/*--------------------------------------------+
 | (C)1990 TommySoftware Thomas Maier, Berlin |
 |  Version 3.00  Letzte nderung 21.11.1990  |
 +--------------------------------------------*/

/* Dieses Programm erzeugt die Informationsdatei 'MEGA_01.MOD'. Diese enthlt  
   alle Informationen, die MegaPaint bentigt, um das Modul 'MEGA_01.PRG'      
   aufrufen zu knnen. Bei diesem handelt es sich um ein Beispielmodul, das    
   die Modulstruktur von MegaPaint verdeutlichen soll. Siehe dazu 'MEGA_01.C'.

   Teilweise ist der Code nicht vollstndig ausformuliert. Dieses Programm kann
   also in der vorliegenden Form nicht direkt compiliert werden !!! Es dient
   nur zur Veranschaulichung des Arbeitsablaufes.                               */

/* (s3B&d1DAchtung !!!&d@ 
   Die hier verwendeten Zeichenketten sind keine C-Strings (durch \0 beendet),
   sondern PASCAL-Strings. Diese enthalten im ersten Byte die Stringlnge, danach
   die gltigen Zeichen (siehe z.B. DATENBLOCK.kennung).(s0B                        */

/*------------------------------------------------------------------------------*/

typedef struct {
  char        kennung[8];             // $07 4d 4f 44 20 33 2e 30 = 'MOD 3.0'
  long        memory;                 // Fr das Modul bentigter Speicher
  char        name[32];               // Namenseintrag im Men
  short       anz;                    // Anzahl bentigter Dateinamen
  char        files[8][8];            // Endungen fr die Dateinamen
  short       types[8];               // Typen fr die Dateinamen
  char        texts[8][128];          // berschriften fr GET_FILENAME
  short       num;                    // $0000 = Reserviert
} MOD_FORMAT;

/*------------------------------------------------------------------------------*/

MOD_FORMAT      feld;
FILE            *disk;

/*------------------------------------------------------------------------------*/

void pascal_strcpy( char *dest, char *src )
{
  register char dummy;

  *dest++ = (char) strlen( src );               /* Erstes Byte = Stringlnge    */
  while( dummy = *src++ ) {
    *dest++ = dummy;                            /* Die NULL am Ende darf nicht  */
  }                                             /* mitkopiert werden !!!        */
}

/*------------------------------------------------------------------------------*/

void main( void ) 
{
  pascal_strcpy( feld.kennung, "MOD 3.0" );     /* $07 4d 4f 44 20 33 2e 30     */

  feld.memory = 20000;                          /* Bentigter Speicherplatz fr */
                                                /* Programmcode, Stack und Heap */
                                                /* in Bytes                     */

  pascal_strcpy( feld.name, "Vektorisierung" ); /* Eintrag, der im Untermen zu */
                                                /* EXTERNES MODUL auftauchen    */
                                                /* soll, maximal 31 Zeichen     */

  feld.anz = 3;                                 /* Es sollen vor dem Aufruf drei*/ 
                                                /* Dateinamen eingelesen werden */

  feld.types[0] = 2;                    /* Bilddatei *.BLD oder *.BL1           */
  pascal_strcpy( feld.files[0], "" );   /* Wird automatisch auf *.BL? gesetzt   */
  pascal_strcpy( feld.texts[0], "Vektorisierung, Rasterbild whlen" );
                                        /* berschrift in der Dateiauswahlbox,  */
                                        /* maximal 63 Zeichen                   */   

  feld.types[1] = 1;                    /* Angegebene Endung vorgeschrieben     */
  pascal_strcpy( feld.files[1], ".VEK" );       /* Gewnschte Endung angeben    */
  pascal_strcpy( feld.texts[1], "Vektorisierung, Vektordatei whlen" );
                                        /* berschrift in der Dateiauswahlbox,  */
                                        /* maximal 63 Zeichen                   */

  feld.types[2] = 0;                    /* Beliebige Endung                     */
  pascal_strcpy( feld.files[2], "" );   /* Wird automatisch auf *.* gesetzt     */
  pascal_strcpy( feld.texts[2], "Vektorisierung, Protokolldatei" );
                                        /* berschrift in der Dateiauswahlbox,  */
                                        /* maximal 63 Zeichen                   */

  feld.dummy = 0;                       /* Dummy, am besten auf 0 setzen        */

  if( disk = fopen( "MEGA_01.MOD", "wb" ) ) {
    fwrite( feld, 1, sizeof( MOD_FORMAT ), disk );
  }
  else {
    /* ERROR !!! */
  }
}

/*------------------------------------------------------------------------------*/

