/*--------------------------------------------+
 | (C)1990 TommySoftware Thomas Maier, Berlin |
 |  Version 3.00  Letzte nderung 21.11.1990  |
 +--------------------------------------------*/

/* Dieses Programm ist das Beispielmodul 'MEGA_01.PRG', das von MegaPaint
   aus aufgerufen werden kann. Hiermit soll das Modulkonzept von MegaPaint
   verdeutlicht werden. Damit MegaPaint das Programm aufrufen kann, mu die
   Informationsdatei 'MEGA_01.MOD' vorhanden sein. Siehe dazu 'MAKE_MOD.C'.   

   Teilweise ist der Code nicht vollstndig ausformuliert. Dieses Programm kann
   also in der vorliegenden Form nicht direkt compiliert werden !!! Es dient
   nur zur Veranschaulichung des Arbeitsablaufes.                               */

/* (s3B&d1DAchtung !!!&d@ 
   Die hier verwendeten Zeichenketten sind keine C-Strings (durch \0 beendet),
   sondern PASCAL-Strings. Diese enthalten im ersten Byte die Stringlnge, danach
   die gltigen Zeichen (siehe z.B. DATENBLOCK.kennung).(s0B                        */

/*------------------------------------------------------------------------------*/

typedef struct {
  short         window_x1,      // Obere linke Ecke des Arbeitsfensters
                window_y1,
                window_x2,      // Untere rechte Ecke des Arbeitsfensters
                window_y2,          
                window_xb,      // Breite des Fensters in Bytes
                window_xl,      // Breite des Fensters in Langworten
                window_xs,      // Breite des Fensters in Pixeln
                window_ys,      // Hhe des Fensters in Pixeln
                        
                scr_dx,         // Bildschirmbreite in Pixeln
                scr_dy,         // Bildschirmhhe in Pixeln
                scr_byte;       // Bildschirmbreite in Bytes
                      
  void          *line_a;        // Zeiger auf LINE A Parameterblock
} BLOCK1;

typedef struct {
  void          *sv,            // Zeiger auf ersten 32K-Puffer
                *sv2,           // Zeiger auf zweiten 32K-Puffer
                *scr,           // Zeiger auf Bildschirm (LOGBASE)
                *scr2,          // Zeiger auf obere linke Ecke des Arbeitsfensters
                *scr3,          // Zeiger auf Minilupe
                *zp,            // Zeiger auf Zeichensatzdaten

                *pp,            // Zeiger auf aktuelles Bild
                (*pics)[4],     // Zeiger auf maximal vier Bilder
                *bp,            // Zeiger auf den Puffer

                *vekanf,        // Zeiger auf Vektordatenfeld
                *vekakt,        // Zeiger aktuelles Vektordatenende
                *vekend,        // Zeiger absolutes Vektordatenende
        
                (*zchs)[8],     // Zeiger auf maximal acht Zeichenstze
                *zchakt,        // Zeiger aktuelles Zeichensatzende
                *zchend,        // Zeiger absolutes Zeichensatzende

                (*syms)[8],     // Zeiger auf maximal acht Symboltabellen
                *symakt,        // Zeiger aktuelles Rastersymbolende
                *symend,        // Zeiger absolutes Rastersymbolende

                (*v_syms)[8],   // Zeiger auf maximal acht Symboltabellen
                *v_symakt,      // Zeiger aktuelles Vektorsymbolende
                *v_symend,      // Zeiger absolutes Vektorsymbolende
} BLOCK2;

typedef struct {
  long          total8;         // Bentigter Speicher fr ein Bild

  long          len8,           // Bildgre  in Bytes
                len32;          // Bildgre  in Langworten
  short         xmax,           // Bildbreite in Pixeln-1
                xsize,          // Bildbreite in Pixeln
                xsize8,         // Bildbreite in Bytes-1
                xsize16,        // Bildbreite in Worten-1
                xsize32,        // Bildbreite in Langworten-1
                xbyte,          // Bildbreite in Bytes
                xbyte2,         // Bildbreite in Bytes*2
                xword           // Bildbreite in Worten
                xlong           // Bildbreite in Langworten
                ymax            // Bildhhe   in Pixeln-1
                ysize;          // Bildhhe   in Pixeln

  long          blen32;         // Puffergre in Langworten
  short         blkmax,         // Pufferhhe  in Pixeln-1
                blklen;         // Pufferhhe  in Pixeln
} BLOCK3;

typedef char    NAME[128];      // Ein Dateiname mit maximal 128 Zeichen

typedef struct {
  char          kennung[8];     // $07 50 52 47 20 33 2e 30 = 'PRG 3.0'
  void          *maus1,         // Startadresse des Mausdatenblockes 1
                *maus2,         // Startadresse des Mausdatenblockes 2
                *maus3;         // Startadresse des Mausdatenblockes 3
  BLOCK1        *block1;        // Startadresse des Konstantenblockes 1 
  BLOCK2        *block2;        // Startadresse des Konstantenblockes 2 
  BLOCK3        *block3;        // Startadresse des Konstantenblockes 3 
  void          *pat;           // Adresse der Fll- und Linienmuster  
  NAME          (*names)[8];    // Adresse der bergebenen Dateinamen   
} DATENBLOCK;

/*------------------------------------------------------------------------------*/

void main( int argc, char *argv[] )
{
  DATENBLOCK    *block;                 /* Zeiger auf den Parameterblock        */
  long          dummy;                  /* Puffer fr Umsetzung der Commandline */
  int           count;                  /* Zhler fr die Ausgabe der Dateinamen*/

  puts( "\nModul geladen...\n" );

  if( argv[1][0] != 'M' || argv[1][1] != 'P' ) {
    puts( "\nFehler in der Kommandozeile...\n" );
    exit( ERROR );
  }

  sscanf( argv[2], "%o", &dummy );      /* Oktalzahl einlesen                   */
  block = (DATENBLOCK *) dummy;         /* Umwandeln in einen DATENBLOCK-Zeiger */

  if( block->kennung != "PRG 3.0" ) {   /* So natrlich nicht korrekt, aber der */
                                        /* Sinn drfte klar sein...             */
    puts( "\nFehler in der Kommandozeile...\n" );
    exit( ERROR );
  }

  printf( "  Kennung: %s\n", block->kennung );
  printf( "Adresse 1: %ld\n", (long) block->maus1 );
  printf( "Adresse 2: %ld\n", (long) block->maus2 );
  printf( "Adresse 3: %ld\n", (long) block->maus3 );
  printf( "Adresse 4: %ld\n", (long) block->block1 );
  printf( "Adresse 5: %ld\n", (long) block->block2 );
  printf( "Adresse 6: %ld\n", (long) block->block3 );

  for( count = 0; count < 3; count++ ) {        /* Drei Namen waren gefordert...*/
    printf( "  Datei %i: %s\n", count, block->names[count] );
  }

  scanf( "%*c" );
}
