;	FIRDEMO.ASM
; Filter test
; Empfngt die Filterkoeffizienten via Hostinterface(Dsp_InStream(...)):
;	Der Dsp pollt zunchst das HSR bis das Kommando RCV_COEFF anliegt
; (Dsp_BlkUnpacked(...) danach wird die Anzahl der Filterkoeffizienten 
; geholt und dann werden die Koeffizienten in einer Hostinterruptroutine
; in das Ram geladen 

; I/O Addressen:
PBC				EQU		$FFE0						; Port B(HOST) Bus Control Register
PCC				EQU		$FFE1						; Port C Bus Control Register
PCDDR			EQU		$FFE3						; Port C Data Direction Register
HCR				EQU		$FFE8						; Host Control Register
HSR				EQU		$FFE9						; Host Status Register
HTX				EQU		$FFEB						; Host Transmit Data Register
HRX				EQU		$FFEB						; Host Receive Data Register
TSR				EQU		$FFEE						; Don't care scip Register
CRA				EQU		$FFEC						; SSI Control Register A
CRB				EQU		$FFED						; SSI Control Register B
SSR				EQU		$FFEE						; SSI Status Register
RX 				EQU		$FFEF						; Serial Receive Data Register
TX 				EQU		$FFEF						; Serial Transmit Data Register
BCR				EQU		$FFFE						; Port A Bus Control Register
IPR				EQU		$FFFF						; Interupt Priority Register

; Konstanten: 
CRA_BITS	EQU		$4100						; Initialisierungswert fr CRA
CRB_BITS	EQU		$F800						; Initialisierungswert fr CRB
RDF				EQU		$0007						; Receive Data Register Full
TDE				EQU		$0006						; Transmit Data Empty
TFS				EQU		$0002						; Transmit Sync Flag
RFS				EQU		$0003						; Receive Sync Flag
RCV_COEFF	EQU				0

dflt_coeff EQU		.7				; Anfangskoeffizient (Allpass)
dflt_n		EQU			3

	org x:$0
statesr		dsm		$80
statesl		dsm		$80

smpl_recvd dc		0
smpl_l		ds		1
smpl_r		ds		1
temp			ds		1
temp1 		ds		1
inflag		dc		1
outflag 	dc		1

	org	y:$0															
coeff			dsm		$80											; max 128 coeff.

	org	p:$0
						jmp				start
	
	org	p:$0c
						jsr				datain						; SSI Receive interrupt
						
	org	p:$0e
						movep			x:<<SSR,a					; SSI Receive
						jsr				datain						; interrupt with exeption					
					
	org p:$10
						jsr				dataout						; SSI Transmit interrupt
						
	org p:$12
						movep			x:<<SSR,a					; SSI Transmit
						jsr				dataout						; interrupt	with exeption				
						
	org p:$20															; Host Receive exeption		
						movep			x:<<HRX,y:(r6)+
									
	org	P:$200
start 			movep			#1,X:PBC					; Port B = Host Port
						movep			#>CRA_BITS,x:<<CRA
						btst			#4,x:<<SSR
						movep			#>CRB_BITS,x:<<CRB
						movep			#>$1f8,x:<<PCC		; Port C = SSI
						movep			#>$1800,x:<<IPR		; Set Host=2/SSI=1 IPL
						move			#dflt_coeff,x0		; Default = 1 Koeffizient
						move			x0,y:coeff		
						move			#>dflt_n,b				; Default Anzahl Koeffizienten
						jsr				fir_init					; Filter initialisieren
						movep			x:<<HRX,x0				;	Receive Register leeren
						movep			#>0,x:<<HCR				; turnoff xmt and rcv interrupts	
						move			#0,sr							; Ipl,loopcount u.s.w. = 0
						movec			#<0,sp
main:    		jclr			#0,x:<<HSR,main 	; Warte auf Hostcommand
						movep			x:<<HRX,b 				; Commando holen
						move			#RCV_COEFF,x1							
						cmp				x1,b
						jne				main							; again...
						
						clr				b									; 0 = Koeffizienten empfangen
						jclr			#0,x:<<HSR,*			; auf nchstes Wort warten...							
						movep			x:<<HRX,b1				; Anzahl der Koeffizienten holen
						move			#>1,x1						
						sub				x1,b						
						move			b,m6							; Modulo (Anzahl-1) oder einfach -1?						
						move			#coeff,r6					; Startadr. der Koeffizienten
						movep			#$1,x:<<HCR				; Enable Host RCV Interrupts
wait_rcv:		move			r6,x1							; Warten...
						cmp				x1,b  						; ... bis alle Koeffizienten geholt
						jne				wait_rcv					; wurden		
						movep			#$0,x:<<HCR				; Disable Host RCV Interrupts
						move			#>1,x1						;
						sub 			x1,b							; Modulo fr FIR Filter(n-1)
						jsr				fir_init
						jmp				main

fir_init:		move			#statesr,r0				; FIR Filter initialisierungs-
						move			#statesl,r1				; routine
						move			#coeff,r4					; bergabe der Anzahl der Filter-
						move			#coeff,r5					; koeffizienten in b
						move			b,n0							; Fr 'REP n0' in Filteralgorith. 
						move			b,m0
						move			n0,m4
						move			m0,m5
						move			m0,m1
						rts					
												
datain:			move			x0,x:temp					; SSI RCV interrupt routine
						move			y0,x:temp1
						move			x:inflag,x0
						jclr			#0,x0,do_leftin
do_rightin  movep			x:<<RX,x0
						bclr			#0,x:inflag				; FIR Filter vielleicht doch nicht
						clr     	a    x0,x:(r0)+  y:(r4)+,y0   ; im Interrupt ??  
        		rep     	n0
        		mac     	x0,y0,a  x:(r0)+,x0  y:(r4)+,y0
        		macr    	x0,y0,a  (r0)-
						move			a,x:smpl_r
						move			x:temp1,y0
						move			x:temp,x0
						rti	
do_leftin:	movep			x:<<RX,x0
						bset			#0,x:inflag				; FIR Filter vielleicht doch nicht
						clr     	a    x0,x:(r1)+  y:(r4)+,y0   ; im Interrupt ??  
        		rep     	n0
        		mac     	x0,y0,a  x:(r1)+,x0  y:(r4)+,y0
        		macr    	x0,y0,a  (r1)-
        		move			a,x:smpl_l
						move			x:>temp1,y0
						move			x:>temp,x0
						rti	
dataout:		move			x0,x:temp					; SSI XMT interrupt routine
						move			x:outflag,x0					
						jclr			#0,x0,do_leftout
do_rightout: move			x:smpl_r,x0
						movep			x0,x:<<TX
						bclr			#0,x:outflag
						move			x:temp,x0
						rti	
do_leftout:	move			x:smpl_l,x0
						movep			x0,x:<<TX
						bset			#0,x:outflag
						move			x:temp,x0
						rti				
			end start
