/*
	"midnight", wenn's dunkel wird...

	Header-File fr eigene Modulentwicklungen.
	Fragen ? Dann lesen Sie am besten erst 'mal hier die Kommentare,
	dann wieder das Handbuch, sehen sich dann eins der Beispielmodule
	an und dann sind WIR immernoch da...

	Hartwig zur Nieden fidonet:(2:241/3420.17), Mario Adam @ S3
		Clausthal-Zellerfeld/Gttingen  15.11.1992

	Ach ja, viel Spa beim programmieren :-)
*/






#ifndef __MIDNIGHT
#define __MIDNIGHT


/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/* Funktionsnummern fr Mod_main			*/
#define M_INIT   0		/* Initialisierungen (v_opnvwk(!),Malloc etc.)	*/
#define M_SWITCH 1		/* Umblenden auf gewnschten Hintergrund		*/
#define M_DO_IT  2		/* Hier geht's richtig los						*/
#define M_EXIT   3		/* Rckgngig machen, was in M_INIT war			*/


/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/* Typenbezeichnungen fr die Einstellungen	*/
#define T_END	0x8000	/* Flag, das im letzten Value gesetzt sein mu	*/
#define T_MINE		0	/* Dieser Werte steht unter eigener Kontrolle	*/
#define T_EDIT		1	/* Editfeld zu Eingabe von Zahlen				*/
#define T_BUTTON	2	/* Cross-Button (Ein/Aus)						*/
#define T_POPUP		3	/* Liste als Popup anzeigen (explizite Werte)	*/
#define T_SLIDER	4	/* Schieberegler darstellen ('ungenaue' Werte)	*/
#define T_FORM		5	/* Eigen-Dialog zeigen							*/
#define T_TITEL		6	/* Eine Titelzeile in der Box malen.			*/

/*
	Dieser Struct gibt Zusatzinformationen zu den 8 im Modul-Header
	gesicherten Informationen an. Im Programm steht eine Liste von 8
	solchen Werten. Ist der Pointer auf diese Liste == NULL, ist das
	Modul nicht konfigurierbar.
*/

typedef struct value
	{	UWORD	Art;	/* Art der Einstellmglichkeit			*/
		long	Min;	/* Erlaubter Minimalwert oder Pointer	*/
		long	Max;	/* Erlaubter Maximalwert oder Pointer	*/
		char	*Name;	/* Pointer auf Erklrungsstring			*/
	} Value;		/* Die Einstellungen.	*/


/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*
	Flagbelegung, anhand der entschieden wird, ob das Modul auf dem
	aktuellen Rechner lauffhig ist. Fr weitere Infos mu vom Modul
	auf die Cookies zurckgegriffen werden.
	Das Modul gibt hier an, auf welcher Hardware es laufen WRDE,
	das ACC vergleicht dann mit der tatschlich vorhandenen Hardware
	Ein guter Wert wre hier 0x003f, dieses Modul lft BERALL.
	Bits 0-5 = 1 bedeuten: mit diesen Planes laufe ich,
	Bits >5  = 1 bedeuten: diese Hardware MU ich haben.
	ber die Union ist es etwas einfacher, die vielen Bits zu setzen:
	Hw_flags.b= 0x003f;
*/

typedef	union hw_fl							/* Harsware-Flags:		*/
	{	struct	{	Pl_1  : 1;	Pl_2  : 1;	/* Mgliche Planes		*/
					Pl_4  : 1;	Pl_8  : 1;
					Pl_HC : 1;	Pl_TC : 1;	/* HC=High-,TC=TrueCol	*/
					Fl_020 : 1;				/* 1= CPU >= 68020		*/
					Fl_FPU : 1;				/* 1= FPU				*/
					Fl_DSP : 1;				/* 1= DSP (???)			*/
					resvd : 7;			/* fr spter reserviert	*/
				} B;
		 int	b;			/* Jetzt nochmal als handlicheres int	*/
	} HW_Fl;



/*------------------------------------------------------------------*/
/* WICHTIG ! So mu ein Modul nach dem GEMDOS-Header aussehen !!	*/

typedef struct mod_str		/* Diese Struktur steht am Modulanfang	*/
	{	int		branch;		/* Branch an den Code=Einsprungadresse	*/
							/* &MOD_struct ist also= MOD_main		*/
		char	magic[8];	/* Hier sollte "mid_MOD\0" stehen		*/

		long	Werte[8];	/* Werte, die gendert werden knnen	*/
		HW_Fl	U;	/* Diese Union wird von M_INIT beim allerersten	*/
					/* Laden gesetzt und immer mitgespeichert.		*/

		Value	**V;			/* Beschreibung der Einstellarten.	*/
			/* V zeigt auf einen Pointer auf eine Liste von 8		*/
			/* 'Value's, die im Modul existieren MUSS als "Value_s"	*/
			/* Ist V==NULL, so ist nichts einstellbar im Modul.		*/
		char	*MyName;/* Zeiger auf Command-Line mit Modulnamen	*/
	} MOD_str;



/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*
	Struktur fr den Sampleabspieler. Ist DMA-Sound vorhanden, wird
	bei 6258,12517,25033 und 50066 kHz als Frequenz ber DMA gespielt
	Der Sample mu Byteweise vorliegen und wird fr DMA entsprechend
	angepasst.
*/

typedef struct snd_str
	{	UBYTE	*SND_start;		/* Pointer auf Sounddaten.			*/
		volatile UBYTE *SND_pos;/* Aktueller Datenpointer, schreiben*/
		/* ist verboten. Lesend geht SND_pos auf 0, wenn der Sample	*/
		/* fertig abgespielt ist. Ansonsten ist SND_pos != 0.		*/
		UBYTE	*SND_end;		/* Erstes Byte nach den Sounddaten	*/
					/* Diese Daten geben die 'signed' Amplituden an	*/
		int		SND_Hz;			/* Abspielgeschwindigkeit in Hz		*/
		UWORD	SND_repeat;		/* # Wiederholungen (0 keine)		*/
			/* Das Oberste Bit wird als Flag fr die DMA-Konver-	*/
			/* tierung bentigt, darum Zhler nur von 0-32767.		*/
			/* Bit 15=1: -128 minimale, 127 maximale Amplitude(DMA),*/
			/* Bit 15=0:    0 minimale, 255 maximale Amplitude(PCM).*/
	} SND_str;


/*------------------------------------------------------------------*/
/* Dieser Struct wird an das Modul bei dessen Aufruf bergeben.		*/

typedef struct acc_str
	{	int		x,y,w,h;	/* Pos und Gre des erlaubten Bereichs	*/
		HW_Fl	U;			/* Vorhandene Hardware-Chips und Grafik	*/
		int		work_in[11],	/* work_in ist auf 1 initialisiert,	*/
				work_out[57];	/* darf aber verndert werden.		*/
		int		handle;			/* VDI-Handle des 'reellen' Treibers*/
		int		planes;						/* Anzahl Planes		*/

		int		(*EVNT_ask)(long);			/* Abfragfunktion		*/
		long	(*rnd24)(long);				/* Random-Berechner		*/
		int		(*Sound)( SND_str * );		/* Soundfunktion.		*/
		int		(*ScreenSave)(int,char*);	/* Sc.S.-Fkt.			*/
			/* Die letzten 4 Pointer KNNEN so aufgerufen werden,	*/
			/* sind aber in MOSTART.S nochmal als normale Funktionen*/
			/* , um SOWAS zu vermeiden: (*As->Sound)( &sound );		*/
	} ACC_str;


/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*
	Die folgenden Funktionen finden sich im Startup-Code MOSTART.S
	und wrden normalerweise mit (*MOD_struct.EVNT_ask)( 0 )
	aufgerufen. Diese Funktionen sollen also nur eine Erleichterung
	sein, denn in MOSTART.S werden genau so wie beschrieben aufgerufen.
*/

int		EVNT_ask( long wait_ms );
long		rnd24( long wert );
int		Sound( SND_str *SND_struct );
int		ScreenSave( int flag, char *Name );


/*
	Die Modul-Struktur ist in MOSTART.S definiert. Da aber ein
	Abfragen der Werte mit MOD_struct.Werte[0] etwas lang wird, knnen
	Sie sich mit #define das Krzel Ms erschaffen, welches die
	Schreibarbeit etwas verringert...


extern MOD_str MOD_struct;
*/

#endif
