;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Jaguar Example Source Code
; Jaguar Workshop Series #1
; Copyright (c)1994 Atari Corp.
; ALL RIGHTS RESERVED
;
; Program: hv.cof	- Minimum time object list update
;  Module: hv_init.s	- Program entry and initialization
;
; Revision History:
; 6/4/94   - SDS: Created
; 6/8/94   - SDS: Working 'black' screen (no bitmap yet)
; 6/13/94  - SDS: Bitmap working after zeroing the $@$%^@ VMODE variable
;                 Coalesced several .s files into this one
; 7/15/94  - SDS: Changed from RAM bitmap to ROM bitmap
;                 Changed move.w #$1F00,INT1 to move.w #$FFFF,VI
;                 Use UpdateFields instead of copying buffered list

		.include	"jaguar.inc"
		.include	"hv.inc"

; Globals
		.globl		InitMoveVars

		.globl		main_obj_list
		.globl		bra2
		.globl		bm1
		.globl		bm2
		.globl		gpu1
		.globl		stop1
		.globl		bmp_highl1
		.globl		bmp_lowl1
		.globl		bmp_height2
		.globl		bmp_highl2
		.globl		bmp_lowl2
		.globl		scl_lowl2
		.globl		img_adr1
		.globl		img_adr2
		.globl		reflect1
		.globl		count_x1
		.globl		count_y1
		.globl		x_motion1
		.globl		y_motion1
		.globl		x_pos1
		.globl		y_pos1
		.globl		x_min1
		.globl		x_max1
		.globl		y_min1
		.globl		y_max1
		.globl		upd_freqx1
		.globl		upd_freqy1
		.globl		reflect2
		.globl		count_x2
		.globl		count_y2
		.globl		x_motion2
		.globl		y_motion2
		.globl		x_pos2
		.globl		y_pos2
		.globl		x_min2
		.globl		x_max2
		.globl		y_min2
		.globl		y_max2
		.globl		upd_freqx2
		.globl		upd_freqy2
		.globl		bmp_hscl2
		.globl		bmp_vscl2
		.globl		a_hdb
		.globl		a_hde
		.globl		a_vdb
		.globl		a_vde
		.globl		width
		.globl		height
		.globl		image1
		.globl		image2
		.globl		image3
; Externals
		.extern		InitGPU
		.extern		InitLister
		.extern		UpdateList
		.extern		JoyLoop

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; Program Entry Point Follows...

		.text

		move.l	#$00070007,G_END	; big-endian mode
		move.w	#$FFFF,VI					; disable video interrupts

		move.l	#INITSTACK,a7			; Setup a stack
			
		jsr	    InitVideo					; Setup our video registers.
    jsr     InitMoveVars  		; Initialize Object vars
		jsr	    InitLister				; Initialize Object Display List

		jsr     InitGPU   	  		; Load GPU Interrupt Code
						           	  		; and start the gpu code

		jsr	    InitVBint					; Initialize our VBLANK routine

		move.l	d0,OLP						; Value of D0 from InitLister
		move.w	#$6C1,VMODE				; Configure Video

		jsr			JoyLoop						; This will last forever

		illegal										; Bye bye...

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Procedure: InitVBint 
; Install our vertical blank handler and enable interrupts
;

InitVBint:
		move.l	d0,-(sp)

		move.l	#UpdateList,LEVEL0	; Install our Auto-Vector 0 handler

		move.w	a_vde,d0		; Must be ODD
		ori.w	#1,d0
		move.w	d0,VI

		move.w	INT1,d0			; Enable video interrupts
		ori.w	#1,d0
		move.w	d0,INT1

		move.w	sr,d0
		and.w	#$F8FF,d0		; Lower the 68k IPL to allow interrupts
		move.w	d0,sr

		move.l	(sp)+,d0
		rts
		
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Procedure: InitVideo (same as in vidinit.s)
;            Build values for hdb, hde, vdb, and vde and store them.
;
 						
InitVideo:
		movem.l	d0-d6,-(sp)		
			
		move.w	CONFIG,d0		; Also is joystick register
		andi.w	#VIDTYPE,d0		; 0 = PAL, 1 = NTSC
		beq	palvals

		move.w	#NTSC_HMID,d2
		move.w	#NTSC_WIDTH,d0

		move.w	#NTSC_VMID,d6
		move.w	#NTSC_HEIGHT,d4

		bra	calc_vals
palvals:
		move.w	#PAL_HMID,d2
		move.w	#PAL_WIDTH,d0

		move.w	#PAL_VMID,d6
		move.w	#PAL_HEIGHT,d4

calc_vals:
		move.w	d0,width
		move.w	d4,height

		move.w	d0,d1
		asr	#1,d1			; Width/2

		sub.w	d1,d2			; Mid - Width/2
		add.w	#4,d2			; (Mid - Width/2)+4

		sub.w	#1,d1			; Width/2 - 1
		ori.w	#$400,d1		; (Width/2 - 1)|$400
		
		move.w	d1,a_hde
		move.w	d1,HDE

		move.w	d2,a_hdb
		move.w	d2,HDB1
		move.w	d2,HDB2

		move.w	d6,d5
		sub.w	d4,d5
		move.w	d5,a_vdb

		add.w	d4,d6
		move.w	d6,a_vde

		move.w	a_vdb,VDB
		move.w	#$FFFF,VDE
			
		move.l	#0,BORD1		; Black border
		move.w	#0,BG			; Init line buffer to black
			
		movem.l	(sp)+,d0-d6
		rts
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Procedure: InitMoveVars
;            Initialize variables for our moving bitmap
;            Note: x_pos and y_pos are initialized in mov_list.s
;
; Registers: None
;

InitMoveVars:
		move.l  d0,-(sp)

		move.w  #X_MOTION,x_motion1	; Motion for each iteration
		move.w  #Y_MOTION,y_motion1

		clr.w   count_x1		; Current elapsed frames
		clr.w   count_y1		; Current elapsed frames

		move.l   #O_REFLECT,reflect1

		move.w   #100, upd_freqx1
		move.w   #100, upd_freqy1

		move.w   #10, x_min1			; Min X = 10		
		clr.l	d0
		move.w  width,d0		; Max X = Scr Width - Bmap Width
		lsr.w	#2,d0
		sub.w	#BMP_WIDTH,d0
		sub.w   #1,d0
		move.w  d0,x_max1

		move.w  a_vdb,d0		; Min Y = a_vdb
		andi.w  #$FFFE,d0
		move.w  d0,y_min1

		move.w  a_vde,d0		; Max Y = a_vde - lines of bmap
		sub.w	#BMP_LINES,d0
		andi.w  #$FFFE,d0
		sub.w   #2,d0
		move.w  d0,y_max1

    move.w  #100, y_pos1
    move.w  #180, x_pos1

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Init BitMapVars2	
;
		move.w  #X_MOTION,x_motion2	; Motion for each iteration
		move.w  #Y_MOTION,y_motion2

		clr.w   count_x2		; Current elapsed frames
		clr.w   count_y2		; Current elapsed frames

		clr.l   reflect2

		move.w   #150, upd_freqx2
		move.w   #150, upd_freqy2

		move.w   #10, x_min2			; Min X = 10		
		clr.l	d0
		move.w  width,d0		; Max X = Scr Width - Bmap Width
		lsr.w	#2,d0
		sub.w	#BMP_WIDTH,d0
		sub.w   #1,d0
		move.w  d0,x_max2

		move.w  a_vdb,d0		; Min Y = a_vdb
		andi.w  #$FFFE,d0
		move.w  d0,y_min2

		move.w  a_vde,d0		; Max Y = a_vde - lines of bmap
		sub.w	#BMP_LINES,d0
		andi.w  #$FFFE,d0
		sub.w   #2,d0
		move.w  d0,y_max2

    move.w  #100, y_pos2
    move.w  #160, x_pos2
	
		move.l  (sp)+,d0
		rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Uninitialized Data!!!           ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; Storage space for our object lists
;
          .bss
          .phrase

main_obj_list:	ds.l    1*2
bra2:						ds.l    1*2
bm1:						ds.l    2*2
bm2:						ds.l    3*2
gpu1:						ds.l    1*2
stop1:					ds.l    1*2

bmp_highl1:			ds.l		1
bmp_lowl1:			ds.l		1

bmp_highl2:			ds.l		1
bmp_lowl2:			ds.l		1
scl_lowl2:			ds.l		1

reflect1: 		  ds.w		1
count_x1:       ds.w    1
count_y1:       ds.w    1
x_motion1:      ds.w    1
y_motion1:      ds.w    1
x_pos1:         ds.w    1
y_pos1:         ds.w    1
x_min1:         ds.w    1
x_max1:         ds.w    1
y_min1:         ds.w    1
y_max1:         ds.w    1
upd_freqx1:			ds.w    1
upd_freqy1:			ds.w    1
img_adr1:				ds.l    1

          .phrase
reflect2: 		  ds.w		1
count_x2:       ds.w    1
count_y2:       ds.w    1
x_motion2:      ds.w    1
y_motion2:      ds.w    1
x_pos2:         ds.w    1
y_pos2:         ds.w    1
x_min2:         ds.w    1
x_max2:         ds.w    1
y_min2:         ds.w    1
y_max2:         ds.w    1
upd_freqx2:			ds.w    1
upd_freqy2:			ds.w    1
bmp_hscl2:			ds.w    1
bmp_vscl2:			ds.w    1
img_adr2:				ds.l    1

          .phrase
a_hdb:					ds.w	  1
a_hde:					ds.w	  1
a_vdb:					ds.w	  1
a_vde:					ds.w	  1
width:					ds.w	  1
height:   			ds.w	  1

          .phrase
image1:					ds.l		2048
image2:					ds.l		2048
image3:					ds.l		2048

		.end