/********************************************************************
 *
 *                              N.AES
 *                             =======
 *
 * - naesbind.c -
 *
 * Bindings der AES-Erweiterungen von N.AES
 *
 * PureC-Version
 *
 ********************************************************************/

#include <naesbind.h>

/*-------
	       dieser Long   hat folgende Bedeutung:
	_aes(0,0x9f010100UL);
	         9f       = Opcode (159)
	           01     = Anzahl params in intin
	             01   = Anzahl Params in intout
	               00 = Anzahl params in addrin
-------*/

/*==================================================================
 * - appl_yield -
 *
 * AES-call #17
 *==================================================================*/
int appl_yield(void)
{
	_aes(0,0x11000100UL);
	return _GemParBlk.intout[0];
}

/*==================================================================
 * - objc_xfind -
 *
 * AES-call #49
 *==================================================================*/
int objc_xfind(OBJECT *obj, int start, int depth,  int x, int y)
{
	_GemParBlk.addrin[0] = obj;
	_GemParBlk.intin[0]  = start;
	_GemParBlk.intin[1]  = depth;
	_GemParBlk.intin[2]  = x;
	_GemParBlk.intin[3]  = y;
	_aes(0,0x31040101UL);

	return _GemParBlk.intout[0];
}

/*==================================================================
 * - wind_draw -
 *
 * AES-call #99
 *
 * Zeichnen der Non-Client-Area eines Fensters.
 *==================================================================*/
int	wind_draw(int wi_dhandle, int wi_dstartob)
{
	_GemParBlk.intin[0]  = wi_dhandle;
	_GemParBlk.intin[1]  = wi_dstartob;
	_aes(0, 0x63020100UL);
	return _GemParBlk.intout[0];
}

/*==================================================================
 * - shel_help -
 *
 * AES-call #128
 *
 * Hilfe anfordern.
 *==================================================================*/
int shel_help(int sh_hmode, char *sh_hfile, char *sh_hkey)
{
	_GemParBlk.intin[0]  = sh_hmode;
	_GemParBlk.addrin[0] = sh_hfile;
	_GemParBlk.addrin[1] = sh_hkey;
	_aes(0, 0x80010102UL);
	return _GemParBlk.intout[0];
}

/*==================================================================
 * - appl_control -
 *
 * AES-call #129
 *
 * Steuern von Applikationen.
 *==================================================================*/
int appl_control(int ap_cid, int ap_cwhat, void *ap_cout)
{
	_GemParBlk.intin[0]  = ap_cid;
	_GemParBlk.intin[1]  = ap_cwhat;
	_GemParBlk.addrin[0] = ap_cout;
	_aes(0, 0x81020101UL);
	return _GemParBlk.intout[0];
}

