/*
	Beispielapplikation	fr ACS

	"Directory"

	28.9.91			Stefan Bachert

*/

#include	<tos.h>
#include	<string.h>
#include	<acs.h>
#include	<dir.h>	

static Awindow *file_make (void *not_used);
static void new_drive (void);
static void new_dir (void);
static void ret_dir (void);
static void make_work (Awindow *window);

#include	<dir.ah>

#define	WIDTH	(80)
#define	HEIGHT	(48)

typedef struct {
	unsigned long drives;
	char act_drive;
	char path [128];
} USER;


static OBJECT  back  = {-1, -1, -1, G_BOX, NONE, AOS_FIXED, 0x00001101L, 0, 0, 100, 100};
static AOBJECT back0 = { A_dummy, A_dummy, AEO, 0, NULL, NULL, 0, 0};

static OBJECT  drv   = {-1, -1, -1, G_ICON, EXIT | SELECTABLE, NORMAL, (long) &FLOPPY, 0, 0, WIDTH >> 1, HEIGHT};
static AOBJECT drv0  = {new_drive, A_dummy, AEO, 0, NULL, NULL, 0, 0};

static OBJECT  ret   = {-1, -1, -1, G_ICON, EXIT | SELECTABLE, NORMAL, (long) &DOTDOT, 0, 0, WIDTH, HEIGHT};
static AOBJECT ret0  = {ret_dir, A_dummy, AEO, 0, NULL, NULL, 0, 0};

static OBJECT  dirs  = {-1, -1, -1, G_ICON, EXIT | SELECTABLE, NORMAL, (long) &DIRECTORY, 0, 0, WIDTH, HEIGHT};
static AOBJECT dirs0 = {new_dir, A_dummy, AEO, 0, NULL, NULL, 0, 0};

static OBJECT  files = {-1, -1, -1, G_ICON, NONE, NORMAL, (long) &FILE, 0, 0, WIDTH, HEIGHT};
static AOBJECT files0= { A_dummy, A_dummy, AEO, 0, NULL, NULL, 0, 0};


static void new_drive (void)
	/*
	 *	Dir 
	 */
{
  Awindow *window;
  USER *user;
  
  window = ev_window;
  user = window-> user;

  user-> act_drive = (char) ev_object [ev_obnr]. ob_spec. iconblk-> ib_char - 'A';
  Dsetdrv (user-> act_drive);
  Dsetpath ("\\");

  make_work (window);
  (window-> sized) (window, &window-> wi_act);
}


static void new_dir (void)
	/*
	 *	Dir 
	 */
{
  Awindow *window;
  USER *user;

  window = ev_window;
  user = window-> user;
  Dsetdrv (user-> act_drive);
  Dsetpath (user-> path);
  Dsetpath (window-> work [ev_obnr]. ob_spec. iconblk-> ib_ptext);
  
  make_work (window);
  (window-> sized) (window, &window-> wi_act);
}


static void ret_dir (void)
	/*
	 *	Dir 
	 */
{
  Awindow *window;
  USER *user;

  window = ev_window;
  user = window-> user;
  Dsetdrv (user-> act_drive);
  Dsetpath (user-> path);
  Dsetpath ("..");
  
  make_work (window);
  (window-> sized) (window, &window-> wi_act);
}


static void make_work (Awindow *window)
	/*
	 *	Baue das innere Workobjekt zusammen
	 */
{
  USER *user;
  DTA dta, *olddta;
  OBJECT *work;
  ICONBLK *iconblk;
  char path [128];
  int i, n;
  long drives;
  char drive;
  int state;
  int first;
  
  user = window-> user;

  olddta = Fgetdta ();
  Fsetdta (&dta);			/* auf eigene Dta operieren ! wegen ACCESSORYS ! */
  first = TRUE;
redo:
  strcpy (path, "A:"); *path += user-> act_drive;
  Dgetpath (user-> path, 0); strcpy (path + 2, user-> path);
  Ast_delete (window-> info);
  window-> info = Ast_create (path);
  strcat (path, "\\*.*");

  n = 0;
  state = Fsfirst (path, FA_SUBDIR | FA_READONLY | FA_SYSTEM | FA_HIDDEN | FA_SYSTEM | FA_ARCHIVE);
  while (state >= 0) {					/* was gefunden */
	n ++;
	state = Fsnext ();
  };
  if (state == -33 && first) {		/* bei diskette mit anderen Pfad probieren */
	Dsetpath ("\\");
	first = FALSE;
	goto redo;
  };
  if (window-> wi_id > 0) wind_set (window-> wi_id, WF_INFO, window-> info);

  work = Ax_malloc (((n + 17) << 1) * sizeof (AOBJECT));	/* Grsse des Objectes */
  if (work == NULL) return;				/* Fehler */

  if (window-> work != NULL) Aob_delete (window-> work);
  window-> work = work;

  memcpy (work, &back, sizeof (OBJECT) << 1);	/* Hintergrund */
  work-> ob_head = 2;

  work += 2;
  i = 4;

/*	Drives aufbauen */

  drive = 'A';
  drives = user-> drives;
  n = 0;
  while (drives) {
	if (drives & 1) {
	  memcpy (work, &drv, sizeof (OBJECT) << 1);
	  iconblk = Aic_create (drv. ob_spec. iconblk);
	  (char) iconblk-> ib_char = drive;
	  work-> ob_spec. iconblk = iconblk;
	  work-> ob_next = i;
	  i += 2;
	  work += 2;
	  n ++;
	};
	drives >>= 1;
	drive ++;
  };

  if (n & 1) {		/* ungerade, letzter doppelt so gross */
	(work - 2)-> ob_width <<= 1;
  };
  
/*	Dirs	*/

  state = Fsfirst (path, FA_SUBDIR);			/* nur dirs */
  dirs. ob_spec. iconblk-> ib_ptext = dta. d_fname;	/*wird dann bei create erzeugt */
  while (state >= 0) {					/* was gefunden */
	if (strcmp (dta. d_fname, ".") != 0 && dta. d_attrib & FA_SUBDIR) {
	  if (strcmp (dta. d_fname, "..") == 0) {
		memcpy (work, &ret, sizeof (OBJECT) << 1);	/* return Wert */
	  } else {
		memcpy (work, &dirs, sizeof (OBJECT) << 1);	/* normales Dir */
	  };
	  work-> ob_spec. iconblk = Aic_create (work-> ob_spec. iconblk);
	  work-> ob_next = i;
	  i += 2;
	  work += 2;
	};
	state = Fsnext ();
  };

/*	Files	*/

  state = Fsfirst (path, 0x27);			/* keine dirs */
  files. ob_spec. iconblk-> ib_ptext = dta. d_fname;	/*wird dann bei create erzeugt */
  while (state >= 0) {					/* was gefunden */
	memcpy (work, &files, sizeof (OBJECT) << 1);
	work-> ob_spec. iconblk = Aic_create (files. ob_spec. iconblk);
	work-> ob_next = i;
	i += 2;
	work += 2;
	state = Fsnext ();
  };

/*	Aufrumen */

  (work - 2)-> ob_next = 0;
  (work - 1)-> ob_flags |= LASTOB;
  
  window-> work-> ob_tail = i - 4;

  Fsetdta (olddta);
}


static Awindow *file_make (void *not_used)
	/*
	 *	Erzeuge Directory Fenster
	 */
{
  Awindow *wi;
  USER *user;

  wi = Awi_create (&DIR_WI);
  if (wi == NULL) return NULL;

  user = Ax_malloc (sizeof (USER));
  if (user == NULL) return NULL;

  wi-> user = user;
  user-> act_drive = Dgetdrv ();				/* welche drive gibt es */
  user-> drives = Dsetdrv (user-> act_drive);	/* welches ist das aktuelle */
  user-> path [0] = '\0';

  make_work (wi);					/* erzeuge das Work object */

  (wi-> open) (wi);					/* ffne gleich, auch als accessory */
  return wi;
}


int ACSinit (void)
	/*
	 *	Doppelklick auf NEU erzeugt ein neues Fenster
	 */
{
  Awindow *window;

  window = Awi_root ();						/* root window */

  if (window == NULL) return FAIL;			/* lege NEU Icon an */
  (window-> service) (window, AS_NEWCALL, &DIR_WI. create);

  window = &DIR_WI;
  (window-> create) (NULL);					/* ein Fenster gleich erzeugen */

  return OK;
}
