/*
    Beispielapplikation fr ACS

    "Userdef"

    2.1.92         Stefan Bachert

*/

#include    <acs.h>
#include    <user.h>

static int cdecl user_obj (PARMBLK *pb);
static void my_sized (Awindow *window, Axywh *xywh);
static void my_fulled (Awindow *window);
static Awindow *make_el (void *not_used);

#include    <user.ah>

static int cdecl user_obj (PARMBLK *pb)
	/*
	 *	Zeichnet eine Ellipse
	 */
{
  int x, y, xrad, yrad;
  int pxy [4];

  pxy [2] = pb-> pb_wc;
  pxy [3] = pb-> pb_hc;
  if (pxy [2] || pxy [3]) {			/* klippe */
	pxy [0] = pb-> pb_xc;
	pxy [1] = pb-> pb_yc;
	pxy [2] += pxy [0] - 1;
	pxy [3] += pxy [1] - 1;
	vs_clip (vdi_handle, TRUE, pxy);
  };

  xrad = (pb-> pb_w >> 1) - 2;		/* Abstand zu Rand */
  yrad = (pb-> pb_h >> 1) - 2;

  x = pb-> pb_x + (pb-> pb_w >> 1);
  y = pb-> pb_y + (pb-> pb_h >> 1);

  vswr_mode		(vdi_handle, MD_REPLACE);
  vsf_interior	(vdi_handle, FIS_PATTERN);
  vsf_style		(vdi_handle, 19);
  vsf_perimeter	(vdi_handle, TRUE);
  vsf_color		(vdi_handle, BLACK);
  v_ellipse		(vdi_handle, x, y, xrad, yrad);

  vs_clip		(vdi_handle, FALSE, pxy);		/* klippen ausschalten */

  return (pb-> pb_currstate);
}

static void my_sized (Awindow *window, Axywh *xywh)
	/*
	 *	Fenster inneres verndern
	 */
{
  OBJECT *work;

  work = window-> work;
  work [0]. ob_width =
  work [USEROBJ]. ob_width = 
		xywh-> w - window-> wi_act. w + window-> wi_work. w;
				/* ^^^^^^^^^^  Fenster attribute ^^^^^^^^^
								abziehen (sizer, titlebar)
				*/

  work [0]. ob_height =
  work [USEROBJ]. ob_height =
		xywh-> h - window-> wi_act. h + window-> wi_work. h;

  window-> state |= AWS_FORCEREDRAW; /* immer neu zeichnen */
  Awi_sized (window, xywh);
}


static void my_fulled (Awindow *window)
	/*
	 *	Fenster inneres verndern
	 */
{
  OBJECT *work;

  work = window-> work;

  if (window-> state & AWS_FULL) {	/* ist schon voll */
	work [0]. ob_width =
	work [USEROBJ]. ob_width =
		window-> wi_normal. w - window-> wi_act. w + window-> wi_work. w;;

	work [0]. ob_height =
	work [USEROBJ]. ob_height =
		window-> wi_normal. h - window-> wi_act. h + window-> wi_work. h;
  } else {
	work [0]. ob_width  =
	work [USEROBJ]. ob_width  = desk. w - 30;

	work [0]. ob_height =
	work [USEROBJ]. ob_height = desk. h - 40;
  };

  window-> state |= AWS_FORCEREDRAW; /* immer neu zeichnen */
  Awi_fulled (window);
}

static Awindow *make_el (void *not_used)
    /*
     *  Erzeuge Fenster
     */
{
  Awindow *wi;

  wi = Awi_create (&WINDOW);
  if (wi == NULL) return NULL;
  (wi-> open) (wi);
  return wi;
}


int ACSinit (void)
    /*
     *  Doppelklick auf NEU erzeugt ein neues Fenster
     */
{
  Awindow *window;

  window = Awi_root ();                 /* root window */

  if (window == NULL) return FAIL;      /* lege NEU Icon an */
  (window-> service) (window, AS_NEWCALL, &WINDOW. create);

  window = &WINDOW;
  (window-> create) (NULL);             /* sofort ein Fenster erzeugen */

  return OK;
}
