/*
	Beispielapplikation	fr ACS

	"Dialogorientiertes Help"

	25.11.92			Stefan Bachert

*/

#include	<acs.h>
extern Awindow DESKTOP;

#include	"diahelp.h"
#include	"diahelp.ah"

/*
 *	User Struktur
 */

typedef struct ob_st {
	struct ob_st* prev;
	OBJECT* tree;
	INT16 w;
	INT16 h;
} OBJ_STACK;


static OBJECT* newtree (void)
		/*
		 *	Ermittelt neuen Dialogbaum
		 */
{
	AOBJECT* aob;
	OBJECT* tree;

	aob = (AOBJECT *) ev_object + ev_obnr + 1;
	tree = aob-> userp1;
	if (tree == NULL) {
		form_alert (1, ERR_NOTREE);
		return NULL;
	}
	return Aob_create (tree);
}


static void settree (OBJECT* tree, INT16 w, INT16 h)
		/*
		 *	Setzt den neuen Baum und
		 *	frischt komplett auf
		 */
{
	Awindow* wi;
	Axywh* wi_act;
	INT16 x, y;

	wi = ev_window;
	Awi_diaend ();										/* Editfelder abschalten */
	wi-> ob_edit = -1;								/* ACS wird ziemlich hart der Dialog entzogen */
	wi-> ob_col = -1;

	wi-> work = tree;
	Aob_fix (tree);										/* in Pixel Koordinaten wandeln */

	wi_act = &wi-> wi_act;
	x = wi_act-> x + (wi_act-> w >> 1);
	y = wi_act-> y + (wi_act-> h >> 1);

	graf_shrinkbox (x, y, 1, 1, wi_act-> x, wi_act-> y, wi_act-> w, wi_act-> h);
  evnt_timer (200, 0);
	if (w > 0 && h > 0) {
		wi_act-> w = w;
		wi_act-> h = h;
	}
	graf_growbox (x, y, 1, 1, wi_act-> x, wi_act-> y, wi_act-> w, wi_act-> h);
	wi-> state |= AWS_FORCEREDRAW;		/* erzwinge Neuzeichnen */
	(wi-> sized) (wi, wi_act);				/* Falls sich Gre gendert hat */

	wi-> ob_edit = Aob_findflag (wi-> work, 0, EDITABLE);
	Awi_diastart ();									/* Editfelder wieder einschalten */
}


static void rts (void)
	/*
	 *	Springt eine Ebene hoch
	 */
{
	Awindow* wi;
	OBJ_STACK* stk;

	wi = ev_window;
	stk = wi-> user;
	if (stk == NULL) return;			/* top erreicht */
	wi-> user = stk-> prev;
	Aob_delete (wi-> work);
	settree (stk-> tree, stk-> w, stk-> h);		/* Setze alten Wert */
	Ax_ifree (stk);
}


static void jsr (void)
	/*
	 *	Springt zum nchsten Dialog
	 *  merkt sich aber den aktuellen
	 *	Der Zeiger steht in aob-> userp1
	 */
{
	Awindow* wi;
	OBJECT* tree;
	OBJ_STACK* stk;

	tree = newtree ();
	if (tree == NULL) return;
	stk = Ax_malloc (sizeof (OBJ_STACK));
	if (stk == NULL) return;
	wi = ev_window;
	/*
			Dieses Object mit dem gedrcktem Button kann nicht
			mehr von ACS unselected werden. Also mu der Benutzer das tun
	*/
	(wi-> obchange) (wi, ev_obnr, ev_object [ev_obnr]. ob_state & ~ SELECTED);
	stk-> tree = wi-> work;
	stk-> w = wi-> wi_act. w;
	stk-> h = wi-> wi_act. h;
	stk-> prev = wi-> user;
	wi-> user = stk;	
	settree (tree, desk. w, desk. h);		/* volle gre */
}


static void jmp (void)
	/*
	 *	Springt zum nchsten Dialog
	 *	Der Zeiger steht in aob-> userp1
	 */
{
	Awindow* wi;
	OBJECT* tree;

	tree = newtree ();
	if (tree == NULL) return;
	wi = ev_window;
	Aob_delete (wi-> work);
	settree (tree, 0, 0);		/* Gre bleibt */
}

static void topwi (Awindow* wi)
	/*
	 *		Springt bis zum obersten Fenster und rumt auf
	 */
{
	OBJ_STACK* stk, *prev;
	Axywh act;

	stk = wi-> user;
  wi-> user = NULL;
	if (stk == NULL) return;
	while (stk != NULL) {
		Aob_delete (wi-> work);
		wi-> work = stk-> tree;
		prev = stk-> prev;
		if (prev == NULL) {
			act. w = stk-> w;
			act. h = stk-> h;
		}
		Ax_ifree (stk);
		stk = prev;
	}
	act. x = wi-> wi_act. x;
	act. y = wi-> wi_act. y;
	wi-> state |= AWS_FORCEREDRAW;		/* erzwinge Neuzeichnen */
	(wi-> sized) (wi, &act);					/* Falls sich Gre gendert hat */
}

static void top (void) { topwi (ev_window); }

static INT16 service_dh (Awindow* wi, INT16 task, void* in_out)
{
	switch (task) {
	case AS_TERM:
		topwi (wi);
		Awi_delete (wi);
#ifdef __ACS_MODULE__
		ACSmoduleterm ();
#endif
		break;
	case AS_INFO:
		A_dialog (&_INFOBOX);
		break;
	default:
		return FALSE;
	}
	return TRUE;
}


static Awindow* make_dh (void* not_used)
	/*
	 *	Erzeuge das Fenster
	 */
{
	Awindow* wi;

	wi = Awi_create (&DIAHELP);
	if (wi == NULL) return NULL;
	wi-> user = NULL;
	return wi;
}

INT16 ACSinit (void)
{
	if (NULL == DIAHELP. create (NULL)) {				/* erzeuge gleich das Fenster */
#ifdef __ACS_MODULE__
		ACSmoduleterm ();
#endif
	  return FAIL;
	}
  return OK;
}