/*
	Beispielapplikation	fr ACS

	"Addressdatenbank"

	27.9.91			Stefan Bachert

*/

#include	<tos.h>
#include	<string.h>
#include	<stdio.h>
#include	<acs.h>
#include	<acsplus.h>
#include	<address.h>

static void ad_save		(void);
static void ad_leave	(void);
static void ad_next		(void);
static void ad_prev		(void);
static void ad_first	(void);
static void ad_last		(void);
static void ad_new		(void);
static void ad_modify	(void);
static void ad_delete	(void);

static Awindow *ad_make	(void *x);
static INT16 ad_service	(Awindow *window, INT16 task, void *in_out);

#include	<address.ah>

/*
 *	User Struktur
 */

#define LENGTH	(35)
#define PLZ		(5)
#define TOWN	(30)
#define PHONE	(13)
#define BIRTHDAY (6)

typedef struct {			/* der Eintrag */
	char firstname	[LENGTH + 1];
	char lastname	[LENGTH + 1];
	char street		[LENGTH + 1];
	char plz		[PLZ + 1];
	char town		[TOWN + 1];
	char phone		[PHONE + 1];
	char birthday	[BIRTHDAY + 1];
	char hobby		[LENGTH + LENGTH + 1];
	char idea		[LENGTH + LENGTH + 1];
	char dont		[LENGTH + LENGTH + 1];
	} RECORD;

typedef struct pts {		/* die Verzeigerung der Eintrge */
	struct pts *next;
	struct pts *prev;
	RECORD *record;
	} LINK;

typedef struct {			/* user struktur */
	INT16 n;
	INT16 act_index;
	LINK *act;				/* aktueller Zeiger */
	LINK *first;
	LINK *last;
	char path [80];			/* dateinamen */
	} AD_DB;


static char path [80];			/* letzter Pfad */

static char *fileselect (void)
	/*
	 *	Hole Filenamen
	 */
{
  char *p;
  INT16 button;
  char file [16];

  p = strrchr (path, '\\');					/* select entfernen */
  *(p + 1) = '\0';
  strcat (path, "*.ADB");					/* ADB suchen */
  file [0] = '\0';

  Aev_unhidepointer ();						/* Zeiger wieder sichtbar */
  if (fsel_input (path, file, &button) == 0 ||
	  button == 0 ||
	  file [0] == '\0') {
	return NULL;
  };

  if (strlen (file) == 9) {					/* 8 + . doch extension anhngen */
	if (*(file + 8) == '.') strcat (file, "ADB");
  };
  if (strchr (file, '.') == NULL) {			/* hnge extension an */
	strcat (file, ".ADB");
  };

  p = strrchr (path, '\\');					/* select entfernen */
  strcpy (p + 1, file);

  return path;
}


static void ad_set (Awindow *window)
	/*
	 *	Setze Werte
	 */
{
  static RECORD proto = {
	"", "", "", "W", "", "0", "", "", "", ""};
  AD_DB *user;
  RECORD *record;
  OBJECT *work;

  user = window-> user;
  work = window-> work;
  if (user-> act == NULL) {
	record = &proto;
  } else {
	record = user-> act-> record;
  };

  sprintf (work [AD_INDEX]. ob_spec. tedinfo-> te_ptext, " %d ", user-> act_index);
  strcpy (work [AD_FIRSTNAME]. ob_spec. tedinfo-> te_ptext, record-> firstname);
  strcpy (work [AD_LASTNAME]. ob_spec. tedinfo-> te_ptext, record-> lastname);
  strcpy (work [AD_STREET]. ob_spec. tedinfo-> te_ptext, record-> street);
  strcpy (work [AD_PLZ]. ob_spec. tedinfo-> te_ptext, record-> plz);
  strcpy (work [AD_TOWN]. ob_spec. tedinfo-> te_ptext, record-> town);
  strcpy (work [AD_PHONE]. ob_spec. tedinfo-> te_ptext, record-> phone);

  strcpy (work [AD_BIRTHDAY]. ob_spec. tedinfo-> te_ptext, record-> birthday);

  strncpy (work [AD_1HOBBY]. ob_spec. tedinfo-> te_ptext, record-> hobby, LENGTH);
  strcpy (work [AD_2HOBBY]. ob_spec. tedinfo-> te_ptext, record-> hobby + LENGTH);

  strncpy (work [AD_1IDEA]. ob_spec. tedinfo-> te_ptext, record-> idea, LENGTH);
  strcpy (work [AD_2IDEA]. ob_spec. tedinfo-> te_ptext, record-> idea + LENGTH);

  strncpy (work [AD_1DONTS]. ob_spec. tedinfo-> te_ptext, record-> dont, LENGTH);
  strcpy (work [AD_2DONTS]. ob_spec. tedinfo-> te_ptext, record-> dont + LENGTH);

  Awi_diaend ();						/* Textcursor entfernen */
  (window-> obchange) (window, 0, window-> work-> ob_state);	/* update */
  Awi_diastart ();
}


static void ad_get (Awindow *window)
	/*
	 *	bernehme Werte
	 */
{
  AD_DB *user;
  RECORD *record;
  OBJECT *work;
  user = window-> user;
  work = window-> work;
  record = user-> act-> record;

  strcpy (record-> firstname, work [AD_FIRSTNAME]. ob_spec. tedinfo-> te_ptext);
  strcpy (record-> lastname, work [AD_LASTNAME]. ob_spec. tedinfo-> te_ptext);
  strcpy (record-> street, work [AD_STREET]. ob_spec. tedinfo-> te_ptext);
  strcpy (record-> plz, work [AD_PLZ]. ob_spec. tedinfo-> te_ptext);
  strcpy (record-> town, work [AD_TOWN]. ob_spec. tedinfo-> te_ptext);
  strcpy (record-> phone, work [AD_PHONE]. ob_spec. tedinfo-> te_ptext);

  strcpy (record-> birthday, work [AD_BIRTHDAY]. ob_spec. tedinfo-> te_ptext);

  strcpy (record-> hobby, work [AD_1HOBBY]. ob_spec. tedinfo-> te_ptext);
  strcpy (record-> hobby + LENGTH, work [AD_2HOBBY]. ob_spec. tedinfo-> te_ptext);

  strcpy (record-> idea, work [AD_1IDEA]. ob_spec. tedinfo-> te_ptext);
  strcpy (record-> idea + LENGTH, work [AD_2IDEA]. ob_spec. tedinfo-> te_ptext);

  strcpy (record-> dont, work [AD_1DONTS]. ob_spec. tedinfo-> te_ptext);
  strcpy (record-> dont + LENGTH, work [AD_2DONTS]. ob_spec. tedinfo-> te_ptext);
}


static void ad_save		(void)
	/*
	 *	Sichern
	 */
{
  AD_DB *user;
  FILE *file;
  LINK *link;

  user = ev_window-> user;

  file = fopen (user-> path + 1, "w+");

  if (file == NULL) return;

  link = user-> first;
  while (link != NULL) {
	if (1 != fwrite (link-> record, sizeof (RECORD), 1, file)) {
	  break;	/* fehler */
	};
	link = link-> next;
  };

  fclose (file);
}


static void ad_next		(void)
	/*
	 *	nchster Eintrag
	 */
{
  AD_DB *user;
  LINK *link;

  user = ev_window-> user;
  link = user-> act;

  if (link == NULL) return;			/* leer */
  if (link-> next == NULL) return;	/* letzter */  

  user-> act_index ++;
  user-> act = link-> next;

  ad_set (ev_window);
}


static void ad_prev		(void)
	/*
	 *	voriger Eintrag
	 */
{
  AD_DB *user;
  LINK *link;

  user = ev_window-> user;
  link = user-> act;

  if (link == NULL) return;			/* leer */
  if (link-> prev == NULL) return;	/* erster */

  user-> act_index --;
  user-> act = link-> prev;

  ad_set (ev_window);
}


static void ad_first	(void)
	/*
	 *	erster Eintrag
	 */
{
  AD_DB *user;
  LINK *act;

  user = ev_window-> user;
  act = user-> act;

  if (act == NULL) return;			/* leer */
  if (act-> prev == NULL) return;	/* erster */

  user-> act_index = 1;
  user-> act = user-> first;
  ad_set (ev_window);
}


static void ad_last		(void)
	/*
	 *	letzter Eintrag
	 */
{
  AD_DB *user;
  LINK *act;

  user = ev_window-> user;
  act = user-> act;

  if (act == NULL) return;			/* leer */
  if (act-> next == NULL) return;	/* letzter */

  user-> act_index = user-> n;
  user-> act = user-> last;
  ad_set (ev_window);
}


static void ad_new		(void)
	/*
	 *	neuer Eintrag
	 */
{
  AD_DB *user;
  LINK *act, *new;
  RECORD *record;
  Awindow *window;

  window = ev_window;
  user = window-> user;
  
  new = Ax_malloc (sizeof (LINK));
  if (new == NULL) return;
  record = Ax_malloc (sizeof (RECORD));
  if (record == NULL) return;

  act = user-> act;
  new-> record = record;
  user-> act = new;
  user-> act_index ++;
  user-> n ++;

  new-> prev = act;
  if (act == NULL) {		/* erster Eintrag */
	user-> first = new;
	user-> last = new;
	new-> next = NULL;
  } else {
	new-> next = act-> next;
	act-> next = new;
	if (new-> next != NULL) {
	  new-> next-> prev = new;
	} else {
	  user-> last = new;
	};
  };
  ad_get (window);
  sprintf (window-> work [AD_INDEX]. ob_spec. tedinfo-> te_ptext, " %d ", user-> act_index);
  (window-> obchange) (window, AD_INDEX, window-> work [AD_INDEX]. ob_state);
}


static void ad_modify	(void)
	/*
	 *	bernehme den Wert
	 */
{
  ad_get (ev_window);
}


static void ad_delete	(void)
	/*
	 *	Lsche Wert
	 */
{
  AD_DB *user;
  LINK *act, *p, *n;

  user = ev_window-> user;

  act = user-> act;
  if (act == NULL) return;		/* keine Eintrge */

  p = act-> prev;
  n = act-> next;
  if (p == NULL) {				/* Erster */
	user-> first = n;
  } else {
	p-> next = n;
  };
  if (n == NULL) {				/* letzter */
	user-> last = p;
	user-> act = p;
	user-> act_index --;
  } else {
	user-> act = n;
	n-> prev = p;
  };
  user-> n --;

  Ax_free (act-> record);
  Ax_free (act);
  ad_set (ev_window);
}


static void load (Awindow *window)
	/*
	 *	Lade Datei
	 */
{
  AD_DB *user;
  FILE *file;
  LINK *link, *prev;
  RECORD *record;

  user = window-> user;

  user-> n =
  user-> act_index = 0;
  user-> act =
  user-> first =
  user-> last = NULL;

  file = fopen (user-> path + 1, "r");

  if (file == NULL) return;

  prev = NULL;
  do {
	record = Ax_malloc (sizeof (RECORD));
	if (record == NULL) break;
	link = Ax_malloc (sizeof (LINK));
	if (link == NULL) break;

	if (1 != fread (record, sizeof (RECORD), 1, file)) {
	  break;	/* fehler */
	};

	user-> n ++;
	link-> record = record;
	if (prev == NULL) {		/* erster */
	  user-> first = link;
	} else {
	  prev-> next = link;
	};
	link-> prev = prev;
	prev = link;
  } while (! feof (file));

  if (user-> n == 0) return;
  prev-> next = NULL;
  user-> last = prev;
  user-> act_index = 1;
  user-> act = user-> first;
  fclose (file);
}


static Awindow *ad_make	(void *not_used)
	/*
	 *	Erzeuge Fenster
	 */
{
  Awindow *wi;
  AD_DB *user;
  char *p;

  p = fileselect ();					/* dateinamen */
  if (p == NULL) return NULL;

  user = Ax_malloc (sizeof (AD_DB));	/* benutzerobjekt */
  if (user == NULL) return NULL;

  *user-> path = ' ';
  strcpy (user-> path + 1, p);			/* kopiere Space vorne dran */
  ADDRESS. info = user-> path;			/* wird dann mit dupliziert */
  wi = Awi_create (&ADDRESS);			/* erzeuge */
  if (wi == NULL) return NULL;
  wi-> user = user;
  load (wi);							/* lade diese Datei */
  ad_set (wi);
  (wi-> open) (wi);					/* ffne gleich */
  return wi;
}


static void term (Awindow *window)
	/*
	 *	Gebe alles wieder frei
	 */
{
  AD_DB *user;
  LINK *link, *temp;

  user = window-> user;			/* Db freigeben */
  link = user-> first;
  while (link != NULL) {
	temp = link-> next;
	Ax_free (link-> record);	/* eintrag */
	Ax_free (link);				/* Zeiger */
	link = temp;
  };

  Ax_free (window-> user);
  Awi_delete (window);
}


static void ad_leave	(void)
	/*
	 *	Term
	 */
{
  term (ev_window);
}


static INT16 ad_service	(Awindow *window, INT16 task, void *in_out)
	/*
	 *	Service routine
	 */
{
  switch (task)	{				/* welche Routine */
	case AS_TERM:
	  term (window);
	  break;
	default:
	  return FALSE;				/* kein Wert */
  };
  return TRUE;					/* wurde durchgefhrt */
}


INT16 ACSinit (void)
	/*
	 *	Doppelklick auf NEU erzeugt eine neue Datenbank
	 */
{
  Awindow *window;

  path [0] = 'A' + Dgetdrv ();				/* aktuelles Laufwerk ermitteln */
  path [1] = ':';
  Dgetpath (path + 2, 0);					/* aktueller Pfad */
  if (path [2] == 0) { path [2] = '\\'; path [3] = '\0'; };

  window = Awi_root ();						/* root window */
  if (window == NULL) return FAIL;			/* lege NEU Icon an */
  (window-> service) (window, AS_NEWCALL, &ADDRESS. create);
  return OK;
}
