/*
	Beispielapplikation	fr ACS

	"Auf & Ab"

	27.9.91			Stefan Bachert

*/

#include	<stdio.h>
#include	<string.h>
#include	<acs.h>
#include	<acsplus.h>
#include	<auf_ab.h>		/* nicht wirklich notwendig in diesem Beispiel */

static void tasten (Awindow *window, INT16 key, INT16 kstate);	/* eigene Tastenroutine */
static Awindow *updown_make (void *not_used);		/* Fenster erzeugen */
static void hoch (void);							/* click-routine Zhlt hoch */
static void runter (void);							/* click-routine Zhlt runter */
static void neuer_wert (void);						/* drag-routine empfngt neuen Wert */
static void frage (void);							/* doppelklick auf Zahl */
static INT16 updown_service (Awindow *window, INT16 task, void *in_out);


#define		NUM_STRING	12345	/* Typ des Objektes */

#include	<auf_ab.ah>


static void update (void)
	/*
	 *	Macht nderungen sichtbar
	 */
{
	/*	Das Objekt mit der Nummer VALUE wird neu gezeichnet
		da sich der 'ob_state' nicht ndert.
	*/
  (ev_window-> obchange) (ev_window, VALUE, ev_window-> work [VALUE]. ob_state);
}


static void hoch (void)
	/*
	 *	Zhlt den Wert hoch
	 */
{
  char *p;
  INT16 wert;

  p = ev_object [VALUE]. ob_spec. tedinfo-> te_ptext;		/* Zeiger auf den Nummernstring */
  sscanf (p, "%d", &wert);				/* wert in integer wandeln */
  if (wert >= 999) return;				/* finito */
  wert ++;
  sprintf (p, "%d", wert);				/* wieder als String */
  update ();
}


static void runter (void)
	/*
	 *	Zhlt den Wert runter
	 */
{
  char *p;
  unsigned INT16 wert;

  p = ev_object [VALUE]. ob_spec. tedinfo-> te_ptext;		/* Zeiger auf den Nummernstring */
  sscanf (p, "%d", &wert);				/* wert in integer wandeln */
  if (wert < 1) return;					/* finito */
  wert --;
  sprintf (p, "%d", wert);				/* wieder als String */
  update ();
}



static void neuer (Awindow *window)
	/*
	 *	Erfrage neuen Wert
	 */
{
  OBJECT *dia;

  dia = Aob_create (&NEU_DIA);			/* Erzeuge Dialog */
  if (dia == NULL) return;

  strcpy (dia [DIA_VAL]. ob_spec. tedinfo-> te_ptext,	/* Vorgabe eintragen */
			window-> work [VALUE]. ob_spec. tedinfo-> te_ptext);
  if (DIA_OK == A_dialog (dia)) {						/* ok gedrckt */
	strcpy (window-> work [VALUE]. ob_spec. tedinfo-> te_ptext,	/* Wert bernehmen */
			dia [DIA_VAL]. ob_spec. tedinfo-> te_ptext);
	(window-> obchange) (window, VALUE, window-> work [VALUE]. ob_state);
  };
  Aob_delete (dia);						/* gebe Dialog wieder frei */
}


static void frage (void)
	/*
	 *	Frage nach Wert
	 */
{
  neuer (ev_window);
}


static void tasten (Awindow *window, INT16 key, INT16 kstate)
	/*
	 *	eigene Tastenroutine ruft einfach den Dialog auf
	 */
{
  neuer (window);
}


static void hole_wert (Awindow *window)
	/*
	 *	Empfngt Wert
	 */
{
  AOBJECT *aob;
  INT16 nr;

  Aselect. next = 0;					/* erstes Objekt der Liste lesen */
  nr = Adr_next ();						/* hier macht es nur Sinn ein Objekt anzunehmen */

  if (nr >= 0) {						/* ein Objekt ist da (test ist berflssig) */
	aob = (AOBJECT *) Aselect. window-> work + nr + 1;	/* zeigt auf extented Objekt, unterstellt die Existenz ohne Test ! */
	if (aob-> type == NUM_STRING) {		/* es ist der richtig Typ */

	  if (Aselect. window == window) return;	/* auf sich selbst ?? */

	  Adr_del (Aselect. window, nr);	/* Objekt konsumiert */
	  strcpy (window-> work [VALUE]. ob_spec. tedinfo-> te_ptext,	/* auf das eigene Objekt kopieren */
			aob-> userp1);
	  (window-> obchange) (window, VALUE, window-> work [VALUE]. ob_state);
	};
	if (aob-> type == AT_NEW) {			/* Neu darauf gezogen */
	  Adr_del (Aselect. window, nr);	/* Objekt konsumiert */
	  neuer (window);
	};
	
  };
}


static void neuer_wert (void)
	/*
	 *	Empfange durch Objekt
	 */
{
  hole_wert (ev_window);
}


static Awindow *updown_make (void *not_used)
	/*
	 *	Erzeuge "Auf und AB" Fenster
	 */
{
  Awindow *wi;

  wi = Awi_create (&FENSTER);
  if (wi == NULL) return NULL;

  ((AOBJECT *) wi-> work + VALUE + 1)-> userp1 =		/* userp1 des erweiterten Objektes das VALUE trgt */
	wi-> work [VALUE]. ob_spec. tedinfo-> te_ptext;	/* gleich dem Text */

  (wi-> open) (wi);					/* ffne gleich */
  return wi;
}


void delete (Awindow *window)
	/*
	 *	
	 */
{
  Adr_unselect ();			/* die Auswahlliste lschen */
  strcpy (window-> work [VALUE]. ob_spec. tedinfo-> te_ptext, "0");
  (window-> obchange) (window, VALUE, window-> work [VALUE]. ob_state);
}


static INT16 updown_service (Awindow *window, INT16 task, void *in_out)
	/*
	 *	service Routine
	 */
{
  switch (task) {
	case AS_TERM:				/* Fenster freigeben */
	  Awi_delete (window); break;
	case AS_DRAGGED:			/* gezogene Objekte als Ikone empfangen */
	  hole_wert (window); break;
	case AS_DELETE:				/* lsche Wert */
	  delete (window); break;
	case AS_INFO:				/* Info zeigen */
	  A_dialog (&INFOBOX); break;
	default:
	  return FALSE;
  };
  return TRUE;
}


INT16 ACSinit (void)
	/*
	 *	Doppelklick auf NEU erzeugt ein neues Fenster
	 */
{
  Awindow *window;

  window = Awi_root ();						/* root window */
  if (window == NULL) return FAIL;			/* lege NEU Icon an */
  (window-> service) (window, AS_NEWCALL, &FENSTER. create);

  return OK;
}


void ACSaboutme (void)			/* berschreibe Default ABOUT_ME */
{
  A_dialog (&ABOUT_ME);
}
