/*
    Beispielapplikation fr ACS

    "Input"

    2.9.92         Stefan Bachert

*/

#include	<string.h>
#include    <acs.h>
#include	<acsplus.h>
#include    <input.h>

static Awindow *inp_make (void *not_used);
static INT16 inp_service (Awindow *window, INT16 task, void *in_out);

#include    <input.ah>


static Awindow *inp_make (void *not_used)
    /*
     *  Input Fenster
     */
{
  Awindow *wi;

  wi = Awi_create (&INPUT);
  if (wi == NULL) return NULL;
  (wi-> open) (wi);                 /* ffne gleich, auch als accessory */
  return wi;
}

static INT16 inp_service (Awindow *window, INT16 task, void *in_out)
  /*
   *  service Routine
   */
{
  char *p;
  INT16 obnr;

  switch (task) {
  case AS_TERM:        /* Fenster freigeben */
    Awi_delete (window); break;
  case AS_FOCUSCHG:      /* Vor Focus change */
    obnr = window-> ob_edit;  /* da war Focus zuvor */
    if (obnr >= 0) {
      p = window-> work [obnr]. ob_spec. tedinfo-> te_ptext;
      if (*p) {  /* Was da -> uppercase */
        strupr (p);
        (window-> obchange) (window, obnr, -1);  /* Auffrischen */
      } else {        /* Leer gelassen -> Focus wieder rein setzen */
        *((INT16 *) in_out) = obnr;
      }
    };
    break;
  default:
    return FALSE;
  };
  return TRUE;
}

INT16 ACSinit0 (void)
{
  strcpy (basename, "  Inputle");
  return OK;
}


INT16 ACSinit (void)
    /*
     *  Doppelklick auf NEU erzeugt ein neues Fenster
     */
{
  Awindow *window;

  window = Awi_root ();                 /* root window */

  if (window == NULL) return FAIL;      /* lege NEU Icon an */
  (window-> service) (window, AS_NEWCALL, &INPUT. create);

  window = &INPUT;
  (window-> create) (NULL);             /* sofort ein Fenster erzeugen */

  return OK;
}
