/*
    Beispielapplikation fr ACS

    "Hello World" mit eigenem Desktop

    4.9.92         Stefan Bachert

*/

#include    <acs.h>
#include    "desk.h"

static Awindow *hello_make (void *not_used);
static Awindow *desk_make  (void *not_used);
static INT16 desk_service (Awindow *window, INT16 task, void *in_out);
static void new_window (void);
static void any_where (void);

#include    "desk.ah"


static void any_where (void)
	/*
	 *	frage
	 */
{
  Ame_popup (ev_window, &ASK, -1, -1);
}

static void quit (void) { ACSblk-> ACSclose (); }
static void about (void) { ACSblk-> ACSaboutme (); }

static void new_window (void)
	/*
	 *	Weiteres Fenster
	 */
{
  HELLO. create (NULL);
}


static Awindow *desk_make (void *not_used)
    /*
     *  Erzeuge Desktop
     */
{
  Awindow *wi;

  wi = Awi_create (&MY_DESK);
  if (wi == NULL) return NULL;

  if (wi-> work == NULL) return wi;
  if (application && ! multitask) {
	wi-> work-> ob_x      = desk. x;
	wi-> work-> ob_y      = desk. y;
	wi-> work-> ob_width  = desk. w;
	wi-> work-> ob_height = desk. h;
  } else {
	wi-> work-> ob_x      = 0;
	wi-> work-> ob_y      = 0;
	wi-> work-> ob_width  = desk. w / 2;
	wi-> work-> ob_height = desk. h / 2;
  };

  return wi;
}


static Awindow *hello_make (void *not_used)
    /*
     *  Erzeuge Hello World Fenster
     */
{
  Awindow *wi;

  wi = Awi_create (&HELLO);
  if (wi == NULL) return NULL;
  if ((wi-> open) (wi)) {		/* ffne gleich, auch als accessory */
	Awi_delete (wi);
	return NULL;
  };
  return wi;
}


static void term (Awindow *window)
	/*
	 *	Terminiert dieses Window
	 */
{
  if (application) {
	Awi_delete (window);
  } else {
	Awi_closed (window);
  };
}


static INT16 desk_service (Awindow *window, INT16 task, void *in_out)
	/*
	 *
	 */
{
  switch (task) {
  case AS_TERM:
	term (window);
	break;
  default:
	return FALSE;
  };
  return TRUE;
}


INT16 ACSinit (void)
    /*
     *  Doppelklick auf NEU erzeugt ein neues Fenster
     */
{
  Awindow *window;

  window = &HELLO;
  (window-> create) (NULL);             /* sofort ein Fenster erzeugen */

  return OK;
}
