/*
		Beispielapplikation fr ACS

		"Rezepte"

		7.12.92				 Stefan Bachert

*/

#include	<string.h>
#include	<tos.h>
#include	<acs.h>
#include	<acsplus.h>
#include	"rezept.h"
#include	"rezept.ah"

typedef struct {
	OBJECT* edit;
	char file [128];
} REDATA;

static INT16 frame = 3;
static INT16 block = 2;

static void term (Awindow* wi)
{
	Ax_free (wi-> user);
	Awi_delete (wi);
}

static void ok (void)
{
	REDATA* data;
	long handle;
	OBJECT* zutat, *zubereit;
	Awindow* wi;
	long lines;
	static char crlf []= "\r\n";
	static char nul [] = "";
	EDITGETS gets;

	wi = ev_window;
	data = wi-> user;

	handle = Fcreate (data-> file, 0);
	if (handle < 0) {
		form_alert (1, ERR_CREATE);
		return;
	}
	zutat = wi-> work + ZUTATEN;
	Auo_editor (zutat, AUO_EDUNSELECT, NULL);
	Auo_editor (zutat, AUO_EDGETROWS, &lines);
	gets. row = 0;
	while (gets. row < lines) {
		if (gets. row > 0) {
			Fwrite ((INT16) handle, 2, crlf);
		}
		Auo_editor (zutat, AUO_EDGETROW, &gets);
		if (gets. size > 0) {
			Fwrite ((INT16) handle, gets. size, gets. text);
		}
		gets. row ++;
	}
	Fwrite ((INT16) handle, 1, nul);

	zubereit = wi-> work + ZUBEREIT;
	Auo_editor (zubereit, AUO_EDUNSELECT, NULL);
	Auo_editor (zubereit, AUO_EDGETROWS, &lines);
	gets. row = 0;
	while (gets. row < lines) {
		if (gets. row > 0) {
			Fwrite ((INT16) handle, 2, crlf);
		}
		Auo_editor (zubereit, AUO_EDGETROW, &gets);
		if (gets. size > 0) {
			Fwrite ((INT16) handle, gets. size, gets. text);
		}
		gets. row ++;
	}
	Fclose ((INT16) handle);
	term (wi);
}

static void cancel (void)
{
	term (ev_window);
}

static void cled (void)
{
	OBJECT* act, *old;
	REDATA* data;

	data = ev_window-> user;
	old = data-> edit;
	act = ev_object + ev_obnr;
	if (old != act) {
		Auo_editor (old, AUO_EDCURHIDE, NULL);
		Auo_editor (old, AUO_EDUNSELECT, NULL);
		Auo_editor (old, AUO_EDCURSOR, &frame);
		Auo_editor (old, AUO_EDCURSHOW, NULL);
		Auo_editor (act, AUO_EDCURHIDE, NULL);
		Auo_editor (act, AUO_EDCURSOR, &block);
		Auo_editor (act, AUO_EDCURSHOW, NULL);
		data-> edit = act;
	} else {
		Aus_editor ();
	}
}


static void load (char* file, OBJECT* zutat, OBJECT* zubereit)
{
	long size;
	long handle;
	long col = 0;
	char* buffer, *ende, *end1, *start;
	char* p;

	handle = Fopen (file, FO_READ);
	if (handle < 0) return;
	size = Fseek (0, (INT16) handle, 2);
	Fseek (0, (INT16) handle, 0);
	buffer = Ax_malloc (size + 2);
	if (buffer == NULL) {	Fclose ((INT16) handle);	return;	}
	if (size != Fread ((INT16) handle, size, buffer)) {
		Ax_ifree (buffer); Fclose ((INT16) handle);	return;
	}
	buffer [size] = '\0';
	buffer [size + 1] = '\0';
	Fclose ((INT16) handle);

	start = buffer;
	ende = buffer + size;
	end1 = strchr (buffer, '\0');

	while (buffer < end1 && buffer [0] != '\0') {
		p = strchr (buffer, '\r');
		if (p != NULL) {
			*p = '\0';
			Auo_editor (zutat, AUO_EDAPPLINE, buffer);
			if (p [1] == '\n') {
				buffer = p + 2;
			} else {
				buffer = p + 1;
			}
			Auo_editor (zutat, AUO_EDNEWLINE, NULL);
		}	else {
			Auo_editor (zutat, AUO_EDAPPLINE, buffer);
			break;
		}
	}
	Auo_editor (zutat, AUO_BEGIN, NULL);
	Auo_editor (zutat, AUO_EDCURPOS, &col);
	Auo_editor (zutat, AUO_EDVIEW, NULL);
	Auo_editor (zutat, AUO_EDSLIDERS, NULL);

	buffer = end1 + 1;
	while (buffer < ende && buffer [0] != '\0') {
		p = strchr (buffer, '\r');
		if (p != NULL) {
			*p = '\0';
			Auo_editor (zubereit, AUO_EDAPPLINE, buffer);
			if (p [1] == '\n') {
				buffer = p + 2;
			} else {
				buffer = p + 1;
			}
			Auo_editor (zubereit, AUO_EDNEWLINE, NULL);
		}	else {
			Auo_editor (zubereit, AUO_EDAPPLINE, buffer);
			break;
		}
	}
	Auo_editor (zubereit, AUO_BEGIN, NULL);
	Auo_editor (zubereit, AUO_EDCURPOS, &col);
	Auo_editor (zubereit, AUO_EDVIEW, NULL);
	Auo_editor (zubereit, AUO_EDSLIDERS, NULL);

	Ax_ifree (start);
}


static INT16 rezept_service (Awindow* wi, INT16 task, void* in_out)
{

	switch (task) {
	case AS_TERM:
		term (wi);
		break;
	default:
		return FALSE;
	}
	return TRUE;
}

static void rezept_key (Awindow* wi, INT16 kstate, INT16 key)
{
	REDATA* data;

	data = wi-> user;
	Auok_editor (data-> edit, kstate, key);
}

static char path [128];

static Awindow *rezept_make (void *not_used)
{
	Awindow *wi;
	OBJECT* entry;
	REDATA* data;
	Awiob wiob;
	char* file;
	static long wrap = 2000L;		/* Mu klein genug sein wegen AUO_EDNEWLINE */
	
	file = A_fileselect (title, path, "RZP");
	if (file == NULL) return NULL;

	data = Ax_malloc (sizeof (REDATA));

	REZEPT. name = file;
	wi = Awi_create (&REZEPT);
	if (wi == NULL) return NULL;
	wi-> user = data;
	strcpy (data-> file, file);	

	wiob. window = wi;
	data-> edit = entry = wi-> work + ZUTATEN;
	wiob. entry = entry;
	wiob. obnr = ZUTATEN;
	Auo_editor (entry, AUO_SELF, &wiob);		/* WICHTIG */
	Auo_editor (entry, AUO_EDCHARSELECT, NULL);
	Auo_editor (entry, AUO_EDCURSOR, &block);
	Auo_editor (entry, AUO_EDCURON, NULL);
	Auo_editor (entry, AUO_EDCURSHOW, NULL);
	Auo_editor (entry, AUO_EDWRAP, &wrap);

	wiob. entry = wi-> work + ZUTATENH;
	wiob. obnr = ZUTATENH;
	Auo_editor (entry, AUO_EDHORSLIDER, &wiob);

	wiob. entry = wi-> work + ZUTATENV;
	wiob. obnr = ZUTATENV;
	Auo_editor (entry, AUO_EDVERSLIDER, &wiob);

	entry = wi-> work + ZUBEREIT;
	wiob. entry = entry;
	wiob. obnr = ZUBEREIT;
	Auo_editor (entry, AUO_SELF, &wiob);		/* WICHTIG */
	Auo_editor (entry, AUO_EDCHARSELECT, NULL);
	Auo_editor (entry, AUO_EDCURSOR, &frame);
	Auo_editor (entry, AUO_EDCURON, NULL);
	Auo_editor (entry, AUO_EDCURSHOW, NULL);
	Auo_editor (entry, AUO_EDWRAP, &wrap);

	wiob. entry = wi-> work + ZUBEREITH;
	wiob. obnr = ZUBEREITH;
	Auo_editor (entry, AUO_EDHORSLIDER, &wiob);

	wiob. entry = wi-> work + ZUBEREITV;
	wiob. obnr = ZUBEREITV;
	Auo_editor (entry, AUO_EDVERSLIDER, &wiob);
	load (file, wi-> work + ZUTATEN, wi-> work + ZUBEREIT);

	(wi-> open) (wi);								 /* ffne gleich, auch als accessory */
	return wi;
}


INT16 ACSinit0 (void)
	/*
	 *	Konfiguriere generische Desktop
	 */
{
/*	DESKTOP. menu = &MYMENU;													/* andere Menleiste */
  DESKTOP. service (NULL, AS_BACKOBJECT, &MYDESK);	/* anderer Desktophintergrund */
  DESKTOP. service (NULL, AS_ICONNEW, &NEW_IC);		/* andere Ikons */
  DESKTOP. service (NULL, AS_ICONTRASH, &TRASH_IC);
/*  DESKTOP. service (NULL, AS_ICONWINDOW, &WINDOW_IC); */
  return OK;
}


INT16 ACSinit (void)
		/*
		 *	Doppelklick auf NEU erzeugt ein neues Fenster
		 */
{
  Awindow *window;

  window = Awi_root ();									/* root window */
  if (window == NULL) return FAIL;			/* lege NEU Icon an */
  (window-> service) (window, AS_NEWCALL, &REZEPT. create);

  return OK;
}
