/*
    Beispielapplikation fr ACS

    "RS232 Commander"

    12.7.92         Stefan Bachert

	Dies ist ein einfaches Beispiel wie die RS-232-Schnittstelle
	zum Steuern verwendet werden kann.

	Jeder Knopf kann mit zwei 12 Zeichen beschriftet werden.
	Alternativ zur Mausbedienung kann ein (ASCII-) Zeichen
	frei definiert werden.
	Nach Bettigen des Knopf wird eine bis zu 56 Zeichen lange
	Nachricht versandt. Die Schreibweise \Octal ist zulssig
	Ein Doppelklick auf den Knopf gestattet die Werte zu modifizieren

	Die Definition der Knpfe lt sich speichern und wieder laden

	Das Programm lt sich durch Umbenennen in .ACC auch als
	Accessory starten.


	Bezugsquelle fr ACS:

	MAXON-Computer GmbH
	Schwalbacherstr. 52
	6236 ESCHBORN

	Preis:	DM 198,-

	Voraussetzung: Turbo C 2.0, Pure C oder Lattice C

*/

#include    <tos.h>
#include	<string.h>
#include    <acs.h>
#include	<acsplus.h>
#include    <rscom.h>

#define NBUTTONS	(16)
#define LABELSIZE	(12)
#define TASKSIZE	(28)
#define EXT			"RS"
#define	DEV			(0)			/* 1 = RS 232,  0 = Centronics (Test) */

static void laden (void);
static void sichern (void);
static void edit_ok (void);
static void edit_cancel (void);
static void sende (void);

static Awindow *make_control (void *not_used);
static Awindow *make_edit (void *not_used);
static INT16 service_edit (Awindow *wi, INT16 task, void *in_out);

#include    <rscom.ah>

typedef struct {
	INT16 index;
	Awindow *wi;
	INT16 key;
	char label1 [LABELSIZE];
	char label2 [LABELSIZE];
	char task1 [TASKSIZE];
	char task2 [TASKSIZE];
	} entry;

static entry field [NBUTTONS] = {
	 {0}, {1}, {2}, {3},
	 {4}, {5}, {6}, {7},
	 {8}, {9},{10},{11},
	{12},{13},{14},{15}
	};


static INT16 table [16] = {
	KNOPF_01, KNOPF_02, KNOPF_03, KNOPF_04,
	KNOPF_05, KNOPF_06, KNOPF_07, KNOPF_08,
	KNOPF_09, KNOPF_10, KNOPF_11, KNOPF_12,
	KNOPF_13, KNOPF_14, KNOPF_15, KNOPF_16	};


static Awindow *contrl;
static char path [80];			/* letzter Pfad */


static void closewi (void)
	/*
	 *	Alle Fenster schliessen
	 */
{
  Awindow *wi;
  INT16 index;

  for (index = 0; index < NBUTTONS; index ++) {
	wi = field [index]. wi;
	if (wi != NULL) (wi-> service) (wi, AS_TERM, NULL);
  };
}


static void label_update (void)
	/*
	 *	Labels eintragen
	 */
{
  OBJECT *work;
  AOBJECT *aob;
  INT16 index, obnr;

  work = contrl-> work;

  for (index = 0; index < NBUTTONS; index ++) {
	obnr = table [index];
	aob = (AOBJECT *) work + obnr + 1;
	aob-> key = field [index]. key;
	obnr = work [obnr]. ob_head;
	strncpy (work [obnr]. ob_spec. tedinfo-> te_ptext, field [index]. label1, LABELSIZE);
	obnr = work [obnr]. ob_next;
	strncpy (work [obnr]. ob_spec. tedinfo-> te_ptext, field [index]. label2, LABELSIZE);
  };
}


static void term_edit (Awindow *wi)
	/*
	 *
	 */
{
  INT16 index;

  index = (INT16) wi-> user;
  field [index]. wi = NULL;
  
  Awi_delete (wi);
}


static void edit_ok (void)
	/*
	 *	bernehme
	 */
{
  OBJECT *work;
  entry *ent;
  INT16 index;

  work = ev_object;
  index = (INT16) ev_window-> user;
  ent = field + index;
  
  strncpy (ent-> label1,work [LABEL_1]. ob_spec. tedinfo-> te_ptext, LABELSIZE);
  strncpy (ent-> label2,work [LABEL_2]. ob_spec. tedinfo-> te_ptext, LABELSIZE);
  strncpy (ent-> task1,	work [COMMAND_1]. ob_spec. tedinfo-> te_ptext, TASKSIZE);
  strncpy (ent-> task2,	work [COMMAND_2]. ob_spec. tedinfo-> te_ptext, TASKSIZE);
  ent-> key = 255 & *work [KEYCODE]. ob_spec. tedinfo-> te_ptext;

  label_update ();
  Awi_obredraw (contrl, table [index]);
  term_edit (ev_window);
}


static void edit_cancel (void)
	/*
	 *	Abbruch
	 */
{
  term_edit (ev_window);
}


static INT16 service_edit	(Awindow *window, INT16 task, void *in_out)
	/*
	 *	Service routine
	 */
{
  switch (task)	{				/* welche Routine */
	case AS_TERM:
	  term_edit (window);
	  break;
	default:
	  return FALSE;				/* kein Wert */
  };
  return TRUE;					/* wurde durchgefhrt */
}


static Awindow *make_edit (void *eintrag)
    /*
     *  Erzeuge Editfenster
     */
{
  Awindow *wi;
  entry *ent;
  OBJECT *work;
  INT16 index;
  char *p;

  index = (INT16) eintrag;
  ent = field + index;
  wi = ent-> wi;
  if (wi != NULL) {
	Awi_show (wi);
  } else {
	p = EDIT. name + 6;				/* Nummer in den Titel */
	if (index <= 9) {
	  *p ++ = '0';
	} else {
	  *p ++ = '1';
	};
	*p = '0' + (index % 10);

	wi = Awi_create (&EDIT);
	if (wi == NULL) return NULL;

	wi-> user = (void *) index;
	ent-> wi = wi;			/* merke Editor zu diesem Eintrag */
	work = wi-> work;
	strncpy (work [LABEL_1]. ob_spec. tedinfo-> te_ptext, ent-> label1, LABELSIZE);
	strncpy (work [LABEL_2]. ob_spec. tedinfo-> te_ptext, ent-> label2, LABELSIZE);
	strncpy (work [COMMAND_1]. ob_spec. tedinfo-> te_ptext, ent-> task1, TASKSIZE);
	strncpy (work [COMMAND_2]. ob_spec. tedinfo-> te_ptext, ent-> task2, TASKSIZE);
	*(work [KEYCODE]. ob_spec. tedinfo-> te_ptext) = (char) ent-> key;

	(wi-> open) (wi);
  }
  return wi;
}



static char *fileselect (void)
	/*
	 *	Hole Filenamen
	 */
{
  char *p;
  char file [16];
  INT16 button;

  p = strrchr (path, '\\');					/* select entfernen */
  *(p + 1) = '\0';
  strcat (path, "*." EXT);					/* Extension suchen */
  file [0] = '\0';

  Aev_unhidepointer ();						/* Zeiger wieder sichtbar */
  if (fsel_input (path, file, &button) == 0 ||
	  button == 0 ||
	  file [0] == '\0') {
	return NULL;
  };

  if (strlen (file) == 9) {					/* 8 + . doch extension anhngen */
	if (*(file + 8) == '.') strcat (file, EXT);
  };
  if (strchr (file, '.') == NULL) {			/* hnge extension an */
	strcat (file, "." EXT);
  };

  p = strrchr (path, '\\');					/* select entfernen */
  strcpy (p + 1, file);

  return path;
}


static void laden (void)
	/*
	 *
	 */
{
  char *name;
  INT16 handle;
  long ret;

  name = fileselect ();
  if (name == NULL) return;
  closewi ();

  handle = (INT16) Fopen (name, 0);
  if (handle < 0) {
	form_error (- handle - 31);
	return;
  };

  ret = Fread (handle, sizeof (field), &field);
  if (sizeof (field) != ret) {
	form_error (((INT16) - ret) - 31);
  }

  label_update ();
  Awi_obredraw (contrl, 0);

  Fclose (handle);
}


static void sichern (void)
	/*
	 *
	 */
{
  char *name;
  INT16 handle;
  long ret;

  name = fileselect ();
  if (name == NULL) return;
  closewi ();

  handle = (INT16) Fcreate (name, 0);
  if (handle < 0) {
	form_error (- handle - 31);
	return;
  };

  ret = Fwrite (handle, sizeof (field), &field);
  if (sizeof (field) != ret) {
	form_error (((INT16) - ret) - 31);
  }

  Fclose (handle);
}


static void ausgabe (char *text)
	/*
	 *	Gibt den Text an das Device, erkennt \Octal Schreibweise
	 */
{
  char c, code;

  while (*text) {			/* alle Zeichen ausgeben */
	c = *text ++;
	if (c == '\\') {		/* Besondere Zeichen */
	  c = *text ++;
	  switch (c) {
		case 'n': Bconout (DEV, '\n'); break;
		case 'r': Bconout (DEV, '\r'); break;
		case 't': Bconout (DEV, '\t'); break;
		case '0': case '1': case '2': case '3':	case '4':
		case '5': case '6': case '7': case '8': case '9':
		  code = c - '0';
		  while (*text >= '0' && *text <= '9') {
			code = (code << 3) + (*text ++) - '0';
		  };
		  Bconout (DEV, code); break;
		default: Bconout (DEV, c); break;
	  };
	} else {	/* normales Zeichen */
	  Bconout (DEV, c);
	};
  };
}


static void sende (void)
	/*
	 *	Senden oder Edit (Dklick)
	 */
{
  INT16 eintrag;  

  switch (ev_obnr) {
	case KNOPF_01: eintrag = 0; break;
	case KNOPF_02: eintrag = 1; break;
	case KNOPF_03: eintrag = 2; break;
	case KNOPF_04: eintrag = 3; break;
	case KNOPF_05: eintrag = 4; break;
	case KNOPF_06: eintrag = 5; break;
	case KNOPF_07: eintrag = 6; break;
	case KNOPF_08: eintrag = 7; break;
	case KNOPF_09: eintrag = 8; break;
	case KNOPF_10: eintrag = 9; break;
	case KNOPF_11: eintrag = 10; break;
	case KNOPF_12: eintrag = 11; break;
	case KNOPF_13: eintrag = 12; break;
	case KNOPF_14: eintrag = 13; break;
	case KNOPF_15: eintrag = 14; break;
	case KNOPF_16: eintrag = 15; break;
	default: return;		/* sollte nicht passieren */
  };
  if (ev_object [ev_obnr]. ob_state & AOS_DCLICK) {	/* edit */
	make_edit ((void *) eintrag);
  } else {	/* senden */
	ausgabe (field [eintrag]. task1);
	ausgabe (field [eintrag]. task2);
  }
}


static Awindow *make_control (void *not_used)
    /*
     *  Erzeuge Kontroll Fenster
     */
{
  Awindow *wi;

  wi = Awi_create (&CONTROL);
  if (wi == NULL) return NULL;
  contrl = wi;
  label_update ();
  if (application) (wi-> open) (wi);
  return wi;
}


INT16 ACSinit (void)
    /*
     *  Erzeuge sofort Control
     */
{
  path [0] = 'A' + Dgetdrv ();				/* aktuelles Laufwerk ermitteln */
  path [1] = ':';
  Dgetpath (path + 2, 0);					/* aktueller Pfad */
  if (path [2] == 0) { path [2] = '\\'; path [3] = '\0'; };

  if (application) (CONTROL. create) (NULL);             /* sofort ein Fenster erzeugen */

  return OK;
}
