/*
    Beispielapplikation fr ACS

    "User Slider"

    14.4.92         Stefan Bachert

*/

#include    <acs.h>
#include	<acsplus.h>
#include    <uslider.h>

static Awindow *uslider_make (void *not_used);
static void uslider_arrow (Awindow *window, INT16 which);
static void uslider_vslid (Awindow *window, INT16 pos);
static void uslider_hslid (Awindow *window, INT16 pos);
static INT16 CDECL cimage (PARMBLK *pb);

#include    <uslider.ah>

static INT16 CDECL cimage (PARMBLK *pb)
	/*
	 *
	 */
{
  INT16 pxy [8];
  Awindow *wi;
  Axywh *user;

  pxy [2] = pb-> pb_wc;
  pxy [3] = pb-> pb_hc;
  if (pxy [2] || pxy [3]) {			/* klippe */
	pxy [0] = pb-> pb_xc;
	pxy [1] = pb-> pb_yc;
	pxy [2] += pxy [0] - 1;
	pxy [3] += pxy [1] - 1;
	vs_clip (vdi_handle, TRUE, pxy);
  };

  wi = (Awindow *) pb-> pb_parm;
  user = wi-> user;
  pxy [0] = user-> x;
  pxy [1] = user-> y;
  pxy [2] = user-> x + pb-> pb_w - 1;
  pxy [3] = user-> y + pb-> pb_h - 1;
  pxy [4] = pb-> pb_x;
  pxy [5] = pb-> pb_y;
  pxy [6] = pb-> pb_x + pb-> pb_w - 1;
  pxy [7] = pb-> pb_y + pb-> pb_h - 1;
  vro_cpyfm (vdi_handle, S_ONLY, pxy, &screenMFDB, &screenMFDB);

  vs_clip (vdi_handle, FALSE, pxy);
  return pb-> pb_currstate;
}


static void cleanup (Awindow *wi)
{
  Axywh *user;
  INT16 d, wid;
  OBJECT *im;

  im = wi-> work + IMAGE;
  user = wi-> user;
  wid = wi-> wi_id;
  if (wid < 0) return;
  
  if (user-> x < 0) user-> x = 0;
  if (user-> y < 0) user-> y = 0;
  d = user-> x + im-> ob_width - user-> w;
  if (d > 0) user-> x -= d;
  d = user-> y + im-> ob_height - user-> h;
  if (d > 0) user-> y -= d;

  wi-> wi_slider. x = (INT16) ((user-> x * 1000L) / (user-> w - im-> ob_width));
  wind_set (wid, WF_HSLIDE, wi-> wi_slider. x, 0, 0, 0);
  wi-> wi_slider. y = (INT16) ((user-> y * 1000L) / (user-> h - im-> ob_height));
  wind_set (wid, WF_VSLIDE, wi-> wi_slider. y, 0, 0, 0);
  (wi-> obchange) (wi, IMAGE, im-> ob_state);
}


static void uslider_arrow (Awindow *wi, INT16 which)
	/*
	 *
	 */
{
  Axywh *user;
  OBJECT *im;

  im = wi-> work + IMAGE;
  user = wi-> user;

  switch (which) {
  case WA_UPLINE:			/* Zeile hoch */
	user-> y --; break;
  case WA_DNLINE:			/* Zeile runter */
	user-> y ++; break;
  case WA_UPPAGE:			/* Seitenweise */
	user-> y -= im-> ob_height; break;
  case WA_DNPAGE:
	user-> y += im-> ob_height; break;
  case WA_LFPAGE:
	user-> x -= im-> ob_width; break;
  case WA_RTPAGE:
	user-> x += im-> ob_width; break;
  case WA_LFLINE:
	user-> x --; break;
  case WA_RTLINE:
	user-> x ++; break;
  };
  cleanup (wi);
}


static void uslider_vslid (Awindow *wi, INT16 pos)
	/*
	 *
	 */
{
  Axywh *user;
  user = wi-> user;

  user-> y = (INT16) (((long) pos * user-> h) / 1000L);

  cleanup (wi);
}


static void uslider_hslid (Awindow *wi, INT16 pos)
	/*
	 *
	 */
{
  Axywh *user;
  user = wi-> user;

  user-> x = (INT16) (((long) pos * user-> w) / 1000L);

  cleanup (wi);
}


static Awindow *uslider_make (void *not_used)
    /*
     *  Erzeuge Fenster
     */
{
  Awindow *wi;
  OBJECT *im;
  Axywh *user;

  wi = Awi_create (&USLIDER);
  if (wi == NULL) return NULL;
  wi-> user = user = Ax_malloc (sizeof (Axywh));
  if (user == NULL) return NULL;

  wi-> kind |= AW_UHSLIDER | AW_UVSLIDER;	/* spezial Flags setzen */

  im = wi-> work + IMAGE;
  im-> ob_spec. userblk-> ub_parm = (long) wi;

  user-> x =
  user-> y = 0;
  user-> w = desk. x + desk. w;
  user-> h = desk. y + desk. h;

  wi-> wi_slider. x =			/* start werte */
  wi-> wi_slider. y = 0;
  wi-> wi_slider. w = (INT16) ((im-> ob_width * 1000L) / user-> w);
  wi-> wi_slider. h = (INT16) ((im-> ob_height * 1000L) / user-> h);

  (wi-> open) (wi);                 /* ffne gleich, auch als accessory */
  return wi;
}


INT16 ACSinit (void)
    /*
     *  Doppelklick auf NEU erzeugt ein neues Fenster
     */
{
  Awindow *window;

  window = Awi_root ();                 /* root window */

  if (window == NULL) return FAIL;      /* lege NEU Icon an */
  (window-> service) (window, AS_NEWCALL, &USLIDER. create);

  window = &USLIDER;
  (window-> create) (NULL);             /* sofort ein Fenster erzeugen */

  return OK;
}
