{	Beispielapplikation fr ACS
	"Adressdatenbank"
	27.09.91 Stefan Bachert (Pure C)
	29.09.92 Michael Schlter (Pure Pascal)
	Letzte nderung: 01.01.93
}

PROGRAM adress;							{ Programmname }

{$X+}				{ Functionen knnen ohne Resultat aufgerufen werden }

USES ACS, GEM, TOS;						{ bentigte Units }

PROCEDURE ad_save; FORWARD;				{ Definitionen werden schon }
PROCEDURE ad_leave; FORWARD;			{ in ADRESS.I gebraucht }
PROCEDURE ad_next; FORWARD;
PROCEDURE ad_prev; FORWARD;
PROCEDURE ad_first; FORWARD;
PROCEDURE ad_last; FORWARD;
PROCEDURE ad_new; FORWARD;
PROCEDURE ad_modify; FORWARD;
PROCEDURE ad_delete; FORWARD;
FUNCTION ad_service( window : AwindowPtr; task : INTEGER; in_out : POINTER) : BOOLEAN; FORWARD;
FUNCTION ad_make( not_used: POINTER ): AwindowPtr; FORWARD;

{$I ADRESS.I}							{ einladen der Definitionen }

CONST									{ Vordefinierte Werte }
		LAENGE		=		35;
		PLZ			=		5;
		TOWN		=		30;
		PHONE		=		13;
		BIRTHDAY	=		6;

TYPE
		TRecordPtr	= ^TRecord;
		TRecord 	= RECORD
			firstname	:	ARRAY[0..LAENGE] OF CHAR;
			lastname	:	ARRAY[0..LAENGE] OF CHAR;
			street		:	ARRAY[0..LAENGE] OF CHAR;
			plz			:	ARRAY[0..PLZ] OF CHAR;
			town		:	ARRAY[0..TOWN] OF CHAR;
			phone		:	ARRAY[0..PHONE] OF CHAR;
			birthday	:	ARRAY[0..BIRTHDAY] OF CHAR;
			hobby		:	ARRAY[0..LAENGE + LAENGE] OF CHAR;
			idea		:	ARRAY[0..LAENGE + LAENGE] OF CHAR;
			dont		:	ARRAY[0..LAENGE + LAENGE] OF CHAR;
		END;

		TLinkPtr	= ^TLink;
		TLink 		= RECORD
			next		:	TLinkPtr;
			prev		:	TLinkPtr;
			ad_record	:	TRecordPtr;
		END;

		TAd_DbPtr	= ^TAd_Db;
		TAd_Db		= RECORD
			n			:	INTEGER;
			act_index	:	INTEGER;
			act			:	TLinkPtr;
			first		:	TLinkPtr;
			last		:	TLinkPtr;
			path		:	STRING;
		END;

VAR
		path	:	STRING;				{ Zwischenspeicher fr den Pfad }
		proto	:	TRecord;			{ Falls keine Daten geladen werden }

{ ----------------------------------------------------------------- }
{ Nimmt die Auswahl der zu ladenden Datei vor (mit Dateiauswahlbox) }
{ ----------------------------------------------------------------- }
FUNCTION fileselect : STRING;
VAR		name	: STRING;				{ Name der Datei }
		button	: INTEGER;				{ gedrckte Button }

	{ * Lscht einen Dateinamen aus dem bergebenen Pfad * }
	PROCEDURE pfad_select_entf( VAR pfad : STRING );
	VAR 	p		: BYTE;				{ Buchstabenzhler }
	BEGIN
		p := LENGTH(pfad);				{ stelle Lnge des Pfades fest }
		WHILE ( pfad[p] <> '\' ) DO		{ Wiederhole bis '\' gefunden }
			DEC(p);						{ Nchstes Zeichen }
		pfad[0] := CHR(p);				{ Lnge anpassen }
	END;

BEGIN
	pfad_select_entf(path);				{ Alten Dateinamen lschen }
	name := '';							{ Kein Name vorwhlen }
	path := path + '*.ADB';				{ Nur nach Datenbanken suchen }
	Aev_unhidepointer;					{ Der Mauszeiger wird wieder sichtbar }
	IF ((Fsel_input(path, name, button) = 0) OR
		(button = 0) OR (LENGTH(name) = 0)) THEN
										{ Wenn kein Speicher fr Dateiauswahlbox }
										{ oder Abbruch oder kein Dateiname }
		fileselect := ''				{ nichts zurckgeben }
	ELSE
	BEGIN
		IF ((LENGTH(name) = 9) AND (name[8] = '.')) THEN
										{ Wenn Dateiname + '.' }
			name := name + 'ADB';		{ dann Extension anhngen }
		IF (POS('.', name) = 0) THEN	{ Wenn kein '.' }
			name := name + '.ADB';		{ dann Extension mit '.' anhngen }
		pfad_select_entf(path);			{ Pfad wieder zurckkrzen }
		fileselect := path + name;		{ Pfad mit Dateinamen zurckgeben }
	END;
END;

{ ----------------------------------------------------------------- }
{ Daten in die Dialogbox eintragen									}
{ ----------------------------------------------------------------- }
PROCEDURE ad_set( window : AwindowPtr );
VAR		user	: TAd_DbPtr;			{ Pointer auf Userrec. einer Datenbank }
		xrekord	: TRecordPtr;			{ Pointer auf einen Datensatz }
		work	: AESTreePtr;			{ Pointer auf den Objectbaum }
		nr 		: STRING;				{ String fr Datensatznummer }
BEGIN
	user := window^.user;				{ Pointer auf Userrecord holen }
	work := AESTreePtr(window^.work);	{ Pointer auf Objectbaum holen }
	IF (user^.act = NIL) THEN xrekord := @proto
							{ Wenn keine DB geladen, dann leeren Datens. nehmen }
	ELSE xrekord := user^.act^.ad_record;{ Sonst aktuellen Datens. nehmen }
	STR(user^.act_index, nr);			{ Datensatznummer in String umwandeln }
	nr := ' ' + nr + ' ';				{ Leerzeichen einfgen }
	SetPtext(work, AD_INDEX, nr);		{ Und in den Objectrecord einbauen }
								{ Daten aus dem Record in das Object kopieren: }
	Move(xrekord^.firstname, work^[AD_FIRSTNAME].ob_spec.ted_info^.te_ptext^, LAENGE);
	Move(xrekord^.lastname, work^[AD_LASTNAME].ob_spec.ted_info^.te_ptext^, LAENGE);
	Move(xrekord^.street, work^[AD_STREET].ob_spec.ted_info^.te_ptext^, LAENGE);
	Move(xrekord^.plz, work^[AD_PLZ].ob_spec.ted_info^.te_ptext^, PLZ);
	Move(xrekord^.town, work^[AD_TOWN].ob_spec.ted_info^.te_ptext^, TOWN);
	Move(xrekord^.phone, work^[AD_PHONE].ob_spec.ted_info^.te_ptext^, PHONE);
	Move(xrekord^.birthday, work^[AD_BIRTHDAY].ob_spec.ted_info^.te_ptext^, BIRTHDAY);
	Move(xrekord^.hobby, work^[AD_1HOBBY].ob_spec.ted_info^.te_ptext^, LAENGE);
	Move(xrekord^.hobby[LAENGE], work^[AD_2HOBBY].ob_spec.ted_info^.te_ptext^, LAENGE);
	Move(xrekord^.idea, work^[AD_1IDEA].ob_spec.ted_info^.te_ptext^, LAENGE);
	Move(xrekord^.idea[LAENGE], work^[AD_2IDEA].ob_spec.ted_info^.te_ptext^, LAENGE);
	Move(xrekord^.dont, work^[AD_1DONTS].ob_spec.ted_info^.te_ptext^, LAENGE);
	Move(xrekord^.dont[LAENGE], work^[AD_2DONTS].ob_spec.ted_info^.te_ptext^, LAENGE);
	Awi_diaend;							{ Textcursor entfernen }
	window^.OB_COL := -1;				{ Textcursor an letzte Position }
	window^.redraw(window, @window^.wi_work);{ Dialog updaten }
	Awi_diastart;						{ Textcursor darstellen }
END;

{ ----------------------------------------------------------------- }
{ Daten aus der Dialogbox holen										}
{ ----------------------------------------------------------------- }
PROCEDURE ad_get(window : AwindowPtr);
VAR		user	: TAd_DbPtr;			{ Pointer auf Userrec. einer Datenbank }
		xrekord	: TRecordPtr;			{ Pointer auf einen Datensatz }
		work	: AESTreePtr;			{ Pointer auf den Objectbaum }
BEGIN
	user := window^.user;				{ Pointer auf Userrecord holen }
	work := AESTreePtr(window^.work);	{ Pointer auf Objectbaum holen }
	xrekord := user^.act^.ad_record;	{ Aktuellen Datensatz nehmen }
	Move(work^[AD_FIRSTNAME].ob_spec.ted_info^.te_ptext^, xrekord^.firstname, LAENGE);
	Move(work^[AD_LASTNAME].ob_spec.ted_info^.te_ptext^, xrekord^.lastname, LAENGE);
	Move(work^[AD_STREET].ob_spec.ted_info^.te_ptext^, xrekord^.street, LAENGE);
	Move(work^[AD_PLZ].ob_spec.ted_info^.te_ptext^, xrekord^.plz, PLZ);
	Move(work^[AD_TOWN].ob_spec.ted_info^.te_ptext^, xrekord^.town, TOWN);
	Move(work^[AD_PHONE].ob_spec.ted_info^.te_ptext^, xrekord^.phone, PHONE);
	Move(work^[AD_BIRTHDAY].ob_spec.ted_info^.te_ptext^, xrekord^.birthday, BIRTHDAY);
	Move(work^[AD_1HOBBY].ob_spec.ted_info^.te_ptext^, xrekord^.hobby, LAENGE);
	Move(work^[AD_2HOBBY].ob_spec.ted_info^.te_ptext^, xrekord^.hobby[LAENGE], LAENGE);
	Move(work^[AD_1IDEA].ob_spec.ted_info^.te_ptext^, xrekord^.idea, LAENGE);
	Move(work^[AD_2IDEA].ob_spec.ted_info^.te_ptext^, xrekord^.idea[LAENGE], LAENGE);
	Move(work^[AD_1DONTS].ob_spec.ted_info^.te_ptext^, xrekord^.dont, LAENGE);
	Move(work^[AD_2DONTS].ob_spec.ted_info^.te_ptext^, xrekord^.dont[LAENGE], LAENGE);
END;


{ ----------------------------------------------------------------- }
{ Daten auf einen Datentrger sichen								}
{ ----------------------------------------------------------------- }
PROCEDURE ad_save;
VAR		user	: TAd_DbPtr;			{ Pointer auf Userrec. einer Datenbank }
		datei	: FILE OF TRecord;		{ Variable fr Dateihandling }
		link	: TLinkPtr;				{ Record von Pointern auf Datenstze }
BEGIN
	user := ev_window^.user;			{ Pointer auf User-Record holen }
	Assign(datei, copy(user^.path, 2, LENGTH(user^.path)-1));
										{ Datei zuweisen }
	{$I-}								{ berprfung auf IO-Fehler aus }
	Rewrite(datei);						{ Neue Datei - alte Daten lschen }
	{$I+}								{ berprfung auf IO-Fehler an }
	IF IOResult <> 0 THEN EXIT;			{ Wenn Fehler, dann Procedure beenden }
	link := user^.first;				{ Auf ersten Link setzten }
	WHILE (link <> NIL) DO				{ Wiederhole bis letzter Link }
	BEGIN
		Blockwrite(datei, link^.ad_record^, 1);
										{ Datensatz auf Datentrger speichern }
		link := link^.next;				{ Zum nchsten Link }
	END;
	close(datei);						{ Datei wieder schlieen }
END;

{ ----------------------------------------------------------------- }
{ Nchsten Datensatz anzeigen										}
{ ----------------------------------------------------------------- }
PROCEDURE ad_next;
VAR		user	: TAd_DbPtr;			{ Pointer auf Userecord einer Datenb. }
		link	: TLinkPtr;				{ Record von Pointer auf Datensatz }
BEGIN
	user := ev_window^.user;			{ Userecord holen }
	link := user^.act;					{ Linkrecord holen }
	IF (link <> NIL) AND (link^.next <> NIL) THEN
	BEGIN					{ Wenn Link vorhanden und es einen nchsten DS gibt }
		INC(user^.act_index);			{ Indexnummer erhhen }
		user^.act := link^.next;		{ Nchste Datensatz ist nun aktuelle Datensatz }
		ad_set(ev_window);				{ Daten in das Object eintragen }
	END;
END;

{ ----------------------------------------------------------------- }
{ Vorherigen Datensatz anzeigen										}
{ ----------------------------------------------------------------- }
PROCEDURE ad_prev;
VAR		user	: TAd_DbPtr;			{ Pointer auf Userecord einer Datenb. }
		link	: TLinkPtr;				{ Record von Pointer auf Datensatz }
BEGIN
	user := ev_window^.user;			{ Userecord holen }
	link := user^.act;					{ Linkrecord holen }
	IF (link <> NIL) AND (link^.prev <> NIL) THEN
	BEGIN					{ Wenn Link vorhanden und es einen vorherigen DS gibt }
		DEC(user^.act_index);			{ Indexnummer erniedrigen }
		user^.act := link^.prev;		{ Vorherige Datensatz ist nun aktuelle Datensatz }
		ad_set(ev_window);				{ Daten in das Object eintragen }
	END;
END;

{ ----------------------------------------------------------------- }
{ Ersten Datensatz anzeigen											}
{ ----------------------------------------------------------------- }
PROCEDURE ad_first;
VAR		user	: TAd_DbPtr;			{ Pointer auf Userecord einer Datenb. }
		act		: TLinkPtr;				{ Record von Pointer auf Datensatz }
BEGIN
	user := ev_window^.user;			{ Userecord holen }
	act := user^.act;					{ Linkrecord holen }
	IF (act <> NIL) AND (act^.prev <> NIL) THEN
	BEGIN					{ Wenn Link vorhanden und nicht schon erster DS  }
		user^.act_index := 1;			{ Indexnummer = 1 }
		user^.act := user^.first;		{ Erste Datensatz ist nun aktuelle Datensatz }
		ad_set(ev_window);				{ Daten in das Object eintragen }
	END;
END;

{ ----------------------------------------------------------------- }
{ Letzten Datensatz anzeigen										}
{ ----------------------------------------------------------------- }
PROCEDURE ad_last;
VAR		user	: TAd_DbPtr;			{ Pointer auf Userecord einer Datenb. }
		act		: TLinkPtr;				{ Record von Pointer auf Datensatz }
BEGIN
	user := ev_window^.user;			{ Userecord holen }
	act := user^.act;					{ Linkrecord holen }
	IF (act <> NIL) AND (act^.next <> NIL) THEN
	BEGIN					{ Wenn Link vorhanden und nicht schon letzter DS  }
		user^.act_index := user^.n;		{ Indexnummer = letzte DSnummer }
		user^.act := user^.last;		{ Letzte Datensatz ist nun aktuelle Datensatz }
		ad_set(ev_window);				{ Daten in das Object eintragen }
	END;
END;

{ ----------------------------------------------------------------- }
{ Neuen Datensatz eingeben											}
{ ----------------------------------------------------------------- }
PROCEDURE ad_new;
VAR		user		: TAd_DbPtr;		{ Pointer auf Userrec. einer Datenbank }
		act, new	: TLinkPtr;			{ Record von Pointer auf Datenstze }
		xrecord		: TRecordPtr;		{ Pointer auf Datensatz }
		window		: AwindowPtr;		{ Pointer auf Fensterrecord }
BEGIN
	window := ev_window;				{ Fensterrecordpointer holen }
	user := window^.user;				{ Pointer auf User-Record holen }
	new := Ax_malloc(SizeOf(TLink));	{ Speicher fr Link anfordern }
	IF new = NIL THEN EXIT;				{ Wenn kein freier Speicher -> abbruch }
	xrecord := Ax_malloc(SizeOf(TRecord));{ Speicher fr Datenrecord anfordern }
	IF xrecord = NIL THEN EXIT;			{ Wenn kein freier Speicher -> abbruch }
	act := user^.act;					{ Aktuellen Link holen }
	new^.ad_record := xrecord;			{ Adresse des Datensatzes sichern }
	user^.act := new;					{ Neue DS = aktuelle DS }
	INC(user^.act_index);				{ Erhhe den index }
	INC(user^.n);						{ Erhhe die Anzahl d. DS }
	new^.prev := act;					{ Aktuelle DS ist vorgnger des neuen DS }
	IF act = NIL THEN					{ Wenn kein aktueller DS dann ... }
	BEGIN
		user^.first := new;				{ Neuer DS = erster DS }
		user^.last := new;				{    "     = letzter DS }
		new^.next := NIL;				{ Und kein nchster DS }
	END
	ELSE 								{ Sonst ... }
	BEGIN
		new^.next := act^.next;			{ Nchster DS = nchster DS vom aktuellen DS }
		act^.next := new;				{ Nchste DS vom aktuellen DS = neuer DS }
		IF new^.next <> NIL THEN		{ Wenn es einen nchsten DS gibt ... }
			new^.next^.prev := new		{ Dann dort den neuen als vorgnger eintragen }
		ELSE							{ Sonst ... }
			user^.last := new;			{ Ist der neue DS = der letzte DS }
	END;
	ad_get(window);						{ Daten aus dem Object auslesen }
	ad_set(window);						{ Daten in Object eintragen und ausgeben }
END;

{ ----------------------------------------------------------------- }
{ Vernderten Datensatz bernehmen									}
{ ----------------------------------------------------------------- }
PROCEDURE ad_modify;
BEGIN
	ad_get(ev_window);					{ Daten aus Object auslesen }
END;

{ ----------------------------------------------------------------- }
{ Datensatz lschen													}
{ ----------------------------------------------------------------- }
PROCEDURE ad_delete;
VAR 	user 		: TAd_DbPtr;		{ Pointer auf Userrec. einer Datenbank }
		act, p, n	: TLinkPtr;			{ Record von Pointern auf Datenstze }
BEGIN
	user := ev_window^.user;			{ Pointer auf User-Record holen }
	act := user^.act;					{ Pointer auf aktuellen Link holen }
	IF act = NIL THEN EXIT;				{ Wenn kein DS mehr vorhanden }
	p := act^.prev;						{ Vorherigen Link holen }
	n := act^.next;						{ Nchsten Link holen }
	IF p = NIL THEN 					{ Wenn kein vorheriger Link }
		user^.first := n				{ Dann der Nchste = der Erste }
	ELSE
		p^.next := n;					{ Sonst der Nchste = der Nchste }
	IF n = NIL THEN						{ Wenn kein nchste Link }
	BEGIN
		user^.last := p;				{ Der Letzte = Vorherige }
		user^.act := p;					{ Der Aktuelle = Vorherige }
		DEC(user^.act_index);			{ Index an aktuellen Datensatz anpassen }
	END
	ELSE
	BEGIN
		user^.act := n;					{ Der Aktuelle = der Nchste }
		n^.prev := p;					{ Der Vorherige = der Vorherige }
	END;
	DEC(user^.n);						{ Ein Datensatz weniger }
	Ax_free(act^.ad_record);			{ Speicher fr Record wieder freigeben }
	Ax_free(act);						{ Speicher fr Link wieder freigeben }
	Ad_set(ev_window);					{ Daten in Object eintragen und ausgeben }
END;


{ ----------------------------------------------------------------- }
{ Ld die Daten einer Datenbank von einem Datentrger				}
{ ----------------------------------------------------------------- }
PROCEDURE load( window : AwindowPtr );
LABEL	FEHLER;							{ Sprungmarke bei einem Fehler }
VAR		user		: TAd_DbPtr;		{ Pointer auf Userrec. einer Datenbank }
		datei		: FILE OF TRecord;	{ Variable fr Dateihandling }
		link, prev	: TLinkPtr;			{ Record von Pointern auf Datenstze }
		xrecord		: TRecordPtr;		{ Pointer auf Datensatz }
		loops		: LONGINT;			{ Zwischenspeicher Anzahl d. Datenstze }
BEGIN
	user := window^.user;				{ Pointer auf User-Record holen }
	user^.n := 0;						{ Enthlt bisher keinen Datens. }
	user^.act_index := 0;				{ Keinen aktueller Datensatz }
	user^.act := NIL;					{ Keinen aktuellen Datensatz }
	user^.first := NIL;					{ Keinen ersten Datensatz }
	user^.last := NIL;					{ Keinen letzten Datensatz }
	
	Assign(datei, copy(user^.path, 2, LENGTH(user^.path) - 1));
										{ Datei zuweisen }
	{$I-}								{ berprfung auf IO-Fehler aus }
	Reset(datei);						{ Datei ffnen }
	{$I+}								{ berprfung auf IO-Fehler an }
	IF IOResult <> 0 THEN EXIT;			{ Wenn Fehler, dann beende Procedure }
	prev := NIL;						{ Kein vorheriger Datensatz }
	loops := Filesize(datei);			{ Anzahl der Datenstze -> loops }
	WHILE ( user^.n < loops ) DO		{ Wiederhole bis alle Datenstze gelesen }
	BEGIN
		xrecord := Ax_malloc(SizeOf(TRecord));
										{ Speicher fr einen TRecord bereitst. }
		IF (xrecord = NIL) THEN GOTO FEHLER;
										{ Wenn Fehler dann Schleife abbrechen }
		link := Ax_malloc(SizeOf(TLink));{ Speicher fr einen TLink bereitst. }
		IF (link = NIL) THEN GOTO FEHLER;{ Wenn Fehler dann Schleife abbrechen }
		BlockRead(datei, xrecord^, 1);	{ Lese Datensatz von Datentrger ein }
		INC(user^.n);					{ Erhhe Datensatzzhler }
		link^.ad_record := xrecord;		{ Adresse des Datensatzrecords abspeichern }
		IF (prev = NIL) THEN			{ Wenn erste Datensatz }
			user^.first := link			{ dann im user-Record abspeicher }
		ELSE
			prev^.next := link;			{ sonst in Pointerkette einreihen }
		link^.prev := prev;				{ vorherigen eintragen }
		prev := link;					{ aktuelle ist vorherige }
	END;
FEHLER:									{ im Fehlerfall ist man hier richtig }
	IF (user^.n <> 0) THEN				{ Wenn mind. ein Datensatz geladen }
	BEGIN
		prev^.next := NIL;				{ kein nchster Datensatz }
		user^.last := prev;				{ letzte ist letzter Datensatz }
		user^.act_index := 1;			{ erste ist aktuelle Datensatz }
		user^.act := user^.first;		{ erste ist aktuelle Datensatz }
	END;
	Close(datei);						{ Schliee Datei }
END;

{ ----------------------------------------------------------------- }
{ Beendet die Bearbeitung eines Datenbankfensters					}
{ ----------------------------------------------------------------- }
PROCEDURE term( window : AwindowPtr );
VAR		user		: TAd_DbPtr;		{ Pointer auf Userrec. einer Daten B. }
		link, temp	: TLinkPtr;			{ Record von Pointern auf Datenstze }
BEGIN
	user := window^.user;				{ Pointer auf User-Record holen }
	link := user^.first;				{ Erste Link eines Datensatz holen }
	while (link <> NIL) DO				{ Wiederhole bis keine Link mehr da }
	BEGIN
		temp := link^.next;				{ Nchsten Link zwischensp. }
		Ax_free(link^.ad_record);		{ Gebe Speicher eines Datens. frei }
		Ax_free(link);					{ Gebe Speicher eine Links frei }
		link := temp;					{ Zum nchsten Link }
	END;

	Ax_free(user);						{ User-Record freigeben }
	Awi_delete(window);					{ Fenster-Record freigeben }
END;

{ ----------------------------------------------------------------- }
{ Ein Datenbankenfenster soll geschlossen werden					}
{ ----------------------------------------------------------------- }
PROCEDURE ad_leave;
BEGIN
	term(ev_window);					{ Lsche Adr. Datenbank mit Fenster }
END;

{ ----------------------------------------------------------------- }
{ Routine, die die Nachrichten vom ACS bearbeitet					}
{ ----------------------------------------------------------------- }
FUNCTION ad_service( window : AwindowPtr; task : INTEGER; in_out : POINTER) : BOOLEAN;
BEGIN
	CASE task OF
		AS_TERM: term(window);			{ Fenster soll geschlossen werden }
		ELSE BEGIN
			ad_service := FALSE;		{ Message nicht bearbeitet }
			EXIT;
		END;
	END;
	ad_service := TRUE;					{ Message wurde bearbeitet }
END;

{ ----------------------------------------------------------------- }
{ ffne ein Fenster und was sonst noch gemacht werden mu			}
{ ----------------------------------------------------------------- }
FUNCTION ad_make( not_used : POINTER ): AwindowPtr;
VAR		p 		: STRING;
		wi		: AwindowPtr;
		user	: TAd_DbPtr;
BEGIN
	p := fileselect;					{ Datei auswhlen }
	IF (LENGTH(p) <> 0) THEN			{ Wenn eine Datei ausgewhlt }
	BEGIN
		user := Ax_malloc(SizeOf(TAd_Db)); { Speicher fr Userblockrec. bereitstellen }
		IF (user = NIL) THEN
			ad_make := NIL				{ Kein Speicher bekommen }
		ELSE
		BEGIN
			wi := Awi_create(@ADDRESS);	{ Fenster wird erzeugt }
			IF (wi = NIL) THEN
				ad_make := NIL			{ Fehler beim Erzeugen }
			ELSE
			BEGIN
				wi^.user := user;		{ Userblockrec. in Windowrec. sichern }
				user^.path := ' ' + p + CHR(0);
										{ Pfad in Userblockrec. sichern (C-Spez.)}
				Ast_delete(wi^.info);	{ Alten Infotext lschen }
				wi^.info := Ast_create(@user^.path[1]);
										{ Neuen Infotext erzeugen }
										{ Pfad soll Infotext im Fenster sein }
				load(wi);				{ Daten laden }
				ad_set(wi);				{ Daten in den Dialog einsetzen }
				wi^.open(wi);			{ Fenster gleich ffnen }
				ad_make := wi;			{ Adresse d. Windowrecords zurckgeben }
			END;
		END;
	END
	ELSE
		ad_make := NIL;					{ Keine Datei ausgewhlt }
END;

{ ----------------------------------------------------------------- }
{ Initialisieren der Applikation									}
{ ----------------------------------------------------------------- }
FUNCTION init_acs: INTEGER;
VAR		wi 			: AwindowPtr;		{ Erzeuge einen Pointer auf Awindow }
		akt_path	: STRING;			{ Zwischenspeichern des akt. Pfades }
BEGIN
	{ ** Erstmal den aktuellen Pfad ermitteln und sichern ** }
	path := 'A:';						{ Laufwerk vorgeben }
	path[1] := CHR(ORD(path[1]) + Dgetdrv);
										{ Akt. Laufwerk ermitteln }
	Dgetpath(akt_path, 0);				{ Akt. Pfad ermitteln }
	IF (LENGTH(akt_path) = 0) THEN		{ Wenn kein Pfad zurckgegeben }
		akt_path := '\';				{ dann nehmen wir den Obersten }
	path := path + akt_path;			{ Und in die globale Variable kopieren }

	{ ** Nun das Root-Window mit der Create-Routine anmelden ** }
	wi := Awi_root;						{ Hole Pointer auf Rootwindow }
	IF (wi <> NIL) THEN					{ Zeiger OK? }
	BEGIN
		wi^.service (wi, AS_NEWCALL, @@ADDRESS.create);
										{ Routine fr Neu-Ikon einsetzten }
		init_acs := OK;					{ Alles richtig gelaufen }
	END
	ELSE
		init_acs := FAIL;				{ Fehler aufgetreten }
END;

BEGIN									{ Programmstart }
	start_acs(init_acs, @ACSdescr);		{ ACS starten }
END.									{ Programmende }