{
	UNIT AUFM ab for PurePascal
	(c) 1992  Stefan Bachert
	berarbeitet von Michael Schlter (@SL)
	Letzte nderung: 07.01.1993
}

UNIT auf_abm;

{$X+}

INTERFACE

USES GEM, ACS;

CONST	NUM_STRING	= 12345;					{ TYP des Objektes }

{$I AUF_AB.I}									{ Lade ACS-File ein }

{ ----------------------------------------------------------------- }
{ Macht nderung sichtbar											}
{ ----------------------------------------------------------------- }
PROCEDURE update;
BEGIN
	ev_window^.obchange(ev_window, VALUE, ev_window^.work^[VALUE].aes.ob_state);
	{ Das Object VALUE wir neu gezeichnet, da sich ob_state nicht ndert }
END;

{ ----------------------------------------------------------------- }
{ Zhlt den Wert hoch												}
{ ----------------------------------------------------------------- }
PROCEDURE hoch;
var		z,
		res		: INTEGER;
		p		: POINTER;
		st		: STRING;
BEGIN
	GetPText(AESTreePtr(ev_object), VALUE, st);			{ Zahlenstring auslesen }
	VAL(st, z, res);									{ In INTEGER umwandeln }
	IF z < 999 THEN										{ Wert darf 999 nicht berschreiten }
	BEGIN
		INC(z);											{ Um 1 erhhen }
		STR(z, st);										{ INTEGER in STRING umwandeln }
		SetPText(AESTreePtr(ev_object), VALUE, st);		{ Zahlenstring in Object schreiben }
		update;											{ nderung sichtbar machen }
	END;
END;

{ ----------------------------------------------------------------- }
{ Zhlt den Wert runter												}
{ ----------------------------------------------------------------- }
PROCEDURE runter;
var		z,
		res		: INTEGER;
		p		: POINTER;
		st		: STRING;
BEGIN
	GetPText(AESTreePtr(ev_object), VALUE, st);			{ Zahlenstring auslesen }
	VAL(st, z, res);									{ In INTEGER umwandeln }
	IF z > 0 THEN										{ Wert darf 1 nicht unterschreiten }
	BEGIN
		DEC(z);											{ Um 1 verringern }
		STR(z, st);										{ INTEGER in STRING umwandeln }
		SetPText(AESTreePtr(ev_object), VALUE, st);		{ Zahlenstring in Object schreiben }
		update;											{ nderung sichtbar machen }
	END;
END;

{ ----------------------------------------------------------------- }
{ Erfrage neuen Wert												}
{ ----------------------------------------------------------------- }
PROCEDURE neuer(window : AWindowPtr);
VAR		dia		: ACSTreePtr;
		st		: STRING;
BEGIN
	dia := Aob_create(@NEU_DIA);						{ Erzeuge Dialog }
	IF dia <> NIL THEN									{ Wenn Ok dann }
	BEGIN
		GetPText(AESTreePtr(window^.work), VALUE, st);	{ Lese akt. Zahlenwert aus }
		SetPText(AESTreePtr(dia), DIA_VAL, st);			{ Trage Zahlenwert ein }
		IF DIA_OK = A_dialog(dia) THEN					{ Dialog abarbeiten }
		BEGIN											{ Wenn OK-Button }
			GetPText(AESTreePtr(dia), DIA_VAL, st);		{ Lese Zahlenwert aus Dialogbox }
			SetPText(AESTreePtr(window^.work), VALUE, st);
														{ und trage in auf-ab ein }
			window^.obchange(window, VALUE, window^.work^[VALUE].aes.ob_state);
														{ nderung sichtbar machen }
		END;
		Aob_delete(dia);								{ Dialog wieder freigeben }
	END
END;

{ ----------------------------------------------------------------- }
{ Frage nach Wert													}
{ ----------------------------------------------------------------- }
PROCEDURE frage;
BEGIN
	neuer(ev_window);
END;

{ ----------------------------------------------------------------- }
{ Frage nach Wert													}
{ ----------------------------------------------------------------- }
PROCEDURE tasten(wi: AwindowPtr; kstate, key: Integer);
BEGIN
	neuer(wi);
END;

{ ----------------------------------------------------------------- }
{ Empfngt Wert														}
{ ----------------------------------------------------------------- }
PROCEDURE hole_wert(window: AWindowPtr);
VAR		nr		: INTEGER;
		st		: STRING;
BEGIN
	Aselect^.next := 0;							{ Erste Objekt der Liste lesen }
	nr := Adr_next;								{ Selektiertes Objekt ermitteln }
	IF nr >= 0 THEN								{ Wenn ein Objekt selektiert }
	BEGIN
		IF Aselect^.window^.work^[nr + 1].acs.aob_type = NUM_STRING THEN
												{ Wenn Objekt ein NUM_STRING }
			IF Aselect^.window <> window THEN	{ Wenn nicht auf das gleiche Fenster }
			BEGIN
				GetPText(AESTreePtr(Aselect^.window^.work), nr, st);
												{ Lese Zahlenstring aus 'von' Objekt }
				SetPText(AESTreePtr(window^.work), VALUE, st);
												{ Schreibe Zahlenstring in 'nach' Objekt }
				Adr_del(Aselect^.window, nr);	{ Lsche Objekt aus der Liste }
				window^.obchange(window, VALUE, window^.work^[VALUE].aes.ob_state);
			END;								{ nderung sichtbar machen }
		IF Aselect^.window^.work^[nr + 1].acs.aob_type = AT_NEW THEN
		BEGIN									{ Wenn Objekt das NEU-Ikon }
			Adr_del(Aselect^.window, nr);		{ Lsche Objekt aus der Liste }
			neuer(window);						{ Erfrage neuen Wert }
		END;
	END;
END;

{ ----------------------------------------------------------------- }
{ Empfang durch Object												}
{ ----------------------------------------------------------------- }
PROCEDURE neuer_wert;
BEGIN
	hole_wert(ev_window);
END;

{ ----------------------------------------------------------------- }
{ Erzeuge Fenster													}
{ ----------------------------------------------------------------- }
FUNCTION updown_make(para: Pointer): AwindowPtr;
VAR		wi		: AwindowPtr;
BEGIN
	wi := Awi_create (@FENSTER);				{ Erzeuge Fenster }
	IF wi <> NIL THEN							{ Wenn OK }
	BEGIN
		wi^.work^[VALUE + 1].acs.userp1 := POINTER(wi^.work^[VALUE].aes.ob_spec.ted_info^.te_ptext);
												{ POINTER userp1 zeigt auf Zahlenstring }
		wi^. open (wi);							{ ffne das Fenster }
	END;
	updown_make := wi;							{ und zurck }
END;

{ ----------------------------------------------------------------- }
{ Lschen															}
{ ----------------------------------------------------------------- }
PROCEDURE delete(window: AWindowPtr);
BEGIN
	Adr_unselect;								{ Auswahlliste lschen }
	SetPtext(AESTreePtr(window^.work), VALUE, '0');{ Zahlenstring = 0 }
	window^.obchange(window, VALUE, window^.work^[VALUE].aes.ob_state);
												{ nderung sichtbar machen }
END;

{ ----------------------------------------------------------------- }
{ service Routine													}
{ ----------------------------------------------------------------- }
Function updown_service (wi: AwindowPtr; task: Integer; in_out: Pointer): Boolean;
BEGIN
	CASE task OF
		AS_TERM:	Awi_delete(wi);				{ Nun ist Schlu }
		AS_DRAGGED:	hole_wert(wi);				{ gezogene Objekt als Icon empfangen }
		AS_DELETE:	delete(wi);					{ Wert auf Null setzten (lschen) }
		AS_INFO:	A_dialog(@INFOBOX);			{ Info anzeigen }
		ELSE
		BEGIN
			updown_service := FALSE;			{ task konnte nicht bearbeitet werden }
			EXIT;								{ Abbrechen }
		END;
	END;
	updown_service := TRUE;						{ task wurde bearbeitet }
END;

BEGIN
END.