{
	UNIT DEPENDM ab for PurePascal
	(c) 1992  Stefan Bachert
	PURE PASCAL Version: Michael Schlter (@SL)
	Letzte nderung: 04.01.1993
}
UNIT dependm;

{$X+}

INTERFACE

USES ACS;

VAR 	slavew		: AWindowPtr;				{ Globale Variablen }

{$I DEPEND.I}									{ Lade ACS-File ein }

VAR		slave_count	: INTEGER;					{ Lokale Variable }

{ ----------------------------------------------------------------- }
{ Erzeuge Slave Fenster												}
{ ----------------------------------------------------------------- }
FUNCTION slave_make(para: Pointer): AwindowPtr;
BEGIN
	slave_make := Awi_create (@SLAVE);					{ Erzeuge Fenster }
END;

{ ----------------------------------------------------------------- }
{ ffne Slave Fenster												}
{ ----------------------------------------------------------------- }
FUNCTION slave_open(wi: AWindowPtr) : INTEGER;
BEGIN
	IF slave_count > 0 THEN
		slave_open := OK						{ Fenster schon offen }
	ELSE
		slave_open := Awi_open(wi);				{ ffne Fenster }
	INC(slave_count);
END;

{ ----------------------------------------------------------------- }
{ Schliee Slave Fenster											}
{ ----------------------------------------------------------------- }
PROCEDURE slave_closed(wi: AWindowPtr);
BEGIN
	DEC(slave_count);
	IF slave_count = 0 THEN						{ Fenster noch offen }
	BEGIN
		slave_count := 0;						{ Falls < 0 }
		wi^.state := wi^.state OR AWS_TERM;		{ verhindert Zeichnen d. Icons }
		Awi_closed(wi);							{ Schliee Fenster }
		wi^.state := wi^.state AND NOT AWS_TERM;{ Flag wieder lschen }
	END;
END;

{ ----------------------------------------------------------------- }
{ Service Slave Routine												}
{ ----------------------------------------------------------------- }
Function slave_service (wi: AwindowPtr; task: Integer; in_out: Pointer): Boolean;
VAR		root	: AWindowPtr;
BEGIN
	CASE task OF
		AS_TERM:		IF appexit > 0 THEN
							Awi_delete(wi);		{ Nun ist Schlu }
		AS_ACCLOSED:	BEGIN
							slave_count := 0;	{ Zhler 0-setzten }
							IF wi^.icon >= 0 THEN
							BEGIN				{ Nun doch Iconifiziert }
								root := Awi_root;{ Pointer auf Rootfenster holen }
								root^.service(root, AS_REMICON, @wi^.icon);
							END;				{ Ikone freigeben }
						END
		ELSE
		BEGIN
			slave_service := FALSE;				{ task konnte nicht bearbeitet werden }
			EXIT;								{ Abbrechen }
		END;
	END;
	slave_service := TRUE;						{ task wurde bearbeitet }
END;

{ ----------------------------------------------------------------- }
{ Erzeuge Master Fenster											}
{ ----------------------------------------------------------------- }
FUNCTION master_make(para: Pointer): AwindowPtr;
VAR		wi		: AwindowPtr;
BEGIN
	wi := Awi_create (@MASTER);					{ Erzeuge Fenster }
	IF wi <> NIL THEN
		wi^.open(wi);							{ ffne das Fenster gleich }
	master_make := wi;							{ und zurck }
END;

{ ----------------------------------------------------------------- }
{ ffne Master Fenster												}
{ ----------------------------------------------------------------- }
FUNCTION master_open(wi: AWindowPtr) : INTEGER;
BEGIN
	IF Awi_open(wi) = OK THEN				{ Wenn das Master-Fenster geffnet wurde }
		IF slavew^.open(slavew) = FAIL THEN	{ Wenn das Slave-Fenster nicht geffnet werden konnte }
		BEGIN
			wi^.closed(wi);					{ Schliee das Master-Fenster }
			master_open := FAIL;			{ Fehler }
		END
		ELSE
			master_open := OK				{ Sonst alles OK }
	ELSE
		master_open := FAIL;				{ Fehler * konnte Masterfenster nicht ffnen }
END;

{ ----------------------------------------------------------------- }
{ Schliee Master Fenster											}
{ ----------------------------------------------------------------- }
PROCEDURE master_closed(wi: AWindowPtr);
BEGIN
	Awi_closed(wi);							{ schliee Fenster }
	slavew^.closed(slavew);					{ schliee vielleicht Slave-Fenster }
END;

{ ----------------------------------------------------------------- }
{ Service Master Routine											}
{ ----------------------------------------------------------------- }
Function master_service (wi: AwindowPtr; task: Integer; in_out: Pointer): Boolean;
BEGIN
	CASE task OF
		AS_TERM:		Awi_delete(wi);			{ Nun ist Schlu }
		AS_ICONIZED:	slavew^.closed(slavew)	{ schliee Slavefenster? }
		ELSE
		BEGIN
			master_service := FALSE;			{ task konnte nicht bearbeitet werden }
			EXIT;								{ Abbrechen }
		END;
	END;
	master_service := TRUE;						{ task wurde bearbeitet }
END;

{ ----------------------------------------------------------------- }
{ Erzeuge Desk														}
{ ----------------------------------------------------------------- }
FUNCTION make_desk(para: Pointer): AwindowPtr;
BEGIN
	make_desk := Awi_create(@DESK);				{ Erzeuge Fenster }
END;

{ ----------------------------------------------------------------- }
{ Desk-Menu 'QUIT'													}
{ ----------------------------------------------------------------- }
PROCEDURE quit;
BEGIN
	Awi_sendall(AS_TERM, NIL);					{ Alle Fenster sollen sich schlieen }
	Aev_quit;									{ Programm wird beendet }
END;

{ ----------------------------------------------------------------- }
{ DESK-Menu 'NEU'													}
{ ----------------------------------------------------------------- }
PROCEDURE neu;
BEGIN
	MASTER.create(NIL);
END;

BEGIN
	slave_count := 0;						{Zhler 0-setzten }
END.