{
	UNIT MENUEM ab for PurePascal
	(c) 1992  Stefan Bachert
	PURE PASCAL Version: Michael Schlter (@SL)
	Letzte nderung: 02.01.1993
}
{ ACHTUNG: Bis zur jetztigen PP Version (07.11.92) gibt die XOR-Verknpfung
  in set_menu einen Internal error. Ich hoffe der Fehler ist in einer der
  nchsten Versionen behoben. Zum Testen kann eine andere Verknpfung ein-
  gesetzt werden, z.B. AND, OR.
  (In der Version vom Dez. 92 soll der Fehler behoben sein)
}
UNIT menuem;

{$X+}

INTERFACE

USES GEM, ACS;

CONST	OBJ_1		= 1;						{ OBJ_1 ist Button mit Objektnr. 1 }
		OBJ_2		= 2;
		OBJ_3		= 3;
		OBJ_4		= 4;

{$I MENUE.I}									{ Lade ACS-File ein }

{ ----------------------------------------------------------------- }
{ Setze Meneintrge je nach selektiertem Objekt					}
{ ----------------------------------------------------------------- }
PROCEDURE set_menu(wi: AWindowPtr);
VAR		nr,
		count		: INTEGER;
		o1,	o2,	o3,
		o4			: BOOLEAN;
BEGIN
	count := 0; o1 := FALSE; o2 := FALSE; o3 := FALSE; o4 := FALSE;
	Aselect^.next := 0;							{ Liste von vorne lesen }
	nr := Adr_next;								{ Erste Objekt holen }
	WHILE nr >= 0 DO							{ Wenn noch ein Objekt in der Liste }
	BEGIN
		INC(count);								{ Erhhe Zhler }
		CASE wi^.work^[nr+1].acs.aob_type OF	{ Setzte Flag des jeweiligen Objektes }
			OBJ_1:		o1 := TRUE;
			OBJ_2:		o2 := TRUE;
			OBJ_3:		o3 := TRUE;
			OBJ_4:		o4 := TRUE;
		END;
		nr := Adr_next;							{ Nchste Objekt aus der Liste holen }
	END;
	IF count = 0 THEN							{ Wenn kein Objekt selektiert }
		wi^.menu^[SEL_0].aes.ob_state := wi^.menu^[SEL_0].aes.ob_state AND (NOT DISABLED)
	ELSE
		wi^.menu^[SEL_0].aes.ob_state := wi^.menu^[SEL_0].aes.ob_state OR DISABLED;
	IF count = 1 THEN							{ Wenn ein Objekt selektiert }
		wi^.menu^[SEL_1].aes.ob_state := wi^.menu^[SEL_1].aes.ob_state AND (NOT DISABLED)
	ELSE
		wi^.menu^[SEL_1].aes.ob_state := wi^.menu^[SEL_1].aes.ob_state OR DISABLED;
	IF count > 0 THEN							{ Wenn Objekt(e) selektiert }
		wi^.menu^[SEL_ANY].aes.ob_state := wi^.menu^[SEL_ANY].aes.ob_state AND (NOT DISABLED)
	ELSE
		wi^.menu^[SEL_ANY].aes.ob_state := wi^.menu^[SEL_ANY].aes.ob_state OR DISABLED;
	IF o1 THEN									{ Wenn Objekt 1 selektiert }
		wi^.menu^[OBJ1].aes.ob_state := wi^.menu^[OBJ1].aes.ob_state AND (NOT DISABLED)
	ELSE
		wi^.menu^[OBJ1].aes.ob_state := wi^.menu^[OBJ1].aes.ob_state OR DISABLED;
	IF o2 THEN									{ Wenn Objekt 2 selektiert }
		wi^.menu^[OBJ2].aes.ob_state := wi^.menu^[OBJ2].aes.ob_state AND (NOT DISABLED)
	ELSE
		wi^.menu^[OBJ2].aes.ob_state := wi^.menu^[OBJ2].aes.ob_state OR DISABLED;
	IF o2 AND o3 THEN							{ Wenn Objekt 2 und Objekt 3 selektiert }
		wi^.menu^[OBJ23].aes.ob_state := wi^.menu^[OBJ23].aes.ob_state AND (NOT DISABLED)
	ELSE
		wi^.menu^[OBJ23].aes.ob_state := wi^.menu^[OBJ23].aes.ob_state OR DISABLED;
	IF NOT o4 THEN								{ Wenn nicht Objekt 4 selektiert }
		wi^.menu^[OBJnot4].aes.ob_state := wi^.menu^[OBJnot4].aes.ob_state AND (NOT DISABLED)
	ELSE
		wi^.menu^[OBJnot4].aes.ob_state := wi^.menu^[OBJnot4].aes.ob_state OR DISABLED;
	IF o3 xor o4 THEN							{ Wenn Objekt 3 oder Objekt 4 selektiert }
		wi^.menu^[OBJxor34].aes.ob_state := wi^.menu^[OBJxor34].aes.ob_state AND (NOT DISABLED)
	ELSE
		wi^.menu^[OBJxor34].aes.ob_state := wi^.menu^[OBJxor34].aes.ob_state OR DISABLED;
END;

{ ----------------------------------------------------------------- }
{ Erzeuge Fenster													}
{ ----------------------------------------------------------------- }
FUNCTION menu_make(para: Pointer): AwindowPtr;
VAR		wi		: AwindowPtr;
BEGIN
	wi := Awi_create (@DEMO);					{ Erzeuge Fenster }
	IF wi <> NIL THEN							{ Wenn OK }
		wi^. open (wi);							{ ffne das Fenster }
	menu_make := wi;							{ und zurck }
END;

{ ----------------------------------------------------------------- }
{ Service Routine													}
{ ----------------------------------------------------------------- }
Function menu_service (wi: AwindowPtr; task: Integer; in_out: Pointer): Boolean;
BEGIN
	CASE task OF
		AS_TERM:		Awi_delete(wi);			{ Nun ist Schlu }
		AS_SELECTDEL,
		AS_SELECTADD:	set_menu(wi);			{ verndert Menuzeile }
		AS_DELETE:		Adr_unselect;			{ Wert auf Null setzten (lschen) }
		ELSE
		BEGIN
			menu_service := FALSE;				{ task konnte nicht bearbeitet werden }
			EXIT;								{ Abbrechen }
		END;
	END;
	menu_service := TRUE;						{ task wurde bearbeitet }
END;

BEGIN
END.