{	Beispielapplikation fr ACS
	"Hello World" mit eigenem Desktop
	20.12.92 Stefan Bachert (Pure C)
	06.10.92 Michael Schlter (Pure Pascal)
	Letzte nderung: 01.01.93
}

PROGRAM hello_world;					{ Programmname }

{$X+}				{ Functionen knnen ohne Resultat aufgerufen werden }

USES ACS, GEM;							{ bentigte Units }

PROCEDURE any_where; FORWARD;			{ Definitionen werden schon }
PROCEDURE new_window; FORWARD;			{ in DESK.I bentigt }
FUNCTION desk_make(not_used : POINTER) : AWindowPtr; FORWARD;
FUNCTION hello_make( not_used : POINTER) : AWindowPtr; FORWARD;
FUNCTION desk_service( window : AWindowPtr; task : INTEGER; in_out : POINTER) : BOOLEAN; FORWARD;
PROCEDURE about; FORWARD;
PROCEDURE quit; FORWARD;

{$I DESK.I}								{ einladen der Definitionen }

{ ---------------------------------------------------------	}
{ Die About Me Dialogbox wird ausgegeben					}
{ ---------------------------------------------------------	}
PROCEDURE about;
BEGIN
	ACSBlk^.ACSaboutme;
END;

{ ---------------------------------------------------------	}
{ Das Programm wird beendet									}
{ ---------------------------------------------------------	}
PROCEDURE quit;
BEGIN
	ACSBlk^.ACSclose;
END;

{ ---------------------------------------------------------	}
{ Erzeugt bei Drcken des Mausbuttons ein Popupmenu			}
{ ---------------------------------------------------------	}
PROCEDURE any_where;
BEGIN
	Ame_popup(ev_window, @ask, -1, -1);	{ Popupmenu aufbauen }
END;

{ ---------------------------------------------------------	}
{ Button auf Desktop wurde gedrckt							}
{ ---------------------------------------------------------	}
PROCEDURE new_window;
BEGIN
	HELLO.create(NIL);					{ Erzeugt ein Hallo-Fenster }
END;

{ ---------------------------------------------------------	}
{ Erzeuge den Desktop										}
{ ---------------------------------------------------------	}
FUNCTION desk_make(not_used : POINTER) : AWindowPtr;
VAR		wi	: AWindowPtr;				{ Pointer auf Fensterrecord }
BEGIN
	wi := Awi_create(@MY_DESK);			{ Erzeuge Fenster }
	IF (wi = NIL) THEN					{ Wenn nicht mglich }
		desk_make := NIL				{ Dann Error }
	ELSE
	BEGIN
		IF (wi^.work = NIL) THEN		{ Wenn kein Arbeitsobject }
			desk_make := wi				{ Pointer des Fensterrecords zurckgeben }
		ELSE
		BEGIN
			IF (application <> 0) THEN	{ Wenn als ACC gestartet }
			BEGIN						{ Desktop an Fensterkoordinaten anpassen }
				wi^.work^[0].aes.ob_x := ACSblk^.desk.x;
				wi^.work^[0].aes.ob_y := ACSblk^.desk.y;
				wi^.work^[0].aes.ob_width := ACSblk^.desk.w;
				wi^.work^[0].aes.ob_height := ACSblk^.desk.h;
			END
			ELSE
			BEGIN						{ Sonst alle auf Null setzten }
				wi^.work^[0].aes.ob_x := 0;
				wi^.work^[0].aes.ob_y := 0;
				wi^.work^[0].aes.ob_width := 0;
				wi^.work^[0].aes.ob_height := 0;
			END;
			desk_make := wi				{ Pointer des Fensterrecords zurckgeben }
		END;
	END; 
END;

{ ---------------------------------------------------------	}
{ Erzeuge Hello-World Fenster								}
{ ---------------------------------------------------------	}
FUNCTION hello_make( not_used : POINTER) : AWindowPtr;
VAR		wi	: AWindowPtr;				{ Pointer auf Fensterrecord }
BEGIN
	wi := Awi_create(@HELLO);			{ Erzeuge Fenster }
	IF (wi = NIL) THEN					{ Wenn nicht mglich }
		hello_make := NIL				{ Dann ein Fehler }
	ELSE
	BEGIN
		IF (wi^.open(wi) <> 0) THEN		{ Sonst ffne Fenster }
		BEGIN
			Awi_delete(wi);				{ Wenn nicht mglich, dann lsche Fenster wieder }
			hello_make := NIL;			{ Und Fehler zurckgeben }
		END
		ELSE
			hello_make := wi;			{ Sonst Pointer des Fensterrecords zurckgeben }
	END; 
END;

{ ---------------------------------------------------------	}
{ Lsche ein Fenster										}
{ ---------------------------------------------------------	}
PROCEDURE term(window : AWindowPtr);
BEGIN
	IF (application <> 0) THEN			{ Wenn als ACC gestartet }
		Awi_delete(window)				{ Fenster wird gelscht }
	ELSE
		Awi_closed(window);				{ Sonst: Fenster wird Iconifiziert }
END;

{ ---------------------------------------------------------	}
{ Function, die die Nachrichten vom ACS bearbeitet			}
{ ---------------------------------------------------------	}
FUNCTION desk_service( window : AWindowPtr; task : INTEGER; in_out : POINTER) : BOOLEAN;
BEGIN
	CASE task OF
		AS_TERM: term(window);			{ Fenster soll geschlossen werden }
		ELSE BEGIN
			desk_service := FALSE;		{ Message wurde nicht bearbeitet }
			EXIT;
		END;
	END;
	desk_service := TRUE;				{ Message wurde bearbeitet }
END;


{ ---------------------------------------------------------	}
{ Initialisieren der Applikation							}
{ ---------------------------------------------------------	}
FUNCTION init_acs : INTEGER;
VAR		window	: AWindowPtr;			{ Pointer auf Fensterrecord }
BEGIN
	window := Awi_root;					{ Hole Pointer auf Rootfenster }
	IF (window <> NIL) THEN				{ Pointer vorhanden? }
	BEGIN
		window^.service(window, AS_NEWCALL, @@HELLO.create);
										{ Routine fr Neu-Ikon einsetzten }
		window := @HELLO;				{ Hole Pointer auf Hallo-World-Fenster }
		window^.create(NIL);			{ Fenster sofort erzeugen }
		init_acs := OK;					{ Alles richtig gelaufen }
	END
	ELSE
		init_acs := FAIL;				{ Fehler aufgetreten }
END;

BEGIN									{ Programmstart }
	start_acs(init_acs, @ACSdescr);		{ ACS starten }
END.									{ Programmende }