{
	UNIT PLOTM ab for PurePascal
	(c) 1992  Stefan Bachert
	PURE PASCAL Version: Michael Schlter (@SL)
	Letzte nderung: 04.01.1993
}

UNIT plotm;

{$X+}

INTERFACE

USES GEM, ACS;

VAR		plotterw	: AWindowPtr;				{ Globale Vairable }

{$I PLOT.I}										{ Lade ACS-File ein }

VAR		count,
		update		: INTEGER;					{ Lokale Varaiable }

{ ----------------------------------------------------------------- }
{ Lscht den Inhalt des Plot-Fensters								}
{ ----------------------------------------------------------------- }
PROCEDURE clear;
BEGIN
	IF plotterw <> NIL THEN
	BEGIN
		w_clr(plotterw);
		w_update(plotterw);
	END;
END;

{ ----------------------------------------------------------------- }
{ Mal eine RECHTECK													}
{ ----------------------------------------------------------------- }
PROCEDURE area;
VAR		handle		: INTEGER;
		pxy			: ARRAY_8;
BEGIN
	IF plotterw <> NIL THEN
	BEGIN
		count := 50;							{ Wartezeit bis zum nchsten Plot }
		plotterw^.service(plotterw, AS_PLOTHANDLE, @handle);
												{ Ermittle akt. VDI-Handle }
		pxy[0] := Random(63) SHL 2;				{ Zufllige Koordinaten ermitteln }
		pxy[1] := Random(63) SHL 2;
		pxy[2] := pxy[0] + (Random(15) SHL 2) + 15;
		pxy[3] := pxy[1] + (Random(15) SHL 2) + 15;		
		vswr_mode(handle, MD_REPLACE);			{ Flche ersetzt Hintergrund }
		vsf_color(handle, Random(ncolors - 1) +1); { Farbe d. Flche }
		vsf_interior(handle, FIS_PATTERN);		{ Flche hat Muster }
		vsf_style(handle, Random(15) + 1);		{ Flchenstyle }
		vsf_perimeter(handle, 1);				{ Umrandung an }
		w_bar(plotterw, pxy);					{ zeichnet ausgeflltes Rechteck }
		w_update(plotterw);						{ Frischt die Anzeige auf. }
	END;
END;

{ ----------------------------------------------------------------- }
{ Gibt einen Text aus												}
{ ----------------------------------------------------------------- }
PROCEDURE ptext;
VAR		handle,
		point,
		temp,
		x,
		y			: INTEGER;
		name		: STRING32;
BEGIN
	IF plotterw <> NIL THEN
	BEGIN
		count := 50;							{ Wartezeit bis zum nchsten Plot }
		plotterw^.service(plotterw, AS_PLOTHANDLE, @handle);
												{ Ermittle akt. VDI-Handle }
		vst_font(handle, vqt_name(handle, Random(ACSblk^.fonts) + 1, name));
												{ Whl ein Font aus }
		point := vst_point(handle, 99, temp, temp, temp, temp);
												{ Ermittelt max. Hhe des Zeichensatzes }
		IF (point <= 99) AND (point >= 1) THEN
		BEGIN
			vst_point(handle, point SHR 1, temp, temp, temp,temp);
												{ Setzt Zeichenhhe }
			x := Random(63) SHL 2;
			y := Random(63) SHL 2;
			vswr_mode(handle, MD_REPLACE);		{ Flche ersetzt Hintergrund }
			vst_color(handle, Random(ncolors - 1) +1); { Farbe d. Textes }
			vst_effects(handle, 0);				{ Text hat keine Effekte }
			vst_rotation(handle, 0);			{ Keine Textrotation }
			vst_alignment(handle, 0, 5, temp, temp); { Schriftausrichtung }
			name := 'Textprobe' + #0;			{ Text erstellen }
			w_gtext(plotterw, x, y, @name[1]);{ gibt Text aus }
			w_update(plotterw);					{ Frischt die Anzeige auf. }
		END;
	END;
END;

{ ----------------------------------------------------------------- }
{ Mal einen Kreis													}
{ ----------------------------------------------------------------- }
PROCEDURE pcircle;
VAR		handle,
		x,
		y,
		xrad,
		yrad		: INTEGER;
BEGIN
	IF plotterw <> NIL THEN
	BEGIN
		count := 50;							{ Wartezeit bis zum nchsten Plot }
		plotterw^.service(plotterw, AS_PLOTHANDLE, @handle);
												{ Ermittle akt. VDI-Handle }
		x := Random(63) SHL 2;					{ Zufllige Koordinaten ermitteln }
		y := Random(63) SHL 2;
		xrad := (Random(15) SHL 1) + 7;
		yrad := (Random(15) SHL 1) + 7;		
		vswr_mode(handle, MD_REPLACE);			{ Kreis ersetzt Hintergrund }
		vsf_color(handle, Random(ncolors - 1) +1); { Farbe d. Flche }
		vsf_interior(handle, FIS_PATTERN);		{ Flche hat Muster }
		vsf_style(handle, Random(15) + 1);		{ Flchenstyle }
		vsf_perimeter(handle, 1);				{ Umrandung an }
		w_ellipse(plotterw, x, y, xrad, yrad);	{ zeichnet ausgefllten Kreis }
		w_update(plotterw);						{ Frischt die Anzeige auf. }
	END;
END;

{ ----------------------------------------------------------------- }
{ Mal eine kleine Plots												}
{ ----------------------------------------------------------------- }
FUNCTION plot_init(wi: AWindowPtr): INTEGER;
VAR		handle,
		x,
		y			: INTEGER;
BEGIN
	wi^.state := wi^.state OR AWS_LATEUPDATE;
	IF plotterw <> NIL THEN
	BEGIN
		DEC(count);
		IF count <= 0 THEN
		BEGIN
			count := 0;							{ Falls < 0 }
			plotterw^.service(plotterw, AS_PLOTHANDLE, @handle);
												{ Ermittle akt. VDI-Handle }
			x := Random(63) SHL 2;				{ Zufllige Koordinaten ermitteln }
			y := Random(63) SHL 2;
			vswr_mode(handle, MD_REPLACE);		{ Kreis ersetzt Hintergrund }
			vsf_color(handle, BLACK);			{ Farbe d. Flche }
			vsf_interior(handle, FIS_HOLLOW);	{ Kreis hat kein Muster }
			vsf_perimeter(handle, 1);			{ Umrandung an }
			w_circle(plotterw, x, y, 5);		{ zeichnet Kreis }
			DEC(update);
			IF update <= 0 THEN
			BEGIN
				update := 5;
				w_update(plotterw);				{ Frischt die Anzeige auf. }
			END;
		END;
	END;
	plot_init := OK;
END;

{ ----------------------------------------------------------------- }
{ Erstellt ein Fenster												}
{ ----------------------------------------------------------------- }
FUNCTION plot_make(para: Pointer): AwindowPtr;
VAR		wi		: AwindowPtr;
BEGIN
	wi := Awi_create (@CONTROL);				{ Erzeuge Fenster }
	IF wi <> NIL THEN							{ Wenn OK }
		wi^. open (wi);							{ ffne das Fenster }
	plot_make := wi;							{ und zurck }
END;

BEGIN
	Randomize;
	update := 0;
END.