/*
 * aes.h - AES interface header file
 *
 * Started 16/9/89 Alex G. Kiernan
 *
 * Copyright (c) 1989 HiSoft
 */

#ifndef _AES_H
#define _AES_H

short __regargs _AESif(unsigned short);

extern void *_AESpb[6];

extern short _AEScontrol[5];
extern short _AESglobal[15];
extern short _AESintin[16];
extern short _AESintout[7];
extern void *_AESaddrin[3];
extern void *_AESaddrout[1];

/* Application library definitions */
typedef struct
{
	long ap_event;
	long ap_value;
} EVNTREC;

short appl_init(void);
#define appl_init() _AESif(0)
short appl_read(short,short,void *);
short appl_write(short,short,void *);
short appl_find(const char *);
#define appl_find(a)	(_AESaddrin[0]=(void *)(a),_AESif(12))
short appl_tplay(EVNTREC *,short,short);
short appl_trecord(EVNTREC *,short);
short appl_exit(void);
#define appl_exit()	_AESif(36)

/* Event library definitions */
#define MU_KEYBD	0x0001	
#define MU_BUTTON	0x0002
#define MU_M1		0x0004
#define MU_M2		0x0008
#define MU_MESAG	0x0010
#define MU_TIMER	0x0020

#define K_RSHIFT	0x0001
#define K_LSHIFT	0x0002
#define K_CTRL		0x0004
#define K_ALT		0x0008

#define MN_SELECTED	10

#define WM_REDRAW	20
#define WM_TOPPED	21
#define WM_CLOSED	22
#define WM_FULLED	23
#define WM_ARROWED	24
#define WM_HSLID	25
#define WM_VSLID	26
#define WM_SIZED	27
#define WM_MOVED	28
#define WM_NEWTOP	29

#define AC_OPEN		40
#define AC_CLOSE	41

#define CT_UPDATE	50
#define CT_MOVE		51
#define CT_NEWTOP	52
#define CT_KEY		53

#define WA_UPPAGE	0
#define WA_DNPAGE	1
#define WA_UPLINE	2
#define WA_DNLINE	3
#define WA_LFPAGE	4
#define WA_RTPAGE	5
#define WA_LFLINE	6
#define WA_RTLINE	7

typedef struct moblk
{
	short m_out;
	short m_x;
	short m_y;
	short m_w;
	short m_h;
} MOBLK;

short evnt_keybd(void);
#define evnt_keybd()	_AESif(40)
short evnt_button(short,short,short,short *,short *,short *,short *);
short evnt_mouse(short,short,short,short,short,short *,short *,short *,short *);
short evnt_mesag(short *);
#define evnt_mesag(a)	(_AESaddrin[0]=(a),_AESif(52))
short evnt_timer(short,short);
short evnt_multi(short,short,short,short,short,short,short,short,short,short,short,short,short,short,short *,short,short,short *,short *,short *,short *,short *,short *);
short evnt_dclick(short,short);

/* Object library definitions */
#define ROOT		0
#define NIL			-1

#define MAX_DEPTH	8	/* max depth of search or draw */
					
#define IP_HOLLOW	0	/* inside patterns */
#define IP_1PATT	1
#define IP_2PATT	2
#define IP_3PATT	3
#define IP_4PATT	4
#define IP_5PATT	5
#define IP_6PATT	6
#define IP_SOLID	7
					
#define IBM			3	/* font types */
#define SMALL		5
						
#define G_BOX		20	/* Graphic types of obs	*/
#define G_TEXT		21
#define G_BOXTEXT	22
#define G_IMAGE		23
#define G_PROGDEF	24
#define	G_USERDEF	G_PROGDEF
#define G_IBOX		25
#define G_BUTTON	26
#define G_BOXCHAR	27
#define G_STRING	28
#define G_FTEXT		29
#define G_FBOXTEXT	30
#define G_ICON		31
#define G_TITLE		32
						
#define NONE		0x0000	/* Object flags	*/
#define SELECTABLE	0x0001
#define DEFAULT		0x0002
#define EXIT		0x0004
#define EDITABLE	0x0008
#define RBUTTON		0x0010
#define LASTOB		0x0020
#define TOUCHEXIT	0x0040
#define HIDETREE	0x0080
#define INDIRECT	0x0100

#define NORMAL		0x0000	/* Object states */
#define SELECTED	0x0001
#define CROSSED		0x0002
#define CHECKED		0x0004
#define DISABLED	0x0008
#define OUTLINED	0x0010
#define SHADOWED	0x0020
#define SPECIAL		0x0040	/* user defined object state */

#define WHITE		0	/* Object colors */
#define BLACK		1
#define RED			2
#define GREEN		3
#define BLUE		4
#define CYAN		5
#define YELLOW		6
#define MAGENTA		7
#define LWHITE		8
#define LBLACK		9
#define LRED		10
#define LGREEN		11
#define LBLUE		12
#define LCYAN		13
#define LYELLOW		14
#define LMAGENTA	15
					
#define TE_LEFT		0	/* editable text justification */
#define TE_RIGHT	1
#define TE_CNTR		2

typedef struct {
	char *te_ptext;
	char *te_ptmplt;
	char *te_pvalid;
	short te_font;
	short te_junk1;
	short te_just;
	short te_color;
	short te_junk2;
	short te_thickness;
	short te_txtlen;
	short te_tmplen;
} TEDINFO;

typedef struct {
	short *ib_pmask;
	short *ib_pdata;
	char  *ib_ptext;
	short ib_char;
	short ib_xchar;
	short ib_ychar;
	short ib_xicon;
	short ib_yicon;
	short ib_wicon;
	short ib_hicon;
	short ib_xtext;
	short ib_ytext;
	short ib_wtext;
	short ib_htext;
} ICONBLK;

typedef struct {
	short *bi_pdata;
	short bi_wb;
	short bi_hl;
	short bi_x;
	short bi_y;
	short bi_color;
} BITBLK;

struct __object;

typedef struct {
	struct __object *pb_tree;
	short pb_obj;
	short pb_prevstate;
	short pb_currstate;
	short pb_x;
	short pb_y;
	short pb_w;
	short pb_h;
	short pb_xc;
	short pb_yc;
	short pb_wc;
	short pb_hc;
	long pb_parm;
} PARMBLK;

/* Lattice 3 flavour */
typedef struct {
	short (*__stdargs ub_code)(PARMBLK *);
	long ub_parm;
} USERBLK;

/* Rest of the world flavour */
typedef struct {
	short (*__stdargs ab_code)(PARMBLK *);
	long ab_parm;
} APPLBLK;


typedef union obspecp {
        long     index;
        char    *free_string;
        TEDINFO  *tedinfo;
        ICONBLK  *iconblk;
        BITBLK   *bitblk;
        USERBLK *userblk;
        union obspecp *indirect;
} OBSPEC;


typedef struct __object
{
        short             ob_next;        /* -> object's next sibling     */
        short             ob_head;        /* -> head of object's children */
        short             ob_tail;        /* -> tail of object's children */
        unsigned short    ob_type;        /* object type: BOX, CHAR,...   */
        unsigned short    ob_flags;       /* object flags                 */
        unsigned short    ob_state;       /* state: SELECTED, OPEN, ...   */
        OBSPEC            ob_spec;        /* what ever */
        short             ob_x;           /* upper left corner of object  */
        short             ob_y;           /* upper left corner of object  */
        short             ob_width;       /* object width                 */
        short             ob_height;      /* object height                */
} OBJECT;

typedef struct grect
{
	short g_x;
	short g_y;
	short g_w;
	short g_h;
} GRECT;

short objc_add(OBJECT *,short,short);
short objc_delete(OBJECT *,short);
short objc_draw(OBJECT *,short,short,short,short,short,short);
short objc_find(OBJECT *,short,short,short,short);
short objc_offset(OBJECT *,short,short *,short *);
short objc_order(OBJECT *,short,short);
short objc_edit(OBJECT *,short,short,short *,short);
short objc_change(OBJECT *,short,short,short,short,short,short,short,short);

/* HiSoft extras */
short objc_xywh(OBJECT *,short,GRECT *);
void objc_walk(OBJECT *,short,short,short,short (*)(OBJECT *,short));

/* Menu library definitions */
short menu_bar(OBJECT *, short);
short menu_icheck(OBJECT *,short,short);
short menu_ienable(OBJECT *,short,short);
short menu_tnormal(OBJECT *,short,short);
short menu_text(OBJECT *,short,const char *);
short menu_register(short,const char *);

/* Form library definitions */
#define ED_START	0	/* editable text field definitions */
#define EDSTART	ED_START
#define ED_INIT	1
#define EDINIT	ED_INIT	
#define ED_CHAR	2
#define EDCHAR	ED_CHAR
#define ED_END	3
#define EDEND	ED_END
					
#define FMD_START	0
#define FMD_GROW	1
#define FMD_SHRINK	2
#define FMD_FINISH	3

short form_do(OBJECT *,short);
short form_dial(short,short,short,short,short,short,short,short,short);
short form_alert(short,const char *);
short form_error(short);
#define form_error(a)	(_AESintin[0]=a,_AESif(172))
short form_center(OBJECT *,short *,short *,short *,short *);
short form_keybd(OBJECT *,short,short,short,short *,short *);
short form_button(OBJECT *,short,short,short *);

/* Graphics library definitions */
#define	ARROW		0
#define	TEXT_CRSR	1
#define	HOURGLASS	2
#define	BUSYBEE	HOURGLASS
#define	BUSY_BEE	HOURGLASS
#define	POINT_HAND	3
#define	FLAT_HAND	4
#define	THIN_CROSS	5
#define	THICK_CROSS	6
#define	OUTLN_CROSS	7
#define	USER_DEF	255
#define M_OFF		256
#define M_ON		257

#define VERTICAL	0
#define HORIZONTAL	1

short graf_rubberbox(short,short,short,short,short *,short *);
short graf_dragbox(short,short,short,short,short,short,short,short,short *,short *);
short graf_movebox(short,short,short,short,short,short);
short graf_growbox(short,short,short,short,short,short,short,short);
short graf_shrinkbox(short,short,short,short,short,short,short,short);
short graf_watchbox(OBJECT *,short,short,short);
short graf_slidebox(OBJECT *,short,short,short);
short graf_handle(short *,short *,short *,short *);
short graf_mouse(short,void *);
short graf_mkstate(short *,short *,short *,short *);

/* Scrap library definitions */
short scrp_read(char *);
short scrp_write(const char *);
#define scrp_read(a)	(_AESaddrin[0]=a,_AESif(280))
#define scrp_write(a)	(_AESaddrin[0]=(void *)(a),_AESif(284))

/* File selector library definitions */
short fsel_input(char *,char *,short *);
short fsel_exinput(char *,char *,short *,const char *);

/* Window library definitions */
#define NAME		0x0001
#define CLOSE		0x0002
#define CLOSER		CLOSE
#define FULL		0x0004
#define FULLER		FULL
#define MOVE		0x0008
#define MOVER		MOVE
#define INFO		0x0010
#define SIZE		0x0020
#define SIZER		SIZE
#define UPARROW		0x0040
#define DNARROW		0x0080
#define VSLIDE		0x0100
#define LFARROW		0x0200
#define RTARROW		0x0400
#define HSLIDE		0x0800

#define WF_KIND		1
#define WF_NAME 	2
#define WF_INFO 	3
#define WF_WXYWH	4
#define WF_WORKXYWH	WF_WXYWH
#define WF_CXYWH	5
#define WF_CURRXYWH	WF_CXYWH
#define WF_PXYWH	6
#define WF_PREVXYWH	WF_PXYWH
#define WF_FXYWH	7
#define WF_FULLXYWH	WF_FXYWH
#define WF_HSLIDE	8
#define WF_VSLIDE	9
#define WF_TOP		10
#define WF_FIRSTXYWH	11
#define WF_NEXTXYWH	12
#define WF_IGNORE	13
#define WF_NEWDESK	14
#define WF_HSLSIZE	15
#define WF_HSLSIZ	WF_HSLSIZE
#define WF_VSLSIZE	16
#define	WF_VSLSIZ	WF_VSLSIZE
#define WF_SCREEN	17
#define WF_COLOR	18
#define WF_DCOLOR	19

#define	END_UPDATE	0
#define	BEG_UPDATE	1
#define	END_MCTRL	2
#define	BEG_MCTRL	3

#define WC_BORDER	0
#define WC_WORK		1

#define DESK	0

#define	W_BOX		0
#define W_TITLE		1
#define W_CLOSER	2
#define W_NAME		3
#define W_FULLER	4
#define W_INFO		5
#define W_DATA		6
#define W_WORK		7
#define W_SIZER		8
#define W_VBAR		9
#define W_UPARROW	10
#define W_DNARROW	11
#define W_VSLlDE	12
#define W_VELEV		13
#define W_HBAR		14
#define W_LFARROW	15
#define W_RTARROW	16
#define W_HSLIDE	17
#define W_HELEV		18

short wind_create(short,short,short,short,short);
short wind_open(short,short,short,short,short);
short wind_close(short);
short wind_delete(short);
#define wind_close(a)	(_AESintin[0]=a,_AESif(368))
#define wind_delete(a)	(_AESintin[0]=a,_AESif(372))
short wind_get(short,short,short *,short *,short *,short *);
short wind_set(short,short,...);
short wind_find(short,short);
short wind_update(short);
#define wind_update(a)	(_AESintin[0]=a,_AESif(388))
short wind_calc(short,short,short,short,short,short,short *,short *,short *,short *);
short wind_new(void);
#define wind_new()	_AESif(396)

/*  HiSoft extras */
short wind_newdesk(OBJECT *,short);
short wind_info(short,const char *);
short wind_title(short,const char *);
short wind_redraw(short,GRECT *,short (*)(short,GRECT *));

/* Resource library definitions */
#define R_TREE		0
#define R_OBJECT	1
#define R_TEDINFO	2
#define R_ICONBLK	3
#define R_BITBLK	4
#define R_STRING	5	/* gets pointer to free strings */
#define R_IMAGEDATA	6	/* gets pointer to free images */
#define R_OBSPEC	7
#define R_TEPTEXT	8	/* sub ptrs in TEDINFO */
#define R_TEPTMPLT	9
#define R_TEPVALID	10
#define R_IBPMASK	11	/* sub ptrs in ICONBLK */
#define R_IBPDATA	12
#define R_IBPTEXT	13
#define R_BIPDATA	14	/* sub ptrs in BITBLK */
#define R_FRSTR		15	/* gets addr of ptr to free strings */
#define R_FRIMG		16	/* gets addr of ptr to free images */

typedef struct
{
	short rsh_vrsn;			/* RCS version no. */
	unsigned short rsh_object;	/* offset to object[] */
	unsigned short rsh_tedinfo;	/* offset to tedinfo[] */
	unsigned short rsh_iconblk;	/* offset to iconblk[] */
	unsigned short rsh_bitblk;	/* offset to bitblk[] */
	unsigned short rsh_frstr;		/* offset to free string index */
	unsigned short rsh_string;	/* offset to first string */
	unsigned short rsh_imdata;	/* offset to image data */
	unsigned short rsh_frimg;		/* offset to free image index */
	unsigned short rsh_trindex;	/* offset to object tree index */
	short rsh_nobs;			/* number of objects */
	short rsh_ntree;			/* number of trees */
	short rsh_nted;			/* number of tedinfos */
	short rsh_nib;			/* number of icon blocks */
	short rsh_nbb;			/* number of blt blocks */
	short rsh_nstring;		/* number of free strings */
	short rsh_nimages;		/* number of free images */
	unsigned short rsh_rssize;	/* total bytes in resource */
} RSHDR;

short rsrc_load(const char *);
short rsrc_free(void);
#define rsrc_load(a)	(_AESaddrin[0]=(void *)(a),_AESif(400))
#define rsrc_free()	_AESif(404)
short rsrc_gaddr(short,short,void *);
short rsrc_saddr(short,short,void *);
short rsrc_obfix(OBJECT *,short);

/* Shell library definitions */
short shel_read(char *,char *);
short shel_write(short,short,short,const char *,const char *);
short shel_get(char *,short);
short shel_put(const char *,short);
short shel_find(char *);
#define shel_find(a)	(_AESaddrin[0]=a,_AESif(456))
short shel_envrn(char **, const char *);

/* Rectangle manipulation definitions */
void rc_constrain(const GRECT *,GRECT *);
void rc_copy(const GRECT *,GRECT *);
short rc_equal(const GRECT *,const GRECT *);

/*
 short __builtin_memcmp(const void *, const void *, unsigned long);
*/
#define rc_equal(p1,p2)	(!__builtin_memcmp(p1,p2,sizeof(GRECT)))
short rc_intersect(const GRECT *,GRECT *);
short rc_inside(short,short,const GRECT *);
void rc_union(const GRECT *,GRECT *);
void rc_center(const GRECT *,GRECT *);

/* Macro for Lattice 3 compatability */
#ifdef _SHORTINT
#define ADDR(a) (a)
#else
#define	ADDR(a)	((long)(a)>>16),((long)(a))
#endif

/* Useful AES functions */
#ifndef min
short min(short,short);
short __builtin_min(short,short);
#define min(a,b)	__builtin_min(a,b)
#endif

#ifndef max
short max(short,short);
short __builtin_max(short,short);
#define max(a,b)	__builtin_max(a,b)
#endif

unsigned short umul_div(unsigned short,unsigned short,unsigned short);
#pragma inline d0=umul_div(d0,d1,d2)	{"c0c180c2";}

/* macros to pass parameters */
#ifndef PTRS
#define PTRS(r) (r)->g_x, (r)->g_y, (r)->g_w, (r)->g_h
#endif

#ifndef ELTS
#define ELTS(r) (r).g_x, (r).g_y, (r).g_w, (r).g_h
#endif

#ifndef NULL
#define NULL	((void *)0)
#endif
#endif
