INT16 CDECL A_3Dframe (PARMBLK *pb)
		/*
		 *		Zeichnet 3D-like Rahmen
		 */
{
	INT16 pxy [4], pxy2 [10];
	INT16 col1, col2;

	if (pb-> pb_wc != 0 || pb-> pb_hc != 0) {
		pxy [0] = pb-> pb_xc;
		pxy [1] = pb-> pb_yc;
		pxy [2] = pb-> pb_xc + pb-> pb_wc - 1;
		pxy [3] = pb-> pb_yc + pb-> pb_hc - 1;
		vs_clip (vdi_handle, TRUE, pxy);
	}

	vswr_mode (vdi_handle, MD_REPLACE);
	vsl_width (vdi_handle, 1);
	vsl_color (vdi_handle, BLACK);
	vsl_ends (vdi_handle, SQUARE, SQUARE);
	vsl_type (vdi_handle, SOLID);

	if (pb-> pb_currstate & OUTLINED) {
		pb-> pb_x -= 3;
		pb-> pb_y -= 3;
		pb-> pb_w += 6;
		pb-> pb_h+= 6;
	};

	if (pb-> pb_prevstate == pb-> pb_currstate) {		/* Rahmen */
		pxy2 [0] = pxy2 [6] = pxy2 [8] = pb-> pb_x;
		pxy2 [1] = pxy2 [3] = pxy2 [9] = pb-> pb_y;
		pxy2 [2] = pxy2 [4] = pb-> pb_x + pb-> pb_w - 1;
		pxy2 [5] = pxy2 [7] = pb-> pb_y + pb-> pb_h - 1;
		v_pline (vdi_handle, 5, pxy2);
	};

	col1 = (INT16) pb-> pb_parm & 0xf;
	col2 = (INT16) (pb-> pb_parm >> 4) & 0xf;

	pxy2 [0] = pxy2 [2] = pb-> pb_x + 1;
	pxy2 [3] = pxy2 [5] = pb-> pb_y + 1;
	pxy2 [4] = pb-> pb_x + pb-> pb_w - 2;
	pxy2 [1] = pb-> pb_y + pb-> pb_h - 2;

	if (pb-> pb_currstate & SELECTED) {		/* angewhlt */
		vsl_color (vdi_handle, col1);
	} else {
		vsl_color (vdi_handle, col2);
	};

	v_pline (vdi_handle, 3, pxy2);
	pxy2 [0] ++; pxy2 [1] --; pxy2 [2] ++; pxy2 [3] ++;
	pxy2 [4] --; pxy2 [5] ++;
	v_pline (vdi_handle, 3, pxy2);

	pxy2 [0] = pb-> pb_x + 1;
	pxy2 [1] = pxy2 [3] = pb-> pb_y + pb-> pb_h - 2;
	pxy2 [4] = pxy2 [2] = pb-> pb_x + pb-> pb_w - 2;
	pxy2 [5] = pb-> pb_y + 1;

	if (pb-> pb_currstate & SELECTED) {		/* angewhlt */
		vsl_color	(vdi_handle, col2);
	} else {
		vsl_color	(vdi_handle, col1);
	};

	v_pline	(vdi_handle, 3, pxy2);
	pxy2 [0] ++; pxy2 [1] --; pxy2 [2] --; pxy2 [3] --;
	pxy2 [4] --; pxy2 [5] ++;
	v_pline	(vdi_handle, 3, pxy2);

	vs_clip	(vdi_handle, FALSE, pxy);				/* klippen ausschalten */

	return (pb-> pb_currstate & ~(SELECTED | OUTLINED));
}




