unit acs;

interface

uses gem;

Const __PS__ 	=		(127 + 1);	{ Pathsize }

type

	AwindowPtr = ^Awindow;

	Aaction = Procedure;
	Acreate = Function (x: Pointer): AwindowPtr;
	AcreatePtr = ^Acreate;
	Aretint = Function: Integer;

	AOBJECTPtr = ^AOBJECT;
	AOBJECT = Record
		click:	Aaction;	{ action on exit, touchexit or dclick }
		drag:		Aaction;	{ action on drag }
		ob_flags:	Word;		{ ob_flags, must be same as in OBJECT }
								{ since it will be checked }
		key:		Word;		{ key for selecting }
		userp1:	Pointer;	{ user pointers }
		userp2:	Pointer;
		mo_index:	Integer;	{ mouse index upon this field }
								{ contains title number for menues }
		aob_type:	Integer;	{ Object type (not AES type) }
	End;

	ACSOBJECTPtr = ^ACSOBJECT;
	ACSOBJECT = Record
	  case boolean of
		false: (aes: AESOBJECT);
		true:  (acs: AOBJECT);
	End;

	ACSTreePtr = ^ACSTree;
	ACSTree = Array [0..8191] of ACSOBJECT;

	AUSERBLKPtr = ^AUSERBLK;
	AUSERBLK = Record
		ub_code:	Function (dummy1, dummy2: Pointer; pb: PARMBLKPtr): Integer;
		ub_parm:	LongInt;
		ub_serv:	Function (entry: ACSOBJECTPtr; task: Integer; in_out: Pointer): Boolean;
		ub_ptr1:	Pointer;
		ub_ptr2:	Pointer;
		ub_ptr3:	Pointer;
	End;

	AmousePtr = ^Amouse;
	Amouse = Record
		number: Integer;		{ Mousenumber 255=Userdef }
		form:	MFORMPtr;		{ Mouseform or NULL }
	End;

	AxywhPtr = ^Axywh;
	Axywh = Record
		x: Integer;
		y: Integer;
		w: Integer;
		h: Integer;
	End;

	Awindow = Record
		user:		Pointer;			{ Users pointer }
		service:	Function (w: AwindowPtr; task: Integer; in_out: Pointer): Boolean;
		create:		Function (a: Pointer): AwindowPtr;
		open:		Function (w: AwindowPtr): Integer;
		init:		Function (w: AwindowPtr): Integer;
		work:		ACSTreePtr;			{ Object within window }
		reserved:	Pointer;			{ reserved pointer }
		ob_edit, ob_col: Integer;		{ ob nr and act column }
			{ GEM attributes }
		wi_id:		Integer;			{ gem window id or -1 }
		wi_kind:	Integer;			{ window attributes }
	    wi_act:		Axywh;				{ actual outer coordinates }
		wi_normal:	Axywh;				{ normal outer0coordinates }
		wi_work:	Axywh;				{ inner size without menu }
		wi_slider:	Axywh;				{ last set slider (init -1) }
		wi_nx, wi_ny:	Integer;		{ normal offset zero or negative }
		snap_mask:	Word;				{ snap mask due to pattern offset }
		name:		Pointer;			{ points to name }
		info:		Pointer;			{ points to info }
			{ ACS attributes }
		wi_type:	Integer;			{ type of this window }
		kind:		Integer;			{ own attributes }
		state:		Integer;			{ state of window }
		icon:		Integer;			{ objectnr in root window, -1 if not }
		iconblk:	ICONBLKPtr;			{ defines the Iconimage, NULL means default Iconz}
			{ Menue }
		menu:		ACSTreePtr;			{ menuetree OBJECT }
		{ Keyboard }
		keys:		Procedure (w: AwindowPtr; kstate: Integer; key: Integer); { unknown key actions }
		{ mouse select }
		obchange:	Procedure (w: AwindowPtr; obnr: Integer; new_state: Integer);	{ change state of this ob }

		{ window attribute reactions }
		redraw:		Procedure (w: AwindowPtr; r: AxywhPtr);		{ Redraw }
		topped:		Procedure (w: AwindowPtr);					{ Topped }
		closed:		Procedure (w: AwindowPtr);					{ closed }
		fulled:		Procedure (w: AwindowPtr);					{ fulled }
		arrowed:	Procedure (w: AwindowPtr; wh: Integer);		{ arrowed }
		hslid:		Procedure (w: AwindowPtr; p: Integer);		{ hslide }
		vslid:		Procedure (w: AwindowPtr; p: Integer);		{ vslide }
		sized:		Procedure (w: AwindowPtr; r: AxywhPtr);		{ size }
		moved:		Procedure (w: AwindowPtr; r: AxywhPtr);		{ move }
	End;

	AdescrPtr = ^Adescr;
	Adescr = Record					{ Description start }
		magic:		packed array [0..7] of char;	{ Magic "ACS 102" }
		version:	Integer;		{ Version * 102 }
		dx,dy:		Integer;		{ virtuell desktop increments }
		flags:		Integer;		{ commom flags }
		acc_reg:	packed array [0..31] of char;	{ Accessory register message }
		root:		AwindowPtr;		{ Root window }
		acc:		AwindowPtr;		{ Accessory first window }
		mouse:		Array [0..31] of Amouse;	{ 32 Mouseforms }
	End;

	AselPtr = ^Asel;
	Asel = Record				{ list of selected Objects }
		window:	AwindowPtr;	{ the objects belong to this window }
		maxlen:	Integer;		{ max entries in list }
		actlen:	Integer;		{ actual count }
		next:	Integer;		{ next entry return by Adr_next }
		dragback:	Integer;	{ drag still selected ob back to origin }
		x, y:	Integer;		{ position during pick up }
		rx, ry:	Integer;		{ relativ dragged distance }
		parray:	Pointer;		{ points to array of obnr's (Integer) }
	End;

	AwiobPtr = ^Awiob;
	Awiob = Record
		window:	AwindowPtr;
		entry:	ACSOBJECTPtr;
		obnr:		Integer;
	End;

	AblkPtr = ^Ablk;
	Ablk = Record
		gl_apid:			Integer;
		phys_handle:	Integer;
		gl_wattr:			Integer;
		gl_hattr:			Integer;
		desk:					Axywh;
		vdi_handle:		Integer;
		gl_wbox:			Integer;
		gl_hbox:			Integer;
		gl_wchar:			Integer;
		gl_hchar:			Integer;
		ncolors:			Integer;
		nplanes:			Integer;
		appname:			packed array [1..__PS__] of char;
		apppath:			packed array [1..__PS__] of char;
		apppara:			packed array [1..__PS__] of char;
		appfrom:			packed array [1..__PS__] of char;
		basename:			packed array [1..20] of char;
		ev_mtcount:		LongInt;
		application:	Integer;
		multitask:		Integer;
		appexit:			Integer;
		description:	AdescrPtr;
		Aselect:			Asel;
		ev_window:		AwindowPtr;
		ev_object:		ACSTreePtr;
		ev_obnr:			Integer;
		ev_mmox, ev_mmoy:	Integer;
		ev_mmokstate:	Integer;
		dia_abort:		Integer;
		screenMFDB:		MFDB;
		apterm:				Integer;
		AESglobal:		Pointer;
		fonts:				Integer;
		argc:					Integer;
		argv:					Pointer;
		env:					Pointer;
		fontid:				Integer;
		fheight:			Integer;
		fontsid:			Integer;
		fsheight:			Integer;
		ACSterm:			Procedure;
		ACSaboutme:		Procedure;
		ACSclose:			Procedure;
		ACSmessage:		Procedure (var ev_mgpbuff : ARRAY_8);
		ACSmproto:		Procedure (var ev_mgpbuff : ARRAY_8);
		ACStimer:			Procedure;
		ACSinit0:			Function: Integer;
		dither:				Integer;
	End;


{	ACS plus }
	SLLIVEPtr = ^SLLIVE;
	SLLIVE  = Record 
		call: Procedure (obj: Pointer; pos: LongInt);
	End;

	EDITSUBSPtr = ^EDITSUBS;
	EDITSUBS = Record
		row1: LongInt;
		col1:	LongInt;
		row2:	LongInt;
		col2:	LongInt;
		nrow: LongInt;
		text: Pointer;		{ ^Array [0..] of Pointer }
	End;

	EDITGETSPtr = ^EDITGETS;
	EDITGETS = Record
		row:	LongInt;
		size: LongInt;
		text:	Pointer;
	End;

	EDITLIVEPtr = ^EDITLIVE;
	EDITLIVE = Record
		call:	Procedure (obj: Pointer; text: Pointer);
		obj:	Pointer;
	End;

	PROTOCOLDATAPtr = ^PROTOCOLDATA;
	PROTOCOLDATA = Record
		fontid: Integer;
		height: Integer;
		col:		Integer;
		row:		Integer;
		tabsize:Integer;
		wrap:		Integer;
		x:			Integer;
		y:			Integer;
	End;

	PLOTTERDATAPtr = ^PLOTTERDATA;
	PLOTTERDATA = Record
		x:	Integer;
		y:	Integer;
		w:	Integer;
		h:	Integer;
	End;

Const
	OK = 0;
	FAIL = -1;
		{ USERDEF. serv }
	AUO_CREATE		=	(1);
	AUO_TERM			=	(2);
	AUO_GETVAL		=	(3);
	AUO_SETVAL		=	(4);
	AUO_UPDATE		=	(5);
	AUO_FULLUPDATE=	(6);
	AUO_SELF			=	(9);
	AUO_NEXT			=	(10);
	AUO_PREV			=	(11);
	AUO_NEXTPAGE	=	(12);
	AUO_PREVPAGE	=	(13);
	AUO_BEGIN			=	(14);
	AUO_END				=	(15);
	AUO_POS				=	(17);

	AUO_SLFULL		=		(100);
	AUO_SLSIZE		=		(101);
	AUO_SLSTEP		=		(102);
	AUO_SLCALL		=		(103);
	AUO_SLLEN			=		(104);
	AUO_SLLIVE		=		(105);
	AUO_SLWIPOS		=		(106);

	AUO_EDVERSLIDER=	(200);
	AUO_EDHORSLIDER=	(201);
	AUO_EDGETROW	=		(202);
	AUO_EDNEWLINE	=		(203);
	AUO_EDAPPLINE	=		(204);
	AUO_EDWRAP		=		(205);
	AUO_EDDELETE	=		(206);
	AUO_EDFONT		=		(207);
	AUO_EDHEIGHT	=		(208);
	AUO_EDCOLOR		=		(209);
	AUO_EDCFULL		=		(210);
	AUO_EDCURON		=		(211);
	AUO_EDCUROFF	=		(212);
	AUO_EDCURHIDE	=		(213);
	AUO_EDCURSHOW	=		(214);
	AUO_EDCURPOS	=		(215);
	AUO_EDGETPOS	=		(216);
	AUO_EDHCOL		=		(217);
	AUO_EDHROW		=		(218);
	AUO_EDVIEW		=		(219);
	AUO_ED1SELECT	=		(220);
	AUO_ED01SELECT=		(221);
	AUO_EDNSELECT	=		(222);
	AUO_EDNMSELECT=		(223);
	AUO_EDCHARSELECT=	(224);
	AUO_EDBLKSELECT=	(225);
	AUO_EDUNSELECT=		(226);
	AUO_EDGETSELECT=	(227);
	AUO_EDSETSELECT=	(228);
	AUO_EDCALL		=		(229);
	AUO_EDLIVE		=		(230);
	AUO_EDGETCURPOS=	(231);
	AUO_EDGETLENGTH=	(232);
	AUO_EDGETROWS	=		(233);
	AUO_EDSUB			=		(234);
	AUO_EDUNDO		=		(235);
	AUO_EDTABSIZE	=		(236);
	AUO_EDCLEARUNDO=	(237);
	AUO_EDRESIZE	=		(238);
	AUO_EDUPDATE	=		(239);
	AUO_EDGETTABSIZE=	(240);
	AUO_EDBLOCKMODE	=	(241);
	AUO_EDFIND			=	(242);
	AUO_EDBACKWARD	=	(243);
	AUO_EDFORWARD		=	(244);
	AUO_EDCASE			=	(245);
	AUO_EDNOCASE		=	(246);
	AUO_EDWORD			=	(247);
	AUO_EDNOWORD		=	(248);
	AUO_EDRESET			=	(249);
	AUO_EDGETCHANGED=	(250);
	AUO_EDGETNEED		=	(251);
	AUO_EDSELECTWORD=	(252);
	AUO_EDSLIDERS		=	(253);
	AUO_EDCURSOR		=	(254);

	AUO_FTFONT			=	(300);
	AUO_FTHEIGHT		=	(301);
	AUO_FTCOLOR			=	(302);
	AUO_FTEFFECTS		=	(303);
	AUO_FTLEFT			=	(304);
	AUO_FTRIGHT			=	(305);
	AUO_FTCENTER		=	(306);
	AUO_FTBLOCK			=	(307);
	AUO_CYCPOPUP		=	(400);
	AUO_CYCINDEX		=	(401);
	AUO_CYCGETINDEX	=	(402);
	AUO_PICMFDB			=	(500);

		{ description. flags }
	AB_CLICKMENU 	=	($0001);	{ menu drop down on click instead of touch }
	AB_MOVIES			=	($0002);	{ draws moving, growing, shrink rectangle }
	AB_ACUSTIC		=	($0004);	{ acustic bell if user clicks outside of dialog }
	AB_HIDEPOINTER=	($0008);	{ hide pointer on key input }
	AB_CENTERDIALOG=($0010);	{ center dialog }
	AB_GDOSFONT		=	($0020);	{ load and frees gdos fonts if available }
	AB_SMARTREDRAW=	($0040);	{ use smart redraw }
	AB_MENUFIRST	=	($0080);	{ change key consume strategie }

		{ Awindow. service }	{ generic }
	AS_ACCLOSED	=	(1);		{ accessory closed, initialize correctly }
	AS_TERM			=	(2);		{ terminate }
	AS_ICONIZED	=	(3);		{ the window was iconized (in order to receive a free window id); }
	AS_MOUSE		=	(4);		{ Mouse is upon the window }
	AS_SELECTADD=	(5);		{ added ob in select list }
	AS_SELECTDEL=	(6);		{ deleted ob in select list }
	AS_UNTOPPED	=	(7);		{ ACS does not handle UNTOPPED, maybe the windowzwant it }
	AS_FOCUSCHG	=	(8);		{ Focus changed to another Inputfield }
	AS_CHECKDRAG=	(9);		{ check if window will accept draglist }

	AS_OPEN			=	(10);		{ Open the selected list of objects }
	AS_DELETE		=	(11);		{ delete selected list }
	AS_CHECKDELETE= (12); { is list deleteable }
	AS_INFO			=	(15);		{ Info about Window }
	AS_DRAGGED	=	(16);		{ Something dragged on windows ICON }
	AS_CHECKDRAGGED=(17);	{ is list acceptable for this window icon }
	AS_CONFIGDRAG	=	(18);	{ Allows owner window to modify drag parameter like raster }

					{ desktop }
	AS_PLACEICON=	(100);		{ place icon, in_out = the window }
	AS_REMICON	=	(101);		{ remove icon }
	AS_GHOSTICON=	(102);		{ change to ghost icon }
	AS_NORMICON	=	(103);		{ chance from ghost icon to normal icon }
	AS_NEWCALL	=	(104);		{ set new call }
	AS_BACKOBJECT	=	(105);	{ Set Background Objekt, (ob_type, ob_spec) ACSinit0 }
	AS_ICONNEW		=	(106);	{	Set New-Icon, ACSinit0 }
	AS_ICONTRASH	=	(107);	{	Set Trash-Icon, ACSinit0 }
	AS_ICONWINDOW	=	(108);	{	Set Default-Icon, ACSinit0 ! }
	AS_UPDATEICON	=	(109);	{	updates icon }

	AS_EDGETENTRY	=	(200);
	AS_EDEXT			=	(201);
	AS_EDLOADFILE	=	(202);
	AS_EDTITLE		=	(203);
	AS_EDTITLEDIRTY=(204);
	AS_EDPUTSTRING=	(205);
	AS_EDGETSTRING=	(206);
	AS_EDGETNEED	=	(207);
	AS_EDWINDOW		=	(208);
	AS_EDTERM			=	(209);
	AS_EDSAVE			=	(210);
	AS_EDCLEAN		=	(211);
	AS_EDHOME			=	(212);
	AS_EDICONTEXT	=	(213);

	AS_PLOTHANDLE		=	(300);
	AS_PLOTMFDB			=	(301);
	AS_PLOTSIZE			=	(302);

		{ Awindow. kind }
	AW_ICON			=	($0001);	{ Iconizing Window instead of Terminating }
	AW_GHOSTICON=	($0002);	{ Ghost Icon from beginning }
	AW_STAY			=	($0004);	{ do not change state of the window iconize/open }
	AW_OBLIST		=	($0008);	{ inner ob is a objects list }
	AW_ICONACCEPT=($0010);	{ accept dragging on windows icon }
	AW_UHSLIDER	=	($0020);	{ user administrated horizontal slider }
	AW_UVSLIDER	=	($0040);	{ user administrated vertical slider }
	AW_NOSCROLL	=	($0080);	{ no optimized scrolling }
	AW_TOOLBOX	= ($0100);	{ do not top if access (AES 4.0 only) }

	{ Awindow. state }
	AWS_FULL		=	($0001);	{ State full }
	AWS_DIALOG	=	($0002);	{ dialog is activ }
	AWS_MODIFIED=	($0004);	{ dependend information was changed call init before open }
	AWS_MODAL		=	($0008);	{ a modal dialog is open for this window }
	AWS_FORCEREDRAW=	($0010);	{ forces a redraw }
	AWS_LATEUPDATE=	($0020);	{ send AS_UPATE after returning to main loop }
	AWS_TERM	=	($0100);	{ Terminatesequence active, skip iconizing }
	AWS_INTERM=	($0200);	{	USER set! window is term routine in progress, just to avoid double terminating and freeing memory }

	{ OBJECT. ob_flags }
	AEO			=	($8000);	{ Extended Object }
	AO_DEFABLE	=	($4000);	{ defaultable Object }
	AO_DRAGABLE	=	($2000);	{ dragable Object }
	AO_ACCEPT	=	($1000);	{ accept dragable Object }
	AO_SILENT	=	($0800);	{ ob will NOT visual react (AO_ACCEPT); }

	{ OBJECT. ob_state }
	AOS_FIXED		=	($8000);	{ Object tree is already fixed }
	AOS_DCLICK	=	($4000);	{ last selection was a double click }
	AOS_CONST		=	($2000);	{ Do not copy substructure, do not release (free); substructure }
	AOS_LOCKED	=	($1000);	{ subtree is locked */
	AOS_CLTOP		=	($0800);	{ Counterlock Top; is bound to Bottom of parent }
	AOS_CLBOTTOM=	($0400);	{ Counterlock Bottom }
	AOS_CLLEFT	=	($0200);	{ Counterlock Left }
	AOS_CLRIGHT	=	($0100);	{ Counterlock Right }

	{ AOBJECT. type }
	AT_ICONWINDOW=(1);		{ iconized window }
	AT_NEW			=	(2);		{ new ob }
	AT_TRASH		=	(3);		{ trash bin }
	AT_MFDB			=	(10);		{ MFDB in userp1 }
	AT_STRING		=	(11);		{ Nullterminated String in userp1 }
	AT_FILE 		=	(20);		{ Nullterminated String in userp1, file path }

		{ AOBJECT. key }
	AO_SCANCODE	=	($8000);	{ contain scancode instead of vdi-code }

		{ desktop icons size }
	AREA_WIDTH	=	(80);		{ area for icons }
	AREA_HEIGHT	=	(48);
	FRAME				=	(8);		{ frame around Icon }


Var
	ACSblk: AblkPtr;

{
	Just to support ACS 1.xx Programms, warning Functions are readonly Vars
}
	Function	gl_apid:	Integer;
	Function	phys_handle:Integer;		{ workstation for aes }
	Function	gl_wattr:	Integer;		{ attribut width }
	Function	gl_hattr:	Integer;		{ attribut height }

	Function	desk:	AxywhPtr;				{ desktop limits XYWH }
	{ VDI }
	Function	vdi_handle:	Integer;		{ virtual VDI workstation for ACS }
	Function	gl_wbox:	Integer;		{ cell width of standard char }
	Function	gl_hbox:	Integer;		{ cell height of standard char }
	Function	gl_wchar:	Integer;		{ max width of standard char}
	Function	gl_hchar:	Integer;		{ max height of standard char }
	Function	ncolors:	Integer;		{ number of colors (2=mono) }
	Function	nplanes:	Integer;		{ number of colors expressed in planes }
	{ Pathes }
	Function	appname:	Pointer;		{ application complete name}
	Function	apppath:	Pointer;		{ azplication path }
	Function	apppara:	Pointer;		{ application parameter }
	Function	appfrom:	Pointer;		{ application called from }
	Function	basename:	Pointer;		{ basename appname without extention }
	{ others }
	Function	ev_mtcount:		Longint;		{ Timerintervall in milli sec (initial 500 ms) }
	Function	application:	Integer;		{ runs as an application }
	Function	multitask:		Integer;		{ more than 1 applications possible }
	Function	appexit:		Integer;		{ application is in system termination mode }
	Function	description:	AdescrPtr;		{ surface description, pointer for late assignment }
	Function	Aselect:			AselPtr;			{ list of selected objects }
	{ context during callback pointer values }
	Function	ev_window:		AwindowPtr;		{ actual window }
	Function	ev_object:		ACSTreePtr;		{ actual ob tree }
	Function	ev_obnr:		Integer;		{ actaul objectnumber, index }
	Function	ev_mmox:	Integer;
	Function	ev_mmoy:	Integer;	{ Mouse position }
	Function	ev_mmokstate:	Integer;		{ Keyboard state }
	Function	dia_abort:		Integer;		{ Abort modal dialog }
	Function	screenMFDB:		MFDBPtr;		{ exactly this }

{
 *	Windowhandling common Routines
}

	Function Awi_wid (wid: Integer): AwindowPtr; external;	{ get window for gem window id }
	Function Awi_root: AwindowPtr; external;				{ return root window }
	Function Awi_list: AwindowPtr; external;				{ next window from total set }
	Procedure Awi_sendall									{ sends message to all windows }
		(task: Integer; in_out: Pointer); external;
	Procedure Awi_down; external;							{ cycle down windows }
	Procedure Awi_up; external;								{ cycle up windows }
	Procedure Awi_show (w: AwindowPtr); external;			{ show window }
	Function  Awi_init (w: AwindowPtr): Integer; external;	{ Dummy init routine }
	Function  Awi_create (w: AwindowPtr): AwindowPtr; external;	{ create a copy of window x }
	Function  Awi_open (w: AwindowPtr): Integer; external;	{ open window }
	Procedure Awi_closed (w: AwindowPtr); external;			{ close window }
	Procedure Awi_delete (w: AwindowPtr); external;			{ free window }
	Procedure Awi_topped (w: AwindowPtr); external;			{ top this window }
	Procedure Awi_fulled (w: AwindowPtr); external;			{ fullsize window }
	Procedure Awi_sized (w: AwindowPtr;						{ move/resize window }
			new: AxywhPtr); external;
	Procedure Awi_moved (w: AwindowPtr;						{ move/resize window }
			new: AxywhPtr); external;
	Procedure Awi_diaend; external;							{ finish open dialog }
	Procedure Awi_diastart; external;						{ start dialog }
	Procedure Awi_keys (w: AwindowPtr;						{ key input for dialog }
		kstate: Integer; key: Integer); external;
	Procedure Awi_obview (w: AwindowPtr;					{ show area in work ob coordinates }
		xywh: AxywhPtr); external;
	Function Awi_service (w: AwindowPtr;					{ very simple service routine }
		task: Integer; in_out: Pointer): Boolean; external;
	Procedure Awi_scroll (w: AwindowPtr;					{ intelligent scroll/update, x,y upper left edge BEFORE scrolling }
		x: Integer; y: Integer); external;

{
 * Window: inner Objects
 }

	Procedure Awi_obchange (wi: AwindowPtr;				{ change the state of this ob in work tree }
			obnr: Integer; new_state: Integer); external;	{ ! changed behaviour to 1.0 }
	Procedure Awi_obredraw (wi: AwindowPtr;				{ redraws everthing in the area of obnr }
		obnr: Integer); external;						{ uses window-> redraw }
	Procedure Awi_redraw (w: AwindowPtr;				{ redraw routine }
		limit: AxywhPtr); external;
	Procedure Awi_arrowed (w: AwindowPtr;				{ arrows }
		which: Integer); external;
	Procedure Awi_hslid (w: AwindowPtr;					{ horizontal slider }
		pos: Integer); external;
	Procedure Awi_vslid (w: AwindowPtr; 				{ vertical slider }
		pos: Integer); external;

{
 * Events
 }

	Procedure Aev_quit; external;				{ Next eventloop will terminate }
	Procedure Aev_mess; external;				{ Accept and handle messages eg redraw }
	Procedure Aev_unhidepointer; external;		{ unhides hidden pointer }

{
 *	Mousehandling
 }

	Procedure Amo_new (mouse: AmousePtr); external;	{ set new mouse }
	Procedure Amo_busy; external;				{ set busy indicator }
	Procedure Amo_unbusy; external;				{ remove busy indicator }
	Procedure Amo_hide; external;				{ hide mouse }
	Procedure Amo_show; external;				{ unhide mouse }

{
 *	Objecthandling
 }

	Function Aob_create (						{ creates a copy of parent }
		parent: ACSTreePtr): ACSTreePtr; external;	
	Procedure Aob_delete (ob: ACSTreePtr); external;{ frees ob generated by Aob_create }
	Procedure Aob_fix (ob: ACSTreePtr); external;	{ fixes ob }
	Procedure Aob_offset (redraw: AxywhPtr;			{ calculate redraw rectangle for ob }
		ob: ACSTreePtr; entry: Integer); external;
	Function Aob_save (rect: AxywhPtr): MFDBPtr; external;	{ save rectangle of desktop }
	Procedure Aob_restore (save: MFDBPtr;			{ restore desktop previously save with Aob_save }
		rect: AxywhPtr); external;
	Function Aob_watch (w: AwindowPtr;				{ watched ob, select if pointer upon obnr }
		obnr: Integer): Boolean; external;			{ returns TRUE if button was release upon obnr }
	Function Aob_findflag (ob: ACSTreePtr;			{ find obnr for which flagmask becomes true, obnr is start ob }
		obnr: Integer; flag: Integer): Integer; external;
	Function Aob_up (ob: ACSTreePtr; obnr: Integer): Integer; external;	{ find parent objectnr, returns -1 on top level }

	Procedure Ame_namefix (menu: ACSTreePtr); external;		{ fixes tree on different length of first title (name) }

	Function Ame_popup (w: AwindowPtr;				{ pop up a popup menu, x/y determs upper left edge }
		popup: ACSTreePtr;x: Integer; y: Integer): Integer; external;	{ returns selected Obnr, If a callback is defined it will be called }

	Function Ame_strpopup (w: AwindowPtr;				{ pop up a popup menu, x/y determs upper left edge }
		popup, chk: Pointer;x: Integer; y: Integer): Pointer; external;	

{
 * Backplane Support
 }

	Function Abp_create (w: Integer; h: Integer): MFDBPtr; external;	{ Create Backplane with width w and height h }
	Procedure Abp_delete (bp: MFDBPtr); external;						{ free Backplane }
	Procedure Abp_start (bp: MFDBPtr); external;						{ start writing on backplane (all vdi and aes calls) }
	Procedure Abp_end; external;										{ stop writing on backplane, resume to screen }

{
 * Drag support functions
 }

	Procedure Adr_box (x: Integer; y: Integer); external;	{ start drawing a box which select intersected objects }
	Procedure Adr_drag (x: Integer; y: Integer); external;	{ drag ob list }
	Procedure Adr_start; external;								{ begin reading select with Adr_next }
	Function Adr_next: Integer; external;					{ returns next obnr from list }
	Procedure Adr_add (w: AwindowPtr;					{ add ob in Aselect list }
			obnr: Integer); external;
	Procedure Adr_del (w: AwindowPtr;					{ delete ob from Aselect list, did not update on screen ! }
			obnr: Integer); external;
	Procedure Adr_unselect; external;					{ unselect all ob in list, update screen ! }	

{
 *	String support
 }

	Function Ast_create (parent: Pointer): Pointer; external;	{ create a copy of parent string }
	Procedure Ast_delete (str: Pointer); external;		{ release this copy }

{
 * ICON, Image Support
 }

	Function Aic_create							{ create a copy of icon, but not image part ! }
		(icon: ICONBLKPtr):ICONBLKPtr; external;
	Procedure Aic_delete (icon: ICONBLKPTR); external;	{ release this copy }

	Function Aim_create							{ create a bitblk copy, but not image }
		(bitblk: BITBLKPtr): BITBLKPtr; external;
	Procedure Aim_delete (bitblk: BITBLKPtr); external;	{ release copy }

{
 *	USER defined Objects
 }

	Function Aus_create 						{ create a copy }
			(user: USERBLKPtr): USERBLKPtr; external;
	Procedure Aus_delete (user: USERBLKPtr); external;	{ release this copy }

{
 *	TEDINFO Support
 }

	Function Ate_create							{ create a copy }
			(tedi: TEDINFOPtr): TEDINFOPtr; external;
	Procedure Ate_delete (tedi: TEDINFOPtr); external;	{ release this copy }

{
 *	Xtra Functions
 }

	Function Ax_malloc (size: LongInt): Pointer; external;	{ ACS Malloc can be overwritten if linked before library }
	Procedure Ax_free (memory: Pointer); external;			{ Mark memory as free }
	Procedure Ax_ifree (memory: Pointer); external;			{ give memory immediate free (be very carefully) }

{
 *	Dummy Routines
 }

	Procedure A_nokey (w: AwindowPtr;			{ Zero Routine }
		kstate: Integer; key: Integer); external;

{
 *	Utilities
 }
	Procedure Aob_alias; external;				{ Alias ob, number in userp1 }
	Function A_fileselect (title, path, ext: Pointer): Pointer; external;		{ Fileselector }
	Function A_dialog (dia: ACSTreePtr): Integer; external;		{ Draw a dialogbox near the pointer, handle draw and redraw }
											{ returns buttonnumber }
	Function alert_str						{ display an alert box with one string parameter }
		(alert: Pointer;					{ alert must have the form [X][...%s....][Y] }
		 para: Pointer): Integer; external;
	Procedure intersect (toa, froma: AxywhPtr); external;

{
 *	Predefined "Userdefined Objects"
 }

	function A_checkbox( dummy1, dummy2 : Pointer; parm: PARMBLKPtr) : Integer; external;		{ checkboxes, parm simular to ob_spec for boxes ! }
	function A_radiobutton( dummy1, dummy2 : Pointer; parm: PARMBLKPtr) : Integer; external;	{ rounded selectable elements, parm simular to ob_spec for boxes ! }
	function A_innerframe( dummy1, dummy2 : Pointer; parm: PARMBLKPtr) : Integer; external;	{ draws a frames half a character inside ! }
	function A_pattern( dummy1, dummy2 : Pointer; parm: PARMBLKPtr) : Integer; external;		{ draws general patterns }
	function A_arrows( dummy1, dummy2 : Pointer; parm: PARMBLKPtr) : Integer; external;		{ draws arrows }
	function A_3Dbutton ( dummy1, dummy2 : Pointer; parm: PARMBLKPtr) : Integer; external;		{ draws 3D Button }
	function A_cycle ( dummy1, dummy2 : Pointer; parm: PARMBLKPtr) : Integer; external;
	function A_picture ( dummy1, dummy2 : Pointer; parm: PARMBLKPtr) : Integer; external;
	function A_ftext ( dummy1, dummy2 : Pointer; parm: PARMBLKPtr) : Integer; external;
	function A_select( dummy1, dummy2 : Pointer; parm: PARMBLKPtr) : Integer; external;		{ select in a frame instead of reverse }

	function Auo_string (entry: ACSOBJECTPtr; task: Integer; in_out: Pointer) : Boolean; external;
	function Auo_ftext (entry: ACSOBJECTPtr; task: Integer; in_out: Pointer) : Boolean; external;
	function Auo_picture (entry: ACSOBJECTPtr; task: Integer; in_out: Pointer) : Boolean; external;
	function Auo_cycle (entry: ACSOBJECTPtr; task: Integer; in_out: Pointer) : Boolean; external;

	Procedure Aus_cycle; external;
	Function Ash_prog (path, command, env: Pointer): LongInt; external;
	Function Ash_module (path: Pointer): Integer; external;

{ ACSPLUS }

	Function A_editor( dummy1, dummy2 : Pointer; parm: PARMBLKPtr) : Integer; external;		{ checkboxes, parm simular to ob_spec for boxes ! }
	function A_slider( dummy1, dummy2 : Pointer; parm: PARMBLKPtr) : Integer; external;	{ rounded selectable elements, parm simular to ob_spec for boxes ! }
	function A_wislider( dummy1, dummy2 : Pointer; parm: PARMBLKPtr) : Integer; external;	{ draws a frames half a character inside ! }

	function Auo_editor (entry: ACSOBJECTPtr; task: Integer; in_out: Pointer) : Boolean; external;
	function Auo_slider (entry: ACSOBJECTPtr; task: Integer; in_out: Pointer) : Boolean; external;
	Procedure Aus_editor; external;
	Procedure Aus_slider; external;
	Procedure Auok_editor (entry: ACSOBJECTPtr; kstate, key: Integer); external;

	Procedure Awd_quit; External;
	Procedure Awd_open; External;
	Procedure Awd_close; External;
	Procedure Awd_delete; External;
	Procedure Awd_info; External;
	Procedure Awd_hor; External;
	Procedure Awd_list; External;
	Procedure Awd_ver; External;
	Procedure Awd_behaviour; External;
	Procedure Awd_module; External;

	Function get_desktop: AwindowPtr; External;

	Procedure wputs (text: Pointer; wi: AwindowPtr); External;
	Procedure wvprintf (wi: AwindowPtr; format: Pointer; arglist: Pointer); External;
{	Procedure wprintf (wi: AwindowPtr, format: Pointer, ... ); Variable Parameter kennt Pascal NICHT }
	Function get_protocol: AwindowPtr; external;

	Procedure Aed_wrap; External;
	Procedure Aed_toclip; External;
	Procedure Aed_fromclip; External;
	Procedure Aed_copy; External;
	Procedure Aed_cut; External;
	Procedure Aed_cutline; External;
	Procedure Aed_find; External;
	Procedure Aed_findnext; External;
	Procedure Aed_gotoline; External;
	Procedure Aed_info; External;
	Procedure Aed_open; External;
	Procedure Aed_merge; External;
	Procedure Aed_paste; External;
	Procedure Aed_quit; External;
	Procedure Aed_replace; External;
	Procedure Aed_replacenext; External;
	Procedure Aed_save; External;
	Procedure Aed_saveas; External;
	Procedure Aed_font; External;
	Procedure Aed_option; External;
	Procedure Aed_undo; External;
	Function get_editor: AwindowPtr; external;
	Procedure w_pline (wi: AwindowPtr; count: Integer; var pxy: ptsin_Array); External;
	Procedure w_pmarker (wi: AwindowPtr; count: Integer; var pxy: ptsin_Array); External;
	Procedure w_gtext (wi: AwindowPtr; x: Integer; y: Integer; strng: Pointer); External;
	Procedure w_fillarea (wi: AwindowPtr; count: Integer; var pxy: ptsin_Array); External;
	Procedure w_contourfill (wi: AwindowPtr; x: Integer; y: Integer; index: Integer); External;
	Procedure wr_recfl (wi: AwindowPtr; var pxy: Array_4); External;
	Procedure w_bar (wi: AwindowPtr; var pxy: Array_4); External;
	Procedure w_arc (wi: AwindowPtr; x: Integer; y: Integer; rad: Integer; begang: Integer; endang: Integer); External;
	Procedure w_pieslice (wi: AwindowPtr; x: Integer; y: Integer; rad: Integer; begang: Integer; endang: Integer); External;
	Procedure w_circle (wi: AwindowPtr; x: Integer; y: Integer; rad: Integer); External;
	Procedure w_ellipse (wi: AwindowPtr; x: Integer; y: Integer; xrad: Integer; yrad: Integer); External;
	Procedure w_ellarc (wi: AwindowPtr; x: Integer; y: Integer; xrad: Integer; yrad: Integer; begang: Integer; endang: Integer); External;
	Procedure w_ellpie (wi: AwindowPtr; x: Integer; y: Integer; xrad: Integer; yrad: Integer; begang: Integer; endang: Integer); External;
	Procedure w_rbox (wi: AwindowPtr; var pxy: Array_4); External;
	Procedure w_rfbox (wi: AwindowPtr; var pxy: Array_4); External;
	Procedure w_justified (wi: AwindowPtr; x: Integer; y: Integer; strng: Pointer; length: Integer; word_space: Integer; char_space: Integer); External;

	Procedure w_draw (wi: AwindowPtr; x1: Integer; y1: Integer; x2: Integer; y2: Integer); External;
	Procedure w_update (wi: AwindowPtr); External;
	Procedure w_clr (wi: AwindowPtr); External;
	Procedure w_inv (wi: AwindowPtr); External;
	Function get_plotter: AwindowPtr; external;

	Function A_fontsel (var fontid: Integer; var height: Integer; prop: Integer): Integer; External;
	Procedure read_multiline (dest: Pointer; len: Integer; from: Pointer; lines: Integer); External;
	Procedure write_multiline (dest: Pointer; len: Integer; from: Pointer;lines: Integer); External;

	Procedure start_acs (ini: Aretint; descr: AdescrPtr);

implementation

var
	ACSdescr: Adescr;
	Errno: Integer;
	_baspag: PDPtr;
	_app: Integer;
	init_call: Aretint;

	Function	gl_apid;	Begin gl_apid := ACSBlk^. gl_apid; End;
	Function	phys_handle;	Begin  phys_handle := ACSBlk^. phys_handle; End;
	Function	gl_wattr;	Begin gl_wattr := ACSBlk^. gl_wattr; End;
	Function	gl_hattr;	Begin gl_hattr := ACSBlk^. gl_hattr; End;

	Function	desk;	Begin desk := @ACSBlk^. desk; End;
	{ VDI }
	Function	vdi_handle;	Begin vdi_handle := ACSBlk^. vdi_handle; End;
	Function	gl_wbox;	Begin gl_wbox := ACSBlk^. gl_wbox; End;
	Function	gl_hbox;	Begin gl_hbox := ACSBlk^. gl_hbox; End;
	Function	gl_wchar;	Begin gl_wchar := ACSBlk^. gl_wchar; End;
	Function	gl_hchar;	Begin gl_hchar := ACSBlk^. gl_hchar; End;
	Function	ncolors;	Begin ncolors := ACSBlk^. ncolors; End;
	Function	nplanes;	Begin nplanes:= ACSBlk^. nplanes; End;

	{ Pathes }
	Function	appname;	Begin appname := @ACSBlk^. appname; End;
	Function	apppath;	Begin apppath := @ACSBlk^. apppath; End;
	Function	apppara;	Begin apppara := @ACSBlk^. apppara; End;
	Function	appfrom;	Begin appfrom := @ACSBlk^. appfrom; End;
	Function	basename;	Begin basename := @ACSBlk^. basename; End;
	{ others }
	Function	ev_mtcount;	Begin ev_mtcount := ACSBlk^. ev_mtcount; End;
	Function	application;	Begin application := ACSBlk^. application; End;
	Function	multitask;	Begin multitask := ACSBlk^. multitask; End;
	Function	appexit;	Begin appexit := ACSBlk^. appexit; End;
	Function	description;	Begin description := ACSBlk^. description; End;
	Function	Aselect;	Begin Aselect := @ACSBlk^. Aselect; End;
	Function	ev_window;	Begin ev_window := ACSBlk^. ev_window; End;
	Function	ev_object;	Begin ev_object := ACSBlk^. ev_object; End;
	Function	ev_obnr;	Begin ev_obnr := ACSBlk^. ev_obnr; End;
	Function	ev_mmox;	Begin ev_mmox := ACSBlk^. ev_mmox; End;
	Function	ev_mmoy;	Begin ev_mmoy := ACSBlk^. ev_mmoy; End;
	Function	ev_mmokstate;	Begin ev_mmokstate := ACSBlk^. ev_mmokstate; End;
	Function	dia_abort;	Begin dia_abort := ACSBlk^. dia_abort; End;
	Function	screenMFDB;	Begin screenMFDB := @ACSBlk^. screenMFDB; End;

	Procedure acs_call (argc: Integer; argv, env: Pointer); external;
	Function get_acsblk: AblkPtr; external;

	Function ACSinit: Integer; begin ACSinit := init_call; end;
	Procedure dummy; begin; end;

 {$L ppacs.lib }

	Procedure start_acs (ini: Aretint; descr: AdescrPtr);
	begin
	  init_call := ini;
	  ACSblk^. description := descr;
		if (descr^. root = NIL) then 
		begin
			descr^. root := get_desktop;
		end;
	  acs_call (0, NIL, NIL);
	end;

begin
	ACSblk := get_acsblk;
	_baspag := BasePage;
	_app := Integer (AppFlag);
end.
