unit WWRITELN;
{
	(c) 1993 Stefan Bachert

	Dieser Texttreiber erlaubt es die ACS pro 2.00 Fenster
	mit dem Befehl write und writeln anzusprechen

	Beispiel:

        var
           t : Text;
        begin
           ACSprotocol( t );
           Rewrite( t );
           Writeln( t, 'This is ACS pro 2.00 output!' );
           Close( t );
        end.
}

interface

Procedure ACSprotocol (var f: Text);  { spezieller Assign fr ACS Protocol-Fenster}

implementation

uses acs, dos;

Type
	MyUserPtr = ^AwindowPtr;
Const
	form: packed array [0..2] of char = '%s'#0;

Function InOutFunc (var t: TextRec): Integer;
Begin
	InOutFunc := 0;
End;

Function FlushFunc (var t: TextRec): Integer;
Var
	i: Integer;
	Buf: ^TextBuf;
	strng: packed array [0..128] of char;
	user: MyUserPtr;
	wi: AwindowPtr;
	p: Pointer;
Begin
	user := @(t. userdata);
	wi := user^;
	if ((wi <> NIL) AND (t. mode = fmOutput)) Then Begin
		if (t. BufPos > 0) Then BEGIN
			Buf := Pointer(t. BufPtr);
			if (t. Bufpos >= t. Bufsize) then BEGIN
				for i:= 0 to t. BufPos do strng [i] := Buf^[i];
				p := @strng;
			END ELSE BEGIN
				t. BufPtr^[t. BufPos] := chr(0);
				p := t. BufPtr;
			END;
			wvprintf (wi, @form, @p);
			t. BufPos := 0;
		END;
		FlushFunc := 0;
	END ELSE FlushFunc := 1;
END;

Function CloseFunc (var t: TextRec): Integer;
Var
	user: MyUserPtr;
	wi: AwindowPtr;
	db: Boolean;
Begin
	user := @(t. userdata);
	wi := user^;
	if (wi <> NIL) Then Begin
		db := wi^. service (wi, AS_TERM, wi);
		user^ := NIL;
		CloseFunc := 0;
	End Else CloseFunc := 1;
End;

Function OpenFunc (var t: TextRec): Integer;
Var
	user: MyUserPtr;
	wi: AwindowPtr;
	di: Integer;
Begin
	OpenFunc := 0;
	if (t. mode = fmOutput) Then Begin
		user := @(t. userdata);
		if (user^ = NIL) Then Begin {	Noch nicht offen }
			wi := get_protocol^. create (NIL);
			if (wi <> NIL) Then Begin
				user^ := wi;
				t. InOutFunc := @InOutFunc;
				t. FlushFunc := @FlushFunc;
				t. CloseFunc := @CloseFunc;
				di := wi^. open (wi);
			End Else Begin	 {	Konnte kein Fenster erzeugen }
				OpenFunc := 1;
			END
		END;
	End Else Begin		{ Nur Output erlaubt }
		OpenFunc := 1;
	End;
End;

Procedure ACSprotocol (var f: Text);
Var
	t: ^TextRec;
	user: MyUserPtr;
Begin
	t := @f;
	t^. OpenFunc := @OpenFunc;
	t^. BufSize := 128;
	t^. BufPtr := @(t^. Buffer);
	t^. mode := fmClosed;
	user := @(t^. userdata);
	user^ := NIL;
End;

begin
end.
