/*
 *		(c) 1991 Stefan Bachert
 *
 *		ACS							Application Construction System
 *
 *		MODULE:					UOROTSTR
 *
 *		REVISION:				7 DEC 1992
 *
 *		DESCRIPTION:		Userdefined Objecte
 *										
 *										Rotierter String
 *										
 */

/*
 * IMPORT / EXPORT Section
 */


#	include		"string.h"
#	include		"acs.h"

/*
 *		Local Defines
 */

/*
 *		Local Types
 */

/*
 *		Local Prototypes
 */

/*
 *		Local Vars & exported const or initialize
 */

/*
 *		Modul Initializiation/Termination
 */

/*
 *		Functions
 */


INT16 CDECL A_rotstr (PARMBLK *pb)
		/*
		 *		Zeichnet einen Rotierten String
		 */
{
	INT16 pxy [4];
	INT16 temp, width, height, chg;
	INT16 x, y, len;
	AUSERBLK *user;
	OBJECT* entry;
	char *string;

	pxy [2] = pb-> pb_wc;
	pxy [3] = pb-> pb_hc;
	if (pxy [2] || pxy [3]) {						/* klippe */
		pxy [0] = pb-> pb_xc;
		pxy [1] = pb-> pb_yc;
		pxy [2] += pxy [0] - 1;
		pxy [3] += pxy [1] - 1;
		vs_clip (vdi_handle, TRUE, pxy);
	};

	chg = (pb-> pb_currstate ^ pb-> pb_prevstate);
	if (chg == 0) {
		entry = pb-> pb_tree + pb-> pb_obj;
		user = (AUSERBLK *) entry-> ob_spec. userblk;
		string = user-> ub_ptr1;
		if (string == NULL) return 0;
		if (pb-> pb_parm & 4) {
			vswr_mode (vdi_handle, MD_REPLACE);
		} else {
			vswr_mode (vdi_handle, MD_TRANS);
		}
		vst_font (vdi_handle, 1);
		vst_height (vdi_handle, gl_hchar, &temp, &temp, &width, &height);
		vst_color (vdi_handle, BLACK);
		vst_alignment (vdi_handle, 0, 5, &temp, &temp);
		vst_effects (vdi_handle, 0);

		len = (INT16) strlen (string) * width;
		switch ((INT16) (pb-> pb_parm & 3)) {
		case 0:		/*   0 */
			vst_rotation (vdi_handle, 0);
			x = pb-> pb_x + ((pb-> pb_w - len) >> 1);
			y = pb-> pb_y + ((pb-> pb_h - height) >> 1);
			break;
		case 1:		/*  90 */
			vst_rotation (vdi_handle, 900);
			x = pb-> pb_x + ((pb-> pb_w - height) >> 1);
			y = pb-> pb_y + ((pb-> pb_h + len) >> 1) - 1;
			break;
		case 2:		/* 180 */
			x = pb-> pb_x + ((pb-> pb_w + len) >> 1) - 1;
			y = pb-> pb_y + ((pb-> pb_h + height) >> 1) - 1;
			vst_rotation (vdi_handle, 1800);
			break;
		case 3:		/* 270 */
			vst_rotation (vdi_handle, 2700);
/*		vst_rotation (vdi_handle, -900);	*/
			x = pb-> pb_x + ((pb-> pb_w + height) >> 1) - 1;
			y = pb-> pb_y + ((pb-> pb_h - len) >> 1);
			break;
		};
		v_gtext (vdi_handle, x, y, string);
	}

	if ((chg == 0 && pb-> pb_currstate & SELECTED) ||
			 chg & SELECTED) {											/* selectiert */
		if (chg == 0) {														/* selectiert */
			vswr_mode (vdi_handle, MD_REPLACE);
		} else {
			vswr_mode (vdi_handle, MD_XOR);
		}
		vsf_interior (vdi_handle, FIS_SOLID);
		vsf_color (vdi_handle, BLACK);
		pxy [0] = pb-> pb_x;
		pxy [1] = pb-> pb_y;
		pxy [2] = pxy [0] + pb-> pb_w - 1;
		pxy [3] = pxy [1] + pb-> pb_h - 1;
		vsf_perimeter (vdi_handle, FALSE);
		v_bar (vdi_handle, pxy);
	};

	vs_clip	(vdi_handle, FALSE, pxy);				/* klippen ausschalten */
	return (pb-> pb_currstate & ~(SELECTED));
}

