; *********************************************************************** ;
; *********           Routines de base pour demos...           ********** ;
; *********************************************************************** ;
; * - Initialisations et programme principal par DEMOMAKER/ABSTRACT.    * ;
; * - Routine DSP par CHAOS/SANITY.                                     * ;
; * - Adaptation effets ProTracker 2.1A par LEADER ONE.                 * ;
; *********************************************************************** ;

SndTrack	 EQU 	1		; Si =0,pas de musique
					; Si =1,play Yvette !

; *********************************************************************** ;
; **********              Definition des macros                ********** ;
; *********************************************************************** ;

Swap_Screens Macro
	lea 	Adr_Screen1(pc),a0		; Debut adresses ecrans
	movem.l	(a0),d0-d1			; Charge les 2 donnees
	move.l 	d1,(a0)+			; Donnees ecran 1
	move.l 	d0,(a0)+			; Donnees ecran 2
 EndM
 
move_dmacon	MACRO
.setdma\@	MOVE.W D4,-(Sp)			; save D4
		MOVE.W \1,D4
		BTST #15,D4			; set or clear?
		BNE.S .setbits\@		
.clearbits\@	NOT.W D4			; zero so clear
		AND.W D4,shadow_dmacon		; mask bits in dmacon
		BRA.S .dmacon_set\@		; and exit...
.setbits\@	OR.W D4,shadow_dmacon		; not zero so set 'em
.dmacon_set\@	MOVE.W (sp)+,D4			; restore D4
		ENDM
 
; *********************************************************************** ;
; **********               Programme principal                 ********** ;
; *********************************************************************** ;

	TEXT

	pea 	Main(pc)
	move.w 	#38,-(sp)
	trap 	#14
	addq.l 	#6,sp
	clr.w 	-(sp)
	trap 	#1
	 
Main
	move.l 	usp,a0				; Pile utilisateur
	move.l 	a0,Save_User_Stack		; Sauvee
	move.l 	sp,Save_Super_Stack		; Pile superviseur sauvee
	move.w 	#$2500,sr			; Ipl 5
	bsr 	Save_System			; Sauve registres systeme
 IfNe SndTrack	
 	bsr 	Init_Music			; Initialise soundtrack
 EndC
	move.w 	#$2700,sr			; Ipl 7
	bsr 	Init_Screens_Adr		; Initialise adresses ecrans
	bsr 	Init_System			; initialise registres systeme
	move.w 	#$2300,sr			; Ipl 3
Wait_Space
	cmpi.b 	#$1d,$fffffc02.w		; Touche Control appuyee ?
	seq 	Test_Time			; Si oui,le signaler...
	tst.w 	Test_Time			; Test temps machine ?
	beq.s 	No_Test_Time1			; Si non,saut
	move.l 	#$fcfc00fc,$ffff9800.w		; Si oui,fond blanc !
No_Test_Time1
	clr.w 	N_Vbl				; Pas de Vbl passee...
	bsr.s 	Demo				; Execute la demo
	Swap_Screens				; Swappe ecrans logique/phys
	tst.w 	Test_Time			; Test temps machine ?
	beq.s 	Wait_Vbl			; Si non,saut
	clr.l 	$ffff9800.w			; Si oui,fond noir !
Wait_Vbl
	tst.w 	N_Vbl				; Vbl passee ?
	beq.s 	Wait_Vbl			; Si non,on attend !
	move.l 	d1,d0				; Sauve adresse ecran
	lsr.w 	#8,d1				; Decalage mot poids faible
	move.l 	d1,$ffff8200.w			; Adresse ecran (moyen/fort)
	move.b 	d0,$ffff820D.w			; Adresse ecran (faible)
	tst.w 	Space_Pressed			; Touche Espace appuyee ?
	beq.s 	Wait_Space			; Si non,on boucle...
Reset
	move.w 	#$2700,sr			; Ipl 7
	move.l 	Save_User_Stack(pc),a0		; Pile utilisateur
	move.l 	a0,usp				; Restauree
	move.l 	Save_Super_Stack(pc),sp		; Pile superviseur restauree
	move.l 	Error(pc),d0			; Erreur
	beq.s 	No_Error			; Si nulle,pas d'erreur !
	move.l 	d0,$ffff9800.w			; Couleur de l'erreur
Wait_Escape
	cmpi.b 	#$1,$fffffc02.w			; Touche Escape pressee ?
	bne.s 	Wait_Escape			; Si non,on boucle...
No_Error
	bsr 	Restore_System			; Restaure registres systeme
	move.w 	#$2500,sr			; Ipl 5
 IfNe SndTrack	
 	bsr 	Stop_Music			; Arrete soundtrack
 EndC
	move.w 	#$2300,sr			; Ipl 3
	rts	
	
Save_User_Stack
	ds.l 	1
Save_Super_Stack
	ds.l 	1
Test_Time
	ds.w 	1
Space_Pressed
	ds.w 	1
Error
	ds.l 	1
		
; *********************************************************************** ;
; **********           Routine principale de la demo           ********** ;
; *********************************************************************** ;

Demo
	rts
	
; *********************************************************************** ;
; **********        Routines d'initialisation du FALCON        ********** ;
; *********************************************************************** ;

Save_System
	lea 	Old_System(pc),a0		; Espace de sauvegarde
	movec 	cacr,d0				; Valeur du cache
	move.w 	d0,(a0)+			; Sauvee !
	move.b 	$ffff8007.w,(a0)+		; Configuration 68030
	move.b 	$ffff8201.w,(a0)+		; Video (poids fort)
	move.b 	$ffff8203.w,(a0)+		; Video (poids moyen)
	move.b 	$ffff820d.w,(a0)+		; Video (poids faible)
	move.b 	$ffff820a.w,(a0)+		; Synchronisation video
	move.w 	$ffff820e.w,(a0)+		; Offset pour prochaine ligne
	move.w 	$ffff8210.w,(a0)+		; Largeur d'une ligne en mots
	move.b 	$ffff8260.w,(a0)+		; Resolution ST
	move.w 	$ffff8266.w,(a0)+		; Resolution FALCON
	move.w 	$ffff8282.w,(a0)+		; HHT-Synchro
	move.w 	$ffff8284.w,(a0)+		; Fin du decodage de la ligne
	move.w 	$ffff8286.w,(a0)+		; Debut du decodage de la ligne
	move.w 	$ffff8288.w,(a0)+		; Overscan gauche
	move.w 	$ffff828a.w,(a0)+		; Overscan droit
	move.w 	$ffff828c.w,(a0)+		; HSS-Synchro
	move.w 	$ffff828e.w,(a0)+		; HFS
	move.w 	$ffff8290.w,(a0)+		; HEE
	move.w 	$ffff82a2.w,(a0)+		; VFT-Synchro
	move.w 	$ffff82a4.w,(a0)+		; Fin du decodage de l'image
	move.w 	$ffff82a6.w,(a0)+		; Debut du decodage de l'image
	move.w 	$ffff82a8.w,(a0)+		; Overscan haut
	move.w 	$ffff82aa.w,(a0)+		; Overscan bas
	move.w 	$ffff82ac.w,(a0)+		; VSS-Synchro
	move.w 	$ffff82c0.w,(a0)+		; Reconnaissance ST/FALCON
	move.w 	$ffff82c2.w,(a0)+		; Informations resolution
	move.b 	$fffffa01.w,(a0)+		; Registre gpip
	move.b 	$fffffa03.w,(a0)+		; Registre aer
	move.b 	$fffffa05.w,(a0)+		; Registre ddr
	move.b 	$fffffa07.w,(a0)+		; Registre iera
	move.b 	$fffffa09.w,(a0)+		; Registre ierb
	move.b 	$fffffa0b.w,(a0)+		; Registre ipra
	move.b 	$fffffa0d.w,(a0)+		; Registre iprb
	move.b 	$fffffa0f.w,(a0)+		; Registre isra
	move.b 	$fffffa11.w,(a0)+		; Registre isrb
	move.b 	$fffffa13.w,(a0)+		; Registre imra
	move.b 	$fffffa15.w,(a0)+		; Registre imrb
	move.b 	$fffffa17.w,(a0)+		; Registre vr
	move.b 	$fffffa19.w,(a0)+		; Controle Timer A
	move.b 	$fffffa1b.w,(a0)+		; Controle Timer B
	move.b 	$fffffa1d.w,(a0)+		; Controle Timer C et D
	move.b 	$fffffa1f.w,(a0)+		; Donnee Timer A
	move.b 	$fffffa21.w,(a0)+		; Donnee Timer B
	move.b 	$fffffa23.w,(a0)+		; Donnee Timer C
	move.b 	$fffffa25.w,(a0)+		; Donnee Timer D
	move.b 	$fffffa27.w,(a0)+		; Registre ucr
	move.b 	$fffffa2b.w,(a0)+		; Registre rsr
	move.b 	$fffffa2d.w,(a0)+		; Registre tsr
	move.b 	$fffffa2f.w,(a0)+		; Registre udr
	move.l 	$8.w,(a0)+			; Bus error
	move.l 	$10.w,(a0)+			; Illegal error
	move.l 	$14.w,(a0)+			; Div0 error
	move.l 	$68.w,(a0)+			; Adresse HBL
	move.l 	$70.w,(a0)+			; Adresse VBL
	move.l 	$110.w,(a0)+			; Adresse Timer D
	move.l 	$114.w,(a0)+			; Adresse Timer C
	move.l 	$120.w,(a0)+			; Adresse Timer B
	move.l 	$134.w,(a0)+			; Adresse Timer A
	lea 	$ffff8240.w,a1			; Palette ST
	moveq 	#7,d0				; 8 longs...
Save_ST_Palette	
	move.l	(a1)+,(a0)+			; Sauve 2 couleurs
	dbf 	d0,Save_ST_Palette		; Boucle les 16 mots !
	lea 	$ffff9800.w,a1			; Palette FALCON
	move.w 	#255,d0				; 256 longs...
Save_FALCON_Palette
	move.l	(a1)+,(a0)+			; Sauve 1 couleur
	dbf 	d0,Save_FALCON_Palette		; Boucle les 256 longs !
	rts
	
Init_Music
	move.w 	#1,-(sp)
	move.w 	#1,-(sp)
	move.w 	#0,-(sp)
	move.w 	#8,-(sp)
	move.w 	#1,-(sp)
	move.w 	#$8b,-(sp)
	trap 	#14
	lea 	12(sp),sp
	move.w 	#0,-(sp)
	move.w 	#1,-(sp)
	move.w 	#$89,-(sp)
	trap 	#14
	addq.w 	#6,sp
	lea 	Dsp_Rout,a0
	move.l 	a0,a1
	move.l 	#$5ec,d0
	lsr.l 	#2,d0
	subq.w 	#1,d0
lbc000054
	addq.l 	#1,a1
	move.b 	(a1)+,(a0)+
	move.b 	(a1)+,(a0)+
	move.b 	(a1)+,(a0)+
	dbf 	d0,lbc000054
	move.w 	#1,-(sp)
	move.l 	#$17b,-(sp)
	pea 	Dsp_Rout(pc)
	move.w 	#$6e,-(sp)
	trap 	#14
	lea 	12(sp),sp
	bsr.s 	Init_Buffer
	bsr.s 	Init_Module
	bsr 	Init_voices
	rts

Init_Buffer
	lea 	mt_FreqTable,a0
	move.w 	#$4f,d0
Loop_Clear_Buffer
	clr.l 	(a0)+
	dbf 	d0,Loop_Clear_Buffer
	move.w 	#$31f,d0
	move.l 	#$50,d1
	move.l 	#$24665268,d2
Loop_Fill_Buffer
	move.l 	d2,d4
	divu.l 	d1,d4
	move.l 	d4,(a0)+
	addq.l 	#1,d1
	dbf 	d0,Loop_Fill_Buffer
	rts

Init_Module
	lea 	Module,a0
	lea 	$3b6(a0),a1
	lea 	$86(a1),a2
	moveq 	#$1e,d0
	cmp.l 	#"M.K.",$438(a0)
	beq.s 	Instr31
	lea 	$1d6(a0),a1
	lea 	$82(a1),a2
	moveq 	#14,d0
Instr31
	move.l 	a1,Sequence_adr		; Adresse de la sequence.
	move.l 	a2,Patterns_adr		; Adresse des "patterns".
	move.w 	d0,Nb_samples		; Nombre d'instruments.
	move.l 	Sequence_adr,a1
	addq.l 	#2,a1
	moveq 	#$7f,d0
	moveq 	#0,d1
mt_loop
	move.b 	(a1)+,d2
	cmp.b 	d2,d1
	bcc.s 	mt_minus
	move.b 	d2,d1
mt_minus
	dbf 	d0,mt_loop
	addq.w 	#1,d1
	mulu 	#$400,d1
	move.l 	Patterns_adr,a1
	lea 	(a1,d1.l),a1		; A1 => Adresse SAMPLES.
	lea 	$2a(a0),a2		; Pointe sur longueur 1er sample.     
	moveq 	#0,d2
	move.w 	Nb_samples,d0
mt_Clength
	move.w 	(a2),d3
	ext.l 	d3
	add.l 	d3,d3
	add.l 	d3,d2
	add.w 	#$1e,a2
	dbf 	d0,mt_Clength		; Calcule longueur totale des SAMPLES.
	move.l 	#$64000,a2		; Un peu de place pour les precalculs.
					; Cette valeur varie suivant les 
					; modules, mais $64000 semble convenir
					; pour la plupart...
	add.l 	a0,a2
	move.l 	a1,a3
	add.l 	d2,a1
mt_Move
	move.w 	-(a1),-(a2)
	subq.l 	#2,d2
	bne.s 	mt_Move
	lea 	Samples_adr,a1
	move.w 	Nb_samples,d0
mt_NextSample
	move.l 	a3,(a1)+
	tst.w 	$2a(a0)
	beq.s 	mt_NulLength
	tst.w 	$2e(a0)
	bne.s 	mt_RepeatTrue
	move.w 	$2a(a0),d1
	move.w 	d1,d3
	subq.w 	#1,d1
	move.l 	a3,a4
lbc0002b2
	move.w 	(a2)+,(a3)+
	dbf 	d1,lbc0002b2
	bra.s 	lbc0002d2
mt_RepeatTrue
	move.w 	$2e(a0),d1
	move.w 	d1,d3
	subq.w 	#1,d1
	move.l 	a2,a4
lbc0002c4
	move.w 	(a4)+,(a3)+
	dbf 	d1,lbc0002c4
	add.w 	$2a(a0),a2
	add.w 	$2a(a0),a2
lbc0002d2
	move.l 	a3,a5
	moveq 	#0,d1
lbc0002d6
	move.l 	a4,a6
	move.w 	$30(a0),d2
	subq.w 	#1,d2
lbc0002de
	move.w 	(a6)+,(a3)+
	addq.w 	#2,d1
	dbf 	d2,lbc0002de
	cmp.w 	#$384,d1
	bcs.s 	lbc0002d6
	move.w 	#$1c1,d2
lbc0002f0
	move.w 	(a5)+,(a3)+
	dbf 	d2,lbc0002f0
	add.w 	d3,d3
	move.w 	d3,$2a(a0)
	move.w 	d1,$30(a0)
	clr.w 	$2e(a0)
mt_NulLength
	lea 	$1e(a0),a0
	dbf 	d0,mt_NextSample
	rts

Init_voices
	lea 	NullSample,a0
	move.l 	a0,a1
	lea 	$384(a1),a2
	move.w 	#$383,d0
lbc00034e
	clr.w 	(a0)+
	dbf 	d0,lbc00034e
	lea 	DSP_datas,a0	
	move.w 	#3,d0
lbc00035e
	move.l 	a1,(a0)
	move.l 	a2,4(a0)
	move.l 	#$384,8(a0)
	move.w 	#$320,12(a0)
	clr.w 	14(a0)
	move.w 	#$ffff,$10(a0)
	add.w 	#$12,a0
	dbf 	d0,lbc00035e
	
	move_dmacon #$F
	
	rts

Init_Screens_Adr
	lea 	Screens,a0		        ; Espace pour ecrans
	lea 	Adr_Screen1(pc),a1		; Premiere adresse
	moveq 	#1,d0				; 2 ecrans
Init_Screen_Adr
	move.l 	a0,d1				; Adresse ecran
	addi.l 	#256,d1				; +256
	andi.l 	#$ffffff00,d1			; Multiple de 256
	move.l 	d1,(a1)+			; Adresse sauvee !
	adda.l 	#64256,a0			; Prochain ecran
	dbf 	d0,Init_Screen_Adr		; Boucle les 2 ecrans
	rts
	
Adr_Screen1
	ds.l 	1
Adr_Screen2
	ds.l 	1

Init_System
	movec 	cacr,d0			; Valeur du cache
	move.w 	#$2d0d,d0		; Caches actives
	movec 	d0,cacr			; Nouvelle valeur
	move.b 	#5,$ffff8007.w		; 68030 et Blitter a 16 Mhz
	move.l 	Adr_Screen1(pc),d0	; Adresse ecran...
	lsr.w 	#8,d0			; Adresse hardware
	move.l 	d0,$ffff8200.w		; Fixee !
	move.l 	Adr_Screen1(pc),d0	; Adresse ecran...
	move.b 	d0,$ffff820d.w		; Fixee ! (poid faible)
	move.b 	#2,$ffff820a.w		; 50 Hz
	clr.w 	$ffff820e.w		; Offset pour prochaine ligne nul
	move.w 	#160,$ffff8210.w	; Largeur d'une ligne en mots=160
	move.w 	#16,$ffff8266.w		; Resolution FALCON=256 couleurs
	cmpi.b 	#128,$ffff8006.w	; Ecran VGA ?
	bhs.s 	Vga_Screen		; Si oui,saut...
	move.w 	#254,$ffff8282.w	; HHT-Synchro
	move.w 	#203,$ffff8284.w	; Fin du decodage de la ligne
	move.w 	#39,$ffff8286.w		; Debut du decodage de la ligne
	move.w 	#28,$ffff8288.w		; Overscan gauche
	move.w 	#125,$ffff828a.w	; Overscan droit
	move.w 	#216,$ffff828c.w	; HSS-Synchro
	clr.w 	$ffff828e.w		; HFS
	clr.w 	$ffff8290.w		; HEE
	move.w 	#625,$ffff82a2.w	; VFT-Synchro
	move.w 	#613,$ffff82a4.w	; Fin du decodage de l'image
	move.w 	#47,$ffff82a6.w		; Debut du decodage de l'image
	move.w 	#127,$ffff82a8.w	; Overscan haut
	move.w 	#527,$ffff82aa.w	; Overscan bas
	move.w 	#619,$ffff82ac.w	; VSS-Synchro
	move.w 	#385,$ffff82c0.w	; Indique resolution FALCON
	clr.w 	$ffff82c2.w		; Informations resolution
	bra.s 	TV_Screen		; Sauter VGA infos
Vga_Screen
	move.w 	#198,$ffff8282.w	; HHT-Synchro
	move.w 	#141,$ffff8284.w	; Fin du decodage de la ligne
	move.w 	#21,$ffff8286.w		; Debut du decodage de la ligne
	move.w 	#666,$ffff8288.w	; Overscan gauche
	move.w 	#123,$ffff828a.w	; Overscan droit
	move.w 	#150,$ffff828c.w	; HSS-Synchro
	clr.w 	$ffff828e.w		; HFS
	clr.w 	$ffff8290.w		; HEE
	move.w 	#1049,$ffff82a2.w	; VFT-Synchro
	move.w 	#1023,$ffff82a4.w	; Fin du decodage de l'image
	move.w 	#63,$ffff82a6.w		; Debut du decodage de l'image
	move.w 	#63,$ffff82a8.w		; Overscan haut
	move.w 	#1023,$ffff82aa.w	; Overscan bas
	move.w 	#1045,$ffff82ac.w	; VSS-Synchro
	move.w 	#390,$ffff82c0.w	; Indique resolution FALCON
	clr.w 	$ffff82c2.w		; Informations resolution
TV_Screen
	clr.b 	$fffffa07.w		; Registre iera nul
	clr.b 	$fffffa09.w		; Registre ierb nul
	clr.b 	$fffffa0b.w		; Registre ipra nul
	clr.b 	$fffffa0d.w		; Registre iprb nul
	clr.b 	$fffffa0f.w		; Registre isra nul
	clr.b 	$fffffa11.w		; Registre isrb nul
	clr.b 	$fffffa13.w		; Registre imra nul
	clr.b 	$fffffa15.w		; Registre imrb nul
	bclr 	#3,$fffffa17.w		; Fin interruptions automatique
	clr.b 	$fffffa19.w		; Timer A stoppe
	clr.b 	$fffffa1b.w		; Timer B stoppe
	clr.b 	$fffffa1d.w		; Timer C et D stoppes
	clr.b 	$fffffa1f.w		; Donnee Timer B nulle
	clr.b 	$fffffa21.w		; Donnee Timer B nulle
	clr.b 	$fffffa23.w		; Donnee Timer C nulle
	clr.b 	$fffffa25.w		; Donnee Timer D nulle
	move.l 	#Bus_Error,$8.w		; Deroute erreur bus
	move.l 	#Ilg_Error,$10.w	; Deroute erreur illegal
	move.l 	#Div_Error,$14.w	; Deroute erreur div0
	move.l 	#New_Hbl,$68.w		; Nouvelle routine HBL !
	move.l 	#New_Vbl,$70.w		; Nouvelle routine VBL !
	clr.l 	$110.w			; Pas de Timer D
	clr.l 	$114.w			; Pas de Timer C
	clr.l 	$120.w			; Pas de Timer B
	clr.l 	$134.w			; Pas de Timer A
 IfNe SndTrack	
 	move.l 	#Timer_A,$134.w		; Routine de SoundTrack
	ori.b 	#32,$fffffa07.w		; Timer A active
	ori.b 	#32,$fffffa13.w		; Timer A non masque
	move.b 	#7,$fffffa19.w		; Base Timer A = 12288 Hz
	move.b 	#$cc,$fffffa1f.w	; Frequence Timer A = 60 Hz
 EndC
	moveq 	#0,d0			; d0 nul
	lea 	$ffff8240.w,a0		; Palette ST
	moveq 	#7,d1			; 8 longs...
Init_ST_Palette
	move.l 	d0,(a0)+		; 2 couleurs noires
	dbf 	d1,Init_ST_Palette	; Boucle les 16 mots !
	lea 	$ffff9800.w,a0		; Palette FALCON
	move.w 	#255,d1			; 256 longs...
Init_FALCON_Palette	
	move.l 	d0,(a0)+		; 1 couleur noire
	dbf 	d1,Init_FALCON_Palette	; Boucle les 256 longs !
	rts	
	
Restore_System
	lea 	Old_System(pc),a0	; Espace de sauvegarde
	move.w 	(a0)+,d0		; Valeur du cache
	movec 	d0,cacr			; Restauree !
	move.b 	(a0)+,$ffff8007.w	; Configuration 68030
	move.b 	(a0)+,$ffff8201.w	; Video (poids fort)
	move.b 	(a0)+,$ffff8203.w	; Video (poids moyen)
	move.b 	(a0)+,$ffff820d.w	; Video (poids faible)
	move.b 	(a0)+,$ffff820a.w	; Synchronisation video
	move.w 	(a0)+,$ffff820e.w	; Offset pour prochaine ligne
	move.w 	(a0)+,$ffff8210.w	; Largeur d'une ligne en mots
	move.b 	(a0)+,d0		; Resolution ST
	move.w 	(a0)+,d1		; Resolution FALCON
	move.w 	(a0)+,$ffff8282.w	; HHT-Synchro
	move.w 	(a0)+,$ffff8284.w	; Fin du decodage de la ligne
	move.w 	(a0)+,$ffff8286.w	; Debut du decodage de la ligne
	move.w 	(a0)+,$ffff8288.w	; Overscan gauche
	move.w 	(a0)+,$ffff828a.w	; Overscan droit
	move.w 	(a0)+,$ffff828c.w	; HSS-Synchro
	move.w 	(a0)+,$ffff828e.w	; HFS
	move.w 	(a0)+,$ffff8290.w	; HEE
	move.w 	(a0)+,$ffff82a2.w	; VFT-Synchro
	move.w 	(a0)+,$ffff82a4.w	; Fin du decodage de l'image
	move.w 	(a0)+,$ffff82a6.w	; Debut du decodage de l'image
	move.w 	(a0)+,$ffff82a8.w	; Overscan haut
	move.w 	(a0)+,$ffff82aa.w	; Overscan bas
	move.w 	(a0)+,$ffff82ac.w	; VSS-Synchro
	move.w 	(a0)+,$ffff82c0.w	; Reconnaissance ST/FALCON
	move.w 	(a0)+,$ffff82c2.w	; Informations resolution
	move.b 	(a0)+,$fffffa01.w	; Registre gpip
	move.b 	(a0)+,$fffffa03.w	; Registre aer
	move.b 	(a0)+,$fffffa05.w	; Registre ddr
	move.b 	(a0)+,$fffffa07.w	; Registre iera
	move.b 	(a0)+,$fffffa09.w	; Registre ierb
	move.b 	(a0)+,$fffffa0b.w	; Registre ipra
	move.b 	(a0)+,$fffffa0d.w	; Registre iprb
	move.b 	(a0)+,$fffffa0f.w	; Registre isra
	move.b 	(a0)+,$fffffa11.w	; Registre isrb
	move.b 	(a0)+,$fffffa13.w	; Registre imra
	move.b 	(a0)+,$fffffa15.w	; Registre imrb
	move.b 	(a0)+,$fffffa17.w	; Registre vr
	move.b 	(a0)+,$fffffa19.w	; Controle Timer A
	move.b 	(a0)+,$fffffa1b.w	; Controle Timer B
	move.b 	(a0)+,$fffffa1d.w	; Controle Timer C et D
	move.b 	(a0)+,$fffffa1f.w	; Donnee Timer A
	move.b 	(a0)+,$fffffa21.w	; Donnee Timer B
	move.b 	(a0)+,$fffffa23.w	; Donnee Timer C
	move.b 	(a0)+,$fffffa25.w	; Donnee Timer D
	move.b 	(a0)+,$fffffa27.w	; Registre ucr
	move.b 	(a0)+,$fffffa2b.w	; Registre rsr
	move.b 	(a0)+,$fffffa2d.w	; Registre tsr
	move.b 	(a0)+,$fffffa2f.w	; Registre udr
	move.l 	(a0)+,$8.w		; Bus error
	move.l 	(a0)+,$10.w		; Illegal error
	move.l 	(a0)+,$14.w		; Div0 error
	move.l 	(a0)+,$68.w		; Adresse HBL
	move.l 	(a0)+,$70.w		; Adresse VBL
	move.l 	(a0)+,$110.w		; Adresse Timer D
	move.l 	(a0)+,$114.w		; Adresse Timer C
	move.l 	(a0)+,$120.w		; Adresse Timer B
	move.l 	(a0)+,$134.w		; Adresse Timer A
	btst 	#0,$ffff82c0		; Resolution FALCON ?
	bne.s 	Falcon_Rez		; Si oui,saut !
	move.w 	d1,$ffff8266.w		; Fixe resolution FALCON...
	move.b 	d0,$ffff8260.w		; Fixe resolution ST...
	bra.s 	St_Rez			; Saut
Falcon_Rez
	move.w 	d1,$ffff8266.w		; Fixe resolution FALCON...
St_Rez	
	lea 	$ffff8240.w,a1		; Palette ST
	moveq 	#7,d0			; 8 longs...
Restore_ST_Palette	
	move.l 	(a0)+,(a1)+		; Restaure 2 couleurs
	dbf 	d0,Restore_ST_Palette	; Boucle les 16 mots !
	lea 	$ffff9800.w,a1		; Palette FALCON
	move.w 	#255,d0			; 256 longs...
Restore_FALCON_Palette
	move.l 	(a0)+,(a1)+		; Restaure 1 couleur
	dbf 	d0,Restore_FALCON_Palette	; Boucle les 256 longs !
Wait_No_Key
	move.b 	$fffffc02.w,d0		; Code clavier
	btst 	#0,$fffffc00.w		; Buffer vide ?
	bne.s 	Wait_No_Key		; Sinon,on continue...
	rts	
	
Stop_Music
	move.w 	#1,-(sp)
	move.w 	#0,-(sp)
	move.w 	#0,-(sp)
	move.w 	#8,-(sp)
	move.w 	#0,-(sp)
	move.w 	#$8b,-(sp)
	trap 	#14
	lea 	12(sp),sp
	move.w 	#0,-(sp)
	move.w 	#$84,-(sp)
	trap 	#14
	addq.w 	#4,sp
	rts

Old_System
	ds.l 	50+8+256

; *********************************************************************** ;
; **********               Gestion des erreurs !               ********** ;
; *********************************************************************** ;

Bus_Error
	move.l 	#$fc000000,Error		; Rouge
	jmp 	Reset
	
Ilg_Error
	move.l 	#$00fc0000,Error		; Vert
	jmp 	Reset
	
Div_Error
	move.l 	#$000000fc,Error		; Bleu
	jmp 	Reset

; *********************************************************************** ;
; **********        Routines tournant sous interruption        ********** ;
; *********************************************************************** ;

New_Hbl
	rte

New_Vbl
	addq.w 	#1,N_Vbl			; Signale Vbl
	cmpi.b 	#$39,$fffffc02.w		; Touche Espace appuyee ?
	bne.s 	End_Vbl				; Si non,saut !
	st 	Space_Pressed			; Si oui,le signaler...
End_Vbl
	rte
	
N_Vbl
	ds.w 	1
	
; *********************************************************************** ;
; **********               Gestion du SoundTrack               ********** ;
; *********************************************************************** ;

n_note		EQU	0  ; W
n_cmd		EQU	2  ; W
n_cmdlo		EQU	3  ; B
n_start		EQU	4  ; L
n_length	EQU	8  ; W
n_loopstart	EQU	10 ; L
n_replen	EQU	14 ; W
n_period	EQU	16 ; W
n_finetune	EQU	18 ; B
n_volume	EQU	19 ; B
n_dmabit	EQU	20 ; W
n_toneportdirec	EQU	22 ; B
n_toneportspeed	EQU	23 ; B
n_wantedperiod	EQU	24 ; W
n_vibratocmd	EQU	26 ; B
n_vibratopos	EQU	27 ; B
n_tremolocmd	EQU	28 ; B
n_tremolopos	EQU	29 ; B
n_wavecontrol	EQU	30 ; B
n_glissfunk	EQU	31 ; B
n_sampleoffset	EQU	32 ; B
n_pattpos	EQU	33 ; B
n_loopcount	EQU	34 ; B
n_funkoffset	EQU	35 ; B
n_wavestart	EQU	36 ; L
n_reallength	EQU	40 ; L

sam_start	EQU	0  ; L
sam_length	EQU	4  ; W
sam_period	EQU	6  ; W
sam_vol		EQU	8  ; W
sam_lpstart	EQU	10 ; L
sam_lplength	EQU	14 ; W

DSP_start	EQU	0  ; L
DSP_end		EQU	4  ; L
DSP_repstart	EQU	8  ; L
DSP_period	EQU	12 ; W
DSP_vol		EQU	14 ; W
DSP_repeat	EQU	16 ; W

Timer_A
	movem.l	d0-a6,-(sp)
	lea 	$ffffa200,a6
	lea 	mt_FreqTable,a0
	lea 	DSP_datas,a1
	clr.b 	7(a6)
	bsr.s 	Play_A_Voice
	bsr.s 	Play_A_Voice
	bsr.s 	Play_A_Voice
	bsr.s 	Play_A_Voice
	bsr.s 	Play_Patterns
	movem.l	(sp)+,d0-a6
	rte

Play_A_Voice
	move.b 	DSP_vol+1(a1),5(a6)
	clr.w 	6(a6)
	move.w 	DSP_period(a1),d0
	lea 	(a0,d0.w*4),a3
	move.l 	(a3),4(a6)
	moveq 	#0,d0
wait_DSP1
	btst 	#0,2(a6)
	beq.s 	wait_DSP1
	move.l 	4(a6),d0
	tst.w 	DSP_repeat(a1)
	beq.s 	lbc0001a8
	clr.w 	DSP_repeat(a1)
	move.l 	DSP_start(a1),a2
	bra.s 	lbc0001bc
lbc0001a8
	add.l 	(a1),d0
	cmp.l 	DSP_end(a1),d0
	bcs.s 	lbc0001b6
	sub.l 	DSP_repstart(a1),d0
lbc0001b6
	move.l 	d0,(a1)
	move.l 	d0,a2
lbc0001bc
	moveq 	#0,d0
wait_DSP2
;	btst 	#0,2(a6)	; Pas la peine...
;	beq.s 	wait_DSP2	; DSP works very fast !!!
				; Enlever les points-virgule si problemes...
	move.l 	4(a6),d0
	divu 	#3,d0
	addq.w 	#2,d0
	move.w 	d0,d2
	clr.b 	5(a6)
	move.w 	d0,6(a6)
	subq.w 	#1,d2
transmit_loop
	move.b 	(a2)+,5(a6)
	move.w 	(a2)+,6(a6)
	dbf 	d2,transmit_loop
	add.w 	#18,a1
	rts

Play_Patterns
	lea 	Module,a0
	ADDQ.B	#1,mt_counter
	MOVE.B	mt_counter(PC),D0
	CMP.B	mt_speed(PC),D0
	BNE.S	mt_NoNewNote
	MOVE.B	#$FF,mt_counter
	TST.B	mt_PattDelTime2
	BEQ.S	mt_GetNewNote
	BSR.S	mt_NoNewAllChannels
	BRA	mt_dskip

mt_NoNewNote
	BSR.S	mt_NoNewAllChannels
	BRA	mt_NoNewPosYet

mt_NoNewAllChannels
	LEA	ch1s(PC),A5
	LEA	mt_chan1temp(PC),A6
	BSR	mt_CheckEfx
	LEA	ch2s(PC),A5
	LEA	mt_chan2temp(PC),A6
	BSR	mt_CheckEfx
	LEA	ch3s(PC),A5
	LEA	mt_chan3temp(PC),A6
	BSR	mt_CheckEfx
	LEA	ch4s(PC),A5
	LEA	mt_chan4temp(PC),A6
	BRA	mt_CheckEfx

mt_GetNewNote
	LEA	Module(PC),A3
	LEA	$2A(A3),A3
	MOVE.L	Sequence_adr,A2				;pattpo
	ADDQ.l	#2,A2
	MOVE.L	Patterns_adr,A0				;patterndata
	MOVEQ	#0,D0
	MOVEQ	#0,D1
	MOVE.B	mt_SongPos(PC),D0
	MOVE.B	(A2,D0.W),D1
	ASL.L	#8,D1
	ASL.L	#2,D1
	ADD.W	mt_PatternPos(PC),D1
	CLR.W	mt_DMACONtemp

	LEA	ch1s(PC),A5
	LEA	mt_chan1temp(PC),A6
	BSR.S	mt_PlayVoice
	LEA	ch2s(PC),A5
	LEA	mt_chan2temp(PC),A6
	BSR.S	mt_PlayVoice
	LEA	ch3s(PC),A5
	LEA	mt_chan3temp(PC),A6
	BSR.S	mt_PlayVoice
	LEA	ch4s(PC),A5
	LEA	mt_chan4temp(PC),A6
	BSR.S	mt_PlayVoice
	BRA	mt_SetDMA

mt_PlayVoice
	TST.L	(A6)
	BNE.S	mt_plvskip
	BSR	mt_PerNop
mt_plvskip
	MOVE.L	(A0,D1.L),(A6)
	ADDQ.L	#4,D1
	MOVEQ	#0,D2
	MOVE.B	n_cmd(A6),D2
	AND.B	#$F0,D2
	LSR.B	#4,D2
	MOVE.B	(A6),D0
	AND.B	#$F0,D0
	OR.B	D0,D2
	TST.B	D2
	BEQ.S	mt_SetRegs
	MOVEQ	#0,D3
	SUBQ.L	#1,D2
	MOVE	D2,D4
	ASL.L	#2,D2
	MULU	#30,D4
	LEA	Samples_adr,A1
	MOVE.L	(A1,D2.L),n_start(A6)
	MOVE.W	(A3,D4.L),n_length(A6)
	MOVE.W	(A3,D4.L),n_reallength(A6)
	MOVE.W	2(A3,D4.L),n_finetune(A6)
	MOVE.W	4(A3,D4.L),D3 ; Get repeat
	TST.W	D3
	BEQ.S	mt_NoLoop
	MOVE.L	n_start(A6),D2				; Get start
	ASL.W	#1,D3
	ADD.L	D3,D2					; Add repeat
	MOVE.L	D2,n_loopstart(A6)
	MOVE.L	D2,n_wavestart(A6)
	MOVE.W	4(A3,D4.L),D0				; Get repeat
	ADD.W	6(A3,D4.L),D0				; Add replen
	MOVE.W	D0,n_length(A6)
	MOVE.W	6(A3,D4.L),n_replen(A6)			; Save replen
	MOVEQ	#0,D0
	MOVE.B	n_volume(A6),D0
	MOVE.W	D0,sam_vol(A5)				; Set volume
	BRA.S	mt_SetRegs

mt_NoLoop
	MOVE.L	n_start(A6),D2
	MOVE.L	D2,n_loopstart(A6)
	MOVE.L	D2,n_wavestart(A6)
	MOVE.W	6(A3,D4.L),n_replen(A6)			; Save replen
	MOVEQ	#0,D0
	MOVE.B	n_volume(A6),D0
	MOVE.W	D0,sam_vol(A5)				; Set volume
mt_SetRegs
	MOVE.W	(A6),D0
	AND.W	#$0FFF,D0
	BEQ	mt_CheckMoreEfx				; If no note
	MOVE.W	2(A6),D0
	AND.W	#$0FF0,D0
	CMP.W	#$0E50,D0
	BEQ.S	mt_DoSetFineTune
	MOVE.B	2(A6),D0
	AND.B	#$0F,D0
	CMP.B	#3,D0					; TonePortamento
	BEQ.S	mt_ChkTonePorta
	CMP.B	#5,D0
	BEQ.S	mt_ChkTonePorta
	CMP.B	#9,D0					; Sample Offset
	BNE.S	mt_SetPeriod
	BSR	mt_CheckMoreEfx
	BRA.S	mt_SetPeriod

mt_DoSetFineTune
	BSR	mt_SetFineTune
	BRA.S	mt_SetPeriod

mt_ChkTonePorta
	BSR	mt_SetTonePorta
	BRA	mt_CheckMoreEfx

mt_SetPeriod
	MOVEM.L	D0-D1/A0-A1,-(SP)
	MOVE.W	(A6),D1
	AND.W	#$0FFF,D1
	LEA	mt_PeriodTable(PC),A1
	MOVEQ	#0,D0
	MOVEQ	#36,D2
mt_ftuloop
	CMP.W	(A1,D0.W),D1
	BHS.S	mt_ftufound
	ADDQ.L	#2,D0
	DBRA	D2,mt_ftuloop
mt_ftufound
	MOVEQ	#0,D1
	MOVE.B	n_finetune(A6),D1
	MULU	#36*2,D1
	ADD.L	D1,A1
	MOVE.W	(A1,D0.W),n_period(A6)
	MOVEM.L	(SP)+,D0-D1/A0-A1

	MOVE.W	2(A6),D0
	AND.W	#$0FF0,D0
	CMP.W	#$0ED0,D0 ; Notedelay
	BEQ	mt_CheckMoreEfx

	move_dmacon n_dmabit(A6)
	
	BTST	#2,n_wavecontrol(A6)
	BNE.S	mt_vibnoc
	CLR.B	n_vibratopos(A6)
mt_vibnoc
	BTST	#6,n_wavecontrol(A6)
	BNE.S	mt_trenoc
	CLR.B	n_tremolopos(A6)
mt_trenoc
	MOVE.L	n_start(A6),sam_start(A5)		; Set start
	MOVE.W	n_length(A6),sam_length(A5)		; Set length
	
	MOVE.W	n_period(A6),D0
	MOVE.W	D0,sam_period(A5)			; Set period
	
	MOVE.w	n_dmabit(A6),D0
	OR.W	D0,mt_DMACONtemp

	BRA	mt_CheckMoreEfx
	
mt_SetDMA
	lea 	DSP_datas,a0
	
	move.w 	mt_DMACONtemp(pc),d0
	btst 	#0,d0
	beq.s 	ch1_OFF
	
	lea	ch1s(PC),a5
	lea	mt_chan1temp(PC),a6
	moveq 	#0,d1
	moveq 	#0,d2
	move.w 	sam_length(a5),d1
	move.w 	n_replen(a6),d2
	add.l 	d2,d1
	move.l 	sam_start(a5),(a0)
	add.l 	sam_start(a5),d1
	move.l 	d1,DSP_end(a0)
	move.l 	d2,DSP_repstart(a0)
	move.w 	#$ffff,DSP_repeat(a0)
	
ch1_OFF
	lea 	18(a0),a0
	btst 	#1,d0
	beq.s 	ch2_OFF
	
	lea	ch2s(PC),a5
	lea	mt_chan2temp(PC),a6
	moveq 	#0,d1
	moveq 	#0,d2
	move.w 	sam_length(a5),d1
	move.w 	n_replen(a6),d2
	add.l 	d2,d1
	move.l 	sam_start(a5),(a0)
	add.l 	sam_start(a5),d1
	move.l 	d1,DSP_end(a0)
	move.l 	d2,DSP_repstart(a0)
	move.w 	#$ffff,DSP_repeat(a0)
	
ch2_OFF
	lea 	18(a0),a0
	btst 	#2,d0
	beq.s 	ch3_OFF
	
	lea	ch3s(PC),a5
	lea	mt_chan3temp(PC),a6
	moveq 	#0,d1
	moveq 	#0,d2
	move.w 	sam_length(a5),d1
	move.w 	n_replen(a6),d2
	add.l 	d2,d1
	move.l 	sam_start(a5),(a0)
	add.l 	sam_start(a5),d1
	move.l 	d1,DSP_end(a0)
	move.l 	d2,DSP_repstart(a0)
	move.w 	#$ffff,DSP_repeat(a0)
	
ch3_OFF
	lea 	18(a0),a0
	btst 	#3,d0
	beq.s 	ch4_OFF
	
	lea	ch4s(PC),a5
	lea	mt_chan4temp(PC),a6
	moveq 	#0,d1
	moveq 	#0,d2
	move.w 	sam_length(a5),d1
	move.w 	n_replen(a6),d2
	add.l 	d2,d1
	move.l 	sam_start(a5),(a0)
	add.l 	sam_start(a5),d1
	move.l 	d1,DSP_end(a0)
	move.l 	d2,DSP_repstart(a0)
	move.w 	#$ffff,DSP_repeat(a0)
	
ch4_OFF
mt_dskip
	add.w 	#$10,mt_PatternPos
	move.b	mt_PattDelTime,d0
	beq.s	mt_dskc
	move.b	d0,mt_PattDelTime2
	clr.b	mt_PattDelTime
mt_dskc
	tst.b	mt_PattDelTime2
	beq.s	mt_dska
	subq.b	#1,mt_PattDelTime2
	beq.s	mt_dska
	sub.w	#16,mt_PatternPos
mt_dska
	tst.b	mt_PBreakFlag
	beq.s	mt_nnpysk
	sf	mt_PBreakFlag
	moveq	#0,d0
	move.b	mt_PBreakPos(PC),d0
	clr.b	mt_PBreakPos
	lsl.w	#4,d0
	move.w	d0,mt_PatternPos
mt_nnpysk
	cmp.w 	#$400,mt_PatternPos
	blo.s 	mt_NoNewPosYet
mt_NextPosition
	moveq	#0,d0
	move.b	mt_PBreakPos(pc),d0
	lsl.w	#4,d0
	move.w	d0,mt_PatternPos
	clr.b	mt_PBreakPos
	clr.b 	mt_PosJumpFlag
	addq.b 	#1,mt_SongPos
	and.b 	#$7f,mt_SongPos
	move.b 	mt_SongPos(pc),d1
	move.l 	Sequence_adr,a0
	cmp.b 	(a0),d1
	blo.s 	mt_NoNewPosYet
	clr.b	mt_SongPos
mt_NoNewPosYet
	tst.b 	mt_PosJumpFlag
	bne.s 	mt_NextPosition
	
	lea 	DSP_datas,a6
	lea	ch1s(pc),a5
	
	move.w 	sam_period(a5),DSP_period(a6)
	move.w	sam_vol(a5),DSP_vol(a6)
	lea 	16(a5),a5
	lea	18(a6),a6
	move.w 	sam_period(a5),DSP_period(a6)
	move.w	sam_vol(a5),DSP_vol(a6)
	lea 	16(a5),a5
	lea	18(a6),a6
	move.w 	sam_period(a5),DSP_period(a6)
	move.w	sam_vol(a5),DSP_vol(a6)
	lea 	16(a5),a5
	lea	18(a6),a6
	move.w 	sam_period(a5),DSP_period(a6)
	move.w	sam_vol(a5),DSP_vol(a6)
mt_exit	
	rts

mt_CheckEfx
	BSR	mt_UpdateFunk
	MOVE.W	n_cmd(A6),D0
	AND.W	#$0FFF,D0
	BEQ.S	mt_PerNop
	MOVE.B	n_cmd(A6),D0
	AND.B	#$0F,D0
	BEQ.S	mt_Arpeggio
	CMP.B	#1,D0
	BEQ	mt_PortaUp
	CMP.B	#2,D0
	BEQ	mt_PortaDown
	CMP.B	#3,D0
	BEQ	mt_TonePortamento
	CMP.B	#4,D0
	BEQ	mt_Vibrato
	CMP.B	#5,D0
	BEQ	mt_TonePlusVolSlide
	CMP.B	#6,D0
	BEQ	mt_VibratoPlusVolSlide
	CMP.B	#$E,D0
	BEQ	mt_E_Commands
SetBack	MOVE.W	n_period(A6),sam_period(A5)
	CMP.B	#7,D0
	BEQ	mt_Tremolo
	CMP.B	#$A,D0
	BEQ	mt_VolumeSlide
mt_Return
	RTS

mt_PerNop
	MOVE.W	n_period(A6),sam_period(A5)
	RTS

mt_Arpeggio
	MOVEQ	#0,D0
	MOVE.B	mt_counter(PC),D0
	DIVS	#3,D0
	SWAP	D0
	CMP.W	#0,D0
	BEQ.S	mt_Arpeggio2
	CMP.W	#2,D0
	BEQ.S	mt_Arpeggio1
	MOVEQ	#0,D0
	MOVE.B	n_cmdlo(A6),D0
	LSR.B	#4,D0
	BRA.S	mt_Arpeggio3

mt_Arpeggio1
	MOVEQ	#0,D0
	MOVE.B	n_cmdlo(A6),D0
	AND.B	#15,D0
	BRA.S	mt_Arpeggio3

mt_Arpeggio2
	MOVE.W	n_period(A6),D2
	BRA.S	mt_Arpeggio4

mt_Arpeggio3
	ASL.W	#1,D0
	MOVEQ	#0,D1
	MOVE.B	n_finetune(A6),D1
	MULU	#36*2,D1
	LEA	mt_PeriodTable(PC),A0
	ADD.L	D1,A0
	MOVEQ	#0,D1
	MOVE.W	n_period(A6),D1
	MOVEQ	#36,D3
mt_arploop
	MOVE.W	(A0,D0.W),D2
	CMP.W	(A0),D1
	BHS.S	mt_Arpeggio4
	ADDQ.L	#2,A0
	DBRA	D3,mt_arploop
	RTS

mt_Arpeggio4
	MOVE.W	D2,sam_period(A5)
	RTS

mt_FinePortaUp
	TST.B	mt_counter
	BNE.S	mt_Return
	MOVE.B	#$0F,mt_LowMask
mt_PortaUp
	MOVEQ	#0,D0
	MOVE.B	n_cmdlo(A6),D0
	AND.B	mt_LowMask(PC),D0
	MOVE.B	#$FF,mt_LowMask
	SUB.W	D0,n_period(A6)
	MOVE.W	n_period(A6),D0
	AND.W	#$0FFF,D0
	CMP.W	#113,D0
	BPL.S	mt_PortaUskip
	AND.W	#$F000,n_period(A6)
	OR.W	#113,n_period(A6)
mt_PortaUskip
	MOVE.W	n_period(A6),D0
	AND.W	#$0FFF,D0
	MOVE.W	D0,sam_period(A5)
	RTS	
 
mt_FinePortaDown
	TST.B	mt_counter
	BNE	mt_Return
	MOVE.B	#$0F,mt_LowMask
mt_PortaDown
	CLR.W	D0
	MOVE.B	n_cmdlo(A6),D0
	AND.B	mt_LowMask(PC),D0
	MOVE.B	#$FF,mt_LowMask
	ADD.W	D0,n_period(A6)
	MOVE.W	n_period(A6),D0
	AND.W	#$0FFF,D0
	CMP.W	#856,D0
	BMI.S	mt_PortaDskip
	AND.W	#$F000,n_period(A6)
	OR.W	#856,n_period(A6)
mt_PortaDskip
	MOVE.W	n_period(A6),D0
	AND.W	#$0FFF,D0
	MOVE.W	D0,sam_period(A5)
	RTS

mt_SetTonePorta
	MOVE.L	A0,-(SP)
	MOVE.W	(A6),D2
	AND.W	#$0FFF,D2
	MOVEQ	#0,D0
	MOVE.B	n_finetune(A6),D0
	MULU	#37*2,D0
	LEA	mt_PeriodTable(PC),A0
	ADD.L	D0,A0
	MOVEQ	#0,D0
mt_StpLoop
	CMP.W	(A0,D0.W),D2
	BHS.S	mt_StpFound
	ADDQ.W	#2,D0
	CMP.W	#37*2,D0
	BLO.S	mt_StpLoop
	MOVEQ	#35*2,D0
mt_StpFound
	MOVE.B	n_finetune(A6),D2
	AND.B	#8,D2
	BEQ.S	mt_StpGoss
	TST.W	D0
	BEQ.S	mt_StpGoss
	SUBQ.W	#2,D0
mt_StpGoss
	MOVE.W	(A0,D0.W),D2
	MOVE.L	(SP)+,A0
	MOVE.W	D2,n_wantedperiod(A6)
	MOVE.W	n_period(A6),D0
	CLR.B	n_toneportdirec(A6)
	CMP.W	D0,D2
	BEQ.S	mt_ClearTonePorta
	BGE	mt_Return
	MOVE.B	#1,n_toneportdirec(A6)
	RTS

mt_ClearTonePorta
	CLR.W	n_wantedperiod(A6)
	RTS

mt_TonePortamento
	MOVE.B	n_cmdlo(A6),D0
	BEQ.S	mt_TonePortNoChange
	MOVE.B	D0,n_toneportspeed(A6)
	CLR.B	n_cmdlo(A6)
mt_TonePortNoChange
	TST.W	n_wantedperiod(A6)
	BEQ	mt_Return
	MOVEQ	#0,D0
	MOVE.B	n_toneportspeed(A6),D0
	TST.B	n_toneportdirec(A6)
	BNE.S	mt_TonePortaUp
mt_TonePortaDown
	ADD.W	D0,n_period(A6)
	MOVE.W	n_wantedperiod(A6),D0
	CMP.W	n_period(A6),D0
	BGT.S	mt_TonePortaSetPer
	MOVE.W	n_wantedperiod(A6),n_period(A6)
	CLR.W	n_wantedperiod(A6)
	BRA.S	mt_TonePortaSetPer

mt_TonePortaUp
	SUB.W	D0,n_period(A6)
	MOVE.W	n_wantedperiod(A6),D0
	CMP.W	n_period(A6),D0
	BLT.S	mt_TonePortaSetPer
	MOVE.W	n_wantedperiod(A6),n_period(A6)
	CLR.W	n_wantedperiod(A6)

mt_TonePortaSetPer
	MOVE.W	n_period(A6),D2
	MOVE.B	n_glissfunk(A6),D0
	AND.B	#$0F,D0
	BEQ.S	mt_GlissSkip
	MOVEQ	#0,D0
	MOVE.B	n_finetune(A6),D0
	MULU	#36*2,D0
	LEA	mt_PeriodTable(PC),A0
	ADD.L	D0,A0
	MOVEQ	#0,D0
mt_GlissLoop
	CMP.W	(A0,D0.W),D2
	BHS.S	mt_GlissFound
	ADDQ.W	#2,D0
	CMP.W	#36*2,D0
	BLO.S	mt_GlissLoop
	MOVEQ	#35*2,D0
mt_GlissFound
	MOVE.W	(A0,D0.W),D2
mt_GlissSkip
	MOVE.W	D2,sam_period(A5) 			; Set period
	RTS

mt_Vibrato
	MOVE.B	n_cmdlo(A6),D0
	BEQ.S	mt_Vibrato2
	MOVE.B	n_vibratocmd(A6),D2
	AND.B	#$0F,D0
	BEQ.S	mt_vibskip
	AND.B	#$F0,D2
	OR.B	D0,D2
mt_vibskip
	MOVE.B	n_cmdlo(A6),D0
	AND.B	#$F0,D0
	BEQ.S	mt_vibskip2
	AND.B	#$0F,D2
	OR.B	D0,D2
mt_vibskip2
	MOVE.B	D2,n_vibratocmd(A6)
mt_Vibrato2
	MOVE.B	n_vibratopos(A6),D0
	LEA	mt_VibratoTable(PC),A4
	LSR.W	#2,D0
	AND.W	#$001F,D0
	MOVEQ	#0,D2
	MOVE.B	n_wavecontrol(A6),D2
	AND.B	#$03,D2
	BEQ.S	mt_vib_sine
	LSL.B	#3,D0
	CMP.B	#1,D2
	BEQ.S	mt_vib_rampdown
	MOVE.B	#255,D2
	BRA.S	mt_vib_set
mt_vib_rampdown
	TST.B	n_vibratopos(A6)
	BPL.S	mt_vib_rampdown2
	MOVE.B	#255,D2
	SUB.B	D0,D2
	BRA.S	mt_vib_set
mt_vib_rampdown2
	MOVE.B	D0,D2
	BRA.S	mt_vib_set
mt_vib_sine
	MOVE.B	(A4,D0.W),D2
mt_vib_set
	MOVE.B	n_vibratocmd(A6),D0
	AND.W	#15,D0
	MULU	D0,D2
	LSR.W	#7,D2
	MOVE.W	n_period(A6),D0
	TST.B	n_vibratopos(A6)
	BMI.S	mt_VibratoNeg
	ADD.W	D2,D0
	BRA.S	mt_Vibrato3
mt_VibratoNeg
	SUB.W	D2,D0
mt_Vibrato3
	MOVE.W	D0,sam_period(A5)
	MOVE.B	n_vibratocmd(A6),D0
	LSR.W	#2,D0
	AND.W	#$003C,D0
	ADD.B	D0,n_vibratopos(A6)
	RTS

mt_TonePlusVolSlide
	BSR	mt_TonePortNoChange
	BRA	mt_VolumeSlide

mt_VibratoPlusVolSlide
	BSR.S	mt_Vibrato2
	BRA	mt_VolumeSlide

mt_Tremolo
	MOVE.B	n_cmdlo(A6),D0
	BEQ.S	mt_Tremolo2
	MOVE.B	n_tremolocmd(A6),D2
	AND.B	#$0F,D0
	BEQ.S	mt_treskip
	AND.B	#$F0,D2
	OR.B	D0,D2
mt_treskip
	MOVE.B	n_cmdlo(A6),D0
	AND.B	#$F0,D0
	BEQ.S	mt_treskip2
	AND.B	#$0F,D2
	OR.B	D0,D2
mt_treskip2
	MOVE.B	D2,n_tremolocmd(A6)
mt_Tremolo2
	MOVE.B	n_tremolopos(A6),D0
	LEA	mt_VibratoTable(PC),A4
	LSR.W	#2,D0
	AND.W	#$001F,D0
	MOVEQ	#0,D2
	MOVE.B	n_wavecontrol(A6),D2
	LSR.B	#4,D2
	AND.B	#$03,D2
	BEQ.S	mt_tre_sine
	LSL.B	#3,D0
	CMP.B	#1,D2
	BEQ.S	mt_tre_rampdown
	MOVE.B	#255,D2
	BRA.S	mt_tre_set
mt_tre_rampdown
	TST.B	n_vibratopos(A6)
	BPL.S	mt_tre_rampdown2
	MOVE.B	#255,D2
	SUB.B	D0,D2
	BRA.S	mt_tre_set
mt_tre_rampdown2
	MOVE.B	D0,D2
	BRA.S	mt_tre_set
mt_tre_sine
	MOVE.B	(A4,D0.W),D2
mt_tre_set
	MOVE.B	n_tremolocmd(A6),D0
	AND.W	#15,D0
	MULU	D0,D2
	LSR.W	#6,D2
	MOVEQ	#0,D0
	MOVE.B	n_volume(A6),D0
	TST.B	n_tremolopos(A6)
	BMI.S	mt_TremoloNeg
	ADD.W	D2,D0
	BRA.S	mt_Tremolo3
mt_TremoloNeg
	SUB.W	D2,D0
mt_Tremolo3
	BPL.S	mt_TremoloSkip
	CLR.W	D0
mt_TremoloSkip
	CMP.W	#$40,D0
	BLS.S	mt_TremoloOk
	MOVE.W	#$40,D0
mt_TremoloOk
	MOVE.W	D0,sam_vol(A5)
	MOVE.B	n_tremolocmd(A6),D0
	LSR.W	#2,D0
	AND.W	#$003C,D0
	ADD.B	D0,n_tremolopos(A6)
	RTS

mt_SampleOffset
	MOVEQ	#0,D0
	MOVE.B	n_cmdlo(A6),D0
	BEQ.S	mt_sononew
	MOVE.B	D0,n_sampleoffset(A6)
mt_sononew
	MOVE.B	n_sampleoffset(A6),D0
	LSL.W	#7,D0
	CMP.W	n_length(A6),D0
	BGE.S	mt_sofskip
	SUB.W	D0,n_length(A6)
	LSL.W	#1,D0
	ADD.L	D0,n_start(A6)
	RTS
mt_sofskip
	MOVE.W	#$0001,n_length(A6)
	RTS

mt_VolumeSlide
	MOVEQ	#0,D0
	MOVE.B	n_cmdlo(A6),D0
	LSR.B	#4,D0
	TST.B	D0
	BEQ.S	mt_VolSlideDown
mt_VolSlideUp
	ADD.B	D0,n_volume(A6)
	CMP.B	#$40,n_volume(A6)
	BMI.S	mt_vsuskip
	MOVE.B	#$40,n_volume(A6)
mt_vsuskip
	MOVEQ	#0,D0
	MOVE.B	n_volume(A6),D0
	MOVE.W	D0,sam_vol(A5)
	RTS

mt_VolSlideDown
	MOVEQ	#0,D0
	MOVE.B	n_cmdlo(A6),D0
	AND.B	#$0F,D0
mt_VolSlideDown2
	SUB.B	D0,n_volume(A6)
	BPL.S	mt_vsdskip
	CLR.B	n_volume(A6)
mt_vsdskip
	MOVEQ	#0,D0
	MOVE.B	n_volume(A6),D0
	MOVE.W	D0,sam_vol(A5)
	RTS

mt_PositionJump
	MOVE.B	n_cmdlo(A6),D0
	SUBQ.B	#1,D0
	MOVE.B	D0,mt_SongPos
mt_pj2	CLR.B	mt_PBreakPos
	ST 	mt_PosJumpFlag
	RTS

mt_VolumeChange
	MOVEQ	#0,D0
	MOVE.B	n_cmdlo(A6),D0
	CMP.B	#$40,D0
	BLS.S	mt_VolumeOk
	MOVEQ	#$40,D0
mt_VolumeOk
	MOVE.B	D0,n_volume(A6)
	MOVE.W	D0,sam_vol(A5)
	RTS

mt_PatternBreak
	MOVEQ	#0,D0
	MOVE.B	n_cmdlo(A6),D0
	MOVE.L	D0,D2
	LSR.B	#4,D0
	MULU	#10,D0
	AND.B	#$0F,D2
	ADD.B	D2,D0
	CMP.B	#63,D0
	BHI.S	mt_pj2
	MOVE.B	D0,mt_PBreakPos
	ST	mt_PosJumpFlag
	RTS

mt_SetSpeed
	MOVEQ	#0,D0
	MOVE.B	3(A6),D0
	BEQ.s	mt_end
	CLR.B	mt_counter
	MOVE.B	D0,mt_speed	
mt_end		
	RTS

mt_CheckMoreEfx
	BSR	mt_UpdateFunk
	MOVE.B	2(A6),D0
	AND.B	#$0F,D0
	CMP.B	#$9,D0
	BEQ	mt_SampleOffset
	CMP.B	#$B,D0
	BEQ	mt_PositionJump
	CMP.B	#$D,D0
	BEQ	mt_PatternBreak
	CMP.B	#$E,D0
	BEQ.S	mt_E_Commands
	CMP.B	#$F,D0
	BEQ	mt_SetSpeed
	CMP.B	#$C,D0
	BEQ	mt_VolumeChange
	BRA	mt_PerNop

mt_E_Commands
	MOVE.B	n_cmdlo(A6),D0
	AND.B	#$F0,D0
	LSR.B	#4,D0
	BEQ.S	mt_FilterOnOff
	CMP.B	#1,D0
	BEQ	mt_FinePortaUp
	CMP.B	#2,D0
	BEQ	mt_FinePortaDown
	CMP.B	#3,D0
	BEQ.S	mt_SetGlissControl
	CMP.B	#4,D0
	BEQ.s	mt_SetVibratoControl
	CMP.B	#5,D0
	BEQ.s	mt_SetFineTune
	CMP.B	#6,D0
	BEQ.s	mt_JumpLoop
	CMP.B	#7,D0
	BEQ	mt_SetTremoloControl
	CMP.B	#9,D0
	BEQ	mt_RetrigNote
	CMP.B	#$A,D0
	BEQ	mt_VolumeFineUp
	CMP.B	#$B,D0
	BEQ	mt_VolumeFineDown
	CMP.B	#$C,D0
	BEQ	mt_NoteCut
	CMP.B	#$D,D0
	BEQ	mt_NoteDelay
	CMP.B	#$E,D0
	BEQ	mt_PatternDelay
	CMP.B	#$F,D0
	BEQ	mt_FunkIt
	RTS

mt_FilterOnOff
	RTS	

mt_SetGlissControl
	MOVE.B	n_cmdlo(A6),D0
	AND.B	#$0F,D0
	AND.B	#$F0,n_glissfunk(A6)
	OR.B	D0,n_glissfunk(A6)
	RTS

mt_SetVibratoControl
	MOVE.B	n_cmdlo(A6),D0
	AND.B	#$0F,D0
	AND.B	#$F0,n_wavecontrol(A6)
	OR.B	D0,n_wavecontrol(A6)
	RTS

mt_SetFineTune
	MOVE.B	n_cmdlo(A6),D0
	AND.B	#$0F,D0
	MOVE.B	D0,n_finetune(A6)
	RTS

mt_JumpLoop
	TST.B	mt_counter
	BNE	mt_Return
	MOVE.B	n_cmdlo(A6),D0
	AND.B	#$0F,D0
	BEQ.S	mt_SetLoop
	TST.B	n_loopcount(A6)
	BEQ.S	mt_jumpcnt
	SUBQ.B	#1,n_loopcount(A6)
	BEQ	mt_Return
mt_jmploop	
	MOVE.B	n_pattpos(A6),mt_PBreakPos
	ST	mt_PBreakFlag
	RTS

mt_jumpcnt
	MOVE.B	D0,n_loopcount(A6)
	BRA.S	mt_jmploop

mt_SetLoop
	MOVE.W	mt_PatternPos(PC),D0
	LSR.W	#4,D0
	MOVE.B	D0,n_pattpos(A6)
	RTS

mt_SetTremoloControl
	MOVE.B	n_cmdlo(A6),D0
	AND.B	#$0F,D0
	LSL.B	#4,D0
	AND.B	#$0F,n_wavecontrol(A6)
	OR.B	D0,n_wavecontrol(A6)
	RTS

mt_RetrigNote
	MOVE.L	D1,-(SP)
	MOVEQ	#0,D0
	MOVE.B	n_cmdlo(A6),D0
	AND.B	#$0F,D0
	BEQ.s	mt_rtnend
	MOVEQ	#0,D1
	MOVE.B	mt_counter(PC),D1
	BNE.S	mt_rtnskp
	MOVE.W	(A6),D1
	AND.W	#$0FFF,D1
	BNE.s	mt_rtnend
	MOVEQ	#0,D1
	MOVE.B	mt_counter(PC),D1
mt_rtnskp
	DIVU	D0,D1
	SWAP	D1
	TST.W	D1
	BNE.S	mt_rtnend
mt_DoRetrig

	move_dmacon n_dmabit(A6)		; Channel DMA off
	
	MOVE.L	n_start(A6),sam_start(A5) 	; Set sampledata pointer     
	MOVE.W	n_length(A6),sam_length(A5)	; Set length
	
	MOVE.W	n_dmabit(A6),D0
	BSET	#15,D0
	move_dmacon d0
	
	MOVE.L	n_loopstart(A6),sam_lpstart(A5)
	MOVE.L	n_replen(A6),sam_lplength(A5)
	MOVE.W	n_period(A6),sam_period(A5)
mt_rtnend
	MOVE.L	(SP)+,D1
	RTS

mt_VolumeFineUp
	TST.B	mt_counter
	BNE	mt_Return
	MOVEQ	#0,D0
	MOVE.B	n_cmdlo(A6),D0
	AND.B	#$F,D0
	BRA	mt_VolSlideUp

mt_VolumeFineDown
	TST.B	mt_counter
	BNE	mt_Return
	MOVEQ	#0,D0
	MOVE.B	n_cmdlo(A6),D0
	AND.B	#$0F,D0
	BRA	mt_VolSlideDown2

mt_NoteCut
	MOVEQ	#0,D0
	MOVE.B	n_cmdlo(A6),D0
	AND.B	#$0F,D0
	CMP.B	mt_counter(PC),D0
	BNE	mt_Return
	CLR.B	n_volume(A6)
	MOVE.W	#0,sam_vol(A5)
	RTS

mt_NoteDelay
	MOVEQ	#0,D0
	MOVE.B	n_cmdlo(A6),D0
	AND.B	#$0F,D0
	CMP.B	mt_counter,D0
	BNE	mt_Return
	MOVE.W	(A6),D0
	BEQ	mt_Return
	MOVE.L	D1,-(SP)
	BRA	mt_DoRetrig

mt_PatternDelay
	TST.B	mt_counter
	BNE	mt_Return
	MOVEQ	#0,D0
	MOVE.B	n_cmdlo(A6),D0
	AND.B	#$0F,D0
	TST.B	mt_PattDelTime2
	BNE	mt_Return
	ADDQ.B	#1,D0
	MOVE.B	D0,mt_PattDelTime
	RTS

mt_FunkIt
	TST.B	mt_counter
	BNE	mt_Return
	MOVE.B	n_cmdlo(A6),D0
	AND.B	#$0F,D0
	LSL.B	#4,D0
	AND.B	#$0F,n_glissfunk(A6)
	OR.B	D0,n_glissfunk(A6)
	TST.B	D0
	BEQ	mt_Return
mt_UpdateFunk
	MOVEM.L	A0/D1,-(SP)
	MOVEQ	#0,D0
	MOVE.B	n_glissfunk(A6),D0
	LSR.B	#4,D0
	BEQ.S	mt_funkend
	LEA	mt_FunkTable(PC),A0
	MOVE.B	(A0,D0.W),D0
	ADD.B	D0,n_funkoffset(A6)
	BTST	#7,n_funkoffset(A6)
	BEQ.S	mt_funkend
	CLR.B	n_funkoffset(A6)

	MOVE.L	n_loopstart(A6),D0
	MOVEQ	#0,D1
	MOVE.W	n_replen(A6),D1
	ADD.L	D1,D0
	ADD.L	D1,D0
	MOVE.L	n_wavestart(A6),A0
	ADDQ.L	#1,A0
	CMP.L	D0,A0
	BLO.S	mt_funkok
	MOVE.L	n_loopstart(A6),A0
mt_funkok
	MOVE.L	A0,n_wavestart(A6)
	MOVEQ	#-1,D0
	SUB.B	(A0),D0
	MOVE.B	D0,(A0)
mt_funkend
	MOVEM.L	(SP)+,A0/D1
	RTS


mt_FunkTable dc.b 0,5,6,7,8,10,11,13,16,19,22,26,32,43,64,128

mt_VibratoTable	
	dc.b   0, 24, 49, 74, 97,120,141,161
	dc.b 180,197,212,224,235,244,250,253
	dc.b 255,253,250,244,235,224,212,197
	dc.b 180,161,141,120, 97, 74, 49, 24

mt_PeriodTable
; Tuning 0, Normal
	dc.w	856,808,762,720,678,640,604,570,538,508,480,453
	dc.w	428,404,381,360,339,320,302,285,269,254,240,226
	dc.w	214,202,190,180,170,160,151,143,135,127,120,113
; Tuning 1
	dc.w	850,802,757,715,674,637,601,567,535,505,477,450
	dc.w	425,401,379,357,337,318,300,284,268,253,239,225
	dc.w	213,201,189,179,169,159,150,142,134,126,119,113
; Tuning 2
	dc.w	844,796,752,709,670,632,597,563,532,502,474,447
	dc.w	422,398,376,355,335,316,298,282,266,251,237,224
	dc.w	211,199,188,177,167,158,149,141,133,125,118,112
; Tuning 3
	dc.w	838,791,746,704,665,628,592,559,528,498,470,444
	dc.w	419,395,373,352,332,314,296,280,264,249,235,222
	dc.w	209,198,187,176,166,157,148,140,132,125,118,111
; Tuning 4
	dc.w	832,785,741,699,660,623,588,555,524,495,467,441
	dc.w	416,392,370,350,330,312,294,278,262,247,233,220
	dc.w	208,196,185,175,165,156,147,139,131,124,117,110
; Tuning 5
	dc.w	826,779,736,694,655,619,584,551,520,491,463,437
	dc.w	413,390,368,347,328,309,292,276,260,245,232,219
	dc.w	206,195,184,174,164,155,146,138,130,123,116,109
; Tuning 6
	dc.w	820,774,730,689,651,614,580,547,516,487,460,434
	dc.w	410,387,365,345,325,307,290,274,258,244,230,217
	dc.w	205,193,183,172,163,154,145,137,129,122,115,109
; Tuning 7
	dc.w	814,768,725,684,646,610,575,543,513,484,457,431
	dc.w	407,384,363,342,323,305,288,272,256,242,228,216
	dc.w	204,192,181,171,161,152,144,136,128,121,114,108
; Tuning -8
	dc.w	907,856,808,762,720,678,640,604,570,538,508,480
	dc.w	453,428,404,381,360,339,320,302,285,269,254,240
	dc.w	226,214,202,190,180,170,160,151,143,135,127,120
; Tuning -7
	dc.w	900,850,802,757,715,675,636,601,567,535,505,477
	dc.w	450,425,401,379,357,337,318,300,284,268,253,238
	dc.w	225,212,200,189,179,169,159,150,142,134,126,119
; Tuning -6
	dc.w	894,844,796,752,709,670,632,597,563,532,502,474
	dc.w	447,422,398,376,355,335,316,298,282,266,251,237
	dc.w	223,211,199,188,177,167,158,149,141,133,125,118
; Tuning -5
	dc.w	887,838,791,746,704,665,628,592,559,528,498,470
	dc.w	444,419,395,373,352,332,314,296,280,264,249,235
	dc.w	222,209,198,187,176,166,157,148,140,132,125,118
; Tuning -4
	dc.w	881,832,785,741,699,660,623,588,555,524,494,467
	dc.w	441,416,392,370,350,330,312,294,278,262,247,233
	dc.w	220,208,196,185,175,165,156,147,139,131,123,117
; Tuning -3
	dc.w	875,826,779,736,694,655,619,584,551,520,491,463
	dc.w	437,413,390,368,347,328,309,292,276,260,245,232
	dc.w	219,206,195,184,174,164,155,146,138,130,123,116
; Tuning -2
	dc.w	868,820,774,730,689,651,614,580,547,516,487,460
	dc.w	434,410,387,365,345,325,307,290,274,258,244,230
	dc.w	217,205,193,183,172,163,154,145,137,129,122,115
; Tuning -1
	dc.w	862,814,768,725,684,646,610,575,543,513,484,457
	dc.w	431,407,384,363,342,323,305,288,272,256,242,228
	dc.w	216,203,192,181,171,161,152,144,136,128,121,114



Dsp_Rout
	dc.w 	10,$f080,0,$40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dc.w 	0,0,0,0,0,0,0,0,0,0,11,$f080,0,$145,0,0,0,0,0,0,0,0
	dc.w 	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dc.w 	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dc.w 	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dc.w 	0,0,0,0,0,0,8,$f4be,0,0,8,$f4a0,0,1,$66,$f400,0
	dc.w 	$1000,$67,$f400,0,$133e,5,$f426,0,$671,4,$67a6,$20
	dc.w 	$1b,6,$72a6,$49,$5e00,$20,$13,$56,$600,$56,$500,$56
	dc.w 	$d00,$56,$c00,$56,$1400,$56,$1300,$56,$1b00,$56
	dc.w 	$1a00,$56,$f400,0,0,$57,$f400,0,0,$56,$100,$57,$200
	dc.w 	$57,$800,$56,$900,$57,$f00,$56,$1000,$56,$1600,$57
	dc.w 	$1700,8,$f4bf,0,$3000,8,$f4ac,0,$4100,8,$f4ad,0
	dc.w 	$5800,8,$f4a1,0,$1f0,8,$f4a3,0,8,0,$fcb8,10,$a980,0
	dc.w 	$6e,8,$452b,10,$a523,$22,$ef00,$22,$c400,$20,$4c
	dc.w 	$20,$2e,$57,$1c00,$22,$d500,$60,$f400,0,$200,$61
	dc.w 	$f400,0,3,11,$f080,0,$14b,$60,$f400,0,$32c,$61
	dc.w 	$f400,0,10,11,$f080,0,$14b,$60,$f400,0,$458,$61
	dc.w 	$f400,0,$11,11,$f080,0,$14b,$60,$f400,0,$584,$61
	dc.w 	$f400,0,$18,11,$f080,0,$14b,10,$a503,$46,$f400,$70
	dc.w 	0,$47,$f400,0,0,$44,$8300,$20,$d0,$56,$100,$20,$c0
	dc.w 	$56,$200,$44,$8a00,$20,$d0,$56,$900,$20,$c0,$56
	dc.w 	$800,$44,$9100,$20,$d0,$56,$1000,$20,$c0,$56,$f00
	dc.w 	$44,$9800,$20,$d0,$56,$1600,$20,$c0,$56,$1700,$60
	dc.w 	$f400,0,$200,11,$f080,0,$163,$60,$f400,0,$6b0,$57
	dc.w 	$8600,$44,$8400,$45,$d800,$46,$8100,$46,$82e0,$21
	dc.w 	$c700,$20,$e0,$21,$c600,$70,$9c00,6,$d800,0,$c4,$20
	dc.w 	$48,10,$f0a5,0,$c4,10,$cd57,$45,$d800,$46,$8100,$46
	dc.w 	$82e0,$21,$c700,$20,$e0,$21,$c600,$43,$5e00,$57
	dc.w 	$600,$22,$f00,$44,$f400,0,$6b1,$20,$4c,$57,$500,$60
	dc.w 	$f400,0,$32c,11,$f080,0,$163,$22,$b600,$60,$f400,0
	dc.w 	$6b0,$57,$8d00,$44,$8b00,$45,$d800,$46,$8800,$46
	dc.w 	$89e0,$21,$c700,$20,$e0,$21,$c600,$70,$9c00,6,$d800
	dc.w 	0,$ec,$20,$48,10,$f0a5,0,$e7,10,$cd57,$45,$d800,$46
	dc.w 	$8800,$46,$89e0,$21,$c700,$20,$e0,$21,$c600,$56
	dc.w 	$e600,$20,$70,$56,$6600,$5e,$e600,$20,$50,$5e,$5e00
	dc.w 	$57,$d00,$22,$f00,$44,$f400,0,$6b1,$20,$4c,$57,$c00
	dc.w 	$60,$f400,0,$458,11,$f080,0,$163,$22,$b600,$60
	dc.w 	$f400,0,$6b0,$57,$9400,$44,$9200,$45,$d800,$46
	dc.w 	$8f00,$46,$90e0,$21,$c700,$20,$e0,$21,$c600,$70
	dc.w 	$9c00,6,$d800,0,$114,$20,$48,10,$f0a5,0,$10f,10
	dc.w 	$cd57,$45,$d800,$46,$8f00,$46,$90e0,$21,$c700,$20
	dc.w 	$e0,$21,$c600,$56,$e600,$20,$70,$56,$6600,$5e,$e600
	dc.w 	$20,$50,$5e,$5e00,$57,$1400,$22,$f00,$44,$f400,0
	dc.w 	$6b1,$20,$4c,$57,$1300,$60,$f400,0,$584,11,$f080,0
	dc.w 	$163,$22,$b600,$60,$f400,0,$6b0,$57,$9b00,$44,$9900
	dc.w 	$45,$d800,$46,$9600,$46,$97e0,$21,$c700,$20,$e0,$21
	dc.w 	$c600,$70,$9c00,6,$d800,0,$13c,$20,$48,10,$f0a5,0
	dc.w 	$137,10,$cd57,$45,$d800,$46,$9600,$46,$97e0,$21
	dc.w 	$c700,$20,$e0,$21,$c600,$56,$e600,$20,$70,$56,$6600
	dc.w 	$5e,$e600,$20,$50,$5e,$5e00,$57,$1b00,$22,$f00,$44
	dc.w 	$f400,0,$6b1,$20,$4c,$57,$1a00,10,$f080,0,$6e,10
	dc.w 	$ae82,0,$149,8,$e7ef,0,4,8,$dfaf,0,4,10,$a980,0
	dc.w 	$14b,8,$59ab,10,$a980,0,$14e,8,$452b,$45,$5900,$44
	dc.w 	$9c00,$20,$a8,10,$a981,0,$154,8,$e1ab,10,$a981,0
	dc.w 	$157,8,$cf2b,10,$a980,0,$15a,8,$442b,6,$c400,0,$161
	dc.w 	10,$a980,0,$15f,8,$58ab,0,12,$61,$f400,0,$6b0,6
	dc.w 	$2c81,0,$179,$57,$e000,$44,$f400,$ff,0,$45,$f44e,0
	dc.w 	$80,$55,$5900,$44,$e000,$44,$f4a8,$ff,0,$21,$2f00
	dc.w 	$45,$f44e,0,$8000,$55,$5900,$44,$d800,$44,$f4a8,$ff
	dc.w 	0,$21,$2f00,$20,$4e,$55,$5900,0,12

ch1s
	dc.l 	NullSample
	ds.w 	1
	ds.w 	1
	ds.w 	1
	ds.l	1
	ds.w	1
ch2s
	dc.l 	NullSample
	ds.w 	1
	ds.w 	1
	ds.w 	1
	ds.l	1
	ds.w	1
ch3s
	dc.l 	NullSample
	ds.w 	1
	ds.w 	1
	ds.w 	1
	ds.l	1
	ds.w	1
ch4s
	dc.l 	NullSample
	ds.w 	1
	ds.w 	1
	ds.w 	1
	ds.l	1
	ds.w	1
	
shadow_dmacon
	dc.w 	0	
mt_speed
	dc.b 	6
mt_counter
	dc.b 	0
mt_SongPos
	dc.b	0
mt_PBreakPos
	dc.b	0
mt_PosJumpFlag
	dc.b 	0
mt_PBreakFlag
	dc.b	0
mt_LowMask
	dc.b	0
mt_PattDelTime
	dc.b	0
mt_PattDelTime2
	dc.b	0
	
	EVEN
	
mt_PatternPos
	dc.w 	0
mt_DMACONtemp
	dc.w 	0
	
mt_chan1temp
	dc.l	0,0,0,0,0,$00010000,0, 0,0,0,0
mt_chan2temp
	dc.l	0,0,0,0,0,$00020000,0, 0,0,0,0
mt_chan3temp
	dc.l	0,0,0,0,0,$00040000,0, 0,0,0,0
mt_chan4temp
	dc.l	0,0,0,0,0,$00080000,0, 0,0,0,0

*******************************************************************************

** ATTENTION, le module doit etre le DERNIER objet en segment DATA... *******
*****************************************************************************

Module
	incbin 	"F:\SNDTRK\ENIGMA.MOD"
	BSS
	ds.l	100000
	
** ATTENTION, la zone libre de 400000 octets doit etre la premiere en BSS. **
** Cette zone libre est utilisee pour le precalcul des samples. Sa taille  **
** peut varier selon les modules, mais 400000 semble fonctionner pour 99%  **
** des modules.                                                            **
*****************************************************************************

Sequence_adr
	ds.l	1
Patterns_adr
	ds.l	1
Nb_samples
	ds.w	1
Samples_adr
	ds.l	32
DSP_datas
	ds.b	80
mt_FreqTable
	ds.l	900
NullSample
	ds.w	900

*****************************************************************************

Screens
	ds.b 	2*64256
L.hHWn*r`.ݭx[3>Ai2sBd:ܝѷ }e~$M.R;R$]iNt,U]#cuA0?	URjBU.|
/W_wYn+/'-#"l4ƽ
ak0*T9,i{ETZ#L&o8ϰc8:6*$W|v{}=3r紌&cDxg6:H
]`Pn d)c\'% Dt	X&uh&W>ڍĳ: 8Z'@蘁m!۸*I=ju{PbEWBsyWʏXV+bhؐh{-mTX3(ʚwn
|"qBk7BGY0fr
+a$1(-BΌ""NMHg	C=g1&粽hAKN# x犃'i✀,A6H;)FbL^RYDK	j >;E#֜1eʖ+L0FC;Q	֭\zJ+Mj	vn6k*35bMkrXd'"-p~/*CXkf6̢bқt!wm]E޽D0@)P	uRHdhjíh5x4Z]v:nH}R˟<ѝS]3 24%"qur'dώe~zEk'QKfDFRiQL')}e1?9O׎0
iq&IƗoC!H  E%O-|a볿zŪF@C{rdn3
t%
)]a!: pmGՆRO^8G7e߇@݆ZզKqo|}>!	;o
zT*rNyբr:^rٝk%(,[5	-$k;U=iՀ
:'x;
R"R~mS/K7WhQ#;a,<]9##䌇ͮɒN"q_y{.OZqA/{ti517Y	M/t(:e"s/Dey>yOkvnpxS2]@И/Ɠ7:yKe!Upo'406|zvszKez*E6~A?PK   RRq  3      HOW_TO_C.ODE/JOYSTICK/BLIT_JOY.S[_w6fw@6׶,$%KvEQKr,I{BKT"UR&o rfo{v&`0@jgE&6L7x:N1ۈ/:*ZE^GIK߻G8dH<DIi§h#fx.mXY	ؖqEuIkLm"bh*IS$HL*XXD	\j4Mt#!O|qK$NÌP$xEei)da:w:MhKw?,D\䛌("'4eb.m*mb0ha&b!v/Lb/̖Q$G8,ˇ@tsm0F4Ƈ12'&	/nYu}ƹ!+-l~ab<!xZCtf"hM|qIc)0)n)LoH0Ngъ;\gJܥ,:*0-bோ4x+s+|`ׁ7	nisAﾛWx*nwƽAmc$$26L!XF=	X7Q w"mS4/_|']K"Y}RdJ'_E8XDO0﻽5XC_"״ixozYVM!ys/r?: .Ȣ<]l :r9K<{o:=kzy9{^lS V8d]~_
-@k.e,
)v
&޳w^Iğg:Fy.>^cO=zD|uxn?'neo>ɴ>ĳ(58ԗ BH8Ùɠ5uh>aW)\ML<g&[rr*-*\>;:͋s{e+{j*Tl折\s0,],508q>z/&#z^<
@hL_CqhEja-[S>8m[u> x2ܳ{phY J+T2)V&ԉRV6[@wqyBW1A9h٦vЬ):qoh)a{iFWb6UTXe
:
RG/4͝bJnWBR\@~Y}ӭO
hƓn&p#LR@JTg|R4fS
/(,b1EZQd;/~Dd<a3Iy7x[&!~o$vcQJfkv<U(؀;VWRR]1CRSь1=IGEy!mVw[X񵅶+Ϡ
5`$yuzjc6Gl.>Y/cu0Lw0".X`o(=A_67]ty%
r46\Ӳk>IOJ0mOys#I?9'#u!cߎqWu!5#vnr!IT#Hc	8_eK)%dy9BӴY$WubUr\)Uș4xrG:'PJcyBp	X}cMUL)`BaJs|m/(\ȽTҥ'?v	u<_v1irH]<acbHo/Σpeov@
`2 э9>CBJ,ӾÑi?AzNG;w0i̎ n'\Y40FFGҞS!<T:,Bav7#qR;ԝӣ>Fp"<H+	| KP:jt>"a̜3qɉy֏c[mGζ	ڸO3^BR8۶CTmL<'A"$	a!9D-," ,w27#DdvO!|@+̑ං
_
_
WR%K$<1<1dIoL
/ p˕&ftKF040<MA)a"F,nє".߭9~XN^ffWvxw^`R{VŎ?-Zh}tIY-#3,diA8`gaYA҉VAT))FۘC}h7mcr_IzMߓ\lAY(Jt \)bbY+_C5M30DLS*WyfjkAELў^hXsmt+mwyfQD"}G`ei,4)3AYz2f&id_JcSB}e5±
SE
7r_h͊fju䘕*@!)$IW$j+ tT!ޛ"ی
)`՘c}
ʭ*OvfMZ5Tu=s=s5k}kjMҫfWjbOs %HYR7t&ܭӂrڌjRmHk=YKX`9Z-0v<[榭oGfa`|u=<FezE!"X48HL:ҊmaJEhŨiZ	RHxrlۦ^&^lKXuXoWAHiq1.^Q?EerP?2(nXʠ/5eoDKdMYDQL^-˼<P={WQ&5uJ5nsYOmU,W]WWUouu*$U&3CpᇋfA_*g)IչV5Hj[z}XK)6 /Ҹ?Юbh>vCķA|K[2֣"$]/e#9i򀊋G:i1+bXUODQΣJ'_5S} xrσ(/f˸t/N'h09
Z!CQҎLL9Q=ʈ3*^#57]R,,?u1OV,vk0|9lTGyTo7YC,X^*9
*ZS=\3f#*|n|w2<P%݅;ܤ!,noed``k}gLQB"ԵXqo!I%fKQY%mZglY/1ӑɫnEIO	.ECU
CG6kwTYNVavHE9NyCjıZc\+k
ZqUϩ;F:ɬM7%?4-SRmDS
<z<w2{:-`#n&Ꮌ23iŒ.axfI^dl+%z{GqcBwTnB%)
)@ꚡR	Wr Z@J;n}+Ag b7^]#]edXf_jCz$x]DT^ith1߾}MC0wvYŎ~	n[d{FLoKP}Uz\A<2V&.i<o;=(c+k5+$*xu(1ilf<xN3ؕsgB	C?q&L.΍>v-9t7E2/s9y̿͗ZݲNRdBT*Gt=ʊ٦c{7RiCQuAbbȞ/%5~$gaȈ%;ԡ|yi
z <5vb=SŇc/G
nxoyGG7X=R>n	^-6?G5҅＠^Ah1\oy0aܭ0GoKVC0$I0YmyPK   RRS  }  !   HOW_TO_C.ODE/JOYSTICK/EXEMPLE.NEO\ox?&YI!;QI"v "<!"5@ /(R[
{Kؔ0@M!UiehHgf̦O|3<n~7wyAȒk4e?siy%~LEM_8L7o5:_F+ azJ_qƻ?u+Ԡ/8U?\FT97*AW_q$k>}OT__q*B8!$uN(bbK3T3!2V~*^fy}}ǩbOE3
׎fV]MD~*&q`@_q#}ǩYUh-?I}
.*RC}ƩbF,>#}ǩbv !J2a K`?~0~
+'3o|P#۹'wq>/4̒>l[q#] \amMy@=X
;*]RmPm^J?-Z_h_ 

pSc!OJZU_2+A|?Σ_n;.V(Uo=ܠ퍿Iff65~,׳Qb(/9;$=q}~*!?F
m]ڞT GnpMhey9L=E2[o4_u%AV7{Zmjw$oؼOz1\NSl29k?ۙ]l;%ƊJaw;.zwׁr>alOnhqv\=e߽Ut:U{x!sˀ	:pgp-Kt}鈗ޠ3sN#(<_$pi  Wΰ !GOVk *aLm:p[RO`=7sb8=ygoCgwVC_.q\Pf:oϝqzr9ܚ,¶=e-nO<mf.8EzdPLzX<(q/0Uz6ᑡ=:~])Ȭ|X}-OC_μ$)wٕNSVev5uȴ{)xwqY=e
gYk}}8(bWqy!uضfRmׁ+`иHL.+CG(,ׁ(и?Ʃ( $}"T)QKFS%
xeʳ6 a(^GI8KPz/8U~+wRj/8U~	zd\ǑTp9Kʡn	׃b0V0~*`)9D?N;FI4P8F9#}ǩb'^Ϋp0̖C
8_,VIq?N/c\0m_5n0lCL9DnE7aײ{ص4pXG\m| |n)mP劙	d-Xp*8G+ll
8EL3|2RlCtuN4Z{3f2-~j?oFͦjTŶ>oqD^;g}njTbJi0XIW_qĉN?S0DO_7%20쥝uNxG0@ }݀SĊ?b(Dʊn),bPvotU͸h7y;pHĐ7ƽ IC_7q"/oPTL

8ULx!F_`Ak3Pó>{$l>w'FťRTڿϦZN?PXH_kJ)!ES%~w@	(}w?[j50A"~@+%4t9h,)uK-C~0E6"K\%e
[F߇0uYxBlJ7w_St8'sFUܪa`[p6<=[ ȭ@|AyV*=~`H)=_ 
P>äФ#p_vW	}C~۰o>l(~wJn8 _I{`] >I܇
Tzl]}
}mRnm\xr9|o4rx>J-?U쬀ӷ_l#ؼˉ[#1d#fƍcUj-oFoCGm*]Xo* <d	B=7T#l	ocF,1Q5`qstqFJ#;<
~MKq$oq'q$yjw쮨-'
.#}VA~=C"M}.̉;3Y{bU:
~R
snhAZ_E?wz^-qC 	&] j
d+i{r> K~q?3:4m(-At"V$,p]ȹ~dp]wz`.t0r4&|]uL.\ebo Zϋ:zQgiO_=w_9+'т>#rdff ]{̛_\צbPo{`
/σ
#\"RCir:89Z)^Ow|o]qsq n)H^1]Iq~y*D?lwCA[>(ȡ5Έow0G0y,?up}tzٮ@bzuy(_ߕa"+`#L'zIꡫ#>	SAxkl|'d70xO\7iiTiʏ}`|Oj%s_=[	KK~&
~myǵT`ns'$Rh*Ooѐ;KqSWHrsO1,;8?<lPGƁVOwNa5LgJ֢+qJy6,xR|t7Iqqv0ugob==q?)/_OS ,
S`Yv}w-gfz*o0mF/UEu<mz/[{y|^{oװ_o_/gdkc8ڰ"`/og2|;{H+قqnᗂ^/)&T73	z?8}[h5= Wokn;8|vNwM<+|_4[)
_%)j ڵW)'8S4p|6}=kwLtTJ4ꙗɘVSPS'`\Ƿy~_/~夌yug;%aBM۳h*9H/]q^93ހB/O߰c~ 6\qp`}.~{si	>HCƄg,@`uܨ27|
q8BЬ0:Ӄ= bΣy< ;}^ۘ:7SYI"AEm _l0?|3Bk#PMV\lQ~~7}j`SSQlu?_u`&7#4*
j諅`.ļUCnrowԆʊ`㷝VKL{v -~?|{>g
 ɨb,b{hݽ1VڏdP'G
͖k9`;ы|xg4ψ'Xmįzmswܜ\4<|&׃}9x[hM^rB+I
p6_Oן-l~X0Fuٍ[+iG#
AO7@JT; ǡ滭y,ѝB{cu$OC^d6|!FJv_x?JnC$D;M50rIlu iUQp|S^`nyt6p P83y9BK(ZA{wJLMv%5^n AK~)dBSR.B񳞴ndr;f ^،0`+Wô?e6
1M-<q[]RDq&yt!T|bjX.
F`%ۦŏr$٥|0g3,qRdk8ߏqم'k[+OVEX2Cc	CX?<4XXi:	Fx-OKA|_MC4%KSJhSQ{Ǘ$;zCI[rO~=Ϛxk/WICgHZN)\>[Ӧլx]I +dX%JF,/⏽ngN]fva[
8YI&[2a1>tF	7tȄC1>`ڃΡ->~i>'"'Mb0܅lh;A;1F=(շY13\MczbqHEu|"FŁ ~n|z"}~\+9S؃50f
ED:ZZ8*% vkQC{)ܽ+rKb
e5!j焢'[pbF+8ϳoݲ#F$@&L<dMFzK<_Ԉsy{]tp`~sg#'yP2VX!qE5gq=_i6Ga?ےgp
~ og~¥}TvbpmZXK.t)D=%wST+sQ[,kબ5Jb"+(7*߂W&^et.?2C<嘆gkد?΁N:Q|D;o #$v&&2U&^1qj*e4{==ݗTWXy<Gf-v^ܓ]t(L]~Quro&>&x)<<*N1G hPM0$<LFf^yb'NCYn;WDUp>S=1yb){^:> /\G2'Zn>+O*nZAKG` 9!%HLII8kS5r`'B~8Rd)3	avc&ZۄP}>U-:]Wo1zl57Yt
vPb/Yg̏ yDv0p7ux"yւi1v8IJ; I>HwSp.s?<m7l{I@_7]WP"ϩF*Qey؅9rFltg[v|
t9=q~i6U6]~M:Ρgw]^8v
~U&6(я#HNbܿ6NU_P-yͥ3PÎ&&vFyخ5)YPTNVjt	hc+jãŜ!Zf#Gm:󳂉ȭRȀs!U],8(nRN٥p*ɥ	$fyV9y?^
*K	Pg;Uu:WPŵ&G{3W"aC$9j"?|e(ϓj	nQ@ϭ#[ϖkg@=(&+jYdb:ӌd8W_>AYj]'iOL_Jm
V@KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKPK   RRGS       HOW_TO_C.ODE/JOYSTICK/JOY.DOCXr6}wR.Gv7Dr6v(+ioO[#!K4 R~O7XroȞ!ݧOn	
oLe
6TvWoN~${]o*9jsu<f4ٲ+ا,y?&SMvAMBSkM%PA9CW״O'>p$T볓 ƚ)|IZa╭* OЎ*EATwG7N53mw^`Hy_,1)2x
:Gf
M&#ކS56NT/!dV=_n J&zpp;.Ƭ+
:eYLwLCJٴ&Gg6|Oыg!݋<48taxz$(AS@7YYWD_܀8]0М^~9[Y.ت
β#R	q4`AKrp,mPvTUϜw)vJqE וu>:z{\ֽ56at->02oU+YǮHxp`foG=rqyӸ<^^2I.c7M{[~H$ϕ!B6
BT'giae$װ6_d70"C(d=2i3gkhrX fqK`
cC" m-1.GVUKǫ+ڨ3MYtR-5jWA[BlpуhX잓꒲YO$Wa>!ULdńJH9[ћQ@ٚ(oYB+
Ȇ@{Pi!0l%Q"gFRȥ
nMB16:f\iXxPP)ӱ5A[JP!oˋO:zu`;M, KydΛB	0V3F@.HBjnc]WI)8	rwzc.mh`($TcZXL z| */`U7]_c al7n]$>N;l3-RH°Ĝr^kKD 1{RR5*Z15ln1V*zvȡ9
y~/p0	QjgCqۉ֟>v]Vŷv,5E;nk\}<lHLd+ ;<}Ok郉K$GǩbOemRDE_'\TUE`j.4jl~!(>p
xft7Ye.6/$(!dx1i<#QL}'v#F8+[}.)S"'8Hw2,`\צB㠤>;쌥g)}ӇyRi%ﴌ-FgA&ɂHT	"YWwB./uZ[	GW
a{c^*urxI (yT*W0A)C NCt&j'h1h̬@D\nf&y%$νW;KUI_v98{Nםa}]C.fBs4+tK<;Y,Ix-!xfnI/gNUɩN-V$3T|︟;ϊ_PÏ9U~WΚa xD)|~9 MRqM"u
Zk8Jњqir<E
Il4nm=P5~2R/g(-:.88)M-?҉CՆ5P}R|<iv@qӟ r'X(p sx;zWpr&8% 	_s~=-!"0;UCju gsrfH?_O!^s+MTl@"g!ýNܰ>3GG
	tķZFG<#:6"9loj_ug8gTõe{
rg MM{ۉPK   RRpg       HOW_TO_C.ODE/JOYSTICK/JOY.SVnF} vX-@h8EC,#w#n3{(b!v69=s9gf59}59<h]kT n:;ݳ_^U|~^?Dvv!R-^
s`3}luE"AI|ZA
G%ba3"M
i5l.AkAzX~~0mDhJ^dQe9-	,|fP/k= ُ۟G=	)?軩xqj@7f75Φ$CmMaWRwKu
YY'Z~@~=A-򸪞OE}QLu<qOG4MLr'{QKX*jSVh4^q_U%LÙ-^s>2O#%(qRS{T)fM֐ Gh_'*MB\t
C{%sIuTW{7F
ϫ`3dQx4sN%Mг1.B8YN+>N	Ibc0)˭(JY!k,)<1xI_!1EPXnvUj<vczR>}588	cq#HEI]L0ۓPaQY74O"`>TYq,1n*OX'QU	z	`k0ĢqN|/ly t-CqFPs_͋=  vT Sola	'@~M}GYuG
ڎ3v번>*}Y:#7./Ow61Q,.߾z[}{Xܷ7՚IKe$R咩eSoT;Z>,3PK   RR&C#  }     HOW_TO_C.ODE/JOYSTICK/ROAD.NEO}xT2d&`b.3APFOg*?	{2`Fmքj+5ըh&+Zk
P`Ġ!Y]{&9Y~
78p~.Ek.d~_h&h͕eHL=H@ߨp)4۠o
6۠o
6۠o
6۠o
6۠o
6$zAށF
b>:pTI+p4L`Ĵl:MЀgl2m1>-h>g*LhbV[?>7;vb0@×,Q1Qv)*; >#Kvp|ݞ ėĢQ~;	(q|-dYd4qf mbjTnY\˄F
h 7Mhi2m{@-"$ ONiн4۠o
inӨ/ F# Ƨq6`
y
:o6X|Udj	 JR_K
kH1i (8Ol$X(_@yqL15<JW_:d1pgۀqvVt3.z뉦"Bٖ"6d%#;wDo* ?s/|ŧ`8ljY՗5&Ri Ԡ1h3l"C*PU/be!CDX{M2Կ頊as(Mv2:-?ϥ(J΋n
Aߍ#ӐmWl Bnx,E@iGݜu[g8JTFa>KIP7i{dy/ᕅM WgUDWDRK
"~xA9GRޜ}85h!>
EkB{A{2
H0;NKOk^$)1yUۼ\þ- OTiDyq7ze
ѺRޡDe@XS!;:A.ˋ[xΰ>[@4B:1|ژ>d:o{PG!ӘǳwV݉Dc	4e ROTHXa?|>	?1^(Y<9s:[Wǐ"5TUu@}&ZvA|<>|Ne-n沒P6:DSTbYì/'l\Z̤G|qt;O/}ɥYu*޼J+/&htX33V>u>ܛŎmGV&ei6l*65WC~JU~F(%'o؟<ɥ'f7h?ʅ)>/xlxZ+
2"3߹Ϫ
-h9H9.lo9{Gns>'c0CfHy7GYJ
iP 4iLͤ!)↯>yY?
{}mv-? G_Sy/	cxb?<ekv-DΎ?lOPJ럠apsz
:4uHx|<딜*hrp$vD[ksΉVg[_>hB94dp}k3EUJYFAuȴ?ԉL\u5}CJHq[J8HV#g ;)tiIi!N^7B{	F!ݘ`il![Bynu<3DGZ[s)g~c|Zr9K?ӭbQTׯ%i,'
>,	&ˋU@wvnpacNz9|nȒ!{^K}^e	;;N߹eJ4d/UkfjO=9a %d:C֬eV>!G}#%0?.
Ÿ.k߮0QsA癍fRfEp?IV%D'P!ruTv,*-N׳"]jy/X~xC4,t	X)J/aOz̫\yunmD'^j(yvƅ!;?㡯,a^ΣLD3˄+ X?cvYKdь/iOGE7
a68QlzyIʓ`8=0b_grh[0}A`ӽ}uuҕ[⬺N/Rǧ8/_}-Gn$k	:U-9?o}k}&sNvi.\mQ۬5jqg`!~ytݐX	WO/ŽO9?}3}7>Ky5S^BSg]oQ#iCeZg6n޸q;7C}0҂KM)[%h6<^0K
UZ}cu
Iw٬W3YG{wU??q(Sw{#ݾ9^t>[cʆ`{Il~
-ȽL?n,Ǜ8κel	חEӞ"OWL;D]t3>sRQ4ITR?7:UC>!c]Gu1ɻ{[U3huwg}橎tRUs3i^? %T7>a0BygRtZ%f;ޗ-,!.X-k+V:6d1ݹo~A[h6L3wݾQBHYͰ wo}m_H<iK'#'VghY+xu'AJoL-G4|=OxxT#hU{_~UMi-:m22LX&<Xf>u63 I`t& !Y"3NP6B&G߅>/jg6w,5nw̽4'9PzUZ?
E$OVr_mۦlF&gHLybDوra}kcJ&g%طŚpVT5Cڬ|]Klνש.$zR.
rO
E.䉒-ϖ׶!=~cmȷ\~8DOneu\Cc>Hw/:.P#fN_[sFݎ;;o2fmD%⽿LZy޷g8g9->ʒ%U͎/t\2IdB 33k@&Bԓwq;,]nf߭w[:`yъqR".#xpwO3{8<7sV>a鼥]]ZOoC}.W'vfϸ.:}ɤX\ 0=lbGa*/딳y|A{qXVYYR)~s.MeWsmaLGGNkFיP+(9W]Ӱض&|0/Ԩrl:g5	MB;hiF"QP"x4b>$iiVY@ZZVn3(e
&F841#J@	$R$EHyx&1*]`s{뮂~g^6}+^kZEERhhg8G~5.=I3ZL;O*i)e#ޅE~ [q\`ni~`n#
'bfT|є C(#zI`IsnڭnUlzkV*&zy$u<%Z_vU{^\\yf666ed5ݷ$,xa/OzyP#vaSL]/G7Ќ7>l5.\[Yޜ?)&чT7OWѿ:fzg:y._ƆK}V';'8>!F(dCGH`QC4jj
|!iCw۵ŵ%kML[fȷ<	\ZcEg"7Zo20#%ܳ3	bbO>~*rtE	--ey}L)J@wfd`yӣ
u]B
}<f1zˊM?mɅ'o.ɷ:uP3ךk}J&r<9uwe)l[o>ޝUʙ=$WU|x((So:u֩SF!3.AV1w--`Ĥ'ѬiN٭X"4=4|'C\˾5'F9:7b<oN_c_+i(G

dwTan|u暚
CCR;aͰzٚo%?s{:ݟ^C7niD|?#q_6=u4!!ZtU};W6j7?mlΦ?)>VCĆ-b<e̎7ִծ11lMj+I35~.6=|QqQqgC\ڬ@Ą_*wP嫿_"jP?[3naߒ9wMy\y(Dy|oCYp;B5+
=?O`Lx%3>߼cNML^x@==_OMx*)
JuK֋VV]ڲKVZ*-jJ⛒;j1Ë|uȬ![SM&Zdavm©Q6{m=l}/oUګ۫_<@.)UA9(7hқ-3]n"r?lJS4z͑yNrN}m΍3Lhy5#I;*|kv}Rv2d?5-kڪ|s7/6l,99ZC/%dpk]rmP&1c\R玼tEv$MWI`ѯ@yjl6}tf%e߫NĎSk,).:MU
Z<_M_|eg]\g"FclWR>s'kkgC1+:ffVբ=AfBX!cm8oiOOncC60rl_^71K΄-
iR
-?z;Σ
<[Ju>w6R,bN9לvQQjΧ
/ nQDXwzzKWpO%1M5'Y
@e3e2O
uBss_Q}Xd0_`]].s&V/Uxm5avu':18V
i{FȚŌFn9!F9r Ew%r`qbeKB*Xv[8!;t=oԁGLJrDc_QĞii'TO|.si~5N56_[|
qTqv22DVRFTZ^Q!@kwVvCN'p2wܨP
&U[pQ\+A'~ف
ՆF	񫦯tmmK+e~QcuرʂBoI_yPbA^K`vr{tk1ގeGUnR%d	tkd<ae
<HʝxF^tW:0,Np{7b
 C~el`erK%jcr;*|	:
 [KGLca:3ԀgyKrxr|eNe0	ϧ}V~~EkBUX%tB9jt03BCpϮt.v@\`2urQ_+:$NCXDX r>f!v<x\m9?B,CsCn~ L̚t{3F&Ǘt׀nONO2
) Aw2 ã"LR"nF!NB`F&U9p	qkwypq!9CЧ*>|e~p2{8<힑[j߄cz=G-ղ`'v]Q췭@-H NJ}%NOo0*Y|Js[9b?
/W(Q&-mrN_AH3W#1*-.1c˄H} +U{Gi)t{W|W$7ߊks}`u"=c!1ӥ{/}2+yjb2Px1e.E`~z9u.B.v.KLt/L&rI_Cîj00W<aTXo\NDBk*u9]t#ȷ0⫢`ԋE#B_-s\!#6@Pȭ0$[D1yX@5ix׍8=hpyC*]kEQH9ZϏcSh	Z||t|7|s0u^W79([T+'8RneNe `S<q.v?`|@:pH&:K߫ΰ[8~, `}ռt_k]Zѥ{RŢ8vcfpɍB _n4bx6R~
3༃62s!R:w#,R'd3>^p=ʯ2̯R`a:vN97(ch{u;[b 󮷂La*|?-[)WϺY"Qr͔.Xq"}\~C}-L.tnP՘wB\x4}@He YEA>S!!s9˱W੖񮓨f_ߨuZwĝW .n;v+BМ?K&Di˧W0[vK_/:a따=<fwXMV/pu2e#Ձ&=t?s~]]gx<o>7쮛Y^Beؾaܨ*kA1?1	
g%ChKb|e۽:߁~ӱ:9#<jpbJo$9̏fF7,
PNm7e5vr{|L<Fq7S 4nv;U"tzm亜q(/[¢kna9<*?U0`_퐱x_/ca:ˁǡ5K|}ioԡP&("~:h
;eF06O\HD\LgܠTx
:J{/!Yq6Fq0KyǴ`F`\2c>;z"lQko#3_4$kmϣB;e Vgؙ_]	vQYnx=㔨?>R{3*7Vj)O|+D]
J#gI^r:}i>kI1ACu/
n L i<+0݃3=#_9~%3/53uu`s:RYAk1y"+2_Uʏdπ*m
+AVrZwwwSBOGxw	ѿNwu!ܧ0a>tKtgiA1KyKǃ^S?>3C62Lz-8GOj֚ґxwzv542d5Na9ttu>|^t~VGto	& w?N"kn?/W]a; Oب׋|:y	kz: Ʋ<j6^Q*rzFeCLa#~qj>9qzx3t8]j_szϛ|ȞzSZȒ6;.䏪Mq?tb:e<Tp~~G1UzMfHcXLyV<|"a$1a%Vc:~3t~.?N
1^(\c!znDYV$p+;لyMx+54 {yyDa{HJ'A/'E_[?N{PK   RRٹR"  }     HOW_TO_C.ODE/JOYSTICK/WORK.NEO}xTչg\3-D$`!ޘcJk{֓JP&@VAJ)=
jL Iz6xLdbIvߵgX)8OL&3|{w뻭o(Aejd1.06-0ShRbw&⥌%5W1<
x4iӀO<
x4iӀO<
x4iӀO<
x4iӀO<
x4&	h.F('bzE`<G	hv
"6U, 9?UBB:gI+x2/vRd=	lٹ l!EPs 4t0~L9xDPt;w:UtU<A9h"I'+Igԍv)&?I%OD<N׼'!rs/GM\2 `6nHg˙Fp.nTd9YAP4hB+ʽVY[	sȀJc.,EnG{
EfuX!P	= xI;a)Bit)aC:Iw(*QAK+w2h4~fSQ;A-ié,ᕏI _ϙygҠ:-.@4o5;BH!z{I=D2h~'3X/XZ{Owg :q0;/nfMo#2	VA/iOc8cűy:$/#Z3N*w* |!gA[Uq)=sc9о+aF#<CnY9Oկb[7Ek^t1V8dt?hfQ`QAx
oH
z/JzSLPW׭fk-2t9ʬOS)]}]cy	|H VXɆ^Nt0GA)nx_cZ*#'z5}c+NSipxy5U?+AӔnc#/Ϝ~	qS/d^+!]~S6'c)?s7QVaE?ŐKOݶ50?ʅYr#Xp*K(saA#Ǘ,%M?|0gȪE&w(Kp1)O5O8JL n 8cxxfw'mY$^_ʗ4T׻N=QPr+5o}*ǏUcs.u]\EFڗPHORS|_gΟWD+tڝTnxmg?8^}0Χ$>m WJY63E}"
~E1(*AJׄGh;1|v3m':񕊆#V0o_&t_z)GnԢ:?*J]h2̧6%㈐{37et/a՗!%80EVf>a)美g|(h7k5:ӖhW˫u|FyWx ~2C,aQ%;il'
lإ*ۋk$Y-Jo?*-Y6<-A!(Qo߅WLv{?~҇kH	+;dתƶǏGmfn,!	xAr俕+AZ}p4Ba1Ч'K&z`6l>k[X$Ʊ(˯\L|ҧMK(BTMBU*[
R0#[:coԧ1ø/2Q7<vOe~eEer/a9ܧq}fCԎ'P_7LVj3,c63&3/C~[)~dB_|aI_Yn+=)<Z `23_dS0qϱEvEcwB!#$7%Δlf9CL%Xv&-":"^ijQL÷$(p$R1'
&\7W-HG	I_I9S2G痐?[n8pĐ7w|í4;[ce[^#wLΡk=$\>}gg0d<Yw>Ξ+x{B6*RhV)~n|H}ۅP7K'E;l΋\|=|GƟ^PrA:͚K,am67Ѭ-^0R"R`o/όY#<fdIF&p#tN[g[_LVv"HH	HX{Yfu~}/fI{
,_p]qhVq<Y%ՇɴA]ڵKBj|hZh˙'[wh:yrrb@޿Τ9kvGNiKυ]DJ
#ȟ3:m.4S@?;£n&c&]ŪnѫMf]PYp͐ߵM4eGݱ/֯ߨ
)aCY݅-+_)YOʦτN܇!,Y͛F?<: RKŭ(wW`gˏ*)Xo'-7#Ol屼ŎDd+vƖ`A;5X[п9G2L3%C))yW'dі2Z>6
rΦ){jԲ*F}FoӑI=*do%[֯\;gٌ^͓yĪ:XS^mf1}Ys0@%|3Al11ǭ}gxtW05<>OT؅Ԏ֘Ȟ'Ab t#^<Er;;64dnّmEy?"7Jls>物>HwʗO_MD7l߾SpMɱK#yr/gϾ9>~/p
ǭ,
,
qXKV@d80fL_6N)DuM~N?][yX!e$O3N3a_qr_"2|.):C==FWDPCMX$z3ͽV?ub\ 7`R<Vy]TNK.r.rBǿ.2V+VVW#ҵ?`E֢W0wޛ;I⩘
,7>C]פ_IYD1/ڤ+Z
zoݴYh*^]x%HepT9z|0b>{*Yȕ+ !j6Z)Ehr6VwUw
W▀DHA	"= -Wp8L'u߄~XB!.QWn*57E'ѐ>9B\zzM̓aqq0n݃*6Rv.wZ
*M2{MH}6tȤ1hSxx2.S/SCA5wb#'hZ77pgEPHPSe^u
-5-537qa/,YnԗڅZav+VXviF۪_8g|X߮RJRšb_!?p^<S|.\P3֋8ZY$Rdds&ر)$frry]V|ă1%~cXՙ"(K3cB/S\g<PfȮ`~ǢỸޛ5R>}*q|SƝ*Z&R`9q8?"H]0OFsN9$c}Sp;F`ˆ%uAGCŸ²eo_оPN܃6vKi|Vg?_i4|
A`v,Cz+epr<n=`/	˪UOX;<y[0@mMB-9~x<SeU2\QNϘ-mc $oUw_Mצ٠KwkxcaȟUDjC+Dˣk|=rEx.~CPf,oԗ
}y
z[յWjKuR'Ku噷gޮʸ?޸4xcz[ϟ$7nO7njkro_}SB{Ghɶ@]?zfi)9wXuϳjY
ţy2aB!;+{L*b+(1+"r5M/6he?}lyhcƤJy5]5(KI%?.k?<VbþبQ{SSb骴`Z0"6~H}n[\=ngdgDi-eT~T%dl,tZtZ49vŖV3MN8Qϐ*pO['VZ_7/JRm3H\VCZG-k0?J
9kZ540
Xƈyev	Gsj]PjX
OXѹ@_/W+55oY"Ȕw2UVFCNebvwõ

y>e'ZP;Բe9ee{sC#λ~U;%﴿v+U'lSY]}G/,yq&tRRjTqֽ81v;w)W:U̒QPV0ms^<]u+"g1gqEM߭uRU~|r*1815jdM+V];QkH]%@d+gg	O|VeVӲ>3#_:K<aae`UUoʜ
KVFL{gNFFUzK{ʹa@z셓{2ΎmV|ؽ?Ӹ'|kxPP|zCl<KqkzmE"/n
+;ňQ=5"H\Zz{5=x'5d6ǫoZF^fOf?5ZVwbmmalT''VYsRf97y<go}__Ŋ{RYxg,VVs:yvF%c/P̨M]
U{2WKDCC1rybG]̕|Z')R43%1xH|DWMt݆6~ _ #{u Ʃ׀GX42`OOzhq6YiRTF3cni}
>hƦx:m[ _+3/Gݛ^bQ"1'yqLgݛǖ.uQsccjzdH83!?e->#SW<+TPOb ߣԸشc$uCfP6!vvc("%+Oa
~2Սq=qO:>gj3ɗ]JmQy}/ؙp2&,w8M""/&GwoZ>:V֪U*5/[܅z_04ȏkbJ7|*|7a="t3=e1fc`bY\8E|SO.Y2UJ+fbv:n~-[DѨC{GLsu6BG^>??2 ݙSR||@e'b&&IE5?3c2^PMˮ}a?Sq՞jJS΄~;!wvՇX#
"8' 71'qE2
F,1?ϼfD"ft¾౼)%p9'xYEس<aѷ]\,~d)Žk~X>(L?>1s3Y@xgT)>efTyL{;/䑘e|Gkm"&@ZcaG$A8lCR? k5ǀ[M჎p1~t~P@>>iJO|`@^X8i@w\&E^ RWwχr|1Aq|ދq?.S5|Vfe?wmM>ze&g@El*LNFM978_~9Yyx?G{U$+/ar|!xDQ8S|u)?G\סGG59FBX
_rM=,')?c.uߡ G*b~h7zd"0E<SAc.q]Mo
{)V'  wTAu@~Qm=m7D
y/R|Ҫ둒ޟ3~C*5kR_|r^uk"2}~ocWOKb"s=K$#ǡ;\Cti?n1,0CT!b?)/kǱװ;Y]:B >Ivh|.=|~q<[-8/F;}.Dz<ޓG4y5_~pghw##c4Q2FV'VO[-=(!z86#_*z[?-Dd0sY_c?Y2}&֔;]kgwGw;gjzɥwRJY/si"Mc^У ^ zv~#Ko>R}!pL
Bޠf0ǒD^ѷhTa91GUUϋb>
{|]
>3b`-.TIN[v
	"&fпpB~@sw^H3׶Z;O֣}Pp>V#86ږs!qllBH;63(cM_Ң3j$x+UkŸu?b#Dm{5'pr,_~gg k|cȷ*+Anmg_Ϛzzs԰H|Bh&g(≒&FBX[Kw|IN^s2>+:|C,.gM%eXY[<ۃLj<6WKuq$x2_<Y"Xۊt z>#<Q޲:	s %.u11NNjfHı:8tf%
/H`_hs|i	>v4Fz}_UU`HczTcz>c}=ǑASr|	|:ׁ[J@ýaD-1c13vړTOsSx*oNc"ݢ-qK\A|F|J}>g1\ H4;kǃcSE2oh~ȵgX׼> ױ. <O[B
{/~2>b=/|=3GQ&D(*V'><RDʑ
Eٴ2no2p<nii/ǱʢR>	\K
_"
a<?,c`l'19&MIj/pnYG~Sukq
u{!u8)WG]Uȯx';\LO"Cfĉ$N_$t Uf N5荺c<#6u)<
:$
a>U'ǡ,Uש>\I!uI=_OÄ
vp}ݫ%4X[~d=,Mq
l9ƿؘ<Wڪ*I>R9_I| :CCx=%!Uz?]sEKrHf9w^/}=)$)<"-xs2_Ws|^Ϝy]:
:ݿBxqZMla7ob6y'\{}ҍX07{$
MҤbBq&A)):+ϢuŔ+w|:F"?~DCNr\!WLY
PK   RRdMa       HOW_TO_C.ODE/POLYGO/ARTICLE.ASTY[s~.gOf(TJKD$}%.`~Xre=\߳Lky
_WWW5%qk<T|ay{8̫ջ|Px9Lq8yAj\}ZDTQEhJc^(MyegpFIzrjʭ*+q&3N'Ckd ˫rimԏ*KY\<SǨ8!q nPe* dRMP:3hTk㺢\*5.a7Hl66aVݸFE%kHAiw&\oJCTnfMwV\~Tyޔ4yo. |tjȻ4*U:tI.BكѕJ/&U'U<U1dۺj6Oh&66S: }HLH]vvMǋM<Z`rs;/uk׽ºe	WѵSn+l']	Oi[;`^m#ZDc;x1~Gw9
TmClP%gCZ~@O{63bK6+aV0b
$=PlST3|48[]֙ nيf<]T2,׬:}񁯮!)( +\Ne?:@w=Rd<zx>NKZ]QۏV]뢀I&I,vYC80جx{5ŵ`rqڠ˓Um
Dt:@%jC1Q`".46QjIߋs De0=]SPsV᳈uFh	CŀJ<D{*6NW%EFnID,^L@gU3mjVÛHpH.*<~
~Ԁ/26K
3@~^w
{[ G 'WVp4$=YKo!cns0cuwW\[DA2AgS ?[TkEHKZbvh 2NhO9@-g#	D2J@)1UDdN+	Z?T3m@g'j߉R'D*_0%wxkJM,$3YQ(.ʄ-SUy4OL]42e:dgʰ/#+Gi{|+z_'㛀ހb1<-f8`/сulՉDw/0"MiK? Hui}kpW>#ߋґ
&rX	t~]zF>M&ju4Ygdz=ڌ&nrCMu9ruA
A(T)5KSIǩ oQڋLp3^ɹ([f,{ݭ@'6/LƬsM:=AӆC"<Ѻ
	*6s(WBA%y\Z#8>5)xj<],aQ!-(Od745y)N(p${&5 h $8Aq~Îغ-N-#%$.ܖ0Ұ2ot(6#'6unXt5H؇^kgE ]d{ { SHR	!*`䍊Pw#o;vC_&k|U*h;)fs5ʰ	WA>8/Cnw1A oQH@uy
59ZҨiXcc,A竚hHѲzCjPйyl䏋u@r Y3o|(|]6aIx:k,uE;yFF~YOfLܤ2 Ck;2|^y
woG<TBQ(yBc{5lT+nwvhyfMyeq2i(|寐Rf,,U
x!~[cu`83cnـSRsNQ9jT\r$c uCVwv9nΞra$&HKVۈ,I/H>Bwcb1uOr
IHR!٢-? ~S"H~t;Lp_U/3`2C6}9H@nUB&W=U禹[eoYFq2: O[919Lډ~3u$i_ .$ƭ]T~D<r_\rvkbX"`E /@-HSB,
ͦ`'6^/xsA$[3<"KMEC=ڇd&ũЩxq<Le,JԺ|[4D3RF~7B7AŚq}Ect;~~[EѡgMb毉8A%N

`k/dCI&TsY S=W6y#2(pT6}TcjNn5aZa UI;ܞ1UGDƱ稢Q-*4*Âe70^WwԛT@ˤTa?Gڙ/ů
1bJA ?(7HPe"CW?N&;`dڳ
/|0TJu!w?WPK   RR%#j  E     HOW_TO_C.ODE/POLYGO/HTC_POLY.S<sHkf+QXIqݻFbc%hq˿% NrX<3<e_϶lL版f_2=ɣbͿg29Y(F>,Nb1"FUx4O?4~p)Mm>8b4a4G;=wO+g?P7i~Zz
d/{үA٤!k'|P=>.
Nd*H>sWcF.ew^tfΫbgI|'\=̣<(?X4_2|vB\r"wFf$bip$>_8^FSB5n;yxmvvw|3:oGEZ]S/}FyR+mp/wSh$b`lmy$:o}T|Z%b"/<_-i6/_O}dmMB^8d4-Cd0Cv$:!Y4 4ϷEw<Ix Ҕr?۸yLYZDHuWEzHE@Wfk9)0|?	P=%tf҆fr7s(ŇXg55HٍسFͽ8ޱx0ͣU{@ixjW-6Ҍ'\ D  ld;r$ȓ"PHk-{ yuy|NxHdxʐ|Pa;0ø8*(S}zl͌`.c|/ꄽ҄uz
תmZhyf3|
`䖏_q2؂;Ԗw8)2&UM<E
 9()oeb""$KH\#Or	@,@4$d}2$Ʃ$EPa8vIiG@<E`>8G*BdG&D  6JiD"?ݦh4C
| d͢;E%Q'K8A_a1VXL2%{="Zqw!&+$nʻlvg8:ae<n$K]p7/!_MBt/ok
LZ  oJ-6ɌG5 ֈ@I7mb|`j}
 K_a+2xLfuOxLL<{ŷɬB0oBOu!~+mpQ,͙-M=+Ӏfe2&s]%4DU!f,A܊G/cwzʥFOOCBVX(f?# SE'l^KW<CLbs!,z٪HX,9,>9Eg T-/|$Zh_La]Ch2M	2NQ"(T
\Je9pn)I@*V	_\Sp8׮~K0"70:"<	.!љ))2HIP"b> ?$ܢy2VSD@Bu|,gjjK	Fd;$	eO5_xn>=u;|CօJ(
է
Hui;:	8̡ 84<Rఉ`A	,X
ߍ\5	ɬ<U*
"Mj*ջs ?mw7k$<EcpA~"ʗ 9$5\w{=UZRT'E"yf_a!d
1\=ML^94-m(`*]nXSmxE4eРh%hʥHZMJ>ʩ
_U5F7I+xJXaظ?ƶm2r+7 _vX&e.H]\UIzb`В^|Bn/<*a]!~B
) H3%7vCFU	DΓm	)۬7_S׭`/Ԅ
`*oJ*7isKaWDģQdW+^asKJ
F^N,4( I,XTD(h(_UY-srM
g'ȤաfSEPaizCV*JYK[kVdT&O誐
AHՉ-(Q2ԧR2l+i!OT#gg$e+`CՒ5]`BquĲ+%<d2ը)^{?cF[`|ʹZɸMσtrCi<Y,!5uv:
=nu;;B6زyI{hX]#Ee}ڬK.ŕxw̷3	Ы
Pˏ@DTsDwYQmB9iuA`ؘdm]f%QcW6,GRH)h6]0AG~ha?ڷ{ea+g
ŋl:]-T1m<JK@]b[4%l# NFgk]שך^Bib11{F?gݐȃ%qSh(oro KIHD?]CRmHa =8u/ ɐvl¯U"' ~T]O7>* %^l}Ӌa<3
3C`A4	CZFXP.?y*ˍ71Gϓ@?FLV'GorOϨrꈩ~o#:XV+&ZWmq-*m3[daI,O_DHT-xfD,`{L@D:5/q=5}`͡gnQ60LUB~O<@V9VEABvç|j+v^P8ZgsO >8xi$u}VIF2]LI\#W}*ƞC\[COe@ʢb$02{@Hp"\Lu<kXMtB^W#FxBs,C`}O_m
YAn	 %\wb(#@b:~).rt]2H~+7M\NElaz*)sICƐQ2dFII .vd/TN|\v0IMeH0>:}	7h}v𝥋h(J1iH1ZE
pYC#PsK4Cw9xǧ}4dmQ]!VzIG}H7UYzE[m6:䁜<zfjCfK.SO<;UՔPh2E5A+X\E jZvA%Y:E}&jEJM
Q$BMx/dWT$tW)rÚвxnMeWD  ?>B%A2L(XrxVNgloT >R
TV25VL	p!͗+,)l /-F9
i,BJ"tYZOLYߚzU7SN@|Ao/@\O^X#')+I5*zb6y$^xq
ῳN+ω^k!S:cJNXe[uIH8.mx#÷q2jPTʫ$s("[m=*\S
KU|u)S)&ݓ-[	Gxs5
1҆P3@*PfY'iFAvn6)órmDDW)^$NcG5r|*xj
<j}jdLR<2]PRYLVQ/K
3{O7Sqy2^#}\46ut61lpZ5UjYs|%>CA);H:5qKb`,@y~72
Ѝ
(kF%Rv m7DN!@f)w\*A)Ijy>m8u_%M Ϝ&t3dFM!Yߗ̱Kjl]t/J7fǣ#=ȱ8P99a	gp'Jcꑖ&fy_?pYr]^'7M9P=#1Bkx/ayyX
I
BkOށ?`x-|
\9`x
|i1<ӈӌ9*9#i4|hM4{|7QFuO3F}!?Q7pkP`4
*j|9~wqBWu_-:į.)k4XO>aO4OS4|M%2Rз8?йC/:Hm%5-U\&GtRںɲ
^`ݺ~׍3~	3|XؐgjgLdڇ,Oج5&=V]pXbAQM^h	vQPu9I@j݂P<ɀÍk_,ik+yr[Dť(-Mqc+ˡhb`-G*өeJ}}p0mB^ה %nYR=;s6w"(- TʞBoKPz>'
۹:P,y?wյyD4ŋd7VrDx&јh4骧~yO
լ4kA	QhS
ҺDa%
l%m}H|eA{ݥzrlJn`WTNngۼuB$5/@e0h*HQmÉ]ܛ	v6<!A`iv
~exz7ֻx89k_5_o/l^/ý /;>+xg5%N<y36ˎ=Z-xl.Sݝ e@į~+/Z|oz=΋pؽ#ӽwtu`d9FɈj!	i(C
Z4tȇ4t|
GC
:
!B>iiEC|NC'|ȧߧǣ7cRH֑N_Y6X	JGƷ	R| mA4ӳ#AoPw"NxRo%ԹD5!LyĖ:!Ɨ5{?(o?PK   RR5  ,     HOW_TO_C.ODE/ROLLER/FONT.BASc`rOstrtf@  #3a``E@Xm@`PpHhXxDdC׆U.@܄Zqd*V=d <dt}pmCF7{;RK2676\w=dRpzȬ!#

@ٕ1T` 4;ОJn"  M~_,#H $v,
'L1!nea{ĤQAA
lg#& V#F(+
s|0miT }ow;Naq2;1'6ߝnNL  PK   RR%V        HOW_TO_C.ODE/ROLLER/FONT.DAT嘹q@1F {V2t#@ ]Jp	*%TKP	,.`
}@7-}}xqϬA!}{~߿Os媺<7;3-k{$uU_J|uKgYkMx]ۆ4k4=D!Mh|	֒MH|x@<8ȣe,>gYzTJqZdR$}<O?	K?EJBRkR(c,jbj#x=J?=((J3ITB?D;tl.y*W]ayr'#}jҧ!}:ҧx@< X<qAiȼaTLh
ѧ&9cO1}ԗ>tԗ>G'u~81OEHaC},zG<
Tg1I%Rfj(c	-etx*9П>yGgH/GJ3LsP_N߂R1"_,>f5*f{"-?<vh斷#uBiB}~O4Ud(1.#YEq'f_ő3[lK/?Y鈧|3r3r3r3pRA$#\Y-8FNGbYߜ<F_9caݔ{/hikI>ְ3ɳ}?kڜlSm> PK   RRa}a.  B}     HOW_TO_C.ODE/ROLLER/FONT.PI1YnF\K .)X]TI K"@ZW_Z"?H:dzo;wRgXeh^8r߫>jߗKܚ߻zpuCCcy?ǱOSFڥFqJO3KcJiXR:ޤRG_ENۍt~fS~+핟2ݿWʯϟJF
Y
ۨs-Ǻf53wm6E:ez\z>۸qս2\罞Q{Q<ƙ['_gK;}ur+b)ik2M>n%OӨVM_kݗzģ=+ǞT+?ZW'W9C,ϝ\~8k>r,3덮ӃEpoHƄB\<Z^=ʍyE_q}.u"]*13|R_}/lry}{~pSdO/3V׶j>zGWV.ȿ˵n:n<v_5}lfwo2\Mi=Xn1.Vw]goi&+ge>rq=d8٢UJ}ُD'X=(UN6>qn'rZDCq{A~]snC9q'g;ϟGz_Z}WY*9=ˉN/f|}pNvj9
jm컽0}z@à0n_Ergeb71~rB6w,o,	~S~7o<}B/&lKگ|Wjz}^T" >x0NR@.{EAz}`^ǥ^<aA	G/ >8^>H >(˞Az}^<qid<>j'>x~>HNA>(B =. >H
>gz}P^Az\#&OI@>x;z}=AzЃ=qB\˧yϠJ>>lEPK   RRWT/n        HOW_TO_C.ODE/ROLLER/LEMNISCA.BASUAhW۝7c.
AD֙j"TJy
$$Yo&HlC)Eȡo=h<i	2śd{/lry'4Z.) R|bv_0kg)^hރbSl4s,;	vQ.Oz)zX*`1W'ϡOKF/O>9)U=^2+%o0w%Z5m9go+#K_8̖GR,
7k-y^EqZe$c6.+s&?θSkS+vZgλs)py~}3fn({g:ܘu3F$`QN)ɘ16-FqFO܉]qvE >8tXIUPE6^;(*
 ޡVTENT|VE/sUi$bEhj4B찄S$٘Y930>~$%@45ZgUVde.ޓ2n%,UR17|yRE+nqhZtX[F?uOWhR:E3'[uP{b$)f;eLN3~87I+_k*qa*::Rgvˤí6:@Vx7ſvAyV}Kyb6Iu~LP?{==I-"ƒc;Q7Ͱǒ~	Y\΁z
IVhXՃG.?}v:x7pgp1ݿGWoIHv{E`o-|PK   RR"Cm  `	      HOW_TO_C.ODE/ROLLER/LEMNISCA.DATԫwZ$!26Lp2@>W3]>Y9YYD92r䑕ȑGV"+Nj~++};xc{tx	u^a0(x	ma
 x	>r}(tzW~3{u+qRNG!z;!\@5-v.c-] F˯S_0a3~
@#>]L!f2EEO؁(n Rx^5:XfMSp<q'jK؞Ia9T0Z	5`1n	!!h(j$l%69P؈%L0T݇kşR
'SS ﹙KJ=bM}an .pgVkUfQu
n|hScxS4)MZs0A8zC\ky7hS&P?SҬ!!6.a΢,/zN}`M^a?|6Aps*股btNk)]g?]A-0Npa[,Δ%0,֣λV!TOt6P}N6ЗGpy{Ll3Pjrw	uC
D-VgzM0FVUS؍Rr0ވ|/=j1|OHZ9QD$\;=3
&}>,
<ˇ 0I^mpv+(ä0٥&GX#ޘ&U5{cջϫwWPK   RR/p0
       HOW_TO_C.ODE/ROLLER/ROLLER_C.SYoFf{Z) Qns=0V*aKfvI.eNQ=P~OL~Em/
Y'm-tJ6Yi%RE*ERѻ*'^ϾY"t	o,ȁ:q/VŌ~OwkUZ7eZi-FlZῪZheZd%ԯm~"kNH+ߞ &IK@.+pFbt&t**!QMD]R(u`Z&JzUy]A>)	5BWo:;VǓɫ߼}
 9vRh,
O}7;gҷ<$ik%̴l/	^ѹۺJ>JME`/b#H_9?};~dIіnC=$7>ޒ 7rPSWxEuflȣI{ӹ/ގptLSB.c3I-z ENѽ	9wH;:>>fI$@'=o*V$S@x̠,UvZ؄b^"79yˬ̚&漩xp&9MHf@VztA2&6+&b4,L#N5"2. ,D?BP%VvRY{{^x?fHMϥ+fFS."30=rxM[;P>ܞhC:aŎx;;>#g;^#
]6r })IRL CCՃ0IKҍo^Rl3"`oqlH$IXj=ny?Z1_fSC̯N;{Q+sTrxQx=}bz.\LP~0頖E ,!캾F0@-H~R$1H-`L
4MAbEb͎J97V7D"Tu5W<HEiE.en7e%/ĢTm4M'i .q 8fN;QT/y`
YK;죛Yܫ6W-\xS84@-xJɑTƒ.
`IBj[2Fv2mj轏Wlo&IK6Lqi<( BKq%vs XBDSրYq
X`v_FX];dH8CYV8p媟FX5̐XKbB,O >7Kt8`12>/<[ry/<|coo
y<=il)cYy26!d-&
%㻋[*{Ppfn(-∍bd陼>eʪu%Z.U׵k9M`vvkfII*'_ch=t`d
C
?↜\RH1;fM(cYWc4gLMc?\<vd;wל6:O`?}hvua?j!rd}lF`Wͭw|HW|WnZRW+ IB^ &9EiI7_/?
mk6&*A~ȓ6k!UKz+@^Cg ];t&6Hhjd,Nf˩7%c4Nė *q&uL- KF*`"s]Eحf\eljvAJ8%sף`4
GME<晃hA{|҈IPB7ZaMAF t3@f"W[c?W5ZFh^iN'|LLPz:C?|;~^ߠ7~[o'1u l.6@]8B8
a 
Rq&C/v D0*Lr%8\\QLzdar\vq|\IgR@[GidW	n^`:TII[~-bCmmv;̇0vlYX0YbGe?mRw>_ ?Ֆ[	\Uu[೽[ԽoCΝKKW˭-U94|-K*K䃺Zҋs?mf>h(XIKOV0O
WPT	}ڠ^Vaod;2{$;I].KoC;{Lj"fCM05IGqҵǭNPr98=4uІ$*#.z}Eι/L*2?۝ԇLۘ]%Nޝp%&\}jj]`;<XWY8(Q"&k8#
=X\,G{%?^#Fc6e:uV5|O;FoHܭ/&lcwo]5QnUO9V	Ѧ\Nj2i2s1[[i%
@BF,B3'؛|dG fj`Ȱ{r1㳗G(b
`L?PK   RRDZ.`  ~      HOW_TO_C.ODE/ROLLER/ROTATE_5.BASc`rOstrtf  bXUP1:  '
0001 cFGFg`  	
`f
qef0ǘSOQ~IbIj^Jbȥ]w7l q_d*[~BH)B@Qf^c.PK(yݟ.	\v7LbL<b  $ {YL݂ٔ1Bd0*?b@3TR
#ftcPP #Ty+%>`%G02'lGnl`#7wkֲGnw,|w%1g2  PK   RRn~   Q      HOW_TO_C.ODE/ROLLER/ROTATE_5.DAT\lmA00 8````   <AAA<^Zeuj;;NlMlͳ2ʮ>{9{k޲|=7F̷Vw|/o睼򃼟|q~Y>ɧy>E~_]~?S5_o{^lEh[E.;nWN-zA/A1,FŸ8*N⬘⼘⢸,⮸/x.^EZ,\/7ͲQ6˭Unʝr+e얽엇r\eu^v|[ݼw>䷕\"оBNVrКsBSy'_>HJ>0%{T{L| n+> nuq8Эq[qyHG
d$2	>:e}E?ϵ
:GsYFќX0sZ̒FD>?yu_ڼ#B"F>*-iKs
SQA	S}$'pޙh7]]ǐC$%5>$扏Li&>Ҽ t}Y3ۂN/MoKճ}|.4'Ş䊭[Xѧs4	9'SgMJys7
>y9+QYjJ-U3azotG[J}!#=i;fRɺHNlzG90)5O|&r >&>:k]ut
HzbࠩR!}e/.,s$|fgd>cs>6|:ѧi>(>su}Ipu)$>L
s	|2OB/iѧJRI]ڢ;t8_,="*J:#rb:,ZNs|^ϩM4-8Ka>O9!Wڼ053Iϴ|N:1}>ř>}━C/NML[8L|#>#;]sNm;M'Sl|9f:05>mKM'l>-̭]WnҺ]"mJѫ}ga>L3>ӧrbMs$E)}d
c泮
MBm	|owAG}bŔ+̸֩fn2fvR	vrb>3IЇF;ީIyM:3MVlgnlmi|4ʇ)Js}]6e8hZݷ.Yq>zgb5>Ip> &nʇBERW>CMSRN32,SLn h+KWs}4'}J|Ixn-Yw9OaP>;y>:CϠNr'Ef}&z&Oފ=}ٍ%+:W5#:L:P(wc*K:[#+#G;C*SKV&a/BhkBe'@֭ܳ>/|:ٱ	>mludt7ԜERs:Щ9rԜmx7ݼw>x|;x}>WN $<+!'M%$Gnyxٚ}F_|z_tP(XIR:H	|Dm}A> n5:Ⱦ#VqyHG
&z~NaE|}-UGsҷ\y賝Lܼ$<'>0Ϧ&%d	OÚWٴ
>A-*/,U2Zd>Zz\Gu1'*#=za>ڣܴwG{ )1W($>w3	jOh4fRM6/G
EN[azaZ<,'̕nu>O|ICUG1)H,A6m617?͇:2HIbڥu$'3҇-s*i:}Gr]n0Wz}$'s6Oz73|30)3Hħ˫s7!&fɺB=o^j#-Se>s^ .<ӧiEs<yϫͥ5E&J&wROhܴy
ɆIaB4Aq,>g泯B?fO|̤.mQ{kn|^#GHNmIϦy3ϦjaYiXN.r>&&:ټ'K)g1ya2k2Il<l|3O{$ֽU)8:edږH:nOQ;sb>h0iv'Iޯo>05}>Kag.=^O2IvEu4\E ';LӍ>I=\|xG>gY|4ArվF}ְ6~qϼU	άg>Lv1%s%0eeצy<P7N]g̫]ꃜX&s|飓F.\>Ҥlh><&`ߥ

VM"tULaJ3Kkt]6e8hO>vbWԧCъφ}ԟ}DMyd	bRɊ>*5}^鳥));|d[W>px\yɕ
DQҹDb3Wއ9|IY$>F%[Gn!>+>LIy
kNQ-[|8mʧ}f>zE|4'o6у5|}8i5Q5YT|l{vk:=:p&%:P(c*q0tsU+U#EsÛ&IKh4nIv]Jz:e[[gs$elBqyFxl68ǻy|7fb%tUBG\%E!u"SMt*DROtdNw>$9$>})vhN}}7?y_PyYOSrCTGRr,js> nuqŭq[q|nQ$|&$I`	gNZ0#>kYirkr>˕9>ŷħ}r|vվO*$>?yuQ>"P9:Ң_*Lf҃b٧>Ӌ9Yч9unڻ=jÍ>ڣu̕ARbA>3	5>2yA0,8;0:p>S(Ts}EMgrr\IV}.W|:l|&IN&>Ϛmy;೉=wMsȍG|1չהan3ii3'ouET>'GݛL6shN4Wr7Lһݼ"{6O|y-~c
}ΚLeBӄ9z>+B>LOl*7آ8|d}N+iF̣Ι
\\>
E`J|'4	[\ä0W<K4g@gl3ħJRgRh6
'Kn-J6Oϋ9Ϻ0òs`9\>:qŇW<܇6iYO4
Ya6|zud %pdEڥS8z6e0muJ|Ν{'(.9U>[̑0izpT5\"{?6od
YSɒ٤	!3qiI
k׺[״.iw֢N9>չMANw2O#̣O>͕,4>AkvG$MF}as
dLKvf#޲tS%:.MI1W:	ST>8ܙL]gWGrb>M|8g6i
j>hq26i.MVh+gM{q6%VRGSMg#um %pMy'o]HŊ}>>06	Ol܂ϥ%I&|:QG:Tt#̔`:ާc>MQNÜn h&{\yI; m}Fdg>C#B#.0%ٍǩT1кi\U>4)aNp_=XgTK`gI!Ft3@кgÁ*örn/y^MQM*a[:_t>/|F	>;x};xJ\ㄢPE	Pɝ5l3yWx[dZRjQ'KբNx7ݼw>x7ݜ}:_t|_PӃdtKu=uu8[Gĭ#M~џ}A>ng$%R!8z>dCe+>lQ0#>9[sxˉlGGsҷ\M
ܶB&V'L#B?8ETNhk;1^	S}$'rٴnڻ=\9IJ 
i7oR&Nڋ>?dw`OW[<H|ExI}C+_?<,4Irr`|cgI)Jj	
>߱GD}`߱:8tb0'M~+~>l|ϬsF[U9ٴ9IZ||5&{iޜor~ڬ=&k$>ξ{EZ>9 *iG*ua<gi>0n9JKg><>jr|Iv>saR<My _6C|7p.mQ{5'-Ͼ|Ml
D
ӢυQYd3lg|.ϓMm4Wp8`^,A;^S~)='*wu&7q&i"#$]2p؏SgSE<O|G<Xy8h*W[u#3'¤9[<w#4LNޯo><{sl[D).̥g:Ekj>r.i]<d ߔS|jD7ɉΫUς>ȉj3
>·C|4AҤr>){sΦ*A?]Hl3UŔdߘ~ވSf_JGNŹ4~ϫy '+#Wq9`t҈ObI}$<'6d]LvY{iMzó/ө|80U3Zg>/zj>|F\G#Blci^5mag)!)pة-BymFЙgM|(=lL,|c>K;,񑜬@4F+I},'v%M;},P1;SJO+|zVos}lGTҳ0кiVB*a'ۂfⳌ>]9iY|pd>,s]-|@礦3Ú;i̝lZ|d}wҘ?؝4Osuɹv:?ΟkϯN%;׹SɮDOnd%=#w|?wPK   RRaO,  #     HOW_TO_C.ODE/ST/REGISTER.ASCYF*C;Q$`6*`w3/dϺ0r@"v9ǈM\9}Bߟ|A|ğ%% &/XbąkcQBq2B%E.իWb&#^ <2EJ<u%"Wxh
} >I%>*8#"&
zMJIP@|઒eTk(_c1fB`f	a<MM`0w R$U+t9 	[,<
uZĻa|٬X4~^xE`*ՒO ^	֊H(:M
E
^
aݐJߙW *2iYɅS]
*4MuzdgbUr"UKAJ>la~6L >f`4{I>!Or"Y_ii6i
W߬yY~1#؂)I&}A|yy;بE,0L-6,xea'^E踍Bfx\~*m`{_I$zDq?OFb4wh"kVkxnDqdxeĂ.
>^̓\=<bwEeAb82#Uo	0Gs<3w;T&uK@"C=<G$&A$|*IN)0A@>?fil+3i	B"hkQNWԦ$k>4$,9v)bZIpΓkOM;+WO74YuU9h;:MW8#=0{/'><]m0KW+E"&
0X!#~z)4ގV"d
(LSz |z5O$9*⊖azh
t-Rk9x1]#·U[HNiNFoAuHżwd)c^@f""qϓl|"͈xbBXVD៧ToǓc=-,sRT`6!zRRTOY\(w>BPEPShǮ0H_J?PseYk=f=0[Gu=f=4su-*A!R;϶q5BLf\@!	`ڮ܌塭th܎*٭6fs%;F=ÍnξDLE-MVQsz?@8f
}
IU1Y"UE1M{}D(7-gA.)iR붥j؛V_'fjW*qB7S فKRbAb>$^',=&$޷5	hM"QI$;)H Nf
)|-
6Ngst{T\
IUhΠKq\EbGy	\ᄕ!{{\A"EmU:SQr׹sz=:ઐ:,@onOQɰ*::EhpA"Ծnjd<&iAhChBjudzNݯ,%Ʋ2ƪ~<<DPd7ҕ7oے4
STtu)VD!jцD`BR9KZu@ōDR[)ݿIPљKD:CoVO0¢A_`+6_/^֮b
Be<1#p$'Xe֛ȳSu	P]Q5s/泥qiXB j{H2m&"f"jCƥrЁ!ig6m%NeŹB>TŅ(Kbo	,A4-Z%Z3KTawN
*NV4?ޚ =׉!
1r0
.qdc1i4dN:#-f{w75t[z]1Z
fN#$NH
jno^-5
^[VthO49I)]%QPHĵn__O+i</໧_=!ebFtkG~!%EX8@ik5W~,M:/+1ZHcֺEGM?4RN'pܿȅ& ?l?96E|9*@J"ާލmAa6a%x4O g
:Jl<Çɮ8W%bu|mv[Ȗt:M/ZnRW\_wW1=dWϕ[{ԝELrCGK/_HӁDEvz>]ASxȨ7]ᷡuQ$DJ
%X3zG?IDIM/)EH_')`CYY>Ȣv^YYnsFhDy(Pcq" yB'#3rkDbx$RF}$S(*ex1
(~G%4ao)~o߁aT[X9<Hbۢ5p
W
۳TL1	
-[qlaft7t6QSa72&qαJ0SIa:]+6YL=dd4c
}lN5vXjAͣk-rnCy{<Ej%F+q'R6ז7*b]rs
s8~3ήCòb]gϡab][ainO&YgφYϙKbdܵ }R:׺J·
z}&0Xf/D=4s7vWt*NjOUk>;$˄	Eh,=܊>3c;7}>k`
MU4H5Z~:)x+
=uHTU!$ k{_{+nlyC:=
of,fps1@{7v5nSqy*lӳp4#ӫ6;`HTȰv
>L/bj'p-5WFc(W_sYZ1Kx=,o<CL,*FzT"yyhSoqՍ]y utGoNE|?LSdyIMw|N֊XuLȠ) V})q؞r?ގFI\c᠍=fre5V2(:%:6sL  95TPK   RR罥	       HOW_TO_C.ODE/TRACK/INITS.DOX]oG|'	
(F?尢3/(<Cz.a_U.))B6?vg{V~g^WjWZ[ɯ;u2`Fr+׫[yJҙ2knJ=m#iޗ2,W?߯T߸|Ⴕvc&bHOՊZ\\Lf|\T^ǧ/cJ|R*u6״!8?y}v*]h^g/^>imFry7Ny{gۯZ{Jw9EXy+"Y,KWYXn+\5T*u\=p5m|~5$knM"rmqOR;YO땷<IMm6Ɠz~o7 Y@Ԇ$af6u^ma3;67#R*[egKFBjK"@#rQ5xj=/jA0變ȡ]lآR a~gBA]QW+j
6wg1
ZT"Np0.b,܋]VM>TD	 1HuDD(66Ĕ\rNH+G`VVZ7PR(j$YUB+2
53>C5ZVE
8ӊHL~vpPjb@=H>.b˭+E+S
[DֹymE	bF2!ꅍ y"ؖcYE?0vKn|iOpsybH@0-v6o4a cG@L,ȯ	7q*l!I+evd`Kv( s*-Cdlf|gk	^oc;PUg7L[&972{q"X.Uz:-&
ǗR i)݌`!~Ȉnm>~rj&#.PPk}Jj0Ò:Zz|c 8wtZ`y(
|"Zt5{V\XoQO0>	S7loι059
+,ЫX -E#Dc]D*^uHcÒ [~' ﬨv4<>#Qަ&O(}[.ۯ- ŘR@:ZIda%kd˽ F{LLȞ9xJ	~!
U(>8[Mto8tW
wM2_V[f/s#nMt##rPʊD²WQ
(NtNӔH;ǅcl4r#XDmW+	27uhtA𧖀8 W(}N>%r\yR·RY/WPO|cX8$pC4 [RN5psb :Ƀ=tftŏ VޣAqeo޿~+w\x>~2IoAC/`}6
ZSN#Utv`v$A[f$<]9wuƄf#D;6SYk1a֕{$GGFiCN96FFǄpp8<i^CB7u !#gG)[	SҾ饞W~w<iY2GRmN"8Ԫn(=
|ӛlyVO\OkcID_uՈiv[kc1∓ي.{hBgBSD?ÀjnTq|tbR`k8a4or!Tv|s@y> n(q8'Q" HA^rL~jes͢^ƕǞiu*\ڱѾ<*D*8s9a_#₆cWRөye6fO?c3PQ<ԫSRnt]za
f
9+~J$s<;8#Yϒ֣Yn> Hèꍏ#t~WŞz`c9Cc#;Xf[paժW+f.:0+~I
VO̓U\j×_s8APWz~\\oGRH\5ltW;{e}_zcJle\&|MIʞ0!&9yUZMnZ
Yo_zH	Y=+Y6g+qJ
'SuP>`8lxe9'fWW+G`M{ef$Jt˗/S)
C"YbO1΁|X/nb}ms7gJa6UVFR;JbJc*mVP0RJ
!ylDh4@wc'	!ޖlYTFyUr:99!>grYof
MZw| ֳx*_W:y?b[`c0_U?X6NMY7|X	&.FbOfGO	kb֏pW9Ŷ-QګyGb) /d"0q벪ɩCEuhE`V<Dy
vuQUq1^
P}8$|1a\g]4
&rY
d&s؁4FFIp\ X.[WTJZWߝIų9U0YoOo7SO
S\cs aGM
5^-_q?uTG@pS}'b@y1@Ԃ=Qpb?r6`Doe6_
vbY)g0ru~="JK}ՉҺ97Ύ|i!h=Z 3(۬0V>Z4kW+=?AHhZ#f6/|5(k!Uvm[/
8pppe
ôص(
v挼Z̓jG:h	Tbҍͪ
LP* ^6P w{fy,X*$?9uG4i`uEL?fGl=y#U>Fb5;!$8N܎?YܬyV?"@Rt7E֪r;k`XITd_0\
Zg\a7DcOn8{0Kf%؟<_qU}7K%0C! Cl
`%/[X9w]
%Bc0/peaӄMp;daY(E@oa̉4bImBm|" ÿ*g*Ѽu#ݵ>%<[zMވ/
oM=7
$8ƚT<0Bt$F̱*4ɷk˺SE]{r͑Xfr-|^u%lzVn?s"+\֊B\E^zDuPn(V,UgzR*3ܔ++Lݲ֛
;*e
dQZ(|tN
%'̯RGE*c\aA\_:wmpѿ<{}udfKcYBl00|v'j~szxy
EJ%,HAYNgw۵N
㰆M2x& gQq#_|(Fgra].X#
" TP)_29Ζ9lˊ:*)%q,*X\Y,T0|˹ɲ`unD^y!M(ŌωI1.']-@8kX
<Ol[w:Hu
` F\?S<XKvz<%+M<j	Ff!ݦk=)6m3Vn8ly^Ίu5<#?Ky<W>ʌ5{(3g/	G/{ϐpSdz$KR=Eq#:m{5v]`
u;cb t~"	 t=GK;pGn0@ݠ:><PΆb MvY.hj_fNnΤ_hΣ/z_ޯ{gyWJf vcqei2=KǚQye|?7cqv9-GO4ՌGi.Tg{y,:AW+ei^=;Ź\Y5/)/^y;ju;89YδI?Dg&D0Cji+M\v׍Pgac!\aN];Wd]y~_<MjFM,6ⷛfd(8kɔGFz1J$(oi$9&&>ѣG7fqkSGrEGdBxoNyM8oņ
7z2 <osuQ_*Y{Bts!TSCoVeq=
L\m\mrSV(_z"3i:Di~vW5\#"Hj4xe1[n^B^R{ώ]*62f̟e
ɂ|xG8ŘG|E+gKts׎-z)X@HEQ1C%]| 0G-~y>H|5M7|Oq)7mYnHC_#r  c(ǜ0'e^xE6ϗ|Wm5ͪ@`}5h17#JLEL˩/І3>{_&ȸ
׈BU{
c()oqO
:fnJ74X4coX67婐:;ܡ=ulZQ$1Y[XB92$Pxͼ[Dy'oI3o3ewK&i)ȌB&<݌Cinh2jSLb&ʬVt2kgcih5dR^qFw`V]G*T/tYn6 o]栛+^LqR{M"v7|WlT-ia%*-ډS$J
;PK,9
'pYaȖ0O9PQHNE)E<آ>: 'zH=JS&EW!)̄iO3
=^i(\mJDǜ3|ebC^.2l172Rc=1s*	~+Y-+G