Program Bouncer;

Uses EasyGraf;

{ Filename: Bouncer.pas       }
{ Coder   : Jacob V. Pedersen }
{ Coded   : 4-8-1990          }
{ Purpose : Example           }

{ The mouse is not shown if you enter .TOS in the OPTIONS/Linker dialog }

{ Runtime commands are:

        [+] Increaces the size of the tail.
        [-] Decreaces the size of the tail.
        [C] Clears the screen.
        [F] Freezes the program.
        [ ] Set cleanup of tail to On/Off               }

Const
        AbsMax  = 200;                      { Max. number of lines. }
Var
        Brain   : Array[1..AbsMax, 1..4] OF Integer;
        Maxs,
        Coors   : Array[1..4] OF Integer;
        Direcs  : Array[1..4] OF Boolean;
        Cur_Max : Integer;                  { Current max. lines. }
        Drawn   : Integer;                  { Number of drawn lines. }
        CleanUp : Boolean;



Procedure DelargeTail;
Begin
  If (Cur_Max > 1) AND (CleanUp) THEN
    Begin
      LineColor(0);
      Line(Brain[1,1],Brain[1,2],Brain[1,3],Brain[1,4]);
      Dec(Drawn);
      Dec(Cur_Max);
      Move(Brain[2],Brain[1],8*Drawn);
    End;
End; { DelargeTail }


Procedure EnlargeTail;
Begin
  If (Cur_Max < AbsMax) THEN
    Inc(Cur_Max);
End; { EnlargeTail }


Procedure CheckTail;
Begin
  If (Drawn > Cur_Max) THEN
    Begin
      If (CleanUp) THEN
        Begin
          LineColor(0);
          Line(Brain[1,1],Brain[1,2],Brain[1,3],Brain[1,4]);
          Move(Brain[2],Brain[1],8*Cur_Max);
        End;
      Dec(Drawn);
    End;
End; { CheckTail }


Procedure CalculateCoors;
Var
        X : Byte;

Function CheckMax : Boolean;
Begin
  If (Coors[x] = Maxs[x]) and (Direcs[x]) then
   Begin
     Direcs[x] := False;
     CheckMax := True;
   End
 ELSE
   CheckMax := False;
End; { CheckMax }


Procedure MakeMin;
Begin
  If (Coors[x] = 0) and Not Direcs[x] then
    Direcs[x] := True;
End; { MakeMin }


Procedure Adjust;
Begin
  If (X = 1) then
    Begin
      If (Direcs[x]) then
        Begin If (Odd(Coors[2])) then Inc(Coors[1]); End
      ELSE
        Dec(Coors[x]);
    End
  ELSE
    If (Direcs[x]) then Inc(Coors[x]) else Dec(Coors[x]);
End; { Adjust }

Begin
  For X := 1 to 4 DO
    Begin
      If (CheckMax) then
      ELSE
        MakeMin;
      Adjust;
    End;
End; { CalculateCoors }


Procedure StartValues;
Var X : Byte;
Begin
  Maxs[1] := MaxX;
  Maxs[2] := MaxY;
  Maxs[3] := maxX;
  Maxs[4] := MaxY;
  For X := 1 to 4 DO
    Begin
      Coors[x] := Random(Maxs[x]);
      Direcs[x] := Odd(Random(20));
    End;
  Drawn   := 0;
  Cur_Max := 1;
  CleanUp := TRUE;
End; { StartValues }


Procedure Lets_Bounce;
Var
        Dummy : Char;
 Begin
  StartValues;
  Repeat
    CalculateCoors;
    LineColor(Random(MaxColor+1));
    Line(Coors[1],Coors[2],Coors[3],Coors[4]);
    Inc(Drawn);
    CheckTail;
    If (KeyPressed) THEN
      Repeat
        CASE UpCase(ReadKey) OF
          '+' : EnlargeTail;
          '-' : DelargeTail;
          ' ' : Begin
                  If (CleanUp = False) THEN
                    ClearDevice;
                  CleanUp := NOT(CleanUp);
                End;
          'C' : ClearDevice;
          'F' : Dummy := ReadKey;
          ELSE Exit;
        END;
      Until (Not(KeyPressed));
    Move( Coors, Brain[Drawn], 8 );
  Until False;
End; { Lets_Bounce }


BEGIN { main }
  Randomize;
  InitGraphics;
  ClearDevice;
  Lets_Bounce;
  DeInitGraphics
END.
