/*****************************************************************************/
/*                                                                           */
/* Modul: MGLOBAL.H                                                           */
/* Datum: 15/05/91                                                           */
/*                                                                           */
/*****************************************************************************/

#ifndef __MGLOBAL__
#define __MGLOBAL__

/****** DEFINES **************************************************************/

#define DESK          0                   /* Window-Handle/Klasse des Desktop als Objekt */
#define RC            2                   /* Raster Koordinaten */

#define FONT_SYSTEM   1                   /* GEM System Font */
#define FONT_SWISS    2                   /* Swiss Font */
#define FONT_DUTCH   14                   /* Dutch Font */

#ifndef max
#define max(a,b)    (((a) > (b)) ? (a) : (b)) /* Maximum-Funktion */
#define min(a,b)    (((a) < (b)) ? (a) : (b)) /* Minimum Funktion */
#endif

/****** TYPES ****************************************************************/

typedef struct
{
  WORD    mox;                            /* Maus-X-Position */
  WORD    moy;                            /* Maus-Y-Position */
  WORD    momask;                         /* Mausmaske */
  WORD    mobutton;                       /* Mausknopf oben/unten */
  WORD    kstate;                         /* Shift-Tastatur-Status */
  UWORD   kreturn;                        /* Keycode von Event-Keyboard */
  WORD    breturn;                        /* Anzahl der Klicks */
  WORD    ascii_code;                     /* ASCII-Code der Taste */
  WORD    scan_code;                      /* Scan-Code der Taste */
  BOOLEAN shift;                          /* Shift-Taste bettigt ? */
  BOOLEAN ctrl;                           /* Control-Taste bettigt ? */
  BOOLEAN alt;                            /* Alternate-Taste bettigt ? */
} MKINFO;                                 /* Mouse-Key-Info */

typedef struct
{
  WORD x;                                 /* X-Koordinate */
  WORD y;                                 /* Y-Koordinate */
  WORD w;                                 /* Breite */
  WORD h;                                 /* Hhe */
} RECT;

/****** VARIABLES ************************************************************/

extern WORD    vdi_myhandle;              /* Virtuelles Workstation Handle */

extern WORD    *my_mousnumber;         /* aktuelle Mausnummer */
extern MFORM   **my_mousform;					/* Zeiger auf Mausform */
extern BOOLEAN *Grow;                  /* Grow/Shrink eingeschaltet ? */

/****** FUNCTIONS ************************************************************/

GLOBAL VOID    myxywh2rect    _((WORD x, WORD y, WORD w, WORD h, RECT *rect));
GLOBAL BOOLEAN myrc_equal     _((CONST RECT *p1, CONST RECT *p2));
GLOBAL VOID    myrc_copy      _((CONST RECT *ps, RECT *pd));
GLOBAL BOOLEAN myrc_intersect _((CONST RECT *p1, RECT *p2));
GLOBAL VOID    myrc_union     _((CONST REG RECT *p1, REG RECT *p2));
GLOBAL VOID    rect2array   _((CONST RECT *rect, WORD *array));
GLOBAL VOID    xywh2array   _((WORD x, WORD y, WORD w, WORD h, WORD *array));
GLOBAL VOID    obj_rand     _((OBJECT *tree, WORD obj, RECT *r));

GLOBAL VOID    objc_rect    _((OBJECT *tree, WORD obj, RECT *rect, BOOLEAN calc_border));
GLOBAL VOID    set_ptext    _((OBJECT *tree, WORD obj, BYTE *s));
GLOBAL VOID    get_ptext    _((OBJECT *tree, WORD obj, BYTE *s));

GLOBAL VOID    line_default _((WORD vdi_myhandle));

GLOBAL VOID    mybeep         _((VOID));

GLOBAL VOID    do_state     _((OBJECT *tree, WORD obj, UWORD state));
GLOBAL VOID    undo_state   _((OBJECT *tree, WORD obj, UWORD state));
GLOBAL VOID    do_flags     _((OBJECT *tree, WORD obj, UWORD flags));
GLOBAL VOID    undo_flags   _((OBJECT *tree, WORD obj, UWORD flags));

GLOBAL VOID    mygrowbox      _((CONST RECT *st, CONST RECT *fin));
GLOBAL VOID    myshrinkbox    _((CONST RECT *fin, CONST RECT *st));

GLOBAL VOID    set_mouse    _((WORD number, MFORM *addr));
GLOBAL VOID    last_mouse   _((VOID));
GLOBAL VOID    hide_mouse   _((VOID));
GLOBAL VOID    show_mouse   _((VOID));
GLOBAL VOID    busy_mouse   _((VOID));
GLOBAL VOID    arrow_mouse  _((VOID));

#endif /* __MGLOBAL__ */
