/*****************************************************************************/
/*                                                                           */
/* Modul: MYDIAL.H                                                           */
/* Datum: 04/05/91                                                           */
/*                                                                           */
/*****************************************************************************/

#ifndef __MYDIAL__
#define __MYDIAL__

/****** DEFINES **************************************************************/

/* Erweiterte Objekttypen */
#define DIALMOVER  0x0011
#define DCRBUTTON  0x0012
#define UNDERLINE  0x0013
#define TITLELINE  0x0014
#define HELPBUT    0x0015
#define CIRCLEBUT  0x0016
#define UNDOBUT    0x001F

/* Flags fr popup_select */
#define	DO_POPUP		 0
#define	DO_CYCLE		-2
#define	DO_POPPREV	-1
#define	DO_POPNEXT	 1

/* Zentrierflags fr Alertboxtext */
#define ALCENTER   "\001"
#define ALRIGHT    "\002"

/****** TYPES ****************************************************************/

typedef struct
{
	LONG cookie;			/* mu 'VSCR' sein */
	LONG product;			/* Analog zur XBRA-Kennung */
	WORD version;			/* Version des VSCR-Protokolls, zunchst 0x100 */
	WORD x, y, w, h;	/* Sichtbarer Ausschnitt des Bildschirms */
} INFOVSCR;

typedef struct
{
	OBJECT 	*Tree;
	MFDB 	Buffer;
	WORD 	x, y, w, h;
} DIALINFO;

typedef struct
{
	USERBLK	ublk;
	UWORD		old_type;
} OBBLK;

typedef WORD (*FORMKEYFUNC) (OBJECT *, WORD, WORD, WORD, WORD, WORD *, UWORD *);

/****** VARIABLES ************************************************************/

extern INFOVSCR *infovscr;

/****** FUNCTIONS ************************************************************/

/* Cookie suchen; bei TRUE wurde Cookie gefunden */
GLOBAL BOOLEAN getcookie    _((LONG cookie, LONG *p_value));

/*****************************************************************************/

/* Parentobjekt ermitteln; bei ROOT wird NIL (-1) zurckgegeben */
GLOBAL WORD    parent       _((OBJECT *tree, WORD obj));

/* ob_spec ermitteln (auch fr USERDEF Objekte) */
GLOBAL LONG    get_obspec   _((OBJECT *tree, WORD obj));

/* ob_spec ndern (auch fr USERDEF Objekte) */
GLOBAL VOID    set_obspec   _((OBJECT *tree, WORD obj, LONG obspec));

/* evnt_multi kstate und kreturn mit NKCC in normalisierten KeyCode wandeln */
GLOBAL UWORD   normkey      _((WORD ks, WORD kr));



/*****************************************************************************/

/* entspricht form_do: Dialog ausfhren */
GLOBAL WORD    dial_do      _((DIALINFO *di, WORD edit_obj));

/* Dialog verschieben; x,y,w,h geben Begrenzungsrechteck an: i.d.R. Desktop ohne Menzeile */
/* dial_move wird auch von dial_do aufgerufen */
GLOBAL VOID    dial_move    _((DIALINFO *di, WORD x, WORD y, WORD w, WORD h));

/* DIALINFO Struktur mit Werten fllen, Hintergrund buffern */
GLOBAL BOOLEAN dial_start   _((OBJECT *tree, DIALINFO *di));

/* Hintergrund restaurieren, Speicher freigeben */
GLOBAL VOID    dial_end     _((DIALINFO *di));

/* Dialog zentrieren; entspricht form_center */
GLOBAL VOID    dial_center  _((OBJECT *tree));

/* Dialog zeichnen; entspricht objc_draw */
GLOBAL VOID    dial_draw    _((DIALINFO *di));



/*****************************************************************************/

/* Nchste Zeile eines mehrzeiligen Eingabefeldes suchen */
GLOBAL WORD    find_next    _((OBJECT *tree, WORD obj));

/* Vorherige Zeile eines mehrzeiligen Eingabefeldes suchen */
GLOBAL WORD    find_prev    _((OBJECT *tree, WORD obj));

GLOBAL WORD    get_idx      _((OBJECT *tree, WORD obj, WORD cpos));

/* ersetzt form_keybd, ruft mit set_Keybd definierte User Tastaturroutine mit gleichen Parametern auf */
/* Parameter siehe form_keybd */
GLOBAL WORD    form_Keybd   _((OBJECT *tree, WORD edit_obj, WORD next_obj, WORD kr, WORD ks, WORD *onext_obj, UWORD *okr));

/* Shortcut im Objektbaum suchen; liefert Objekt oder NIL               */
/* startobj: Ast, dessen gesammte Unterobjekte auf Shortcut untersucht  */
/*           werden sollen. Normalerweise ROOT (Ausnahme: Popups)       */
/* ks, kr  : Rckgabewerte von evnt_multi, die den Shortcut beschreiben */
GLOBAL WORD    shortcut     _((OBJECT *tree, WORD startobj, WORD ks, WORD kr));

/* Eigene Tastaturroutine in form_Keybd einklinken */
/* Wenn die eigene Routine die Taste nicht auswerten konnte, mu sie NIL zurckgeben, */
/* ansonsten den Rckgabewert von form_button oder form_keybd. */
/* Die Routine wird nach dem Beenden des Dialoges wieder ausgeklinkt */
GLOBAL VOID    set_Keybd    _((FORMKEYFUNC fun));

/* Adresse einer vom User eingeklinkten Tastaturroutine ermitteln */
GLOBAL FORMKEYFUNC get_Keybd _((VOID));

/* Internes MyDial objc_edit.                         */
/* Wenn der Dialog im Fenster liegt, mu winhndl die  */
/* Fensterkennung enthalten, sonst NIL. Dadurch wird  */
/* der Cursor ber die Rechteckliste gezeichnet, um   */
/* Redraw-Fehler zu vermeiden.                        */
GLOBAL WORD		obj_edit		_((OBJECT *ob_edtree, WORD ob_edobject, WORD kstate, WORD ob_edchar, WORD *ob_edidx, WORD ob_edkind, WORD mode, WORD *next_obj, WORD winhndl));

/*****************************************************************************/

/* entspricht form_alert, ruft dial_alert mit dial_alert (NULL, string, defbut, 0, ALI_LEFT) auf. */
GLOBAL WORD    do_alert     _((WORD defbut, CONST BYTE *txt));

/* erweiterter form_alert Aufruf: */
/* alicon : eigenes Icon verwenden; bei NULL wird Iconangabe in string verwendet */
/* string : Alertstring, wie in form_alert */
/*          Wenn der Text eines Buttons mit einem Punkt beginnt, wird er als default Button verwendet, */
/*          beginnte er mit einem Doppelpunkt, ist es der Default-Undobutton. */
/*          In diesen beiden Fllen werden die Werte von defbut und undobut ignoriert. */
/* defbut : Default Exitbutton */
/* undobut: Default Undobutton, wird bei Druck auf UNDO Taste selektiert */
/* align  : Positionieren des Alerttextes: ALI_LEFT, ALI_CENTER, ALI_RIGHT, in VDI.H definiert */
/*          Einzelne Zeilen knnen durch voranstellen von ALCENTER oder ALRIGHT anders positioniert werden */
GLOBAL WORD    dial_alert   _((BITBLK *alicon, CONST BYTE *string, WORD defbut, WORD undobut, WORD align));

/* Liefert zu einer Iconnummer den Zeiger auf die dazu gehrige BITBLK Struktur */
GLOBAL BITBLK  *get_icon    _((WORD icon));

/* Zerlegt Alertstring in 8 einzelne Strings, 5 Textzeilen und 3 Buttons */
/* Gibt Iconnummer zurck */
GLOBAL WORD    al_token     _((CONST BYTE *f_alert, BYTE str[8][50], WORD *txtnum, WORD *butnum));



/******************************************************************************/

/* popup_menu: Popupmen anzeigen															*/
/* tree      : Adresse des Objektbaums, in dem sich das Popupmen befindet		*/
/* obj       : index des Popups																*/
/* x, y      : Position der linken oberen Popup-Ecke (bzw.des Objektzentrums, */
/*             wenn center_obj != NIL)														*/
/* center_obj: enthlt den Index des zu zentrierenden Popup-Eintrags.			*/
/* relative  : TRUE: Popup wird an der Mausposition gezeichnet, x und y			*/
/*             sollten dann 0 sein.															*/
/* bmsk      : gibt den Mausbutton an, mit dem das Popup verlassen wird			*/
/*             (1 = links, 2 = rechts, wie beim AES)									*/
/* ok        : TRUE, wenn Hintergund gesichert werden konnte, FALSE sonst		*/
/* Ergebnis  : ausgewhlter Eintrag oder NIL												*/

GLOBAL WORD    popup_menu   _((OBJECT *tree, WORD obj, WORD x, WORD y, WORD center_obj, BOOLEAN relative, WORD bmsk, BOOLEAN *ok));

/* popup_select: Popup-Button in Dialog mit Cycle-Button verwalten */
/* dialtree  : Dialog-Baum																		*/
/* btn       : Index des Objekts, da das Popup aufruft (erlaubte Typen: BoxText, Button, String, Userdef-Boxtext oder Userdef-Button) */
/* poptree   : Adresse des Objektbaums, in dem sich das Popupmen befindet. */
/* obj       : Index des Popups																*/
/*             Die einzelnen Eintrge mssen aus Strings oder tastaturbedienbaren Strings (Userdef 19) bestehen. */
/* docheck   : aktiven Popup-Eintrag (mit Button-Text) mit Haken versehen		*/
/* docycle   : DO_POPUP: Popup anzeigen; DO_CYCLE, DO_POPNEXT: nchsten Ein-	*/
/*             trag darstellen; DO_POPPREV: vorherigen Eintrag darstellen		*/
/* ok        : TRUE, wenn Hintergund gesichert werden konnte, FALSE sonst		*/
/* Ergebnis  : ausgewhlter Eintrag oder NIL												*/

GLOBAL WORD	   popup_select _((OBJECT *dialtree, WORD btn, OBJECT *poptree, WORD obj, BOOLEAN docheck, WORD docycle, BOOLEAN *ok));



/*****************************************************************************/

/* Dialog ffnen, fhrt Growbox aus, und ruft dial_start auf */
/* bei size = NULL ist der Ausgangspunkt der Growbox die Bildschirmmitte */
/* Rckgabewert gibt an, ob Hintergrund gebuffert werden konnte */
GLOBAL BOOLEAN open_dial    _((OBJECT *tree, BOOLEAN grow, RECT *size, DIALINFO *dialinfo));

/* Dialog schlieen, fhrt Shrinkbox aus, und ruft dial_end auf */
/* bei size = NULL ist der Zielpunkt der Shrinkbox die Bildschirmmitte */
GLOBAL BOOLEAN close_dial   _((BOOLEAN shrink, RECT *size, DIALINFO *dialinfo));

/* Komplette Dialogabarbeitung, ruft open_dial, do_dial und close_dial auf */
/* ok gibt an, ob Hintergrund gebuffert werden konnte */
GLOBAL WORD    HndlDial     _((OBJECT *tree, WORD def, BOOLEAN grow_shrink, RECT *size, BOOLEAN *ok));



/*****************************************************************************/

/* trgt USERDEF Objekte ein, is_dialog gibt an, ob es eine Dialogbox oder ein Pulldownmen ist */
GLOBAL VOID    dial_fix     _((OBJECT  *tree, BOOLEAN is_dialog));

/* Initialisieren der mydials. Am Programmstart 1 mal aufrufen */
/* nkc_init und nkc_set werden in dial_init NICHT aufgerufen, mu vom Hauptprogramm gemacht werden */
GLOBAL BOOLEAN dial_init    _((VOID *alc, VOID *fr, WORD *mnum, MFORM **mform, BOOLEAN *gs));

/* Deinitialisieren der mydials. Am Programmende 1 mal aufrufen */
/* nkc_exit wird in dial_exit NICHT aufgerufen, mu vom Hauptprogramm gemacht werden */
GLOBAL BOOLEAN dial_exit    _((VOID));



/*****************************************************************************/

GLOBAL WORD    scrap_clear _((VOID));

#endif /* __MYDIAL__ */
