 (* --------------------------------------------------------------
#Modula Compiler  /4.0 /   fuer Atari ST / 68020 + 68881  V#0325
#--------------------------------------------------------------
 
#File mc8: Assembler (Th. Tempelmann)
 
#15.9.85  Labels auch ohne '!' erlaubt.
#16.9.85  DBcc jetzt auch bei Vorwaertsref. mit D0 bis D7 moeglich.
#16.9.85  Fehlermeldung bei 'ADD.X <ea>,An' eingebaut.
#17.9.85  Fehler bei Adr.-Art 'd8(PC,Rn.X)' behoben.
#18.8.85  MOVEM nun fast fehlerfrei.
#19.8.85  Fehlender,aber erwarteter 2. Operand wird angemeckert
#19.8.85  Befehle DBRA,ILLEGAL und BREAK(wie ILLEGAL) implementiert
#20.09.85 - 25.09.85 :
&- Bei AERR6 wird ID-Name ausgegeben ( z.Zt. auf Screen ).
&- MOVEM fehlerfrei, sowie BTST #d3,<ea>
&- Bei $D+ wird die Default-Size fuer Bcc auf Long gesetzt (sonst:Short).
&- Neue Vorwaertsref.-Verkettung bei Labels -> ERROR 208 tritt nie mehr
)auf !
&- Vorw.-ref. auf Labels nun auch mit d16(PC) und d8(PC,Rn.X) moeglich.
&- die Adressierungsarten PC-Relativ und SSP ausgebaut.
&- die Adressierungsart d16 (Absolut,nur 16 Bit) wird nicht mehr
)verwandt ( LEA $400,A0 erzeugt 3 Worte ! ).
&- Typenpruefung bei Zugriffen auf Symbole mit Fehlermeldung ( ERROR
)Nr. 213 ).
&- Neben Konstanten koennen auch RECORDs sowie Elemente aus Aufz.-Typen
)verwandt werden.
&- Am Ende eines Assembler-Teils kann nun direkt ein Label stehen,
)also z.B. ' EndLabel   END '.
&- Bei 'Bcc' auf ein schon bekanntes Label wird nicht mehr standard-
)maessig 'Short' als Size verwandt, sondern immer die optimale
)Size genommen, wenn der Branch-Befehl keine explizite Size
)Angabe enthaelt.
'- Bei Mnemonics, die nach dem TEWI 68000-Buch keiner Size-Angabe
)beduerfen, wird bei einer Sizeangabe ein Fehler gemeldet.
)
#29.09.85  Automatisches SYNC ausgebaut ( ausser am Ende eines
.Assembler-Bereichs ), jedoch Abfrage darauf ueberall, bis auf
.bei: DC.B , ASC , ACZ .
#29.09.85  ACI ausgebaut.
#30.09.85  Fuer A7 ist auch SP zugelassen.
#30.09.85  Expressionauswertung (auch Label1-Label2).
#30.09.85  Reglist nun auch mit 'Rn-Rm' moeglich.
#30.09.85  Records jetzt richtig ansprechbar.
#01.10.85  Jetzt hoffentlich ueberall Abfrage, ob Size da oder nicht.
#01.10.85  MOVEC VBR implementiert und Fehlermeldung Nr. 215 bei RTE.
.Dazu wurde aus dem unbenutzten Symbol 'SSP' 'VBR' gemacht.
#07.10.85  68010-Befehle RTD und MOVE from CCR eingefuehrt.
#08.10.85  Sizeangaben-Pruefung erfolgt nun nach Motorola's 68000
.16-Bit User's Manual. Ausnahmen:
.Bei Branch: auch '.S' fuer '.B' und '.L' fuer '.W' .
.ORI,EORI,ANDI,MOVE mit SR oder CCR: hier keine Size erlaubt.
#08.10.85  Fehler bei lok. Proc. behoben.
#08.10.85  Unterscheidung in Long- und Word/Byte-Konstanten eingefuehrt.
.Nun sind L-Const. bei 'd32', LEA,JMP,JSR,PEA erlaubt.
.Ausserdem wird am Ende von 'GetExpr' nochmal die Groesse
.des Datums in der Var. 'Data' ueberprueft.
#08.10.85  Data-Size-Abpruefung bei LINK und STOP/RTD verbessert.
#08.10.85  DS - Pseudo-Op implementiert.
#10.10.85  Sizeangaben-Pruefung nochmal veraendert (jetzt wie Motorola's
.680XX - User's Manual:
0Bei MOVE CCR oder MOVE SR ist auch '.W' erlaubt.
0Bei ANDI to SR, EORI to SR, ORI to SR ist '.W' erlaubt.
0Bei ANDI to CCR, EORI to CCR, ORI to CCR ist '.B' erlaubt.
#10.10.85  Range-Test ueberarbeitet und ERROR 216 eingefuehrt.
#11.10.85  Bei Records auch POINTER TO RECORD oder ARRAY OF RECORD moeglich.
#12.10.85  LEA / PEA mit allen Adr. erlaubt.
#13.10.85  Error 211 bei 'Bcc.S' mit Offset = Null wieder eingebaut.
#15.10.85  als Expr auch Typen ( RECORD, POINTER und ARRAY ) erlaubt.
#16.10.85  Fehler bei TRAP - Befehlsuebersetzung behoben
#16.10.85  'Testtype' nun in 'MN's mit direkter Angabe, ob Source
.oder Destination geprueft wird.
#17.10.85  Fehler vom 16.10.85 bei LSL, ROR usw. behoben.
#29.01.86  Labels auf ungeraden Adr. zugelassen;
-Fehler bei vorw. Ref. auf Label, das direkt hinter END steht,
-behoben;
-Fehlerhafte Uebersetzung von LSR <ea> usw. behoben.
#22.02.86  Neuordnung der Texte (jm)
#21.03.86  LINK - Inst. nun richtig ( vorher wurde immer LINK ..,#0 erzeugt)
#30.07.86  V3.3a: 68020-Mnemonics impl., zudem STR-Pseudo-Op, um Strings mit
-Lngenzhler anzulegen. Neue Option: 'X+' fr 68020-Befehle;
-Test_Ind_An: auch auf SP abgefr., somit nun auch (SP) als Adr.-Art
-zugelassen; BRA mit LONG-Offset sind nicht erzeugbar, da da ja nur
-in Prozeduren ginge, und die knnen sowieso nicht grer als 64KB
-werden. ApndD0_W/L legen Code nun direkt ab. Dadurch sind D2 u. D3
-jetzt whrend der Code-Erzeugung frei.; ASC mit ',' trennbar;
-DIVSL u. DIVUL nicht bersetzt, da Codierung unklar; fr parameter-
-lose TRAPcc mu als Parameter '()' angegeben werden !; MOVES noch
-nicht impl. !; Nach Labeldecl. ist ein direkt angeschlossenes ':'
-erlaubt;
#08.08.86  STR-Pseudo-Op: Alle folg. Zeichen, auch die mit Komma angehngten,
-werden als ein String bewertet; GENSTR um Auswertung von Chars
-und Charconsts erweitert, Auswertung von Strconsts geht noch nicht
#23.11.86  Aenderungen aus V3.3b uebernommen (BYTE->BITE, alle IDs>AsmFirst
-um 2 erhoeht, kein Fehler bei RTE bei Atari, ConFact statt
-ConstEx.
-Achtung: Es ist nicht sicher, ob CAAR und CACR richtig gehen !
6Es sollte mal gepr}ft werden !
#02.12.86  Kein Fehler mehr bei DC.L a,b,c,... (pInstr bei PseudoOp angepasst)
#17.12.86  (ch) Einbau der 68881 - Befehle
#11. 1.87  (jm) Aenderung bei NumDat; Kommentare bei '%%%%'
#15. 1.87  (jm) bei MOVEQ wieder Argumente -128 <= x <= 255 zugelassen
#16. 1.87  (jm) TstScale, GADR11 aus Conditional-Clause gezogen
2(Fehler im Atari-Mode)
$2. 3.87  GetEA: SR->CCR
#27.02.87  Redefinition v. lokalen Labels mglich; Flag f. Labels, ob auf
-sie referiert wird; X-Option wird pro Mnemonic gesamt verwendet
#03.03.87  Ausklammerung aller 68020/881-Routinen f. Atari
#25.03.87  (jm) 68020-Korrekturen von CH (unbek. Datum) wieder eingebaut
#12.04.87  AsmWarning impl.; Warning bei ill. Zugriffen auf A3 bei Gepard
#20.04.87  Conditionals fr 68020/881-bersetzung (Asm20)
#28.04.87  Fehler in GetEA behoben (Asm-Symbols wurden mit .B geprft)
#08.05.87  '* )' in AsmError und AsmWarning entfernt
#22.05.87  Wegen Fehler im Boot-ROM erfolgt bei MOVE from CCR eine
-Fehlermeldung.
#18.07.87  EAto0_5: d16(An) wird zu (An) optimiert, wenn d16 eine
-Nullkonst. ist.
#06.02.88  EAto0_5: d16(An) wird nur zu (An) optimiert, wenn d16 keine
-ausgeschriebene Null/Const
#01.01.89  (TT 18.08.88)  Neben pTxtLin wird auch TxtLine gerettet
#24.07.89  Bisher erkannte CalcExpr einige rel.-Adr-berlaufe nicht:
0z.B. MOVE +/-x(PC,D0.W) oder MOVE +/-y(PC), wenn
0256>x>127, 65536>y>32767.
#10.12.89  nderungen fr separierten Compiler:
-BothSbl: as45, as46, as96 heissen SymAnd, SymOr, SymNot 
-LocalSearch statt MySrc
#13.12.89  Nachtrag aus TTs Version vom 31.08.89
0Symbol-Table: 2. 'DBRA' durch '@@DB' ersetzt, damit RTR geht.
#31.12.89  Den ConFact-Aufruf fr die Parameter-Konsts durch 'ConstExpr'
-ersetzt
#29.01.90  Bei '-' Zeichen wird gleich ConstExpr aufgerufen, soda z.B.
-nicht mehr "-enumValue" geht (dann mu "0-..." progr. werden).
#11.02.90  JMP/JSR knnen auch auf Vars erfolgen
#11.03.90  BTST Dn,#x wird zugelassen
#16.06.90  MOVE from CCR zugelassen
#18.08.90  Anpassung des Offsets zum lok. Record-Baum
#10.10.90  Fr 68881/2 wird nun auch "#" bei k-Faktor zugelassen (allerdings
-auch bei Bitfields)
#11.11.90  Symbol FP steht fr das Frame-Ptr-Reg ("MM2Comp.VarReg")
#05.12.90  MOVEC SFC/DFC nun auch benutzbar
#--------------------------------------------------------------------------
 *)
 
 (* Kommentierung:
#Bei Bezug auf MNEMONICs wird ihnen ein '%' direkt vorangestellt,
#z.B. '%RTE'. (TT)
#Procedurenamen mit '@' sind lokale Hilfsroutinen,die nur von den
#direkt folgenden Procedures benutzt werden sollen !
 *)
 
 TYPE BITE = WORD;
 
 CONST   NoOperands = 0;
(NoOperandsWZE = 1;
(DefltSiz   = 2; (* Nie aendern, weil dieser Wert sowieso festliegt *)
(LabelID    = $801D;
)
)AS1      =     14;
)AS2      =     26;
)AS3      =     2;
)AS4      =     3;
)AS5      =     5;  (* / *)
)AS6      =     4;
)AS7      =     23;
)AS8      =     24;
)AS9      =     47;
)(* !! alle Symbols rel. zu FirstAsmSbl bestimmen !! *)
)AS10     =     FirstAsmSbl; (* 93 *)
)AS17     =     100;
)AS18     =     101;
)AS25     =     108; (* D7 *)
)AS26     =     109; (* SP *)
)AS_FP    =     110; (* FP *)
)AS28     =     111;
)AS29     =     112;
)AS30     =     113;
)AS31     =     114;
)AS32     =     115;
)AS35     =     116;
)AS36     =     117;
)AS37     =     9;
)AS38     =     10;
)AS39     =     30;
)
)AS40     =     119; (* %ABCD *)
)AS_MneF  =     AS40;
)AS_MneL  =     240; (* %RTD  *)
)
)AS157    =     241; (* %DC   *)
)AS158    =     242; (* %DS   *)
)AS159    =     243; (* %@11  *)
)AS160    =     244; (* %EQU  *)
)AS161    =     245; (* %ACZ  *)
)AS162    =     246; (* %SYNC *)
)AS163    =     247; (* %ACS  *)
)AS164    =     248; (* %ACI  *)
)AS165    =     249; (* %BOMB *)
)
)(* neue Konstante seit 3.3a (68020) *)
)
)AS_Astrx =     4;   (* "*" *)
)AS_eKlA  =     15;
)AS_eKlZ  =     27;
)AS_gKlA  =     16;
)AS_gKlZ  =     28;
)AS_dPnkt =     25;
)
)AS_STR   =     250;
)AS_SFC   =     251;
)AS_DFC   =     252;
)AS_CACR  =     253;
)
)(* 254 und 255 mssen frei bleiben !!! (STRCONST und NUMCONST) *)
)
)AS_CAAR  =     257;
)AS_MSP   =     258;
)AS_ISP   =     259;
)AS_M20F  =     260;
)AS_M20L  =     AS_M20F + 36 (* 41 *) + 171 (* Anzahl der 68881-Mnes *);
)AS_FP0   =     AS_M20L + 1; (* 68881 - Register *)
)AS_FP7   =     AS_FP0 + 7;
)AS_FPCR  =     AS_FP7 + 1;
)AS_FPSR  =     AS_FPCR + 1;
)AS_FPIAR =     AS_FPSR + 1;
)
 VAR
 
 MneSecCode : WORD;
 MneCode    : WORD;
 MneVec     : ADDRESS;
 DefltBcc   : BITE;
 SizeOfData : BITE;
 Args       : BITE;
 BreakAgain : BITE;
 (*$ ? RunGep:
 AsmOptions : LONG;
 pInstr     : LONG; *)
 (*$ ? RunST:
 AsmOptions : LONGWORD;
 pInstr     : LONGWORD; *)
 
 
 ModeSource:BITE;
 Mode2Source:BITE;
 RegSource:BITE;
 Reg2Source:BITE;
 DataTypeSource:WORD;
 DataTypeOdSource:WORD;
 IndRegSource:BITE;
 IndTypeSource:BITE;
 IndSizeSource:BITE;
 RegListSource:WORD;
 DataSource:ADDRESS;
 Data2Source:ADDRESS;
 IDPtrSource:ADDRESS;
 M20FlgSource:BITE;
 DataOdSource: (*$ ? RunGep: LONG *) (*$ ? RunST: LONGWORD *) ;
 IndScaleSource:BITE;
 FormatSource:BITE;
 BitWidthSource:BITE;
 BitOffsSource:BITE;
 
 ModeDest:BITE;
 Mode2Dest:BITE;
 RegDest:BITE;
 Reg2Dest:BITE;
 DataTypeDest:WORD;
 DataTypeOdDest:WORD;
 IndRegDest:BITE;
 IndTypeDest:BITE;
 IndSizeDest:BITE;
 RegListDest:WORD;
 DataDest:ADDRESS;
 Data2Dest:ADDRESS;
 IDPtrDest:ADDRESS;
 M20FlgDest:BITE;
 DataOdDest: (*$ ? RunGep: LONG *) (*$ ? RunST: LONGWORD *) ;
 IndScaleDest:BITE;
 FormatDest:BITE;
 BitWidthDest:BITE;
 BitOffsDest:BITE;
 
 ModeThird:BITE;
 Mode2Third:BITE;
 RegThird:BITE;
 Reg2Third:BITE;
 DataTypeThird:WORD;
 DataTypeOdThird:WORD;
 IndRegThird:BITE;
 IndTypeThird:BITE;
 IndSizeThird:BITE;
 RegListThird:WORD;
 DataThird:ADDRESS;
 Data2Third:ADDRESS;
 IDPtrThird:ADDRESS;
 M20FlgThird:BITE;
 DataOdThird: (*$ ? RunGep: LONG *) (*$ ? RunST: LONGWORD *) ;
 IndScaleThird:BITE;
 FormatThird:BITE;
 BitWidthThird:BITE;
 BitOffsThird:BITE;
 
 
 Mode:BITE;     (* Beschreibt Adr.-Art:
2Wert der Bits 0-5:
40  : keine Adressierung
41  : Dn
42  : An
43  : (An)
44  : (An)+
45  : -(An)
46  : d16(An)
47  : d8(An,Xn) / auch Erw. Adr.Arten bei 68020
48  : unbenutzt (war mal d16)
49  : d32
410 : d16(PC)
411 : d8(PC,Xn) / auch Erw. Adr.Arten bei 68020 mit PC
412 : #data
413 : SR
414 : USP
415 : CCR
416 : VBR
417 : (Dn)
418 : Xn - reglist
419 : SFC
420 : DFC
421 : CACR
422 : CAAR
423 : MSP
424 : ISP
4(* 68881 - Modi *)
425 : FPn
426 : FPn - reglist
427 : FPCR(reg=2), FPSR(reg=1), FPIAR(req=0)
428 : FStatus - reglist
429 : <ea>{Di}  (ea-Type in Mode2, i in Format)
430 : <ea>{#i}  (ea-Type in Mode2, i in Format)
4
2Bit 7 gesetzt: Doppelregister
2Bit 6 gesetzt: BitField folgt EA *)
 Mode2:BITE;    (* Adr.-Art f. zweites Register bei Doppelregs, sonst undef. *)
 Reg:BITE;      (* Registernummer *)
 Reg2:BITE;     (* evtl. zweite Registernummer bei 68020 (Doppelregister) *)
 DataType:WORD; (* bit 15 : 1=Wert noch unbekannt,
2bit 14 : ID = TYPE (z.B. TYPE einer RECORD-Def.),
2bit0-12: Type des Operanden:
40  : Short CONST (Byte/Word) : Konstante
41  : External Var.           : Konstante
42  : Num. Konstante          : Konstante
43  : einzelner Character     : Konstante
44  : Aufzhlungstyp          : Konstante
45  : Record-Feld Variable    : Konstante
46  : glob. Var., Table       : abs. Pointer
47  : glob. Procedure         : abs. Pointer
48  : lok. Label              : rel. Pointer
49  : lok. Var.               : Konstante
410 : lok. Procedure          : rel. Pointer
411 : Long CONST              : Konstante
412 : Real CONST              : Konstante *)
 DataTypeOd:WORD; (* wie oben, fr od *)
 IndReg:BITE;   (* Indexregister Nummer *)
 IndType:BITE;  (* Indexregister Type ($FF=Dn/0=An) *)
 IndSize:BITE;  (* Indexregister Size (.W/.L) *)
 RegList:WORD;  (* fuer MOVEM *)
 Data: (*$ ? RunGep: LONG *) (*$ ? RunST: LONGWORD *) ;
"(* evtl. Konstante (z.B. d32 oder bd) *)
 Data2: (*$ ? RunGep: LONG *) (*$ ? RunST: LONGWORD *) ;
"(* weitere 32 fr die Abspeicherrung einer Real Const *)
 IDPtr:ADDRESS; (* bei glob. ID-Referenzen: Zeiger auf ID *)
 M20Flg:BITE;   (* Flags f. erw. Adr.-Art d. 68020 (s. CONST unten) *)
 DataOd: (*$ ? RunGep: LONG *) (*$ ? RunST: LONGWORD *) ;   (* od bei 68020 *)
 IndScale:BITE; (* Scaling-Faktor bei 68020 *)
 Format:BITE;   (* Format der Packedconversion des 68881 *)
 BitWidth:BITE; (* Breite bei Bitfields (bit 5 zeigt Register-Indizierung an) *)
 BitOffs:BITE;  (* Offset bei Bitfields (bit 5 zeigt Register-Indizierung an) *)
 GetLastSbl: BOOLEAN;
 
 
 CONST FlgeKlA = 0;
&FlgeKlZ = 1;
&FlgXn   = 2;
&FlgAnPC = 3;
&FlgOd   = 4;
&FlgBd   = 5;
&FlgPreIx= 6;
&FlgIs20 = 7; (* markiert Erw. Adr-Art der 68020 '([bd,An/PC],Xn],od)' *)
 
 
 PROCEDURE ASMSBL;
 BEGIN
 ASSEMBLER
)ACZ     'A0'
)ACZ     'A1'
)ACZ     'A2'
)ACZ     'A3'
)ACZ     'A4'
)ACZ     'A5'
)ACZ     'A6'
)ACZ     'A7'
)ACZ     'D0'
)ACZ     'D1'
)ACZ     'D2'
)ACZ     'D3'
)ACZ     'D4'
)ACZ     'D5'
)ACZ     'D6'
)ACZ     'D7'
)ACZ     'SP'
)ACZ     'FP'
)ACZ     '@2'
)ACZ     'SR'
)ACZ     'USP'
)ACZ     'CCR'
)ACZ     'VBR'
)ACZ     'PC'
)ACZ     '@3'
)ACZ     '@4'
)ACZ     'ABCD'
)ACZ     'SBCD'
)ACZ     'ADDX'
)ACZ     'SUBX'
)ACZ     'ADD'
)ACZ     '@5'
)ACZ     '@6'
)ACZ     'SUB'
)ACZ     'ADDA'
)ACZ     'CMPA'
)ACZ     'SUBA'
)ACZ     'MOVEA'
)ACZ     'ADDI'
)ACZ     'CMPI'
)ACZ     'SUBI'
)ACZ     'ANDI'
)ACZ     'EORI'
)ACZ     'ORI'
)ACZ     'ADDQ'
)ACZ     'SUBQ'
)ACZ     'ASL'
)ACZ     'ASR'
)ACZ     'LSL'
)ACZ     'LSR'
)ACZ     'ROL'
)ACZ     'ROR'
)ACZ     'ROXL'
)ACZ     'ROXR'
)ACZ     'BCC'
)ACZ     'BCS'
)ACZ     'BEQ'
)ACZ     'BGE'
)ACZ     'BGT'
)ACZ     'BHI'
)ACZ     'BLE'
)ACZ     'BLS'
)ACZ     'BLT'
)ACZ     'BMI'
)ACZ     'BNE'
)ACZ     'BPL'
)ACZ     'BVC'
)ACZ     'BVS'
)ACZ     'BRA'
)ACZ     'BSR'
)ACZ     'BCHG'
)ACZ     'BCLR'
)ACZ     'BSET'
)ACZ     'BTST'
)ACZ     'CHK'
)ACZ     'MULS'
)ACZ     'MULU'
)ACZ     'DIVS'
)ACZ     'DIVU'
)ACZ     'CLR'
)ACZ     'NEG'
)ACZ     'NEGX'
)ACZ     '@7'
)ACZ     'TST'
)ACZ     'CMP'
)ACZ     'CMPM'
)ACZ     'DBCC'
)ACZ     'DBCS'
)ACZ     'DBEQ'
)ACZ     'DBF'
)ACZ     'DBRA'
)ACZ     'DBGE'
)ACZ     'DBGT'
)ACZ     'DBHI'
)ACZ     'DBLE'
)ACZ     'DBLS'
)ACZ     'DBLT'
)ACZ     'DBMI'
)ACZ     'DBNE'
)ACZ     'DBPL'
)ACZ     'DBT'
)ACZ     'DBVC'
)ACZ     'DBVS'
)ACZ     'EOR'
)ACZ     'EXG'
)ACZ     'EXT'
)ACZ     'JMP'
)ACZ     'JSR'
)ACZ     'PEA'
)ACZ     'LEA'
)ACZ     'LINK'
)ACZ     'MOVE'
)ACZ     'MOVEM'
)ACZ     'MOVEP'
)ACZ     'MOVEQ'
)ACZ     'NBCD'
)ACZ     'SCC'
)ACZ     'SCS'
)ACZ     'SEQ'
)ACZ     'SF'
)ACZ     'SGE'
)ACZ     'SGT'
)ACZ     'SHI'
)ACZ     'SLE'
)ACZ     'SLS'
)ACZ     'SLT'
)ACZ     'SMI'
)ACZ     'SNE'
)ACZ     'SPL'
)ACZ     'ST'
)ACZ     'SVC'
)ACZ     'SVS'
)ACZ     'TAS'
)ACZ     'NOP'
)ACZ     'RTE'
)ACZ     'RTS'
)ACZ     'TRAPV'
)ACZ     'RESET'
)ACZ     'STOP'
)ACZ     'SWAP'
)ACZ     'TRAP'
)ACZ     'UNLK'
)ACZ     'RTR'
)ACZ     '@@DB'
)ACZ     'ILLEGAL'
)ACZ     'BREAK'
)ACZ     'MOVEC'
)ACZ     'RTD'
)ACZ     'DC'
)ACZ     'DS'
)ACZ     '@11'
)ACZ     'EQU'
)ACZ     'ACZ'
)ACZ     'SYNC'
)ACZ     'ASC'
)ACZ     'ACI'
)ACZ     'BOMB'
)
); neue Symbole seit 30.7.86 (3.3a) f. 68020-Assembler
)ACZ     'STR'
 (*$ ? Asm20:
)ACZ     'SFC'
)ACZ     'DFC'
)ACZ     'CACR'
)ACZ     '@01'          (* NUMCONST *)
)ACZ     '@02'          (* STRCONST *)
)ACZ     '@03'          (*  *)
)ACZ     'CAAR'
)ACZ     'MSP'
)ACZ     'ISP'
)ACZ     'BFCHG'
)ACZ     'BFCLR'
)ACZ     'BFEXTS'
)ACZ     'BFEXTU'
)ACZ     'BFFFO'
)ACZ     'BFINS'
)ACZ     'BFSET'
)ACZ     'BFTST'
)ACZ     'BKPT'
)ACZ     'CALLM'
)ACZ     'CAS'
)ACZ     'CAS2'
)ACZ     'CHK2'
)ACZ     'CMP2'
)ACZ     'DIVSL'
)ACZ     'DIVUL'
)ACZ     'EXTB'
)ACZ     'MOVES'
)ACZ     'PACK'
)ACZ     'RTM'
)ACZ     'TRAPCC'
)ACZ     'TRAPCS'
)ACZ     'TRAPEQ'
)ACZ     'TRAPF'
)ACZ     'TRAPGE'
)ACZ     'TRAPGT'
)ACZ     'TRAPHI'
)ACZ     'TRAPLE'
)ACZ     'TRAPLS'
)ACZ     'TRAPLT'
)ACZ     'TRAPMI'
)ACZ     'TRAPNE'
)ACZ     'TRAPPL'
)ACZ     'TRAPT'
)ACZ     'TRAPVC'
)ACZ     'TRAPVS'
)ACZ     'UNPK'
)
); Mnemonics 68881
)
)ACZ     'FMOVE'               ; Umspeichern
)ACZ     'FMOVECR'
)ACZ     'FMOVEM'
)ACZ     'FRESTORE'
)ACZ     'FSAVE'
)ACZ     'FNOP'
)ACZ     'FTST'
)ACZ     'FBEQ'                ; Controls
)ACZ     'FBF'
)ACZ     'FBGE'
)ACZ     'FBGL'
)ACZ     'FBGLE'
)ACZ     'FBGT'
)ACZ     'FBLE'
)ACZ     'FBLT'
)ACZ     'FBNE'
)ACZ     'FBNGE'
)ACZ     'FBNGL'
)ACZ     'FBNGLE'
)ACZ     'FBNGT'
)ACZ     'FBNLE'
)ACZ     'FBNLT'
)ACZ     'FBSEQ'
)ACZ     'FBSF'
)ACZ     'FBSNE'
)ACZ     'FBST'
)ACZ     'FBOGE'
)ACZ     'FBOGL'
)ACZ     'FBOGT'
)ACZ     'FBOLE'
)ACZ     'FBOLT'
)ACZ     'FBOR'
)ACZ     'FBT'
)ACZ     'FBUGE'
)ACZ     'FBUEQ'
)ACZ     'FBUN'
)ACZ     'FBUGT'
)ACZ     'FBULE'
)ACZ     'FBULT'
)ACZ     'FDBEQ'
)ACZ     'FDBF'
)ACZ     'FDBGE'
)ACZ     'FDBGL'
)ACZ     'FDBGLE'
)ACZ     'FDBGT'
)ACZ     'FDBLE'
)ACZ     'FDBLT'
)ACZ     'FDBNE'
)ACZ     'FDBNGE'
)ACZ     'FDBNGL'
)ACZ     'FDBNGLE'
)ACZ     'FDBNGT'
)ACZ     'FDBNLE'
)ACZ     'FDBNLT'
)ACZ     'FDBSEQ'
)ACZ     'FDBSF'
)ACZ     'FDBSNE'
)ACZ     'FDBST'
)ACZ     'FDBOGE'
)ACZ     'FDBOGL'
)ACZ     'FDBOGT'
)ACZ     'FDBOLE'
)ACZ     'FDBOLT'
)ACZ     'FDBOR'
)ACZ     'FDBT'
)ACZ     'FDBUGE'
)ACZ     'FDBUEQ'
)ACZ     'FDBUN'
)ACZ     'FDBUGT'
)ACZ     'FDBULE'
)ACZ     'FDBULT'
)ACZ     'FSEQ'
)ACZ     'FSF'
)ACZ     'FSGE'
)ACZ     'FSGL'
)ACZ     'FSGLE'
)ACZ     'FSGT'
)ACZ     'FSLE'
)ACZ     'FSLT'
)ACZ     'FSNE'
)ACZ     'FSNGE'
)ACZ     'FSNGL'
)ACZ     'FSNGLE'
)ACZ     'FSNGT'
)ACZ     'FSNLE'
)ACZ     'FSNLT'
)ACZ     'FSSEQ'
)ACZ     'FSSF'
)ACZ     'FSSNE'
)ACZ     'FSST'
)ACZ     'FSOGE'
)ACZ     'FSOGL'
)ACZ     'FSOGT'
)ACZ     'FSOLE'
)ACZ     'FSOLT'
)ACZ     'FSOR'
)ACZ     'FST'
)ACZ     'FSUGE'
)ACZ     'FSUEQ'
)ACZ     'FSUN'
)ACZ     'FSUGT'
)ACZ     'FSULE'
)ACZ     'FSULT'
)ACZ     'FTRAPEQ'
)ACZ     'FTRAPF'
)ACZ     'FTRAPGE'
)ACZ     'FTRAPGL'
)ACZ     'FTRAPGLE'
)ACZ     'FTRAPGT'
)ACZ     'FTRAPLE'
)ACZ     'FTRAPLT'
)ACZ     'FTRAPNE'
)ACZ     'FTRAPNGE'
)ACZ     'FTRAPNGL'
)ACZ     'FTRAPNGLE'
)ACZ     'FTRAPNGT'
)ACZ     'FTRAPNLE'
)ACZ     'FTRAPNLT'
)ACZ     'FTRAPSEQ'
)ACZ     'FTRAPSF'
)ACZ     'FTRAPSNE'
)ACZ     'FTRAPST'
)ACZ     'FTRAPOGE'
)ACZ     'FTRAPOGL'
)ACZ     'FTRAPOGT'
)ACZ     'FTRAPOLE'
)ACZ     'FTRAPOLT'
)ACZ     'FTRAPOR'
)ACZ     'FTRAPT'
)ACZ     'FTRAPUGE'
)ACZ     'FTRAPUEQ'
)ACZ     'FTRAPUN'
)ACZ     'FTRAPUGT'
)ACZ     'FTRAPULE'
)ACZ     'FTRAPULT'
)ACZ     'FADD'                ; Dyadic Operations
)ACZ     'FCMP'
)ACZ     'FDIV'
)ACZ     'FMOD'
)ACZ     'FMUL'
)ACZ     'FREM'
)ACZ     'FSCALE'
)ACZ     'FSGLDIV'
)ACZ     'FSGLMUL'
)ACZ     'FSUB'
)ACZ     'FABS'                ; Monidic Operations
)ACZ     'FACOS'
)ACZ     'FASIN'
)ACZ     'FATAN'
)ACZ     'FATANH'
)ACZ     'FCOS'
)ACZ     'FCOSH'
)ACZ     'FETOX'
)ACZ     'FETOXM1'
)ACZ     'FGETEXP'
)ACZ     'FGETMAN'
)ACZ     'FINT'
)ACZ     'FINTRZ'
)ACZ     'FLOGN'
)ACZ     'FLOGNP1'
)ACZ     'FLOG10'
)ACZ     'FLOG2'
)ACZ     'FNEG'
)ACZ     'FSIN'
)ACZ     'FSINH'
)ACZ     'FSQRT'
)ACZ     'FTAN'
)ACZ     'FTANH'
)ACZ     'FTENTOX'
)ACZ     'FTWOTOX'
)ACZ     'FSINCOS'             ; Dual Monadic Operation
)
)ACZ     'FP0'                 ; 68881 Register
)ACZ     'FP1'
)ACZ     'FP2'
)ACZ     'FP3'
)ACZ     'FP4'
)ACZ     'FP5'
)ACZ     'FP6'
)ACZ     'FP7'
)ACZ     'FPCR'
)ACZ     'FPSR'
)ACZ     'FPIAR'
)
)*)
)
)DC.B    0
)SYNC
 END
 END ASMSBL;
 
 
 PROCEDURE BOTHSBL;
 BEGIN
 ASSEMBLER
)DC.W    SymAnd
)ACZ     'AND'
)SYNC
)DC.W    SymNot
)ACZ     'NOT'
)SYNC
)DC.W    SymOr
)ACZ     'OR'
)DC.B    0
)SYNC
)DC.W    0
 END
 END BOTHSBL;
 
 
 (*
"901: Wrong addressing mode
"992: Illegal operand size
"903: Branch too long
"904: Illegal symbol
"905: Label expected
"906: Unknown label
"907: Number expected
"909: Odd address
"910: Modula keyword not allowed here
"911: Short branch not allowed here
"912: Label declared twice
"913: Logical addressing error
"914: Illegal Expression
"915: Warning: use only JMP to BOOT-ROM RTE-emulation !
"916: Operand out of Range
"917: 68020 mnemonic not allowed
"918: String too long
"919: unknown instruction
"920: Unsinnige Adr.-Art '([]...)'
"921: 68020 Adr-nicht erlaubt
"922: Use "MOVE fom SR" instruction instead
"950: (Warning:) Illegal addressing mode
 *)
 
 CONST asmIllAM = 950;
 
 PROCEDURE AERR1;
 BEGIN
 ASSEMBLER
"MOVE.W  #901,D5
"JMP     SyntaxErr
 END
 END AERR1;
 
 
 PROCEDURE AERR2;
 BEGIN
 ASSEMBLER
"MOVE.W  #902,D5
"JMP     SyntaxErr
 END
 END AERR2;
 
 
 PROCEDURE AERR3;
 BEGIN
 ASSEMBLER
"MOVE.W  #903,D5
"JMP     SyntaxErr
 END
 END AERR3;
 
 
 PROCEDURE AERR4;
 BEGIN
 ASSEMBLER
"MOVE.W  #904,D5
"JMP     SyntaxErr
 END
 END AERR4;
 
 
 PROCEDURE AERR5;
 BEGIN
 ASSEMBLER
"MOVE.W  #905,D5
"JMP     SyntaxErr
 END
 END AERR5;
 
 
 PROCEDURE AERR6;
 BEGIN
 ASSEMBLER
"JSR     IDfromTree
"MOVE.W  #906,D5
"JMP     SyntaxErr
 END
 END AERR6;
 
 
 PROCEDURE AERR7;
 BEGIN
 ASSEMBLER
"MOVE.W  #907,D5
"JMP     SyntaxErr
 END
 END AERR7;
 
 
 (* AERR8 gibts nicht mehr ! *)
 
 
 PROCEDURE AERR9;
 BEGIN
 ASSEMBLER
"MOVE.W  #909,D5
"JMP     SyntaxErr
 END
 END AERR9;
 
 
 PROCEDURE AERR10;
 BEGIN
 ASSEMBLER
#MOVE.W  #910,D5
#JMP     SyntaxErr
 END
 END AERR10;
 
 
 PROCEDURE AERR11;
 BEGIN
 ASSEMBLER
"MOVE.W  #911,D5
"JMP     SyntaxErr
 END
 END AERR11;
 
 
 PROCEDURE AERR12;
 BEGIN
 ASSEMBLER
#MOVE.W  #912,D5
#JMP     SyntaxErr
 END
 END AERR12;
 
 
 PROCEDURE AERR13;
 BEGIN
 ASSEMBLER
"MOVE.W  #913,D5       ; 'Logical Addressing Error'
"JMP     SyntaxErr
 END
 END AERR13;
 
 
 PROCEDURE AERR14;
 BEGIN
 ASSEMBLER
"MOVE.W  #914,D5       ; 'Illegal Expression'
"JMP     SyntaxErr
 END
 END AERR14;
 
 PROCEDURE AERR15;
 BEGIN
 ASSEMBLER
"MOVE.W  #915,D5       ;'Warning: Use 'JMP $40C' '
"JMP     SyntaxErr
 END
 END AERR15;
 
 PROCEDURE AERR16;
 BEGIN
 ASSEMBLER
"MOVE.W  #916,D5       ;'Operand out of Size' '
"JMP     SyntaxErr
 END
 END AERR16;
 
 PROCEDURE AERR17;
 BEGIN
 ASSEMBLER
"MOVE.W  #917,D5       ; '68020 mnemonic not allowed'
"JMP     SyntaxErr
 END
 END AERR17;
 
 PROCEDURE AERR18;
 BEGIN
 ASSEMBLER
"MOVE.W  #918,D5       ; 'String too long'
"JMP     SyntaxErr
 END
 END AERR18;
 
 PROCEDURE AERR19;
 BEGIN
 ASSEMBLER
"MOVE.W  #919,D5       ; 'unknown instruction
"JMP     SyntaxErr
 END
 END AERR19;
 
 PROCEDURE AERR20;
 BEGIN
 ASSEMBLER
"MOVE.W  #920,D5       ; Unsinnige Adr.-Art '([]...)'
"JMP     SyntaxErr
 END
 END AERR20;
 
 PROCEDURE AERR21;
 BEGIN
 ASSEMBLER
"MOVE.W  #921,D5       ; 68020 Adr-nicht erlaubt
"JMP     SyntaxErr
 END
 END AERR21;
 
 PROCEDURE AERR22;
 BEGIN
 ASSEMBLER
"MOVE.W  #922,D5       ; Use "MOVE fom SR" instruction instead
"JMP     SyntaxErr
 END
 END AERR22;
 
 PROCEDURE AERR23;
 BEGIN
 ASSEMBLER
"MOVE.W  #923,D5       ; Function returns D0 - use '/'
"JMP     SyntaxErr
 END
 END AERR23;
 
 PROCEDURE AERR24;
 BEGIN
 ASSEMBLER
"MOVE.W  #924,D5       ; No Asm in WITH
"JMP     SyntaxErr
 END
 END AERR24;
 
 
 (*$ ? Gepard:
 PROCEDURE AsmWarning;
"BEGIN
$ASSEMBLER
); D2 enth. Fehlernummer, D3 die Position (0=Mnem., 1/2/3=Operand
)MOVEM.L D0-A6,-(A7)
)MOVE.L  AsmOptions,D4
)BTST    #23,D4         ; $W- ?
)BEQ     noWarn
)SUBQ    #1,D3
)BCS     mne
)BEQ     op1
)SUBQ    #1,D3
)BEQ     op2
)MOVE.L  pTxtOp3,A2     ; Text-^ fr Operand 3
)BRA     warn
 op2      MOVE.L  pTxtOp2,A2     ; Text-^ fr Operand 2
)BRA     warn
 op1      MOVE.L  pTxtOp1,A2     ; Text-^ fr Operand 1
)BRA     warn
 mne      MOVE.L  pTxtMne,A2     ; Text-^ fr Mnemonic
 warn     MOVE    D2,D5
)MOVE.L  pLastSym,-(A7)
)MOVE.L  pTxtLin,-(A7)
)MOVE.L  A2,pLastSym
)MOVE.L  pTxtLin2,pTxtLin
)JSR     Warning
)MOVE.L  (A7)+,pTxtLin
)MOVE.L  (A7)+,pLastSym
 noWarn   MOVEM.L (A7)+,D0-A6
$END
"END AsmWarning;
 *)
 
 
 PROCEDURE AsmSameSbl;
"BEGIN
$ASSEMBLER
(CLR     GetLastSbl
(JSR     SameSbl
(MOVE.L  LastGSD2,D2
(TST.W   D3
$END
"END AsmSameSbl;
 
 PROCEDURE AsmGetSbl;
"BEGIN
$ASSEMBLER
(TST     GetLastSbl
(BNE     last
(JMP     GetSbl
&last
(JMP     AsmSameSbl
$END
"END AsmGetSbl;
 
 
 
 PROCEDURE CopyLast;
"BEGIN
"ASSEMBLER
-MOVE.L  D0,-(A7)
-MOVE.L  #ModeDest,D0
-SUB.L   #ModeSource,D0
-SUBQ.L  #1,D0
"L1         MOVE.B  (A0)+,(A1)+
-DBRA    D0,L1
-MOVE.L  (A7)+,D0
-MOVEA.L (A7)+,A1
"END
"END CopyLast;
 
 PROCEDURE SourceToLast;
"BEGIN
"ASSEMBLER
-MOVE.L  A1,-(A7)
-LEA     ModeSource,A0
-LEA     Mode,A1
-JMP     CopyLast
"END
"END SourceToLast;
#
 PROCEDURE DestToLast;
"BEGIN
"ASSEMBLER
-MOVE.L  A1,-(A7)
-LEA     ModeDest,A0
-LEA     Mode,A1
-JMP     CopyLast
"END
"END DestToLast;
 
 PROCEDURE ThirdToLast;
"BEGIN
"ASSEMBLER
-MOVE.L  A1,-(A7)
-LEA     ModeThird,A0
-LEA     Mode,A1
-JMP     CopyLast
"END
"END ThirdToLast;
 
 PROCEDURE LastToThird;
"BEGIN
"ASSEMBLER
-MOVE.L  A1,-(A7)
-LEA     Mode,A0
-LEA     ModeThird,A1
-JMP     CopyLast
"END
"END LastToThird;
 
 PROCEDURE LastToDest;
"BEGIN
"ASSEMBLER
-MOVE.L  A1,-(A7)
-LEA     Mode,A0
-LEA     ModeDest,A1
-JMP     CopyLast
"END
"END LastToDest;
 
 PROCEDURE LastToSource;
"BEGIN
"ASSEMBLER
-MOVE.L  A1,-(A7)
-LEA     Mode,A0
-LEA     ModeSource,A1
-JMP     CopyLast
"END
"END LastToSource;
 
 
 PROCEDURE GetSize;
"BEGIN
"ASSEMBLER
+MOVE.W  D3,-(A7)
+CMPI.B  #'.',(A2)
+BNE     SizeE          ; -> keine Sizeangabe
+
+ADDQ.L  #1,A2
+MOVE.B  (A2)+,D3
+ANDI.B  #$5F,D3        ;aus KLEIN mach gross...
+
+MOVEQ   #$01,D0
+CMPI.B  #'B',D3
+BEQ     SizeE
+
+MOVEQ   #$02,D0
+CMPI.B  #'W',D3
+BEQ     SizeE
+
+MOVEQ   #$04,D0
+CMPI.B  #'L',D3
+BEQ     SizeE
+
+MOVEQ   #$08,D0
+CMPI.B  #'S',D3
+BEQ     SizeE
"
+MOVEQ   #$10,D0
+CMPI.B  #'D',D3
+BEQ     SizeE
"
+MOVEQ   #$20,D0
+CMPI.B  #'X',D3
+BEQ     SizeE
"
+MOVEQ   #$40,D0
+CMPI.B  #'P',D3
+BEQ     SizeE
"
+JMP     AERR1
"
"SizeE    MOVE.W  (A7)+,D3
+MOVE.B  D0,SizeOfData
"END
"END GetSize;
 
 
 PROCEDURE NewLabel;
"BEGIN
"ASSEMBLER  JSR     GETID0         ;Labelnamen in ID-Baum eintragen
+JSR     PULLID
+JSR     SETID
+MOVE.W  #LabelID,-2(A1,D6.L) ;Type festlegen
+CLR.L   -6(A1,D6.L)
+CLR.L   -10(A1,D6.L)
+CLR.L   -14(A1,D6.L)
+CLR.W   -16(A1,D6.L) ; BOOLEAN, f. Flag, ob auf Label referiert wird
+MOVE.L  D6,D2
+SUBI.L  #16,D6
+MOVE.L  D6,TRESPC
"END
"END NewLabel;
 
 PROCEDURE SaveIDPtr; (* RETTET ^ x(A1,D2.L) NACH IDPtr *)
 BEGIN
"ASSEMBLER
$MOVEA.L A1,A0
$ADDA.L  D2,A0
$ADDA.L  D3,A0
$MOVE.L  A0,IDPtr
$BSET    #7,DataType
"END
 END SaveIDPtr;
 
 
 (*
!* Aufruf bei einem Proc-Call. Wenn Proc Result in D0 liefert, mu
!* nach dem Proc-Namen das Zeichen "/" folgen!
!*)
 PROCEDURE CheckProcResult;
"BEGIN
$ASSEMBLER
(MOVE.L  D2,-(A7)
(JSR     AsmSameSbl
(BTST    #8,D3
(BEQ     ok
(JSR     AsmGetSbl
(CMPI    #AS5,D3         ; '/'
(BEQ     ok
(JMP     AERR23
%ok MOVE.L  (A7)+,D2
$END
"END CheckProcResult;
 
 (*
!*   DATA HOLEN
!*)
 VAR SUBNEXT:BITE (* Flag *) ;
$SaveA2, SaveD2: (*$ ? RunGep: LONG *) (*$ ? RunST: LONGWORD *) ;
$SaveD3:WORD;
 PROCEDURE GetExpr;
 BEGIN
 ASSEMBLER
)SF      SUBNEXT
)CLR.W   DataType
)CLR.L   Data
)
)MOVE.L  OPTIONS,D0
)LSR     #1,D0          ;Soll BREAK erfolgen ?
)BCC     noBrk          ;nein
)BREAK
)
 noBrk    JSR     AsmSameSbl
)CMPI.W  #AS3,D3      ; '+'
)BEQ.W   NUMDAT
)CMP     #AS4,D3      ; '-'?
)BEQ.W   NUMDAT
)BRA.W   DATAL
)(*
)BNE.L   DATAL
)ST      SUBNEXT
 DATAPL2  JSR     AsmGetSbl
)BRA.L   DATAL
)*)
)
 AER1     JMP     AERR1
 AER4     JMP     AERR4
 AER14    JMP     AERR14 ;'ILLEGAL EXPRESSION'
)
 RecFeld  ; ermittele Record-Feld
)MOVE.L  SaveD2,D2
)MOVE.W  -2(A1,D2.L),D3  ;Hole ID-Typ
)MOVE.W  D3,SaveD3
)ANDI.W  #$80FF,D3
)CMPI.W  #$800E,D3       ; ID = RECORD-FELD ?
)BEQ     RecF3
)CMPI.W  #$8011,D3       ; ID = VARIABLE ?
)BNE     RecF2           ;Nein: direkt auf Typ testen
 RecF3    MOVE.L  -10(A1,D2.L),D2 ;Hole Typ-^ nach D2
)MOVE.W  -2(A1,D2.L),D3  ;Hole Typ
)ANDI.W  #$80FF,D3
 RecF2    CMPI.W  #$800D,D3       ;Typ = Record ?
)BEQ     RecF4
)
)CLR.L   Data            ;alten Wert loeschen, weil er nicht
A;aufaddiert werden darf !
)CMPI.W  #$800C,D3       ;Typ = Array ?
)BEQ     RecF3
)CMPI.W  #$8014,D3       ;Typ = Pointer ?
)BEQ     RecF3
)
)JMP     AERR4           ;Nein:ERROR
)
 RecF4    ; Verarbeite Record
)MOVE.L  -14(A1,D2.L),D2 ;Hole loc.Rec-Tree-^ nach D2
)MOVE.B  (A2),D1
)JSR     LocalSearch     ;suche ID in Rec.Tree
)BCS     AER4            ;ERROR:Record-Feld nicht gefunden
)MOVE.L  -6(A1,D2.L),D0  ;hole rel.Adr des Rec-Feldes
)MOVE.W  SaveD3,D3
)ANDI.W  #$0200,D3
)BEQ     LocRec          ;Lokale Rec-Var:Feld-Offset aufaddieren
)
)MOVE.W  DataType,D3
)BTST    #6,D3           ;Typenkennung f. glob Var testen
)BEQ     LocRec          ;ist schon geloescht -> (schon 2.Rec-Feld)
)CLR.L   Data            ;sonst:Glob.Adr loeschen
)
 LocRec   CLR.W   DataType        ;Typenkennung f. lok. Var loeschen
)MOVEQ   #5,D3
)BRA.L   DATAFI          ;-> Rel.Adr.des Feldes zu DATA addieren
)
)
 !DATAL   JSR     AsmSameSbl
)ANDI.W  #$90FF,D3
)CMPI.W  #$9011,D3       ;EXTERNAL VARIABLE ?
)BNE     NEVARREF
)
+MOVE.L  -6(A1,D2.L),D0
+MOVEQ   #1,D3
+BRA.L   DATAFI
 
 NEVARREF JSR     AsmSameSbl
)ANDI.W  #$82FF,D3
)CMPI.W  #$8211,D3         ;GLOBALE VARIABLE ?
)BNE     NGVARREF
)
+MOVEQ   #-14,D3
+JSR     SaveIDPtr
+MOVEQ   #6,D3
+BRA.L   DATAFI
 
 NGVARREF CMPI.W  #$8011,D3         ;LOKALE VARIABLE ?
)BNE     NOVARREF
+
+TST     WithScope
+BEQ     noWith
+JMP     AERR24
)noWith
+
+MOVE.L  -6(A1,D2.L),D0
+MOVEQ   #9,D3
+BRA.L   DATAFI
 
 NOVARREF CMPI.W  #$8206,D3         ;GLOBALE PROCEDURE?
)BNE     NOPRCD
 
+JSR     CheckProcResult
+MOVEQ   #-18,D3
+JSR     SaveIDPtr
+MOVEQ   #7,D3
+BRA.L   DATAFI
 
 NOPRCD   CMPI.W  #$8006,D3         ;LOKALE PROCEDURE?
)BNE     NOLPRCD
)
+TST     WithScope
+BEQ     noWith2
+JMP     AERR24
)noWith2
)
+JSR     CheckProcResult
+MOVE.L  -6(A1,D2.L),D0  ;Ist Adr. der Proc. schon bekannt ?
+BEQ     LPRC0           ;Nein->Ref.^ merken.
+
+; lok. Proc. mit bekannter Adr.
+MOVEQ   #10,D3
+BRA.L   DATAFI
+
"LPRC0    ; lok. Proc. mit unbekannter Adr. / Vorw. Ref.
+MOVEQ   #-18,D3
+JSR     SaveIDPtr
+MOVEQ   #10,D3
+BRA.L   DATAFI
 
 NOLPRCD  CMPI.W  #$820C,D3       ; ARRAY - TYP ?
)BEQ     isTyped
)CMPI.W  #$820D,D3       ; RECORD - TYP ?
)BEQ     isTyped
)CMPI.W  #$8214,D3       ; POINTER - TYP ?
)BNE     NOPTR
 
 isTyped    CLR.L   D0
+MOVEQ   #14,D3
+BRA.L   DATAFI
 
 NOPTR    ANDI.W  #$80FF,D3
)CMP     #$801C,D3         ;TABLE?
)BNE     NOTAB
 
+MOVEQ   #-10,D3
+JSR     SaveIDPtr
+MOVEQ   #6,D3
+BRA.L   DATAFI
)
 NOTAB    CMPI.W #$800E,D3         ;Record-Feld ? (Tritt nur waehrend WITH auf)
)BNE     NORECRD
 
+JMP     AERR24
)(* Ist erstmal verboten
+MOVE.L  -6(A1,D2.L),D0
+MOVEQ   #5,D3
+BRA.L   DATAFI
)*)
 
 NORECRD
 
 (* das berlassen wir nun 'NUMDAT':
 
*CMPI.W  #$8012,D3        ;CONSTANT ?
*BNE.L   NOCONST
 
)(* drfte gar nicht vorkommen:
6CMPI.W  #8,-8(A1,D2.L) ;ist Const. 8 Byte lang ?
6BHI     ERRILEXP
6BCS     NOREALCONST
6MOVE.L  -12(A1,D2.L),DATA
6MOVE.L  -16(A1,D2.L),DATA2
6BRA     REALEXIT
4NOREALCONST
)*)
 
+MOVE.L  -12(A1,D2.L),D0
+MOVEQ   #0,D3
+CMPI.W  #4,-8(A1,D2.L) ;ist Const. 4 Byte lang ?
+BNE     DATAEXP      ;NEIN:short Const.
+
+;Const. ist vom Typ LONG
+MOVEQ   #11,D3
+TST.W   DataType
+BEQ.L   DATAFI       ;OK: noch keine Expr.
+MOVE.W  DataType,D3
+BTST    #11,D3       ;Ist Expr. vom Typ L-Const. ?
+BNE.L   DATACO       ;JA: OK
+BTST    #01,D3       ;Ist Expr. vom Typ External ?
+BNE.L   DATACO       ;JA: OK
"ERRILEXP JMP     AERR14       ;ERROR:Ill.Expr.
 *)
 
 NOCONST  CMPI.W  #$800A,D3        ;AUFZAEHLUNGSTYP ?
)BNE     DATA2L
)
+CLR.L   D0
+MOVE.W  -4(A1,D2.L),D0
+MOVEQ   #4,D3
+BRA.L   DATAFI
 
 DATA2L   TST.W   D3               ;Noch unbekanntes Label ?
)BNE     NONEWLBL
)
+JSR     NewLabel
+MOVE    #1,-16(A1,D2.L) ; Referenz auf Label markieren
"C1       MOVEQ   #-6,D3
+JSR     SaveIDPtr
"C2       MOVEQ   #8,D3
+BRA.L   DATAFI
+
 NONEWLBL CMPI.W  #LabelID,D3      ;BEKANNTES LABEL ?
)BNE     NOLBL
)
+MOVE    #1,-16(A1,D2.L) ; Referenz auf Label markieren
+MOVE.L  -6(A1,D2.L),D0 ;Adresse des Labels
+BEQ     C1             ;-> noch unbekannt
+
+TST.W   DataType       ;Expression ?
+BEQ     C2             ;NEIN
+TST.B   SUBNEXT
+BEQ     AER14          ;Addition mit Label illegal
+MOVE.W  DataType,D3
+BTST    #8,D3
+BEQ     AER14          ;ERROR: Source muss auch Label sein
+CLR.W   D3
+BSET    #0,D3          ;Label-Expr. als W-Konst. kennzeichnen
+MOVE.W  D3,DataType
+BRA.L   DATACO
)
 NOLBL    CMPI.W  #STRCONST,D3     ; CHARACTER o. STRING ?
)BNE     NUMDAT
 
+MOVE.B  STRBUF,D0
+EXT.W   D0
+EXT.L   D0
+MOVE.W  DataType,D3
+BEQ     DATASTR1     ;keine Expr.->
+BTST    #3,D3
+BEQ     AER14        ;ERROR: Source muss auch String sein
+BRA.L   DATACO
"DATASTR1 MOVEQ   #3,D3
+BRA.L   DATAFI
"
"NUMDAT   JSR     ConstExpr      ; HOLE NUMERISCHE KONSTANTE
+JSR     PullInt
+JSR     adaptSStoCHAR
+MOVE.L  D0,D2
+ADDQ    #1,GetLastSbl  ; auf TRUE setzen
+
+; erst auf REAL testen, denn das ist kein Skalar   %%%%
+
+MOVE.W  -2(A1,D2.L),D3
+CMPI.B  #$02,D3      ; LONG REAL
+BEQ     REALNUM
+CMPI.B  #42,D3
+BEQ     REALNUM      ; SHORT REAL
+
+; kein REAL - hoffentlich ein skalarer Datentyp
+
+ANDI.W  #$0100,D3
+BEQ     AER1
+MOVE.L  Accu,D0
+MOVEQ   #2,D3
+
+TST.W   DataType
+BEQ     DATAFI
+BMI     AER14        ; ERROR:Source-Adr./Wert noch unbekannt
+BRA.L   DATACO       ; OK: Wert aufrechnen ( W-Const. koennen
@;  auf alle bek. Werte addiert werden )
 
"REALNUM  MOVE.L  Accu,DATA
+MOVE.L  AccuS14,DATA2
+MOVE.W  DataType,D0
+BNE     AER14
+BSET    #12,D0
+MOVE.W  D0,DataType    ;ID-Typ merken
+JSR     AsmGetSbl
+MOVE.L  #DATA,D0
+RTS
 
 DATAFI   MOVE.L  D0,-(A7)
)MOVE.W  DataType,D0
)ANDI.W  #$7FFF,D0
)BNE     AER14          ;Es darf noch kein ID definiert sein
)MOVE.W  DataType,D0
)BSET    D3,D0
)MOVE.W  D0,DataType    ;ID-Typ merken
)MOVE.L  (A7)+,D0
)
 DATACO   TST.B   SUBNEXT
)BEQ     DATA5
)SUB.L   D0,Data
)BRA     DATA6
 DATA5    ADD.L   D0,Data
)
 DATA6    MOVE.L  D2,SaveD2
)JSR     AsmGetSbl
)SF      SUBNEXT
)CMPI.W  #AS37,D3     ; '.'
)BEQ     RecFeld
)
)CMPI.W  #AS3,D3      ; '+'
)BEQ     DATAPLUS
)CMP     #AS4,D3      ; '-'
)BNE     DATAENDL
)
)ST      SUBNEXT
)MOVE.L  D2,SaveD2
 DATAPLUS JSR     AsmGetSbl
)BRA     DATAL
 
 DATAENDL ; Pruefe Datengroesse bez. 'DataType'
)MOVE.W  DataType,D0
)
)BTST    #14,D0             ;ist ID = TYPE ?
)BNE     AER14              ;JA: ERROR
)
)ANDI.W  #011000111001%,D0  ;maskiere alle L-Werte weg
)BEQ     DATAEND2           ;OK: das Datum darf L-Werte haben
)
);Test,ob 'Data' groeser als WORD:
)CMPI.L  #$10000,Data
)BCS     DATAEND2
)CMPI.L  #$FFFF0000,Data
)BHI     DATAEND2
)JMP     AERR16
 
 DATAEND2 END
 END GetExpr;
 
 
 PROCEDURE RetTRUE;
"BEGIN
"ASSEMBLER  MOVE.W  D0,-(A7)
+JSR     AsmGetSbl
+MOVE.W  (A7)+,D0
+ORI     #4,CCR
"END
"END RetTRUE;
 
 
 PROCEDURE RetFALSE;
"BEGIN
"ASSEMBLER  ANDI    #$FB,CCR
"END
"END RetFALSE;
 
 
 PROCEDURE Test_Dn;
 BEGIN
 ASSEMBLER  JSR     AsmSameSbl
)CMPI    #AS18,D3       ;'D0'
)BCC     L1
 L2       JMP     RetFALSE
 !L1      CMPI    #AS25,D3       ;'D7'
)BHI     L2
)SUB     #AS18,D3       ;'D0'
)MOVE    D3,D0
)JMP     RetTRUE
 END
 END Test_Dn;
 
 
 PROCEDURE Test_An;
 BEGIN
 ASSEMBLER  JSR     AsmSameSbl
)CMPI    #AS_FP,D3      ;'FP'
)BNE     L4
)MOVE    VarReg,D0
)SUBQ    #8,D0
)JMP     RetTRUE
 L4       CMPI    #AS26,D3       ;'SP'
)BNE     L3
)MOVEQ   #7,D0
)JMP     RetTRUE
 L3       CMPI    #AS10,D3       ;'A0'
)BCC     L1
 L2       JMP     RetFALSE
 !L1      CMPI    #AS17,D3       ;'A7'
)BHI     L2
)SUB     #AS10,D3       ;'A0'
)MOVE    D3,D0
)JMP     RetTRUE
 END
 END Test_An;
 
 (*$ ? Asm20:
 
 PROCEDURE Test_FPn;
 BEGIN
 ASSEMBLER  JSR     AsmSameSbl
)CMPI    #AS_FP0,D3     ;FP0
)BCS     FPT1
)CMPI    #AS_FP7,D3
)BHI     FPT1
)SUB     #AS_FP0,D3
)MOVE    D3,D0
)JMP     RetTRUE
 FPT1     JMP     RetFALSE
 END
 END Test_FPn;
 
 
 PROCEDURE Test_FCn;
 BEGIN
 ASSEMBLER  JSR     AsmSameSbl
)CMPI    #AS_FPIAR,D3
)BNE     FCT1
)MOVEQ   #$00,D0
 FCTRT    JMP     RETTRUE
 FCT1     CMPI    #AS_FPSR,D3
)BNE     FCT2
)MOVEQ   #$01,D0
)BRA     FCTRT
 FCT2     CMPI    #AS_FPCR,D3
)BNE     FCT3
)MOVEQ   #$02,D0
)BRA     FCTRT
 FCT3     JMP     RETFALSE
 END
 END Test_FCn;
 *)
 
 PROCEDURE Test_Rn;
 BEGIN
 ASSEMBLER  JSR     Test_Dn
)BEQ     C1
)JSR     Test_An
)BNE     C2
)ADDQ.L  #8,D0
 C1       ORI     #4,CCR
 C2
 END
 END Test_Rn;
 
 
 PROCEDURE Test_Ind_An;
 BEGIN
 ASSEMBLER  JSR     AsmSameSbl
)CMPI    #AS1,D3        ; '(' ?
)BEQ     L1
 !JDR1    JMP     RetFALSE
 !L1      CMPI.B  #'A',(A2)
)BEQ     ARIND1
)CMPI.B  #'a',(A2)
)BEQ     ARIND1
)CMPI.B  #'S',(A2)      ; vielleicht SP ?
)BEQ     ARIND1SP
)CMPI.B  #'s',(A2)      ; vielleicht SP ?
)BNE     JDR1
 ARIND1SP CMPI.B  #'P',1(A2)
)BEQ     ARIND2
)CMPI.B  #'p',1(A2)
)BEQ     ARIND2
)BRA     JDR1
 ARIND1   CMPI.B  #'0',1(A2)
)BCS     JDR1
)CMPI.B  #'7',1(A2)
)BHI     JDR1
 ARIND2   CMPI.B  #')',2(A2)
)BNE     JDR1
)JSR     AsmGetSbl
)JSR     Test_An
)BEQ     OK
)JMP     AERR1
 !OK      CMPI    #AS2,D3        ; ')'
)BNE     JDR1
)JMP     RetTRUE
 END
 END Test_Ind_An;
 
 
 PROCEDURE Test_Ind_Dn;
 BEGIN
 ASSEMBLER  JSR     AsmSameSbl
)CMPI    #AS1,D3        ; '(' ?
)BEQ     L1
 !JDR1    JMP     RetFALSE
 !L1      CMPI.B  #'D',(A2)
)BEQ     ARIND1
)CMPI.B  #'d',(A2)
)BNE     JDR1
 ARIND1   CMPI.B  #'0',1(A2)
)BCS     JDR1
)CMPI.B  #'7',1(A2)
)BHI     JDR1
)CMPI.B  #')',2(A2)
)BNE     JDR1
)JSR     AsmGetSbl
)JSR     Test_Dn
)BEQ     OK
)JMP     AERR1
 !OK      CMPI    #AS2,D3        ; ')'
)BNE     JDR1
)JMP     RetTRUE
 END
 END Test_Ind_Dn;
 
 
 VAR KommaExp:BITE; (* Bit 0 gesetzt: Komma ist bei nchstem Symbol erlaubt *)
'Outer:BITE; (* FLAG *)
 PROCEDURE GetEA_U;
 BEGIN
 ASSEMBLER  CLR.B   Mode
)CLR.W   DataType
)CLR.L   Data
)CLR.W   RegList
)CLR.B   Reg
)CLR.B   M20Flg
)BCLR    #0,KommaExp
)
)JSR     Test_Rn
)BNE.L   GADRFP
)
)CMPI    #AS5,D3        ;'/'
)BEQ     GADR3
)CMPI    #AS4,D3        ;'-'
)BEQ     GADRM
)
+CMPI.W  #8,D0
+BCS     DN
+
+MOVE.B  #2,Mode
+ANDI.B  #7,D0
+MOVE.B  D0,Reg
+RTS
+
"DN       MOVE.B  #1,Mode
+MOVE.B  D0,Reg
+RTS
+
";Registerliste auswerten
"GADR3    MOVE    RegList,D2
+BSET    D0,D2
+MOVE    D2,RegList
"GADR34   CMPI    #AS5,D3      ;'/'
+BEQ     GADR5
+CMPI    #AS4,D3      ;'-'
+BEQ     GADRM
+MOVE.B  #18,Mode
+RTS
+
"!GADR5   JSR     AsmGetSbl
+JSR     Test_Rn
+BEQ     GADR3
+
"AER1     JMP     AERR1
"AER20    JMP     AERR20
+
"GADRM    MOVE.W  D0,-(A7)
+JSR     AsmGetSbl
+JSR     Test_Rn
+BNE     AER1
+MOVE.W  (A7)+,D1
+CMP.W   D1,D0
+BCC     GADRM2
+JMP     AERR2        ;ERROR: 2.Reg.>1.Reg.
"GADRM2   MOVE.W  RegList,D2
+BSET    D1,D2
+MOVE.W  D2,RegList
+ADDQ.W  #1,D1
+CMP.W   D0,D1
+BLS     GADRM2
+BRA     GADR34
)
); Flotingpoint register testen
 GADRFP
 (*$ ? Asm20:
)JSR     Test_FPn
)BNE.L   GADRFC
+
)CMPI    #AS5,D3        ;'/'
)BEQ     GADRFP3
)CMPI    #AS4,D3        ;'-'
)BEQ     GADRFPM
+
+MOVE.B  #25,Mode
+MOVE.B  D0,Reg
+RTS
+
+;Floatingpoint Registerliste auswerten
"GADRFP3  MOVE    RegList,D2
+BSET    D0,D2
+MOVE    D2,RegList
"GADRFP34 CMPI    #AS5,D3      ;'/'
+BEQ     GADRFP5
+CMPI    #AS4,D3      ;'-'
+BEQ     GADRFPM
+MOVE.B  #26,Mode
+RTS
+
"GADRFP5  JSR     AsmGetSbl
+JSR     Test_FPn
+BEQ     GADRFP3
+BRA.L   AER1
+
"GADRFPM  MOVE.W  D0,-(A7)
+JSR     AsmGetSbl
+JSR     Test_FPn
+BNE.L   AER1
+MOVE.W  (A7)+,D1
+CMP.W   D1,D0
+BCC     GADRFPM2
+JMP     AERR2        ;ERROR: 2.Reg.>1.Reg.
"GADRFPM2 MOVE.W  RegList,D2
+BSET    D1,D2
+MOVE.W  D2,RegList
+ADDQ.W  #1,D1
+CMP.W   D0,D1
+BLS     GADRFPM2
+BRA     GADRFP34
)
+
); Floatingpoint control-Register Testen
 GADRFC   JSR     Test_FCn
)BNE     GADR1
)
)CMPI    #AS5,D3        ;'/'
)BEQ     GADRFC3
)
+MOVE.B  #27,Mode
+MOVE.B  D0,Reg
+RTS
+
+; Floatingpoint control-Registerliste auswerten
"GADRFC3  MOVE    RegList,D2
+BSET    D0,D2
+MOVE    D2,RegList
+CMPI    #AS5,D3      ;'/'
+BEQ     GADRFC5
+MOVE.B  #28,Mode
+RTS
+
"GADRFC5  JSR     AsmGetSbl
+JSR     Test_FCn
+BEQ     GADRFC3
+BRA.L   AER1
 
 GADR1
'*)
+JSR     Test_Ind_An
+BNE     GADR8
)
+MOVE.B  D0,Reg
+MOVE.B  #4,Mode
+CMPI    #AS3,D3        ;'+'
+BEQ     GADR7
+MOVE.B  #3,Mode
+RTS
"!GADR7   JMP     AsmGetSbl
 
 GADR8    JSR     Test_Ind_Dn
)BNE     GADR81
)
+MOVE.B  D0,Reg
+MOVE.B  #17,Mode
+RTS
 
 GADR81   CMPI    #AS4,D3        ; '-' ?
)BNE     GADR9
)
+CMPI.B  #'(',(A2)
+BNE.L   GADR11       ;keine Klammer? Dann ist es eine num.Konstante
+
+JSR     AsmGetSbl
+JSR     Test_Ind_An
+BNE     AER1
+MOVE.B  D0,Reg
+MOVE.B  #5,Mode
+RTS
 
 GADR9    CMPI    #AS9,D3       ; '#'
)BNE     GADR10
)
+; '#data'
+MOVE.B  #12,Mode
+JSR     AsmGetSbl
+JMP     GetExpr
 
 GADR10   CMPI    #AS29,D3        ; SR ? nein ->
)BNE     GADR28
+
+MOVE.B  #13,Mode
+JMP     AsmGetSbl
 
 GADR28   CMPI    #AS30,D3        ; USP ?
)BNE     GADR29
+
+MOVE.B  #14,Mode
+JMP     AsmGetSbl
 
 GADR29   CMPI    #AS31,D3        ; CCR ? nein ->
)BNE     GADR30
+
+MOVE.B  #15,Mode
+JMP     AsmGetSbl
)
 GADR30   CMPI    #AS32,D3        ; VBR ? nein ->
)BNE.L   GADR100
+
+MOVE.B  #16,Mode
+JMP     AsmGetSbl
 
 TstScale ; Scaling auswerten
-
-MOVE.B  #1,IndScale
-CMPI    #AS_Astrx,D3
-BNE     TscE
-JSR     AsmGetSbl
-MOVE.L  Data,-(A7)         ; Data retten, da von GetExpr zerstrt
-MOVE    DataType,-(A7)     ; ebenfalls retten
-JSR     GetExpr
-MOVE    DataType,D0
-ANDI    #1111111111010%,D0  ; nur Consts erlaubt
-BEQ     Gadr183
-JMP     AERR13         ;'ILLEGAL adressing mode'
$AER2     JMP     AERR2          ;'ILLEGAL operand size'
$Gadr183  MOVE.L  Data,D0        ; als Data nur 1,2,4 oder 8 erlaubt
-MOVE    (A7)+,DataType
-MOVE.L  (A7)+,Data
-TST.L   D0
-BEQ     AER2
-CMPI.L  #8,D0
-BEQ     Gadr185
-CMPI.L  #4,D0
-BHI     AER2
-BEQ     Gadr185
-CMPI.B  #3,D0
-BEQ     AER2
$Gadr185  ; Alles OK
-MOVE.B  D0,IndScale
$TscE     RTS
-
 ; berprfung aller erw. Adr.-Arten der 68020
 
 GADR100
 (*$ ? Asm20:
)CMPI    #AS_SFC,D3
)BNE     GADR101
)
+MOVE.B  #19,Mode
+JMP     AsmGetSbl
)
 Gadr101  CMPI    #AS_DFC,D3
)BNE     GADR102
)
+MOVE.B  #20,Mode
+JMP     AsmGetSbl
)
 Gadr102  CMPI    #AS_CACR,D3
)BNE     GADR103
)
+MOVE.B  #21,Mode
+JMP     AsmGetSbl
)
 Gadr103  CMPI    #AS_CAAR,D3
)BNE     GADR130
)
+MOVE.B  #22,Mode
+JMP     AsmGetSbl
)
 Gadr130  CMPI    #AS_MSP,D3
)BNE     GADR131
)
+MOVE.B  #23,Mode
+JMP     AsmGetSbl
)
 Gadr131  CMPI    #AS_ISP,D3
)BNE     GADR104
)
+MOVE.B  #24,Mode
+JMP     AsmGetSbl
)
 Gadr104  CMPI    #AS1,D3     ; '(' ?
)BNE.L   GADR11
)
)MOVE.L  OPTIONS,D2
)LSR     #1,D2          ;Soll BREAK erfolgen ?
)BCC     noBrk          ;nein
)BREAK
)
 noBrk    ; erw. Adr. Arten mit '([bd,An/PC],Xn.Size*Scale],od)'
)
+MOVE.B  #7,Mode     ; Nehmen wir erstmal an
+
"GadrLoop JSR     AsmGetSbl
+
"GadrLpC  CMPI    #AS38,D3     ; ',' ?
+BNE     GADR142
-
-BCLR    #0,KommaExp
-BEQ     AER1
-BRA     GadrLoop
-
"Gadr142  CMPI    #AS2,D3     ; ')' ?
+BNE     GADR105
-
-; Test, ob nur '[' oder nur ']', sonst Ende
-BTST    #FlgeKlA,M20Flg
-BEQ     Gadr140
-BTST    #FlgeKlZ,M20Flg
-BEQ     AER1
$Gadr141  BSET    #FlgIs20,M20Flg    ; So hiermit wird erw. Adr-Art markiert
-JMP     AsmGetSbl
-
$Gadr140  BTST    #FlgeKlZ,M20Flg
-BNE     AER1
-BRA     Gadr141
-
"Gadr105  CMPI    #AS_eKlA,D3     ; '[' ?
+BNE     GADR106
-
-TST.B   M20Flg
-BNE     AER1            ; Es darf noch nix markiert sein
-BSET    #FlgeKlA,M20Flg
-BRA     GadrLoop
-
"Gadr106  CMPI    #AS_eKlZ,D3     ; ']' ?
+BNE     GADR107
-
-MOVE.B  M20Flg,D0
-BCLR    #FlgeKlA,D0
-BEQ     AER1            ; '[' mu schon auf sein
-TST.B   D0
-BEQ     AER20           ; unsinnige Adr.-Art
-BSET    #FlgeKlZ,M20Flg
-BNE     AER1            ; ']' darf noch nicht gewesen sein
-BSET    #0,KommaExp
-BTST    #FlgXn,D0
-BEQ     GadrLoop
-BSET    #FlgPreIx,M20Flg  ; PreIndexed markieren
-BRA     GadrLoop
-
"Gadr107  CMPI    #AS35,D3     ; 'PC' ?
+BNE     GADR108
-
-MOVE.B  #11,Mode     ; Korrektur der Annahme
-JSR     AsmGetSbl
-
$Gadr170  MOVE.B  M20Flg,D0
-BCLR    #FlgeKlA,D0
-BCLR    #Flgbd,D0
-TST.B   D0
-BNE     AER1
-BSET    #FlgAnPC,M20Flg
-BSET    #0,KommaExp
-BRA     GadrLpC
-
"Gadr108  JSR     Test_Rn
+BNE.L   GADR109
-
-CMPI    #AS37,D3        ; '.' ?
-BEQ     GADR181         ; Ja -> mu Indexreg. sein
/
/SUBQ    #8,D0           ; Adreregister ?
/BCS     AER1            ; Nein -> Error
/
/; Base Register An
/MOVE.B  D0,Reg
/BRA     Gadr170
/
$Gadr181  ; Index Register Xn.Size*Scale
-
-CMPI    #8,D0
-SCS     IndType
-ANDI    #7,D0
-MOVE.B  D0,IndReg
-
-BSET    #FlgXn,M20Flg
-BNE     AER1
-BTST    #FlgOd,M20Flg
-BNE     AER1
-
-MOVE.B  #4,IndSize
-CMPI.B  #'L',(A2)
-BEQ     GADR182
-CMPI.B  #'l',(A2)
-BEQ     GADR182
-MOVE.B  #2,IndSize
-CMPI.B  #'W',(A2)
-BEQ     GADR182
-CMPI.B  #'w',(A2)
-BNE     AER1
)
$GADR182  ADDQ.L  #1,A2
-JSR     AsmGetSbl
-BSR     TstScale
-BSET    #0,KommaExp
-BRA     GadrLpC
-
"Gadr109  ; Jetzt kann's nur noch OD oder BD sein
-
-BTST    #FlgeKlZ,M20Flg
-SNE     Outer
-
-MOVE.L  Data,-(A7)         ; Data retten, da von GetExpr zerstrt
-MOVE    DataType,-(A7)     ; ebenfalls retten
-JSR     GetExpr
-MOVE.L  Data,D0
-MOVE    DataType,D1
-MOVE    (A7)+,DataType
-MOVE.L  (A7)+,Data
-TST.B   Outer
-BNE     Gadr191
-
-; Base Displacement
-MOVE.L  D0,Data
-MOVE    D1,DataType
-MOVE.B  M20Flg,D2
-BCLR    #FlgeKlA,D2
-TST.B   D2                 ; auer '[' darf noch nix sein
-BNE     AER1
-BSET    #FlgBd,M20Flg
-BNE     AER1
-BSET    #0,KommaExp
-BRA     GadrLpC
-
$Gadr191  ; Outer Displacement
-BSET    #FlgOd,M20Flg
-BNE     AER1
-MOVE.L  D0,DataOd
-MOVE    D1,DataTypeOd
-BRA     GadrLpC
 *)
-
 ; Ausdruck holen und Test auf indirekte Adr. (alte 68000 Adr.-Arten)
 
 GADR11   JSR     GetExpr        ;Ausdruck wird ausdruecklich erwartet.
)JSR     Test_Ind_An
)BNE.L   GADR13
)
+; 'd16(An)'
+MOVE.B  D0,Reg
+MOVE.B  #6,Mode
+RTS
 
 GADR13   CMPI.W  #AS1,D3        ; '(' ?
)BEQ     GADR14
)
+; 'd32'
+MOVE.B  #9,Mode
+RTS
)
 GADR14   JSR     AsmGetSbl
)JSR     Test_An
)BEQ     GADR19
)
)CMPI    #AS35,D3       ; 'PC' ?
)BNE     AER1
)
+JSR     AsmGetSbl
+CMPI    #AS2,D3        ; ')' ?
+BNE     GADR26
+
-; 'd16(PC)'
-MOVE.B  #10,Mode
-JMP     AsmGetSbl
"
"GADR26   ; 'd8(PC,Rn.X)'
+MOVE.B  #11,Mode
+BRA.L   GADR24
+
"GADR19   ; 'd8(An,Rn.X)'
+MOVE.B  D0,Reg
+MOVE.B  #7,Mode
 
"!GADR24  CMPI.W  #AS38,D3       ; ',' ?
+BNE     AER1
+JSR     AsmGetSbl
+JSR     Test_Rn
+BNE     AER1
+CMPI    #8,D0
+SCS     IndType
+ANDI    #7,D0
+MOVE.B  D0,IndReg
+CMPI    #AS37,D3     ; '.'
+BNE     AER1
+
+MOVE.B  #4,IndSize
+CMPI.B  #'L',(A2)
+BEQ     GADR39
+CMPI.B  #'l',(A2)
+BEQ     GADR39
+
+MOVE.B  #2,IndSize
+CMPI.B  #'W',(A2)
+BEQ     GADR39
+CMPI.B  #'w',(A2)
+BNE     AER1
+
"GADR39   ADDQ.L  #1,A2
+JSR     AsmGetSbl
+BSR     TstScale
+CMPI.W  #AS2,D3      ; ')'
+BNE     AER1
+JMP     AsmGetSbl
 END
 END GetEA_U;
 
 PROCEDURE GetEA_U0;
 BEGIN
 ASSEMBLER  JSR     GetEA_U
 (*$ ? Asm20:
)MOVE.L  AsmOptions,D0
)BTST    #24,D0    ; $X in Options ?
)BNE     ok        ; Ja: 68020-EAs erlaubt
)MOVE.B  Mode,D0
)CMPI.B  #17,D0
)BEQ     err0
)CMPI.B  #18,D0
)BHI     err0
)BTST    #FlgIs20,M20Flg
)BEQ     ok
 err0     JMP     AERR21
 ok
 *)
 END
 END GetEA_U0;
 
 PROCEDURE GetEA;
 BEGIN
 ASSEMBLER  JSR     GetEA_U0
 
 (*$ ? Asm20:
 
 ; Test auf Bitfield (static/dynamic k-Factor bei FPU)
)JSR     AsmSameSbl
)CMPI    #AS_gKlA,D3    ; '{' ?
)BNE.L   NotBitField
)
)JSR     AsmGetSbl
)BSR.L   GetIndic
)MOVE.W  D1,-(A7)
)CMPI    #AS_dPnkt,D3    ; ':' ?
)BNE     TestFormatQualifier
)
)TST.W   (A7)+
)BNE     isRegO
)CMPI.L  #31,D0         ; als Data nur 0-31 erlaubt
)BHI.L   AER2
 isRegO   OR      D1,D0
)MOVE.B  D0,BitOffs
)JSR     AsmGetSbl
)BSR.L   GetIndic
)BNE     isRegW
)CMPI.L  #32,D0         ; als Data nur 1-32 erlaubt
)BHI.L   AER2
)TST     D0
)BEQ.L   AER2
)ANDI    #$1F,D0
 isRegW   OR      D1,D0
)MOVE.B  D0,BitWidth
)CMPI    #AS_gKlZ,D3    ; '}' ?
)BNE.L   AER1
)BSET    #6,Mode
)JMP     AsmGetSbl
 
 TestFormatQualifier
)MOVE.W  MODE,MODE2      ; 68881 Formatangaben
)TST.W   (A7)+
)BNE     isRegf
)
)MOVE.B  #30,MODE
)CMPI.L  #17,D0          ; Nur Werte von -64 ... +17 zulssig
)BGT     AER1
)CMPI.L  #-64,D0
)BLT     AER1
)ANDI.B  #$7F,D0
)BRA     testkzu
)
 isRegf
)MOVE.B  #29,MODE
 
 testkzu
)MOVE.B  D0,Format
)CMPI    #AS_gKlZ,D3    ; '}' ?
)BNE     AER1
)JMP     AsmGetSbl
 
 NotBitField
); Nun testen wir auf Doppelregister
)CMPI    #AS_dPnkt,D3   ; ':' ?
)BNE     NoDoubleReg
)
)MOVE.B  mode,-(A7)
)MOVE.B  reg,-(A7)      ; Data und DataType brauchen wir nicht retten
)JSR     AsmGetSbl
)JSR     GetEA_U0
)MOVE.B  reg,reg2
)MOVE.B  (A7)+,reg
)MOVE.B  Mode,mode2
)MOVE.B  (A7)+,mode
)BSET    #7,Mode
)RTS
)
 NoDoubleReg
)RTS
 
 AER1     JMP     AERR1
 AER2     JMP     AERR2
 AER13    JMP     AERR13
 
 GetIndic JSR     Test_Dn
)BNE     c1
)MOVEQ   #$20,D1        ; Markierung f. Register-Indizierung
)RTS
 c1       CMPI    #AS9,D3       ; '#' einfach ignorieren (bei k-Factor)
)BNE     c2
)JSR     AsmGetSbl
 c2       MOVE.L  Data,-(A7)     ; Data retten, da von GetExpr zerstrt
)MOVE    DataType,-(A7)
)JSR     GetExpr
)MOVE    DataType,D0
)ANDI    #1111111111010%,D0  ; nur Consts erlaubt
)BNE     AER13
)MOVE.L  Data,D0
)MOVE    (A7)+,DataType
)MOVE.L  (A7)+,Data
)MOVEQ   #0,D1
 *)
 END
 END GetEA;
 
 PROCEDURE RegTo0_2;
 BEGIN
 ASSEMBLER  OR.B    D0,D1
 END
 END RegTo0_2;
 
 PROCEDURE RegTo9_11;
 BEGIN
 ASSEMBLER  ANDI    #$FF,D0
)LSL     #4,D0
)LSL     #5,D0
)OR      D0,D1
 END
 END RegTo9_11;
)
 PROCEDURE SizeTo6_7;
 BEGIN
 ASSEMBLER  TST.B   D0
)BNE     OK
)JMP     AERR2
 OK       CMPI.B  #1,D0
)BEQ     ADR3A
)CMPI.B  #2,D0
)BEQ     ADR3B
)ORI     #$80,D1
)RTS
 ADR3B    ORI     #$40,D1
 !ADR3A   RTS
 END
 END SizeTo6_7;
 
 
 PROCEDURE VerifySize;
 BEGIN
 ASSEMBLER  CMP.B   SizeOfData,D0
)BEQ     C1
)TST.B   SizeOfData
)BEQ     C1
)JMP     AERR2
 C1       ;altes D0 bleibt erhalten
)RTS
 END
 END VerifySize;
 
 
 PROCEDURE LoadSize;
 BEGIN
 ASSEMBLER  MOVE.B  SizeOfData,D0
)BNE     C1
)MOVEQ   #DefltSiz,D0
 C1       CMPI.B  #4,D0
)BLS     ok
)JMP     AERR2
 ok
 END
 END LoadSize;
 
 
 PROCEDURE ErrIfSize;
 BEGIN
 ASSEMBLER  TST.B   SizeOfData
)BEQ     C1
)JMP     AERR2
 C1       RTS
 END
 END ErrIfSize;
 
 
 PROCEDURE SizeTo12_13;
 (* D0 nicht verndern ! *)
 BEGIN
 ASSEMBLER  CMPI.B  #1,D0
)BEQ     ADR10A
)CMPI.B  #4,D0
)BEQ     ADR10B
)ORI     #$3000,D1
)RTS
 !ADR10A  ORI     #$1000,D1
)RTS
 !ADR10B  ORI     #$2000,D1
 END
 END SizeTo12_13;
 
 
 PROCEDURE SizeTo9_10;           (* 00/01/10 *)
 BEGIN
 ASSEMBLER  CMPI.B  #1,D0
)BEQ     ADR10A
)CMPI.B  #4,D0
)BEQ     ADR10B
)BSET    #9,D1
)RTS
 adr10b   BSET    #10,D1
 adr10a
 END
 END SizeTo9_10;
 
 
 PROCEDURE Size2To9_10;           (* 01/10/11 *)
 BEGIN
 ASSEMBLER  ORI     #$0600,D1
)CMPI.B  #4,D0
)BEQ     ADR10A
)CMPI.B  #2,D0
)BEQ     ADR10B
)BCLR    #10,D1
)RTS
 adr10b   BCLR    #9,D1
 adr10a
 END
 END Size2To9_10;
 
 
 PROCEDURE ErrIfOp2;
 BEGIN
 ASSEMBLER  TST.B   ModeDest
)BEQ     OK
)JMP     AERR1
 !OK      RTS
 END
 END ErrIfOp2;
 
 
 (*
 *   <ea> nach D1, Bit 0-5
 *)
 PROCEDURE EAto0_5;
 BEGIN
 ASSEMBLER
)MOVE.W  D1,-(A7)
)CLR.W   D1
)MOVE.B  Mode,D0
)BEQ.L   JAER1          ;ERROR: Operand expected
)CMPI.B  #8,D0          ; d16,d24,(PC),#data ?
)BCC.L   ADREA1         ; ja ->
)
)CMPI.B  #6,D0          ; d16(An) ?
)BEQ     ADREA3         ; ja ->
)
)CMPI.B  #2,D0          ;'An' ?
)BNE     C1
)CMPI.B  #1,SizeOfData  ;'.B' ?
)BEQ.L   AER2           ;ERROR: Byteverarb. bei Adr-Reg. nicht zugel.
 C1       SUBQ.B  #1,D0
)LSL     #3,D0
)OR.B    D0,D1
)MOVE.B  Reg,D0
)JSR     RegTo0_2
 E0       OR.W    (A7)+,D1
)RTS
 
 ADREA3   TST.L   Data
)BNE     C1
)MOVE    DataType,D0
)ANDI    #0000001000111010%,D0  ; Konst., aber nicht explizit ?
)BEQ     C12
)
)MOVEQ   #3,D0          ; d16(An) -> (An) optimieren
)MOVE.B  D0,Mode
)BRA     C1
)
 C12      MOVEQ   #6,D0
)BRA     C1
)
 ADREA1   ORI.B   #111000%,D1
)CMPI.B  #13,D0
)BCC     ADREA11
)
)SUBQ.B  #8,D0
)OR.B    D0,D1
)ADDQ.B  #8,D0
)BRA     E0
 
 ADREA11  CMPI.B  #15,D0         ; 'CCR' ?
)BEQ     ADREA10
)CMPI.B  #13,D0         ; 'SR' ?
)BEQ     ADREA10
 
 JAER1    JMP     AERR1
 AER2     JMP     AERR2
 
 ADREA10  ORI.B   #4,D1
)BRA     E0
 END
 END EAto0_5;
 
 
 (* haenge D0.W im Code an *)
 PROCEDURE ApndD0_W;
 BEGIN
 ASSEMBLER
)ADDQ    #1,D5
)MOVE    D0,(A4)+
 END
 END ApndD0_W;
 
 (* haenge D0.L im Code an *)
 PROCEDURE ApndD0_L;
 BEGIN
 ASSEMBLER  ADDQ    #2,D5
)MOVE.L  D0,(A4)+
 END
 END ApndD0_L;
 
 (* hnge (D0.L).D im Code an *)
 PROCEDURE ApndD0I_D;
 BEGIN
 ASSEMBLER  ADDQ    #4,D5
)MOVE.L  A0,-(A7)
)MOVE.L  D0,A0
)MOVE.L  (A0)+,(A4)+
)MOVE.L  (A0) ,(A4)+
)MOVE.L  (A7)+,A0
 END
 END ApndD0I_D ;
 
 PROCEDURE TestType;
"BEGIN
"ASSEMBLER
)AND.W   DataType,D3
)BEQ     OK
)JMP     AERR13         ;'ILLEGAL ADRESSING MODE'
"OK
"END
"END TestType;
 
 
 PROCEDURE TestTypeSource;
"BEGIN
"ASSEMBLER
)AND.W   DataTypeSource,D3
)BEQ     OK
)JMP     AERR13         ;'ILLEGAL ADRESSING MODE'
"OK
"END
"END TestTypeSource;
 
 
 PROCEDURE TestTypeDest;
"BEGIN
"ASSEMBLER
)AND.W   DataTypeDest,D3
)BEQ     OK
)JMP     AERR13         ;'ILLEGAL ADRESSING MODE'
"OK
"END
"END TestTypeDest;
 
 
 PROCEDURE TestTypeThird;
"BEGIN
"ASSEMBLER
)AND.W   DataTypeThird,D3
)BEQ     OK
)JMP     AERR13         ;'ILLEGAL ADRESSING MODE'
"OK
"END
"END TestTypeThird;
 
 
 PROCEDURE CalcExpr; (* in D3 wird die Size des Datums in Byte uebergeben.
5* Wenn Bit 15 in D3 gesetzt, dann sind Labels unerlaubt
5* Wenn Bit 14 in D3 gesetzt, ist Wert vorzeichenbehaftet!
5* D3.B nicht verndern in dieser Routine ! *)
"BEGIN
"ASSEMBLER
+MOVE.W  DataType,D0
+ANDI.W  #1000010100000000%,D0        ; 8, 10 (lok. Lbl/Proc)
+BMI.W   UNKNOWN
+BNE.W   REL
 
+MOVE.W  DataType,D0
+ANDI.W  #0001000000000000%,D0        ; 12
+BNE.W   REALCONST
 
+; konst. bekannter Wert
+MOVE.L  Data,D0
 
"C11      CMPI.B  #1,D3
+BNE     C10
 
+BTST    #14,D3
+BNE     C112
 
+CMPI.L  #$100,D0
+BCS     E3
+CMPI.L  #$FFFFFF00,D0
+BHI     E3
"AER16    JMP     AERR16
 
"C112     CMPI.L  #$80,D0
+BCS     E3
+CMPI.L  #$FFFFFF80,D0
+BLS     AER16
 
"E3       ANDI.W  #$FF,D0
+RTS
 
"C10      CMPI.B  #2,D3
+BNE     E2
 
+BTST    #14,D3
+BNE     C122
 
+CMPI.L  #$10000,D0
+BCS     E2
+CMPI.L  #$FFFF0000,D0
+BLS     AER16
"E2       RTS
 
"C122     CMPI.L  #$8000,D0
+BCS     E2
+CMPI.L  #$FFFF8000,D0
+BLS     AER16
+RTS
 
 
"REALCONST
+MOVE.L  #Data,D0
+RTS
 
 
"REL      ; PC-rel. Wert ( bekanntes Label / bekannte lok. PROC. )
+MOVE.L  Data,D0
+ADD.L   CodeStart,D0
+SUB.L   pInstr,D0
+SUB.L   D5,D0
+SUB.L   D5,D0
 
+ORI     #$4000,D3
+BRA     C11
 
 
"AER2     JMP     AERR2
 
"UNKNOWN  ANDI.W  #0111111111111111%,D0
+BNE     RELPO
 
+; absolute Verkettung ( glob. PROCEDURE / VAR / TABLE )
+CMPI.B  #4,D3
+BNE     AER2
+MOVE.L  pInstr,D4
+SUB.L   CodeStart,D4
+ADD.L   D5,D4
+ADD.L   D5,D4
+MOVE.L  IDPtr,A0
+MOVE.L  (A0),D0
+MOVE.L  D4,(A0)
+RTS
"
"RELPO    ; PC-rel. Verkettung
+TST.W   D3
+BPL     OK
+
+JSR     PRTSTR
+DC.B    $D
+ACZ     'Internal Error #1'
+SYNC
+BREAK               ;interner ERROR: duerfte hier nicht mehr kommen
+
"OK       MOVEA.L IDPtr,A0
+SUBQ.L  #4,A0
+CMPI.B  #1,D3
+BNE     C2
"C1       SUBQ.L  #4,A0        ;verw. Byte-^, wenn Size = 1 Byte
"
"C2       MOVE.L  (A0),D0
+MOVE.L  pInstr,(A0)
+ADD.L   D5,(A0)
+ADD.L   D5,(A0)
+CMPI.B  #1,D3
+BNE     C4
+ADDQ.L  #1,(A0)
"
"C4       TST.L   D0
+BEQ     E0
+
+SUB.L   pInstr,D0
+SUB.L   D5,D0
+SUB.L   D5,D0
+CMPI.B  #1,D3
+BNE     C5
+SUBQ.L  #1,D0
+
"C5       ; Offset pruefen
+CMPI.B  #1,D3
+BNE     C3
+
+CMPI.L  #$80,D0
+BCS     E1
+CMPI.L  #$FFFFFF80,D0
+BCC     E1
+JMP     AERR3
+
"C3       CMPI.L  #$8000,D0
+BCS     E0
+CMPI.L  #$FFFF8000,D0
+BCC     E0
+JMP     AERR3
"
"E1       BCLR    #7,D0        ;Merker setzen fuer Byte-^
+ANDI.W  #$FF,D0
"E0       ANDI.L  #$FFFF,D0    ;bei Word-^ oberes Wort f. DC.L/#.L loeschen
+RTS
"END
"END CalcExpr;
 
 
 (*
 *   <ea> evtl. als Erweiterungswort an Code anhaengen
 *)
 PROCEDURE ApndEA;
 BEGIN
 ASSEMBLER
)MOVE.B  Mode,D0
)BEQ     JAER1          ;ERROR: Operand expected
)ANDI    #$3F,D0        ; Doppelregs und Bitfields erstmal ignorieren
)CMPI.B  #5,D0          ; d16,d24,(PC),#data ?
)BHI     C1             ; ja ->
 
 OK       RTS                    ; OK, keine Erweiterungworte anzufuegen
 
 C1       CMPI.B  #13,D0         ; SR,CCR,USP,VBR,Reglist ?
)BCC     OK             ; ja -> OK
)CMPI.B  #07,D0         ; 'd8(An,Rn.X)' / erw. 68020 Adr-Arten ?
)BEQ.L   INDX
)CMPI.B  #9,D0          ; 'd32' / 'd16' ?
)BEQ     D32
)CMPI.B  #11,D0         ; 'd8(PC,Rn.X)' ?
)BEQ.L   INDX
)CMPI.B  #12,D0         ; '#data' ?
)BEQ     IMM
)CMPI.B  #06,D0         ; 'd16(An)' ?
)BEQ     D16IND
)CMPI.B  #10,D0         ; 'd16(PC)' ?
)BEQ     D16IND
)
)JSR     PRTSTR
)DC.B    $D
)ACZ     'Internal Error #2'
)SYNC
)BREAK               ;interner ERROR: d16 aufgetreten
 
 JAER1    JMP     AERR1
 AER2     JMP     AERR2
 
 ; 'd32'
 D32      MOVE.W  #$8004,D3
)JSR     CalcExpr
 C6       JMP     ApndD0_L
 C6P      JMP     ApndD0I_D
 ; '#data'
 IMM      MOVE.B  SizeOfData,D3
)BNE     C4
)MOVEQ   #DefltSiz,D3
 C4       ORI.W   #$8000,D3      ; Ref. auf Label nicht erlaubt !
)JSR     CalcExpr
)CMPI.B  #4,D3          ; #.L ?
)BEQ     C6
)CMPI.B  #$10,D3        ; #.D ?
)BEQ     C6P
)CMPI.B  #$02,D3
)BHI     AER2
)JMP     ApndD0_W
 
 ; 'd16(An)'
 D16IND   MOVE.W  #$4002,D3
)CMPI.B  #10,D0       ; PC als Basereg. ?
)BEQ     D16PC
)ORI     #$8000,D3    ; Bei An als Basereg. rel. Adr. nicht zulassen
 D16PC    JSR     CalcExpr
)JMP     ApndD0_W
 
 GetXn    CLR.W   D0
)MOVE.B  IndReg,D0      ; Nummer (n) des 'Rn'
)ROR.W   #4,D0
)TST.B   IndType        ;'Rn': 'Dn' oder 'An' ?
)BNE     C2
)BSET    #15,D0         ;-> 'An'
 C2       CMPI.B  #2,IndSize     ;Size (X) des 'Rn.X'
)BEQ     C3
)BSET    #11,D0         ;-> 'Rn.L'
 C3       MOVE    D0,-(A7)
); Scaling eintragen
)MOVE.B  IndScale,D0
)SUBQ    #1,D0
)BTST    #1,D0
)BEQ     C21
)BCLR    #2,D0
)BNE     C21
)BCLR    #0,D0
 C21      LSL     #8,D0
)LSL     #1,D0
)OR      (A7)+,D0
)RTS
 
 ; 'd8(An,Rn.X)'
 INDX
 (*$ ? Asm20:
)BTST    #FlgIs20,M20Flg
)BNE     M20indx        ; erw. Adr-Arten der 68020 auswerten
 *)
)BSR     GetXn
)MOVE.W  D0,-(A7)
)MOVE.W  #$4001,D3
)MOVE.B  Mode,D0
)ANDI    #$3F,D0
)CMPI.B  #11,D0       ; PC als Basereg. ?
)BEQ     D8PC
)ORI     #$8000,D3    ; Bei An als Basereg. rel. Adr. nicht zulassen
 D8PC     JSR     CalcExpr
)ANDI.W  #$FF,D0
)OR.W    (A7)+,D0
 ApW      JMP     ApndD0_W
 
 (*$ ? Asm20:
 
 ApndDisp ; bestimmt Size fr Displacement (68020) und fgt an Code an
); vorher DataType und Data mit richtigen Daten laden !
); Default ist Long, nur bestimmte Datentypen werden als Wort behandelt
)
)MOVE    DataType,D0
)BTST    #12,D0
)BEQ     KeinReal
)JMP     AERR2
)
 KeinReal MOVEQ   #4,D3
)BTST    #2,D0                  ; Num. Konstante ?
)BEQ     TstTyp                 ; Nein
)
); Num. Konstante auf Gre untersuchen
)CMPI.L  #$8000,Data
)BCS     WordSize               ; 0 <= Data < $8000
)CMPI.L  #$FFFF8000,Data
)BCS     LongSize               ; Data < -$8000
)BRA     WordSize
)
 TstTyp   ANDI    #011100111001%,D0
)BEQ     LongSize
)
 WordSize MOVEQ   #2,D3
 LongSize JSR     CalcExpr
); D3 ist noch erhalten
)CMPI.B  #2,D3
)BEQ     ApW
)JMP     ApndD0_L
)
)
 M20indx  MOVE.L  A4,-(A7)       ; jetzige Code-Pos. merken f. Erw.-Wort
)ADDQ.L  #2,A4          ; zunchst berspringen
)MOVE.W  #0000000111010000%,D2  ; Default: all Operands suppressed
)BTST    #FlgAnPC,M20Flg
)BEQ     x0
)
); Base reg.
)BCLR    #7,D2          ; Base reg. added
)
 x0       BTST    #FlgXn,M20Flg
)BEQ     x1
)
); Index reg.
)BSR     GetXn
)BCLR    #6,D2          ; Index reg. added
)OR      D0,D2
)
 x1       BTST    #FlgBd,M20Flg
)BEQ     x2
)
); Base displacement
)BSR     ApndDisp
)BSET    #5,D2          ; Size = W or L
)CMPI.B  #2,D3          ; bd Size ?
)BNE     x2
)BCLR    #4,D2          ; W-Size setzen
 
 x2       BTST    #FlgeKlA,M20Flg
)BEQ     x3
)
); memory indirection
)
)BSET    #0,D2          ; Default: No outer displacement
)
)BTST    #FlgXn,M20Flg
)BEQ     x21
)BTST    #FlgPreIx,M20Flg
)BNE     x21
)
)BSET    #2,D2          ; Indirect Post-Indexed
)
 x21      BTST    #FlgOd,M20Flg
)BEQ     x3
)
); Outer displacement
)MOVE.L  DataOd,Data
)MOVE    DataTypeOd,DataType
)BSR     ApndDisp
)BSET    #1,D2          ; Size = W or L
)CMPI.B  #2,D3          ; bd Size ?
)BNE     x3
)BCLR    #0,D2          ; W-Size setzen
)
 x3       MOVE.L  (A7)+,A0       ; alte Code-Position zurckholen
)MOVE    D2,(A0)
 *)
 END
 END ApndEA;
 
 
 (*
!*   <ea> auf legale Adressierung pruefen
!*   folg. Kombinationen sind auschlielich erlaubt:
!*     (X:erlaubt, W:Word size, L:Long size, S:Size je nach Datengre)
 
(( 0) Const(Byte,Word)-   L W W W W W W   -    X   X X    W-Konstante
(( 1) External        - L L     L     L   -  X     X X    L-Konstante
(( 2) Numeric const.  - L L W W S W S S   -  X X   X X    W-Konstante
(( 3) Char            -   L W   W   W W   -        X X    W-Konstante
(( 4) Enum.Type       -   L W W W     W   -        X X    W-Konstante
(( 5) Record-Field    -   L W W W     W   -        X X    W-Konstante
(( 6) Glob.Var./Table - L L     L     L   -        X      abs. Pointer
(( 7) Glob.Procedure  - L L     L     L   -  X     X      abs. Pointer
(( 8) Label           -           W W W   -  X   X X X    rel. Pointer
(( 9) Lok.Variable    -   L W W W     W   -        X X    W-Konstante
((10) Lok.Procedure   -           W W W   -  X   X X X    rel. Pointer
((11) Const(Long)     - L L     L   L L   -  X     X      L-Konstante
((12) Real            -                 D -               D-Konstante
?^ ^ ^ ^ ^ ^ ^ ^ ^    ^ ^ ^ ^ ^
-d32         ------/ | | | | | | | |    | | | | |
-#d32        --------/ | | | | | | |    | | | | |
-#d16 / #d8  ----------/ | | | | | |    | | | | |
-d8/d16(An.. ------------/ | | | | |    | | | | |
&68020: bd - An     --------------/ | | | |    | | | | |
-d8/d16(PC.. ----------------/ | | |    | | | | |
&68020: bd - PC     ------------------/ | |    | | | | |
&68020: od          --------------------/ |    | | | | |
&68881: #d64        ----------------------/    | | | | |
T| | | | |
-JMP / JSR                --------------/ | | | |
-TRAP / STOP /LINK / BKPT ----------------/ | | |
-Bcc / DBcc / BSR         ------------------/ | |
-DC.L / MOVE / LEA / PEA / TRAPcc # ----------/ |
-DC.W / DC.B              ----------------------/
-TRAP / BKPT
-PACK / UNPK !!!
-TRAPcc !!!
!*
!* Regel : wenn d8(An/PC,Xn) erlaubt ist, dann sind auch erw. 68020
!*        Adr-Arten (..,An/PC..) erlaubt und mssen geprft werden
!*)
 PROCEDURE VerifyEA;
 BEGIN
 ASSEMBLER  MOVE.B  Mode,D0
)BEQ     JAER1          ;ERROR: Operand expected
)
)CMPI.B  #$3F,D0        ; Doppelregs und Bitfields mssen gelscht sein
)BHI     JAER1
)
)CMPI.B  #2,D0          ;'An' ?
)BNE     C1
)CMPI.B  #1,SizeOfData  ;'.B' ?
)BEQ     AER2           ;ERROR: Byteverarb. bei Adr-Reg. nicht zugel.
)
 C1       CMPI.B  #9,D0          ; 'd32' / 'd16' ?
)BEQ     D32
)CMPI.B  #06,D0         ; 'd16(An)' ?
)BEQ     INDA
)CMPI.B  #07,D0         ; 'd8(An,Rn.X)' ?
)BEQ     INDA
)CMPI.B  #10,D0         ; 'd16(PC)' ?
)BEQ     INDPC
)CMPI.B  #11,D0         ; 'd8(PC,Rn.X)' ?
)BEQ     INDPC
)CMPI.B  #12,D0         ; '#data' ?
)BEQ     IMM
)RTS
 
 JAER1    JMP     AERR1
 AER2     JMP     AERR2
 
 ; 'd16(An)' / 'd8(An,Rn.X)' / erw. 68020 Adr-Arten mit An als Baseregister
 INDA     MOVE.W  #1110111001010%,D3
)BTST    #FlgIs20,M20Flg        ; erw. Adr-Art ?
)BEQ     IndA2                  ; Nein -> Test f. d8/d16(An.. ausfhren
)MOVE.W  #1010100000000%,D3      ; bd testen, od braucht nicht !
 IndA2    JMP     TestType
 
 ; 'd16(PC)' / 'd8(PC,Rn.X)' / erw. 68020 Adr-Arten mit PC als Baseregister
 INDPC    MOVE.W  #1101011111010%,D3
)BTST    #FlgIs20,M20Flg        ; erw. Adr-Art ?
)BEQ     IndPC2                 ; Nein -> Test f. d8/d16(PC.. ausfhren
)MOVE.W  #1001011110010%,D3      ; bd testen, od braucht nicht !
 IndPC2   JMP     TestType
 
 ; 'd32'
 D32      MOVE.W  #1011100111001%,D3
)JMP     TestType
 
 ; '#data'
 IMM      MOVE.B  SizeOfData,D3
)BNE     IMMC2
)MOVEQ   #DefltSiz,D3
 IMMC2    CMPI.B  #1,D3
)BEQ     IMMC1
)CMPI.B  #2,D3
)BEQ     IMMC1
)CMPI.B  #$10,D3
)BEQ     IMMC3
)CMPI.B  #4,D3
)BNE     AER2
)MOVE.W  #1010100000000%,D3
)JMP     TestType
 IMMC1    MOVE.W  #1110111000010%,D3
)JMP     TestType
 IMMC3    MOVE.W  #0111111111111%,D3
)JMP     TestType
 END
 END VerifyEA;
 
 
 PROCEDURE ApndSource;
 BEGIN
 ASSEMBLER  JSR     SourceToLast
)JSR     VerifyEA
)JMP     ApndEA
 END
 END ApndSource;
 
 
 PROCEDURE ApndDest;
 BEGIN
 ASSEMBLER  JSR     DestToLast
)JSR     VerifyEA
)JMP     ApndEA
 END
 END ApndDest;
 
 
 PROCEDURE ApndThird;
 BEGIN
 ASSEMBLER  JSR     ThirdToLast
)JSR     VerifyEA
)JMP     ApndEA
 END
 END ApndThird;
 
 
 PROCEDURE SourceTo0_5;
 BEGIN
 ASSEMBLER  JSR     SourceToLast
+JSR     EATo0_5
+JMP     LastToSource
 END
 END SourceTo0_5;
 
 
 PROCEDURE DestTo0_5;
 BEGIN
 ASSEMBLER  JSR     DestToLast
+JSR     EATo0_5
+JMP     LastToDest
 END
 END DestTo0_5;
 
 
 PROCEDURE ThirdTo0_5;
 BEGIN
 ASSEMBLER  JSR     ThirdToLast
+JSR     EATo0_5
+JMP     LastToThird
 END
 END ThirdTo0_5;
 
 
 (*
 *   '#data' als 'd3' nach Bit 9-11 ( v. ADDQ / SUBQ / ASL / ROL / LSL usw. )
 *)
 PROCEDURE d3To9_11;
 BEGIN
 ASSEMBLER  MOVE.W  #1111111001010%,D3
)JSR     TestTypeSource
)MOVE.L  DataSource,D0
)CMPI.L  #9,D0
)BCS     OK
)JMP     AERR2
 !OK      ANDI.B  #$7,D0
)LSL     #3,D0
)LSL     #6,D0
)OR      D0,D1
 END
 END d3To9_11;
 
 
 PROCEDURE CheckModeSource;
 BEGIN
 ASSEMBLER  ; In D0.L mssen alle zugelassenen Modes als Bits bergeben werden
)MOVE    D2,-(A7)
)MOVE.B  modeSource,D2
)BEQ     AER1
)BTST    D2,D0
)BNE     ok
 AER1     JMP     AERR1
 ok       MOVE    (A7)+,D2
 END
 END CheckModeSource;
 
 
 PROCEDURE CheckModeDest;
 BEGIN
 ASSEMBLER  ; In D0.L mssen alle zugelassenen Modes als Bits bergeben werden
)MOVE    D2,-(A7)
)MOVE.B  modeDest,D2
)BEQ     AER1
)BTST    D2,D0
)BNE     ok
 AER1     JMP     AERR1
 ok       MOVE    (A7)+,D2
 END
 END CheckModeDest;
 
 
 PROCEDURE CheckModeThird;
 BEGIN
 ASSEMBLER  ; In D0.L mssen alle zugelassenen Modes als Bits bergeben werden
)MOVE    D2,-(A7)
)MOVE.B  modeThird,D2
)BEQ     AER1
)BTST    D2,D0
)BNE     ok
 AER1     JMP     AERR1
 ok       MOVE    (A7)+,D2
 END
 END CheckModeThird;
 
 
 PROCEDURE ErrOnOddAdr;
"BEGIN
"ASSEMBLER
+MOVE.W  A4,D0
+BTST    #0,D0
+BEQ     OK
+JMP     AERR9
"OK
"END
"END ErrOnOddAdr;
 
 
 FORWARD ASSM;
 
 PROCEDURE NextLine;
"BEGIN
"ASSEMBLER
+JSR     AsmSameSbl
+CMPI.W  #35,D3
+BEQ     L1
+TST     AsmMode        ;Assembler-Option noch Aktiv ?
+BEQ     L1             ;nein: SYNC und RTS
+JMP     ASSM           ;Ja:naechstes Symbol auswerten
"!L1      SF      DoingAsm
+JSR     ErrOnOddAdr
+JMP     AsmSameSbl
"END
"END NextLine;
 
 
 
 (*
 *   PSEUDO OPCODE
 *)
 PROCEDURE PseudoOp;
 BEGIN
 ASSEMBLER
)CLR.L   D5
)CMPI.W  #AS165,D3
)BEQ.L   MNBOMB
)CMPI.W  #AS157,D3
)BEQ     DCOP         ;%DC
)CMPI.W  #AS158,D3
)BEQ     DSOP         ;%DS
);CMPI.W  #AS160,D3
);BEQ.L   AEQU        ;%EQU
)CMPI.W  #AS161,D3
)BEQ.L   AACZ        ;%ACZ
)CMPI.W  #AS162,D3
)BEQ.L   ASYNC        ;%SYNC
)CMPI.W  #AS163,D3
)BEQ.L   AASC         ;%ASC
);CMPI.W  #AS164,D3
);BEQ.L   AACI         ;%ACI
)CMPI.W  #AS_STR,D3
)BEQ.L   ASTR         ;%STR
 AER4     JMP     AERR4
 AER2     JMP     AERR2
 AER7     JMP     AERR7
 AER18    JMP     AERR18       ; String too long
 
 !DSOP    JSR     AsmGetSbl
)JSR     GetExpr
)MOVE.W  DataType,D0
)BMI     AER7
)ANDI.W  #1001000100101%,D0
)BEQ     AER7
)MOVE.L  Data,D0
)CMPI.L  #$FFFF,D0
)BHI     AER2
)BRA     DSL1
 DSL0     CLR.B   (A4)+
 DSL1     DBRA    D0,DSL0
)JMP     NEXTLINE
 
 !DCOP    JSR     AsmGetSbl
)CMP.W   #AS37,D3        ;'.'?
)BEQ     OK4
)JMP     AERR2
 !OK4     JSR     FETNOSP
)ANDI.W  #$DF,D2      ;KLEINSCHRIFT WEG
)CMP.W   #'D',D2
)BEQ.L   DCD
)CMP.W   #'L',D2
)BEQ.L   DCL
)CMP.W   #'W',D2
)BEQ     DCW
)CMP.W   #'B',D2
)BNE     AER4
 
 !DCB     MOVE.L  A4,pInstr
)CLR     D5
)JSR     AsmGetSbl
)JSR     GetExpr
)MOVE.W  DataType,D3
)BTST    #12,D3
)BNE     AER2
)MOVEQ   #1,D3
)JSR     CalcExpr
)MOVE.B  D0,(A4)+
)JSR     AsmSameSbl
)CMPI.W  #AS38,D3
)BEQ     DCB           ;DC.B
)JMP     NextLine
 
 DCW      JSR     ErrOnOddAdr
)MOVE.L  A4,pInstr
)CLR     D5
)JSR     AsmGetSbl
)JSR     GetExpr
)MOVE.W  DataType,D3
)BTST    #12,D3
)BNE     AER2
)MOVEQ   #2,D3
)JSR     CalcExpr
)MOVE.W  D0,(A4)+
)JSR     AsmSameSbl
)CMPI.W  #AS38,D3
)BEQ     DCW           ;DC.W
)JMP     NextLine
 
 DCL      JSR     ErrOnOddAdr    ; DC.L
)MOVE.L  A4,pInstr
)CLR     D5
)JSR     AsmGetSbl
)JSR     GetExpr
)MOVE.W  DataType,D3
)BTST    #12,D3
)BNE     AER2
)MOVEQ   #4,D3
)JSR     CalcExpr
)MOVE.L  D0,(A4)+
)JSR     AsmSameSbl
)CMPI.W  #AS38,D3
)BEQ     DCL
)JMP     NextLine
 
 DCD      JSR     ErrOnOddAdr    ; DC.D
)MOVE.L  A4,pInstr
)CLR     D5
)JSR     AsmGetSbl
)JSR     GetExpr
)MOVE.W  DataType,D3
)BTST    #12,D3
)BEQ.L   AER2
)MOVEQ   #$10,D3
)JSR     CalcExpr
)MOVE.L  A0,-(A7)
)MOVE.L  D0,A0
)MOVE.L  (A0)+,(A4)+
)MOVE.L  (A0) ,(A4)+
)MOVE.L  (A7)+,A0
)JSR     AsmSameSbl
)CMPI.W  #AS38,D3
)BEQ     DCD
)JMP     NextLine
 
 AACZ     BSR     GENSTR         ; ACZ
)CLR.B   (A4)+
)CMPI.W  #AS38,D3       ; ','
)BEQ     AACZ
)JMP     NextLine
)
 ASYNC    JSR     AsmGetSbl
)JSR     PUT0
)JMP     NextLine
 
 AASC     BSR     GENSTR
)CMPI.W  #AS38,D3       ; ','
)BEQ     AASC
)JMP     NextLine
 
 ASTR     ADDQ.L  #1,A4
)MOVE.L  A4,-(A7)
 ASTR2    BSR     GENSTR
)CMPI.W  #AS38,D3       ; ','
)BEQ     ASTR2
)MOVE.L  A4,D0
)SUB.L   (A7),D0
)CMPI.L  #255,D0
)BHI     AER18          ; String too long
)MOVE.L  (A7)+,A0
)MOVE.B  D0,-1(A0)
)JMP     NextLine
)
 GENSTR   JSR     AsmGetSbl
)CMPI.W  #STRCONST,D3
)BNE     GenStr2
 GenStr0  MOVE    StrLen,D0
)LEA     STRBUF,A0
)BRA     GenSt
 GENLP    MOVE.B  (A0)+,(A4)+
 GenSt    DBRA    D0,GenLp
)JMP     AsmGetSbl
 GenStr2  JSR     ConFact
)MOVE.W  -2(A1,D2.L),D3
)CMPI.B  #3,D3          ; CHAR
)BEQ     GenStrS1
)CMPI.B  #18,D3         ; Alte Const
)BEQ     GenStrS1
)CMPI.B  #50,D3         ; Neue Const
)BEQ     GenStrS1
)CMPI.B  #27,D3         ; String-Const
)BEQ     GenStr0
)CMPI.B  #31,D3         ; String-Const
)BEQ     GenStr0
)BRA     AER4
 GenStrS1 MOVE.L  Accu,D0
)CMPI.L  #$FF,D0
)BHI     AER6
)MOVE.B  D0,(A4)+
)JMP     AsmGetSbl
 AER6     JMP     AERR6
 
 !MNBOMB  JSR     AsmGetSbl
)JSR     GetEA
)TST.B   Mode
)BEQ     AER1
)CMPI    #AS38,D3    ; ','
)BEQ     AER1
)JSR     PRTSTR
)DC.B    37,7,7,13,10
)ACZ     '<BOMB>: qualified user expected!'
)SYNC
)BRA     AER4
 
 AER1     JMP     AERR1
 END
 END PseudoOp;
 
 
 (*
 *   LABEL DEKLARATION, ALLE VORWAERTSREFERENZEN EINTRAGEN
 *)
 PROCEDURE LabelDecl;
 BEGIN
 ASSEMBLER
)TST.L   -6(A1,D2.L)
)BEQ     OK
)JMP     AERR12         ;Label bereits declariert
 !OK      MOVE.L  pInstr,-6(A1,D2.L) ;Adr.d.Labels
)MOVE.L  CodeStart,D0
)SUB.L   D0,-6(A1,D2.L) ;Rel.Adr. eintragen
)
)MOVE.L  -10(A1,D2.L),A0 ;^ auf Word-Offset-Kette
)CMPA.L  #0,A0
)BEQ     E0
)
 L1       MOVE.W  (A0),D0
)MOVE.L  pInstr,D1
)SUB.L   A0,D1
)CMPI.L  #$8000,D1
)BCS     C1
)CMPI.L  #$FFFF8000,D1
)BCC     C1
)JMP     AERR3          ;ERROR:'Branch too long'
 C1       MOVE.W  D1,(A0)
)
)ADDA.W  D0,A0
)TST.W   D0
)BNE     L1
)
 E0       MOVE.L  -14(A1,D2.L),A0 ;^ auf Byte-Offset-Kette
)CMPA.L  #0,A0
)BEQ     E1
)
 L2       MOVE.B  (A0),D0
)MOVE.L  pInstr,D1
)SUB.L   A0,D1
)
)BTST    #7,D0          ;Ist Bit 7 im Verkettungs-^ gesetzt ?
)BEQ     C3
)
)SUBQ.L  #1,D1          ;ja:'Bcc',Displacement wieder um 1 erniedrigen
)BNE     C4             ;Offset # 0 : OK
)
)JMP     AERR11         ;ERROR: 'Bcc.S' mit Offset = 0
 
 C3       ADDQ.L  #1,D1          ;nein: Displacement noch um 1 erhoehen
 
 C4       CMPI.L  #$80,D1
)BCS     C2
)CMPI.L  #$FFFFFF80,D1
)BCC     C2
)JMP     AERR3          ;ERROR:'Branch too long'
 C2       MOVE.B  D1,(A0)
)
)ORI.B   #$80,D0
)EXT.W   D0
)ADDA.W  D0,A0
)ANDI.B  #$7F,D0
)TST.B   D0
)BNE     L2
 
 E1
 END
 END LabelDecl;
 
 
 (*
 *   ID DEFINITION
 *)
 PROCEDURE LABELEXP;
 BEGIN
 ASSEMBLER
)JSR     AsmSameSbl
)TST.W   D3             ; TEST NOCHMAL,OB AUF SYMBOL REFERIERT
)BEQ     ZERO           ; NEIN:SYMBOL NOCH UNBEKANNT
)BPL     AER10          ; MODULA-WORT ->
)CMPI    #LabelID,D3
)BNE     ZERO
)JSR     LabelDecl      ; ID BEREITS BEKANNT -> FORWARD REF.
)BRA     c0
 
 !AER10   JMP     AERR10
 
 !ZERO    JSR     NewLabel
)MOVE.L  pInstr,-6(A1,D2.L) ; akt. Adr. dem Label zuweisen
)MOVE.L  CodeStart,D0
)SUB.L   D0,-6(A1,D2.L) ;Rel.Adr. eintragen
 c0       CMPI.B  #':',(A2)
)BNE     c1
)ADDQ.L  #1,A2          ; Ja -> berspringen
 c1       JSR     AsmGetSbl
)JMP     NextLine
 END
 END LABELEXP;
 
 
 PROCEDURE MneCodeTab;
 BEGIN
 ASSEMBLER  DC.L     1100000100000000%
)DC.L     1000000100000000%
)DC.L     1101000100000000%
)DC.L     1001000100000000%
)DC.L     1101000000000000%
)DC.L     1100000000000000%
)DC.L     1000000000000000%
)DC.L     1001000000000000%
)DC.L     1101000000000000%
)DC.L     1011000000000000%
)DC.L     1001000000000000%
)DC.L     0000000001000000%
)DC.L     0000011000000000%
)DC.L     0000110000000000%
)DC.L     0000010000000000%
)DC.L     0000001000000000%
)DC.L     0000101000000000%
)DC.L     0000000000000000%
)DC.L     0101000000000000%
)DC.L     0101000100000000%
)DC.L     1110000100000000%     ;%ASL
)DC.L     1110000000000000%     ;%ASR
)DC.L     1110001100001000%     ;%LSL
)DC.L     1110001000001000%     ;%LSR
)DC.L     1110011100011000%     ;%ROL
)DC.L     1110011000011000%     ;%ROR
)DC.L     1110010100010000%     ;%ROXL
)DC.L     1110010000010000%     ;%ROXR
)DC.L     0110010000000000%
)DC.L     0110010100000000%
)DC.L     0110011100000000%
)DC.L     0110110000000000%
)DC.L     0110111000000000%
)DC.L     0110001000000000%
)DC.L     0110111100000000%
)DC.L     0110001100000000%
)DC.L     0110110100000000%
)DC.L     0110101100000000%
)DC.L     0110011000000000%
)DC.L     0110101000000000%
)DC.L     0110100000000000%
)DC.L     0110100100000000%
)DC.L     0110000000000000%
)DC.L     0110000100000000%
)DC.L     0000000101000000%
)DC.L     0000000110000000%
)DC.L     0000000111000000%
)DC.L     0000000100000000%
)DC.L     0100000110000000%
)DC.L     1100000111000000%
)DC.L     1100000011000000%
)DC.L     1000000111000000%
)DC.L     1000000011000000%
)DC.L     0100001000000000%
)DC.L     0100010000000000%
)DC.L     0100000000000000%
)DC.L     0100011000000000%
)DC.L     0100101000000000%
)DC.L     1011000000000000%
)DC.L     1011000100001000%
)DC.L     0101010011001000%     ;%DBCC
)DC.L     0101010111001000%
)DC.L     0101011111001000%
)DC.L     0101000111001000%     ;%DBF
)DC.L     0101000111001000%
)DC.L     0101110011001000%
)DC.L     0101111011001000%
)DC.L     0101001011001000%
)DC.L     0101111011001000%
)DC.L     0101001111001000%
)DC.L     0101110111001000%
)DC.L     0101101111001000%
)DC.L     0101011011001000%
)DC.L     0101101011001000%
)DC.L     0101000011001000%
)DC.L     0101100011001000%
)DC.L     0101100111001000%
)DC.L     1011000000000000%
)DC.L     1100000100000000%
)DC.L     0100100010000000%     ;%EXT
)DC.L     0100111011000000%
)DC.L     0100111010000000%
)DC.L     0100100001000000%
)DC.L     0100000111000000%
)DC.L     0100111001010000%
)DC.L     0000000000000000%
)DC.L     0100100010000000%
)DC.L     0000000000001000%
)DC.L     0111000000000000%
)DC.L     0100100000000000%
)DC.L     0101010011000000%
)DC.L     0101010111000000%
)DC.L     0101011111000000%
)DC.L     0101000111000000%
)DC.L     0101110011000000%
)DC.L     0101111011000000%
)DC.L     0101001011000000%
)DC.L     0101111111000000%
)DC.L     0101001111000000%
)DC.L     0101110111000000%
)DC.L     0101101111000000%
)DC.L     0101011011000000%
)DC.L     0101101011000000%
)DC.L     0101000011000000%
)DC.L     0101100011000000%
)DC.L     0101100111000000%
)DC.L     0100101011000000%
)DC.L     0100111001110001%
)DC.L     0100111001110011%
)DC.L     0100111001110101%     ;%RTS
)DC.L     0100111001110110%
)DC.L     0100111001110000%
)DC.L     0100111001110010%
)DC.L     0100100001000000%
)DC.L     0100111001000000%
)DC.L     0100111001011000%
)DC.L     0100111001110111%
)DC.L     0101000111001000%     ;%DBRA (DBF)
)DC.L     $4AFC                 ;%ILLEGAL
)DC.L     $4AFC                 ;%BREAK
)DC.L     $4E7A                 ;%MOVEC
)DC.L     $4E74                 ;%RTD
)
 (*$ ? Asm20:
); Erweiterungen seit 3.3a / 1.8.86 f. 68020
)DC.L     1110101011000000%     ;%BFCHG
)DC.L     1110110011000000%     ;%BFCLR
)DC.L     1110101111000000%     ;%BFEXTS
)DC.L     1110100111000000%     ;%BFEXTU
)DC.L     1110110111000000%     ;%BFFFO
)DC.L     1110111111000000%     ;%BFINS
)DC.L     1110111011000000%     ;%BFSET
)DC.L     1110100011000000%     ;%BFTST
)DC.L     0100100001001000%     ;%BKPT
)DC.L     0000011011000000%     ;%CALLM
)DC.L     0000100011000000%     ;%CAS
)DC.L     0000100011111100%     ;%CAS2
)DC.L     0000000011000000%     ;%CHK2
)DC.L     0000000011000000%     ;%CMP2
)DC.L     1000000111000000%     ;%DIVSL Worte fr DIVS.W bzw DIVU.W
)DC.L     1000000011000000%     ;%DIVUL da in Mn-routien umgesetzt
'; DC.L     0100110001000000%     ;%DIVSL ???
'; DC.L     0100110001000000%     ;%DIVUL ???
)DC.L     0100100111000000%     ;%EXTB
)DC.L     0000111000000000%     ;%MOVES
)DC.L     1000000101000000%     ;%PACK
)DC.L     0000011011000000%     ;%RTM
)DC.L     0101010011111000%     ;%TRAPCC
)DC.L     0101010111111000%     ;%TRAPCS
)DC.L     0101011111111000%     ;%TRAPEQ
)DC.L     0101000111111000%     ;%TRAPF
)DC.L     0101110011111000%     ;%TRAPGE
)DC.L     0101111011111000%     ;%TRAPGT
)DC.L     0101001011111000%     ;%TRAPHI
)DC.L     0101111111111000%     ;%TRAPLE
)DC.L     0101001111111000%     ;%TRAPLS
)DC.L     0101110111111000%     ;%TRAPLT
)DC.L     0101101111111000%     ;%TRAPMI
)DC.L     0101011011111000%     ;%TRAPNE
)DC.L     0101101011111000%     ;%TRAPPL
)DC.L     0101000011111000%     ;%TRAPT
)DC.L     0101100011111000%     ;%TRAPVC
)DC.L     0101100111111000%     ;%TRAPVS
)DC.L     1000000110000000%     ;%UNPK
)
); Erweiterung fr 68881
)DC.L   00000000000000001111001000000000%     ;%FMOVE
)DC.L   01011100000000001111001000000000%     ;%FMOVECR
)DC.L   10000000000000001111001000000000%     ;%FMOVEM
)DC.L   00000000000000001111001101000000%     ;%FRESTORE
)DC.L   00000000000000001111001100000000%     ;%FSAVE
)DC.L   00000000000000001111001010000000%     ;%FNOP
)DC.L   00000000001110101111001000000000%     ;%FTST
)DC.L   00000000000000001111001010000001%     ;%FBEQ
)DC.L   00000000000000001111001010000000%     ;%FBF
)DC.L   00000000000000001111001010010011%     ;%FBGE
)DC.L   00000000000000001111001010010110%     ;%FBGL
)DC.L   00000000000000001111001010010111%     ;%FBGLE
)DC.L   00000000000000001111001010010010%     ;%FBGT
)DC.L   00000000000000001111001010010101%     ;%FBLE
)DC.L   00000000000000001111001010010100%     ;%FBLT
)DC.L   00000000000000001111001010001110%     ;%FBNE
)DC.L   00000000000000001111001010011100%     ;%FBNGE
)DC.L   00000000000000001111001010011001%     ;%FBNGL
)DC.L   00000000000000001111001010011000%     ;%FBNGLE
)DC.L   00000000000000001111001010011101%     ;%FBNGT
)DC.L   00000000000000001111001010011010%     ;%FBNLE
)DC.L   00000000000000001111001010011011%     ;%FBNLT
)DC.L   00000000000000001111001010010001%     ;%FBSEQ
)DC.L   00000000000000001111001010010000%     ;%FBSF
)DC.L   00000000000000001111001010011110%     ;%FBSNE
)DC.L   00000000000000001111001010011111%     ;%FBST
)DC.L   00000000000000001111001010000011%     ;%FBOGE
)DC.L   00000000000000001111001010000110%     ;%FBOGL
)DC.L   00000000000000001111001010000010%     ;%FBOGT
)DC.L   00000000000000001111001010000101%     ;%FBOLE
)DC.L   00000000000000001111001010000100%     ;%FBOLT
)DC.L   00000000000000001111001010000111%     ;%FBOR
)DC.L   00000000000000001111001010001111%     ;%FBT
)DC.L   00000000000000001111001010001011%     ;%FBUGE
)DC.L   00000000000000001111001010001001%     ;%FBUEQ
)DC.L   00000000000000001111001010001000%     ;%FBUN
)DC.L   00000000000000001111001010001010%     ;%FBUGT
)DC.L   00000000000000001111001010001101%     ;%FBULE
)DC.L   00000000000000001111001010001100%     ;%FBULT
)DC.L   00000000000000011111001001001000%     ;%FDBEQ
)DC.L   00000000000000001111001001001000%     ;%FDBF
)DC.L   00000000000100111111001001001000%     ;%FDBGE
)DC.L   00000000000101101111001001001000%     ;%FDBGL
)DC.L   00000000000101111111001001001000%     ;%FDBGLE
)DC.L   00000000000100101111001001001000%     ;%FDBGT
)DC.L   00000000000101011111001001001000%     ;%FDBLE
)DC.L   00000000000101001111001001001000%     ;%FDBLT
)DC.L   00000000000011101111001001001000%     ;%FDBNE
)DC.L   00000000000111001111001001001000%     ;%FDBNGE
)DC.L   00000000000110011111001001001000%     ;%FDBNGL
)DC.L   00000000000110001111001001001000%     ;%FDBNGLE
)DC.L   00000000000111011111001001001000%     ;%FDBNGT
)DC.L   00000000000110101111001001001000%     ;%FDBNLE
)DC.L   00000000000110111111001001001000%     ;%FDBNLT
)DC.L   00000000000100011111001001001000%     ;%FDBSEQ
)DC.L   00000000000100001111001001001000%     ;%FDBSF
)DC.L   00000000000111101111001001001000%     ;%FDBSNE
)DC.L   00000000000111111111001001001000%     ;%FDBST
)DC.L   00000000000000111111001001001000%     ;%FDBOGE
)DC.L   00000000000001101111001001001000%     ;%FDBOGL
)DC.L   00000000000000101111001001001000%     ;%FDBOGT
)DC.L   00000000000001011111001001001000%     ;%FDBOLE
)DC.L   00000000000001001111001001001000%     ;%FDBOLT
)DC.L   00000000000001111111001001001000%     ;%FDBOR
)DC.L   00000000000011111111001001001000%     ;%FDBT
)DC.L   00000000000010111111001001001000%     ;%FDBUGE
)DC.L   00000000000010011111001001001000%     ;%FDBUEQ
)DC.L   00000000000010001111001001001000%     ;%FDBUN
)DC.L   00000000000010101111001001001000%     ;%FDBUGT
)DC.L   00000000000011011111001001001000%     ;%FDBULE
)DC.L   00000000000011001111001001001000%     ;%FDBULT
)DC.L   00000000000000011111001001000000%     ;%FSEQ
)DC.L   00000000000000001111001001000000%     ;%FSF
)DC.L   00000000000100111111001001000000%     ;%FSGE
)DC.L   00000000000101101111001001000000%     ;%FSGL
)DC.L   00000000000101111111001001000000%     ;%FSGLE
)DC.L   00000000000100101111001001000000%     ;%FSGT
)DC.L   00000000000101011111001001000000%     ;%FSLE
)DC.L   00000000000101001111001001000000%     ;%FSLT
)DC.L   00000000000011101111001001000000%     ;%FSNE
)DC.L   00000000000111001111001001000000%     ;%FSNGE
)DC.L   00000000000110011111001001000000%     ;%FSNGL
)DC.L   00000000000110001111001001000000%     ;%FSNGLE
)DC.L   00000000000111011111001001000000%     ;%FSNGT
)DC.L   00000000000110101111001001000000%     ;%FSNLE
)DC.L   00000000000110111111001001000000%     ;%FSNLT
)DC.L   00000000000100011111001001000000%     ;%FSSEQ
)DC.L   00000000000100001111001001000000%     ;%FSSF
)DC.L   00000000000111101111001001000000%     ;%FSSNE
)DC.L   00000000000111111111001001000000%     ;%FSST
)DC.L   00000000000000111111001001000000%     ;%FSOGE
)DC.L   00000000000001101111001001000000%     ;%FSOGL
)DC.L   00000000000000101111001001000000%     ;%FSOGT
)DC.L   00000000000001011111001001000000%     ;%FSOLE
)DC.L   00000000000001001111001001000000%     ;%FSOLT
)DC.L   00000000000001111111001001000000%     ;%FSOR
)DC.L   00000000000011111111001001000000%     ;%FST
)DC.L   00000000000010111111001001000000%     ;%FSUGE
)DC.L   00000000000010011111001001000000%     ;%FSUEQ
)DC.L   00000000000010001111001001000000%     ;%FSUN
)DC.L   00000000000010101111001001000000%     ;%FSUGT
)DC.L   00000000000011011111001001000000%     ;%FSULE
)DC.L   00000000000011001111001001000000%     ;%FSULT
)DC.L   00000000000000011111001001111000%     ;%FTRAPEQ
)DC.L   00000000000000001111001001111000%     ;%FTRAPF
)DC.L   00000000000100111111001001111000%     ;%FTRAPGE
)DC.L   00000000000101101111001001111000%     ;%FTRAPGL
)DC.L   00000000000101111111001001111000%     ;%FTRAPGLE
)DC.L   00000000000100101111001001111000%     ;%FTRAPGT
)DC.L   00000000000101011111001001111000%     ;%FTRAPLE
)DC.L   00000000000101001111001001111000%     ;%FTRAPLT
)DC.L   00000000000011101111001001111000%     ;%FTRAPNE
)DC.L   00000000000111001111001001111000%     ;%FTRAPNGE
)DC.L   00000000000110011111001001111000%     ;%FTRAPNGL
)DC.L   00000000000110001111001001111000%     ;%FTRAPNGLE
)DC.L   00000000000111011111001001111000%     ;%FTRAPNGT
)DC.L   00000000000110101111001001111000%     ;%FTRAPNLE
)DC.L   00000000000110111111001001111000%     ;%FTRAPNLT
)DC.L   00000000000100011111001001111000%     ;%FTRAPSEQ
)DC.L   00000000000100001111001001111000%     ;%FTRAPSF
)DC.L   00000000000111101111001001111000%     ;%FTRAPSNE
)DC.L   00000000000111111111001001111000%     ;%FTRAPST
)DC.L   00000000000000111111001001111000%     ;%FTRAPOGE
)DC.L   00000000000001101111001001111000%     ;%FTRAPOGL
)DC.L   00000000000000101111001001111000%     ;%FTRAPOGT
)DC.L   00000000000001011111001001111000%     ;%FTRAPOLE
)DC.L   00000000000001001111001001111000%     ;%FTRAPOLT
)DC.L   00000000000001111111001001111000%     ;%FTRAPOR
)DC.L   00000000000011111111001001111000%     ;%FTRAPT
)DC.L   00000000000010111111001001111000%     ;%FTRAPUGE
)DC.L   00000000000010011111001001111000%     ;%FTRAPUEQ
)DC.L   00000000000010001111001001111000%     ;%FTRAPUN
)DC.L   00000000000010101111001001111000%     ;%FTRAPUGT
)DC.L   00000000000011011111001001111000%     ;%FTRAPULE
)DC.L   00000000000011001111001001111000%     ;%FTRAPULT
)DC.L   00000000001000101111001000000000%     ;%FADD
)DC.L   00000000001110001111001000000000%     ;%FCMP
)DC.L   00000000001000001111001000000000%     ;%FDIV
)DC.L   00000000001000011111001000000000%     ;%FMOD
)DC.L   00000000001000111111001000000000%     ;%FMUL
)DC.L   00000000001001011111001000000000%     ;%FREM
)DC.L   00000000001001101111001000000000%     ;%FSCALE
)DC.L   00000000001001001111001000000000%     ;%FSGLDIV
)DC.L   00000000001001111111001000000000%     ;%FSGLMUL
)DC.L   00000000001010001111001000000000%     ;%FSUB
)DC.L   00000000000110001111001000000000%     ;%FABS
)DC.L   00000000000111001111001000000000%     ;%FACOS
)DC.L   00000000000011001111001000000000%     ;%FASIN
)DC.L   00000000000010101111001000000000%     ;%FATAN
)DC.L   00000000000011011111001000000000%     ;%FATANH
)DC.L   00000000000111011111001000000000%     ;%FCOS
)DC.L   00000000000110011111001000000000%     ;%FCOSH
)DC.L   00000000000100001111001000000000%     ;%FETOX
)DC.L   00000000000010001111001000000000%     ;%FETOXM1
)DC.L   00000000000111101111001000000000%     ;%FGETEXP
)DC.L   00000000000111111111001000000000%     ;%FGETMAN
)DC.L   00000000000000011111001000000000%     ;%FINT
)DC.L   00000000000000111111001000000000%     ;%FINTRZ
)DC.L   00000000000101001111001000000000%     ;%FLOGN
)DC.L   00000000000001101111001000000000%     ;%FLOGNP1
)DC.L   00000000000101011111001000000000%     ;%FLOG10
)DC.L   00000000000101101111001000000000%     ;%FLOG2
)DC.L   00000000000110101111001000000000%     ;%FNEG
)DC.L   00000000000011101111001000000000%     ;%FSIN
)DC.L   00000000000000101111001000000000%     ;%FSINH
)DC.L   00000000000001001111001000000000%     ;%FSQRT
)DC.L   00000000000011111111001000000000%     ;%FTAN
)DC.L   00000000000010011111001000000000%     ;%FTANH
)DC.L   00000000000100101111001000000000%     ;%FTENTOX
)DC.L   00000000000100011111001000000000%     ;%FTWOTOX
)DC.L   00000000001100001111001000000000%     ;%FSINCOS
 *)
 END
 END MneCodeTab;
 
 
 PROCEDURE MneArgTab;
 BEGIN
 ASSEMBLER  DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0     ;%DBCC
)DC.B 0
)DC.B 0
)DC.B 0     ;%DBF
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0     ;%EXT
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0     ;%RTS
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0
)DC.B 0     ;%DBRA (DBF)
)DC.B 0     ;%ILLEGAL
)DC.B 0     ;%BREAK
)DC.B 0     ;%MOVEC
)DC.B 0     ;%RTD
 
 (*$ ? Asm20:
); Erweiterungen seit 3.3a / 1.8.86 f. 68020
)DC.B 0     ;%BFCHG
)DC.B 0     ;%BFCLR
)DC.B 0     ;%BFEXTS
)DC.B 0     ;%BFEXTU
)DC.B 0     ;%BFFFO
)DC.B 0     ;%BFINS
)DC.B 0     ;%BFSET
)DC.B 0     ;%BFTST
)DC.B 0     ;%BKPT
)DC.B 0     ;%CALLM
)DC.B 3     ;%CAS
)DC.B 3     ;%CAS2
)DC.B 0     ;%CHK2
)DC.B 0     ;%CMP2
)DC.B 0     ;%DIVSL
)DC.B 0     ;%DIVUL
)DC.B 0     ;%EXTB
)DC.B 0     ;%MOVES
)DC.B 3     ;%PACK
)DC.B 0     ;%RTM
)DC.B 0     ;%TRAPCC
)DC.B 0     ;%TRAPCS
)DC.B 0     ;%TRAPEQ
)DC.B 0     ;%TRAPF
)DC.B 0     ;%TRAPGE
)DC.B 0     ;%TRAPGT
)DC.B 0     ;%TRAPHI
)DC.B 0     ;%TRAPLE
)DC.B 0     ;%TRAPLS
)DC.B 0     ;%TRAPLT
)DC.B 0     ;%TRAPMI
)DC.B 0     ;%TRAPNE
)DC.B 0     ;%TRAPPL
)DC.B 0     ;%TRAPT
)DC.B 0     ;%TRAPVC
)DC.B 0     ;%TRAPVS
)DC.B 3     ;%UNPK
)
 ; Erweiterung fr 68881
)DC.B 0     ;%FMOVE               ; Umspeichern
)DC.B 0     ;%FMOVECR
)DC.B 0     ;%FMOVEM
)DC.B 0     ;%FRESTORE
)DC.B 0     ;%FSAVE
)DC.B 0     ;%FNOP
)DC.B 0     ;%FTST
)DC.B 0     ;%FBEQ                ; Controls
)DC.B 0     ;%FBF
)DC.B 0     ;%FBGE
)DC.B 0     ;%FBGL
)DC.B 0     ;%FBGLE
)DC.B 0     ;%FBGT
)DC.B 0     ;%FBLE
)DC.B 0     ;%FBLT
)DC.B 0     ;%FBNE
)DC.B 0     ;%FBNGE
)DC.B 0     ;%FBNGL
)DC.B 0     ;%FBNGLE
)DC.B 0     ;%FBNGT
)DC.B 0     ;%FBNLE
)DC.B 0     ;%FBNLT
)DC.B 0     ;%FBSEQ
)DC.B 0     ;%FBSF
)DC.B 0     ;%FBSNE
)DC.B 0     ;%FBST
)DC.B 0     ;%FBOGE
)DC.B 0     ;%FBOGL
)DC.B 0     ;%FBOGT
)DC.B 0     ;%FBOLE
)DC.B 0     ;%FBOLT
)DC.B 0     ;%FBOR
)DC.B 0     ;%FBT
)DC.B 0     ;%FBUGE
)DC.B 0     ;%FBUEQ
)DC.B 0     ;%FBUN
)DC.B 0     ;%FBUGT
)DC.B 0     ;%FBULE
)DC.B 0     ;%FBULT
)DC.B 0     ;%FDBEQ
)DC.B 0     ;%FDBF
)DC.B 0     ;%FDBGE
)DC.B 0     ;%FDBGL
)DC.B 0     ;%FDBGLE
)DC.B 0     ;%FDBGT
)DC.B 0     ;%FDBLE
)DC.B 0     ;%FDBLT
)DC.B 0     ;%FDBNE
)DC.B 0     ;%FDBNGE
)DC.B 0     ;%FDBNGL
)DC.B 0     ;%FDBNGLE
)DC.B 0     ;%FDBNGT
)DC.B 0     ;%FDBNLE
)DC.B 0     ;%FDBNLT
)DC.B 0     ;%FDBSEQ
)DC.B 0     ;%FDBSF
)DC.B 0     ;%FDBSNE
)DC.B 0     ;%FDBST
)DC.B 0     ;%FDBOGE
)DC.B 0     ;%FDBOGL
)DC.B 0     ;%FDBOGT
)DC.B 0     ;%FDBOLE
)DC.B 0     ;%FDBOLT
)DC.B 0     ;%FDBOR
)DC.B 0     ;%FDBT
)DC.B 0     ;%FDBUGE
)DC.B 0     ;%FDBUEQ
)DC.B 0     ;%FDBUN
)DC.B 0     ;%FDBUGT
)DC.B 0     ;%FDBULE
)DC.B 0     ;%FDBULT
)DC.B 0     ;%FSEQ
)DC.B 0     ;%FSF
)DC.B 0     ;%FSGE
)DC.B 0     ;%FSGL
)DC.B 0     ;%FSGLE
)DC.B 0     ;%FSGT
)DC.B 0     ;%FSLE
)DC.B 0     ;%FSLT
)DC.B 0     ;%FSNE
)DC.B 0     ;%FSNGE
)DC.B 0     ;%FSNGL
)DC.B 0     ;%FSNGLE
)DC.B 0     ;%FSNGT
)DC.B 0     ;%FSNLE
)DC.B 0     ;%FSNLT
)DC.B 0     ;%FSSEQ
)DC.B 0     ;%FSSF
)DC.B 0     ;%FSSNE
)DC.B 0     ;%FSST
)DC.B 0     ;%FSOGE
)DC.B 0     ;%FSOGL
)DC.B 0     ;%FSOGT
)DC.B 0     ;%FSOLE
)DC.B 0     ;%FSOLT
)DC.B 0     ;%FSOR
)DC.B 0     ;%FST
)DC.B 0     ;%FSUGE
)DC.B 0     ;%FSUEQ
)DC.B 0     ;%FSUN
)DC.B 0     ;%FSUGT
)DC.B 0     ;%FSULE
)DC.B 0     ;%FSULT
)DC.B 0     ;%FTRAPEQ
)DC.B 0     ;%FTRAPF
)DC.B 0     ;%FTRAPGE
)DC.B 0     ;%FTRAPGL
)DC.B 0     ;%FTRAPGLE
)DC.B 0     ;%FTRAPGT
)DC.B 0     ;%FTRAPLE
)DC.B 0     ;%FTRAPLT
)DC.B 0     ;%FTRAPNE
)DC.B 0     ;%FTRAPNGE
)DC.B 0     ;%FTRAPNGL
)DC.B 0     ;%FTRAPNGLE
)DC.B 0     ;%FTRAPNGT
)DC.B 0     ;%FTRAPNLE
)DC.B 0     ;%FTRAPNLT
)DC.B 0     ;%FTRAPSEQ
)DC.B 0     ;%FTRAPSF
)DC.B 0     ;%FTRAPSNE
)DC.B 0     ;%FTRAPST
)DC.B 0     ;%FTRAPOGE
)DC.B 0     ;%FTRAPOGL
)DC.B 0     ;%FTRAPOGT
)DC.B 0     ;%FTRAPOLE
)DC.B 0     ;%FTRAPOLT
)DC.B 0     ;%FTRAPOR
)DC.B 0     ;%FTRAPT
)DC.B 0     ;%FTRAPUGE
)DC.B 0     ;%FTRAPUEQ
)DC.B 0     ;%FTRAPUN
)DC.B 0     ;%FTRAPUGT
)DC.B 0     ;%FTRAPULE
)DC.B 0     ;%FTRAPULT
)DC.B 0     ;%FADD                ; Dyadic Operations
)DC.B 0     ;%FCMP
)DC.B 0     ;%FDIV
)DC.B 0     ;%FMOD
)DC.B 0     ;%FMUL
)DC.B 0     ;%FREM
)DC.B 0     ;%FSCALE
)DC.B 0     ;%FSGLDIV
)DC.B 0     ;%FSGLMUL
)DC.B 0     ;%FSUB
)DC.B 0     ;%FABS                ; Monidic Operations
)DC.B 0     ;%FACOS
)DC.B 0     ;%FASIN
)DC.B 0     ;%FATAN
)DC.B 0     ;%FATANH
)DC.B 0     ;%FCOS
)DC.B 0     ;%FCOSH
)DC.B 0     ;%FETOX
)DC.B 0     ;%FETOXM1
)DC.B 0     ;%FGETEXP
)DC.B 0     ;%FGETMAN
)DC.B 0     ;%FINT
)DC.B 0     ;%FINTRZ
)DC.B 0     ;%FLOGN
)DC.B 0     ;%FLOGNP1
)DC.B 0     ;%FLOG10
)DC.B 0     ;%FLOG2
)DC.B 0     ;%FNEG
)DC.B 0     ;%FSIN
)DC.B 0     ;%FSINH
)DC.B 0     ;%FSQRT
)DC.B 0     ;%FTAN
)DC.B 0     ;%FTANH
)DC.B 0     ;%FTENTOX
)DC.B 0     ;%FTWOTOX
)DC.B 0     ;%FSINCOS             ; Dual Monadic Operation
 *)
 END
 END MneArgTab;
 
 
 FORWARD MneJmpTab;
 
 
 PROCEDURE ASSM;
"BEGIN
$ASSEMBLER
)MOVE.L  OPTIONS,D2
)MOVE.L  D2,AsmOPTIONS
)LSR     #1,D2          ;Soll BREAK erfolgen ?
)SCS     BreakAgain
)BCC     C0             ;nein
)LSL     #1,D2
)MOVE.L  D2,AsmOPTIONS
)MOVE.L  D2,OPTIONS
)BREAK
 
 C0       CLR     GetLastSbl
)
);Default-Sprungweite fuer Bcc bestimmen:
)MOVE.L  OPTIONS,D0
)BTST    #04,D0         ;Test auf Debug-Option
)BEQ     C1             ;Nein
)MOVE.B  #2,DefltBcc    ; '.W'
)BRA     C2
 C1       MOVE.B  #1,DefltBcc    ; '.B'
 
 C2       MOVE.L  A4,pInstr
)MOVE.L  pLastSym,pTxtMne
)MOVE.L  pTxtLin,pTxtLin2  ;Zeilenbeginn retten
)MOVE.L  TxtLine,TxtLine2  ;Zeilennr. retten
)ST      DoingAsm
)CLR.B   OprndCnt
)
)JSR     AsmSameSbl
)TST.W   D3
)BEQ     JAL1            ;:UNBEKANNTES SYMBOL
)BMI     JAL1            ;:AUF LABEL WIRD SCHON REFERIERT
)
)CMPI    #AS39,D3        ; '!' ? (LABELDECLARATION ?)
)BNE     TPSOP           ;NEIN >
)
)JSR     AsmGetSbl       ;JA
 
 !JAL1    JMP     LABELEXP        ;>ID ERWARTET
 
 !TPSOP   CMPI    #AS_MneF,D3
)BCC     L1
 
 AER10    JMP     AERR10        ;SYMBOL = SONDERZEICHEN > ERROR
)
 !L1      CMPI    #AS_MneL,D3
)BLS     L2            ;->Mnemonic
)CMPI    #AS_m20F,D3
)BCS     PsOp
)CMPI    #AS_m20L,D3
)BHI     AER10         ;->ERROR
)MOVE.L  AsmOptions,D0
)BTST    #24,D0
)BNE     L1C1
)JMP     AERR17         ; '68020 mnemonic not allowed'
 L1C1     SUBI    #AS_M20F-AS_MneL-1,D3
)BRA     L2             ;->Mnemonic
)
 psop     JMP     PseudoOp       ;PSEUDO-OP GEFUNDEN
 
 (*$ ? Gepard:
 AER15    JMP     AERR15         ;Fehlermeldung bei RTE
 *)
 
 !L2      JSR     ErrOnOddAdr
)
)SUBI    #AS_MneF,D3    ;D3:=Mnemonic-Nr.
)LEA     MneArgTab,A0   ;Tabelle fr Anzahl d. Argumente
)MOVE.B  0(A0,D3.W),D0
)MOVE.B  D0,Args
)LSL.L   #2,D3          ;D3:=Mnemonic-Nr. mal 4
)LEA     MneCodeTab,A0  ;Anf. Tabelle der Opcodes
)
)(*$ ? Gepard:
+MOVE.L  0(A0,D3.W),D0
+CMPI.W  #$4E73,D0      ;Ist Mnemonic = RTE ?
+BEQ     AER15          ;Ja:ERROR
+MOVE.L  D0,MneSecCode
)*)
)
)(*$ ? Atari:
+MOVE.L  0(A0,D3.W),MneSecCode
)*)
)
)LEA     MneJmpTab,A0   ;Anfang der Sprungtabelle
)MOVE.L  0(A0,D3.W),D0  ;Sprungvektor des Befehls
)CMPI.L  #NoOperandsWZE,D0 ;Test,ob der Befehl Operanden erwartet
)BEQ     NOpWZE
)CMPI.L  #NoOperands,D0 ;Test,ob der Befehl Operanden erwartet
)BNE     WithOprd
)
)JSR     AsmGetSbl
)MOVE.W  MneCode,(A4)+
)BRA.L   JRET1          ;kein Operand erwartet,-> zum naechsten Befehl
 
 NOpWZE   JSR     AsmGetSbl
)MOVE.W  MneCode,(A4)+
)CLR.W   (A4)+
)BRA.L   JRET1          ;kein Operand erwartet,-> zum naechsten Befehl
 
 WithOprd MOVE.L  D0,MneVec      ;rette Sprungvektor fuer Operanden-Auswertung
)CLR.L   ModeDest
)
)MOVEQ   #0,D0
)JSR     GetSize
)
)CLR     ModeSource
)CLR     ModeDest
)CLR     ModeThird
)
)JSR     AsmGetSbl
)MOVE.L  pLastSym,pTxtOp1
)ADDQ.B  #1,OprndCnt
)JSR     GetEA
)JSR     LastToSource
)
)JSR     AsmSameSbl
)CMPI    #AS38,D3       ; KOMMA ?
)BNE     ASSML4
)
)JSR     AsmGetSbl
)MOVE.L  pLastSym,pTxtOp2
)ADDQ.B  #1,OprndCnt
)JSR     GetEA
)JSR     LastToDest
)TST.B   ModeDest
)BEQ.L   JAER1          ; ERROR: fehlender Operand nach Komma
)
)CMPI.B  #3,Args
)BNE     AssmL4
)
)JSR     AsmSameSbl
)CMPI    #AS38,D3       ; KOMMA ?
)BNE.L   JAER1
)
)JSR     AsmGetSbl
)MOVE.L  pLastSym,pTxtOp3
)ADDQ.B  #1,OprndCnt
)JSR     GetEA
)JSR     LastToThird
)TST.B   ModeThird
)BEQ.L   JAER1          ; ERROR: fehlender Operand nach Komma
)
 ASSML4   CLR.B   OprndCnt
)JSR     SourceToLast
)MOVE.L  MneSecCode,D1
)ADDQ.L  #2,A4
)MOVEA.L MneVec,A0
)MOVEQ   #1,D5
)TST.B   BreakAgain
)BEQ     nobrk2
)BREAK
 noBrk2   JSR     (A0)
)MOVE.L  pInstr,A0
)MOVE    D1,(A0)
 JRET1    JMP     NextLine
 JAER1    JMP     AERR1
 END
 END ASSM;
 
 
 (****************************************************************************
0BEGINN DER INDIVIDUELLEN MNEMONIC - AUSWERTUNG
 ****************************************************************************)
 
 
 PROCEDURE MN31A;
 BEGIN
 ASSEMBLER  MOVE.B  ModeSource,D0
)CMPI.B  #1,D0          ; S: 'Dn' ?
)BEQ     MN0A
)CMPI.B  #5,D0          ; S: '-(An)' ?
)BEQ     OK
 !AER1    JMP     AERR1
 !OK      MOVE.B  RegSource,D0
)JSR     RegTo0_2
)MOVE.B  ModeDest,D0
)CMPI.B  #5,D0          ; D: '-(An)' ?
)BNE     AER1
)MOVE.B  RegDest,D0
)JSR     RegTo9_11
)BSET    #3,D1
)RTS
 !MN0A    MOVE.B  RegSource,D0
)JSR     RegTo0_2
)MOVE.B  ModeDest,D0
)CMPI.B  #1,D0          ; D: 'Dn' ?
)BNE     AER1
)MOVE.B  RegDest,D0
)JMP     RegTo9_11
 END
 END MN31A;
 
 (*
 *  %ADDX, %SUBX
 *)
 PROCEDURE MN31;
 BEGIN
 ASSEMBLER  JSR     LoadSize
)JSR     SizeTo6_7
)JMP     MN31A
 END
 END MN31;
 
 (* %ABCD, %SBCD *)
 PROCEDURE MN0;
 BEGIN
 ASSEMBLER  MOVEQ   #1,D0
)JSR     VerifySize
)JMP     MN31A
 END
 END MN0;
 
 (*$ ? Asm20:
 
 (* %PACK, %UNPK *)
 PROCEDURE MnePACK_UNPK;
 BEGIN
 ASSEMBLER  JSR     ErrIfSize
)JSR     MN31A
)CMPI.B  #12,ModeThird
)BNE     AER1
)MOVE.W  #1111111111010%,D3
)JSR     TestTypeThird
)MOVE.L  DataThird,D0
)JMP     ApndD0_W
 AER1     JMP     AERR1
 END
 END MnePACK_UNPK;
 
 *)
 
 (* %ADD %SUB %AND %OR *)
 PROCEDURE MN1;
 BEGIN
 ASSEMBLER
)JSR     LoadSize
)JSR     SizeTo6_7
)CMPI.B  #1,ModeDest    ;ist Dest. = DataReg ?
)BNE     MN1B           ;Nein -> weiter testen
)
)MOVE.B  RegDest,D0
)JSR     RegTo9_11
)JSR     SourceTo0_5
)JMP     ApndSource
 
 AER1     JMP AERR1
 
 MN1B     CMPI.B  #1,ModeSource  ;Ist Source = Data.Reg. ?
)BNE     AER1           ;Nein ->ERROR
)CMPI.B  #2,ModeDest    ;ist Dest. = Adr-Reg.?
)BEQ     AER1           ;ja -> ERROR
)CMPI.B  #10,ModeDest
)BCC     AER1
)
)MOVE.B  RegSource,D0
)JSR     RegTo9_11
)BSET    #8,D1
)JSR     DestTo0_5
)JMP     ApndDest
 END
 END MN1;
 
 (* %ADDA, %SUBA, %CMPA *)
 PROCEDURE MN2;
 BEGIN
 ASSEMBLER  MOVE.B  ModeDest,D0
)CMPI.B  #2,D0          ; D: 'An' ?
)BEQ     OK1
)JMP     AERR1
 !OK1     JSR     LoadSize
)CMPI.B  #2,D0          ; Size # BYTE ?
)BEQ     MN2A
)CMPI.B  #4,D0
)BEQ     OK
)JMP     AERR2
 !OK      BSET    #8,D1
 MN2A     BSET    #7,D1
)BSET    #6,D1
)JSR     SourceTo0_5
)JSR     ApndSource
)MOVE.B  RegDest,D0
)JMP     RegTo9_11
 END
 END MN2;
 
 
 PROCEDURE @MN3;
 BEGIN
 ASSEMBLER  JSR     LoadSize
)JSR     SizeTo6_7
)CMPI.B  #12,ModeSource   ; S: '#' ?
)BEQ     OK1
)JMP     AERR1
 !OK1     JSR     ApndSource
)JSR     DestTo0_5
)JMP     ApndDest
 END
 END @MN3;
 
 
 (*
 *   %ADDI, %SUBI
 *)
 PROCEDURE MN3;
 BEGIN
 ASSEMBLER
)MOVE.L  #0001111111010%,D0
)JSR     CheckModeDest
)JMP     @MN3
 END
 END MN3;
 
 (*
 *   %CMPI
 *)
 PROCEDURE MneCMPI;
 BEGIN
 ASSEMBLER
)MOVE.L  #0001111111010%,D0
)MOVE.L  AsmOptions,D2
)BTST    #24,D2
)BEQ     ok0
)ORI.L   #0110000000000%,D0     ; 68020 kann auch PC-rel.
 ok0      JSR     CheckModeDest
)JMP     @MN3
 END
 END MneCMPI;
 
 (*
 * %ANDI, %EORI, %ORI
 *)
 PROCEDURE MN4;
 BEGIN
 ASSEMBLER  MOVE.B  ModeDest,D0
)CMPI.B  #13,D0         ;'SR' ?
)BEQ     C2
)CMPI.B  #15,D0         ;'CCR' ?
)BEQ     C1
)JMP     MN3            ;weiter wie ADDI,CMPI,SUBI
 C1       MOVEQ   #1,D0          ; CCR : BYTE-Operation
)BRA     C3
 C2       MOVEQ   #2,D0          ; SR : WORD-Operation
 C3       JSR     VerifySize
)MOVE.B  D0,SizeOfData
)JMP     @MN3
 END
 END MN4;
 
 (*
 *   %ADDQ, %SUBQ
 *)
 PROCEDURE MN5;
 BEGIN
 ASSEMBLER  CMPI.B  #12,ModeSource
)BEQ     OK
 !AER1    JMP     AERR1
 !OK      JSR     LoadSize
)JSR     SizeTo6_7
)JSR     d3To9_11       ; # - Konstante eintragen in D1
@; Hier erfolgt auch Pruefung der Datengroesse
)MOVE.B  ModeDest,D0
)CMPI.B  #10,D0
)BCC     AER1
)JSR     DestTo0_5
)JMP     ApndDest
 END
 END MN5;
 
 (*
 *   %ASL, %ASR, %LSL, %LSR, %ROL, %ROR, %ROXL, %ROXR
 *)
 PROCEDURE MN6;
 BEGIN
 ASSEMBLER  JSR     LoadSize
)JSR     SizeTo6_7
)MOVE.B  ModeSource,D0
)CMPI.B  #1,D0          ; S: 'Dn' ?
)BEQ     MN6A
)CMPI.B  #12,D0         ; S: '#' ?
)BNE     MN6B
)
); '#d3,Dn'
)ANDI.W  #$F1FF,D1
)MOVE.W  #1111111101010%,D3
)JSR     TestTypeSource
)JSR     d3To9_11       ; # - Konstante eintragen in D1
@; Hier erfolgt auch Pruefung der Datengroesse
)MOVE.B  ModeDest,D0
)CMPI.B  #1,D0          ; D: 'Dn' ?
)BEQ     OK
 !AER1    JMP     AERR1
 !OK      MOVE.B  RegDest,D0
)JMP     RegTo0_2
 
 MN6A     ; 'Dn,Dn'
)ANDI.W  #$F1FF,D1
)BSET    #5,D1
)MOVE.B  RegSource,D0
)JSR     RegTo9_11
)MOVE.B  ModeDest,D0
)CMPI.B  #1,D0          ; S: 'Dn' ?
)BNE     AER1
)MOVE.B  RegDest,D0
)JMP     RegTo0_2
 
 AER2     JMP     AERR2
 
 MN6B     ; '<ea>'
)CMPI.B  #10,D0
)BCC     AER1
)CMPI.B  #2,D0          ; S: 'An' ?
)BEQ     AER1
)JSR     LoadSize
)CMPI.B  #2,D0          ; nur WORD ist erlaubt
)BNE     AER2
)ANDI.W  #$FFC0,D1
)BSET    #6,D1
)BSET    #7,D1
)MOVE.W  #1010010011001%,D3
)JSR     TestTypeSource
)JSR     SourceTo0_5
)JSR     ApndSource
)JMP     ErrIfOp2
 END
 END MN6;
 
 
 (*
 *   Hauptroutine fuer Bcc und DBcc
 *)
 PROCEDURE @MN7A;
 BEGIN
 ASSEMBLER  MOVE.W  DataType,D3
)BMI.L   C1             ;undefined Label / lokal Proc.
)
)MOVE.L  Data,D0
)BTST    #8,D3
)BNE     C2             ;lok. Label
)BTST    #10,D3         ;lok. Proc.
)BEQ     AER5           ;ERROR:label expected
)
 C2       ADD.L   CodeStart,D0
)MOVE.L  pInstr,D2
)ADD.L   D5,D2          ; Achtung: normalerweise wird hier 2 addiert,
)ADD.L   D5,D2          ; bei FDBcc wird 4 addiert !!
)
 C8       SUB.L   D2,D0
)
)CMPI.L  #$8000,D0
)BCS     C3
)CMPI.L  #$FFFF8000,D0
)BCC     C3
)
 AER3     JMP     AERR3
 AER5     JMP     AERR5
 AER2     JMP     AERR2
 
 C3       CMPI.L  #$80,D0
)BCS     C4
)CMPI.L  #$FFFFFF80,D0
)BCC     C4
)
)TST.B   SizeOfData
)BEQ     C5
)CMPI.B  #8,SizeOfData  ; '.S'
)BHI     AER2
)BEQ     AER3
)CMPI.B  #1,SizeOfData  ; '.B'
)BEQ     AER3
 
 C5       JMP     ApndD0_W
 
 C4       TST.B   SizeOfData
)BEQ     C9
)CMPI.B  #4,SizeOfData  ; '.L'
)BEQ     C5
)CMPI.B  #2,SizeOfData  ; '.W'
)BEQ     C5
)CMPI.B  #8,SizeOfData  ; '.S'
)BEQ     C9
)CMPI.B  #1,SizeOfData  ; '.B'
)BNE     AER2
 C9       MOVE.B  D0,D1
)RTS
 
 ; Forward Ref. to Label / lokal Proc.
 C1       BTST    #10,D3         ;lok. Proc.?
)BNE     C7
)BTST    #08,D3         ;undefined Label ?
)BEQ     AER5
)
 ;Forw.Ref to Label
)TST.B   SizeOfData
)BNE     C10
)MOVE.B  DefltBcc,SizeOfData
 C10      CMPI.B  #1,SizeOfData  ; '.B'
)BEQ     C11
)CMPI.B  #8,SizeOfData  ; '.S'
)BEQ     C11
)BHI     AER2
); Long-Bcc
)MOVEA.L IDPtr,A0
)SUBQ.L  #4,A0
)BRA     C12
)
); Short-Bcc
 C11      MOVEA.L IDPtr,A0
)SUBQ.L  #8,A0
)
)MOVEQ   #1,D2
)MOVE.L  (A0),D0        ;Word-Verkettungspointer merken
)BNE     C14
)
)ADD.L   pInstr,D2
)MOVE.L  D2,(A0)        ;momentane Adresse als ^ eintragen
)BSET    #7,D0
)MOVE.B  D0,D1
)RTS
)
 ;Forw.Ref to lokal Proc.
 C7       CMPI.B  #8,SizeOfData  ; '.S'
)BHI     AER2
)BEQ     AER3
)CMPI.B  #1,SizeOfData  ; '.B'
)BEQ     AER3
)
)MOVE.B  #2,SizeOfData  ; '.W' als Default
)
)MOVEA.L IDPtr,A0
)
 C12      MOVE.L  D5,D2          ; Achtung: normalerweise wird hier 2 addiert,
)ADD.L   D5,D2          ; bei FDBcc wird 4 addiert !!
 
 C13      MOVE.L  (A0),D0        ;Word-Verkettungspointer merken
 C14      ADD.L   pInstr,D2
)MOVE.L  D2,(A0)        ;momentane Adresse als ^ eintragen
)
)TST.L   D0
)BEQ     C3             ;1.Ref. -> Null als Verkettungspointer
)BRA     C8             ;Sonst: Wort-Verkettungs-^ bestimmen
 END
 END @MN7A;
 
 
 (*
 *   %Bcc
 *)
 PROCEDURE MN7;
 BEGIN
 ASSEMBLER  JSR     ErrIfOp2
)JSR     SourceToLast
)JMP     @MN7A
 END
 END MN7;
 
 
 (*
 *  %DBcc
 *)
 PROCEDURE MN14;
 BEGIN
 ASSEMBLER  MOVE.B  ModeSource,D0
)CMPI.B  #1,D0          ;Source = 'Dn' ?
)BEQ     OK
)JMP     AERR1          ;nein:ERROR
 !OK      MOVEQ   #2,D0
)JSR     VerifySize
)MOVE.B  D0,SizeOfData  ; '.W' als Default
)MOVE.B  RegSource,D0
)JSR     RegTo0_2       ;setze Reg. in Code-Wort
)JSR     DestToLast
)JMP     @MN7A
 END
 END MN14;
 
 
 (* #d8,<ea>  ausser : #8,Dn  *)
 PROCEDURE MN9A;
 BEGIN
 ASSEMBLER  MOVE.W  #1111111101010%,D3
)JSR     TestTypeSource
)MOVEQ   #1,D0
)JSR     VerifySize
)MOVE.L  DataSource,D0
)CMPI.L  #8,D0
)BCS     OK
)JMP     AERR1
 !OK      JSR     ApndD0_W
)JSR     DestTo0_5
)JMP     ApndDest
 END
 END MN9A;
 
 (* #d8,Dn *)
 PROCEDURE MN8B;
 BEGIN
 ASSEMBLER  MOVE.W  #1111111101010%,D3
)JSR     TestTypeSource
)MOVEQ   #4,D0
)JSR     VerifySize
)MOVE.L  DataSource,D0
)CMPI.L  #32,D0
)BCS     OK
)JMP     AERR1
 !OK      JSR     ApndD0_W
)JSR     DestTo0_5
)JMP     ApndDest
 END
 END MN8B;
 
 
 PROCEDURE MN9C;
 BEGIN
 ASSEMBLER  CMPI.B  #1,D0          ;Dest = 'Dn' ?
)BNE     L1
)JMP     MN8B
 !L1      JMP     MN9A
 END
 END MN9C;
 
 
 (* Dn,<ea> *)
 PROCEDURE MN9B;
 BEGIN
 ASSEMBLER  MOVE.B  ModeDest,D0
)CMPI.B  #13,D0
)BCS     OK
 !AER1    JMP     AERR1
 !AER2    JMP     AERR2
 !OK      CMPI.B  #2,D0          ; D: 'An' ?
)BEQ     AER1
)CMPI.B  #1,D0          ; D: 'Dn' ?
)BNE     C1
)
)MOVEQ   #4,D0          ; Size muss .L sein
)BRA     C3
)
 C1       MOVEQ   #1,D0          ; Size muss .B sein
 
 C3       JSR     VerifySize
)JSR     DestTo0_5
)JSR     ApndDest
)MOVE.B  RegSource,D0
)JMP     RegTo9_11
 END
 END MN9B;
 
 
 PROCEDURE MN8A;
 BEGIN
 ASSEMBLER  MOVE.B  ModeDest,D0
)CMPI.B  #10,D0
)BCS     OK
)JMP     AERR1
 !OK      JMP     MN9B
 END
 END MN8A;
 
 
 (*
 *   %BCHG, %BCLR, %BSET
 *)
 PROCEDURE MN8;
 BEGIN
 ASSEMBLER  MOVE.B  ModeSource,D0
)CMPI.B  #1,D0
)BNE     L1
)JMP     MN8A           ; Dn,<ea>
 !L1      CMPI.B  #12,D0
)BEQ     OK
 !AER1    JMP     AERR1
 !OK      BSET    #11,D1         ; #d8,<ea>
)BCLR    #8,D1
)MOVE.B  ModeDest,D0
)CMPI.B  #10,D0
)BCC     AER1
)CMPI.B  #2,D0
)BEQ     AER1
)JMP     MN9C
 END
 END MN8;
*
 (*
 *  %BTST
 *)
 PROCEDURE MN9;
 BEGIN
 ASSEMBLER  MOVE.B  ModeSource,D0
)CMPI.B  #1,D0          ; S:'Dn' ?
)BNE     L1
)JMP     MN9B
 !L1      CMPI.B  #12,D0         ; S:'#' ?
)BEQ     OK1
)JMP     AERR1
 !OK1     BSET    #11,D1
)BCLR    #8,D1
)MOVE.B  ModeDest,D0
)CMPI.B  #12,D0
)BCS     OK
)JMP     AERR1
 !OK      JMP     MN9C
 END
 END MN9;
 
 
 (*
 *  %MULS, %MULU, %DIVS, %DIVU
 *)
 PROCEDURE MN10;
 BEGIN
 ASSEMBLER  JSR     LoadSize
)CMPI.B  #2,D0
)BEQ     okW
)CMPI.B  #4,D0
)BEQ     okL
)
 !AER2    JMP     AERR2
 !AER1    JMP     AERR1
 
 okW      MOVE.L  #1111011111010%,D0
)JSR     CheckModeSource
)JSR     SourceTo0_5
)JSR     ApndSource
)MOVE.B  ModeDest,D0
)CMPI.B  #1,D0          ; D: 'Dn' ?
)BNE     AER1
)MOVE.B  RegDest,D0
)JMP     RegTo9_11
 
 okL      ; 68020 - Behandlung
)MOVE.L  AsmOptions,D2
)BTST    #24,D2
)BEQ     AER2
)
)CLR     D2                     ; Erw-Wort bei 68020 long form
)BTST    #8,D1
)BEQ     c0
)BSET    #11,D2
 c0       MOVE    #0100110000000000%,D3  ; Long form of instruction
)BTST    #14,D1
)BNE     c2
)BSET    #6,D3
 c2       MOVE    D3,D1
)
)MOVE.B  ModeDest,D0
)ANDI    #$7F,D0
)CMPI.B  #1,D0          ; D: 'Dn' ?
)BNE     AER1
)
); Dp - reg. bestimmen
)MOVE.B  RegDest,D0
)ROR.W   #4,D0          ; oberes Byte des Wortes schon Null
@; ??? soll die vorige Zeile dasein ?
)OR      D0,D2
)
)TST.B   ModeDest
)BPL     NoDouble
)
); Doppelregs nur bei Adr-Arten mit Dn erlaubt
)CMPI.B  #1,Mode2Dest  ; Dn ?
)BNE     AER1
)OR.B    Reg2Dest,D2
)BSET    #10,D2         ; Sz - field: 64 bit operation
)
 NoDouble MOVE.L  #1111011111010%,D0
)JSR     CheckModeSource
)MOVE    D2,D0
)JSR     ApndD0_W
)JSR     SourceTo0_5
)JMP     ApndSource
 END
 END MN10;
 
 
 (*
 *   %DIVSL, %DIVUL
 *)
 
 (*$ ? Asm20:
 
 PROCEDURE MneDIVSL_UL;
 BEGIN
 ASSEMBLER  JSR     LoadSize
)CMPI.B  #4,D0
)BEQ     okL
)
 !AER2    JMP     AERR2
 !AER1    JMP     AERR1
 
 okL      ; 68020 - Behandlung
)MOVE.L  Options,D2
)BTST    #24,D2                 ;$X
)BEQ     AER2
)
)CLR     D2                     ; Erw-Wort bei 68020 long form
)BTST    #8,D1
)BEQ     c0
)BSET    #11,D2
 c0       MOVE    #0100110001000000%,D1  ; Long form of instruction
)
)MOVE.B  ModeDest,D0
)ANDI    #$7F,D0
)CMPI.B  #1,D0          ; D: 'Dn' ?
)BNE     AER1
)
); Dp - reg. bestimmen
)MOVE.B  RegDest,D0
)OR      D0,D2
)
)TST.B   ModeDest
)BPL     AER1
)
); Doppelregs nur bei Adr-Arten mit Dn erlaubt
)CMPI.B  #1,Mode2Dest  ; Dn ?
)BNE     AER1
)MOVE.B  Reg2Dest,D0
)CMP.B   RegDest,D0
)BEQ     AER1
)
)ROR.W   #4,D0          ; oberes Byte des Wortes schon Null
)OR      D0,D2
)MOVE.L  #1111011111010%,D0
)JSR     CheckModeSource
)MOVE    D2,D0
)JSR     ApndD0_W
)JSR     SourceTo0_5
)JMP     ApndSource
 END
 END MneDIVSL_UL;
 *)
 
 (*
 *  %CHK
 *)
 PROCEDURE MneCHK;
 BEGIN
 ASSEMBLER  JSR     LoadSize
)CMPI.B  #2,D0
)BEQ     OK0
)MOVE.L  AsmOptions,D2
)BTST    #24,D2
)BEQ     AER2
)BCLR    #7,D1          ; Size auf Long
)CMPI.B  #4,D0
)BEQ     OK0
 AER2     JMP     AERR2
 OK0      MOVE.B  ModeSource,D0
)CMPI.B  #2,D0          ; S: 'An' ?
)BNE     OK
 !AER1    JMP     AERR1
 !OK      CMPI.B  #13,D0
)BCC     AER1
)JSR     SourceTo0_5
)JSR     ApndSource
)MOVE.B  ModeDest,D0
)CMPI.B  #1,D0          ; D: 'Dn' ?
)BNE     AER1
)MOVE.B  RegDest,D0
)JMP     RegTo9_11
 END
 END MneCHK;
)
 (*$ ? Asm20:
 
 (*
!*  %CHK2, %CMP2
!*)
 PROCEDURE MneCHK2_CMP2;
 BEGIN
 ASSEMBLER  JSR     LoadSize
)JSR     SizeTo9_10
)MOVE.L  #0000000000110%,D0
)JSR     CheckModeDest
)CLR.W   D0
)MOVE.B  RegDest,D0
)ROR.W   #4,D0
)BSET    #11,D0
)CMPI.B  #1,ModeDest
)BEQ     ok
)BSET    #15,D0
 ok       JSR     ApndD0_W
)MOVE.L  #0111011001000%,D0
)JSR     CheckModeSource
)JSR     SourceTo0_5
)JMP     ApndSource
 END
 END MneCHK2_CMP2;
 
 *)
 
 (*
 *   %CLR, %NEG, %NEGX, %NOT
 *)
 PROCEDURE MN11;
 BEGIN
 ASSEMBLER  JSR     LoadSize
)JSR     SizeTo6_7
)MOVE.B  ModeSource,D0
)CMPI.B  #10,D0
)BCS     OK
 !AER1    JMP     AERR1
 !OK      CMPI.B  #2,D0
)BEQ     AER1
)JSR     SourceTo0_5
)JSR     ApndSource
)JMP     ErrIfOp2
 END
 END MN11;
 
 
 (*
 *   %TST
 *)
 PROCEDURE MneTST;
 BEGIN
 ASSEMBLER  JSR     LoadSize
)JSR     SizeTo6_7
)MOVE.L  #0001111111010%,D0
)MOVE.L  AsmOptions,D2
)BTST    #24,D2
)BEQ     ok0
)ORI.L   #0110000000000%,D0     ; 68020 kann auch PC-rel.
 ok0      JSR     CheckModeSource
)JSR     SourceTo0_5
)JSR     ApndSource
)JMP     ErrIfOp2
 END
 END MneTST;
 
 (*$ ? Asm20:
 
 (*
 *   %RTM
 *)
 PROCEDURE MneRTM;
 BEGIN
 ASSEMBLER  JSR     ErrIfSize
)MOVE.L  #0000000000110%,D0
)JSR     CheckModeSource
)JSR     SourceTo0_5
)JMP     ErrIfOp2
 END
 END MneRTM;
 
 *)
 
 (*
 *   %CMP
 *)
 PROCEDURE MN12;
 BEGIN
 ASSEMBLER  MOVE.B  ModeDest,D0
)CMPI.B  #1,D0          ; D: 'Dn' ?
)BEQ     OK
 !AER1    JMP     AERR1
 !OK      MOVE.B  RegDest,D0
)JSR     RegTo9_11
)JSR     LoadSize
)JSR     SizeTo6_7
)MOVE.B  ModeSource,D0
)CMPI.B  #13,D0
)BCC     AER1
)JSR     SourceTo0_5
)JMP     ApndSource
 END
 END MN12;
 
 (*
 *   %CMPM
 *)
 PROCEDURE MN13;
 BEGIN
 ASSEMBLER  JSR     LoadSize
)JSR     SizeTo6_7
)MOVE.B  ModeSource,D0
)CMPI.B  #4,D0          ; S: '(An)+' ?
)BEQ     OK
 !AER1    JMP     AERR1
 !OK      MOVE.B  RegSource,D0
)JSR     RegTo0_2
)MOVE.B  ModeDest,D0
)CMPI.B  #4,D0          ; D: '(An)+' ?
)BNE     AER1
)MOVE.B  RegDest,D0
)JMP     RegTo9_11
 END
 END MN13;
 
 
 (*
 *   %EOR
 *)
 PROCEDURE MN15;
 BEGIN
 ASSEMBLER
)BSET    #8,D1
)JSR     LoadSize
)JSR     SizeTo6_7
)MOVE.B  ModeSource,D0
)CMPI.B  #1,D0
)BEQ     OK
 !AER1    JMP     AERR1
 !OK      MOVE.B  RegSource,D0
)JSR     RegTo9_11
)MOVE.B  ModeDest,D0
)CMPI.B  #10,D0
)BCC     AER1
)CMPI.B  #2,D0
)BEQ     AER1
)JSR     DestTo0_5
)JMP     ApndDest
 END
 END MN15;
 
 
 (*
 *   %EXG
 *)
 PROCEDURE MN16;
 BEGIN
 ASSEMBLER  MOVEQ   #4,D0
)JSR     VerifySize
)MOVE.B  RegSource,D0
)MOVE.B  ModeSource,D4
)CMPI.B  #1,D4
)BEQ     MN16A
)CMPI.B  #2,D4
)BEQ     OK
 !AER1    JMP     AERR1
 !AER2    JMP     AERR2
 
 !OK      JSR     RegTo0_2
)MOVE.B  RegDest,D0
)JSR     RegTo9_11
)MOVE.B  ModeDest,D4
)CMPI.B  #1,D4
)BEQ     MN16B
)CMPI.B  #2,D4
)BNE     AER1
)BSET    #6,D1
)BSET    #3,D1
)RTS
 
 MN16B    BSET    #7,D1
)BSET    #3,D1
)RTS
 
 MN16A    JSR     RegTo9_11
)MOVE.B  RegDest,D0
)JSR     RegTo0_2
)MOVE.B  ModeDest,D0
)CMPI.B  #1,D0
)BEQ     MN16C
)CMPI.B  #2,D0
)BEQ     MN16B
)BRA     AER1
 
 MN16C    BSET    #6,D1
 END
 END MN16;
 
 
 (*
 *   %EXT, %EXTB
 *)
 PROCEDURE MneEXT;
 BEGIN
 ASSEMBLER  JSR     LoadSize
)CMPI.B  #1,D0
)BEQ     AER1
)CMPI.B  #2,D0
)BEQ     ADR9B
)BSET    #6,D1
 ADR9B    MOVE.B  ModeSource,D0
)CMPI.B  #1,D0
)BNE     AER1
)MOVE.B  RegSource,D0
)JSR     RegTo0_2
)JMP     ErrIfOp2
 AER1     JMP     AERR1
 END
 END MneEXT;
 
 
 (*
 *   %CAS
 *)
 PROCEDURE MneCAS;
 BEGIN
 ASSEMBLER  JSR     LoadSize
)JSR     Size2To9_10
)JSR     ThirdTo0_5
)CMPI.B  #1,ModeSource
)BNE     AER1
)CMPI.B  #1,ModeDest
)BNE     AER1
)CLR     D0
)MOVE.B  RegSource,D0
)CLR     D2
)MOVE.B  RegDest,D2
)LSL     #6,D2
)OR      D2,D0
)JSR     ApndD0_W
)MOVE.L  #0001011111000%,D0
)JSR     CheckModeThird
)JMP     ApndThird
)
 AER1     JMP     AERR1
 END
 END MneCAS;
 
 (*$ ? Asm20:
 
 (*
 *   %CAS2
 *)
 PROCEDURE MneCAS2;
 BEGIN
 ASSEMBLER  JSR     LoadSize
)CMPI.B  #1,D0
)BEQ     AER2
)JSR     Size2To9_10
)CMPI.B  #$81,ModeSource
)BEQ     ok0
 AER1     JMP     AERR1
 AER2     JMP     AERR2
 ok0      CMPI.B  #1,Mode2Source
)BNE     AER1
)CMPI.B  #$81,ModeDest
)BNE     AER1
)CMPI.B  #1,Mode2Dest
)BNE     AER1
)MOVE.B  ModeThird,D0
)CMPI.B  #$83,D0        ; '(An) ?
)BEQ     ok1
)CMPI.B  #17+$80,D0     ; '(Dn) ?
)BNE     AER1
 ok1      MOVE.B  Mode2Third,D0
)CMPI.B  #3,D0          ; '(An) ?
)BEQ     ok2
)CMPI.B  #17,D0         ; '(Dn) ?
)BNE     AER1
)
 ok2      CLR     D0
)MOVE.B  RegSource,D0
)CLR     D2
)MOVE.B  RegDest,D2
)LSL     #6,D2
)OR      D2,D0
)CLR     D2
)MOVE.B  RegThird,D2
)ROR     #4,D2
)CMPI.B  #$80+3,ModeThird   ; '(An)' ?
)BNE     ok3
)BSET    #15,D2
 ok3      OR      D2,D0
)JSR     ApndD0_W
)
)CLR     D0
)MOVE.B  Reg2Source,D0
)CLR     D2
)MOVE.B  Reg2Dest,D2
)LSL     #6,D2
)OR      D2,D0
)CLR     D2
)MOVE.B  Reg2Third,D2
)ROR     #4,D2
)CMPI.B  #3,Mode2Third   ; '(An)' ?
)BNE     ok4
)BSET    #15,D2
 ok4      OR      D2,D0
)JMP     ApndD0_W
 END
 END MneCAS2;
 
 *)
 
 PROCEDURE @MN19A;
 BEGIN
 ASSEMBLER  JSR     ErrIfSize
)MOVE.B  ModeSource,D0
)CMPI.B  #12,D0
)BCS     OK
 !AER1    JMP     AERR1
 !OK      CMPI.B  #5,D0
)BEQ     AER1
)CMPI.B  #4,D0
)BEQ     AER1
)CMPI.B  #2,D0
)BLS     AER1
)JSR     SourceTo0_5
)JMP     ApndSource
 END
 END @MN19A;
 
 (*
 *   %JSR,%JMP
 *)
 PROCEDURE MN18;
 BEGIN
 ASSEMBLER
(JSR     ErrIfOp2
(MOVE.W  #1000000111001%,D3
(JSR     TestTypeSource
(JMP     @MN19A
 END
 END MN18;
 
 
 (*
 *   %PEA
 *)
 PROCEDURE MN18P;
 BEGIN
 ASSEMBLER  JSR     ErrIfOp2
 (*$ ? Gepard:
)CMPI.B  #3,ModeSource
)BCS     ok1
)CMPI.B  #7,ModeSource
)BHI     ok1
); Operand ist (An), x(An), -(An), (An)+ oder x(An,Xn.S)
)CMPI.B  #3,RegSource   ; A3 ?
)BNE     ok1
)MOVE.W  #asmIllAM,D2   ;ja-> Warning ausgeben
)MOVEQ   #1,D3          ;source-Operand
)JSR     AsmWarning
 *)
 ok1      JMP     @MN19A
 END
 END MN18P;
 
 
 (*
 *   %LEA
 *)
 PROCEDURE MN19;
 BEGIN
 ASSEMBLER  JSR     ErrIfSize
 (*$ ? Gepard:
)MOVE.W  #asmIllAM,D2   ;Warning ausgeben
)CMPI.B  #3,ModeSource
)BCS     ok1
)CMPI.B  #7,ModeSource
)BHI     ok1
); Operand ist (An), x(An), -(An), (An)+ oder x(An,Xn.S)
)CMPI.B  #3,RegSource   ; source = (A3) ?
)BNE     ok1
)CMPI.B  #3,RegDest     ; dest = A3 ?
)BEQ     ok2            ; LEA x(A3...),A3 ist erlaubt
)MOVEQ   #1,D3          ;source-Operand
)JSR     AsmWarning
)BRA     ok2
 ok1      CMPI.B  #3,RegDest     ; dest = A3 ?
)BNE     ok2            ; LEA xx,A3 ist nicht erlaubt
)MOVEQ   #2,D3          ; dest-Operand
)JSR     AsmWarning
 *)
 ok2      MOVE.B  ModeDest,D0
)CMPI.B  #2,D0
)BEQ     OK
)JMP     AERR1
 !OK      MOVE.B  RegDest,D0
)JSR     RegTo9_11
)JMP     @MN19A
 END
 END MN19;
 
 
 (*
 *  %LINK
 *)
 PROCEDURE MN20;
 BEGIN
 ASSEMBLER  MOVE.W  #1111111111010%,D3
)JSR     TestTypeSource
)MOVE.B  ModeSource,D0
)CMPI.B  #2,D0
)BEQ     OK
 !AER1    JMP     AERR1
 !OK      MOVE.B  ModeDest,D0
)CMPI.B  #12,D0
)BNE     AER1
)JSR     LoadSize
)CMPI.B  #2,D0
)BEQ     okw
)CMPI.B  #4,D0
)BEQ     okl
)JMP     AERR2
 okl      MOVE    #0100100000001000%,D1  ; LINK.L - instruction
)MOVE.L  DataDest,D0
)JSR     ApndD0_L
)BRA     C2
 okw      MOVE.L  DataDest,D0
)CMPI.L  #$8000,D0
)BCS     C1
)CMPI.L  #$FFFF8000,D0
)BCC     C1
)JMP     AERR16
 C1       JSR     ApndD0_W
 C2       MOVE.B  RegSource,D0
)JMP     RegTo0_2
 END
 END MN20;
 
 
 (*$ ? Asm20:
 
 (*
 *  %CALLM
 *)
 PROCEDURE MneCALLM;
 BEGIN
 ASSEMBLER  MOVE.W  #1111111111010%,D3
)JSR     TestTypeSource
)MOVE.B  ModeSource,D0
)CMPI.B  #12,D0         ; '#'
)BEQ     OK
 !AER1    JMP     AERR1
 !OK      MOVE.L  #0111011001000%,D0
)JSR     CheckModeDest
)MOVE.L  DataDest,D0
)CMPI.L  #$100,D0
)BCS     C1
)JMP     AERR16
 C1       JSR     ApndD0_W
)JMP     DestTo0_5
 END
 END MneCALLM;
 
 *)
 
 (*
 * %MOVE
 *)
 PROCEDURE MN21;
 BEGIN
 ASSEMBLER  MOVE.B  ModeDest,D0
)CMPI.B  #13,D0         ; D:SR ? ->
)BEQ.L   MN21G
)CMPI.B  #15,D0         ; D:CCR ? ->
)BEQ.L   MN21H
)CMPI.B  #14,D0         ; D:USP ?
)BEQ.L   MN21C
)MOVE.B  ModeSource,D2
)CMPI.B  #13,D2         ; S: SR ?
)BEQ.L   MN21A
)CMPI.B  #15,D2         ; S:CCR ? ->
)BEQ.L   MN21D
)CMPI.B  #14,D2         ; S:USP ?
)BEQ.L   MN21B
)
)JSR     LoadSize
)JSR     SizeTo12_13    ; D0 bleibt erhalten
)
)CMPI.B  #13,D2
)BCC     AER1
 (*$ ? Gepard:
)CMPI.B  #2,D2          ; An ?
)BNE     MN21J
)CMPI.B  #3,RegSource   ; A3 ?
)BNE     MN21J
)MOVE.W  #asmIllAM,D2   ; ja-> Warning ausgeben
)MOVEQ   #1,D3          ; source-Operand
)JSR     AsmWarning
 MN21J
 *)       JSR     SourceTo0_5
)
)MOVE.B  ModeDest,D0
)CMPI.B  #10,D0
)BCC     AER1
)
 (*$ ? Gepard:
)CMPI.B  #2,D0          ; An ?
)BNE     MN21K
)CMPI.B  #3,RegDest     ; A3 ?
)BNE     MN21K
)MOVE.W  #asmIllAM,D2   ; ja-> Warning ausgeben
)MOVEQ   #2,D3          ; dest-Operand
)JSR     AsmWarning
 MN21K
 *)
)MOVE.W  D1,D2
)CLR.W   D1
)JSR     DestTo0_5
)MOVE.W  D1,D0
)ANDI.W  #111000%,D0
)ANDI.W  #000111%,D1
)LSR.W   #3,D0
)LSL.W   #3,D1
)OR.W    D0,D1
)LSL.W   #6,D1
)OR      D2,D1
)JSR     ApndSource
)JMP     ApndDest
)
 AER1     JMP     AERR1
 
 MN21D    ; MOVE CCR,<ea>
)MOVE    #0100001011000000%,D1
)MOVE.L  AsmOptions,D0
)BTST    #24,D0         ; $X+?
)BNE     MN21E
)JMP     AERR17         ; 68020-Mne not allowed
 MN21A    ; MOVE SR,<ea>
)MOVE    #0100000011000000%,D1
 MN21E    MOVEQ   #2,D0
)JSR     VerifySize
);Size-Bestimmung nicht notwendig, da es
);bei Dest. keinen Size-Abh. Operanden gibt
)MOVE.B  ModeDest,D0
)CMPI.B  #10,D0
)BCC     AER1
)CMPI.B  #2,D0
)BEQ     AER1
)JSR     DestTo0_5
)JMP     ApndDest
)
 MN21B    ; MOVE USP,An
)MOVEQ   #4,D0
)JSR     VerifySize
)MOVE.B  ModeDest,D0
)CMPI.B  #2,D0
)BNE     AER1
)MOVE.W  #$4E68,D1
)MOVE.B  RegDest,D0
)JMP     RegTo0_2
 
 MN21C    ; MOVE An,USP
)MOVEQ   #4,D0
)JSR     VerifySize
)MOVE.B  ModeSource,D0
)CMPI.B  #2,D0
)BNE     AER1
)MOVE.W  #$4E60,D1
)MOVE.B  RegSource,D0
)JMP     RegTo0_2
)
 MN21H    MOVE    #0100010011000000%,D1  ; MOVE <ea>,CCR
)MOVEQ   #1,D3                  ; CCR : BYTE-Operation(noetig bei '#')
)BRA     MN21I
)
 MN21G    MOVE    #0100011011000000%,D1  ; MOVE <ea>,SR
)MOVEQ   #2,D3                  ; SR : WORD-Operation(noetig bei '#')
 MN21I    MOVEQ   #2,D0
)JSR     VerifySize
)MOVE.B  D3,SizeOfData
)MOVE.B  ModeSource,D0
)CMPI.B  #13,D0
)BCC     AER1
)CMPI.B  #2,D0
)BEQ     AER1
)JSR     SourceTo0_5
)JMP     ApndSource
 END
 END MN21;
 
 
 (*
 *  %MOVEM
 *)
 PROCEDURE MN22;
 BEGIN
 ASSEMBLER  JSR     LoadSize
)CMPI.B  #1,D0          ;'.B' nicht erlaubt
)BNE     OK
)JMP     AERR2
 
 !OK      CMPI.B  #4,D0          ;Size in Bef-Code eintragen:
)BNE     MN22F
)BSET    #6,D1
 
 MN22F    CMPI.B  #18,ModeSource ;Source = REGLIST ?
)BEQ     MN22A          ;ja ->
)CMPI.B  #12,ModeSource ;teste Source <ea>
)BCS     OK1            ; ->Source <ea> ist OK
 !AER1    JMP     AERR1          ;ERROR:Source Adr-Mode nicht erlaubt
 
@; MOVEM.X <ea>,Reglist.
 !OK1     CMPI.B  #18,ModeDest   ;ist Dest. = 'Reglist.' ?
)BNE     AER1           ;Nein ->ERROR
)CMPI.B  #5,ModeSource  ;Source = '-(Ax)' ?
)BEQ     AER1           ;ja:ERROR
)CMPI.B  #3,ModeSource  ;Source = 'Ax' o. 'Dx' ?
)BCS     AER1           ;ja:ERROR
)BSET    #10,D1         ;Direktion-Flag in Bef-Code setzen
 MN22E    JSR     SourceTo0_5    ;<ea> nach Bit 0-5 in Bef-Code
)MOVE.W  RegListDest,D0 ;Registerliste laden
 (*$ ? Gepard:
)BTST    #8+3,D0        ;A3 drin ?
)BEQ     MN22E2
)MOVE.W  #asmIllAM,D2   ;ja-> Warning ausgeben
)MOVEQ   #2,D3          ;dest-Operand
)JSR     AsmWarning
 MN22E2
 *)       JSR     ApndD0_W
)JMP     ApndSource
 
@; MOVEM.X Reglist.,<ea>
 !MN22A   CMPI.B  #12,ModeDest   ;teste Dest.<ea>
)BCC     AER1           ;ERROR:unerlaubte Dest.<ea>
)JSR     DestTo0_5      ;<ea> nach Bit 0-5 in Bef-Code
)MOVE.W  RegListSource,D0 ;Registerliste laden
 (*$ ? Gepard:
)BTST    #8+3,D0        ;A3 drin ?
)BEQ     MN22A2
)MOVE.W  #asmIllAM,D2   ;ja-> Warning ausgeben
)MOVEQ   #1,D3          ;source-Operand
)JSR     AsmWarning
 MN22A2
 *)       CMPI.B  #3,ModeDest    ;Dest. = '(Ax)' ?
)BEQ     MN22B          ;ja:OK
)CMPI.B  #5,ModeDest    ;Dest = '-(Ax)' ?
)BEQ     MN22C          ;ja:OK
)BCC     MN22B          ;-> andere erlaubte Adr.-Art
)BRA     AER1           ; = 'Dx' o. 'Ax' o. '(Ax)+' :ERROR
 
 MN22C    ;verkehre Reg.liste:
)MOVEQ   #15,D3
 MN22D    ROXR.W  #1,D0
)ROXL.W  #1,D2
)DBF     D3,MN22D
)MOVE.W  D2,D0
 
 MN22B    JSR     ApndD0_W       ; Registerliste als Erw.-Wort zum Code
)JMP     ApndDest
 END
 END MN22;
 
 
 (*
 *  %MOVEP
 *)
 PROCEDURE MN23;
 BEGIN
 ASSEMBLER  JSR     LoadSize
)CMPI.B  #1,D0
)BNE     OK2
)JMP     AERR2
 !OK2     CMPI.B  #2,D0
)BEQ     MN23A
)BSET    #6,D1
 MN23A    BSET    #8,D1
)MOVE.B  ModeSource,D0
)CMPI.B  #1,D0
)BEQ     MN23B
)CMPI.B  #6,D0
)BEQ     OK
 !AER1    JMP     AERR1
 
 !OK      ; MOVEP d16(An),Dn
)MOVE.B  ModeDest,D0
)CMPI.B  #1,D0
)BNE     AER1
)MOVE.B  RegSource,D0
)JSR     RegTo0_2
)JSR     ApndSource
)MOVE.B  RegDest,D0
)JMP     RegTo9_11
 
 MN23B    ; MOVEP Dn,d16(An)
)MOVE.B  ModeDest,D0
)CMPI.B  #6,D0
)BNE     AER1
)BSET    #7,D1
)MOVE.B  RegSource,D0
)JSR     RegTo9_11
)MOVE.B  RegDest,D0
)JSR     RegTo0_2
)JMP     ApndDest
 END
 END MN23;
 
 
 (*
 *  %MOVEQ
 *)
 PROCEDURE MN24;
 BEGIN
 ASSEMBLER  MOVEQ   #4,D0
)JSR     VerifySize
)MOVE.B  ModeSource,D0
)CMPI.B  #12,D0
)BEQ     OK
 !AER1    JMP     AERR1
 !AER2    JMP     AERR2
 !OK      MOVE.B  ModeDest,D0
)CMPI.B  #1,D0
)BNE     AER1
)MOVE.W  #1110111000010%,D3
)JSR     TestTypeDest
)MOVE.B  RegDest,D0
)JSR     RegTo9_11
)MOVE.L  DataSource,D0
)CMPI.L  #$100,D0
)BCS     C1
)CMPI.L  #$FFFFFF80,D0
)BHI     C1
)JMP     AERR16
 C1       MOVE.B  D0,D1
 END
 END MN24;
 
 
 (*
 *  %Scc, %NBCD, %TAS
 *)
 PROCEDURE MN25;
 BEGIN
 ASSEMBLER  MOVEQ   #1,D0
)JSR     VerifySize
)MOVE.B  ModeSource,D0
)CMPI.B  #10,D0
)BCS     OK
 !AER1    JMP     AERR1
 !OK      CMPI.B  #2,D0
)BEQ     AER1
)JSR     SourceTo0_5
)JSR     ApndSource
)JMP     ErrIfOp2
 END
 END MN25;
 
 
 (*
 *  %STOP, %RTD
 *)
 PROCEDURE MneSTOP_RTD;
 BEGIN
 ASSEMBLER  MOVE.W  #1111111111010%,D3
)JSR     TestTypeSource
)MOVE.B  ModeSource,D0
)CMPI.B  #12,D0
)BEQ     OK
)JMP     AERR1
 !OK      JSR     ErrIfSize
)MOVE.L  DataSource,D0
)CMPI.L  #$10000,D0
)BCS     C1
)CMPI.L  #$FFFF0000,D0
)BHI     C1
)JMP     AERR16
 C1       JSR     ApndD0_W
)JMP     ErrIfOp2
 END
 END MneSTOP_RTD;
 
 
 (*
 *  %SWAP
 *)
 PROCEDURE MN28;
 BEGIN
 ASSEMBLER  MOVEQ   #2,D0
)JSR     VerifySize
)MOVE.B  ModeSource,D0
)CMPI.B  #1,D0
)BEQ     OK
)JMP     AERR1
 !OK      MOVE.B  RegSource,D0
)JSR     RegTo0_2
)JMP     ErrIfOp2
 END
 END MN28;
 
 
 PROCEDURE @MN29;
 BEGIN
 ASSEMBLER  CMP.L   DataSource,D0
)BCC     C1
)JMP     AERR16
 C1       OR.L    DataSource,D1
)JSR     ErrIfSize
)MOVE.B  ModeSource,D0
)CMPI.B  #12,D0
)BEQ     OK
)JMP     AERR1
 !OK      MOVE.W  #1111111101010%,D3
)JSR     TestTypeSource
)JMP     ErrIfOp2
 END
 END @MN29;
 
 (*
 *  %TRAP
 *)
 PROCEDURE MN29;
 BEGIN
 ASSEMBLER  MOVEQ   #$10,D0
)JMP     @mn29
 END
 END MN29;
 
 (*$ ? Asm20:
 
 (*
 *  %BKPT
 *)
 PROCEDURE MneBKPT;
 BEGIN
 ASSEMBLER  MOVEQ   #8,D0
)JMP     @mn29
 END
 END MneBKPT;
 
 
 (*
 *  %TRAPcc
 *)
 PROCEDURE MneTRAPcc;
 BEGIN
 ASSEMBLER
); Fr parameterloses TRAPcc mu '()' verwendet werden
)CMPI.B  #12,modeSource
)BEQ     hasPara
)CMPI.B  #7,modeSource  ; erw. Adr.-Arten der 68020
)BNE     AER1
)CMPI.B  #$80,M20FlgSource
)BNE     AER1
)JSR     ErrIfOp2
)JSR     ErrIfSize
)BSET    #2,D1
)RTS
)
 hasPara  JSR     LoadSize
)CMPI.B  #1,D0
)BEQ     AER2
)BSET    #1,D1
)CMPI.B  #2,D0
)BEQ     c1
)BSET    #0,D1
 c1       JMP     ApndSource
 
 AER2     JMP     AERR2
 AER1     JMP     AERR1
 END
 END MneTRAPcc;
 
 *)
 
 (*
 *  %UNLK
 *)
 PROCEDURE MN30;
 BEGIN
 ASSEMBLER  JSR     ErrIfSize
)MOVE.B  ModeSource,D0
)CMPI.B  #2,D0
)BEQ     OK
)JMP     AERR1
 !OK      MOVE.B  RegSource,D0
)JSR     RegTo0_2
)JMP     ErrIfOp2
 END
 END MN30;
 
 
 (*
 *  %MOVEA
 *)
 PROCEDURE MN32;
 BEGIN
 ASSEMBLER  MOVE.B  SizeOfData,D0
)CMPI.B  #1,D0
)BNE     OK
)JMP     AERR2
 !OK      MOVE.B  ModeDest,D0
)CMPI.B  #2,D0
)BEQ     OK1
)JMP     AERR1
 !OK1     JMP     MN21
 END
 END MN32;
 
 
 (*
 *  %MOVEC
 *)
 PROCEDURE MneMOVEC;
 BEGIN
 ASSEMBLER
)MOVEQ   #4,D0
)JSR     VerifySize
)CLR     D2
)
)MOVE.B  ModeSource,D0
)CMPI.B  #12,D0
)BHI     so
)
)CMPI.B  #1,ModeSource
)BEQ     de1
)CMPI.B  #2,ModeSource
)BEQ     de1
 AER1     JMP     AERR1
 de1      MOVE.B  RegSource,D2
)ROR.W   #4,D2
)CMPI.B  #1,ModeSource
)BEQ     ok
)BSET    #15,D2
 ok       MOVE.B  ModeDest,D0
)BSET    #0,D1
)BRA     c0
)
 so       CMPI.B  #1,ModeDest
)BEQ     so1
)CMPI.B  #2,ModeDest
)BNE     AER1
 so1      MOVE.B  RegDest,D2
)ROR.W   #4,D2
)CMPI.B  #1,ModeDest
)BEQ     c0
)BSET    #15,D2
 
 c0       CMPI.B  #16,D0         ; VBR ?
)BNE     notVBR
)ORI     #$801,D2
)BRA     E0
 notVBR   CMPI.B  #14,D0         ; USP ?
)BNE     notUSP
)ORI     #$800,D2
)BRA     E0
 notUSP   CMPI.B  #19,D0         ; SFC ?
)BEQ     E0
)CMPI.B  #22,D0         ; CAAR ?
)CMPI.B  #20,D0         ; DFC ?
)BNE     notDFC
)ORI     #$001,D2
)BRA     E0
 notDFC   CMPI.B  #22,D0         ; CAAR ?
)CMPI.B  #21,D0         ; CACR ?
)BNE     notCACR
)ORI     #$002,D2
)BRA     E0
 notCACR  CMPI.B  #22,D0         ; CAAR ?
)BNE     notCAAR
)ORI     #$802,D2
)BRA     E0
 notCAAR  CMPI.B  #23,D0         ; MSP ?
)BNE     notMSP
)ORI     #$803,D2
)BRA     E0
 notMSP   CMPI.B  #24,D0         ; ISP ?
)BNE     AER1
)ORI     #$804,D2
 
 E0       MOVE.W  D2,D0
)JMP     ApndD0_W
 END
 END MneMOVEC;
 
 
 (*$ ? Asm20:
 
 PROCEDURE MneBitFields;
 BEGIN
 ASSEMBLER  JSR     ErrIfSize
)CLR     D2             ; 1. Erw. Wort
)BCLR    #6,ModeSource
)BNE     BFSource
)
)BCLR    #6,ModeDest
)BNE     BFDest
)
 AER1     JMP     AERR1
)
 ApndBitF OR.B    BitWidth,D2
)CLR     D0
)MOVE.B  BitOffs,D0
)LSL     #6,D0
)OR      D2,D0
)JMP     ApndD0_W
)
 BFdest   MOVE.B  RegSource,D2
)ROR     #4,D2
 c0       JSR     DestToLast
)BSR     ApndBitF
)JSR     DestTo0_5
)JMP     ApndDest
)
 BFsource TST.B   ModeDest
)BEQ     c1
)MOVE.B  RegDest,D2
)ROR     #4,D2
 c1       JSR     SourceToLast
)BSR     ApndBitF
)JSR     SourceTo0_5
)JMP     ApndSource
 END
 END MneBitFields;
 
 
 (*
!*  %BFCHG, %BFCLR, %BFSET
!*)
 PROCEDURE MneBitFea;
 BEGIN
 ASSEMBLER  JSR     ErrIfOp2
)MOVE.L  #0001011001010%,D0
)JSR     CheckModeSource
)JMP     MneBitFields
 END
 END MneBitFea;
 
 
 (*
!*  %BFTST
!*)
 PROCEDURE MneBitFea2;
 BEGIN
 ASSEMBLER  JSR     ErrIfOp2
)MOVE.L  #0111011001010%,D0
)JSR     CheckModeSource
)JMP     MneBitFields
 END
 END MneBitFea2;
 
 
 (*
 *  %BFEXTS %BFEXTU, %BFFFO
 *)
 PROCEDURE MneBitFea_;
 BEGIN
 ASSEMBLER  CMPI.B  #1,ModeDest
)BNE     AER1
)MOVE.L  #0111011001010%,D0
)JSR     CheckModeSource
)JMP     MneBitFields
 AER1     JMP     AERR1
 END
 END MneBitFea_;
 
 
 (*
 *  %BFINS
 *)
 PROCEDURE MneBitF_ea;
 BEGIN
 ASSEMBLER  CMPI.B  #1,ModeSource
)BNE     AER1
)MOVE.L  #0001011001010%,D0
)JSR     CheckModeDest
)JMP     MneBitFields
 AER1     JMP     AERR1
 END
 END MneBitF_ea;
 
 
 (*
 *  %MOVES
 *)
 PROCEDURE MneMOVES;
 BEGIN
 ASSEMBLER  JMP     AERR19
 END
 END MneMOVES;
 
 
 
 (* Beginn der 68881 - Auswertung *)
 
 PROCEDURE FLoadSize;
 BEGIN
 ASSEMBLER  MOVE.B  SizeOfData,D0
)BNE     C1
)MOVEQ   #DefltSiz,D0
 C1       MOVE.B  D0,SizeOfData
 END
 END FLoadSize;
 
 
 (*
!* Anhngen des 68881 op-codes
!*)
 PROCEDURE ApndZw ;
 BEGIN
 ASSEMBLER  MOVE.L  D1,D0
)SWAP    D0
)JMP     ApndD0_W
 END
 END ApndZw ;
 
 
 (*
!* %RegTo0_2Zw
!*)
 PROCEDURE RegTo0_2Zw ;
 BEGIN
 ASSEMBLER  ANDI.L  #$07,D0
)SWAP    D0
)OR.L    D0,D1
 END
 END RegTo0_2Zw ;
 
 
 (*
!* %RegTo7_9Zw
!*)
 PROCEDURE RegTo7_9Zw ;
 BEGIN
 ASSEMBLER  ANDI.L  #$07,D0
)SWAP    D0
)LSL.L   #7,D0
)OR.L    D0,D1
 END
 END RegTo7_9Zw ;
 
 
 (*
!* %RegTo10_12Zw ;
!*)
 PROCEDURE RegTo10_12Zw ;
 BEGIN
 ASSEMBLER  ANDI.L  #$07,D0
)SWAP    D0
)LSL.L   #5,D0
)LSL.L   #5,D0
)OR.L    D0,D1
 END
 END RegTo10_12Zw ;
 
 
 (*
!* %SizeTo10_12Zw
!*)
 PROCEDURE SizeTo10_12Zw ;
 BEGIN
 ASSEMBLER  MOVEQ   #110%,D0
)CMPI.B  #$01,SizeOfData
)BEQ     SizeE
)MOVEQ   #100%,D0
)CMPI.B  #$02,SizeOfData
)BEQ     SizeE
)MOVEQ   #000%,D0
)CMPI.B  #$04,SizeOfData
)BEQ     SizeE
)MOVEQ   #001%,D0
)CMPI.B  #$08,SizeOfData
)BEQ     SizeE
)MOVEQ   #101%,D0
)CMPI.B  #$10,SizeOfData
)BEQ     SizeE
)MOVEQ   #010%,D0
)CMPI.B  #$20,SizeOfData
)BEQ     SizeE
)MOVEQ   #011%,D0
)CMPI.B  #$40,SizeOfData
)BEQ     SizeE
)JMP     AERR1
 SizeE    ANDI.L  #$07,D0
)SWAP    D0
)LSL.L   #5,D0
)LSL.L   #5,D0
)OR.L    D0,D1
 END
 END SizeTo10_12Zw ;
 
 
 (*
!* %FMOVECR
!*)
 PROCEDURE MneFMoveCr ;
 BEGIN
 ASSEMBLER  MOVEQ   #$20,D0
)JSR     VerifySize
)CMPI.B  #12,ModeSource
)BEQ     SOK
 AER1     JMP     AERR1
 SOK      CMPI.B  #25,ModeDest
)BNE     AER1
)MOVE.W  #1111111101010%,D3
)JSR     TestTypeSource
)MOVE.L  DataSource,D0
)CMPI.L  #$80,D0
)BCS     OK
)JMP     AERR2
 OK       SWAP    D0
)OR.L    D0,D1
)MOVE.B  RegDest,D0
)JSR     RegTo7_9Zw
)JMP     ApndZw
 END
 END MneFMoveCr ;
 
'
 (*
!* Ausfhren einer <ea>
!*)
 PROCEDURE ProcessEA ;
 BEGIN
 ASSEMBLER  JSR     ApndZw
)JSR     VerifyEA
)JSR     EATo0_5
)JMP     ApndEA
 END
 END ProcessEA ;
 
 
 (*
!* Append <fea>
!*)
 PROCEDURE Apndfea ;
 BEGIN
 ASSEMBLER  CMPI.B  #25,Mode
)BEQ     REGREGOP
)BSET    #30,D1
)JSR     FLoadSize
)CMPI.B  #02,Mode
)BNE     MOK
 AER1     JMP     AERR1
 AER2     JMP     AERR2
 MOK      BCC     SOK
)MOVE.B  SizeOfData,D0
)ANDI.B  #00001111%,D0
)BEQ     AER2
 SOK      JSR     SizeTo10_12Zw
)JMP     ProcessEA
 REGREGOP MOVEQ   #$20,D0
)JSR     VerifySize
)MOVE.B  Reg,D0
)JSR     RegTo10_12Zw
)JMP     ApndZw
 END
 END Apndfea ;
 
 
 (*
!* Verbiten von ..PC und #..
!*)
 PROCEDURE ErrOnImOrPc ;
 BEGIN
 ASSEMBLER  CMPI.B  #10,Mode
)BCS     OK
)JMP     AERR1
 OK
 END
 END ErrOnImOrPc ;
 
 
 (*
!* Eintragen von FPm  FPn oder <EA>  FPn
!*)
 PROCEDURE TrasferToFPn ;
 BEGIN
 ASSEMBLER  CMPI.B  #25,ModeDest
)BEQ     SOK
)JMP     AERR1
 SOK      MOVE.B  RegDest,D0
)JSR     RegTo7_9Zw
)JSR     SourceToLast
)JMP     Apndfea
 END
 END TrasferToFPn ;
 
 
 (*
!* %FMOVEM
!*)
 PROCEDURE MneFMoveM ;
 BEGIN
 ASSEMBLER  CMPI.B  #26,ModeDest
)BEQ     MnToFPnS
)CMPI.B  #26,ModeSource
)BEQ     MnFrFPnS
)CMPI.B  #01,ModeDest
)BEQ.L   MnToFPnD
)CMPI.B  #01,ModeSource
)BEQ.L   MnFrFPnD
)CMPI.B  #28,ModeDest
)BEQ.L   MnToFPcr
)CMPI.B  #28,ModeSource
)BEQ.L   MnFrFPcr
 AER1     JMP     AERR1
 ToMem    JSR     DestToLast
)CMPI.B  #10,Mode
)BCC     AER1
)CMPI.B  #04,Mode
)BEQ     AER1
)BSET    #29,D1
)RTS
 FromMem  JSR     SourceToLast
)CMPI.B  #05,Mode
)BEQ     AER1
)RTS
 MnToFPnS BSR     FromMem
)MOVE.W  RegListDest,D0
)BRA     MnMFPnS
 MnFrFPnS BSR     ToMem
)MOVE.W  RegListSource,D0
 MnMFPnS  CMPI.B  #05,Mode
)BEQ     ListOk
)MOVEQ   #7,D3
 REP      ROXR.B  #1,D0
)ROXL.B  #1,D2
)DBF     D3,REP
)MOVE.B  D2,D0
)BSET    #28,D1
 ListOk   ANDI.L  #$FF,D0
)SWAP    D0
)OR.L    D0,D1
)BRA     MnMFPn
 MnToFPnD BSR     FromMem
)MOVE.B  RegDest,D0
)BRA     MnMFPnD
 MnFrFPnD BSR     ToMem
)MOVE.B  RegSource,D0
 MnMFPnD  CMPI.B  #05,Mode
)BEQ     DirOk
)BSET    #28,D1
 DirOk    ANDI.L  #$7,D0
)LSL.W   #4,D0
)SWAP    D0
)OR.L    D0,D1
)BSET    #27,D1
 MnMFPn   CMPI.B  #02,Mode
)BLS     AER1H
)CMPI.B  #12,Mode
)BCC     AER1H
)MOVEQ   #$20,D0
)JSR     VerifySize
)MOVE.B  D0,SizeOfData
)BSET    #30,D1
)JMP     ProcessEA
 AER1H    BRA.L   AER1
 MnToFPcr JSR     SourceToLast
)MOVE.W  RegListDest,D0
)BRA     MnMFPcr
 MnFrFPcr JSR     DestToLast
)CMPI.B  #10,Mode
)BCC     AER1H
)BSET    #29,D1
)MOVE.W  RegListSource,D0
 MnMFPcr  ANDI.L  #7,D0
)LSL.W   #5,D0
)LSL.W   #5,D0
)SWAP    D0
)OR.L    D0,D1
)CMPI.B  #02,Mode
)BLS     AER1H
)CMPI.B  #12,Mode
)BCC     AER1H
)MOVEQ   #$04,D0
)JSR     VerifySize
)MOVE.B  D0,SizeOfData
)JMP     ProcessEA
 END
 END MneFMoveM ;
 
'
 (*
!* %FMOVE
!*)
 PROCEDURE MneFMove ;
 BEGIN
 ASSEMBLER  CMPI.B  #25,ModeDest
)BEQ     MnToFPn
)CMPI.B  #25,ModeSource
)BNE     MnMCCr
)CMPI.B  #29,ModeDest
)BEQ     MnFrFPn2
)CMPI.B  #30,ModeDest
)BEQ     MnFrFPn3
)BRA     MnFrFPn1
 MnMCCr   CMPI.B  #27,ModeDest
)BEQ.L   MnToFPcr
)CMPI.B  #27,ModeSource
)BEQ.L   MnFrFPcr
 AER1     JMP     AERR1
 AER2     JMP     AERR2
 MnToFPn  JMP     TrasferToFPn
 MnFrFPn3 MOVE.B  FormatDest,D0
)BRA     MnFrFpnP
 MnFrFPn2 BSET    #28,D1
)MOVE.B  FormatDest,D0
)LSL.B   #4,D0
 MnFrFPnP ANDI.L  #$7F,D0
)SWAP    D0
)OR.L    D0,D1
)CMPI.B  #$40,SizeOfData
)BNE     AER1
)MOVE.B  Mode2Dest,ModeDest
)BRA     MnFrFPn
 MnFrFPn1 CMPI.B  #$40,SizeOfData
)BEQ     AER1
 MnFrFPn  BSET    #29,D1
)MOVE.B  RegSource,D0
)JSR     RegTo7_9Zw
)JSR     DestToLast
)JSR     ErrOnImOrPc
)JMP     Apndfea
 MnToFPcr JSR     SourceToLast
)MOVE.B  RegDest,D0
)BRA     MnMFPcr
 MnFrFPcr JSR     DestToLast
)JSR     ErrOnImOrPc
)MOVE.B  RegSource,D0
)BSET    #29,D1
 MnMFPcr  ADDI.B  #26,D0
)BSET    D0,D1
)MOVE.B  Mode,D2
)CMPI.B  #02,D2
)BNE     MnAMOk
)CMPI.B  #26,D0
)BEQ     MnAMOk
)JMP     AERR1
 MnAMOk   BSET    #31,D1
)MOVEQ   #4,D0
)JSR     VerifySize
)MOVE.B  D0,SizeOfData
)JMP     ProcessEA
 END
 END MneFMove ;
 
'
 (*
!*  %FADD, %FCMP, %FDIV, %FMOD, %FMUL, %FREM, %FSCALE, %FSGLDIV, %FSGLMUL,
!*  %FSUB
!*)
 PROCEDURE MneDyOp ;
 BEGIN
 ASSEMBLER  JMP     TrasferToFPn
 END
 END MneDyOp ;
 
'
 (*
!* %FTST
!*)
 PROCEDURE MneFTst ;
 BEGIN
 ASSEMBLER  JSR     ErrIfOp2
)JSR     SourceToLast
)JMP     Apndfea
 END
 END MneFTst ;
 
'
 (*
!* %FABS, %FACOS, %FASIN, %FATAN, %FATANH, %FCOS, %FCOSH, %FETOX, %FETOXM1,
!* %FGETEXP, %FGETMAN, %FINT, %FINTRZ, %FLOGN, %FLOGNP1, %FLOG10, %FLOG2,
!* %FNEG, %FSIN, %FSINH, %FSQRT, %FTAN, %FTANH, %FTENTOX, %FTWOTOX
!*)
 PROCEDURE MneMoOp ;
 BEGIN
 ASSEMBLER  Tst.W   ModeDest
)BNE     ToOpSpez
)JSR     SourceToLast
)JSR     LastToDest
 ToOpSpez JMP     TrasferToFPn
 END
 END MneMoOp  ;
 
'
 (*
!* %FSINCOS
!*)
 PROCEDURE MneDualMoOp ;
 BEGIN
 ASSEMBLER  CMPI.B  #$80+25,ModeDest
)BEQ     SOK
 AER1     JMP     AERR1
 SOK      BCLR    #7,ModeDest
)CMPI.B  #25,Mode2Dest
)BNE     AER1
)MOVE.B  RegDest,D0
)CMP.B   Reg2Dest,D0
)BEQ     AER1
)JSR     RegTo0_2Zw
)MOVE.B  Reg2Dest,RegDest
)JMP     TrasferToFPn
 END
 END MneDualMoOp ;
 
 
 (*
!* %FSAVE
!*)
 PROCEDURE MneFSave ;
 BEGIN
 ASSEMBLER  JSR     ErrIfSize
)MOVE.B  ModeSource,D0
)CMPI.B  #10,D0
)BCS     OK
 !AER1    JMP     AERR1
 !OK      CMPI.B  #2,D0
)BLS     AER1
)CMPI.B  #4,D0
)BEQ     AER1
)JSR     SourceTo0_5
)JSR     ApndSource
)JMP     ErrIfOp2
 END
 END MneFSave ;
 
'
 (*
!* %FRESTORE
!*)
 PROCEDURE MneFRes ;
 BEGIN
 ASSEMBLER  JSR     ErrIfSize
)MOVE.B  ModeSource,D0
)CMPI.B  #12,D0
)BCS     OK
 !AER1    JMP     AERR1
 !OK      CMPI.B  #2,D0
)BLS     AER1
)CMPI.B  #5,D0
)BEQ     AER1
)JSR     SourceTo0_5
)JSR     ApndSource
)JMP     ErrIfOp2
 END
 END MneFRes ;
 
'
 (*
!* %FScc
!*)
 PROCEDURE MneFScc ;
 BEGIN
 ASSEMBLER  JSR     ApndZw
)JMP     MN25
 END
 END MneFScc ;
 
'
 (*
!* %FTRAPcc
!*)
 PROCEDURE MneFTRAPcc ;
 BEGIN
 ASSEMBLER
)JSR     ApndZw
)JMP     MneTRAPcc
 END
 END MneFTRAPcc ;
 
'
 (*
!*   %FBcc
!*)
 PROCEDURE MneFBcc;
 BEGIN
 ASSEMBLER  JSR     ErrIfOp2
)MOVEQ   #2,D0
)JSR     VerifySize
)MOVE.B  D0,SizeOfData  ; '.W' als Default
)JSR     SourceToLast
)JMP     @MN7A
 END
 END MneFBcc;
 
 
 (*
!*  %FDBcc
!*)
 PROCEDURE MneFDBcc;
 BEGIN
 ASSEMBLER  MOVE.B  ModeSource,D0
)CMPI.B  #1,D0          ;Source = 'Dn' ?
)BEQ     OK
)JMP     AERR1          ;nein:ERROR
 !OK      MOVEQ   #2,D0
)JSR     VerifySize
)MOVE.B  D0,SizeOfData  ; '.W' als Default
)JSR     ApndZw
)MOVE.B  RegSource,D0
)JSR     RegTo0_2       ;setze Reg. in Code-Wort
)JSR     DestToLast
)JMP     @MN7A
 END
 END MneFDBcc;
 
 (* Ende Gepard-Conditional *) *)
 
 PROCEDURE MneJmpTab;
 BEGIN
 ASSEMBLER
)DC.L    MN0
)DC.L    MN0
)DC.L    MN31
)DC.L    MN31
)DC.L    MN1    ;%ADD
)DC.L    MN1    ;%AND
)DC.L    MN1    ;%OR
)DC.L    MN1    ;%SUB
)DC.L    MN2    ;%ADDA
)DC.L    MN2    ;%CMPA
)DC.L    MN2    ;%SUBA
)DC.L    MN32   ;%MOVEA
)DC.L    MN3    ;%ADDI
)DC.L    MN3    ;%CMPI
)DC.L    MN3    ;%SUBI
)DC.L    MN4    ;%ANDI
)DC.L    MN4    ;%EORI
)DC.L    MN4    ;%ORI
)DC.L    MN5    ;%ADDQ
)DC.L    MN5    ;%SUBQ
)DC.L    MN6    ;%ASL
)DC.L    MN6    ;%ASR
)DC.L    MN6    ;%LSL
)DC.L    MN6    ;%LSR
)DC.L    MN6    ;%ROL
)DC.L    MN6    ;%ROR
)DC.L    MN6    ;%ROXL
)DC.L    MN6    ;%ROXR
)DC.L    MN7    ;%BCC           %Bcc
)DC.L    MN7    ;%BCS
)DC.L    MN7    ;%BEQ
)DC.L    MN7    ;%BGE
)DC.L    MN7    ;%BGT
)DC.L    MN7    ;%BHI
)DC.L    MN7    ;%BLE
)DC.L    MN7    ;%BLS
)DC.L    MN7    ;%BLT
)DC.L    MN7    ;%BMI
)DC.L    MN7    ;%BNE
)DC.L    MN7    ;%BPL
)DC.L    MN7    ;%BVC
)DC.L    MN7    ;%BVS
)DC.L    MN7    ;%BRA
)DC.L    MN7    ;%BSR
)DC.L    MN8    ;%BCHG
)DC.L    MN8    ;%BCLR
)DC.L    MN8    ;%BSET
)DC.L    MN9    ;%BTST
)DC.L    MneCHK ;%CHK
)DC.L    MN10   ;%MULS
)DC.L    MN10   ;%MULU
)DC.L    MN10   ;%DIVS
)DC.L    MN10   ;%DIVU
)DC.L    MN11   ;%CLR
)DC.L    MN11   ;%NEG
)DC.L    MN11   ;%NEGX
)DC.L    MN11   ;%NOT
)DC.L    MneTST ;%TST
)DC.L    MN12   ;%CMP
)DC.L    MN13   ;%CMPM
)DC.L    MN14   ;               %DBcc
)DC.L    MN14
)DC.L    MN14
)DC.L    MN14
)DC.L    MN14
)DC.L    MN14
)DC.L    MN14
)DC.L    MN14
)DC.L    MN14
)DC.L    MN14
)DC.L    MN14
)DC.L    MN14
)DC.L    MN14
)DC.L    MN14
)DC.L    MN14
)DC.L    MN14
)DC.L    MN14
)DC.L    MN15   ;%EOR
)DC.L    MN16   ;%EXG
)DC.L    MneEXT ;%EXT
)DC.L    MN18   ;%JMP
)DC.L    MN18   ;%JSR
)DC.L    MN18P  ;%PEA
)DC.L    MN19   ;%LEA
)DC.L    MN20   ;%LINK
)DC.L    MN21   ;%MOVE
)DC.L    MN22   ;%MOVEM
)DC.L    MN23   ;%MOVEP
)DC.L    MN24   ;%MOVEQ
)DC.L    MN25   ;%NBCD
)DC.L    MN25   ;%SCC           %Scc
)DC.L    MN25
)DC.L    MN25
)DC.L    MN25
)DC.L    MN25
)DC.L    MN25
)DC.L    MN25
)DC.L    MN25
)DC.L    MN25
)DC.L    MN25
)DC.L    MN25
)DC.L    MN25
)DC.L    MN25
)DC.L    MN25
)DC.L    MN25
)DC.L    MN25
)DC.L    MN25           ;%TAS
)DC.L    NoOperands     ;%NOP
)DC.L    NoOperands     ;%RTE
)DC.L    NoOperands     ;%RTS
)DC.L    NoOperands     ;%TRAPV
)DC.L    NoOperands     ;%RESET
)DC.L    MneSTOP_RTD    ;%STOP
)DC.L    MN28           ;%SWAP
)DC.L    MN29           ;%TRAP
)DC.L    MN30           ;%UNLK
)DC.L    NoOperands     ;%RTR
)DC.L    MN14           ;%DBRA
)DC.L    NoOperands     ;%ILLEGAL
)DC.L    NoOperands     ;%BREAK
)DC.L    MneMOVEC       ;%MOVEC
)DC.L    MneSTOP_RTD    ;%RTD
 (*$ ? Asm20:
); Erweiterungen seit 3.3a / 1.8.86 f. 68020
)DC.L    MneBitFea      ;%BFCHG
)DC.L    MneBitFea      ;%BFCLR
)DC.L    MneBitFea_     ;%BFEXTS
)DC.L    MneBitFea_     ;%BFEXTU
)DC.L    MneBitFea_     ;%BFFFO
)DC.L    MneBitF_ea     ;%BFINS
)DC.L    MneBitFea      ;%BFSET
)DC.L    MneBitFea2     ;%BFTST
)DC.L    MneBKPT        ;%BKPT
)DC.L    MneCALLM       ;%CALLM
)DC.L    MneCAS         ;%CAS
)DC.L    MneCAS2        ;%CAS2
)DC.L    MneCHK2_CMP2   ;%CHK2
)DC.L    MneCHK2_CMP2   ;%CMP2
)DC.L    MneDIVSL_UL    ;%DIVSL
)DC.L    MneDIVSL_UL    ;%DIVUL
)DC.L    MneEXT         ;%EXTB
)DC.L    MneMOVES       ;%MOVES
)DC.L    MnePACK_UNPK   ;%PACK
)DC.L    MneRTM         ;%RTM
)DC.L    MneTRAPcc      ;%TRAPCC
)DC.L    MneTRAPcc      ;%TRAPCS
)DC.L    MneTRAPcc      ;%TRAPEQ
)DC.L    MneTRAPcc      ;%TRAPF
)DC.L    MneTRAPcc      ;%TRAPGE
)DC.L    MneTRAPcc      ;%TRAPGT
)DC.L    MneTRAPcc      ;%TRAPHI
)DC.L    MneTRAPcc      ;%TRAPLE
)DC.L    MneTRAPcc      ;%TRAPLS
)DC.L    MneTRAPcc      ;%TRAPLT
)DC.L    MneTRAPcc      ;%TRAPMI
)DC.L    MneTRAPcc      ;%TRAPNE
)DC.L    MneTRAPcc      ;%TRAPPL
)DC.L    MneTRAPcc      ;%TRAPT
)DC.L    MneTRAPcc      ;%TRAPVC
)DC.L    MneTRAPcc      ;%TRAPVS
)DC.L    MnePACK_UNPK   ;%UNPK
)
); Erweiterung fr 68881
)DC.L    MneFMove       ;%FMOVE        ; Umspeichern
)DC.L    MneFMoveCr     ;%FMOVECR
)DC.L    MneFMoveM      ;%FMOVEM
)DC.L    MneFRes        ;%FRESTORE
)DC.L    MneFSave       ;%FSAVE
)DC.L    NoOperandsWZE  ;%FNOP
)DC.L    MneFTst        ;%FTST
)DC.L    MneFBcc        ;%FBEQ         ; Controls
)DC.L    MneFBcc        ;%FBF
)DC.L    MneFBcc        ;%FBGE
)DC.L    MneFBcc        ;%FBGL
)DC.L    MneFBcc        ;%FBGLE
)DC.L    MneFBcc        ;%FBGT
)DC.L    MneFBcc        ;%FBLE
)DC.L    MneFBcc        ;%FBLT
)DC.L    MneFBcc        ;%FBNE
)DC.L    MneFBcc        ;%FBNGE
)DC.L    MneFBcc        ;%FBNGL
)DC.L    MneFBcc        ;%FBNGLE
)DC.L    MneFBcc        ;%FBNGT
)DC.L    MneFBcc        ;%FBNLE
)DC.L    MneFBcc        ;%FBNLT
)DC.L    MneFBcc        ;%FBSEQ
)DC.L    MneFBcc        ;%FBSF
)DC.L    MneFBcc        ;%FBSNE
)DC.L    MneFBcc        ;%FBST
)DC.L    MneFBcc        ;%FBOGE
)DC.L    MneFBcc        ;%FBOGL
)DC.L    MneFBcc        ;%FBOGT
)DC.L    MneFBcc        ;%FBOLE
)DC.L    MneFBcc        ;%FBOLT
)DC.L    MneFBcc        ;%FBOR
)DC.L    MneFBcc        ;%FBT
)DC.L    MneFBcc        ;%FBUGE
)DC.L    MneFBcc        ;%FBUEQ
)DC.L    MneFBcc        ;%FBUN
)DC.L    MneFBcc        ;%FBUGT
)DC.L    MneFBcc        ;%FBULE
)DC.L    MneFBcc        ;%FBULT
)DC.L    MneFDBcc       ;%FDBEQ
)DC.L    MneFDBcc       ;%FDBF
)DC.L    MneFDBcc       ;%FDBGE
)DC.L    MneFDBcc       ;%FDBGL
)DC.L    MneFDBcc       ;%FDBGLE
)DC.L    MneFDBcc       ;%FDBGT
)DC.L    MneFDBcc       ;%FDBLE
)DC.L    MneFDBcc       ;%FDBLT
)DC.L    MneFDBcc       ;%FDBNE
)DC.L    MneFDBcc       ;%FDBNGE
)DC.L    MneFDBcc       ;%FDBNGL
)DC.L    MneFDBcc       ;%FDBNGLE
)DC.L    MneFDBcc       ;%FDBNGT
)DC.L    MneFDBcc       ;%FDBNLE
)DC.L    MneFDBcc       ;%FDBNLT
)DC.L    MneFDBcc       ;%FDBSEQ
)DC.L    MneFDBcc       ;%FDBSF
)DC.L    MneFDBcc       ;%FDBSNE
)DC.L    MneFDBcc       ;%FDBST
)DC.L    MneFDBcc       ;%FDBOGE
)DC.L    MneFDBcc       ;%FDBOGL
)DC.L    MneFDBcc       ;%FDBOGT
)DC.L    MneFDBcc       ;%FDBOLE
)DC.L    MneFDBcc       ;%FDBOLT
)DC.L    MneFDBcc       ;%FDBOR
)DC.L    MneFDBcc       ;%FDBT
)DC.L    MneFDBcc       ;%FDBUGE
)DC.L    MneFDBcc       ;%FDBUEQ
)DC.L    MneFDBcc       ;%FDBUN
)DC.L    MneFDBcc       ;%FDBUGT
)DC.L    MneFDBcc       ;%FDBULE
)DC.L    MneFDBcc       ;%FDBULT
)DC.L    MneFScc        ;%FSEQ
)DC.L    MneFScc        ;%FSF
)DC.L    MneFScc        ;%FSGE
)DC.L    MneFScc        ;%FSGL
)DC.L    MneFScc        ;%FSGLE
)DC.L    MneFScc        ;%FSGT
)DC.L    MneFScc        ;%FSLE
)DC.L    MneFScc        ;%FSLT
)DC.L    MneFScc        ;%FSNE
)DC.L    MneFScc        ;%FSNGE
)DC.L    MneFScc        ;%FSNGL
)DC.L    MneFScc        ;%FSNGLE
)DC.L    MneFScc        ;%FSNGT
)DC.L    MneFScc        ;%FSNLE
)DC.L    MneFScc        ;%FSNLT
)DC.L    MneFScc        ;%FSSEQ
)DC.L    MneFScc        ;%FSSF
)DC.L    MneFScc        ;%FSSNE
)DC.L    MneFScc        ;%FSST
)DC.L    MneFScc        ;%FSOGE
)DC.L    MneFScc        ;%FSOGL
)DC.L    MneFScc        ;%FSOGT
)DC.L    MneFScc        ;%FSOLE
)DC.L    MneFScc        ;%FSOLT
)DC.L    MneFScc        ;%FSOR
)DC.L    MneFScc        ;%FST
)DC.L    MneFScc        ;%FSUGE
)DC.L    MneFScc        ;%FSUEQ
)DC.L    MneFScc        ;%FSUN
)DC.L    MneFScc        ;%FSUGT
)DC.L    MneFScc        ;%FSULE
)DC.L    MneFScc        ;%FSULT
)DC.L    MneFTRAPcc     ;%FTRAPEQ
)DC.L    MneFTRAPcc     ;%FTRAPF
)DC.L    MneFTRAPcc     ;%FTRAPGE
)DC.L    MneFTRAPcc     ;%FTRAPGL
)DC.L    MneFTRAPcc     ;%FTRAPGLE
)DC.L    MneFTRAPcc     ;%FTRAPGT
)DC.L    MneFTRAPcc     ;%FTRAPLE
)DC.L    MneFTRAPcc     ;%FTRAPLT
)DC.L    MneFTRAPcc     ;%FTRAPNE
)DC.L    MneFTRAPcc     ;%FTRAPNGE
)DC.L    MneFTRAPcc     ;%FTRAPNGL
)DC.L    MneFTRAPcc     ;%FTRAPNGLE
)DC.L    MneFTRAPcc     ;%FTRAPNGT
)DC.L    MneFTRAPcc     ;%FTRAPNLE
)DC.L    MneFTRAPcc     ;%FTRAPNLT
)DC.L    MneFTRAPcc     ;%FTRAPSEQ
)DC.L    MneFTRAPcc     ;%FTRAPSF
)DC.L    MneFTRAPcc     ;%FTRAPSNE
)DC.L    MneFTRAPcc     ;%FTRAPST
)DC.L    MneFTRAPcc     ;%FTRAPOGE
)DC.L    MneFTRAPcc     ;%FTRAPOGL
)DC.L    MneFTRAPcc     ;%FTRAPOGT
)DC.L    MneFTRAPcc     ;%FTRAPOLE
)DC.L    MneFTRAPcc     ;%FTRAPOLT
)DC.L    MneFTRAPcc     ;%FTRAPOR
)DC.L    MneFTRAPcc     ;%FTRAPT
)DC.L    MneFTRAPcc     ;%FTRAPUGE
)DC.L    MneFTRAPcc     ;%FTRAPUEQ
)DC.L    MneFTRAPcc     ;%FTRAPUN
)DC.L    MneFTRAPcc     ;%FTRAPUGT
)DC.L    MneFTRAPcc     ;%FTRAPULE
)DC.L    MneFTRAPcc     ;%FTRAPULT
)DC.L    MneDyOp        ;%FADD         ; Dyadic Operations
)DC.L    MneDyOp        ;%FCMP
)DC.L    MneDyOp        ;%FDIV
)DC.L    MneDyOp        ;%FMOD
)DC.L    MneDyOp        ;%FMUL
)DC.L    MneDyOp        ;%FREM
)DC.L    MneDyOp        ;%FSCALE
)DC.L    MneDyOp        ;%FSGLDIV
)DC.L    MneDyOp        ;%FSGLMUL
)DC.L    MneDyOp        ;%FSUB
)DC.L    MneMoOp        ;%FABS         ; Monidic Operations
)DC.L    MneMoOp        ;%FACOS
)DC.L    MneMoOp        ;%FASIN
)DC.L    MneMoOp        ;%FATAN
)DC.L    MneMoOp        ;%FATANH
)DC.L    MneMoOp        ;%FCOS
)DC.L    MneMoOp        ;%FCOSH
)DC.L    MneMoOp        ;%FETOX
)DC.L    MneMoOp        ;%FETOXM1
)DC.L    MneMoOp        ;%FGETEXP
)DC.L    MneMoOp        ;%FGETMAN
)DC.L    MneMoOp        ;%FINT
)DC.L    MneMoOp        ;%FINTRZ
)DC.L    MneMoOp        ;%FLOGN
)DC.L    MneMoOp        ;%FLOGNP1
)DC.L    MneMoOp        ;%FLOG10
)DC.L    MneMoOp        ;%FLOG2
)DC.L    MneMoOp        ;%FNEG
)DC.L    MneMoOp        ;%FSIN
)DC.L    MneMoOp        ;%FSINH
)DC.L    MneMoOp        ;%FSQRT
)DC.L    MneMoOp        ;%FTAN
)DC.L    MneMoOp        ;%FTANH
)DC.L    MneMoOp        ;%FTENTOX
)DC.L    MneMoOp        ;%FTWOTOX
)DC.L    MneDualMoOp    ;%FSINCOS      ; Dual Monadic Operation
 *)
 END
 END MneJmpTab;
  
(* $000082EC$00010C48$00010CCD$00010D53$0002194C$FFFCB948$FFFCB948$FFFCB948$FFFCB948$FFFCB948$FFFCB948$FFFCB948$FFFCB948$FFFCB948$FFFCB948$00008F25$FFFCB948$00017E98$FFFCB948$FFFCB948$FFFCB948$FFFCB948$FFFCB948$FFFCB948$FFFCB948$FFFCB948$FFFCB948$FFFCB948$FFFCB948$0001E2F9$0000899F$FFFCB948$FFFCB948$FFFCB948$FFFCB948$FFFCB948$FFFCB948$FFFCB948$FFFCB948$FFFCB948$FFFCB948$FFFCB948$0001217AT.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$00008F35$00008F99$000121F8$000228EF$0001212B$0001219D$0001217A$00012197$0001214A$00020855$00020876$000208AE$00020894$00020870$00001D59$00001D83*)
