 MODULE MM2Make;
 (*$Z+,R-*)
 
 (*
!to do:
 
!- beim suchen nach codes auch den comp-pfad der shell-option-box berck-
#sichtigen!
 
!- option f. make & build, ob die output-pfade bestimmt werden sollen
#oder nicht. auerdem fehlende output-pfade ggf. hervorheben
 
!- compiler mu per option (z.b. $O <name>) output-path auswerten
 
!- die vierfachen langen procs, wie z.b. GetSrcTimes, zusammenfassen
 *)
 
 (*----------------------------------------------------------------------------
!* Make-Utility fr Megamax Modula-2
!*
!*    Liest eine Make-Datei (als Argument zu bergeben, ansonsten in der
!*    Shell einzustellen) ein, die alle Import-Abhngigkeiten eines
!*    Projekts beschreibt und compiliert anhand der Zeitangaben der
!*    Textdateien und der zugehrigen Codedateien alle vernderten
!*    Module neu.
!*
!* In der Argumentzeile kann auch "-B" fr "Build" bergeben werden.
!*
!* Exitcodes:
!*   0: Es sind Module zu compilieren
!*   1: Alle Module sind bereits korrekt compiliert
!*   2: Es sind Syntax-Fehler aufgetreten
!*   3: Es sind allg. Fehler aufgetreten
!*
!* Das Format der Make-Datei:
!*    Am Anfang einer Zeile steht ein Modulname , dann entweder '-DEF',
!*    '-IMP' oder '-MOD'. Dann folgen der Codedateiname und, falls, vorhanden,
!*    der Quelldateiname. Ist der Quelltext vorhanden, folgt '-SOURCE' und
!*    der Name der Quelltextdatei. Gibt es zum Quelltext Includedateien, so
!*    werden diese nach -INC aufgezhlt. Die Liste wird durch einen einzelnen
!*    Strichpunkt abgeschlossen. Werden andere Module importiert, mssen
!*    sie mit '-IMPORT' eingeleitet werden, dann folgen die importierten
!*    Modulnamen. Das Ende der Importnamen mu durch einen einzelnen Strich-
!*    punkt angegeben werden. Sind andere Dateien abhngig (z.B RSC-Dateien),
!*    sind sie mit -USES aufzuzhlen (wie Importe und Include-Dateien).
!*    Die importierten Modulnamen mssen alle nochmal irgendwo in der Datei
!*    mit "<Modulname> -DEF <Codedateiname> -IMP <Codedateiname>" aufgefhrt
!*    werden!
!*    Ein Implementationsmodul, das kein DEF zur Prfung braucht (als
!*    Hauptmodul, beispielsweise Treiber, wie GEMIO), wird mit '-IMPMOD'
!*    eingeleitet.
!*    Wenn bei einem Dateinamen kein Pfad angegeben ist, wird auf den von
!*    Shell und Compiler benutzten Pfaden (siehe Modul 'ShellMsg') gesucht
!*    (bei Includes wird auf den Source-Pfaden, bei USES auf den StdPaths
!*    "DefaultPath" gesucht).
!*
!* Beispiel fr eine Make-Datei:
!*
!*    Test         -MAIN
!*                 -MOD    D:\TEST.MOD
!*                 -SOURCE D:\TEST.M
!*                 -IMPORT InOut MyUtility;
!*                 -USES   D:\TEST.RSC
!*    MyUtility    -IMP    D:\CODES.IMP\MyUtil.IMP
!*                 -SOURCE D:\MyUtil.I
!*                 -INC    D:\MyUtil.H ;
!*                 -IMPORT TimeConvert
!*                         Clock
!*                         ;
!*                 -DEF    D:\CODES.DEF\MyUtil.DEF
!*                 -SOURCE D:\MyUtil.D
!*                 -IMPORT Clock ;
!*    TimeConvert  -DEF    TIMECONV.DEF  (* IMP unntig, wenn kein Source *)
!*                 -NOSRC                (* anzeigen, da kein Source vorhand.*)
!*    Clock        -DEF    CLOCK.DEF
!*                 -NOSRC
!*                 -IMP    CLOCK.IMP
!*                 -NOSRC
!*    MyIO         -IMPMOD MYIO.IMP      (* bentigt kein -DEF *)
!*                 -SOURCE MYIO.I
!*
!*----------------------------------------------------------------------------
!* TT     : Thomas Tempelmann
!* CD     : Christian Driele
!*----------------------------------------------------------------------------
!* Datum     Version  Autor  Bemerkung (Arbeitsbericht)
!*----------------------------------------------------------------------------
!* 02.03.88  1.0      TT     Grundversion
!* 03.03.89           CD     Ermglicht, da zu einem Modul IMP und DEF erlaubt
!*                           sind.
!* 04.03.89           CD     Rekursiven Modulbaum-durchsuch-algorithmus erprobt.
!* 05.03.89           CD     Alle Files in 5 Listen verteilt:
!*                             - ModCodes
!*                             - DefCodes
!*                             - ImpCodes
!*                             - Sources
!*                             - withPath (Files mit ausdrcklich angegebenem
!*                                         Pfadnamen)
!*                           Die Files dieser Listen werden Pfadweise nachein-
!*                           einander gesucht und die Zeit eingelesen.
!* 07.03.89           CD     Neue Errungenschaften vom 5.3. getestet und
!*                           korrigiert.
!*                           Nachfrage bei fehlendem Code und vorhandenem
!*                           Source.
!*                           IMP mit Source aber ohne IMPORT geht jetzt auch
!*                           am Ende der Makedatei.
!*                           Rekursive Suche durch den Modulbaum implementiert
!*                           mit markieren der zu bersetzenden Dateien.
!*                           Suche auch im Defaultpfad nach allen Sorten von
!*                           Dateien.
!* 08.03.89  1.01     CD     Include-Dateien knnen angegeben werden und sie
!*                           werden bercksichtigt.
!*                           Es wird eine Datei mit Include-Anweisungen fr
!*                           den Compiler erzeugt.
!* 09.03.89           CD     toMoment berichigt ( * $10000L), bei nicht ge
!*                           gefundenem Code wird date und time auf 0 gesetzt.
!* 08.08.89           TT     lauffhige Version fertiggestellt
!* 19.08.89           TT     "-MAIN"-ID neu; bei Fehler wird TextName, TextLine
!*                           und TextCol gesetzt; bei Erfolg wird CodeName
!*                           nach -MAIN gesetzt; MakeFileName importiert
!* 19.08.89           TT     TemporaryPath statt M2Home verwendet
!* 20.09.89           TT     Nur erster MAIN-Name wird nach CodeName bernommen.
!* 09.01.90           TT     Test-Funktion showIdents zeigt bei Importen deren
!*                           Modul- statt Code-Namen an
!* 18.01.90  1.2      TT     Wenn Pfad angegeben, wird trotzdem auch auf den
!*                           anderen Such-Pfaden gesucht
!* 04.03.90           TT     Durch '-NOSRC' wird keine Sourceangabe mehr
!*                           verlangt, wenn nur Code angegeben werden soll.
!* 11.03.90  1.3      TT     Meckert bei -NOSRC nicht mehr ber falsches Datum.
!*                           Noch zu tun: Bei IMP meckert er u.U. (wenn DEF
!*                           neu ist) ber Datum, auerdem wird bei Nichtangabe
!*                           des IMP dann nicht erkannt, da Clients neu
!*                           compiliert werden mssen.
!* 08.05.90           TT     'ignoreSource'-Abfrage in 'chkDate' entfernt.
!* 20.07.90           TT     "-B" fr Build eingebaut
!* 23.07.90           TT     Vielleicht werden fehlende Sources nun korrekt
!*                           bemngelt.
!* 18.08.90           TT     Noch ein paar ReplaceHome-Aufrufe eingefgt.
!* 10.11.90           TT     $R-, $Z+
!* 28.11.90           TT     Syntax-Fehler besser erkannt und ausfhrlichere
!*                           Fehlermeldung; Nun wird entw. -SOURCE oder -NOSRC
!*                           verlangt. Bei "NOSRC" und fehlendem Code wird nun
!*                           der Fehler korrekt gemeldet.
!* 19.02.91  1.4      TT     In Outfile steht nun jew. einer der Clienten, der
!*                           die bersetzung erzwingt.
!* 15.03.91           TT     "-BI" fr BuildImp (nur Implementations) eingebaut
!* 25.04.91           TT     Reason bei Includes/Uses wird korrekt angegeben.
!*----------------------------------------------------------------------------
!*)
 
 
 FROM SYSTEM IMPORT ASSEMBLER, ADDRESS, ADR;
 
 FROM ArgCV IMPORT InitArgCV, PtrArgStr;
 
 FROM InOut IMPORT
(FlushKbd, GotoXY, WriteLn, WriteString, Write, Read, ReadString,
(WriteInt, WriteCard, BusyRead, KeyPressed;
 
 FROM Directory IMPORT
(GetDirEntry, DirQuery, DirEntry;
 
 FROM FileNames IMPORT
(ValidatePath, ConcatPath, SplitPath;
 
 FROM MOSGlobals IMPORT FileStr;
 
 FROM Clock IMPORT
(CurrentDate, CurrentTime, PackDate, PackTime,
(UnpackDate, UnpackTime, Date, Time;
 
 FROM TimeConvert IMPORT
(TimeToText, DateToText;
 
 FROM Files IMPORT
(File, Access, Open, State, GetStateMsg, ResetState, Close, EOF,
(SetDateTime, GetDateTime, Create, ReplaceMode, Remove;
 
 IMPORT Text;
 
 FROM PathEnv IMPORT
(HomePath, ReplaceHome, HomeReplaced;
 FROM Paths IMPORT
(SearchFile, ListPos;
 FROM PathCtrl IMPORT
(PathList, PathEntry;
 
 FROM ShellMsg IMPORT
(CodeName, TextName, TextLine, TextCol, ModuleName, ErrorMsg, Active,
(ShellPath, MakeFileName, ModPaths, DefPaths, ImpPaths, SrcPaths,
(TemporaryPath;
 
 FROM Lists IMPORT
(List, LCarrier, CreateList, AppendEntry, InsertEntry, NextEntry,
(ScanEntries, LDir, LCondProc, ResetList, RemoveEntry, ListEmpty;
 
 IMPORT Storage;
 
 FROM Storage IMPORT
(DEALLOCATE;
 
 FROM PrgCtrl IMPORT
(TermProcess;
 
 FROM Strings IMPORT
(Empty, StrEqual, Upper, Insert, Copy, Length, Pos, PosLen, String,
(Split, EatSpaces, Assign, Concat, Append, Delete;
 
 IMPORT FastStrings, FuncStrings;
 
 TYPE
(CharSet = SET OF CHAR;
 
 CONST
(titl1 = ' MM2Make V1.4 fr Megamax Modula-2';
(titl2 = ' Erstellt 3/1989 von Thomas Tempelmann & Christian Driele';
(noMem = 'Zu wenig Speicher!';
(noFile= 'Make-Datei ist leer!';
(readng= 'Lese ';
(scanin= 'Prfe Dateien';
(datErr= ' hat ungltiges Datum!';
(toComp= 'Der Compiler wartet schon...';
(noComp= 'Alles OK';
(filErr= 'Dateifehler: ';
(dblid = 'Modul ist doppelt deklariert!';
(notDef= ' wurde nicht oder unvollstndig deklariert!';
(opnErr= 'Datei(en) nicht gefunden!';
(noCom = 'Ausgabedatei konnte nicht angelegt werden! (Stimmt "Temp.Pfad"?)';
(synErr= 'Syntaxfehler: ';
(nameExp='Modulname erwartet.';
(fileExp='Dateiname erwartet.';
(typeExp='Modulkennung (DEF/IMP/MOD) erwartet.';
(srcExp ='Source-Kennung (SOURCE/NOSRC) erwartet.';
(srcnExp='Quelltextname erwartet.';
(remErr= 'Remove in Liste haut nicht hin!';
(eoprg = 'Programmende. Taste drcken...';
(NoCodeMsg = 'No Code';
(SelfMsg   = 'Modified';
 
(maybe = CharSet {'j', 'J', 'n', 'N'};
(no = CharSet {'n', 'N'};
(
(compFileName = 'MAKE.M2C';    (* temp.File f. Compiler, nach ShellMsg *)
 
 TYPE
(FileType= (def, imp, mod, src, inc, uses);
(ModType = [def..mod];
 
(ImpList = POINTER TO ImpDesc;
(IncList = POINTER TO IncDesc;
(PtrMod  = POINTER TO ModDesc;
(
(ImpDesc = RECORD
4next: ImpList;
4modPtr : PtrMod
2END;
(
(IncDesc = RECORD
4fullname: ARRAY [0..80] OF CHAR;
4date, time : CARDINAL;
4next : IncList;
2END;
 
(ModDesc = RECORD
4name: String;
4type: ModType;
4codeName: String;
4date, time: CARDINAL;
4checked: BOOLEAN;
4ignore: BOOLEAN;
4CASE withSource: BOOLEAN OF
6TRUE: sourceName: String;
<sdate, stime: CARDINAL;
<uses, include : IncList;
<import: ImpList;
4| FALSE: ignoreSource: BOOLEAN;
4END
2END;
 
(moment = LONGCARD;
 
 
 VAR
(build, buildImp, waitAtEnd, ok, error: BOOLEAN;
(exitCode: INTEGER;
(f, compfile : File;
(modlist: List; (* OF ModDesc *)
 
 (*!TT*)
 PROCEDURE term3 (REF s: ARRAY OF CHAR);
"VAR c:CHAR;
"BEGIN
$WriteLn;
$WriteString (s);
$WriteLn;
$WriteLn;
$WriteString (eoprg);
$FlushKbd;
$Read (c);
$ResetState (f);
$Close (f);
$TermProcess (3)
"END term3;
 
 (*!TT*)
 PROCEDURE termNoMem;
"BEGIN
$term3 (noMem);
"END termNoMem;
 
 PROCEDURE term (s: ARRAY OF CHAR);
"VAR c:CHAR;
"BEGIN
$(*!TT*)
$IF Active THEN
&FastStrings.Assign (s, ErrorMsg);
$ELSE
&WriteLn;
&WriteString (s);
&WriteLn;
&WriteLn;
&WriteString (eoprg);
&FlushKbd;
&Read (c);
$END;
$ResetState (f);
$Close (f);
$TermProcess (2)
"END term;
 
 
 PROCEDURE ALLOCATE (VAR p:ADDRESS; l:LONGCARD);
"BEGIN
$Storage.ALLOCATE (p,l);
$IF p=NIL THEN termNoMem END
"END ALLOCATE;
 
 (*$Z-*)
 PROCEDURE chkavail (d1, d2: ADDRESS): BOOLEAN;
 (*$Z=*)
"VAR actmod: PtrMod; chkmod: POINTER TO PtrMod; eq: BOOLEAN;
"(*$L-*)
"BEGIN
$(*
&actmod:= d1;
&chkmod:= d2;
&eq:= (actmod^.type = chkmod^^.type)
)& StrEqual (actmod^.name, chkmod^^.name);
&IF eq THEN chkmod^:= actmod END;
&RETURN eq
$*)
$ASSEMBLER
(MOVE.L  -(A3),A2        ; d2
(MOVE.L  A2,-(A7)
(MOVE.L  (A2),A2         ; A2: chkmod
(MOVE.L  -(A3),A1        ; A1: actmod
(MOVE.W  ModDesc.type(A1),D0
(CMP.W   ModDesc.type(A2),D0
(BNE     neq
(MOVE.B  ModDesc.name(A1),D0
(CMP.B   ModDesc.name(A2),D0
(BNE     neq
(LEA     ModDesc.name(A1),A0
(MOVE.L  A0,(A3)+
(MOVE    #79,(A3)+
(LEA     ModDesc.name(A2),A0
(MOVE.L  A0,(A3)+
(MOVE    #79,(A3)+
(MOVE.L  A1,-(A7)
(JSR     StrEqual
(MOVE.L  (A7)+,A1
(TST     -(A3)
(BEQ     neq
(MOVE.L  (A7)+,A2
(MOVE.L  A1,(A2)
(MOVE    #1,(A3)+
(RTS
&neq
(ADDQ.L  #4,A7
(CLR     (A3)+
$END
"END chkavail;
"(*$L=*)
 
 PROCEDURE avail (VAR s: ARRAY OF CHAR; t: ModType; VAR modp: PtrMod): BOOLEAN;
"VAR mod: ModDesc; found: BOOLEAN;
"BEGIN
$Assign (s, mod.name, ok);
$mod.type:= t;
$modp:= ADR (mod);
$ResetList (modlist);
$ScanEntries (modlist, forward, chkavail, ADR (modp), found);
$RETURN found
"END avail;
 
 PROCEDURE newMod (VAR s: ARRAY OF CHAR; t: ModType; VAR actmod: PtrMod);
"BEGIN
$NEW (actmod);
$AppendEntry (modlist, actmod, error);
$IF error THEN termNoMem END;
$WITH actmod^ DO
&Assign (s, name, ok);
&type:= t;
&codeName:= '';
&checked:= FALSE;
&ignore:= FALSE;
&withSource:= FALSE;
$END
"END newMod;
 
 
 PROCEDURE readIdents (makename: ARRAY OF CHAR);
 
"VAR
(path: PathList;
(fname: FileStr;
(id: String;
(line: ARRAY [0..256] OF CHAR;
(lineLen: CARDINAL;
(actmod: PtrMod;
 
"PROCEDURE syntaxError(REF s: ARRAY OF CHAR);
$BEGIN
&WriteLn;
&WriteString (line);
&WriteLn;
&WriteString ('id: <');
&WriteString (id);
&Write ('>');
&WriteLn;
&DEC (TextCol, Length (id));
&term (FuncStrings.ConcStr (synErr, s))
$END syntaxError;
 
"PROCEDURE checkState;
$VAR s: String;
$BEGIN
&IF State (f) < 0 THEN
(GetStateMsg (State (f), s);
(Insert (filErr, 0, s, ok);
(term3 (s)
&END
$END checkState;
"
"PROCEDURE getIdent (VAR s: ARRAY OF CHAR): BOOLEAN;
$(* Liefert in 's' das nchste Wort aus der Datei 'f'. *)
$VAR p: CARDINAL;
$
$BEGIN
&LOOP
(IF TextCol >= lineLen THEN
*IF EOF (f) THEN
,s[0]:= 0C;
,RETURN FALSE
*END;
*INC (TextLine);
*Text.ReadString (f, line);
*TextCol:= 0;
*IF line [0] = '*' THEN          (* Kommentar *)
,line:= ''
*END;
*lineLen:= FastStrings.Length (line);
(END;
(ASSEMBLER
0; WHILE char (line, TextCol) = ' ' DO INC (TextCol) END;
0MOVE.L  (A6),A0
0MOVE.W  TextCol,D0
0MOVE.W  lineLen(A0),D1
0LEA     line(A0),A1
0MOVE.W  D1,D2
.again
0CMP.W   D1,D0
0BCC     ende
0CMPI.B  #' ',0(A1,D0.W)
0BNE     cont
0ADDQ.W  #1,D0
0BRA     again
.cont
0MOVE    D0,-(A7)
0ADDQ.W  #1,D0
.aga2
0CMP.W   D1,D0
0BCC     end2
0CMPI.B  #' ',0(A1,D0.W)
0BEQ     end3
0ADDQ.W  #1,D0
0BRA     aga2
.end3
0MOVE    D0,D2
.end2
0MOVE    (A7)+,D0
.ende
0MOVE.W  D0,TextCol
0SUB.W   D0,D2
0MOVE.W  D2,p(A6)
(END;
(IF p>0 THEN
*FastStrings.Copy (line, TextCol, p, s);
*INC (TextCol, p);
*RETURN TRUE
(END;
&END (* LOOP *)
$END getIdent;
 
"PROCEDURE newUse (name : ARRAY OF CHAR);
$VAR inclink : IncList; err : BOOLEAN;
$BEGIN
&NEW (inclink);
&IF inclink = NIL THEN termNoMem END;
&inclink^.next := actmod^.uses;
&actmod^.uses := inclink;
&Assign (name, inclink^.fullname, err);
$END newUse;
 
"PROCEDURE newInc (name : ARRAY OF CHAR);
$VAR inclink : IncList; err : BOOLEAN;
$BEGIN
&NEW (inclink);
&IF inclink = NIL THEN termNoMem END;
&inclink^.next := actmod^.include;
&actmod^.include := inclink;
&Assign (name, inclink^.fullname, err);
$END newInc;
 
"PROCEDURE newImport (VAR name: ARRAY OF CHAR);
$VAR implink: ImpList; impmod: PtrMod;
$BEGIN
&IF ~avail (name, def, impmod) THEN
(newMod (name, def, impmod);
&END;
&NEW (implink);
&implink^.next:= actmod^.import;
&implink^.modPtr := impmod;
&actmod^.import:= implink
$END newImport;
 
"VAR   actname, dummy: String;
(n: INTEGER;
(empty, firstMain, mainMod, mainImp, ignore: BOOLEAN;
(idNOSOURCE, idMAIN, idMOD, idDEF, idIMPMOD, idIMP,
(idNONE, idSOURCE, idINC, idUSES, idIMPORT: String;
(acttype: ModType;
(state: (ModOrType, waitModName, waitType, waitCodeName, waitSource,
0waitSourceName, waitInc, waitUseName, waitIncName, waitImport,
0waitImportName);
 
"BEGIN (* readIdents *)
$SearchFile (makename, (*!TT*)SrcPaths, fromStart, ok, fname);
$Open (f, fname, readSeqTxt);
$checkState;
$TextLine:= 0;
$FastStrings.Assign (fname, TextName);
 
$WriteLn;
$WriteString(readng);
$WriteString (fname);
 
$idMOD:= '-MOD';
$idDEF:= '-DEF';
$idIMP:= '-IMP';
$idIMPMOD:= '-IMPMOD';
$idNONE:= '-IGNORE';
$idMAIN:= '-MAIN';
$idSOURCE:= '-SOURCE';
$idNOSOURCE:= '-NOSRC';
$idINC := '-INC';
$idUSES:= '-USES';
$idIMPORT:= '-IMPORT';
$
$TextCol:= 0; lineLen:= 0; line:= '';
$state:= waitModName;
$mainImp:= FALSE;
$firstMain:= TRUE;
$empty:= TRUE;
$(*$D-*)
$WHILE getIdent (id) DO
&empty:= FALSE;
&LOOP
(CASE state OF
*ModOrType:
,IF id [0] = '-' THEN
.state := waitType
,ELSE
.state := waitModName
,END |
*waitModName:
,IF id [0] = '-' THEN syntaxError (nameExp) END;
,mainMod:= FALSE;
,actname:= id; state:= waitType; EXIT |
*waitType:
,Upper (id);
,ignore:= FALSE;
,mainImp:= FALSE;
,IF    StrEqual (id, idDEF) THEN
.acttype:= def;
,ELSIF StrEqual (id, idIMP) THEN
.acttype:= imp;
,ELSIF StrEqual (id, idMOD) THEN
.acttype:= mod
,ELSIF StrEqual (id, idIMPMOD) THEN
.acttype:= imp;
.mainImp:= TRUE
,ELSIF StrEqual (id, idNONE) THEN
.acttype:= def;
.ignore:= TRUE
,ELSIF StrEqual (id, idMAIN) THEN
.mainMod:= TRUE;
.state:= ModOrType;
.EXIT
,ELSE
.syntaxError (typeExp)
,END;
,IF avail (actname, acttype, actmod) THEN
.IF ~Empty (actmod^.codeName) THEN
0WriteLn;
0WriteString (actname);
0term (dblid)
.ELSIF ignore THEN
0actmod^.ignore:= TRUE
.END
,ELSE
.newMod (actname, acttype, actmod);
,END;
,IF ignore THEN
.state:= waitModName
,ELSE
.state:= waitCodeName
,END;
,EXIT |
*waitCodeName:
,IF id [0] = '-' THEN syntaxError (fileExp) END;
,ReplaceHome (id);
,actmod^.codeName:= id;
,IF mainMod & firstMain THEN
.firstMain:= FALSE;
.FastStrings.Assign (actmod^.name, ModuleName);
.FastStrings.Assign (actmod^.codeName, CodeName);
,END;
,state:= waitSource; EXIT |
*waitSource:
,IF StrEqual (id, idSOURCE) THEN
.actmod^.withSource:= TRUE; state:= waitSourceName; EXIT
,ELSIF StrEqual (id, idNOSOURCE) THEN
.actmod^.ignoreSource:= TRUE;
.IF acttype = mod THEN
0state:= waitModName
.ELSE
0state := ModOrType
.END;
.EXIT
,ELSE
.syntaxError (srcExp);
,END |
*waitSourceName:
,IF id [0] = '-' THEN syntaxError (srcnExp) END;
,ReplaceHome (id);
,actmod^.sourceName:= id;
,actmod^.include:= NIL;
,actmod^.uses:= NIL;
,actmod^.import:= NIL;
,IF NOT mainImp & (actmod^.type = imp) THEN
.(* eigenes Def-Modul importieren *)
.newImport (actname)
,END;
,state:= waitInc;
,EXIT |
*waitInc:
,IF StrEqual (id, idINC) THEN
.state:= waitIncName; EXIT
,ELSIF StrEqual (id, idUSES) THEN
.state:= waitUseName; EXIT
,ELSE
.state:= waitImport
,END; |
*waitIncName, waitUseName:
,IF id [0] = '-' THEN syntaxError (fileExp) END;
,n:= Pos (';', id, 0);
,IF n>=0 THEN (* Ende der Includes *)
.state := waitImport;
.IF n=0 THEN EXIT END;
.Copy (id, 0, n, id, ok)
,END;
,ReplaceHome (id);
,IF state = waitIncName THEN
.newInc (id)
,ELSE
.newUse (id)
,END;
,EXIT |
*waitImport:
,IF StrEqual (id, idIMPORT) THEN
.state:= waitImportName; EXIT
,ELSE
.IF acttype = mod THEN state:= waitModName
.ELSE state := ModOrType END;
,END |
*waitImportName:
,IF id [0] = '-' THEN syntaxError (nameExp) END;
,n:= Pos (';', id, 0);
,IF n>=0 THEN (* Ende der Importe *)
.IF acttype = mod THEN state:= waitModName
.ELSE state := ModOrType END;
.IF n=0 THEN EXIT END;
.Copy (id, 0, n, id, ok)
,END;
,newImport (id);
,EXIT |
(END  (* CASE state OF *)
&END  (* LOOP *)
$END; (* WHILE getIdent (id) *)
$(*$D-*)
$Close (f);
$IF empty THEN
&term3 (noFile)
$END
"END readIdents;
 
 PROCEDURE verifyIdents (): BOOLEAN;
"VAR modPtr: PtrMod;
"BEGIN
$ResetList (modlist);
$LOOP
&modPtr:= NextEntry (modlist);
&IF modPtr = NIL THEN EXIT END;
&IF ~modPtr^.ignore & Empty (modPtr^.codeName) THEN
(WriteLn;
(WriteString (modPtr^.name);
(WriteString (notDef);
(waitAtEnd:= TRUE;
&END
$END;
$RETURN ~waitAtEnd
"END verifyIdents;
 
 
 PROCEDURE getFileDateTime (REF name: ARRAY OF CHAR;
;VAR date, time: CARDINAL): BOOLEAN;
"VAR f: File; entry: DirEntry; res: INTEGER;
"BEGIN
$GetDirEntry (name, entry, res);
$IF res >= 0 THEN
&date:= PackDate (entry.date);
&time:= PackTime (entry.time);
$END;
$RETURN res >= 0
"END getFileDateTime;
 
 
 PROCEDURE getTime (): BOOLEAN;
 
 TYPE
"FileEntry = RECORD
0name : ARRAY [0..12] OF CHAR;
0modPtr : PtrMod;
.END;
"PtrFile = POINTER TO FileEntry;
"FullEntry = RECORD
0fullname : ARRAY [0..80] OF CHAR;
0modPtr : ADDRESS;
0typ : FileType;
.END;
"PtrFullEntry = POINTER TO FullEntry;
"
 VAR
"pmod: PtrMod;
"err: BOOLEAN;
"ModCodes : List; (* OF FileEntry *)
"DefCodes : List; (* OF FileEntry *)
"ImpCodes : List; (* OF FileEntry *)
"Sources  : List; (* OF FileEntry *)
"Defaults : List; (* OF FileEntry *)
"withPath : List; (* OF FullEntry *)
 
 
"PROCEDURE insCode (REF name : ARRAY OF CHAR; type : ModType; pmod : PtrMod);
"VAR
$merr : BOOLEAN;
$Fentry : PtrFile;
$FullE  : PtrFullEntry;
$path : ARRAY [0..127] OF CHAR;
$fname: ARRAY [0..12] OF CHAR;
"BEGIN
$SplitPath (name, path, fname);
$IF path[0] = 0C THEN
&NEW (Fentry);
&IF Fentry=NIL THEN termNoMem END;
&IF type = mod THEN
(AppendEntry (ModCodes, Fentry, merr);
&ELSIF type = def THEN
(AppendEntry (DefCodes, Fentry, merr);
&ELSIF type = imp THEN
(AppendEntry (ImpCodes, Fentry, merr);
&END;
&IF merr THEN termNoMem END;
&Assign (name, Fentry^.name, merr);
&Fentry^.modPtr := pmod;
$ELSE
&NEW (FullE);
&IF FullE = NIL THEN termNoMem END;
&AppendEntry (withPath, FullE, merr);
&IF merr THEN termNoMem END;
&Assign (name, FullE^.fullname, merr);
&FullE^.modPtr := pmod;
&FullE^.typ := type;
$END;
"END insCode;
"
"PROCEDURE insSource (REF name : ARRAY OF CHAR; type : ModType; pmod : PtrMod);
"VAR
$merr : BOOLEAN;
$Fentry : PtrFile;
$FullE  : PtrFullEntry;
$path : ARRAY [0..80] OF CHAR;
$fname: ARRAY [0..12] OF CHAR;
$actinc : IncList;
"BEGIN
$SplitPath (name, path, fname);
$IF path[0]=0C THEN
&NEW (Fentry);
&IF Fentry = NIL THEN termNoMem END;
&AppendEntry (Sources, Fentry, merr);
&IF merr THEN termNoMem END;
&Assign (name, Fentry^.name, merr);
&Fentry^.modPtr := pmod;
$ELSE
&NEW (FullE);
&IF FullE = NIL THEN termNoMem END;
&AppendEntry (withPath, FullE, merr);
&IF merr THEN termNoMem END;
&Assign (name, FullE^.fullname, merr);
&FullE^.modPtr := pmod;
&FullE^.typ := src;
$END;
$(*!!! INC sollten, wenn kein Pfad angegeben, in 'Sources' eingetragen werden *)
$actinc := pmod^.include;
$WHILE (actinc <> NIL) DO
&NEW (FullE);
&AppendEntry (withPath, FullE, merr);
&IF merr THEN termNoMem END;
&Assign (actinc^.fullname, FullE^.fullname, merr);
&FullE^.modPtr := actinc;
&FullE^.typ := inc;
&actinc := actinc^.next;
$END;
$(*!!! USES sollten, wenn kein Pfad angegeben, in 'Defaults' eingetragen werden *)
$actinc := pmod^.uses;
$WHILE (actinc <> NIL) DO
&NEW (FullE);
&AppendEntry (withPath, FullE, merr);
&IF merr THEN termNoMem END;
&Assign (actinc^.fullname, FullE^.fullname, merr);
&FullE^.modPtr := actinc;
&FullE^.typ := uses;
&actinc := actinc^.next;
$END;
"END insSource;
 
"PROCEDURE markToCompile (modPtr: PtrMod; name: ARRAY OF CHAR);
$BEGIN
&WITH modPtr^ DO
(date := 0;
(time := 0;
&END; (* WITH *)
$END markToCompile;
 
 
"PROCEDURE getModTimes();
"VAR
$PathPtr : PathEntry;
$FilePtr : PtrFile;
$path, cn : String;
$c: CHAR;
$ok, rerr : BOOLEAN;
"BEGIN
$ResetList(ModPaths);
$LOOP
&PathPtr := NextEntry(ModPaths);
&IF PathPtr = NIL THEN EXIT END;
&Assign (PathPtr^,path,ok);
&ValidatePath (path);
&ReplaceHome (path);
&ResetList(ModCodes);
&LOOP
(FilePtr := NextEntry (ModCodes);
(IF FilePtr = NIL THEN EXIT END;
(Concat (path, FilePtr^.name, cn, ok);
(IF getFileDateTime (cn, FilePtr^.modPtr^.date, FilePtr^.modPtr^.time) THEN
*Assign (cn, FilePtr^.modPtr^.codeName, ok);
*RemoveEntry(ModCodes, rerr);
*IF rerr THEN term3 (remErr) END;
(END;
&END; (* FileLoop *)
&IF ListEmpty (ModCodes) THEN EXIT END;
$END; (* PathLoop *)
$IF ~ListEmpty(ModCodes) THEN
&ResetList(ModCodes);
&LOOP
(FilePtr := NextEntry(ModCodes);
(IF FilePtr = NIL THEN EXIT END;
(IF FilePtr^.modPtr^.withSource THEN
*markToCompile (FilePtr^.modPtr, FilePtr^.name);
(ELSE
*WriteLn;
*WriteString (FilePtr^.name);
*waitAtEnd:= TRUE
(END;
&END; (* LOOP *)
$END; (* IF ~ListEmpty *)
"END getModTimes;
"
"PROCEDURE getDefTimes();
"VAR
$PathPtr : PathEntry;
$FilePtr : PtrFile;
$path, cn : String;
$c: CHAR;
$ok, rerr : BOOLEAN;
"BEGIN
$ResetList(DefPaths);
$LOOP
&PathPtr := NextEntry(DefPaths);
&IF PathPtr = NIL THEN EXIT END;
&Assign (PathPtr^,path,ok);
&ValidatePath (path);
&ReplaceHome (path);
&ResetList(DefCodes);
&LOOP
(FilePtr := NextEntry (DefCodes);
(IF FilePtr = NIL THEN EXIT END;
(Concat (path, FilePtr^.name, cn, ok);
(IF getFileDateTime (cn, FilePtr^.modPtr^.date, FilePtr^.modPtr^.time) THEN
*Assign (cn, FilePtr^.modPtr^.codeName, ok);
*RemoveEntry(DefCodes, rerr);
*IF rerr THEN term3 (remErr) END;
(END;
&END; (* FileLoop *)
&IF ListEmpty (DefCodes) THEN EXIT END;
$END; (* PathLoop *)
$IF ~ListEmpty(DefCodes) THEN
&ResetList(DefCodes);
&LOOP
(FilePtr := NextEntry(DefCodes);
(IF FilePtr = NIL THEN EXIT END;
(IF FilePtr^.modPtr^.withSource THEN
*markToCompile (FilePtr^.modPtr, FilePtr^.name);
(ELSE
*WriteLn;
*WriteString (FilePtr^.name);
*waitAtEnd:= TRUE
(END;
&END; (* LOOP *)
$END; (* IF ~ListEmpty *)
"END getDefTimes;
"
"PROCEDURE getImpTimes();
"VAR
$PathPtr : PathEntry;
$FilePtr : PtrFile;
$path, cn : String;
$c: CHAR;
$ok, rerr : BOOLEAN;
"BEGIN
$ResetList(ImpPaths);
$LOOP
&PathPtr := NextEntry(ImpPaths);
&IF PathPtr = NIL THEN EXIT END;
&Assign (PathPtr^,path,ok);
&ValidatePath (path);
&ReplaceHome (path);
&ResetList(ImpCodes);
&LOOP
(FilePtr := NextEntry (ImpCodes);
(IF FilePtr = NIL THEN EXIT END;
(Concat (path, FilePtr^.name, cn, ok);
(IF getFileDateTime (cn, FilePtr^.modPtr^.date, FilePtr^.modPtr^.time) THEN
*Assign (cn, FilePtr^.modPtr^.codeName, ok);
*RemoveEntry(ImpCodes, rerr);
*IF rerr THEN term3 (remErr) END;
(END;
&END; (* FileLoop *)
&IF ListEmpty (ImpCodes) THEN EXIT END;
$END; (* PathLoop *)
$IF ~ListEmpty(ImpCodes) THEN
&ResetList(ImpCodes);
&LOOP
(FilePtr := NextEntry(ImpCodes);
(IF FilePtr = NIL THEN EXIT END;
(IF FilePtr^.modPtr^.withSource THEN
*markToCompile (FilePtr^.modPtr, FilePtr^.name);
(ELSE
*WriteLn;
*WriteString (FilePtr^.name);
*waitAtEnd:= TRUE
(END;
&END; (* LOOP *)
$END; (* IF ~ListEmpty *)
"END getImpTimes;
 
"PROCEDURE getSrcTimes();
"VAR
$PathPtr : PathEntry;
$FilePtr : PtrFile;
$path, cn : String;
$ok, rerr : BOOLEAN;
"BEGIN
$ResetList(SrcPaths);
$LOOP
&PathPtr := NextEntry(SrcPaths);
&IF PathPtr = NIL THEN EXIT END;
&Assign (PathPtr^,path,ok);
&ValidatePath (path);
&ReplaceHome (path);
&ResetList(Sources);
&LOOP
(FilePtr := NextEntry (Sources);
(IF FilePtr = NIL THEN EXIT END;
(Concat (path, FilePtr^.name, cn, ok);
(IF getFileDateTime (cn, FilePtr^.modPtr^.sdate, FilePtr^.modPtr^.stime) THEN
*Assign (cn, FilePtr^.modPtr^.sourceName, ok);(*!!!das trifft auf INC nicht zu?! *)
*RemoveEntry(Sources, rerr);
*IF rerr THEN term3 (remErr) END;
(END;
&END; (* FileLoop *)
&IF ListEmpty (Sources) THEN EXIT END;
$END; (* PathLoop *)
$IF ~ListEmpty(Sources) THEN
&ResetList(Sources);
&WriteLn;
&LOOP
(FilePtr := NextEntry(Sources);
(IF FilePtr = NIL THEN EXIT END;
(WriteString (FilePtr^.name);
(WriteLn;
&END; (* LOOP *)
&waitAtEnd:= TRUE
$END; (* IF ~ListEmpty *)
"END getSrcTimes;
 
 (*!TT
"PROCEDURE getDftTimes();
"VAR
$PathPtr : PathEntry;
$FilePtr : PtrFile;
$paths   : PathList;
$path, cn: String;
$ok, rerr: BOOLEAN;
"BEGIN
$paths:= StdPaths ();
$ResetList(paths);
$LOOP
&PathPtr := NextEntry(paths);
&IF PathPtr # NIL THEN Assign (PathPtr^,path,ok)
&ELSE EXIT END;
&ResetList(Defaults);
&LOOP
(FilePtr := NextEntry (Defaults);
(IF FilePtr = NIL THEN EXIT END;
(Concat (path, FilePtr^.name, cn, ok);
(IF getFileDateTime (cn, FilePtr^.modPtr^.sdate, FilePtr^.modPtr^.stime) THEN
*Assign (cn, FilePtr^.modPtr^.sourceName, ok);(*!!!das trifft auf USES nicht zu?! *)
*RemoveEntry(Defaults, rerr);
*IF rerr THEN term3 (remErr) END;
(END;
&END; (* FileLoop *)
$END; (* PathLoop *)
$IF ~ListEmpty(Defaults) THEN
&ResetList(Defaults);
&WriteLn;
&LOOP
(FilePtr := NextEntry(Defaults);
(IF FilePtr = NIL THEN EXIT END;
(WriteString (FilePtr^.name);
(WriteLn;
&END; (* LOOP *)
&waitAtEnd:= TRUE
$END; (* IF ~ListEmpty *)
"END getDftTimes;
 *)
 
"PROCEDURE getPathTimes();
"VAR
$FilePtr : PtrFullEntry;
$pmod : PtrMod;
$pinc : IncList;
$sdate, stime: CARDINAL;
$fname: FileStr;
$paths: PathList;
$c: CHAR;
$ok, rerr : BOOLEAN;
"BEGIN
$ResetList(withPath);
$LOOP
&FilePtr := NextEntry (withPath);
&IF FilePtr = NIL THEN EXIT END;
&WITH FilePtr^ DO
(
((*!TT:*)
(ok:= getFileDateTime (HomeReplaced (fullname), sdate, stime);
(IF NOT ok THEN
*IF typ = mod THEN
,paths:= ModPaths
*ELSIF typ = def THEN
,paths:= DefPaths
*ELSIF typ = imp THEN
,paths:= ImpPaths
*ELSE
,paths:= SrcPaths
*END;
*SearchFile (fullname, paths, fromStart, ok, fname);
*ok:= getFileDateTime (fname, sdate, stime);
(END;
(
(IF ok THEN
*IF typ = src THEN
,pmod := modPtr;
,pmod^.sdate:= sdate;
,pmod^.stime:= stime;
*ELSIF (typ = inc) OR (typ = uses) THEN
,pinc := modPtr;
,pinc^.date:= sdate;
,pinc^.time:= stime;
*ELSE
,pmod := modPtr;
,pmod^.date:= sdate;
,pmod^.time:= stime
*END;
*RemoveEntry(withPath, rerr);
*IF rerr THEN term3 (remErr) END;
(END; (* IF State *)
&END; (* WITH FilePtr *)
$END; (* FileLoop *)
$IF ~ListEmpty(withPath) THEN
&ResetList(withPath);
&LOOP
(FilePtr := NextEntry(withPath);
(IF FilePtr = NIL THEN EXIT END;
(pmod := FilePtr^.modPtr;
(IF (FilePtr^.typ < src) & pmod^.withSource THEN
*(* Wenn's ein Code mit Source ist, fehlenden Code bersetzen *)
*markToCompile (pmod, FilePtr^.fullname)
(ELSE
*(* Sonst fehlende Datei melden *)
*WriteLn;
*WriteString (FilePtr^.fullname);
*waitAtEnd:= TRUE
(END;
&END; (* LOOP *)
$END; (* IF ~ListEmpty *)
"END getPathTimes;
 
 (*
"PROCEDURE showL (l : List; Titel : ARRAY OF CHAR);
"VAR FilePtr : PtrFile;
"BEGIN
$WriteString(Titel);
$WriteLn;
$ResetList(l);
$LOOP
&FilePtr := NextEntry (l);
&IF FilePtr = NIL THEN EXIT END;
&WriteString (FilePtr^.name);
&WriteLn;
$END;
$WriteLn;
$REPEAT UNTIL KeyPressed();
$FlushKbd();
"END showL;
"
"PROCEDURE showP (l : List; Titel : ARRAY OF CHAR);
"VAR FilePtr : PtrFullEntry;
"BEGIN
$WriteString(Titel);
$WriteLn;
$ResetList(l);
$LOOP
&FilePtr := NextEntry (l);
&IF FilePtr = NIL THEN EXIT END;
&WriteString (FilePtr^.fullname);
&WriteLn;
$END;
$WriteLn;
$REPEAT UNTIL KeyPressed();
$FlushKbd();
"END showP;
 *)
 
"BEGIN
$WriteLn;
$WriteString(scanin);
$CreateList (ModCodes, error);
$IF error THEN termNoMem END;
$CreateList (DefCodes, error);
$IF error THEN termNoMem END;
$CreateList (ImpCodes, error);
$IF error THEN termNoMem END;
$CreateList (Sources, error);
$IF error THEN termNoMem END;
$CreateList (Defaults, error);
$IF error THEN termNoMem END;
$CreateList (withPath, error);
$IF error THEN termNoMem END;
$
$ResetList (modlist);
$LOOP
&pmod:= NextEntry (modlist);
&IF pmod = NIL THEN EXIT END;
&IF ~pmod^.ignore THEN
(IF Empty (pmod^.codeName) THEN
*HALT
*(* mte schon bei 'verifyIdents' geprft worden sein:
,WriteLn;
,WriteString (pmod^.name);
,WriteString (notDef);
,waitAtEnd:= TRUE;
**)
(ELSIF ~waitAtEnd THEN
*WITH pmod^ DO
,insCode (codeName, type, pmod);
,IF withSource THEN
.insSource (sourceName, type, pmod);
,END;
*END;
(END;
&END
$END;
$IF NOT waitAtEnd THEN
&(*
&showL(ModCodes, 'Mod:');
&showL(DefCodes, 'Def:');
&showL(ImpCodes, 'Imp:');
&showL(Sources, 'Src:');
&showL(Defaults, 'Src:');
&showP(withPath, 'Mit Pfad:');
&*)
&(*!!!
&getdefaultTimes();
&*)
&WriteLn;
&getModTimes();
&getDefTimes();
&getImpTimes();
&getSrcTimes();
&getPathTimes();
&WriteLn;
&IF waitAtEnd THEN
(term3 (opnErr)
&END
$END;
$RETURN ~waitAtEnd
"END getTime;
 
 (*
 PROCEDURE showIdents;
"VAR modPtr: PtrMod; c: CHAR; i: ImpList; s: String;
"BEGIN
$ResetList (modlist);
$LOOP
&modPtr:= NextEntry (modlist);
&IF modPtr = NIL THEN EXIT END;
&WITH modPtr^ DO
(WriteLn;
(WriteString (name);
(WriteString ('  ');
(IF type=def THEN WriteString ('DEF')
(ELSIF type=imp THEN WriteString ('IMP')
(ELSE WriteString ('MOD') END;
(WriteLn;
(WriteString ('Codename: ');
(WriteString (codeName);
(WriteString ('  ');
(DateToText (UnpackDate (date), '', s);
(WriteString (s);
(WriteString ('  ');
(TimeToText (UnpackTime (time), '', s);
(WriteString (s);
(IF withSource THEN
*WriteLn;
*WriteString ('Source: ');
*WriteString (sourceName);
*WriteString ('  ');
*DateToText (UnpackDate (sdate), '', s);
*WriteString (s);
*WriteString ('  ');
*TimeToText (UnpackTime (stime), '', s);
*WriteString (s);
*IF import # NIL THEN
,WriteLn;
,WriteString ('Imports: ');
,i:= import;
,LOOP
.WriteString (i^.modPtr^.name);
.i:= i^.next;
.IF i = NIL THEN EXIT END;
.WriteString (', ')
,END
*END  (* IF import # NIL *)
(END; (* IF withSource *)
(WriteLn;
(Read (c);
&END  (* WITH modPtr^ *)
$END; (* LOOP *)
"END showIdents;
 *)
 
 PROCEDURE chkTree;
"VAR
$modPtr: PtrMod;
$cdate, ctime : CARDINAL;
$currtime: moment;
$success : BOOLEAN;
$mustCompile: BOOLEAN;
 
"PROCEDURE toCompile (REF sourceName, codeName, clientName: ARRAY OF CHAR);
$VAR s, s2: String;
$BEGIN
&mustCompile:= TRUE;
&Text.WriteString (compfile, '(*$I ');
&Text.WriteString (compfile, sourceName);
&IF codeName[0] # '' THEN
(Text.WriteString (compfile, '  Code: ');
(SplitPath (codeName, s, s2);
(Text.WriteString (compfile, s)
&END;
&IF clientName[0] # '' THEN
(Text.WriteString (compfile, '  Reason: ');
(Text.WriteString (compfile, clientName)
&END;
&Text.WriteString (compfile, ' *)');
&Text.WriteLn (compfile);
$END toCompile;
 
"PROCEDURE illegalSourceTime (REF sourceName: ARRAY OF CHAR);
$BEGIN
&WriteLn;
&WriteString (sourceName);
&WriteString (datErr);
&waitAtEnd:= TRUE
$END illegalSourceTime;
 
"PROCEDURE illegalCodeTime (REF codeName: ARRAY OF CHAR);
$BEGIN
&WriteLn;
&WriteString (codeName);
&WriteString (datErr);
&waitAtEnd:= TRUE
$END illegalCodeTime;
 
"PROCEDURE toMoment (date : CARDINAL; time : CARDINAL) : moment;
$BEGIN
&RETURN (LONG(time)+LONG(date)*$10000L);
$END toMoment;
 
"PROCEDURE setTimeDate (time: moment; modPtr: PtrMod);
$BEGIN
&modPtr^.date:= SHORT (time DIV $10000);
&modPtr^.time:= SHORT (time MOD $10000);
$END setTimeDate;
 
"PROCEDURE Lmax (a, b : LONGCARD) : LONGCARD;
$BEGIN
&IF a>b THEN RETURN a
&ELSE RETURN b END;
$END Lmax;
 
"PROCEDURE chkDate(aktmod : PtrMod) : moment;
$VAR
&clientName: String;
&aktimp: ImpList;
&this, maximp, codeMom, sourceMom: moment;
 
$PROCEDURE check (aktinc: IncList);
&VAR incTime: moment;
&BEGIN
(WHILE (aktinc <> NIL) DO
*incTime:= toMoment(aktinc^.date, aktinc^.time);
*IF incTime > sourceMom THEN
,sourceMom:= incTime;
,IF (sourceMom > codeMom) & (clientName[0] = '') THEN
.Assign (aktinc^.fullname, clientName, ok)
,END
*END;
*aktinc := aktinc^.next;
(END
&END check;
 
$BEGIN
&codeMom:= 0;
&clientName:= '';
&WITH aktmod^ DO
(IF NOT ignore THEN
*IF build THEN
,codeMom:= 0
*ELSE
,codeMom:= toMoment(date, time);
*END;
*IF NOT checked THEN
,checked:= TRUE;
,IF codeMom > currtime THEN illegalCodeTime (codeName) END;
,IF withSource THEN
.IF build THEN
0sourceMom:= 0
.ELSE
0sourceMom:= toMoment(sdate, stime);
.END;
.IF sourceMom > currtime THEN illegalSourceTime (sourceName) END;
.IF NOT build THEN
0IF sourceMom > codeMom THEN
2IF codeMom = 0 THEN
4clientName:= NoCodeMsg
2ELSE
4clientName:= SelfMsg
2END
0END;
0check (include);
0check (uses);
.END;
.maximp:= 0L;
.aktimp:= import;
.WHILE aktimp <> NIL DO
0this:= chkDate(aktimp^.modPtr);
0IF this > maximp THEN
2maximp:= this;
2IF (maximp > codeMom) & (sourceMom <= codeMom) THEN
4Assign (aktimp^.modPtr^.codeName, clientName, ok)
2END
0END;
0aktimp:= aktimp^.next;
.END; (* WHILE *)
.IF build OR (buildImp & (type # def))
.OR (maximp>codeMom) OR (sourceMom>codeMom) THEN
0IF build THEN clientName:= '' END;
0toCompile (sourceName, codeName, clientName);
0codeMom:= currtime;
0setTimeDate (codeMom, aktmod);
.END;
,END; (* IF withSource *)
*END; (* IF NOT checked *)
(END; (* IF NOT ignore *)
&END; (* WITH *)
&RETURN codeMom;
$END chkDate;
 
"VAR cn: String; ok: BOOLEAN; ml: List; dummy: moment;
 
"BEGIN
$WriteLn;
$
$ctime:= PackTime(CurrentTime());
$cdate:= PackDate(CurrentDate());
$currtime:= toMoment(cdate, ctime);
 
$ConcatPath (HomeReplaced (TemporaryPath), compFileName, cn);
$Create(compfile, cn, writeSeqTxt, replaceOld);
$IF State(compfile)<0 THEN term3 (noCom) END;
 
$ml:= modlist;
$ResetList (ml);
$mustCompile:= FALSE;
$LOOP
&modPtr:= NextEntry (ml);
&IF modPtr = NIL THEN EXIT END;
&IF NOT modPtr^.checked THEN
(dummy:= chkDate (modPtr)
&END
$END;
 
$IF waitAtEnd THEN
&Remove (compfile)
$ELSIF mustCompile THEN
&exitCode:= 0;
&WriteString (toComp);
&Close (compfile);
$ELSE
&exitCode:= 1;
&WriteString (noComp);
&Remove (compfile);
$END;
 
"END chkTree;
 
 
 VAR ch: CHAR;
$n, i, argc: CARDINAL;
$opts: String;
$argv: ARRAY [0..1] OF PtrArgStr;
 
 BEGIN
"WriteLn;
"WriteString (titl1);
"WriteLn;
"WriteString (titl2);
"WriteLn;
 
"HomePath:= ShellPath;
 
"CodeName:= '';
"ModuleName:= '';
 
"CreateList (modlist, error);
"IF error THEN termNoMem END;
 
"(* MAKE-Datei einlesen, Daten in 'modlist' einfgen *)
"build:= FALSE;
"buildImp:= FALSE;
"InitArgCV (argc, argv);
"n:= 1; (* mgl. Pos. des Filenamens *)
"FOR i:= 1 TO argc-1 DO
$Upper (argv[i]^);
$IF StrEqual ('-B', argv[i]^) THEN
&IF i = 1 THEN n:= 2 (* neue mgl. Pos. des Filenamens *) END;
&build:= TRUE
$ELSIF StrEqual ('-BI', argv[i]^) THEN
&IF i = 1 THEN n:= 2 (* neue mgl. Pos. des Filenamens *) END;
&buildImp:= TRUE
$END
"END;
"IF argc > n THEN
$readIdents (argv[n]^)
"ELSE
$Upper (MakeFileName);
$EatSpaces (MakeFileName);
$(* Prfen, ob "-B" am Anfang steht *)
$IF StrEqual ("-B", FuncStrings.CopyStr (MakeFileName, 0, 2)) THEN
&IF StrEqual ("-BI", FuncStrings.CopyStr (MakeFileName, 0, 3)) THEN
(buildImp:= TRUE;
&ELSE
(build:= TRUE;
&END;
&Delete (MakeFileName, 0, 2, ok);
$ELSE
&Split (MakeFileName,
-PosLen ("-", MakeFileName, 0),
-MakeFileName, opts, ok);
&IF StrEqual ("-B", opts) THEN
(build:= TRUE
&ELSIF StrEqual ("-BI", opts) THEN
(buildImp:= TRUE
&END
$END;
$readIdents (MakeFileName)
"END;
 
"exitCode:= -1;
"waitAtEnd:= FALSE;
 
"IF verifyIdents () THEN
$IF build OR getTime () THEN
&(*showIdents;*)
&chkTree;
$END
"END;
 
"IF waitAtEnd THEN
$term3 ('')
"ELSE
$TermProcess (exitCode)
"END
 END MM2Make.
  
(* $FFEE2C9E$FFEE2C9E$FFEE2C9E$FFEE2C9E$FFEE2C9E$FFEE2C9E$FFEE2C9E$FFEE2C9E$FFEE2C9E$FFEE2C9E$FFEE2C9E$FFEE2C9E$FFEE2C9E$FFEE2C9E$FFEE2C9E$00009A3E$FFEE2C9E$FFEE2C9E$FFEE2C9E$FFEE2C9E$FFEE2C9E$FFEE2C9E$FFEE2C9E$FFEE2C9E$FFEE2C9E$FFEE2C9E$FFEE2C9E$FFEE2C9E$FFEE2C9E$FFEE2C9E$FFEE2C9E$FFEE2C9E$FFEE2C9E$FFEE2C9E$FFEE2C9E$FFEE2C9E$FFEE2C9E$FFEE2C9E$FFEE2C9E$FFEE2C9E$FFEE2C9E$FFEE2C9E$000028C8T.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$00008F32$FFF0CEDA$00001D90$00001EB8$00001E70$00001E78$00001EB5$00008CF5$00008D61$00008CA8$000028C8$00009A3E$00008833$0000913B$00008F46$00008DB1*)
