DEFINITION MODULE AESWindows;


(*  Megemax-Module 2 GEM-Library :  Die AES Fensterfunktionen
 *
 *  Autor: Manuel Chakravarty           Erstellt :  05.11.87
 *
 *  Version   2.2     V#0016
 *)


FROM    MOSGlobals      IMPORT MemArea;

FROM    GrafBase        IMPORT Point, Rectangle;

FROM    GEMGlobals      IMPORT PtrMaxStr, PtrObjTree;



                (*  Window Manager  *)
                (*  ==============  *)


CONST   NoWindow        = 65535;    (*  Dies ist der Wert fr ein nicht be-
                                     *  setztes Window-Handle
                                     *)

        DeskHandle      = 0;        (*  Dies ist das Fensterkennung der
                                     *  Desktop-Oberflche
                                     *)


TYPE    WindowElement   = (nameBar,    closer,    fuller,     mover,
                           infoBar,    sizer,     upArrow,    downArrow,
                           vertSlider, leftArrow, rightArrow, horSlider);

        WElementSet     = SET OF WindowElement;


PROCEDURE CreateWindow (    elems : WElementSet;
                            max   : Rectangle;
                        VAR handle: CARDINAL   );

        (*  Es wird ein neues Fenster beim AES angemeldet.
         *
         *  'elems'     -- die Elemente, die das Fenster besitzt.
         *  'max'       -- die maximalen Ausmae des Fensters.
         *  'handle'    -- liefert die Fensterkennung als Ergebnis.Be-
         *                 sitzt es den Wert 'NoWindow', so konnte kein
         *                 Fenster mehr erzeugt werden. (Das GEM ist nur
         *                 fr eine Verwaltung von hchstens sieben
         *                 Fenstern ausgelegt).
         *)

PROCEDURE OpenWindow (handle: CARDINAL; frame: Rectangle);

        (*  Das Fenster mit der Kennung 'handle' wird in der Gre 'frame'
         *  auf den Bildschirm gebracht.
         *)

PROCEDURE CloseWindow (handle: CARDINAL);

        (*  Das durch die Kennung 'handle' bezeichnete Fenster wird vom
         *  Bildschirm entfernt. Es wird dabei nicht aus dem Speicher
         *  gelscht.
         *)

PROCEDURE DeleteWindow (handle: CARDINAL);

        (*  Das Fenster, das die Kennung 'handle' besitzt wird abgemeldet.
         *  Das bedeutet, da dieses Fenster nicht mehr angesprochen werden
         *  darf, es ist gelscht.
         *)


TYPE    WSizeMode       = (workSize, borderSize, previousSize, fullSize);

PROCEDURE WindowSize (handle: CARDINAL; typ: WSizeMode): Rectangle;

        (*  Diese Funktion liefert die Ausmae eines Fensters. Es knnen
         *  folgende Ausmae erfragt werden:
         *
         *  'workSize'     -- Die Gre des Arbeitsbereichs (ohne Fenster-
         *                    elemente)
         *  'borderSize'   -- Die Gre des gesamten Fensters (mit Fenster-
         *                    elementen)
         *  'previousSize' -- Die letzte Gre des Gesamtfensters
         *  'fullSize'     -- Die maximale Gre des Fensters
         *
         *  Insbesondere knnen, mit Hilfe der Kennung 'DeskHandle', die
         *  Ausmae des Desktop's erfragt werden.
         *)


TYPE    WSliderMode     = (horPosition, vertPosition, horSize, vertSize);

PROCEDURE WindowSliderValue (handle: CARDINAL; typ: WSliderMode): INTEGER;

        (*  Es wird die Position eines Fensterschiebers geliefert.
         *  'handle' enthlt die Fensterkennung und 'typ' kann fol-
         *  gende Werte annehmen:
         *
         *  'horPosition'  -- Position des horizontalen Schiebers
         *  'vertPosition' -- Position des vertikalen Schiebers
         *  'horSize'      -- Ausmae des horizontalen Schiebers
         *  'vertSize'     -- Ausmae des vertikalen Schiebers
         *
         *  Schieberposition und Schiebergre werden in Promille ange-
         *  geben (Wertebereich: 0 - 1000), bei der Schiebergre ist
         *  allerdings auch der Wert -1 zugelassen, der die kleinste
         *  mgliche Gre reprsentiert.
         *)

PROCEDURE TopWindow (): CARDINAL;

        (*  Liefert die Fensterkennung des oben aufliegenden Fensters.
         *)


TYPE    RListMode       = (firstElem, nextElem);

PROCEDURE WindowRectList (handle: CARDINAL; typ: RListMode): Rectangle;

        (*  Zum Zeichnen innerhalb teilweiser verdeckter Fensterbereiche
         *  ist es unerllich, die nicht verdeckten Ausschnitte zu ken-
         *  nen. Genau diese Ausschnitte sind in der so genannten Recht-
         *  eckliste, die von dieser Funktion ausgelesen wird, festgehal-
         *  ten. Das Ende der Liste ist durch ein Rechteck mit der Flche
         *  Null gekennzeichnet.
         *  Besitzt 'typ' den Wert 'firstElem', so wird das erste Element
         *  der Rechteckliste gelesen. Bei jedem folgenden Aufruf mit
         *  'nextElem' wird sukzessiv ein weiteres Element ermittelt.
         *)

PROCEDURE ScreenBuffer (handle: CARDINAL): MemArea;

        (*  Es wird die Beschreibung eines Speicherbereichs geliefert,
         *  der vom AES zur Zwischenspeicherung von Bildschirminhalten
         *  benutzt wird.
         *  Dieser Bereich kann ohne weiteres auch von Anwendungspro-
         *  grammen mitverwendet werden. Allerdings sollte er nur fr
         *  kurzfristige Aufgaben benutzt werden. Sein Umfang betrgt
         *  in der Regel circa 8 kByte.
         *  Beim Aufruf der Funktion mu als Kennung ('handle') 'Desk
         *  Handle' eingetragen werden.
         *)


TYPE    WStringMode     = (nameStr, infoStr);

PROCEDURE SetWindowString (handle: CARDINAL;
                           typ   : WStringMode;
                           str   : PtrMaxStr);

        (*  Einem Fenster wird eine Zeichenkette fr einen Namen oder
         *  eine Informationszeile zugewiesen.
         *
         *  'handle'    -- Die Kennung des Fensters
         *  'typ'       -- '= nameStr': Name
         *                 '= infoStr': Infozeile
         *  'str'       -- Enthlt einen Zeiger auf die Zeichenkette.
         *)

PROCEDURE SetWindowSize (handle: CARDINAL; frame: Rectangle);

        (*  Damit werden die Fensterausmae des Fensters 'handle' auf
         *  'frame' gesetzt.
         *  Es mu immer die Gre der Fensterauenmae angegeben werden.
         *)

PROCEDURE SetWindowSlider (handle: CARDINAL;
                           typ   : WSliderMode;
                           value : INTEGER);

        (*  Setzt ein Fensterschieberparameter auf den Wert 'value'.
         *  Die Parameterbeschreibung entspricht der von 'WindowSliderValue'.
         *)

PROCEDURE SetTopWindow (handle: CARDINAL);

        (*  Das Fenster mit der Kennung 'handle' wird nach oben gebracht.
         *)

PROCEDURE SetNewDesk (tree: PtrObjTree; first: CARDINAL);

        (*  Diese Routine erlaubt es eine eigene Desktop-Oberfche anzu-
         *  melden. Dadurch kann der Bildschirmhintergrund frei gestaltet
         *  werden. Die Oberflche mu in Form eines Objektbaumes vor-
         *  liegen.
         *  'tree'      -- derObjektbaum
         *  'first'     -- gibt das erste zu Zeichnende Objekt des
         *                 Baumes an.
         *
         *  Hinweis: Durch das Anmelden wird der neue Hintergrund noch
         *           nicht dargestellt, dafr mu erst ein Neuzeichnen
         *           veranlat werden (Siehe 'AESForms.FormDial').
         *)

PROCEDURE FindWindow (loc: Point): CARDINAL;

        (*  Diese Funktion ermittelt, welches Fenster sich an der Position
         *  'loc' befindet. Als Ergebnis wird die Fensterkennung geliefert.
         *)

PROCEDURE UpdateWindow (update: BOOLEAN);

        (*  Hiermit wird dem AES mitgeteilt, zu welchem Zeitpunkt eine An-
         *  wendung Ausgaben in ein Fenster ttigen will. Whrend dieser
         *  Zeit reagiert das AES nicht auf Versuche des Anwenders die Menu-
         *  zeile zu benutzen oder Fensterelemente zu bedienen.
         *  Mit 'update = TRUE' werden die Ausgaben eingeleitet und mit
         *  'FALSE' beendet.
         *  Diese Routine hat einen internen Zhler, so da fr zwei ge-
         *  schachtelte Aufrufe mit 'TRUE' auch zwei mit 'FALSE' folgen
         *  men.
         *)

PROCEDURE MouseControl (user: BOOLEAN);

        (*  Die Reaktion des AES auf diese Routine entspricht im wesentlichen
         *  der auf 'UpdateWindow', nur ist dafr vorgesehen, da die Anwen-
         *  dung die Kontrolle ber alle Mausfunktionen selbst bernimmt.
         *)


TYPE    WCalcMode       = (calcBorder, calcWork);

PROCEDURE CalcWindow (typ  : WCalcMode;
                      elems: WElementSet;
                      in   : Rectangle  ): Rectangle;

        (*  Diese Funktion berechnet aus Fensterauenmaen die Arbeitsbe-
         *  reichsmae und umgekehrt.
         *
         *  'elems'      -- enthlt die Fensterelemente
         *
         *  Fr 'typ' gilt:
         *
         *  'calcBorder' -- 'in' enthlt Arbeitsbereichsgre und das Er-
         *                   gebnis sind die Auenmae.
         *  'calcWork'   -- 'in' enthlt die Auenmae un das Ergebnis ist
         *                   die Arbeitsbereichsgre.
         *)


PROCEDURE ResetWindows ();

        (*  Es werden alle noch offenen Fenster der Applikation geschlossen,
         *  auerdem wird 'UpdateWindow' und 'MouseControl' zurckgesetzt.
         *
         *  ACHTUNG: Diese Prozedur ist erst ab TOS 1.4 funktionsfhig.
         *           Die TOS-Version kann mit 'GEMEnv.GEMVersion' erfragt
         *           werden.
         *)


END AESWindows.