 DEFINITION MODULE GMEConfig;
 (*$Z+*)
 
 FROM GMEBase IMPORT
"einKey, einStatus, cTastaturEbenen, einLinePointer, einPufferPointer,
"einBefehl;
 
 TYPE    einTastenTyp =          (keineTaste, Zeichen, Befehl, String,
AMakro, Mausklick, Tastenebene);
 
(einTastaturPointer =    POINTER TO eineTastenEbene;
(einMakroPointer =       POINTER TO einMakro;
 
(einTasteneintrag =      RECORD
BCASE TT: einTastenTyp OF
DkeineTaste: |
DZeichen:    zch:    CHAR;|
DBefehl:     bef:    einBefehl;|
DString:     str:    einLinePointer;|
DMakro:      mak:    einMakroPointer;|
DMausklick:  x, y:   CARDINAL;|
DTastenebene: teb:   einTastaturPointer;|
BEND (* CASE *);
@END (* einTasteneintrag *);
!
(einMakro =              RECORD
Bmakro:        einTasteneintrag;
Bnext:         einMakroPointer;
@END;
 
(eineTastenEbene =       ARRAY einKey OF einTasteneintrag;
(eineTastatur =          ARRAY [0..cTastaturEbenen] OF einTastaturPointer;
!
 VAR     Tastatur:               eineTastatur;
(ConfigInit:     BOOLEAN;
 
 PROCEDURE TastaturIndex (s: einStatus): CARDINAL;
 PROCEDURE NewTastenebene (VAR T: einTastaturPointer);
 PROCEDURE RemoveTastenebene (VAR T: einTastaturPointer);
 PROCEDURE InitTastenebene (keyStatus: einStatus; T: einTastaturPointer);
 PROCEDURE InitTastatur (VAR T: eineTastatur);
 PROCEDURE SetTaste (key: einKey; T: einTastaturPointer;
4eintrag: einTasteneintrag);
 PROCEDURE LiesTastMaus (VAR t: einTasteneintrag; keys: einStatus);
 PROCEDURE LiesBefehl (VAR b: einBefehl);
 PROCEDURE LiesTaste (VAR t: einTasteneintrag);
 PROCEDURE LiesZeichen (VAR ch: CHAR);
 PROCEDURE TasteBereit(): BOOLEAN;
 PROCEDURE LoescheQueue;
 PROCEDURE InitConfig (VAR Puff: einPufferPointer);
 PROCEDURE CopyConfig (VAR Q, Z: einPufferPointer);
 
 END GMEConfig.
  
(* $FFEE806A$FFEE806A$FFEE806A$FFEE806A$FFEE806A$FFEE806A$FFEE806A$FFEE806A$FFEE806A$FFEE806A$FFEE806A$0000009C$FFEE806A$00000712$FFEE806A$FFEE806A$FFEE806A$FFEE806A$FFEE806A$FFEE806A$FFEE806A$FFEE806A$FFEE806A$FFEE806A$FFEE806A$FFEE806A$FFEE806A$FFEE806A$FFEE806A$FFEE806A$FFEE806A$FFEE806A$FFEE806A$FFEE806A$FFEE806A$FFEE806A$FFEE806A$FFEE806A$FFEE806A$FFEE806A$FFEE806A$FFEE806A$0000008CT.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$00000710$0000001D$FFEB6B7C$FFEB6B7C$FFEB6B7C$0000070C$00000089$00000068$0000008C$FFEE806A$FFEE806A$FFEE806A$FFEE806A$FFEE806A$FFEE806A$FFEE806A*)
