 (* Portierung auf MM2: 9. 6. 89 *)
 (* Stand 10. 12. 90 *)
 
 (*
"17.1.90: TT  MainOutputPath & CompilerParm.name beim Compiler-Call
/ausgewertet
#6.3.90: TT  CompilerArgs an Compiler bergeben
"29.7.90: TT  $Y+ Direktive eingefgt, $J- entfernt
!13.12.90: TT  Damit nach Compile-Lauf im GME der Text ein File-Datum
/erhhlt, das das Make zufriedenstellt, wird die Zeit VOR
/dem Compiler-Aufruf verwendet.
 *)
 
 IMPLEMENTATION MODULE GMEditor;
 
 (* The Little Golem Editor. Begonnen 13. 06. 86
#(C) 1986, 1987, 1988 by Johannes Leckebusch.
#(C) 1989, 1990 by Johannes Leckebusch.
 *)
 
 (*$R-*)
 (*$Z+*)
 (*$Y+ (sonst geht Compile nicht!) *)
 
 
 FROM SYSTEM IMPORT ASSEMBLER, ADR, ADDRESS;
 IMPORT StrConv, Loader, Paths, ShellMsg, TimeConvert, Clock, Lists;
 (* FROM Storage IMPORT Inconsistent; *)
 FROM EasyGEM1 IMPORT ClearScrap;
 
 (* FROM MyConversions IMPORT ConvCard; *)
 FROM Convert IMPORT ConvCard;
 
 IMPORT Strings;
 IMPORT Directory;
 
 FROM FastStrings IMPORT Append, Assign, Copy, Delete, Length,
6Insert, Pos;
 
 FROM GMEBase IMPORT nul, backspace, CharsInLine, tab, LinesOnScreen,
7linedel, lineins,
7WriteChar, WriteLn, WriteConst, Trace,
7LoescheBild, LoescheZeile, GotoXY,
7(* CursorEin, *) CursorAus, HighLight, Normal,
7Left, Right, ButtonSet, MausPos, MausDoppel,
7MausAus, MausEin, MausBusy, Nachricht,
7FrageJaNein, Ja, Nein, Abbruch,
7CharWidth, CharHeight, ScreenWidth, ScreenHeight;
 
 FROM GMEBase IMPORT einBefehl, Befehlssatz;
 FROM GMEConfig IMPORT einTasteneintrag, einTastenTyp, LiesZeichen,
(CopyConfig;
 
 FROM GMEBase IMPORT UndoPuffer, ClipBoard, HilfsPuffer, ConfigPuffer,
(EditPuffer, AlternEdit, FehlerPuffer, MailPuffer, GolemPuffer,
(Tausch, SendePuffer, PSCPuffer, WaehlPuffer, undone,
(DruckPuff, StartPuffer;
 
 FROM GMEBase IMPORT cZeile;
 
 FROM GMEBase IMPORT eineZeile, eineInfo, einLinePointer, aLine,
5einStringPointer,
5einPufferPointer, einMerkPunkt, MerkIndex, einMerkPointer,
5einPufferDeskriptor, Mode,
5Moden, CharSet;
 
 FROM GMEBase IMPORT Loeschen, DeletePuffer, PufferLeer,
5GetLine, PutLine,
5FindeLeerpuffer, InsertPuffer, AutoCount;
 
 FROM GMEKernel IMPORT WriteString, SchirmSchreiben,
7InsertZeile, tabjump;
 
 FROM GMEFile IMPORT SaveConfig, LoadConfig;
 
 FROM GMEKernel IMPORT Edit, Prompt;
 
 FROM GMEKernel IMPORT SucheZeilenPointer, StelleZeileEin, StellePointerEin,
7SucheZeilenNummer, LineDown, LineUp,
7DeleteLine, InsertLine, ScrollDown, ScrollUp,
7DoBackspace, DoDelete, DoCR;
 
 FROM GMEKernel IMPORT SucheWort, TauscheWort, GetKey, ReadNum,
(InBlockMarken, BlockMarkiert, KopiereLoesche, Kopiere,
(MarkiereBlockAnfang, MarkiereBlockEnde, LoescheBlockMarken,
(RueckeBlockEin, LoeschePuffer;
 
 (* FROM EditLook IMPORT SuchwortHolen, WortSuchen, SuchTauschen; *)
 
 FROM GMEBase IMPORT DeleteTail, DoClipboard;
 
 FROM GMEFile IMPORT TextSchreiben, TextLesen;
 
 FROM GMEFile IMPORT ScrapPfad, ScrapName, SetCompilerInfo;
 
 CONST   coffset =               16;
 
 VAR     scrolloffset:           CARDINAL;
(dummy:                  CHAR;
(befehl:                 einBefehl;
(key:                    einTasteneintrag;
(version:                eineInfo;
(suchwort:               eineZeile;
(tauschwort:             eineZeile;
(Zeile:                  eineZeile;
(dummyC, dummyCC:        CARDINAL;
(mx, my, oldmx, oldmy:   CARDINAL;
(Knoepfe:                ButtonSet;
(bewegt:                 BOOLEAN;
(SelectMenue,
(SelectEintrag:          CARDINAL;
(LoeschPfad, LoeschName: eineInfo;
(DummySuff:              ARRAY [0..3] OF CHAR;
(result:                 INTEGER;
(returnX:                CARDINAL;
(VollPrompt:             BOOLEAN;
(BlockWurdeMarkiert:     BOOLEAN;
 
 VAR compLine: einLinePointer;
$compEOF: CHAR;
 
 
 (* die folg. Prozedur mu global sein! *)
 
 (*$Z-*)
 PROCEDURE doCompilerLine (): einStringPointer;
"(*$L-*)
"BEGIN
$(*
&compLine:= compLine^.naechste;
&IF compLine # NIL THEN
(p:= compLine^.ZeilPointer;
&ELSE
(compEOF:= 3C;
(p:= ADR (compEOF)
&END;
&RETURN p
$*)
$ASSEMBLER
(LEA     compLine,A0
(MOVE.L  (A0),A1
(MOVE.L  compLine.naechste(A1),A1
(MOVE.L  A1,(A0)
(BEQ     atEOF
 
(MOVE.L  compLine.ZeilPointer(A1),(A3)+
(RTS
 
&atEOF
(MOVE.B  #$03,compEOF
(MOVE.L  #compEOF,(A3)+
$END;
"END doCompilerLine;
"(*$L=*)
 (*$Z+*)
 
 (*************************** Aus EditLook ***********************)
 
 (*********** Alte Suchroutinen, die frueher in Editor.MOD waren: ****)
 CONST   PhantomTrenn =          37C; (* Arghhh! Sollte importiert werden... *)
 VAR     TrennSet, BindeSet:     CharSet;
 
 PROCEDURE SuchwortHolen (Puff: einPufferPointer; VAR suchwort: ARRAY OF CHAR);
 VAR   ind, off:               CARDINAL;
&switch, warBlank:       BOOLEAN;
 
"(* Aus Editline, abgeaendert!: *)
"PROCEDURE SkipBlank (ch: CHAR): BOOLEAN;
"BEGIN
$switch := warBlank;
$warBlank := warBlank OR (ch IN TrennSet);
$IF warBlank & (ch # ' ') & switch THEN
&warBlank := FALSE;
&switch := FALSE;
&RETURN FALSE; (* Cursor bleibt stehen *)
$ELSE RETURN TRUE; (* Cursor luft weiter *)
$END (* IF *);
"END SkipBlank;
"
 BEGIN (* SuchwortHolen *)
"suchwort [0] := nul;
"WITH Puff^.MerkPunkte [LaufendeZeile] DO
$ind := 0; off := 0; warBlank := FALSE;
$IF (merkline^.ZeilPointer^ [ind + charpos] IN TrennSet) THEN
&WHILE SkipBlank (merkline^.ZeilPointer^ [ind + charpos]) DO
(INC (ind); INC (off);
&END;
$END (* IF *);
$IF charpos + ind < Length (merkline^.ZeilPointer^) THEN
&WHILE (SkipBlank (merkline^.ZeilPointer^ [ind + charpos])) &
,(merkline^.ZeilPointer^ [ind + charpos] # ' ') DO
(suchwort [ind - off] := merkline^.ZeilPointer^ [ind + charpos];
(INC (ind);
&END (* WHILE *);
&IF (ind > 0) & (merkline^.ZeilPointer^ [ind - 1 + charpos] IN
+TrennSet - CharSet {' '})
(THEN DEC (ind);
&END (* IF *);
$END (* IF *);
$suchwort [ind - off] := nul;
"END (* WITH *);
 END SuchwortHolen;
!
 PROCEDURE WortSuchen (Puff: einPufferPointer;
6holen: BOOLEAN; VAR suchwort: ARRAY OF CHAR);
 VAR   repeat:           CARDINAL;
&s:                CharSet;
&m:                eineInfo;
&gefunden:         BOOLEAN;
&ersterFund:       BOOLEAN;
&IndexAbfrage:     BOOLEAN;
&ok:               BOOLEAN;
 VAR   ml, mp, hp:       einMerkPointer;
&(* dummy,dummy1, scd, *)
&ch, ch1:          CHAR;
&key:              einTasteneintrag;
 BEGIN
"IF holen THEN SuchwortHolen (Puff, suchwort);
"(* ELSE suchwort [0] := nul; *)
"END;
"IF WortSuche IN Puff^.Modus THEN
$Prompt (1, 'Suche Wort (ESC lscht Vorgabe, leeres Wort bricht ab): ',
*suchwort, key);
"ELSE
$Prompt (1, 'Suche Muster (ESC lscht Vorgabe, leeres Muster bricht ab): ',
*suchwort, key);
"END (* IF *);
"(* tauschwort := ''; *)
"IF ~(suchwort [0] = nul) THEN
"
$s := CharSet {'E', 'N', 'L', 'Q'}; (* Konstante einsetzen funkt. nicht *)
$ch := 'E';
$GetKey (2, 'E(inmal, N(mal, L(etztes suchen oder Q(uit: ', s, ch);
$IF ch = 'Q' THEN
&SchirmSchreiben (Puff, Puff^.MerkPunkte [LaufendeZeile].merkline, 0, 0);
&RETURN;
$END (* IF Quit *);
$IF ch = 'N' THEN
&repeat := 1;
&ReadNum (3, 'Anzahl: ', repeat);
&IF repeat = 0 THEN RETURN; END;
$ELSE repeat := 1;
$END (* IF *);
$ersterFund := TRUE;
$IF holen THEN
&WITH Puff^ DO
(WITH MerkPunkte [LetztePosition] DO
*zeilpos := MerkPunkte [LaufendeZeile].zeilpos;
*charpos := MerkPunkte [LaufendeZeile].charpos;
*merkline := MerkPunkte [LaufendeZeile].merkline;
(END (* WITH *);
&END (* WITH Puff^ *);
&StelleZeileEin (Puff, 1, 0);
$END (* IF holen *);
$REPEAT
&MausBusy;
&SucheWort (Puff, suchwort, gefunden, key);
&IF ch IN CharSet {'E', 'N'} THEN DEC (repeat);
(IF ~gefunden THEN
*Strings.Assign ('>>', m, ok); Append (suchwort, m);
*Strings.Append ('<<|nicht gefunden!', m, ok);
*Nachricht (m);
(END (* IF ~gefunden *);
&END (* IF dummy *);
$UNTIL (ch = 'E') OR ~gefunden OR (repeat = 0);
"END (* IF *);
"IF gefunden THEN
$WITH Puff^ DO
&WITH MerkPunkte [IndexListe] DO
(zeilpos := MerkPunkte [LaufendeZeile].zeilpos;
(merkline := MerkPunkte [LaufendeZeile].merkline;
(charpos := MerkPunkte [LaufendeZeile].charpos;
&END (* WITH *);
$END (* WITH Puff^ *);
"END (* IF gefunden *);
"Normal;
"SchirmSchreiben (Puff, Puff^.MerkPunkte [LaufendeZeile].merkline, 0, 0);
 END WortSuchen;
 
 PROCEDURE SuchTauschen (Puff: einPufferPointer; holen: BOOLEAN;
8VAR suchwort, tauschwort: ARRAY OF CHAR);
 VAR   repeat:           CARDINAL;
&dummy:            einTasteneintrag;
&ch, ch1:          CHAR;
&key:              einTasteneintrag;
&s:                CharSet;
&gefunden:         BOOLEAN;
 BEGIN
"IF holen THEN SuchwortHolen (Puff, suchwort);
"(* ELSE suchwort [0] := nul; *)
"END;
"WITH Puff^ DO
$IF WortSuche IN Modus THEN
&Prompt (1,
!'Suchen & Tauschen: Suchwort (ESC lscht Vorgabe, leeres Wort bricht ab): ',
,suchwort, key);
$ELSE
&Prompt (1,
 'Suchen & Tauschen: Suchmuster (ESC lscht Vorgabe, leeres Muster bricht ab): ',
,suchwort, key);
$END (* IF *);
$IF ~(suchwort [0] = nul) THEN
&IF (tauschwort [0] = nul) THEN Assign (suchwort, tauschwort); END;
&Prompt (2, 'Austauschwort (ESC lscht Vorgabe): ', tauschwort, key);
&s := CharSet {'E', 'N', 'F', 'A', 'Q'};
&ch := 'E';
&GetKey (3, 'E(inmal, N(mal, F(ragen nmal, A(lle tauschen, Q(uit: ', s, ch);
&IF ch = 'Q' THEN
(SchirmSchreiben (Puff, MerkPunkte [LaufendeZeile].merkline, 0, 0);
(RETURN;
&END (* IF Quit *);
&IF ch IN CharSet {'N', 'F'} THEN
(repeat := 1;
(ReadNum (4, 'Anzahl (0 fr alle): ', repeat);
(IF repeat = 0 THEN repeat := 65000; END;
&ELSE repeat := 1;
&END (* IF *);
&REPEAT
(MausBusy;
(SucheWort (Puff, suchwort, gefunden, key);
(IF (ch IN CharSet {'E', 'N', 'F'})
(THEN DEC (repeat);
(END (* IF *);
*IF gefunden THEN
,INCL (Modus, Editiert);
,IF ch = 'F' THEN
.SchirmSchreiben (Puff, MerkPunkte [LaufendeZeile].merkline, 0, 0);
.GotoXY (0, 0); LoescheZeile; HighLight;
.WriteConst ('Tauschen J/N/Ende: '); Normal;
.GotoXY (MerkPunkte [LaufendeZeile].charpos -
8MerkPunkte [ErsteZeile].charpos,
6MerkPunkte [LaufendeZeile].zeilpos -
8MerkPunkte [ErsteZeile].zeilpos);
.REPEAT LiesZeichen (ch1); ch1 := CAP (ch1);
.UNTIL ch1 IN CharSet {'J', 'N', 'E'};
,ELSE ch1 := 'J'; WriteChar ('.');
,END (* IF *);
,IF ch1 = 'J' THEN
.TauscheWort (Puff, suchwort, tauschwort, Max, dummy);
,ELSIF ch1 = 'E' THEN gefunden := FALSE;
,END (* IF *);
*END (* IF gefunden *);
&UNTIL (ch = 'E') OR ~gefunden OR (repeat = 0);
$END (* IF *);
$IF gefunden THEN
&WITH MerkPunkte [IndexListe] DO
(zeilpos := MerkPunkte [LaufendeZeile].zeilpos;
(merkline := MerkPunkte [LaufendeZeile].merkline;
(charpos := MerkPunkte [LaufendeZeile].charpos;
&END (* WITH *);
$END (* IF gefunden *);
$SchirmSchreiben (Puff, MerkPunkte [LaufendeZeile].merkline, 0, 0);
"END (* WITH *);
 END SuchTauschen;
 
 (**************************** ENDE EditLook ****************************)
 
 
 PROCEDURE CheckMargin (Puff: einPufferPointer);
 VAR   Cursor, Offset, dec:     CARDINAL;
 BEGIN
"WITH Puff^ DO
$Cursor := MerkPunkte [LaufendeZeile].charpos;
$Offset := MerkPunkte [ErsteZeile].charpos;
 
$IF Cursor < Offset THEN (* es war die linke Grenze: *)
&dec := ((Offset - Cursor) DIV scrolloffset + 1) * scrolloffset;
&IF MerkPunkte [ErsteZeile].charpos > dec THEN
(DEC (MerkPunkte [ErsteZeile].charpos, dec)
&ELSE MerkPunkte [ErsteZeile].charpos := 0;
&END (* IF *);
$ELSIF Cursor >= Offset + CharsInLine (* es war die rechte Grenze: *) THEN
&dec := ((Cursor - Offset) DIV scrolloffset + 1) *
/scrolloffset - CharsInLine;
&INC (MerkPunkte [ErsteZeile].charpos, dec);
$END (* IF globalx <> xoffset *);
"END (* WITH *);
 END CheckMargin;
 
 PROCEDURE CallCompiler (puff: einPufferPointer; VAR msg: ARRAY OF CHAR);
"(*
#* IN: puff
#* OUT: msg  (enthlt Fehlermeldung, sonst leer)
#*)
 
"VAR ok: BOOLEAN; ex: INTEGER; res: Loader.LoaderResults;
&n: CARDINAL; arg: ARRAY [0..125] OF CHAR;
&drivers: Lists.List;
&tagzeit, dat: CARDINAL;
"BEGIN
$GotoXY (0, 0); HighLight;
$WriteConst ('Compiler luft...'); LoescheZeile; Normal;
$ShellMsg.ScanMode:= FALSE;
$compLine:= puff^.Puffer;
$Strings.Concat (puff^.Name, ' /Q /^', arg, ok);
$Strings.Append (StrConv.LHexToStr (ADDRESS (doCompilerLine),0), arg, ok);
$IF ShellMsg.MainOutputPath[0] # 0C THEN
&Strings.Append (' /O', arg, ok);
&Append (ShellMsg.MainOutputPath, arg);
$END;
$IF ShellMsg.CompilerArgs[0] # 0C THEN
&Strings.Append (' ', arg, ok);
&Append (ShellMsg.CompilerArgs, arg);
$END;
$(* Zeit mu VOR Compiler-Aufruf gemerkt werden! *)
$tagzeit:= Clock.PackTime (Clock.CurrentTime ());
$dat:= Clock.PackDate (Clock.CurrentDate ());
$MausBusy;
$Loader.CallModule (ShellMsg.CompilerParm.name, ShellMsg.StdPaths,
7arg, NIL, ex, msg, res);
$IF res = Loader.noError THEN
&CASE ex OF
(0:   Strings.Upper (ShellMsg.CodeName);
-Assign (ShellMsg.CodeName, msg);
-Strings.Append ('   Lnge: ', msg, ok);
-Strings.Append (StrConv.CardToStr (ShellMsg.CodeSize, 0),
=msg, ok);
-WITH puff^ DO
/tageszeit := tagzeit;
/datum := dat;
/INCL (Modus, Compiliert);
-END (* WITH *);
(|
(2,3: StelleZeileEin (puff, ShellMsg.TextLine, LinesOnScreen DIV 2);
-n:= Length
2(puff^.MerkPunkte [LaufendeZeile].merkline^.ZeilPointer^) + 1;
-IF ShellMsg.TextCol > n THEN ShellMsg.TextCol:= n END;
-puff^.MerkPunkte [LaufendeZeile].charpos := ShellMsg.TextCol-1;
-CheckMargin (puff);
-Strings.Assign (ShellMsg.ErrorMsg, msg, ok);
-(*
-WITH puff^.MerkPunkte [CompilerInfo] DO
/zeilpos := puff^.MerkPunkte [LaufendeZeile].zeilpos;
/merkline := puff^.MerkPunkte [LaufendeZeile].merkline;
/charpos := puff^.MerkPunkte [LaufendeZeile].charpos;
/PutLine (merkinfo, msg);
-END (* WITH *);
-*)
(|
(4:   Strings.Assign ('Include-Dateien sind hier nicht erlaubt!',
=msg, ok)
(|
&ELSE
-Strings.Assign ('Unbekannte Antwort vom Compiler', msg, ok);
&END
$ELSE
&(* Fehler in 'msg' anzeigen lassen *)
$END;
$SetCompilerInfo (puff, msg);
"END CallCompiler;
 
 PROCEDURE ZeitAnzeigen (Puff: einPufferPointer; VAR msg: ARRAY OF CHAR);
 VAR     str:            ARRAY [0..13] OF CHAR;
(ok:             BOOLEAN;
 BEGIN
"Assign ('Datum: ', msg);
"TimeConvert.DateToText (Clock.UnpackDate (Puff^.datum), '', str);
"Append (str, msg);
"Append (', Zeit: ', msg);
"TimeConvert.TimeToText (Clock.UnpackTime (Puff^.tageszeit), '', str);
"Append (str, msg);
 END ZeitAnzeigen;
 
 PROCEDURE CursorAufMauspos (Puff: einPufferPointer; bef: einTasteneintrag);
 VAR     n:              CARDINAL;
(xpos, ypos:     CARDINAL;
 BEGIN
"IF oldmy <= CharHeight * 3 (* in Statuszeile *)
$THEN RETURN;
"END;
"xpos := oldmx DIV CharWidth; ypos := oldmy DIV CharHeight - 2;
"WITH Puff^ DO
$MausAus; GotoXY (xpos, ypos);
$(* n wird die absolute Textzeile, daher Addition
'des Fensteroffsets >>ErsteZeile.zeilpos<< *)
$n := MerkPunkte [ErsteZeile].zeilpos + ypos;
$IF n > ZeilenAnzahl THEN n := ZeilenAnzahl; END;
 
$(* Einstellen auf die Zeile mit gleichem Fensteroffset *)
$StelleZeileEin (Puff, n, n - MerkPunkte [ErsteZeile].zeilpos);
$
$(* Einstellen auf Charakter + seitlichem Scrolloffset *)
$MerkPunkte [LaufendeZeile].charpos := MerkPunkte [ErsteZeile].charpos +
;xpos;
$CASE bef.bef OF
&LeftMous:         MarkiereBlockAnfang (Puff); BlockWurdeMarkiert:= TRUE|
&RightMous:        MarkiereBlockEnde (Puff); BlockWurdeMarkiert:= TRUE|
&ELSE;
$END;
"END (* WITH *);
 END CursorAufMauspos;
 
 PROCEDURE DoWeitSuch (Puff: einPufferPointer);
 VAR     gefunden:       BOOLEAN;
(ok:             BOOLEAN;
 BEGIN
"WITH Puff^ DO
$IF ~(suchwort [0] = nul) THEN
&GotoXY (0, 0); HighLight; LoescheZeile;
&WriteString (0, suchwort);
&MausBusy;
&SucheWort (Puff, suchwort, gefunden, key);
&IF gefunden THEN
(WITH MerkPunkte [IndexListe] DO
*zeilpos := MerkPunkte [LaufendeZeile].zeilpos;
*merkline := MerkPunkte [LaufendeZeile].merkline;
*charpos := MerkPunkte [LaufendeZeile].charpos;
(END (* WITH *);
&ELSE
(Strings.Assign ('>>', Zeile, ok); Append (suchwort, Zeile);
(Strings.Append ('<<|nicht gefunden!', Zeile, ok);
(Nachricht (Zeile);
&END (* IF ~gefunden *);
&Normal;
$END (* IF *);
"END (* WITH *);
 END DoWeitSuch;
 
 PROCEDURE DoTextLoad (VAR Puff: einPufferPointer; termch: einTasteneintrag;
(VAR Info: ARRAY OF CHAR);
 VAR     helpPuff:       einPufferPointer;
 BEGIN
"WITH Puff^ DO
$helpPuff := FindeLeerpuffer (Puff);
$IF helpPuff # NIL THEN
&Puff := helpPuff;
&SchirmSchreiben (Puff,
*Puff^.MerkPunkte [LaufendeZeile].merkline, 0, 0);
&Puff := helpPuff;
&TextLesen (Puff, TRUE, TRUE, TRUE, TRUE);
0(* KonfigSpeichern IN ConfigPuffer^.Modus);*)
&IF ~PufferLeer (Puff) THEN
(Assign (helpPuff^.Pfad, Info); DeleteTail (Info);
(Append (helpPuff^.Name, Info);
(Puff := helpPuff;
&END (* IF Puffer leer *);
&tabjump := TabWeite;
&SchirmSchreiben (Puff,
(MerkPunkte [LaufendeZeile].merkline, 0, 0);
$END (* IF *);
"END (* WITH *);
 END DoTextLoad;
 
 PROCEDURE DoNaechsterMerker (Puff: einPufferPointer;
=VAR infozeile: ARRAY OF CHAR);
 VAR     mp:     einMerkPointer;
 BEGIN
"WITH Puff^.MerkPunkte [CompilerInfo] DO
$StellePointerEin (Puff, merkline, LinesOnScreen DIV 2);
$Puff^.MerkPunkte [LaufendeZeile].charpos := charpos;
$GetLine (merkinfo, infozeile);
"END (* WITH *);
"WITH Puff^ DO
$WITH MerkPunkte [LaufendeZeile] DO
&IF (charpos > MerkPunkte [ErsteZeile].charpos + CharsInLine) OR
)(charpos < MerkPunkte [ErsteZeile].charpos) THEN
(CheckMargin (Puff);
&END (* IF *);
$END (* WITH *);
"END (* WITH Puff^ *);
 END DoNaechsterMerker;
 
 PROCEDURE Editieren (Puff: einPufferPointer;
5VAR RetPuff: einPufferPointer;
5VAR termch: einTasteneintrag;
5infozeile: ARRAY OF CHAR;
5Level: CARDINAL);
 VAR    restlaenge:              CARDINAL;
'n, mz:                   CARDINAL;
'ml:                      einLinePointer;
'shift:                   BOOLEAN;
'overflow:                BOOLEAN;
'marginoverflow:          BOOLEAN;
'Indent:                  BOOLEAN;
'Inf, Info:               eineInfo;
'AlterPfad, AlterName:    eineInfo;
'ch:                      CHAR;
'helpInfo:                eineInfo;
 
'helpPuff:                einPufferPointer;
!
 VAR     dummy:          CHAR;
(gefunden:       BOOLEAN;
(gotoX, gotoY:   CARDINAL;
(Z:              eineInfo;
 
"PROCEDURE Vorlauf (Puff: einPufferPointer);
"VAR   l, ll:          CARDINAL;
(loescheBlanks:  BOOLEAN;
(ok:             BOOLEAN;
"BEGIN
$EditPuffer := Puff;
$WITH Puff^ DO
&
&(* *** Anzeige der Kopfzeile: *** *)
&Assign (Pfad, Inf); DeleteTail (Inf);
&Append (Name, Inf);
&IF Editiert IN Modus THEN Strings.Append (' !', Inf, ok); END;
&
&(* *** Zeileneditor aufrufen: *** *)
&MausPos (oldmx, oldmy, bewegt, Knoepfe);
&
&EXCL (Modus, Changed);
&IF (infozeile [0] = nul) THEN
(Edit (Puff, Zeile, TRUE, VollPrompt, Inf,
.overflow, marginoverflow,
.FALSE, oldmx, oldmy, termch);
.VollPrompt := FALSE;
&ELSE
(Edit (Puff, Zeile, FALSE, TRUE, infozeile,
.overflow, marginoverflow,
.FALSE, oldmx, oldmy, termch);
(infozeile [0] := nul; VollPrompt := TRUE;
&END (* IF *);
&
&(* *** Bearbeitete Textposition merken: *** *)
&IF (termch.TT = Befehl) & (termch.bef = RestoreCurrentLine) THEN
(IF ~(Changed IN Modus) THEN
*termch.bef := PopLastBufferLine;
(ELSE
*SchirmSchreiben (Puff, MerkPunkte [LaufendeZeile].merkline, 0, 0);
*termch.bef := nothing;
(END;
&ELSIF Changed IN Modus THEN
(WITH MerkPunkte [LetztePosition] DO
*zeilpos := MerkPunkte [LaufendeZeile].zeilpos;
*charpos := MerkPunkte [LaufendeZeile].charpos;
*merkline := MerkPunkte [LaufendeZeile].merkline;
(END (* WITH *);
&
((* Zeile zurueckschreiben: *)
(PutLine (MerkPunkte [LaufendeZeile].merkline, Zeile);
(INCL (Modus, Editiert);
(EXCL (Modus, Compiliert);
&END (* IF changed *);
&(*
&IF (AutoCount >= SchreibZaehler) & (AutoSave IN Modus) THEN
(AutoCount := 0;
(TextSchreiben (Puff, FALSE, FALSE, FALSE, KonfigSpeichern IN Modus, FALSE);
(SchirmSchreiben (Puff, MerkPunkte [LaufendeZeile].merkline, 0, 0);
9(*MerkPunkte [LaufendeZeile].zeilpos -
;MerkPunkte [ErsteZeile].zeilpos); *)
&END (* IF AutoCount *);
&*)
$END (* WITH *);
"END Vorlauf;
 
 CONST   BrowseOff =     8; (* Mausabstand vom Schirmrand in Chars,
>um Browser statt Menue zu rufen *)
 VAR     mp, hp:         einMerkPointer;         (* Fuer MerkMenu *)
(mpt:            einMerkPunkt;
(ok:             BOOLEAN;
(vorherMarkiert: BOOLEAN;
(
 BEGIN (* Editieren *)
"VollPrompt := TRUE;
"WITH Puff^ DO
$EXCL (Modus, Changed);
$tabjump := TabWeite;
$IF ~(Exit IN Puff^.Modus) THEN
&SchirmSchreiben (Puff, Puff^.MerkPunkte [LaufendeZeile].merkline, 0, 0);
$END (* IF *);
"END (* WITH *);
"REPEAT
$WITH Puff^ DO
&(* tabjump := TabWeite; *)
&IF (termch.bef = RollFLeft) OR (termch.bef = RollFRight) THEN
(scrolloffset := CharsInLine - TabWeite
&ELSE scrolloffset := TabWeite + TabWeite;
&END;
&Vorlauf (Puff);
&vorherMarkiert:= BlockWurdeMarkiert;
&BlockWurdeMarkiert:= FALSE;
&CASE termch.bef OF
(RollLeft, RollFLeft:  IF MerkPunkte [ErsteZeile].charpos > 0 THEN
5marginoverflow := TRUE;
5MerkPunkte [LaufendeZeile].charpos :=
7MerkPunkte [ErsteZeile].charpos - 1;
3END (* IF *);
(|
(RollRight, RollFRight:  IF MerkPunkte [ErsteZeile].charpos + CharsInLine <= Max THEN
6MerkPunkte [LaufendeZeile].charpos :=
7MerkPunkte [ErsteZeile].charpos + CharsInLine;
4ELSE MerkPunkte [LaufendeZeile].charpos := Max;
4END (* IF *);
4marginoverflow := TRUE;
(|
(ELSE;
&END (* CASE *);
&IF marginoverflow THEN
(CheckMargin (Puff);
(SchirmSchreiben (Puff, MerkPunkte [LaufendeZeile].merkline, 0, 0);
&ELSE (* not overflow *)
!
(CASE termch.bef OF
*EditBlock:       Strings.Assign ('[***Blockpuffer***]', Inf, ok);
;EXCL (ClipBoard^.Modus, Exit);
;SchirmSchreiben (ClipBoard,
=MerkPunkte [ErsteZeile].merkline, 0, 0);
;Editieren (ClipBoard, helpPuff, key, Inf, 0);
;EditPuffer := Puff;
;VollPrompt := TRUE;
-|
*Seitup:          IF ((MerkPunkte [LaufendeZeile].zeilpos + 3) >
=LinesOnScreen) THEN
=StelleZeileEin (Puff,
MMerkPunkte [LaufendeZeile].zeilpos
M- LinesOnScreen + 3,
MMerkPunkte [LaufendeZeile].zeilpos
M- MerkPunkte [ErsteZeile].zeilpos);
;ELSE StelleZeileEin (Puff, 1, 0);
;END (* IF *);
;|
*cursup:          LineUp (Puff);|
*Seitdown:        StelleZeileEin (Puff,
KMerkPunkte [LaufendeZeile].zeilpos
K+ LinesOnScreen - 3,
KMerkPunkte [LaufendeZeile].zeilpos
K- MerkPunkte [ErsteZeile].zeilpos);
;|
*cursdown:        LineDown (Puff);
;|
*cursleft, ZeilAnf, DelBZeil,
*Wortleft:        IF MerkPunkte [LaufendeZeile].merkline^.vorige # Puffer THEN
=LineUp (Puff);
=MerkPunkte [LaufendeZeile].charpos :=
?Length (MerkPunkte [LaufendeZeile].merkline^.ZeilPointer^);
;END (* IF *);
;|
*cursright, ZeilEnde, DelEZeil,
*Wortrigt:        IF MerkPunkte [LaufendeZeile].merkline^.naechste # NIL THEN
=LineDown (Puff);
=MerkPunkte [LaufendeZeile].charpos := 0;
;END (* IF *);
;VollPrompt := TRUE;
;|
*DelLChar,
*DelLWort:        DoBackspace (Puff);
;VollPrompt := TRUE;
;|
*DelRChar,
*DelRWort:        WITH MerkPunkte [LaufendeZeile] DO
=charpos := Length (merkline^.ZeilPointer^);
;END;
;DoDelete (Puff);
;VollPrompt := TRUE;
;|
*(* RETURN - Zeile spalten, neue Zeile einfuegen: *)
*return:          returnX := 1; DoCR (Puff, TRUE, returnX);
;VollPrompt := TRUE;
;|
*(* Undo-Puffer loeschen: *)
*LoeschUndo:      undone := FALSE;
;Loeschen (UndoPuffer);
;|
*(* Zeile in Puffer kopieren: *)
*PopCopyLine:     InsertLine (UndoPuffer,
=Puff^.MerkPunkte [LaufendeZeile].merkline^.ZeilPointer^,
=FALSE, FALSE, FALSE);
;VollPrompt := TRUE;
;|
*(* Zeile loeschen - in Puffer schreiben: *)
*PopDeleteLine:   DeleteLine (Puff,
AMerkPunkte [LaufendeZeile].merkline,
CTRUE, TRUE);
;INCL (Modus, Editiert);
;EXCL (Modus, Compiliert);
;VollPrompt := TRUE;
;|
*(* Zeile aus Puffer bei Cursor in Text kopieren: *)
*PopLastBufferLine,
*CopyLastBufferLine: Indent := AutoIndent IN Modus;
;EXCL (Modus, AutoIndent);
;LineUp (Puff);
;InsertLine (Puff,
GUndoPuffer^.MerkPunkte
I[LaufendeZeile].merkline^.ZeilPointer^,
GFALSE, TRUE, TRUE);
;IF termch.bef = PopLastBufferLine THEN
=DeleteLine (UndoPuffer,
?UndoPuffer^.MerkPunkte [LaufendeZeile].merkline,
GFALSE, FALSE);
=LineUp (UndoPuffer);
;END (* IF *);
;IF Indent THEN INCL (Modus, AutoIndent); END;
;INCL (Modus, Editiert);
;EXCL (Modus, Compiliert);
;VollPrompt := TRUE;
;|
*(* Ueberschreiben/Einfuegen umschalten: *)
*indent:          IF AutoIndent IN Modus THEN
>EXCL (Modus, AutoIndent);
;ELSE INCL (Modus, AutoIndent);
;END (* IF *);
;VollPrompt := TRUE;
;|
*insert:          IF OverWrite IN Modus THEN
=EXCL (Modus, OverWrite);
;ELSE INCL (Modus, OverWrite);
;END (* IF *);
;VollPrompt := TRUE;
;|
*Grossklein:      IF GrossKleinSuche IN Modus THEN
>EXCL (Modus, GrossKleinSuche);
;ELSE INCL (Modus, GrossKleinSuche);
;END;
-|
*Wortsuche:       IF WortSuche IN Modus THEN
=EXCL (Modus, WortSuche);
;ELSE INCL (Modus, WortSuche);
;END;
-|
*(* Hilfspuffer anzeigen: *)
*help:            IF HilfsPuffer # NIL THEN
=EditPuffer := HilfsPuffer;
=HilfsPuffer := Puff;
=Puff := EditPuffer;
=VollPrompt := TRUE;
;END (* IF *);
;|
*(* Neuen Puffer anlegen: *)
*InsertPuff:      Puff := FindeLeerpuffer (Puff);
;IF ~PufferLeer (Puff) THEN
=Puff := InsertPuffer (Puff);
;END;
;VollPrompt := TRUE;
;|
*NaechstenPuffer: helpPuff := Puff;
;Puff := Puff^.NaechsterPuffer;
;tabjump := TabWeite;
;EditPuffer := Puff;
;VollPrompt := TRUE;
;|
*(* Bildschirm nach unten rollen: *)
*Rolldown:        ScrollDown (Puff, 1);
;|
*(* Bildschirm nach oben rollen: *)
*Rollup:          ScrollUp (Puff, 1);
;|
*(* Zum Textanfang springen: *)
*zumDAnf:         MerkPunkte [LaufendeZeile].merkline :=
=Puffer^.naechste;
;MerkPunkte [ErsteZeile].merkline :=
=MerkPunkte [LaufendeZeile].merkline;
;MerkPunkte [LaufendeZeile].zeilpos := 1;
;MerkPunkte [ErsteZeile].zeilpos := 0;
;MerkPunkte [LaufendeZeile].charpos := 0;
;VollPrompt := TRUE; (* Fr alle Flle... *)
;|
*(* Zum Textende springen: *)
*zumDEnde:        StelleZeileEin (Puff, ZeilenAnzahl + 1, LinesOnScreen);
;MerkPunkte [LaufendeZeile].charpos :=
=Length (MerkPunkte [LaufendeZeile].merkline^.ZeilPointer^);
;VollPrompt := TRUE;
;|
*(* Zur einer Zeilennummer springen: *)
*zuNrZeile:       n := 0;
;ReadNum (1, 'Zeilennummer: ', n);
;StelleZeileEin (Puff, n, LinesOnScreen DIV 2);
;VollPrompt := TRUE;
;|
*(* Linke Maustaste gedrueckt: *)
*(* LeftMous *)
*LeftMous, RightMous:        CursorAufMauspos (Puff, termch);
;|
*(* String suchen: *)
*SuchString:      tauschwort := '';
;WortSuchen (Puff, FALSE, suchwort);
;VollPrompt := TRUE;
;|
*(* Ganzes Wort auf Cursor suchen *)
*PickWort:        tauschwort := '';
;WortSuchen (Puff, TRUE, suchwort);
;VollPrompt := TRUE;
;|
*(* Wort noch einmal suchen oder/und austauschen: *)
*WeitSuch:        DoWeitSuch (Puff); VollPrompt := TRUE;
;|
*(* Wort suchen und tauschen: *)
*StriTausch:      SuchTauschen (Puff, FALSE, suchwort, tauschwort);
;VollPrompt := TRUE;
;|
*PickTausch:      SuchTauschen (Puff, TRUE, suchwort, tauschwort);
;VollPrompt := TRUE;
;|
*(* gepufferten Block an Cursorposition in Text kopieren: *)
*Kopier,
*Verschieb,
*Paste:           IF NOT BlockMarkiert (Puff) AND
>(termch.bef # Paste) THEN
=Nachricht ('Kein Block markiert!');
;ELSIF InBlockMarken (Puff)
;& (termch.bef = Verschieb) THEN
=Nachricht ('Verschieben ist hier |nicht mglich!');
;ELSE
=IF BlockMarkiert (Puff) AND
=((termch.bef # Paste) OR vorherMarkiert) THEN
?WITH MerkPunkte [LaufendeZeile] DO
Aml:= merkline;
An:= charpos;
AKopiereLoesche (Puff, ClipBoard,
Ctermch.bef # Paste, termch.bef # Kopier);
AIF termch.bef # Paste THEN
C(* Cursor zurcksetzen *)
CSucheZeilenNummer (Puff, ml, zeilpos);
Cmerkline:= ml;
Ccharpos:= n
AEND
?END
=END;
=LoescheBlockMarken (Puff);
=IF DoClipboard & (termch.bef = Paste) THEN
?EXCL (ClipBoard^.Modus, Editiert);
?LoeschePuffer (ClipBoard);
?Assign (ScrapPfad, ClipBoard^.Pfad);
?Assign (ScrapName, ClipBoard^.Name);
?TextLesen (ClipBoard, TRUE, FALSE, FALSE, FALSE);
=END;
=IF PufferLeer (ClipBoard) THEN
?Nachricht ('Es ist nichts|im Clipboard!');
=ELSE
?Kopiere (Puff, ClipBoard);
=END;
;END;
;VollPrompt := TRUE;
;|
*(* Markierten Block loeschen (oder kopieren) und puffern): *)
*CutToClipboard,
*DeleteBlock,
*CopyToClipboard: KopiereLoesche (Puff, ClipBoard,
=termch.bef # DeleteBlock,
=termch.bef # CopyToClipboard);
;IF (termch.bef # DeleteBlock) & DoClipboard THEN
=ClearScrap; (* Lscht alle "SCRAP.*"-Dateien im
J* Scrap-Ordner, falls er existiert.*)
=Assign (ScrapPfad, ClipBoard^.Pfad);
=Assign (ScrapName, ClipBoard^.Name);
=TextSchreiben (ClipBoard, FALSE, FALSE, FALSE, FALSE, FALSE, ok);
;END;
;LoescheBlockMarken (Puff); VollPrompt := TRUE;
;|
*(* Ganzen Puffer loeschen & entfernen: *)
*LoescheText:     IF (Editiert IN Puff^.Modus) THEN
=IF FrageJaNein (Ja, 'Text speichern?') THEN
?TextSchreiben (Puff, FALSE, FALSE, FALSE,
LKonfigSpeichern IN Modus, FALSE, ok);
=ELSIF
?FrageJaNein (Nein, 'Text ist editiert|Trotzdem lschen?') THEN
?EXCL (Modus, Editiert);
=END (* IF *);
;END (* IF Editiert *);
;IF ~(Editiert IN Puff^.Modus) THEN
=LoeschePuffer (Puff);
=DeletePuffer (Puff);
;END (* IF *);
;VollPrompt := TRUE;
;|
*(* Markierten Block saven *)
*BlockWrit:       TextSchreiben (Puff, FALSE, TRUE, TRUE, FALSE, FALSE, ok);
;IF ok THEN
=LoescheBlockMarken (Puff);
;END;
;VollPrompt := TRUE;
;|
*(* File als Block in Text einfuegen *)
*BlockRead:       AlterName := Puff^.Name;
;AlterPfad := Puff^.Pfad; (* DeleteTail (AlterPfad); *)
;TextLesen (Puff, FALSE, TRUE, FALSE, TRUE);
;Puff^.Name := AlterName; Puff^.Pfad := AlterPfad;
;VollPrompt := TRUE;
;|
*(* Datei sichern ohne Abfrage *)
*Update:          TextSchreiben (Puff, FALSE, FALSE, FALSE,
JKonfigSpeichern IN Modus, FALSE, ok);
;VollPrompt := TRUE;
;|
*(* Text speichern mit Abfrage *)
*TextSave:        TextSchreiben (Puff, FALSE, FALSE, TRUE,
JKonfigSpeichern IN Modus, FALSE, ok);
;VollPrompt := TRUE;
;|
*(* Datei laden *)
*TextLoad,
*TextFragLad:     DoTextLoad (Puff, termch, Info);
;EditPuffer := Puff; VollPrompt := TRUE;
;|
*(* Zum Blockanfang springen: *)
*zurAMark:        StelleZeileEin (Puff,
@MerkPunkte [BlockMarke1].zeilpos, 3);
;MerkPunkte [LaufendeZeile].charpos :=
=MerkPunkte [BlockMarke1].charpos;
;VollPrompt := TRUE;
;|
*(* Marke Blockanfang setzen: *)
*setAMark:        MarkiereBlockAnfang (Puff); BlockWurdeMarkiert:= TRUE
;|
*(* Zum Blockende springen: *)
*zurEMark:        StelleZeileEin (Puff,
KMerkPunkte [BlockMarke2].zeilpos,
KLinesOnScreen - 3);
;MerkPunkte [LaufendeZeile].charpos :=
=MerkPunkte [BlockMarke2].charpos;
;|
*(* Aufheben der Blockmarkierung: *)
*BlockMLoe:       LoescheBlockMarken (Puff);
;|
*(* Marke Blockende setzen: *)
*setEMark:        MarkiereBlockEnde (Puff); BlockWurdeMarkiert:= TRUE
;|
*SelectAll:       mpt:= MerkPunkte [LaufendeZeile];
;WITH MerkPunkte [LaufendeZeile] DO
=n:= 1;
=SucheZeilenPointer (Puff, n, merkline);
=zeilpos:= n; charpos := 0;
=MarkiereBlockAnfang (Puff);
=n:= ZeilenAnzahl;
=SucheZeilenPointer (Puff, n, merkline);
=zeilpos:= n;
=charpos := Length (merkline^.ZeilPointer^);
=MarkiereBlockEnde (Puff);
;END;
;BlockWurdeMarkiert:= TRUE;
;MerkPunkte [LaufendeZeile]:= mpt;
;VollPrompt := TRUE;
;|
*SelectLine:      LoescheBlockMarken (Puff);
;mpt:= MerkPunkte [LaufendeZeile];
;WITH MerkPunkte [LaufendeZeile] DO
=charpos := 0;
=MarkiereBlockAnfang (Puff);
=IF merkline^.naechste # NIL THEN
?merkline := merkline^.naechste;
?INC (zeilpos);
=ELSE
?charpos := Length (merkline^.ZeilPointer^);
=END;
=MarkiereBlockEnde (Puff);
;END;
;BlockWurdeMarkiert:= TRUE;
;MerkPunkte [LaufendeZeile]:= mpt;
;VollPrompt := TRUE;
;|
*SelectWord: (*   noch nicht impl *)
;|
*(* Block Einruecken: *)
*Einrueck:        RueckeBlockEin (Puff);
;VollPrompt := TRUE;
;|
*(* Zur ersten Sprungmarke springen: *)
*zur1Mark:        StelleZeileEin (Puff,
>MerkPunkte [MerkPunkt1].zeilpos,
>LinesOnScreen DIV 2);
;MerkPunkte [LaufendeZeile].charpos :=
=MerkPunkte [MerkPunkt1].charpos;
;|
*(* Erste Sprungmarke setzen: *)
*set1Mark:        WITH MerkPunkte [MerkPunkt1] DO
=zeilpos := MerkPunkte [LaufendeZeile].zeilpos;
=merkline := MerkPunkte [LaufendeZeile].merkline;
=charpos := MerkPunkte [LaufendeZeile].charpos;
;END (* WITH *);|
*(* Zur zweiten Sprungmarke springen: *)
*zur2Mark:        StelleZeileEin (Puff,
KMerkPunkte [MerkPunkt2].zeilpos,
KLinesOnScreen DIV 2);
;MerkPunkte [LaufendeZeile].charpos := MerkPunkte [MerkPunkt2].charpos;
;|
*zur3Mark:        StelleZeileEin (Puff,
KMerkPunkte [M13].zeilpos,
KLinesOnScreen DIV 2);
;MerkPunkte [LaufendeZeile].charpos := MerkPunkte [M13].charpos;
;|
*(* Zweite Sprungmarke setzen: *)
*set2Mark:        WITH MerkPunkte [MerkPunkt2] DO
=zeilpos := MerkPunkte [LaufendeZeile].zeilpos;
=merkline := MerkPunkte [LaufendeZeile].merkline;
=charpos := MerkPunkte [LaufendeZeile].charpos;
;END (* WITH *);|
*set3Mark:        WITH MerkPunkte [M13] DO
=zeilpos := MerkPunkte [LaufendeZeile].zeilpos;
=merkline := MerkPunkte [LaufendeZeile].merkline;
=charpos := MerkPunkte [LaufendeZeile].charpos;
;END (* WITH *);|
*(* Tabulator-Sprungweite einstellen: *)
*TabLaen:         ReadNum (1, 'Tabulatorabstand: ', TabWeite);
;tabjump := TabWeite;
;scrolloffset := TabWeite + TabWeite;
;MerkPunkte [LaufendeZeile].charpos := 0;
;MerkPunkte [ErsteZeile].charpos := 0;
;VollPrompt := TRUE;
;|
*(* Zur letzten bearbeiteten Position springen: *)
*LetztePos:       StelleZeileEin (Puff,
AMerkPunkte [LetztePosition].zeilpos,
ALinesOnScreen DIV 2);
;MerkPunkte [LaufendeZeile].charpos :=
=MerkPunkte [LetztePosition].charpos;
;|
*(* Zur letzten gesuchten Position springen: *)
*LetzteSuchPos:   StelleZeileEin (Puff,
AMerkPunkte [IndexListe].zeilpos,
ALinesOnScreen DIV 2);
;MerkPunkte [LaufendeZeile].charpos :=
=MerkPunkte [LetztePosition].charpos;
;|
*SteuerZeichenAnzeige:
;IF ControlZeichen IN Modus THEN
=EXCL (Modus, ControlZeichen)
;ELSE INCL (Modus, ControlZeichen);
;END;
;|
*TextParam:       IF KonfigSpeichern IN Modus THEN
=EXCL (Modus, KonfigSpeichern)
;ELSE INCL (Modus, KonfigSpeichern);
;END;
;|
*BackupAnlegen:   IF MakeBAK IN Modus THEN
=EXCL (Modus, MakeBAK)
;ELSE INCL (Modus, MakeBAK);
;END;
;|
*GEMKlemmbrettEinAus: DoClipboard := ~DoClipboard;
;|
*QueryError:      DoNaechsterMerker (Puff, infozeile);
;|
*Compile:         infozeile [0] := nul;
;SetCompilerInfo (Puff, infozeile); (* Lschen! *)
;CallCompiler (Puff, infozeile);
;CheckMargin (Puff);
;VollPrompt := TRUE;
;|
*ZeitUndDatum:    ZeitAnzeigen (Puff, infozeile);
;VollPrompt := TRUE;
;|
*GlobParam:       CopyConfig (Puff, ConfigPuffer);
;SaveConfig (ConfigPuffer, TRUE);
;|
*LoadParam:       LoadConfig (ConfigPuffer, TRUE, FALSE);
;|
*ELSE;
(END (* CASE *);
&END (* ELSE overflow *);
$END (* WITH *);
$
$IF (termch.TT = Befehl) & (termch.bef IN
&Befehlssatz {TextLoad, TextFragLad, WeitSuch, SuchString, PickWort,
3StriTausch, PickTausch, BlockMLoe, SelectLine,
3QueryError, KillPuff, NaechstenPuffer, InsertPuff,
3EditBlock, Seitup, GMECopyrightBox,
3Seitdown, help, PufferWaehlen, zumDAnf, zumDEnde, zuNrZeile,
3Lookup, LoadFiles,
3Compile, Make, MakeExec,
3CutToClipboard, CopyToClipboard,
3LoescheText, BlockWrit, BlockRead, TextSave,
3Update, zurAMark, zurEMark, zur1Mark, zur2Mark, zur3Mark,
3TabLaen, LetztePos, LetzteSuchPos,
3GlobParam, MerkPunkt, SetzPunkt, home})
$THEN
&SchirmSchreiben (Puff, Puff^.MerkPunkte [LaufendeZeile].merkline, 0, 0);
&VollPrompt := TRUE;
$END;
"UNTIL (termch.TT = Befehl) & (termch.bef IN
$Befehlssatz {ExitEditor, QuitCompile, QuitCompileRun, Make, MakeExec,
-LoescheAllePuffer, SpeichereAllePuffer}) OR
((Exit IN Puff^.Modus);
"RetPuff := Puff;
 END Editieren;
 
 BEGIN
"Trace ('EditLook');
"BindeSet := CharSet {0C, ' ', '-', PhantomTrenn};
"TrennSet := CharSet {0C, tab, ' ', ',', ';', '.', '(',
7')', '[', ']', '{', '}',
7':', '!', '/', '*', '-',
7'+', '&', '~', '=', (*'^',*)
7'#', '|', '<', '>'};
 
"Trace ('Editor');
"BlockWurdeMarkiert:= FALSE;
"suchwort := ''; tauschwort := '';
"undone := FALSE;
 END GMEditor.
 
 
  
(* $FFED7F4C$FFED7F4C$FFED7F4C$FFED7F4C$FFED7F4C$FFED7F4C$FFED7F4C$FFED7F4C$FFED7F4C$FFED7F4C$FFED7F4C$FFED7F4C$FFED7F4C$FFED7F4C$FFED7F4C$FFEBA0DA$FFED7F4C$FFED7F4C$FFED7F4C$FFED7F4C$FFED7F4C$FFED7F4C$FFED7F4C$FFED7F4C$FFED7F4C$FFED7F4C$FFED7F4C$FFED7F4C$FFED7F4C$FFED7F4C$FFED7F4C$FFED7F4C$FFED7F4C$FFED7F4C$FFED7F4C$FFED7F4C$FFED7F4C$FFED7F4C$FFED7F4C$FFED7F4C$FFED7F4C$FFED7F4C$00003277T.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$00002DD5$00008792$FFEB9790$0000319F$000031FE$000031E3$000031ED$000030FC$00002FF0$FFEB9790$00002F9A$FFEB9790$FFEB9790$000002F7$00003277$00008C0B*)
