 DEFINITION MODULE GMEKernel;
 (*$Z+*)
 
 (* DEFINITION MODULE EditKernel; *)
 
 (* The Little Golem Editor. Begonnen 13. 06. 86
#(C) 1986, 1987, 1988, 1989, 1990 by Johannes Leckebusch.
#Version: Siehe ceditor
#
#TT 14.12.90  "BlockMarkiert" exportiert
 *)
 
 (* Bemerkung: StringZeilen werden als >>Zeile<<, Pointer-Objekte
#als >>Line<< bezeichnet *)
 
 FROM GMEBase IMPORT einPufferPointer, eineInfo, einLinePointer,
"eineZeile;
#
 FROM GMEBase IMPORT CharSet;
 FROM GMEConfig IMPORT einTasteneintrag;
 
 PROCEDURE StelleZeileEin (Puff: einPufferPointer;
:n, offset: CARDINAL);
"(* Zeiger auf die nte Zeile einstellen *)
 
 PROCEDURE StellePointerEin (Puff: einPufferPointer;
@l: einLinePointer;
@offset: CARDINAL);
 
 PROCEDURE SucheZeilenNummer (Puff: einPufferPointer;
=Zeile: einLinePointer;
=VAR Nummer: CARDINAL);
"(* Nummer der Zeile mit Zeiger >>Zeile<< ermitteln *)
 
 PROCEDURE SucheZeilenPointer (Puff: einPufferPointer;
>VAR Nummer: CARDINAL;
>VAR Zeile: einLinePointer);
"(* Pointer auf die Zeile mit Nummer Nummer suchen *)
 
 PROCEDURE LineDown (Puff: einPufferPointer);
"(* eine Zeile nach unten *)
 
 PROCEDURE LineUp (Puff: einPufferPointer);
"(* eine Zeile nach oben *)
 
 PROCEDURE DeleteLine (Puff: einPufferPointer;
6VAR LoeschZeile: einLinePointer;
6zeigen, puffern: BOOLEAN);
"(* loesche die aktuelle Zeile und gehe in die naechste *)
 
 PROCEDURE InsertLine (Puff: einPufferPointer;
6REF z: ARRAY OF CHAR;
6Indent: BOOLEAN;
 (* Dieser Parameter ist scheinbar redundant, doch soll AutoIndent
#oft explizit abgeschaltet sein, z. B. beim Fileeinlesen *)
6zeigen: BOOLEAN;
6adjustMerkpunkte: BOOLEAN);
"(* fuege z nach der laufenen Zeile ein *)
 
 PROCEDURE ScrollDown (Puff: einPufferPointer; z: CARDINAL);
"(* gehe um z Zeilen nach oben *)
 
 PROCEDURE ScrollUp (Puff: einPufferPointer; z: CARDINAL);
"(* gehe um z Zeilen nach unten *)
 
 PROCEDURE DoBackspace (Puff: einPufferPointer);
"(* Fuehre Backspace aus, ev. Zeilen zusammenhaengen *)
 
 PROCEDURE DoDelete (Puff: einPufferPointer);
"(* Fuehre Delete aus, ev. Zeilen zusammenhaengen *)
 
 PROCEDURE DoCR (Puff: einPufferPointer; zeigen: BOOLEAN;
0VAR returnX: CARDINAL);
"(* Spalte Zeile bei Cursorposition, gehe zum Anfang naechste Zeile *)
 
 (* END EditKernel. *)
 
 (* DEFINITION MODULE EditUtil; *)
 
 
 PROCEDURE LoeschePuffer (p: einPufferPointer);
 PROCEDURE GetKey (zeile: CARDINAL;
2info: ARRAY OF CHAR;
2set: CharSet;
2VAR ch: CHAR);
 PROCEDURE ReadNum (zeile: CARDINAL; REF info: ARRAY OF CHAR; VAR n: CARDINAL);
 PROCEDURE Kopiere (Puff: einPufferPointer; ClipBoard: einPufferPointer);
 PROCEDURE KopiereLoesche (Puff, ZielPuff: einPufferPointer;
:kopiere, loesche: BOOLEAN);
 PROCEDURE MarkiereBlockAnfang (Puff: einPufferPointer);
 PROCEDURE MarkiereBlockEnde (Puff: einPufferPointer);
 PROCEDURE LoescheBlockMarken (Puff: einPufferPointer);
 PROCEDURE BlockMarkiert (Puff: einPufferPointer): BOOLEAN;
 PROCEDURE InBlockMarken (Puff: einPufferPointer): BOOLEAN;
 PROCEDURE RueckeBlockEin (Puff: einPufferPointer);
 PROCEDURE SucheWort (Puff: einPufferPointer;
5w: ARRAY OF CHAR; VAR gefunden: BOOLEAN;
5key: einTasteneintrag (* cursup, cursdown, return *));
"(* Stellt LaufendeZeile auf gefundenes Wort ein *)
 
 PROCEDURE TauscheWort (Puff: einPufferPointer;
7VAR s, t: ARRAY OF CHAR; maxx: CARDINAL;
7modus: einTasteneintrag);
 
 (* END EditUtil.*)
 
 (* DEFINITION MODULE EditScreen; *)
 
 PROCEDURE InsertZeile (Puff: einPufferPointer; n: CARDINAL);
 PROCEDURE DeleteZeile (Puff: einPufferPointer; n: CARDINAL);
 PROCEDURE WriteString (xoff: CARDINAL; (*Control, Tabs: BOOLEAN;*)
6VAR s: ARRAY OF CHAR);
 PROCEDURE MakeHighLine (puff: einPufferPointer; (*Control, Tabs: BOOLEAN;*)
8zeile: CARDINAL; VAR inhalt: ARRAY OF CHAR);
 PROCEDURE SchirmSchreiben (Puff: einPufferPointer;
;Start: einLinePointer;
;Anzahl: CARDINAL;
;SOffset: INTEGER);
"(* schreibe den Bildschirm neu *)
"
 PROCEDURE High   (v, h: CHAR; n: ARRAY OF CHAR);
 PROCEDURE HighL  (v, h: CHAR; n: ARRAY OF CHAR);
 
 VAR     tabjump:        CARDINAL;
 
 (* END EditScreen. *)
 
 (* DEFINITION MODULE EditLine; *)
 
 (* Definitionsmenge fuer SkipBlank sollte parametrisiert werden *)
 
 PROCEDURE Prompt (zeile: CARDINAL;
1info: ARRAY OF CHAR;
1VAR eingabe: ARRAY OF CHAR;
1VAR key: einTasteneintrag);
 
 PROCEDURE Edit (Puff: einPufferPointer;
0VAR s:                  ARRAY OF CHAR;  (* Zu editierende Zeile *)
4zeighelp, DoVorlauf: BOOLEAN;        (* Prompt anzeigen *)
0VAR info:               ARRAY OF CHAR;  (* aktuelle Information *)
0VAR overflow:           BOOLEAN;        (* Zeilenberlauf *)
0VAR marginoverflow:     BOOLEAN;        (* Bildschirmberlauf *)
4exit:               BOOLEAN;
0VAR mx, my:             CARDINAL;        (* MausPos vor Tastendruck *)
0VAR termch:             einTasteneintrag); (* FunktionsCode,
Jmit dem die Zeile abgebrochen wurde *)
 (* END EditLine. *)
 
 END GMEKernel.
 
(* $FFEDF89A$FFEDF89A$FFEDF89A$FFEDF89A$FFEDF89A$FFEDF89A$FFEDF89A$FFEDF89A$FFEDF89A$FFEDF89A$FFEDF89A$FFEDF89A$FFEDF89A$FFEDF89A$FFEDF89A$00000A84$FFEDF89A$FFEDF89A$FFEDF89A$FFEDF89A$FFEDF89A$FFEDF89A$FFEDF89A$FFEDF89A$FFEDF89A$FFEDF89A$FFEDF89A$FFEDF89A$FFEDF89A$FFEDF89A$FFEDF89A$FFEDF89A$FFEDF89A$FFEDF89A$FFEDF89A$FFEDF89A$FFEDF89A$FFEDF89A$FFEDF89A$FFEDF89A$FFEDF89A$FFEDF89A$00000BB5T.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$FFEA150D$00000A9B$00000AC8$00000A71$FFEB1170$00000B91$FFEB1170$00000BB5$00000107$FFEAA45E$FFEA150D$FFEB1170$00000A89$FFEA150D$FFEA150D$FFEA150D*)
