 
 DEFINITION MODULE ALAP;
 (*$H+,Z+,R-*)
 
 FROM SYSTEM IMPORT BITNUM, BYTE, WORD, LONGWORD, ADDRESS;
 
 CONST   minFrameSize = 3;
(maxDataSize = 1600; (* Mac: 600!!! *)
(maxFrameSize = maxDataSize+5;
(
(maxDefers = 32;
(maxCollsns = 32;
(lapENQ = BYTE($81);
(lapACK = BYTE($82);
(lapRTS = BYTE($84);
(lapCTS = BYTE($85);
(wksTries = 20;
(
(rxEnable = $DD;
(setRTS   = $62;
(txEnable = $6B;
 
 TYPE    TransmitStatus = (transmitOK, excessDefers, excessCollsns, dupAddress);
(ReceiveStatus = (receiveOK, receiving, nullReceive, frameError);
(FrameStatus = (noFrame, lapDATAframe, lapENQframe, lapACKframe,
(lapRTSframe, lapCTSframe, badframeCRC, badframeSize, badframeType,
(overrunError, underrunError, lostAddress, undefined);
(
(bitVector = SET OF BITNUM[0..7];
(octet = BYTE;
(anAddress = octet;
(aLAPtype = octet;
(aDataField = ARRAY [1..maxDataSize] OF octet;
(ptrDataField = POINTER TO aDataField;
 
(frameInterpretation = (raw, structured);
(aRxFrame = RECORD
5CASE :frameInterpretation OF
7raw:
9rawData: ARRAY [1..maxFrameSize] OF octet|
7structured:
9dstAddr: anAddress;
9srcAddr: anAddress;
9lapType: aLAPtype;
9dataField: aDataField
5END
3END;
(
(aCtrlFrame = RECORD
7dstAddr: anAddress;
7srcAddr: anAddress;
7lapType: aLAPtype;
5END;
 
(ptrPacket = POINTER TO aPacket;
(aPacket = RECORD
4status: FrameStatus;
4length: [0..maxFrameSize];
4next  : ptrPacket;
4frame : aRxFrame;
4no    : CARDINAL;
2END;
 
(aTxFrame = RECORD
5ctrl: aCtrlFrame;
5dataPtr1: ptrDataField;
5dataCnt1: CARDINAL;
5dataPtr2: ptrDataField;
5dataCnt2: CARDINAL;
3END;
 
 VAR     myAddress: anAddress;
(backoff: INTEGER;
(fAdrValid: BOOLEAN;
(fAdrInUse: BOOLEAN;
(fCTSexpected: BOOLEAN;
(deferCount, collsnCount: CARDINAL;
(DataFramesOut, RTSFramesOut, CTSFramesOut: CARDINAL;
(deferHistory, collsnHistory: bitVector;
(deferTries, collsnTries, lclbackoff: INTEGER;
(RTSframe: aTxFrame;
(seed: LONGCARD;
(packetBuffers: CARDINAL;
(tailPacket: ptrPacket;  (* zeigt aufs lteste gltige Paket *)
(headPacket: ptrPacket;  (* zeigt hinter jngstes Paket *)
*(* wenn head = tail, stehen keine neuen Pakete an. *)
(
(FramesReceived, Interrupts: CARDINAL;
(test: BOOLEAN;
(
(IR_Vector [$360]: PROC;
 
 PROCEDURE Init;
 PROCEDURE NewPacketBuffer;
 PROCEDURE WriteFrame (REF packet: aPacket; no: CARDINAL);
 PROCEDURE WriteStatus (status: FrameStatus);
 PROCEDURE TransmitPacket;
 PROCEDURE TransmitFrame;
 PROCEDURE ReceiveFrame (VAR packet: ptrPacket): FrameStatus;
 PROCEDURE ReceivePacket (VAR dstParam: anAddress;
9VAR srcParam: anAddress;
9VAR typeParam: aLAPtype;
9VAR dataParam: aDataField;
9VAR dataLength: INTEGER);
 
 END ALAP.
 
(* $FFEF7C83$FFEF7C83$FFEF7C83$FFEF7C83$FFEF7C83$FFEF7C83$FFEF7C83$FFEF7C83$FFEF7C83$FFEF7C83$FFEF7C83$FFEF7C83$FFEF7C83$FFEF7C83$FFEF7C83$00000A95$FFEF7C83$FFEF7C83$FFEF7C83$FFEF7C83$FFEF7C83$FFEF7C83$FFEF7C83$FFEF7C83$FFEF7C83$FFEF7C83$FFEF7C83$FFEF7C83$FFEF7C83$FFEF7C83$FFEF7C83$FFEF7C83$FFEF7C83$FFEF7C83$FFEF7C83$FFEF7C83$FFEF7C83$FFEF7C83$FFEF7C83$FFEF7C83$FFEF7C83$FFEF7C83$000000D5T.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$00000629$00000644$000005CA$0000009F$FFF006F0$000000D5$FFEF7C83$FFEF7C83$0000006E$0000002F$000008EE$00000652$0000063C$00000622$000005F9$00000614*)
