 MODULE LANMonitor; (*$H+,Z+,R-*)
 
 (*
 NOTES
 -----
 - Testen auch ohne Interrupts - nur Polling!
 - Die CRC-Prfung scheint nicht zu klappen. Zumindest wird kein Fehler angezeigt,
"wenn beim empf. Dataframe das 1.Byte fehlt.
"-> Evtl. wird overrun gelmeldet und nicht erkannt?
 - Wenn 'excessCollsns' gemeldet wird, kann das auch heien, da
"der Partner berhaupt nicht geantwortet hat (also kein CTS auf's RTS
"gesandt hat).
 - oft passiert es, da das CTS zu spt kommt. Dann wird in 'GetFrame'
"'fAdrInUse' gesetzt, weil man annimmt, da jemand anderes auf ein RTS
"geantwortet hat (denn 'fCTSexpected ist schon FALSE).
"Das ist eigentlich OK, nur da das *erwartete* CTS offenbar dann zu spt kam.
 - seltsamerweise klappt beim TransmitPacket immer der erste RTS nicht.
"Es kommt dann kein CTS? Bei weiteren RTS klappt's dafr immer.
 *)
 
 (*
 IMPORT TOSDebug;
 *)
 
 IMPORT TOSIO; (*$E MOS *)
 
 IMPORT SYSTEM;
 FROM SYSTEM IMPORT ASSEMBLER, ADR, BYTE;
 
 IMPORT ALAP;
 
 IMPORT MOSGlobals, PrgCtrl;
 
 FROM InOut IMPORT WriteLn, Write, WriteCard, ReadCard, ReadLCard, Read,
0GotoXY, WritePg, WriteString, WriteHex, WriteLHex,
0KeyPressed, Done, WriteNum, WriteLNum;
 
 FROM GEMDOS IMPORT Super;
 IMPORT VT52; FROM VT52 IMPORT Codes;
 
 
 CONST NMI_Mask = $0700; (* !!! $0700 *)
 
 
 (*****************************************************************************)
 
 
 MODULE SCC;
 (*$L-*)
 
 FROM SYSTEM IMPORT WORD, ADDRESS, ASSEMBLER;
 
 IMPORT Super;
 FROM PrgCtrl IMPORT TermCarrier, CatchProcessTerm;
 FROM MOSGlobals IMPORT MemArea;
 
 EXPORT QUALIFIED Reg, SetReg, CTLA;
 
 CONST CTLA = $FFFF8C81;
 
 PROCEDURE Reg (n: CARDINAL): CARDINAL;
"BEGIN
$ASSEMBLER
(MOVE    SR,-(A7)
(MOVE    #$2500,SR
(MOVEA.W #CTLA,A1
(MOVE.W  -(A3),D0
(BEQ     read0
(MOVE.B  D0,(A1)          ; SCC A control
&read0:
(MOVE.B  (A1),D0
(MOVE    (A7)+,SR
$END;
"END Reg;
 
 PROCEDURE SetReg (no, value: CARDINAL);
"BEGIN
$ASSEMBLER
(MOVE    SR,-(A7)
(MOVE    #$2500,SR
(MOVEA.W #CTLA,A1
(MOVE.W  -(A3),D1        ; value
(MOVE.W  -(A3),D0        ; no
(BEQ     write0
(MOVE.B  D0,(A1)         ; SCC A control
&write0:
(MOVE.B  D1,(A1)
(MOVE    (A7)+,SR
$END;
"END SetReg;
 
 (*$L=*)
 
 (****** Vorsicht: ab hier $L+ ******)
 
 PROCEDURE term;
"VAR ssp: LONGCARD;
"BEGIN
$ssp:= Super (0);
$SetReg (9, $C0);
$ssp:= Super (ssp)
"END term;
 
 VAR carrier: TermCarrier;
 
 BEGIN
"CatchProcessTerm (carrier, term, MemArea{NIL,0});
 END (* MODULE *) SCC;
 
 
 TYPE BS = SET OF [0..7];
%RegSet = SET OF [0..15];
 
 CONST ReadRegs  = RegSet {0,1,2,3,8,10,12,13,15};
&WriteRegs = RegSet {0..15};
&
&RegsToDisplay = RegSet {0,1,2,3,8,10,12,13,15};
&
 
 PROCEDURE WriteReg (n: CARDINAL);
"VAR reg: CARDINAL;
"BEGIN
$reg:= SCC.Reg (n);
$WriteNum (reg, 16, 2, '0');
$WriteString ('  ');
$WriteNum (reg, 2, 8, '0');
"END WriteReg;
 
 
 VAR ch: CHAR;
$rxIdx, n, c: CARDINAL;
$lc: LONGCARD;
$i: INTEGER;
$ssp, li: LONGINT;
$redraw, quit, ok, b: BOOLEAN;
$by: BS;
$myaddr, outaddr: CARDINAL;
$sentDatas,sendTrials,rcvdDatas: LONGCARD;
$
$txFrame: ALAP.aTxFrame;
$packet: ALAP.ptrPacket;
$dstParam, srcParam: ALAP.anAddress;
$typeParam: ALAP.aLAPtype;
$dataParam: ALAP.aDataField;
$txStatus: ALAP.TransmitStatus;
$frameStatus: ALAP.FrameStatus;
$dataLength: INTEGER;
 
 BEGIN
"WritePg;
"ssp:= Super (0);
"
"(*
"WriteLn;
"WriteString ('Start...');
"FOR c:= 1 TO 5 DO
$FOR n:= 1 TO 5*1000 DO
&ASSEMBLER
(MOVEA.W #$FA00,A2
(MOVEQ   #50,D0
(MOVE.B  #$DF,$0B(A2)    ; IPRA: Clear Timer-A Pending Bit
(MOVE.B  D0,$1F(A2)      ; TADR: Set Timer Count
(MOVE.B  #2,$19(A2)      ; TACR: Timer Start (Teiler: 1/10)
$l0: BTST    #5,$0B(A2)      ; time over?
(BEQ     l0
(MOVE.B  #$00,$19(A2)    ; TACR: Timer Stop
&END;
$END;
"END;
"WriteString ('Stop!');
"WriteLn;
"*)
"
"WriteLn;
"WriteString ('Init...');
"WriteLn;
"
"ASSEMBLER
(MOVEQ   #0,D0
(JSR     ALAP.Init;
"END;
"
"ALAP.NewPacketBuffer;
"ALAP.NewPacketBuffer;
"ALAP.NewPacketBuffer;
"ALAP.NewPacketBuffer;
"
"WriteString ('OK');
"WriteLn;
"
"rxIdx:= 0;
"redraw:= TRUE;
"quit:= FALSE;
"REPEAT
$IF redraw THEN
&GotoXY (4,0);
&WriteString (' interrupts');
&GotoXY (4,1);
&WriteString (' frames received');
&GotoXY (0,2);
&FOR n:= 0 TO 15 DO
(IF n IN ReadRegs THEN
*WriteString ('Reg '); WriteNum (n, 16, 1, '0'); WriteString (': '); WriteLn;
(END
&END;
&WriteString (VT52.Seq[clearEOS]);
&
&c:= 2;
&FOR n:= 0 TO 15 DO
(IF n IN ReadRegs THEN
*IF n IN RegsToDisplay THEN GotoXY (7,c); WriteReg (n) END;
*INC (c);
(END;
&END;
&
&GotoXY (0, 11);
&WriteString ('myAddress: '); WriteHex (LONG (ALAP.myAddress), 3);
&WriteString (', dest-Addr: '); WriteHex (outaddr, 3);
&GotoXY (0, 12);
&WriteString ('collsns:   , defers:');
&GotoXY (0, 13);
&WriteString ('RTS:   , CTS:   , Data:');
&redraw:= FALSE
$END;
$GotoXY (0,0);
$WriteCard (ALAP.Interrupts, 4);
$GotoXY (0,1);
$WriteCard (ALAP.FramesReceived, 4);
$GotoXY (8,12);
$WriteCard (ALAP.collsnCount,3);
$GotoXY (20,12);
$WriteCard (ALAP.deferCount,3);
$GotoXY (4,13);
$WriteCard (ALAP.RTSFramesOut,3);
$GotoXY (13,13);
$WriteCard (ALAP.CTSFramesOut,3);
$GotoXY (23,13);
$WriteCard (ALAP.DataFramesOut,3);
$
$ASSEMBLER MOVE SR,-(A7) ORI.W #$0700,SR END;
$IF ALAP.headPacket # ALAP.tailPacket THEN
&frameStatus:= ALAP.ReceiveFrame (packet);
&GotoXY (40, rxIdx);
&WriteCard (rxIdx, 2);
&INC (rxIdx);
&WriteString (': ');
&ALAP.WriteFrame (packet^, 5);
&WriteCard (packet^.no, 1); Write (' ');
&ALAP.WriteStatus (packet^.status);
$END;
$ASSEMBLER MOVE.W (A7)+,SR END;
$
$IF KeyPressed() THEN
&GotoXY (0,14);
&WriteString (VT52.Seq[clearEOS]);
&WriteLn;
&Read (ch); ch:= CAP (ch);
&IF ch = 'Q' THEN
(quit:= TRUE;
&ELSIF ch = 'T' THEN
(WriteLn;
(WriteString ('Transmitting...');
(WriteLn;
(
((*txStatus:= ALAP.TransmitPacket (outaddr, BYTE($10), dataParam, 0);*)
(WITH txFrame DO
*ctrl.srcAddr:= ALAP.myAddress;
*ctrl.dstAddr:= SHORT (outaddr);
*ctrl.lapType:= BYTE ($10);
*dataCnt1:= 2;
*dataPtr1:= ADR (dataParam);
*dataCnt2:= 0;
*dataParam[1]:= BYTE ($12);
*dataParam[2]:= BYTE ($34);
(END;
(ASSEMBLER
*LEA   txFrame,A0
*JSR   ALAP.TransmitPacket
*MOVE  D0,txStatus
(END;
(
(ALAP.fAdrInUse:= FALSE;
(WriteString ('Status: ');
(CASE txStatus OF
(| ALAP.transmitOK: WriteString ('transmitOK')
(| ALAP.excessDefers: WriteString ('excessDefers')
(| ALAP.excessCollsns: WriteString ('excessCollsns')
(| ALAP.dupAddress: WriteString ('dupAddress')
(END;
(WriteLn;
&ELSIF ch = 'R' THEN
(WriteLn;
(WriteString ('Receiving...');
(WriteLn;
(ALAP.ReceivePacket (dstParam, srcParam, typeParam, dataParam, dataLength);
(IF KeyPressed () THEN
*WriteString ('Aborted');
*Read (ch)
(ELSE
*WriteString ('OK');
(END
&ELSIF ch = 'G' THEN
(WriteLn;
(WriteString ('Getting Addresses on Bus...');
(WriteLn;
(FOR n:= $01 TO $7F DO
*
*(*txStatus:= ALAP.TransmitPacket (SHORT(n), BYTE($81), dataParam, 0);*)
*WITH txFrame DO
,ctrl.srcAddr:= ALAP.myAddress;
,ctrl.dstAddr:= SHORT (n);
,ctrl.lapType:= ALAP.lapENQ;
,dataCnt1:= 0;
,dataCnt2:= 0;
*END;
*ASSEMBLER
,LEA   txFrame,A0
,JSR   ALAP.TransmitPacket
,MOVE  D0,txStatus
*END;
*
*IF txStatus = ALAP.dupAddress THEN
,Write ('>'); WriteHex (n, 3); Write ('<'); WriteLn;
*END;
*ALAP.fAdrInUse:= FALSE;
(END;
(WriteLn;
(WriteString ('OK.');
(WriteLn;
&ELSIF ch = ' ' THEN
(WritePg;
(rxIdx:= 0;
(redraw:= TRUE
&ELSIF ch = 'I' THEN
(WriteString ('Address? ');
(ReadCard (myaddr);
(IF Done THEN
*ASSEMBLER
,MOVE  myaddr,D0
,JSR   ALAP.Init
*END
(END
&ELSIF ch = 'A' THEN
(WriteString ('Dest-Address? ');
(ReadCard (outaddr);
&ELSIF ch = '0' THEN
((*
*Test-Modus.
*sieht NUR mit Polling nach, ob Daten angekommen sind.
(*)
(rcvdDatas:= 0;
(ASSEMBLER MOVE SR,-(A7) ORI.W #$0500,SR END;
(LOOP
*frameStatus:= ALAP.ReceiveFrame (packet);
*IF frameStatus = ALAP.lapDATAframe THEN
,(*
.WriteHex (LONG(packet^.frame.srcAddr),3);
,*)
,IF packet^.frame.lapType = BYTE ($11) THEN EXIT END;
,INC (rcvdDatas);
*END;
(END;
(ASSEMBLER MOVE.W (A7)+,SR END;
(WriteLn;
(WriteCard (rcvdDatas,0); WriteString (' frames received');
(Read (ch);
&ELSIF ch = '1' THEN
((*
*Test-Modus.
*sieht mit Polling nach, ob Daten angekommen sind.
(*)
(rcvdDatas:= 0;
(LOOP
*frameStatus:= ALAP.ReceiveFrame (packet);
*IF frameStatus = ALAP.lapDATAframe THEN
,IF packet^.frame.lapType = BYTE ($11) THEN EXIT END;
,INC (rcvdDatas);
,WriteHex (LONG(packet^.frame.srcAddr),3);
*END;
*IF KeyPressed() THEN EXIT END;
(END;
(WriteLn;
(WriteCard (rcvdDatas,0); WriteString (' frames received');
(Read (ch);
&ELSIF ch = '2' THEN
((*
*Test-Modus.
*sieht NUR im Interrupt nach, ob Daten angekommen sind.
(*)
(rcvdDatas:= 0;
(LOOP
*ASSEMBLER MOVE SR,-(A7) ORI.W #$0500,SR END;
*WHILE ALAP.headPacket # ALAP.tailPacket DO
,frameStatus:= ALAP.ReceiveFrame (packet);
,IF frameStatus = ALAP.lapDATAframe THEN
.IF packet^.frame.lapType = BYTE ($11) THEN
0ASSEMBLER MOVE.W (A7)+,SR END;
0EXIT
.END;
.INC (rcvdDatas);
.WriteHex (LONG(packet^.frame.srcAddr),3);
,END;
*END;
*ASSEMBLER MOVE.W (A7)+,SR END;
*IF KeyPressed() THEN EXIT END;
(END;
(WriteLn;
(WriteCard (rcvdDatas,0); WriteString (' frames received');
(Read (ch);
&ELSIF ch = '3' THEN
((*
*Test-Modus.
*Jede Station sendet ununterbrochen;
*sieht jedesmal nach, ob Daten angekommen sind.
(*)
(rcvdDatas:= 0;
(sentDatas:= 0;
(sendTrials:= 0;
(WITH txFrame DO
*ctrl.srcAddr:= ALAP.myAddress;
*ctrl.dstAddr:= SHORT (outaddr);
*ctrl.lapType:= BYTE ($10);
*dataCnt1:= 1024;
*dataPtr1:= ADR (dataParam);
*dataCnt2:= 0;
*dataParam[1]:= BYTE ($12);
*dataParam[2]:= BYTE ($34);
*dataParam[3]:= BYTE ($56);
(END;
(LOOP
*ASSEMBLER LEA txFrame,A0 JSR ALAP.TransmitPacket MOVE D0,txStatus END;
*INC (sendTrials);
*IF ALAP.fAdrInUse THEN Write ('#'); ALAP.fAdrInUse:= FALSE; END;
*CASE txStatus OF
*| ALAP.transmitOK: Write ('.'); INC (sentDatas)
*| ALAP.excessDefers: Write ('+')
*| ALAP.excessCollsns: Write ('-')
*| ALAP.dupAddress:
*END;
*ASSEMBLER MOVE SR,-(A7) ORI.W #$0500,SR END;
*WHILE ALAP.headPacket # ALAP.tailPacket DO
,frameStatus:= ALAP.ReceiveFrame (packet);
,IF frameStatus = ALAP.lapDATAframe THEN
.INC (rcvdDatas);
.WriteHex (LONG(packet^.frame.srcAddr),3);
.IF packet^.frame.lapType = BYTE ($11) THEN EXIT END;
,END;
*END;
*ASSEMBLER MOVE.W (A7)+,SR END;
*IF KeyPressed() THEN EXIT END;
(END;
(WriteLn;
(WriteCard (sendTrials,0); WriteString (' frames tried to sent, ');
(WriteCard (sentDatas,0); WriteString (' frames sent, ');
(WriteCard (rcvdDatas,0); WriteString (' frames received');
(Read (ch);
&ELSIF ch = '4' THEN
((*
*Send Abort to all (Broadcast)
(*)
(WITH txFrame DO
*ctrl.srcAddr:= ALAP.myAddress;
*ctrl.dstAddr:= BYTE ($FF);
*ctrl.lapType:= BYTE ($11);
*dataCnt1:= 0;
*dataCnt2:= 0;
(END;
(ASSEMBLER LEA txFrame,A0 JSR ALAP.TransmitPacket MOVE D0,txStatus END;
&(*
&ELSIF (ch >= '0') & (ch <= '9') OR (ch >= 'A') & (ch <= 'F') THEN
(Write (10C); (* BS *)
(n:= ORD (ch) - ORD ('0'); IF n > 9 THEN DEC (n, 7) END;
(IF n IN WriteRegs THEN
*WriteString ('Write Reg '); WriteNum (n, 16, 1, '0');
*WriteString ('? ');
*ReadCard (c);
*IF Done & (c <= 255) THEN
,SCC.SetReg (n, c);
*ELSE
,WriteString ('No write!'); WriteLn
*END
(END
&*)
&END;
$END;
"UNTIL quit;
"ssp:= Super (ssp)
 END LANMonitor.
  
(* $FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$00000FA1$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$000023E8T.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$00002159$000023A9$000023E8$000023A9$000020DF$00001815$00001C1C$00001C09$00002600$00002ACE$FFF006F0$00000417$000003A2$00001F4E$00001FCE$00002198*)
