 IMPLEMENTATION MODULE FileNames;
 (*$Y+, L-*)
 
 (*
!03.12.90  Fehler bei SplitName behoben, so da nun kein Fehler mehr mit
+68020 passieren drfte. (D0 war bei CopyA0OnStack-Aufruf um
+eins zu hoch, was ggf. ein Byte zuviel kopierte und damit den
+Stack berschrieb).
!31.01.91  ValidatePath verwendet "fileUpper" statt Strings.Upper
!29.03.93  StrToDrv erlaubt nun Drives v. A-Z (bisher A-P)
 *)
 
 FROM SYSTEM IMPORT ASSEMBLER, ADDRESS, ADR, TSIZE, BYTE, WORD, LONGWORD;
 IMPORT Strings;
 FROM MOSGlobals IMPORT FileStr, PathStr, DriveStr, NameStr, SfxStr, PfxStr,
(OutOfStack, StringOverflow, fNotDeleted, fPathNotFound, fFileNotFound,
(Drive, DriveSet;
 
 CONST drvZ = 26;
 
 VAR strok: BOOLEAN;
 
 
 PROCEDURE fileUpper (VAR s: ARRAY OF CHAR);
"(* "Upper" fr Dateinamen: bercksichtigt nur die unteren 128 Zeichen *)
"VAR n: CARDINAL;
"BEGIN
$(*
$FOR n:= 0 TO HIGH (s) DO
&IF s[n]='' THEN RETURN END;
&IF s[n]<CHR(128) THEN s[n]:=CAP(s[n]) END
$END
$*)
$ASSEMBLER
(MOVE.W  -(A3),D1
(MOVE.L  -(A3),A1
(CLR.W   D0
&luup:
(MOVE.B  (A1)+,D0
(BEQ     ende
(BMI     next
(JSR     @CAP    ;/A2
(MOVE.B  D0,-1(A1)
&next:
(DBRA    D1,luup
&ende:
$END
"END fileUpper;
 
 
 PROCEDURE copyA0OnStack;
"(*
#* Kopiert String in A0/D0.W auf Stack und korrigiert A0
#*)
"BEGIN
$ASSEMBLER
(MOVE.L  (A7)+,(A3)+     ; Rcksprung-Adr retten
(MOVE.L  A1,(A3)+        ; A1 retten
(MOVE.W  D0,(A3)+        ; D0 retten
(ADDQ    #2,D0           ; wichtig: es mu mind. -2- sein!
(BCLR    #0,D0           ; SYNC D0
(SUBA.W  D0,A7
(CMPA.L  A3,A7
(BCC     N
(TRAP    #6
(DC.W    OutOfStack
&N MOVE.L  A7,A1
(MOVE.W  -2(A3),D0
&L MOVE.B  (A0)+,(A1)+
(DBEQ    D0,L
(MOVE.L  A7,A0
(MOVE.W  -(A3),D0
(MOVE.L  -(A3),A1
(MOVE.L  -(A3),-(A7)     ; und Rcksprung
$END
"END copyA0OnStack;
 
 PROCEDURE ConcatName (REF prefix, suffix: ARRAY OF CHAR; VAR name: ARRAY OF CHAR);
"(*$L+*)
"VAR s1, s2: SfxStr; n1: NameStr; app: BOOLEAN;
"BEGIN
$(* aufpassen, da 'prefix'/'suffix' mit 'name' identisch sein knnen! *)
$app:= suffix[0] # 0C;
$IF app THEN
&Strings.Copy (suffix, Strings.Pos ('.', suffix, 0) + 1, 3, s1, strok);
$END;
$SplitPath (prefix, name, n1);
$SplitName (n1, n1, s2);
$Strings.Append (n1, name, strok);
$IF app THEN
&Strings.Append ('.', name, strok);
&Strings.Append (s1, name, strok);
$END;
"END ConcatName;
"(*$L=*)
 
 PROCEDURE ConcatPath (REF path, name: ARRAY OF CHAR; VAR fullname: ARRAY OF CHAR);
"(*$L+*)
"VAR p1: PathStr; n2, n1: NameStr;
"BEGIN
$(* aufpassen, da 'path'/'name' mit 'fullName' identisch sein knnen! *)
$SplitPath (name, p1, n1);
$SplitPath (path, fullname, n2);
$Strings.Append (n1, fullname, strok);
"END ConcatPath;
"(*$L=*)
 
 PROCEDURE NameConc ( REF prefix, suffix: ARRAY OF CHAR ): FileStr;
"(*$L+*)
"VAR n1: FileStr;
"BEGIN
$ConcatName (prefix, suffix, n1);
$RETURN n1
"END NameConc;
"(*$L=*)
 
 PROCEDURE PathConc ( REF path, name: ARRAY OF CHAR ): FileStr;
"(*$L+*)
"VAR p1: FileStr;
"BEGIN
$ConcatPath (path, name, p1);
$RETURN p1
"END PathConc;
"(*$L=*)
 
 PROCEDURE SplitName ( REF source: ARRAY OF CHAR; VAR prfx, sfx: ARRAY OF CHAR );
"BEGIN
$ASSEMBLER
(LINK    A5,#0
(
(MOVE    -(A3),D2
(MOVE.L  -(A3),A2        ; sfx
(MOVE    -(A3),D1
(MOVE.L  -(A3),A1        ; prfx
(MOVE    -(A3),D0
(MOVE.L  -(A3),A0        ; source
(
(CMPA.L  A2,A0
(BNE     a2NotEqu
(JSR     copyA0OnStack
(BRA     a1NotEqu
&a2NotEqu
(CMPA.L  A1,A0
(BNE     a1NotEqu
(JSR     copyA0OnStack
&a1NotEqu
(
(ADDQ    #1,D0
(MOVE    D3,-(A7)
(
(; Fehler melden, wenn 'prfx' zu klein
(CMPI    #7,D1
(BEQ     OK1
(BHI     OK2
(TRAP    #6
(DC.W    StringOverflow-$4000        ; callerCaused
(ADDQ    #1,D1
(BRA     OK3
&OK2:
(CLR.B   8(A1)
&OK1:
(MOVEQ   #8,D1
&OK3:
(
(; Fehler melden, wenn 'sfx' zu klein
(CMPI    #2,D2
(BEQ     OK4
(BHI     OK5
(TRAP    #6
(DC.W    StringOverflow
(ADDQ    #1,D2
(BRA     OK6
&OK5:
(CLR.B   3(A2)
&OK4:
(MOVEQ   #3,D2
&OK6:
(
&L1:
(SUBQ    #1,D0
(BCS     EMPTY
(MOVE.B  (A0)+,D3
(BEQ     EMPTY
(CMPI.B  #'.',D3
(BEQ     POINT
(SUBQ    #1,D1
(BMI     L1
(MOVE.B  D3,(A1)+
(BRA     L1
(
&POINT:
(SUBQ    #1,D0
(BCS     EMPTY
(MOVE.B  (A0)+,D3
(BEQ     EMPTY
(SUBQ    #1,D2
(BCS     EMPTY
(MOVE.B  D3,(A2)+
(BRA     POINT
(
&EMPTY:
(TST     D1
(BLE     EM1
(CLR.B   (A1)
&EM1:
(TST     D2
(BLE     EM2
(CLR.B   (A2)
&EM2:
(
(MOVE    (A7)+,D3
(UNLK    A5
$END
"END SplitName;
 
 PROCEDURE SplitPath ( REF source: ARRAY OF CHAR; VAR path, name: ARRAY OF CHAR );
"BEGIN
$ASSEMBLER
(LINK    A5,#0
(
(MOVE.L  -18(A3),A0      ; ADR (source)
(MOVE.L  A0,A1
(MOVE.W  -14(A3),D0      ; HIGH (source)
(MOVE.W  D0,D2
(
(MOVE.L  A1,D1
 len     TST.B   (A1)+
(DBEQ    D2,len
(BNE     cle
(SUBQ.L  #1,A1
 cle     SUBA.L  D1,A1
(MOVE.W  A1,D1
(BEQ     ende0
(
&lupo:
(MOVE.B  -1(A0,D1.W),D2
(CMPI.B  #':',D2
(BEQ     ende0
(CMPI.B  #'\',D2
(BEQ     ende0
(SUBQ    #1,D1
(BNE     lupo
&ende0:
(
(MOVE.L  -12(A3),A1      ; ADR (path)
(MOVE.L  -06(A3),A2      ; ADR (name)
(
(CMPA.L  A2,A0
(BNE     a2NotEqu
(JSR     copyA0OnStack
(BRA     a1NotEqu
&a2NotEqu
(CMPA.L  A1,A0
(BNE     a1NotEqu
(JSR     copyA0OnStack
&a1NotEqu
(
(CLR.B   (A1)
(CLR.B   (A2)
(
(MOVEM.L D3-D7,-(A7)
(
(MOVE.W  -08(A3),D5      ; HIGH (path)
(MOVE.W  -(A3),D6        ; HIGH (name)
(SUBA.W  #16,A3
(
(MOVE    #1,-(A7)        ; Flag: Bisher kein berlauf
(
(MOVEQ   #0,D2           ; source-counter
 l       CMP     D1,D2           ; pos erreicht ?
(BGE     scnd
(CMP     D0,D2           ; source geleert ?
(BHI     err             ; ja.
(CMP     D5,D2
(BHI     full
(MOVE.B  (A0)+,(A1)+
 c       BEQ     err2
(ADDQ    #1,D2
(BRA     l
(
 full    CLR     (A7)
(TST.B   (A0)+
(BRA     c
(
 full2   TST     D7
(BNE     full3
(TST     D3
(BNE     ende
 full3   TST.B   (A0)+
(BEQ     ende
(
 err     CMP     D5,D2
(BHI     err2
(CLR.B   (A1)+           ; Endemarke bei dest1 setzen
(
 err2    CLR     (A7)
(BRA     ende
(
 scnd    CMP     D5,D2
(BHI     scnd0
(CLR.B   (A1)+           ; Endemarke bei dest1 setzen
 scnd0   MOVEQ   #0,D4
(MOVEQ   #0,D3           ; Flag f. prefix/suffix
(MOVEQ   #8,D7
 l2      CMP     D6,D4           ; dest2 voll ?
(BHI     full2
(MOVE.B  (A0)+,D1
(BEQ     ende2
(CMPI.B  #'.',D1
(BNE     l22
(MOVEQ   #0,D7
(TST     D3
(BNE     l22
(MOVEQ   #1,D3
(MOVEQ   #4,D7
 l22     TST     D7
(BEQ     l21
(SUBQ    #1,D7
(MOVE.B  D1,(A2)+
(ADDQ    #1,D4
 l21     ADDQ    #1,D2
(CMP     D0,D2
(BLS     l2
 ende2   CMP     D6,D4
(BHI     ende
(CLR.B   (A2)+           ; Endemarke bei dest2 setzen
 ende
(TST.W   (A7)+
(BNE     ok
(TRAP    #6
(DC.W    StringOverflow
&ok:
(MOVEM.L (A7)+,D3-D7
(UNLK    A5
$END
"END SplitPath;
 
 PROCEDURE FileName   ( REF filename: ARRAY OF CHAR ): NameStr;
"(*$L+*)
"VAR path: PathStr; name: NameStr;
"BEGIN
$SplitPath (filename, path, name);
$RETURN name
"END FileName;
"(*$L=*)
 
 PROCEDURE FilePath   ( REF filename: ARRAY OF CHAR ): PathStr;
"(*$L+*)
"VAR path: PathStr; name: NameStr;
"BEGIN
$SplitPath (filename, path, name);
$RETURN path
"END FilePath;
"(*$L=*)
 
 PROCEDURE FilePrefix ( REF filename: ARRAY OF CHAR ): PfxStr;
"(*$L+*)
"VAR path: PathStr; name: NameStr; pfx: PfxStr; sfx: SfxStr;
"BEGIN
$SplitPath (filename, path, name);
$SplitName (name, pfx, sfx);
$RETURN pfx
"END FilePrefix;
"(*$L=*)
 
 PROCEDURE FileSuffix ( REF filename: ARRAY OF CHAR ): SfxStr;
"(*$L+*)
"VAR path: PathStr; name: NameStr; pfx: PfxStr; sfx: SfxStr;
"BEGIN
$SplitPath (filename, path, name);
$SplitName (name, pfx, sfx);
$RETURN sfx
"END FileSuffix;
"(*$L=*)
 
 PROCEDURE DriveToStr ( driveNo: Drive ): DriveStr;
"BEGIN
$ASSEMBLER
(MOVE    -(A3),D0
(BEQ     DFT
(ADDI.B  #$40,D0
(MOVE.B  D0,(A3)+
(MOVE.B  #':',(A3)+
(RTS
&DFT:
(CLR     (A3)+
$END
"END DriveToStr;
 
 PROCEDURE StrToDrive ( REF driveStr: ARRAY OF CHAR ): Drive;
"BEGIN
$ASSEMBLER
(CLR     D0
(TST.W   -(A3)
(MOVE.L  -(A3),A0
(BEQ     DFT
(TST.B   (A0)
(BEQ     DFT
(CMPI.B  #':',1(A0)
(BNE     DFT
(MOVE.B  (A0),D0
(CMPI.B  #'Z',D0
(BLS     nolower
(SUBI.B  #32,D0  ; change to lower case
&nolower
(SUBI.B  #'A',D0
(BCS     err
(ADDQ    #1,D0
(CMPI.W  #drvZ,D0
(BLS     DFT
&err
(CLR     D0
&DFT:
(MOVE    D0,(A3)+
$END
"END StrToDrive;
 
 PROCEDURE ValidatePath ( VAR path: ARRAY OF CHAR );
"BEGIN
$ASSEMBLER
(MOVE.L  -6(A3),-(A7)
(MOVE.W  -2(A3),-(A7)
(JSR     fileUpper
(MOVE.W  (A7)+,D0
(MOVE.L  (A7)+,A0
(TST.B   (A0)
(BEQ     e
&l TST.B   (A0)+
(DBEQ    D0,l
(BNE     a
(SUBQ.L  #1,A0
&a SUBQ.L  #1,A0
(CMPI.B  #':',(A0)
(BEQ     e
(CMPI.B  #'\',(A0)
(BEQ     e
(TST.W   D0
(BPL     o
(; string ist schon voll!
(TRAP    #6
(DC.W    StringOverflow
(BRA     e
&o BEQ     f
(CLR.B   2(A0)           ; wenn mit '\' nicht voll, NUL-Zeichen dran
&f MOVE.B  #'\',1(A0)
&e
$END
"END ValidatePath;
"
 PROCEDURE PathValidated ( REF path: ARRAY OF CHAR ): PathStr;
"(*$L+*)
"VAR newpath: PathStr; ok: BOOLEAN;
"BEGIN
$Strings.Assign (path, newpath, ok);
$ValidatePath (newpath);
$RETURN newpath
"END PathValidated;
"(*$L=*)
 
 
 PROCEDURE NameUnique ( REF fileName: ARRAY OF CHAR ): BOOLEAN;
"BEGIN
$ASSEMBLER
(MOVE.W  -(A3),D0
(MOVE.L  -(A3),A0
(MOVEQ   #'?',D1
(MOVEQ   #'*',D2
&L TST.B   (A0)
(BEQ     T
(CMP.B   (A0),D1
(BEQ     F
(CMP.B   (A0)+,D2
(BEQ     F
(DBRA    D0,L
&T MOVE    #1,(A3)+
(RTS
&F CLR     (A3)+
$END
"END NameUnique;
 
 
 PROCEDURE NameMatching ( REF fileName, wildcard: ARRAY OF CHAR ): BOOLEAN;
"BEGIN
$ASSEMBLER
((*
*MOVE.W  -(A3),D1
*MOVE.L  -(A3),A1        ; A1: wildcard
*MOVE.W  -(A3),D0
*MOVE.L  -(A3),A0        ; A0: filename
*TST.B   4(A0)
*BEQ     F               ; leerer filename ergibt FALSE
(*)
(LINK    A5,#0
 
(MOVE.L  -12(A3),(A3)+
(MOVE.W  -08(A3),(A3)+
(JSR     fileUpper
(MOVE.L  -06(A3),(A3)+
(MOVE.W  -02(A3),(A3)+
(JSR     fileUpper
 
(MOVE.L  -12(A3),A0
(TST.B   (A0)
(BEQ.W   F               ; leerer filename ergibt FALSE
 
(BRA     C0
 
%U0 ; Strings auf Stack lschen!
(MOVE.L  (A7)+,D0
(CLR.L   -(A7)
(CLR.L   -(A7)
(CLR.W   -(A7)
(MOVE.L  A7,(A3)+        ; VAR pfx
(MOVE    #8,(A3)+
(CLR.L   -(A7)
(MOVE.L  A7,(A3)+        ; VAR sfx
(MOVE    #3,(A3)+
(MOVE.L  D0,-(A7)
(JMP     SplitName
 
%C0 BSR     U0
(BSR     U0
(; Stack (alle Strings Null-terminiert):
(;  0(A7): sfx(filename)
(;  4(A7): pfx(filename)
(; 14(A7): sfx(wildcard)
(; 18(A7): pfx(wildcard)
 
(LEA     18(A7),A0
(LEA     4(A7),A1
%L1 MOVE.B  (A0)+,D0        ; Zeichen aus 'wildcard'
(BEQ     E1              ; filename mu zu ende sein
(CMPI.B  #'*',D0
(BEQ     T1              ; filename ist egal
(CMP.B   (A1)+,D0
(BEQ     L1
(CMPI.B  #'?',D0
(BEQ     L1              ; zeichen ist egal
(BRA     F
 
%E1 TST.B   (A1)
(BNE     F
 
%T1 LEA     14(A7),A0
(LEA     (A7),A1
%L2 MOVE.B  (A0)+,D0
(BEQ     S1              ; filename mu zu ende sein
(CMPI.B  #'*',D0
(BEQ     T               ; filename ist egal
(CMP.B   (A1)+,D0
(BEQ     L2
(CMPI.B  #'?',D0
(BEQ     L2              ; zeichen ist egal
(BRA     F
 
%S1 TST.B   (A1)
(BNE     F
 
&T MOVE    #1,(A3)+
(UNLK    A5
(RTS
 
&F CLR     (A3)+
(UNLK    A5
$END
"END NameMatching;
 
 END FileNames.
 
(* $FFECF05A$FFECF05A$FFECF05A$FFECF05A$FFECF05A$FFECF05A$FFECF05A$FFECF05A$FFECF05A$FFECF05A$FFECF05A$000020AC$FFECF05A$00002CAF$FFECF05A$00001E79$FFECF05A$FFECF05A$FFECF05A$FFECF05A$FFECF05A$FFECF05A$FFECF05A$FFECF05A$FFECF05A$FFECF05A$FFECF05A$FFECF05A$FFECF05A$FFECF05A$FFECF05A$FFECF05A$FFECF05A$FFECF05A$FFECF05A$FFECF05A$FFECF05A$FFECF05A$FFECF05A$FFECF05A$FFECF05A$FFECF05A$00000195T.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$000002BD$0000015C$00000164$00000195$0000016B$000002B2$FFEE7904$0000275D$FFE2D09E$00000404$FFF13E0C$00000410$00000404$00001E79$000020AC$00001F6F*)
