 IMPLEMENTATION MODULE Files; (* V#144 *)
 (*$Y+,R-*)
 
 (*
"22.01.88  TT  Get/SetDateTime korrigiert, Close/Remove: A3 richtig nach call
"15.05.88  TT  Bei Open/Create ist 'appendSeqTxt' auf Units erlaubt;
0In checkUnit hatt 'res' nun immer definierten Wert.
"03.07.88  TT  @CheckError meldet Fehler und liefert FALSE, wenn 'f' in
0ErrField zeigt.
"01.09.88  TT  Sys-Funktionen werden nicht autom. bei unterstem Level-Ende
0abgemeldet.
"25.10.88 TT   CatchRemoval-Aufruf, Files des untersten Levels werden auch
0geschlossen.
"04.08.89 TT   Kein 'del'-Aufruf mehr in Open; Datenpuffer f. 'readSeqTxt'
"05.09.88  TT  Get/SetDateTime fragen keinen Fehler mehr ab, weil TOS < 1.4
0undefinierte Werte liefert
"31.01.90  TT  unitOpen berschrieb die Ausgaberoutine, was bei Ausgabe
0auf eine Unit zu einem JMP ins Ungewisse fhrte (es lag
0daran, da der 'console'-Move mit .L statt .W gemacht wurde).
"16.07.90  TT  Bei Close() nach Open() wird das Datei-Datum aktualisiert.
"15.09.90  TT  Der Dateiname kann nun 139 Zeichen lang sein.
"31.01.91  TT  Open/Create geht nun auch mit Umlauten im Namen, da die
0Umlaute nicht mehr von Klein nach Gro gewandelt werden.
"02.08.91  TT  GetFileName kopiert _Rest_ vom Namen, falls er nicht pat.
"27.10.91  TT  SetDateTime lscht nun wirklich 'state' und nicht irgendein
0Word irgendwo im Speicher.
"10.12.93  TT  Create (.. appendSeqTxt, ..) nun auch unter MTOS mglich (ging
0nicht, weil Datei mit "readOnly" geffnet wurde und nur das
0alte TOS dies nicht bemngelt hatte).
 *)
 
 
 FROM SYSTEM IMPORT ASSEMBLER, ADDRESS, LONGWORD, ADR, WORD, TSIZE;
 
 FROM SysTypes IMPORT ScanDesc;
 
 FROM SysCtrl IMPORT GetScanAddr, ScanBack;
 
 FROM Clock IMPORT Time, Date, PackTime, PackDate, UnpackTime, UnpackDate,
(CurrentTime, CurrentDate;
 
 FROM Strings IMPORT Upper, Length, Copy, Assign, Pos, Delete, Insert, StrEqual;
 
 FROM Storage IMPORT SysAlloc, DEALLOCATE;
 
 FROM ResCtrl IMPORT RemovalCarrier, CatchRemoval;
 
 FROM FileBase IMPORT CloseFile, HandleError, Unit, UnitDriver,
(UDriver, UDataProc, UCloseProc, UFlushProc, URStrProc,
(UWStrProc, UGChrProc;
 
 FROM MOSConfig IMPORT FileErrMsg;
 
 FROM MOSGlobals IMPORT fFileNotOpen, fInternalErr1, fWasNotOpen, fOutOfMem,
(fFileExists, fNoReadAllowed, fNameTooLarge, fBadOp, fBadAccess,
(fFileNotClosed, MemArea;
 
 FROM PrgCtrl IMPORT TermCarrier, CatchProcessTerm, EnvlpCarrier, SetEnvelope;
 
 FROM StrConv IMPORT IntToStr;
 
 (*$I FileDesc.Icl *)
 
 CONST   BufferSize = 512;  (* Gre f. Daten-Puffer bei 'readSeqTxt' *)
 
 (*$O+*)
 TYPE File = POINTER TO FileDesc;
 (*$O-*)
 
%FileList = POINTER TO FileField;
%FileField = RECORD
3next: FileList;
3owner: File;
3marked: BOOLEAN;
1END;
 
 TYPE seekMode = ( fromBegin, fromPos, fromEnd );
 
 CONST MaxWarn = 4;
&MaxErrorNo = -142;
 
 VAR ErrorTable: ARRAY [MaxErrorNo..MaxWarn] OF INTEGER;
$ErrTblEnd, ErrTblBeg: ADDRESS;
$OpenFiles: FileList;
$ModLevel: INTEGER;
$strRes: BOOLEAN;
$unitSize: CARDINAL;
$fileSize: LONGCARD;
 
 
 PROCEDURE Init (VAR f: File);
"BEGIN
$f:= NIL
"END Init;
 
 
 PROCEDURE Abort (VAR f: File);
"BEGIN
$HALT
"END Abort;
 
 
 (*$L-*)
 PROCEDURE OpErr (n:LONGWORD):File;
"BEGIN
$ASSEMBLER
(MOVEQ   #MaxWarn,D0
(SUB.L   -(A3),D0
(LSL.L   #1,D0
(ADD.L   ErrTblBeg,D0
(MOVE.L  D0,(A3)+
$END
"END OpErr;
 
 
 (*$L-*)
 PROCEDURE seek (offset : LONGINT; handle: INTEGER; base: seekMode):LONGINT;
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),-(A7)
(MOVE.L  -(A3),-(A7)
(MOVE    #$42,-(A7)
(TRAP    #1
(ADDA.W  #10,A7
(MOVE.L  D0,(A3)+
$END
"END seek;
 (*$L+*)
 
 
 (*$L-*)
 PROCEDURE del (VAR name: ARRAY OF CHAR);
"BEGIN
$ASSEMBLER
(SUBQ.L  #2,A3
(MOVE.L  -(A3),-(A7)
(MOVE    #$41,-(A7)            ; DELETE
(TRAP    #1
(ADDQ.L  #6,A7
$END;
"END del;
 
 
 (*$L-*)
 PROCEDURE clos (h: WORD): LONGINT;
"BEGIN
$ASSEMBLER
(MOVE    -(A3),-(A7)
(MOVE    #$3E,-(A7)            ; CLOSE
(TRAP    #1
(ADDQ.L  #4,A7
(MOVE.L  D0,(A3)+
$END
"END clos;
 
 (*$L-*)
 PROCEDURE LowerWord (l:LONGWORD):WORD;
"BEGIN
$ASSEMBLER
&MOVE.L  -(A3),D0
&MOVE    D0,(A3)+
$END
"END LowerWord;
 
 
 (*$L-*)
 PROCEDURE Opened (f: File): BOOLEAN;
"BEGIN
$ASSEMBLER
(; A1, D2 nicht zerstren !
(MOVE.L  -(A3),D0
(BEQ     FA
(MOVE.L  OpenFiles,A0
%L0 MOVE.L  A0,D1
(BEQ     FA
(CMP.L   FileField.owner(A0),D0
(BEQ     TR
(MOVE.L  FileField.next(A0),A0
(BRA     L0
%TR MOVE    #1,(A3)+
(RTS
%FA CLR     (A3)+
$END
"END Opened;
 
 (*$L-*)
 PROCEDURE ListAppend (f:File; VAR res: LONGINT): BOOLEAN;
"BEGIN
$ASSEMBLER
(MOVE.L  -8(A3),(A3)+
(JSR     Opened
(TST     -(A3)
(BEQ     T0
%EE MOVE    #fFileNotClosed,D0
(MOVE.L  -(A3),A0
(SUBQ.L  #4,A0
(MOVE    D0,File.state(A0)
(CLR     (A3)+
(RTS
%T0 LEA     OpenFiles,A0
(MOVE.L  (A0),-(A7)
(MOVE.L  A0,(A3)+
(MOVE.L  fileSize,(A3)+
(JSR     SysAlloc
(MOVE.L  (A7)+,D0
(LEA     OpenFiles,A0
(MOVE.L  (A0),D1
(BNE     T1
(MOVE.L  D0,(A0)
(MOVE    #fOutOfMem,D0
(BRA     EE
%T1 MOVE.L  D1,A1
(MOVE.L  D0,FileField.next(A1)
(SUBQ.L  #4,A3
(MOVE.L  -(A3),FileField.owner(A1)
(MOVE    #1,(A3)+
$END
"END ListAppend;
 
 (*$L-*)
 PROCEDURE ListRemove (VAR f: File);
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),A0        ; ^FILE
(MOVE.L  (A0),D0
(LEA     OpenFiles,A1
%L0 MOVE.L  (A1),A2
(MOVE.L  A2,D2
(BEQ     E0
(CMP.L   FileField.owner(A2),D0
(BNE     T0
(MOVE.L  FileField.next(A2),(A1)
(MOVE.L  A2,-(A7)
(MOVE.L  A7,(A3)+
(CLR.L   (A3)+
(JSR     DEALLOCATE
(ADDQ.L  #4,A7
(RTS
%T0 LEA     FileField.next(A2),A1
(BRA     L0
%E0 CLR.L   (A0)
$END
"END ListRemove;
 
 
 (*$L-*)
 PROCEDURE free (VAR f:File; res:LONGINT);
"BEGIN
$ASSEMBLER
(JSR     OpErr
(MOVE.L  -(A3),-(A7)     ; error-code
(MOVE.L  -4(A3),-(A7)    ; ADR (f)
(JSR     ListRemove
(MOVE.L  (A7),A0         ; ADR (f)
(MOVE.L  (A0),A1
(MOVE.L  File.buffer(A1),D0
(BEQ     noBuf
(MOVE.L  D0,-(A7)
(MOVE.L  A7,(A3)+        ; f.buffer
(CLR.L   (A3)+
(JSR     DEALLOCATE
(ADDQ.L  #4,A7
&noBuf
(MOVE.L  (A7),(A3)+      ; ADR (f)
(CLR.L   (A3)+
(JSR     DEALLOCATE
(MOVE.L  (A7)+,A0
(MOVE.L  (A7)+,(A0)
$END
"END free;
 
 
 (*$L-*)
 PROCEDURE init0 (f: File);
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),A0
(MOVEQ   #0,D0
(MOVE.B  D0,File.lastch(A0)
(MOVE.B  D0,File.prevch(A0)
(MOVE.W  D0,File.getlast(A0)
(MOVE.W  D0,File.eof(A0)
(MOVE.W  D0,File.eol(A0)
(MOVE.W  D0,File.skipLF(A0)
(MOVE.W  D0,File.state(A0)
(MOVE.W  #1,File.chkeof(A0)
(MOVE.B  #26,File.eofchr(A0)
$END
"END init0;
 
 (*$L-*)
 PROCEDURE fileUpper (VAR s: ARRAY OF CHAR);
"(* "Upper" fr Dateinamen: bercksichtigt nur die unteren 128 Zeichen *)
"VAR n: CARDINAL;
"BEGIN
$(*
$FOR n:= 0 TO HIGH (s) DO
&IF s[n]='' THEN RETURN END;
&IF s[n]<CHR(128) THEN s[n]:=CAP(s[n]) END
$END
$*)
$ASSEMBLER
(MOVE.W  -(A3),D1
(MOVE.L  -(A3),A1
(CLR.W   D0
&luup:
(MOVE.B  (A1)+,D0
(BEQ     ende
(BMI     next
(JSR     @CAP    ;/A2
(MOVE.B  D0,-1(A1)
&next:
(DBRA    D1,luup
&ende:
$END
"END fileUpper;
 
 (*$L+*)
 PROCEDURE prepErr (VAR f:File; REF n: ARRAY OF CHAR; VAR myname: ARRAY OF CHAR;
3mode:Access; VAR unit0:Unit; VAR disk: BOOLEAN ): BOOLEAN;
"
"VAR res:LONGINT;
"
"PROCEDURE checkUnit;
$VAR s: ARRAY [0..39] OF CHAR;
(ok:BOOLEAN;
(unitIdx: Unit;
$BEGIN
&res:=0L;
&FOR unitIdx:= con TO ext7 DO
(WITH UnitDriver [unitIdx] DO
*Copy (myname,0,Length(name),s,ok);
*IF valid & StrEqual (s,name) THEN
,IF ORD (mode) < 3 THEN
.res := fBadOp
,ELSIF ((mode#readSeqTxt) & ~output) OR ((mode=readSeqTxt) & ~input) THEN
.res := fBadAccess
,END;
,disk:= FALSE;
,unit0:= unitIdx;
,RETURN
*END
(END
&END;
&disk:= TRUE
$END checkUnit;
"
"BEGIN
$Assign (n,myname,strRes);
$IF NOT strRes THEN
&f:= OpErr (LONG(fNameTooLarge));
&RETURN TRUE
$END;
$fileUpper (myname);
$SysAlloc (f, TSIZE (FileDesc));
$IF f=NIL THEN
&f := OpErr (LONG(fOutOfMem));
&RETURN TRUE
$END;
$f^.buffer:= NIL;
$IF ~ListAppend (f,res) THEN
&DEALLOCATE (f,0L);
&f := OpErr (res);
&RETURN TRUE
$END;
$checkUnit;
$IF res<0L THEN
&free (f,res);
&RETURN TRUE
$END;
$Assign (myname,f^.name,strRes);
$RETURN FALSE
"END prepErr;
 
 
 (*$L+*)
 PROCEDURE unitOpen (VAR f:File; unit0:Unit): BOOLEAN;
"VAR res:INTEGER;
"BEGIN
$ASSEMBLER
(MOVE    unit0(A6),D0
(MULU    unitSize,D0
(LEA     UnitDriver,A0
(ADDA.W  D0,A0
(MOVE.L  f(A6),A1
(MOVE.L  (A1),A1
(MOVE.L  UDriver.wrData(A0),File.uwrite(A1)
(MOVE.L  UDriver.wrStr(A0),File.uwrstr(A1)
(MOVE.L  UDriver.rdData(A0),File.uread(A1)
(MOVE.L  UDriver.rdChr(A0),File.urdchr(A1)
(MOVE.W  UDriver.console(A0),File.ucons(A1)
(MOVE.L  UDriver.close(A0),File.uclose(A1)
(MOVE.L  UDriver.flush(A0),File.uflush(A1)
(MOVE.L  UDriver.initHdl(A0),File.uhandle(A1)
$END;
$WITH f^ DO
&unit:= unit0;
&res:= UnitDriver[unit].open (uhandle,name); (* 'name' ist auch in Unit *)
$END;
$IF res<0 THEN
&free (f,LONG(res));
&RETURN TRUE
$ELSE
&RETURN FALSE
$END
"END unitOpen;
 
 
 (*$L+*)
 PROCEDURE open0 (VAR f         : File;
5REF mediumname: ARRAY OF CHAR;
5mode      : Access;
5level     : INTEGER);
"VAR h, n: CARDINAL;
&l, res: LONGINT;
&myname: ARRAY [0..139] OF CHAR;
&append, disk: BOOLEAN;
&unit0: Unit;
"BEGIN
$res:= 0;
$IF prepErr (f,mediumname,myname,mode,unit0,disk) THEN RETURN END;
$append:= FALSE;
$IF disk THEN
&ASSEMBLER
(MOVE    mode(A6),D0
(CMPI    #2,D0
(BLS     ok
(SUBQ    #3,D0
(CMPI    #2,D0           ; appendSeqTxt ?
(BNE     ok
(MOVEQ   #1,D0           ; writeOnly
$ok: MOVE    D0,-(A7)
(PEA     myname(A6)
(MOVE    #$3D,-(A7)              ; OPEN
(TRAP    #1
(ADDQ.L  #8,A7
(MOVE.L  D0,res(A6)
&END;
&IF res < 0L THEN
(free (f,res);
(RETURN
&ELSE
(IF mode=readSeqTxt THEN
*f^.bufsize:= BufferSize;
*f^.bufpos:= BufferSize;
*SysAlloc (f^.buffer, BufferSize);
*IF f^.buffer = NIL THEN
,res:= clos (h);
,free (f,fOutOfMem);
,RETURN
*END
(END;
(h:= SHORT (res);
(l:= seek (0L,h,fromEnd);
(IF mode=appendSeqTxt THEN
*append:= TRUE
(ELSE
*res:= seek (0L,h,fromBegin)
(END;
(IF (l<0L) OR (res<0L) THEN
*IF l>=0L THEN l:= res END;
*res:= clos (h);
*free (f,l);
*RETURN
(END
&END
$ELSE
&IF unitOpen (f,unit0) THEN RETURN END;
&l:= 0
$END;
$WITH f^ DO
&ondisk:= disk;
&IF ondisk THEN
(new:= FALSE;
(handle:= h;
(modified:= FALSE;
&END;
&accmode := mode;
&IF append THEN pos := l ELSE pos := 0 END;
&len := l;
&modlevel := level
$END;
$init0 (f)
"END open0;
 
 
 (*$L+*)
 PROCEDURE create0 (VAR f         : File;
7REF mediumname: ARRAY OF CHAR;
7mode      : Access;
7replMode  : ReplaceMode;
7level     : INTEGER);
"VAR h, n: CARDINAL;
&res: LONGINT;
&myname: ARRAY [0..139] OF CHAR;
&append, disk: BOOLEAN;
&unit0: Unit;
"BEGIN
$res := 0;
$IF (mode=readOnly) OR (mode=readSeqTxt) THEN
&f:= OpErr (LONG(fNoReadAllowed));
&RETURN
$END;
$IF prepErr (f,mediumname,myname,mode,unit0,disk) THEN RETURN END;
$append := FALSE;
$IF disk THEN
&ASSEMBLER
*MOVE    #writeOnly,-(A7)
*PEA     myname(A6)
*MOVE    #$3D,-(A7)            ; OPEN
*TRAP    #1
*ADDQ.L  #8,A7
*MOVE.L  D0,res(A6)
&END;
&IF res>=0L THEN (* Datei existiert *)
(IF replMode = noReplace THEN
*res := clos (LowerWord(res));
*free (f,LONG(fFileExists));
*RETURN
(ELSE
*IF mode#appendSeqTxt THEN
,res := clos (LowerWord(res));
,del (myname);
,res := -33
*ELSE
,append := TRUE
*END
(END
&END;
&IF (res=-33L) OR (res=-34L) THEN
(ASSEMBLER
*CLR     -(A7)
*PEA     myname(A6)
*MOVE    #$3C,-(A7)            ; CREATE
*TRAP    #1
*ADDQ.L  #8,A7
*MOVE.L  D0,res(A6)
(END
&END;
&IF res < 0L THEN
(free (f,res);
(RETURN
&END;
&h := SHORT (res)
$ELSE
&IF unitOpen (f,unit0) THEN RETURN END;
$END;
$WITH f^ DO
&ondisk:= disk;
&IF ondisk THEN
(new:= TRUE;
(handle:= h;
(modified:= FALSE;
&END;
&accmode := mode;
&IF append THEN
(res := seek (0,h,fromEnd);
(IF res < 0L THEN
*free (f,res);
*RETURN
(END;
(len := res;
(pos := res
&ELSE
(len := 0;
(pos := 0;
&END;
&modlevel := level
$END;
$init0 (f)
"END create0;
 
 
 (*$L-*)
 PROCEDURE Open (VAR f: File; REF n: ARRAY OF CHAR; m: Access);
"BEGIN
$ASSEMBLER
(MOVE.W  ModLevel,(A3)+
(JMP     open0
$END
"END Open;
 
 (*$L-*)
 PROCEDURE SysOpen (VAR f: File; REF n: ARRAY OF CHAR; m: Access);
"BEGIN
$ASSEMBLER
(MOVE    #-1,(A3)+
(JMP     open0
$END
"END SysOpen;
 
 (*$L-*)
 PROCEDURE Create (VAR f: File; REF n: ARRAY OF CHAR; m: Access; r: ReplaceMode);
"BEGIN
$ASSEMBLER
(MOVE.W  ModLevel,(A3)+
(JMP     create0
$END
"END Create;
 
 (*$L-*)
 PROCEDURE SysCreate (VAR f: File; REF n: ARRAY OF CHAR; m: Access; r: ReplaceMode);
"BEGIN
$ASSEMBLER
(MOVE    #-1,(A3)+
(JMP     create0
$END
"END SysCreate;
 
 
 (*$L-*)
 PROCEDURE clRem;
"BEGIN
$ASSEMBLER
(LINK    A5,#0
(MOVE    D0,-(A7)
(MOVE.L  -(A3),A0
(MOVE.L  A0,-(A7)
(MOVE.L  (A0),(A3)+
(JSR     Opened
(TST     -(A3)
(BEQ.W   OE
(MOVE.L  (A7),A0
(MOVE.L  (A0),(A3)+
(JSR     @CheckState
(TST     -(A3)
(BEQ.W   E0
(MOVE.L  (A7),(A3)+
(JSR     ListRemove
(MOVE.L  (A7),A0
(MOVE.L  (A0),A1
(MOVE.L  A1,D1
(BEQ.W   E0
(TST     File.ondisk(A1)
(BEQ     T0
(
(; Wenn Close() und Datei nicht neu angelegt, Datum ggf. neu setzen
(MOVE    4(A7),D0        ; Remove()?
(OR      File.new(A1),D0 ; oder Datei neu angelegt?
(BNE     T1
(
(TST.W   File.modified(A1) ; Datei beschrieben?
(BEQ     T1
(
(; Datum setzen
(MOVE.L  A1,(A3)+        ; f
(JSR     CurrentDate
(JSR     CurrentTime
(JSR     SetDateTime
(
%T1 ; File beim GEMDOS schlieen
(MOVE.L  (A7),A0
(MOVE.L  (A0),A1
(MOVE    File.handle(A1),(A3)+
(MOVE.L  A1,-(A7)
(JSR     clos            ; liefert state.L auf Heap
(MOVE.L  (A7)+,A1
(
(; Wenn Remove() und Datei neu angelegt, Datei lschen
(MOVE    4(A7),D0        ; Remove()?
(AND     File.new(A1),D0 ; und Datei neu angelegt?
(BEQ     T2
(
(; Datei lschen
(CLR.L   -4(A3)
(LEA     File.name(A1),A0
(MOVE.L  A0,(A3)+
(ADDQ.L  #2,A3
(JSR     del
(BRA     T2
(
%T0 MOVE.L  File.uhandle(A1),(A3)+
(MOVE.L  File.uclose(A1),A2
(JSR     (A2)
(MOVE.W  -(A3),D0
(EXT.L   D0
(MOVE.L  D0,(A3)+
(
%T2 MOVE.L  (A7),A0         ; ADR (f)
(MOVE.L  (A0),A1
(MOVE.L  File.buffer(A1),D0
(BEQ     noBuf
(MOVE.L  D0,-(A7)
(MOVE.L  A7,(A3)+        ; f.buffer
(CLR.L   (A3)+
(JSR     DEALLOCATE
(ADDQ.L  #4,A7
%noBuf
(MOVE.L  (A7),(A3)+
(CLR.L   (A3)+
(JSR     DEALLOCATE
(BRA     E1
%E0 MOVE.L  (A7)+,A0
(CLR.L   (A0)
(UNLK    A5
(RTS
%OE MOVE.L  #fWasNotOpen,(A3)+
%E1 JSR     OpErr
(MOVE.L  (A7)+,A0
(MOVE.L  -(A3),(A0)
(UNLK    A5
$END
"END clRem;
 
 
 (*$L-*)
 PROCEDURE Close (VAR f: File);
"BEGIN
$ASSEMBLER
(MOVEQ   #0,D0        ; REMOVE nicht mglich
(JMP     clRem
$END
"END Close;
 
 
 (*$L-*)
 PROCEDURE Remove (VAR f: File);
"BEGIN
$ASSEMBLER
(MOVEQ   #1,D0           ; REMOVE mglich
(JMP     clRem
$END
"END Remove;
 
 
 (*$L-*)
 PROCEDURE EOF (f: File): BOOLEAN;
"BEGIN
$ASSEMBLER
(; zerstrt nur D0/A0, in A0 zuletzt immer File !
(MOVE.L  -(A3),D0
(MOVE.L  D0,A0
(BEQ     TR
(TST     File.state(A0)
(BMI     TR
(CMPI    #3,File.accmode(A0)
(BCC     T0
(MOVE.L  File.pos(A0),D0
(CMP.L   File.len(A0),D0
(SCC     D0
(ANDI    #1,D0
(MOVE    D0,(A3)+
(RTS
%T0 MOVE    File.eof(A0),(A3)+
(RTS
%TR MOVE    #1,(A3)+
$END
"END EOF;
 
 
 (*$L-*)
 PROCEDURE State (f: File): INTEGER;
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),D0
(BEQ     ER
(MOVE.L  D0,A0
(MOVE    File.state(A0),(A3)+
(RTS
%ER MOVE    #fFileNotOpen,(A3)+
$END
"END State;
 
 
 (*$L+*)
 PROCEDURE getSt2 (ad:ADDRESS; n:INTEGER; VAR msg:ARRAY OF CHAR): BOOLEAN;
"VAR s: POINTER TO ARRAY [0..31] OF CHAR;
"BEGIN
$ASSEMBLER
(MOVE.L  ad(A6),A0
(MOVE.W  n(A6),D0
(
%l: CMP.W   (A0)+,D0
(BNE     c
(
(; gefunden
(MOVE.L  A0,s(A6)
(BRA     e
(
%c: TST.B   (A0)    ; Listenende ?
(BEQ     f       ; Ja, -> nicht gefunden
(
%m: ADDA.W  #32,A0
(BRA     l
(
%f: CLR.L   s(A6)
%e:
$END;
$IF s#NIL THEN
&Assign (s^,msg,strRes);
&RETURN TRUE
$ELSE
&RETURN FALSE
$END
"END getSt2;
 
 (*$L+*)
 PROCEDURE GetStateMsg (n: INTEGER; VAR msg: ARRAY OF CHAR);
"VAR p:INTEGER;
"BEGIN
$msg[0]:=0C;
$IF FileErrMsg=NIL THEN
&Assign ('Unknown error #@',msg,strRes)
$ELSE
&IF ~getSt2 (FileErrMsg,n,msg) THEN
(IF n<0 THEN
*IF getSt2 (FileErrMsg,-32768,msg) THEN END
(ELSE
*IF getSt2 (FileErrMsg,32767,msg) THEN END
(END
&END;
$END;
$p:=Pos ('@',msg,0);
$IF p>=0 THEN
&Delete (msg,p,1,strRes);
&Insert (IntToStr(n,0),p,msg,strRes)
$END
"END GetStateMsg;
 
 
 (*$L+*)
 PROCEDURE ResetState (VAR f: File);
"VAR r: LONGINT;
"BEGIN
$IF Opened (f) THEN
&WITH f^ DO
(state := 0;
(IF ondisk THEN
*r := seek (0L,handle,fromPos);
*IF r<0L THEN
,state := SHORT (r)
*ELSE
,pos := r;
,r := seek (0L,handle,fromEnd);
,IF r<0L THEN
.state := SHORT (r)
,ELSE
.len := r
,END
*END
(END
&END
$ELSE
&f := NIL
$END
"END ResetState;
 
 (*$L-*)
 PROCEDURE InErrField (f:ADDRESS):BOOLEAN;
"BEGIN
$ASSEMBLER
(; A0, A1, D1, D2 nicht zerstren !
(MOVE.L  -(A3),D0
(CMP.L   ErrTblBeg,D0
(BCS     FA
(CMP.L   ErrTblEnd,D0
(BCC     FA
(MOVE    #1,(A3)+
(RTS
%FA CLR     (A3)+
$END
"END InErrField;
 
 (*$L-*)
 PROCEDURE @CheckState (f: File): BOOLEAN;
"BEGIN
$ASSEMBLER
(; Am Ende immer File in A0 !  -- A1 nicht zerstren !
(MOVE.L  -(A3),D0
(BEQ     T6              ; -> file not open
(MOVE.L  D0,A0
(CMP.L   ErrTblBeg,D0
(BCS     T1
(CMP.L   ErrTblEnd,D0
(BCS     T5
%T1 ; 'f' ist nicht im ErrField
(TST     File.ondisk(A0)
(BEQ     T2
(MOVE.L  File.pos(A0),D0
(CMP.L   File.len(A0),D0
(BLS     T2
(MOVE    #fInternalErr1,D2
(BRA     T3
%T2 MOVE    File.state(A0),D2
(BMI     T3
(MOVE    #1,(A3)+
(RTS
%T5 ; 'f' ist im ErrField
(MOVE    (A0),D2
(BMI     T4
(BRA     T6
%T3 MOVE.L  A0,(A3)+
(MOVEM.L D1/A0,-(A7)
(JSR     Opened
(MOVEM.L (A7)+,D1/A0
(TST     -(A3)
(BNE     T4
(MOVE.L  A0,(A3)+
(JSR     InErrField
(TST     -(A3)
(BNE     T4
%T6 MOVE    #fFileNotOpen,D2
%T4 LINK    A5,#0
(MOVEM.L D1/A0/A1,-(A7)
(MOVE.L  A0,-(A7)
(SUBA.W  #TSIZE (ScanDesc),A7
(MOVE.L  A7,(A3)+
(MOVE    D2,-(A7)
(JSR     GetScanAddr
(LEA     2(A7),A0
(MOVE.L  A0,(A3)+
(JSR     ScanBack
(SUBQ.L  #2,A3
(LEA     14(A7),A0
(MOVE.L  A0,(A3)+        ; VAR File
(MOVE    (A7)+,(A3)+     ; err-no
(MOVE.L  (A7)+,(A3)+     ; ScanDesc
(MOVE.L  (A7)+,(A3)+     ; ScanDesc
(MOVE.L  (A7)+,(A3)+     ; ScanDesc
(MOVE.L  HandleError,A0
(JSR     (A0)
(ADDQ.L  #4,A7
(MOVE.L  4(A7),(A3)+
(JSR     Opened
(MOVEM.L (A7)+,D1/A0/A1
(UNLK    A5
$END
"END @CheckState;
 
 
 (*$L-*)
 PROCEDURE AccessMode (f: File): Access;
"BEGIN
$ASSEMBLER
(LINK    A5,#0
(JSR     @CheckState
(CLR     D0
(TST     -(A3)
(BEQ     E0
(MOVE    File.accmode(A0),D0
%E0 MOVE    D0,(A3)+
(UNLK    A5
$END
"END AccessMode;
 
 (*$L-*)
 PROCEDURE DiskAccess (f: File): BOOLEAN;
"BEGIN
$ASSEMBLER
(LINK    A5,#0
(JSR     @CheckState
(CLR     D0
(TST     -(A3)
(BEQ     E0
(MOVE    File.ondisk(A0),D0
%E0 MOVE    D0,(A3)+
(UNLK    A5
$END
"END DiskAccess;
 
 (*$L-*)
 PROCEDURE SetEOFMode (f: File; checkChar: BOOLEAN; eofChar: CHAR);
"BEGIN
$ASSEMBLER
(LINK    A5,#0
(MOVE.L  -8(A3),(A3)+
(JSR     @CheckState
(TST     -(A3)
(BEQ     E0
(SUBQ.L  #1,A3
(MOVE.B  -(A3),D0
(MOVE.W  -(A3),D1
(MOVE.L  -(A3),A0
(CMPI    #readSeqTxt,File.accmode(A0)
(BEQ     T0
(MOVE    #fBadOp,File.state(A0)
(MOVE.L  A0,(A3)+
(JSR     @CheckState
(SUBQ.L  #2,A3
(CLR.W   File.state(A0)
(UNLK    A5
(RTS
%T0 MOVE.B  D0,File.eofchr(A0)
(MOVE.W  D1,File.chkeof(A0)
(CLR     File.eof(A0)
(UNLK    A5
(RTS
%E0 SUBQ.L  #8,A3
(UNLK    A5
$END
"END SetEOFMode;
 
 (*$L-*)
 PROCEDURE GetEOFMode (f: File; VAR checkChar: BOOLEAN; VAR eofChar: CHAR);
"BEGIN
$ASSEMBLER
(LINK    A5,#0
(MOVE.L  -12(A3),(A3)+
(JSR     @CheckState
(TST     -(A3)
(BEQ     E0
(SUBQ.L  #1,A3
(MOVE.L  -(A3),A1
(MOVE.L  -(A3),A2
(MOVE.L  -(A3),A0
(CMPI    #readSeqTxt,File.accmode(A0)
(BEQ     T0
(MOVE    #fBadOp,File.state(A0)
(MOVE.L  A0,(A3)+
(JSR     @CheckState
(SUBQ.L  #2,A3
(CLR.W   File.state(A0)
(UNLK    A5
(RTS
%T0 MOVE.B  File.eofchr(A0),(A1)
(MOVE.W  File.chkeof(A0),(A2)
(UNLK    A5
(RTS
%E0 SUBA.W  #12,A3
(UNLK    A5
$END
"END GetEOFMode;
 
 
 (*$L-*)
 PROCEDURE Flush (f: File);
"BEGIN
$ASSEMBLER
(LINK    A5,#0
(JSR     @CheckState
(TST     -(A3)
(BEQ     E0
(TST     File.ondisk(A0)
(BNE     ok
(MOVE.L  File.uhandle(A0),(A3)+
(MOVE.L  File.uflush(A0),A1
(MOVE.L  A0,-(A7)
(JSR     (A1)
(MOVE.L  (A7)+,A0
(MOVE    -(A3),File.state(A0)
(UNLK    A5
(RTS
%ok CLR     File.state(A0)
(UNLK    A5
%E0
$END
"END Flush;
 
 
 (*$L-*)
 PROCEDURE SetDateTime ( f: File; d: Date; t: Time );
"BEGIN
$ASSEMBLER
(LINK    A5,#0
(JSR     PackTime
(SUBQ    #4,A7
(MOVE    -(A3),(A7)
(JSR     PackDate
(MOVE    -(A3),2(A7)
(JSR     @CheckState
(TST     -(A3)
(BEQ     ende
(TST.W   File.ondisk(A0)
(BEQ     ende
(CLR.W   File.modified(A0)       ; damit Datum nicht bei Close
(MOVE.L  A0,-(A7)                ;          nochmal gesetzt wird
(MOVE    #1,-(A7)
(MOVE    File.handle(A0),-(A7)
(PEA     8(A7)
(MOVE    #$57,-(A7)
(TRAP    #1
(ADDA.W  #10,A7
 
 (* TOS 1.0 & 1.2 liefern keinen Fehler
(MOVEQ   #0,D1
(TST.L   D0
(BEQ     C
(MOVE    D0,D1
%C: MOVE    D1,(A0)         ; state
 *)
(MOVE.L  (A7)+, A0       ; !MS
(CLR     (A0)            ; -> state immer auf Null setzen
%ende:
(UNLK    A5
$END
"END SetDateTime;
 
 (*$L-*)
 PROCEDURE GetDateTime ( f: File; VAR d: Date; VAR t: Time );
"BEGIN
$ASSEMBLER
(LINK    A5,#0
(MOVE.L  -12(A3),(A3)+
(JSR     @CheckState
(TST     -(A3)
(BEQ     error
(CLR.L   -(A7)
(CLR     -(A7)
(MOVE    File.handle(A0),-(A7)
(PEA     4(A7)
(MOVE    #$57,-(A7)
(TRAP    #1
(ADDA.W  #10,A7
 
 (* TOS 1.0 & 1.2 liefern keinen Fehler
(MOVEQ   #0,D1
(TST.L   D0
(BEQ     C
(MOVE    D0,D1
%C: MOVE.L  -12(A3),A0
(MOVE    D1,(A0)         ; state
 *)
(MOVE.L  -12(A3),A0
(CLR     (A0)            ; -> state immer auf Null setzen
 
(MOVE    (A7)+,(A3)+     ; Time
(JSR     UnpackTime
(MOVE.L  -(A3),D0
(MOVE.W  -(A3),D1
(MOVE.L  -(A3),A0
(MOVE.W  D1,(A0)+
(MOVE.L  D0,(A0)
(
(MOVE    (A7)+,(A3)+     ; Date
(JSR     UnpackDate
(MOVE.L  -(A3),D0
(MOVE.W  -(A3),D1
(MOVE.L  -(A3),A0
(MOVE.W  D1,(A0)+
(MOVE.L  D0,(A0)
(
(SUBQ.L  #4,A3
(UNLK    A5
(RTS
 
%err2:
(
%error:
(MOVE.L  -(A3),A0        ; time
(CLR.W   (A0)+
(CLR.L   (A0)
(MOVE.L  -(A3),A0        ; date
(MOVE.W  #31,Date.day(A0)
(MOVE.W  #12,Date.month(A0)
(MOVE.W  #2099,Date.year(A0)
(SUBQ.L  #4,A3           ; f
(UNLK    A5
$END
"END GetDateTime;
 
 
 (*$L+*)
 PROCEDURE GetFileName (f: File; VAR name: ARRAY OF CHAR);
"BEGIN
$IF Opened (f) THEN
&Assign (f^.name,name,strRes);
&IF ~strRes THEN
(Copy (f^.name,LENGTH(f^.name)-(HIGH(name)+1),HIGH(name)+1,name,strRes);
(IF HIGH (name) > 2 THEN
*name[0]:= '.';
*name[1]:= '.';
(END
&END
$ELSE
&ASSEMBLER
(MOVE.L  name(A6),A0
(CLR.B   (A0)
&END
$END
"END GetFileName;
 
 
 (*$L+*)
 PROCEDURE releaseLevel;
"VAR called: BOOLEAN;
&p2: FileList;
&f:File;
"BEGIN
$p2:= OpenFiles;
$WHILE p2 # NIL DO
&p2^.marked:= FALSE;
&p2:= p2^.next
$END;
$REPEAT
&p2:= OpenFiles;
&called:= FALSE;
&WHILE p2 # NIL DO
(IF ~p2^.marked & (p2^.owner^.modlevel >= ModLevel) THEN
*WITH p2^ DO
,marked:= TRUE;
,owner^.state:=0;
,CloseFile (owner,owner^.ondisk & owner^.new);
,IF Opened (owner) THEN
.owner^.state:= 0;
.f:= owner; (* wg. VAR-Para bei Close *)
.Close (f)
,END
*END;
*called:= TRUE;
*p2:= NIL
(ELSE
*p2:= p2^.next
(END
&END
$UNTIL ~called;
"END releaseLevel;
 
 (*$L+*)
 PROCEDURE ChgLevel (start:BOOLEAN; inChild:BOOLEAN; VAR exitCode:INTEGER);
"BEGIN
$IF inChild THEN
&IF start THEN
(INC (ModLevel)
&ELSE
(releaseLevel;
(DEC (ModLevel)
&END
$END
"END ChgLevel;
 
 (*$L+*)
 PROCEDURE freeSys;
"BEGIN
$ModLevel:= MinInt;
$releaseLevel
"END freeSys;
 
 VAR p: ADDRESS;
$i: INTEGER;
$hdl: EnvlpCarrier;
$tHdl: TermCarrier;
$rHdl: RemovalCarrier;
$wsp: MemArea;
 
 BEGIN
"fileSize:= TSIZE (FileField);
"unitSize:= SHORT (SIZE (UnitDriver[con]));
"OpenFiles:= NIL;
"ModLevel:= 0;
"ErrTblBeg:= ADR (ErrorTable);
"ErrTblEnd:= ErrTblBeg + SIZE (ErrorTable);
"p:= ErrTblBeg;
"FOR i:= -MaxWarn TO -MaxErrorNo DO
$p^ := WORD(-i);
$INC (p,2)
"END;
"SetEnvelope (hdl,ChgLevel,wsp);
"CatchProcessTerm (tHdl,releaseLevel,wsp);
"CatchRemoval (rHdl,freeSys,wsp);
 END Files.
  
(* $0000584F$FFFAD5B5$FFFAD5B5$FFFAD5B5$FFFAD5B5$FFFAD5B5$FFFAD5B5$FFFAD5B5$FFFAD5B5$FFFAD5B5$FFFAD5B5$FFFAD5B5$FFFAD5B5$FFFAD5B5$FFFAD5B5$0000387D$FFFAD5B5$FFFAD5B5$FFFAD5B5$FFFAD5B5$FFFAD5B5$FFFAD5B5$FFFAD5B5$FFFAD5B5$FFFAD5B5$FFFAD5B5$FFFAD5B5$FFFAD5B5$FFFAD5B5$FFFAD5B5$FFFAD5B5$FFFAD5B5$FFFAD5B5$FFFAD5B5$FFFAD5B5$FFFAD5B5$00002812$FFFAD5B5$FFFAD5B5$FFFAD5B5$FFFAD5B5$000028F6$00000564T.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$00001C02$00001D94$00002B0B$00002A3D$000004ED$0000060B$0000055E$00000608$00000564$000004FF$FFEC668A$00000553$000004FC$00000553$000004FB$00002A95*)
