 IMPLEMENTATION MODULE Runtime;
 (*$Y+,L-,R-,N+,C-,M-*)
 
 (**********************************************************************
 
,Runtime Support fuer Atari Modula-Compiler   V#097
 
!30.10.86   Version fuer Atari, mit neuem Stringformat:
,CAP, STAS angepasst,
,RangeCheck fuer CHR.
"1.11.86   STAS fuer Stringlaenge > 32K korrigiert;
,Prozeduren zur Coroutinen-Unterstuetzung als Dummy.
"3.11.86   CHR und CAP fuer neue Char-Darstellung (mit folgendem SyncByte)
!30.11.86   Set-Operationen verkraften ungerade Laengenangaben
!19.12.86   TrapCode 7 fuer Zugriff ueber NIL-Pointer definiert
!22.01.87   TRAP-Auswertung wieder impl.
!04.02.87   STAS: BCS ok2 statt BEQ ok2.
!27.02.87   TRAP 15: trp0->trp9; GEM-Alert impl.; DivByZero,TRAPV,Addr- und
,Bus-Error abgefangen; Vektor-Restauration per SetTerminateProc;
,trp7 (access via NIL-Ptr) raus.
!02.03.87   Traps:USP wird gerettet; Scan-Aufruf impl.
!19.03.87   Fehlerbehandlung -> GEMError-Modul
!09.05.87   TRAP-Nummern gendert
!19.06.87   neue Real-Arithmetik
!30.06.87   IOTransfer impl.
!08.07.87   D7->#1; bei Fehler wird Aufrufer angescanned.
!22.07.87   IOTransfer, LISTEN, usw. impl.;
!23.07.87   @PRIO impl, IOTransfer kann auch auf Vektoren >= $400 ange-
,wendet werden.
!11.08.87   abermals D7->#1 in Set-Funktionen (wie kam D7 da wieder hin ??)
!29.08.87   @IDIV korrigiert (UNLK u. MOVEM vertauscht)
!08.09.87   @IOCA neu
!27.10.87   FLOAT und TRUNC auf LONGCARD-Parameter umgestellt
!13.11.87   @LSTN decr. IR um Eins
!16.12.87   Realvergleiche korrigiert (Null galt als grer als Zahlen
-mit negativem Exponenten): RELE, REGE, RELT, REGT
!17.12.87   Realvergleiche jetzt hoffentlich ok
!16.01.88   @PRIO geht auch im Superv.-Mode
!01.04.88   @FPDIV fr negativen Divisor korrigiert; @IOCA geht jetzt.
!09.04.88   Coroutinen-Anpassung f. 68020.
!28.05.88   @RES1 und @RES2 fr Procedure Entries (ab Comp 3.6a) verwendet
!19.07.88   @SMEM, @RELE, @REGE, @RELT, @REGT zerstren nicht mehr D3/D4.
!12.08.88   CAP bercksichtigt auch nicht-deutsche Umlaute.
!01.01.88   TRUNC lst Runtime-Error bei neg. Arg. aus
!19.01.89   881-Untersttzung von MR (26.8.88) bernommen (Cond: A68881)
!15.06.89   Include-File f. Prozessoren
!16.06.89   881-Routinen berarbeitet (optimiert, Errors)
!04.07.89   @STAS korrigiert - machte bei ungeradem Source-String Mist
!19.08.89   Runtime luft nun gleichzeitg mit 68000 & 68020
!30.11.89   Optimierungen in Long-Mul/Div/Mod (LINK verlagert)
 ***********************************************************************)
 
 FROM SYSTEM IMPORT ASSEMBLER, ADDRESS, WORD;
 
 IMPORT SysInfo;
 
 FROM SFP004 IMPORT FPUInit, FPUError;
 
 CONST
 
 (*$I FPU.CNF *)
 
(DftSF = $0010;
 
 VAR     has020: BOOLEAN;
 
 (*$? A68881:
 CONST
(fpstat  =  $fffa40;       (* Response word of MC68881 read *)
(fpstatlo=  $fffa41;
(fpctrl  =  $fffa42;       (* Control  word of MC68881 write *)
(fpcmd   =  $fffa4a;       (* Command  word of MC68881 write *)
(fpcond  =  $fffa4e;       (* Condition word of MC68881 write *)
(fpop    =  $fffa50;       (* Operand  long of MC68881 read/write *)
 *)
 
 (************** Coroutinen-Unterstuetzung **************)
 
 
 PROCEDURE BadReturn;  (* RTS aus CoRoutine anmeckern *)
"BEGIN
$ASSEMBLER
(TRAP    #6
(DC.W    -15-$6000       ; kein cont, scan prev
$END
"END BadReturn;
 
 
 (*
#Transferdaten beim Usermode:
(2  Byte - 0: zeigt Usermode an / 1: Vektor zus. restaurieren
(4  Byte - PC
(2  Byte - SR
(4  Byte - A6
(56 Byte - D0-A5
 
#Transferdaten beim Supervisormode:
(2  Byte - $FFxx, zeigt Supervisormode an
(4  Byte - USP
(60 Byte - D0-A6
(4  Byte - Dummy
(2  Byte - SR
(4  Byte - PC
 *)
 
 (* Kennung:      Zustand:
$0             Normal u. Exc-Rckkehr - Usermode
$1             Warten auf Exc - Usermode, Vektor restaurieren
$$FF           Exc-Rckkehr - Supervisormode
 *)
 
 PROCEDURE @NEWP ( p:PROC; a:ADDRESS; n:LONGCARD; VAR prc:ADDRESS );
"BEGIN
$ASSEMBLER
(LINK    A5,#0
(
(MOVE.L  -(A3),A1        ; 'prc'
(MOVE.L  -(A3),A0        ; SIZE (workspace)
(MOVE.L  A0,D1
(BCLR    #0,D1
(MOVE.L  -(A3),D0        ; ADR (workspace)
(ADDQ.L  #1,D0
(BCLR    #0,D0
(ADDA.L  D0,A0           ; ENDADR (workspace)
(MOVE.L  -(A3),D2        ; ADR (procedure)
(CMPI.L  #90,D1          ; ist workspace gro genug ?
(BCC     wspOk
(
(TRAP    #6
(DC.W    -10-$4000       ; 'out of stack'
(UNLK    A5
(RTS
(
&wspOk:
(MOVEM.L A3/A5,-(A7)
(
(MOVE.L  D0,A3
(
(MOVE.L  D2,-(A0)         ;Adresse fr scan
(ADDQ.L  #2,(A0)          ;scan-Adr etwas vorsetzen
(CLR.L   -(A0)            ;voriges A5
(MOVE.L  A0,A5            ;fr UNLK in backScan()
(MOVE.L  #BadReturn,-(A0) ;Fehlerbehandlung bei RTS aus Coroutine
(
(MOVEM.L D0-A5,-(A0)      ; Bis auf A3,A5 nur Dummy-Werte
(MOVE.L  A6,-(A0)
(MOVE.W  SR,-(A0)
(MOVE.L  D2,-(A0)
(CLR.W   -(A0)
(
(; nun den SP in 'prc' ablegen
(MOVE.L  A0,(A1)
(
(MOVEM.L (A7)+,A3/A5
(UNLK    A5
$END
"END @NEWP;
 
 PROCEDURE @TRAN ( VAR source,dest:ADDRESS );  (* Transfer *)
"BEGIN
$ASSEMBLER
(; Aufruf erfolgt immer im Usermode, der zu startende Proze
(; kann in beiden Modi ablaufen
(
(MOVE.L  -(A3),A2        ; dest
(MOVE.L  -(A3),A1        ; source
(MOVE    SR,D2
(
(; JSR     EnterSupervisorMode
(
(MOVE    #$2700,SR       ; keine Interrupts !
(
(; aktiven Proze beenden
(MOVE.L  USP,A0
(MOVE.L  (A0)+,D0        ; Rcksprungadr. hinter TRANSFER
(MOVEM.L D0-A5,-(A0)
(MOVE.L  A6,-(A0)
(MOVE.W  D2,-(A0)
(MOVE.L  D0,-(A0)
(CLR.W   -(A0)
(
(MOVE.L  (A2),D0         ; zuerst retten, falls A1=A2
(MOVE.L  A0,(A1)
(MOVE.L  D0,A6
(
(; neuen Proze starten
(TST.W   (A6)+
(BEQ     stUsr
(BMI     stSup
(
(; starte Usermode, vorher Vektor restaurieren
(MOVE.L  (A6)+,D0        ; alter Vektor
(MOVE.L  4+2+4+4(A6),A0  ; D1: Vektoradr.
(MOVE.L  D0,(A0)
(TST     has020
(BEQ     no20
(MOVE    #DftSF,-(A7)
 no20:
(MOVE.L  (A6)+,-(A7)     ; PC
(MOVE.W  (A6)+,-(A7)     ; SR
(MOVE.L  (A6)+,-(A7)     ; A6
(MOVEM.L (A6)+,D0-A5
(MOVE.L  A6,USP
(MOVE.L  (A7)+,A6
(RTE
(
 stUsr:  ; starte Usermode
(TST     has020
(BEQ     no20b
(MOVE    #DftSF,-(A7)
 no20b:
(MOVE.L  (A6)+,-(A7)     ; PC
(MOVE.W  (A6)+,-(A7)     ; SR
(MOVE.L  (A6)+,-(A7)     ; A6
(MOVEM.L (A6)+,D0-A5
(MOVE.L  A6,USP
(MOVE.L  (A7)+,A6
(RTE
(
 stSup:  ; starte Supervisormode
(MOVE.L  A6,A7
(MOVE.L  (A7)+,A0
(MOVE.L  A0,USP
(MOVEM.L (A7)+,D0-A6
(ADDQ.L  #4,A7
(TST     has020
(BEQ     no20c
(MOVE.W  (A7),-(A7)
(MOVE.L  4(A7),2(A7)
(MOVE    #DftSF,6(A7)
 no20c:
(RTE
$END
"END @TRAN;
 
 PROCEDURE @LSTN;
"BEGIN
$ASSEMBLER
(; JSR     EnterSupervisorMode
(MOVE    SR,-(A7)
(MOVE    SR,D0
(ANDI    #$0700,D0
(BEQ     ok
(MOVE    SR,D0
(SUBI    #$0100,D0
(MOVE    D0,SR
(NOP
(NOP
&ok:
(MOVE    (A7)+,SR
(ANDI    #$FFFF-$2000,SR ; Back into user mode
$END
"END @LSTN;
 
 PROCEDURE hdlExc;
"(* Fr IOTRANSFER-Auslsungen per Exception *)
"BEGIN
$ASSEMBLER
(; Der Aufruf kann aus beiden Modi kommen, der zu startende
(; Proze ist immer im Usermode
(
(MOVE    #$2700,SR       ; keine Interrupts !
(
(BTST.B  #5,4(A7)        ; aus welchem mode ?
(BNE     frSup
(
(; Entry aus User mode
(
(; Daten auf den USP retten
(MOVE.L  A6,-(A7)
(MOVE.L  USP,A6
(MOVEM.L D0-A5,-(A6)
(MOVE.L  (A7)+,-(A6)
(MOVE.L  (A7)+,A0        ; ^Transfer-Daten
(MOVE    (A7)+,-(A6)     ; SR
(MOVE.L  (A7)+,-(A6)     ; PC
(CLR.W   -(A6)
(
(; A0 zeigt auf:
(; 2  Byte - 1, zeigt IOTR an
(; 4  Byte - alter Exc-Vektor
(; 4  Byte - PC
(; 2  Byte - SR
(; 4  Byte - A6
(; 56 Byte - D0-A5
(
(MOVE.L  2+4+4+2+4+32+8(A0),A2  ; A2: alter dest^
(MOVE.L  A6,(A2)
(
(MOVE.L  2+4+4+2+4+4(A0),A3  ; D1: Vektoradr.
(LEA     2(A0),A6
(MOVE.L  (A6)+,(A3)      ; alten Vektor restaurieren
(TST     has020
(BEQ     no20d
(MOVE    #DftSF,-(A7)
 no20d:
(MOVE.L  (A6)+,-(A7)     ; PC
(MOVE.W  (A6)+,-(A7)     ; SR
(MOVE.L  (A6)+,-(A7)     ; A6
(MOVEM.L (A6)+,D0-A5
(MOVE.L  A6,USP
(MOVE.L  (A7)+,A6
(RTE
(
 frSup:  ; Entry aus Supervisor mode
(
(; Daten auf den USP retten
(MOVEM.L D0-A6,-(A7)
(MOVE.L  USP,A6
(MOVE.L  A6,-(A7)
(ST.B    -(A7)
(
(MOVE.L  2+4+60(A7),A0         ; ^Transfer-Daten
(
(; A0: (s.o.)
(
(MOVE.L  2+4+4+2+4+32+8(A0),A2   ; A2: alter dest^
(MOVE.L  A7,(A2)
(
(MOVE.L  2+4+4+2+4+4(A0),A3  ; D1: Vektoradr.
(LEA     2(A0),A6
(MOVE.L  (A6)+,(A3)      ; alten Vektor restaurieren
(TST     has020
(BEQ     no20e
(MOVE    #DftSF,-(A7)
 no20e:
(MOVE.L  (A6)+,-(A7)     ; PC
(MOVE.W  (A6)+,-(A7)     ; SR
(MOVE.L  (A6)+,-(A7)     ; A6
(MOVEM.L (A6)+,D0-A5
(MOVE.L  A6,USP
(MOVE.L  (A7)+,A6
(RTE
$END
"END hdlExc;
 
 PROCEDURE hdlCall;
"(* Fr IOTRANSFER-Auslsungen per JSR *)
"BEGIN
$ASSEMBLER
(; Der Aufruf kann aus beiden Modi kommen, der zu startende
(; Proze ist immer im Usermode
(
(MOVE.L  D1,-(A7)
(MOVE    SR,D1
(BTST    #13,D1          ; aus welchem Mode ?
(BNE     frSup
(
(; Entry aus User mode
(
(; JSR     EnterSupervisorMode
(
(;BREAK
(MOVE    #$2700,SR       ; keine Interrupts !
(
(; aktiven Proze beenden, Daten auf den USP retten
(; auf USP stehen noch: D1.L, 2 Byte,  ^Dest-Transfer-Daten, PC.L
(MOVE.L  A0,-(A7)
(MOVE.L  USP,A0
(MOVE.L  (A0)+,-(A7)     ; D1 retten
(MOVE.L  (A0)+,-(A7)     ; ^Transfer-Daten
(MOVE.L  (A0)+,-(A7)     ; PC retten
(MOVEM.L D0-A5,-(A0)
(MOVE.L  A6,-(A0)
(MOVE.W  D1,-(A0)        ; SR
(MOVE.L  (A7)+,-(A0)     ; PC
(MOVE.L  (A7)+,14(A0)    ; D1 in Transfer-Daten ablegen
(MOVE.L  (A7)+,A1        ; ^Transfer-Daten
(MOVE.L  (A7)+,42(A0)    ; A0 in Transfer-Daten ablegen
(CLR.W   -(A0)
(
(; A1 zeigt auf:
(; 2  Byte - 1, zeigt IOTR an
(; 4  Byte - alter Exc-Vektor
(; 4  Byte - PC
(; 2  Byte - SR
(; 4  Byte - A6
(; 56 Byte - D0-A5
(
(MOVE.L  2+4+4+2+4+32+8(A1),A2  ; A2: alter dest^
(MOVE.L  A6,(A2)
(
(MOVE.L  2+4+4+2+4+4(A1),A3  ; D1: Vektoradr.
(LEA     2(A1),A6
(MOVE.L  (A6)+,(A3)      ; alten Vektor restaurieren
(TST     has020
(BEQ     no20f
(MOVE    #DftSF,-(A7)
 no20f:
(MOVE.L  (A6)+,-(A7)     ; PC
(MOVE.W  (A6)+,-(A7)     ; SR
(MOVE.L  (A6)+,-(A7)     ; A6
(MOVEM.L (A6)+,D0-A5
(MOVE.L  A6,USP
(MOVE.L  (A7)+,A6
(RTE
(
 frSup:  ; Entry aus Supervisor mode
(
(MOVE.L  (A7),D1
(ADDQ.L  #2,A7
(MOVE.L  2(A7),(A7)      ; ^Transfer-Daten 2 Byte tiefer
(MOVE    SR,4(A7)        ; SR darber
(
(;BREAK
(MOVE    #$2700,SR       ; keine Interrupts !
(
(; aktiven Proze beenden, Daten auf den USP retten
(MOVEM.L D0-A6,-(A7)
(MOVE.L  USP,A0
(MOVE.L  A0,-(A7)
(ST.B    -(A7)
(
(MOVE.L  2+4+60(A7),A0         ; ^Transfer-Daten
(
(; A0: (s.o.)
(
(MOVE.L  2+4+4+2+4+32+8(A0),A2   ; A2: alter dest^
(MOVE.L  A7,(A2)
(
(MOVE.L  2+4+4+2+4+4(A0),A3  ; D1: Vektoradr.
(LEA     2(A0),A6
(MOVE.L  (A6)+,(A3)      ; alten Vektor restaurieren
(TST     has020
(BEQ     no20g
(MOVE    #DftSF,-(A7)
 no20g:
(MOVE.L  (A6)+,-(A7)     ; PC
(MOVE.W  (A6)+,-(A7)     ; SR
(MOVE.L  (A6)+,-(A7)     ; A6
(MOVEM.L (A6)+,D0-A5
(MOVE.L  A6,USP
(MOVE.L  (A7)+,A6
(RTE
$END
"END hdlCall;
 
 
 PROCEDURE @IOTR ( VAR source,dest:ADDRESS; vecAddr:ADDRESS );
"CONST JSRInstr = $4EB9;
"BEGIN
$ASSEMBLER
(; Aufruf erfolgt immer im Usermode, der zu startende Proze
(; kann in beiden Modi ablaufen
(
(MOVE.L  -(A3),D1        ; vector
(MOVE.L  -(A3),A2        ; dest
(MOVE.L  -(A3),A1        ; source
(MOVE    SR,D2
(
(; JSR     EnterSupervisorMode
(
(MOVE    #$2700,SR       ; keine Interrupts !
(
(; Daten fr 'hdlExc' und 'hdlCall':
(; 2  Byte - 1, zeigt IOTR an
(; 4  Byte - alter Exc-Vektor
(; 4  Byte - PC
(; 2  Byte - SR
(; 4  Byte - A6
(; 56 Byte - D0-A5
(
(; aktiven Proze beenden
(MOVE.L  USP,A0
(MOVE.L  (A0)+,D0        ; Rcksprungadr. hinter IOTRANSFER
(MOVEM.L D0-A5,-(A0)
(MOVE.L  A6,-(A0)
(MOVE.W  D2,-(A0)
(MOVE.L  D0,-(A0)
(
(MOVE.L  D1,A3
(MOVE.L  (A3),-(A0)      ; alten vektor retten
(
(MOVE    #1,-(A0)
(
(MOVE.L  (A2),D0         ; zuerst retten, falls A1=A2
(MOVE.L  A0,(A1)
(MOVE.L  D0,A6
(
(CMPA.W  #$400,A3
(BCS     isExc
(MOVE.L  #hdlCall,-(A0)
(BRA     cont0
 isExc   MOVE.L  #hdlExc,-(A0)
 cont0   MOVE    #JSRInstr,-(A0)
(
(MOVE.L  A0,(A3)         ; neuen vektor auf 'JSR hdlExc/hdlCall'
(
(; neuen Proze starten
(TST.W   (A6)+
(BEQ     stUsr
(BMI     stSup
(
(; starte Usermode, vorher Vektor restaurieren
(MOVE.L  (A6)+,D0        ; alter Vektor
(MOVE.L  4+2+4+4(A6),A0  ; D1: Vektoradr.
(MOVE.L  D0,(A0)
(TST     has020
(BEQ     no20h
(MOVE    #DftSF,-(A7)
 no20h:
(MOVE.L  (A6)+,-(A7)     ; PC
(MOVE.W  (A6)+,-(A7)     ; SR
(MOVE.L  (A6)+,-(A7)     ; A6
(MOVEM.L (A6)+,D0-A5
(MOVE.L  A6,USP
(MOVE.L  (A7)+,A6
(RTE
(
 stUsr:  ; starte Usermode
(TST     has020
(BEQ     no20i
(MOVE    #DftSF,-(A7)
 no20i:
(MOVE.L  (A6)+,-(A7)     ; PC
(MOVE.W  (A6)+,-(A7)     ; SR
(MOVE.L  (A6)+,-(A7)     ; A6
(MOVEM.L (A6)+,D0-A5
(MOVE.L  A6,USP
(MOVE.L  (A7)+,A6
(RTE
(
 stSup:  ; starte Supervisormode
(MOVE.L  A6,A7
(MOVE.L  (A7)+,A0
(MOVE.L  A0,USP
(MOVEM.L (A7)+,D0-A6
(ADDQ.L  #4,A7
(TST     has020
(BEQ     no20j
(MOVE.W  (A7),-(A7)
(MOVE.L  4(A7),2(A7)
(MOVE    #DftSF,6(A7)
 no20j:
(RTE
$END
"END @IOTR;
 
 
 PROCEDURE @IOCA ( vecAddr:ADDRESS );
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),A1
(CMPA.L  #$400,A1
(BCS     isExc
(MOVEM.L D3-D7/A3-A6,-(A7)
(; JSR     EnterSupervisorMode     ; Regs D0,A0 knnen verndert werden !
(MOVE.L  (A1),A1
(JSR     (A1)
(ANDI    #$CFFF,SR
(MOVEM.L (A7)+,D3-D7/A3-A6
(RTS
&isExc:
(MOVE.L  (A7)+,A2
(MOVE    SR,D1
(; JSR     EnterSupervisorMode     ; Regs D0,A0 knnen verndert werden !
(MOVE.L  (A1),A1
(TST     has020
(BEQ     no20k
(MOVE    #DftSF,-(A7)
 no20k:
(MOVE.L  A2,-(A7)
(MOVE    D1,-(A7)
(JMP     (A1)            ; rettet sicher alle Register
$END
"END @IOCA;
 
 
 PROCEDURE @PRIO;  (* Set Interrupt Priority *)
"BEGIN
$(* IR-level in D2, auf Bitpos. wie SR; A2 nicht verndern ! *);
$ASSEMBLER
(MOVE    SR,D0
(BTST    #13,D0
(BNE     sup                     ; wir sind im Supervisormode
(; JSR     EnterSupervisorMode
(MOVE    D2,SR
(RTS
&sup:
(ANDI    #$F0FF,D0
(ANDI    #$0F00,D2
(OR      D2,D0
(MOVE    D0,SR
$END
"END @PRIO;
 
 
 PROCEDURE @EXCL; (* Exclude Element aus Set *)
"
"BEGIN (* SetAdr und Element auf Stack *)
$ASSEMBLER
'MOVE.W  -(A3),D0
'MOVE.W  D0,D1
'LSR.W   #3,D0
'MOVE.L  -(A3),A0
'BCLR    D1,0(A0,D0.W)   END
"END @EXCL;
"
 
 PROCEDURE @INCL; (* Include Element in Set *)
 
"BEGIN (* SetAdr und Element auf Stack *)
$ASSEMBLER
(MOVE.W  -(A3),D0
(MOVE.W  D0,D1
(LSR.W   #3,D0
(MOVE.L  -(A3),A0
(BSET    D1,0(A0,D0.W)   END
$END @INCL;
"
 
 PROCEDURE @SAND; (* '*' auf Sets *)
 
#BEGIN (* zwei Sets auf Stack, Laenge in D0 *)
)ASSEMBLER
+MOVE.L  A3,A0
+ADDQ.W  #1,D0
+BCLR    #0,D0    ;sync. D0
+SUBA.W  D0,A0
%Lp    MOVE.W  -(A3),D1
+AND.W   D1,-(A0)
+SUBQ.W  #2,D0
+BHI     Lp
)END
#END @SAND;
!
 
 PROCEDURE @SXOR; (* '/' auf Sets *)
 
"BEGIN (* zwei Sets auf Stack, Laenge in D0 *)
(ASSEMBLER
*MOVE.L  A3,A0
*ADDQ.W  #1,D0
*BCLR    #0,D0    ;sync. D0
*SUBA.W  D0,A0
$Lp    MOVE.W  -(A3),D1
*EOR.W   D1,-(A0)
*SUBQ.W  #2,D0
*BHI     Lp
(END
"END @SXOR;
!
 
 PROCEDURE @SSUM; (* '+' auf Sets *)
 
"BEGIN (* zwei Sets auf Stack, Laenge in D0 *)
(ASSEMBLER
*MOVE.L  A3,A0
*ADDQ.W  #1,D0
*BCLR    #0,D0    ;sync. D0
*SUBA.W  D0,A0
$Lp    MOVE.W  -(A3),D1
*OR.W    D1,-(A0)
*SUBQ.W  #2,D0
*BHI     Lp
(END
"END @SSUM;
!
 
 PROCEDURE @SDIF; (* '-' auf Sets *)
 
"BEGIN (* zwei Sets auf Stack, Laenge in D0 *)
(ASSEMBLER
*MOVE.L  A3,A0
*ADDQ.W  #1,D0
*BCLR    #0,D0    ;sync. D0
*SUBA.W  D0,A0
$Lp    MOVE.W  -(A3),D1
*AND.W   -(A0),D1
*EOR.W   D1,(A0)
*SUBQ.W  #2,D0
*BHI     Lp
(END
"END @SDIF;
 
 
 PROCEDURE @SMEM; (* IN-Operator auf Sets *)
 
"BEGIN (* Element.W und Set auf Stack, SetLaenge in D0 *)
$ASSEMBLER
(MOVE.W  D0,D1
(NEG.W   D1
(BCLR    #0,D1
(LEA     0(A3,D1.W),A0       ;A0 ist ^SetAnfang
(MOVE.W  -(A0),D2
(MOVE.W  D2,D1
(LSR.W   #3,D2
(CMP.W   D0,D2
(BCC     NOMEM
(BTST    D1,2(A0,D2.W)
(BEQ     NOMEM
(MOVE.L  A0,A3
(MOVE.W  #1,(A3)+
(RTS
&NOMEM
(MOVE.L  A0,A3
(CLR     (A3)+
$END
"END @SMEM;
"
 
 PROCEDURE @SEQL; (* '=' auf Sets *)
 
"BEGIN (* zwei Sets auf Stack, Laenge in D0 *)
(ASSEMBLER
*MOVE.W  D0,D1
*NEG.W   D1
*BCLR    #0,D1
*LEA     0(A3,D1.W),A0   ;^Anfang des 2. Sets
*LEA     0(A0,D1.W),A1   ;^Anfang des 1. Sets
*MOVE.L  A1,D1
*SUBQ.W  #1,D0
$Lp    CMPM.B  (A0)+,(A1)+
*DBNE    D0,Lp
*SEQ     D0
*AND.W   #1,D0
*MOVE.L  D1,A3
*MOVE.W  D0,(A3)+
(END
"END @SEQL;
 
 
 PROCEDURE @SNEQ; (* '#' auf Sets *)
 
"BEGIN (* zwei Sets auf Stack, Laenge in D0 *)
(ASSEMBLER
*MOVE.W  D0,D1
*NEG.W   D1
*BCLR    #0,D1
*LEA     0(A3,D1.W),A0   ;^Anfang des 2. Sets
*LEA     0(A0,D1.W),A1   ;^Anfang des 1. Sets
*MOVE.L  A1,D1
*SUBQ.W  #1,D0
$Lp    CMPM.B  (A0)+,(A1)+
*DBNE    D0,Lp
*SNE     D0
*AND.W   #1,D0
*MOVE.L  D1,A3
*MOVE.W  D0,(A3)+
(END
"END @SNEQ;
 
 
 PROCEDURE @SLEQ; (* '<=' auf Sets *)
 
"BEGIN (* zwei Sets auf Stack, Laenge in D0 *)
(ASSEMBLER
*MOVE.W  D0,D1
*NEG.W   D1
*BCLR    #0,D1
*LEA     0(A3,D1.W),A0   ;^Anfang des 2. Sets
*LEA     0(A0,D1.W),A1   ;^Anfang des 1. Sets
*MOVE.L  A1,D2
*SUBQ.W  #1,D0
$Lp    MOVE.B  (A1),D1
*AND.B   (A0)+,D1
*EOR.B   D1,(A1)+        ;Set1 * Set2 =! Set1
*DBNE    D0,Lp
*SEQ     D0
*AND.W   #1,D0
*MOVEA.L D2,A3
*MOVE.W  D0,(A3)+
(END
"END @SLEQ;
 
 
 PROCEDURE @SGEQ; (* '>=' auf Sets *)
 
"BEGIN (* zwei Sets auf Stack, Laenge in D0 *)
(ASSEMBLER
*MOVE.W  D0,D1
*NEG.W   D1
*BCLR    #0,D1
*LEA     0(A3,D1.W),A0   ;^Anfang des 2. Sets
*LEA     0(A0,D1.W),A1   ;^Anfang des 1. Sets
*MOVE.L  A1,D2
*SUBQ.W  #1,D0
$Lp    MOVE.B  (A0),D1
*AND.B   (A1)+,D1
*EOR.B   D1,(A0)+        ;Set1 * Set2 =! Set2
*DBNE    D0,Lp
*SEQ     D0
*AND.W   #1,D0
*MOVEA.L D2,A3
*MOVE.W  D0,(A3)+
(END
"END @SGEQ;
 
 (********* Real-Vergleiche *********)
 
 PROCEDURE @REEQ (a,b:LONGREAL):BOOLEAN;        (* a = b *)
 BEGIN
"ASSEMBLER
$; !!! sind bei 881 nicht unbenutzte Bits, die hier falsche Erg. liefern k?
$MOVE.L -(A3),D0
$MOVE.L -(A3),D1
$MOVE.L -(A3),D2
$CMP.L  -(A3),D1
$BNE    NE
$CMP.L  D0,D2
$BNE    NE
$MOVE.W #true,(A3)+
$RTS
 !NE CLR.W (A3)+
"END
 END @REEQ;
 
 PROCEDURE @RENE (a,b:LONGREAL):BOOLEAN;        (* a # b *)
 BEGIN
"ASSEMBLER
$; !!! sind bei 881 nicht unbenutzte Bits, die hier falsche Erg. liefern k?
$MOVE.L -(A3),D0
$MOVE.L -(A3),D1
$MOVE.L -(A3),D2
$CMP.L  -(A3),D1
$BNE    NE
$CMP.L  D0,D2
$BNE    NE
$CLR.W (A3)+
$RTS
 !NE MOVE.W #true,(A3)+
"END
 END @RENE;
 
 (*********** Longint - Arithmetik ***********)
 
 PROCEDURE @IMUL (a,b:LONGINT):LONGINT;
 BEGIN
#ASSEMBLER
'MOVE.L D3,-(A7)
'CLR.W  D3
'MOVE.L -(A3),D0
'BPL    IMUL5
'NEG.L  D0
'MOVEQ  #1,D3
 !IMUL5 MOVE.L -(A3),D1
'BPL    IMUL4
'NEG.L  D1
'BCHG   #0,D3
 !IMUL4 MOVE.L D0,D2
'MULU   D1,D0
'SWAP   D1
'TST.W  D1
'BEQ    IMUL1
'SWAP   D2
'TST.W  D2
'BEQ    IMUL2
'BNE    IMERR
 !IMUL1 SWAP   D1
 !IMUL2 SWAP   D2
'MULU   D1,D2
'SWAP   D2
'TST.W  D2
'BNE    IMERR
'ADD.L  D2,D0
'BVS    IMERR
'BMI    IMERR
'TST.W  D3
'BEQ    IMUL3
'NEG.L  D0
 !IMUL3 MOVE.L D0,(A3)+
'MOVE.L (A7)+,D3
'RTS
'
 !IMERR LINK   A5,#0
'TRAP    #6          ; Overflow
'DC.W    -7-$4000
'CLR.L   (A3)+
'MOVE.L (A7)+,D3
'UNLK   A5
#END
 END @IMUL;
 
 PROCEDURE @CMUL (a,b:LONGCARD):LONGCARD;
 BEGIN
"ASSEMBLER
'MOVE.L -(A3),D0
'MOVE.L -(A3),D1
'MOVE.L D0,D2
'MULU   D1,D0
'SWAP   D1
'TST.W  D1
'BEQ    CMUL1
'SWAP   D2
'TST.W  D2
'BEQ    CMUL2
'BNE    CMERR
 !CMUL1 SWAP   D1
 !CMUL2 SWAP   D2
'MULU   D1,D2
'SWAP   D2
'TST.W  D2
'BNE    CMERR
'ADD.L  D2,D0
'BCS    CMERR
'MOVE.L D0,(A3)+
'RTS
'
 !CMERR LINK   A5,#0
'TRAP    #6          ; Overflow
'DC.W    -7-$4000
'CLR.L   (A3)+
'UNLK   A5
#END
 END @CMUL;
 
 PROCEDURE @IDIV (a,b:LONGINT):LONGINT;
 BEGIN
#ASSEMBLER
(MOVEM.L D4-D5,-(A7)
(
(CLR.W  D5
(MOVE.L -(A3),D0
(BEQ    IDERR
(BPL    IDIV5
(NEG.L  D0
(MOVEQ  #1,D5
 !IDIV5  MOVE.L -(A3),D1
(BPL    IDIV6
(NEG.L  D1
(BCHG   #0,D5
 !IDIV6  CLR.L  D2
(CLR.L  D4
 !IDIV1  CMP.L  D0,D1
(BLS    IDIV2
(LSL.L  #1,D0
(ADDQ.W #1,D2
(BRA    IDIV1
 !IDIV3  LSR.L  #1,D0
 !IDIV2  LSL.L  #1,D4
(CMP.L  D0,D1
(BCS    IDIV4
(SUB.L  D0,D1
(ADDQ.W #1,D4
 !IDIV4  DBF    D2,IDIV3
(TST.W  D5
(BEQ    IDIV7
(NEG.L  D4
 !IDIV7  MOVE.L D4,(A3)+
(MOVEM.L (A7)+,D4-D5
(RTS
(
 !IDERR  LINK   A5,#0
(TRAP    #6          ; Div by zero
(DC.W    -5-$4000
(CLR.L   (A3)+
(MOVEM.L (A7)+,D4-D5
(UNLK   A5
$END
 END @IDIV;
 
 PROCEDURE @CDIV (a,b:LONGCARD):LONGCARD;
 BEGIN
 ASSEMBLER
'MOVE.L D3,-(A7)
'MOVE.L -(A3),D0
'BEQ    CDERR
'MOVE.L -(A3),D1
'CLR.L  D2
'CLR.L  D3
'TST.L  D0
'BMI    CDIV2
 !CDIV1 CMP.L  D0,D1
'BLS    CDIV2
'ADDQ   #1,D2
'ASL.L  #1,D0
'BPL    CDIV1
 !CDIV2 ASL.L  #1,D3
'CMP.L  D0,D1
'BCS    CDIV3
'SUB.L  D0,D1
'ADDQ   #1,D3
 !CDIV3 LSR.L  #1,D0
'DBF    D2,CDIV2
'MOVE.L D3,(A3)+
'MOVE.L (A7)+,D3
'RTS
'
 !CDERR LINK   A5,#0
'TRAP    #6          ; Div by zero
'DC.W    -5-$4000
'CLR.L   (A3)+
'MOVE.L (A7)+,D3
'UNLK   A5
 END
 END @CDIV;
 
 PROCEDURE @IMOD (a,b:LONGINT):LONGINT;
 BEGIN
 ASSEMBLER
'MOVE.L D5,-(A7)
'CLR.W  D5
'CLR.L  D2
'MOVE.L -(A3),D0
'BEQ    IMODER
'BPL    IMOD2
'NEG.L  D0
 !IMOD2 MOVE.L -(A3),D1
'BPL    IMOD1
'NEG.L  D1
'MOVEQ  #1,D5
 !IMOD1 CMP.L  D0,D1
'BLS    IMOD5
'LSL.L  #1,D0
'ADDQ.W #1,D2
'BRA    IMOD1
 !IMOD3 LSR.L  #1,D0
 !IMOD5 CMP.L  D0,D1
'BCS    IMOD4
'SUB.L  D0,D1
 !IMOD4 DBEQ   D2,IMOD3
'TST.W  D5
'BEQ    IMOD6
'NEG.L  D1
 !IMOD6 MOVE.L D1,(A3)+
'MOVE.L (A7)+,D5
'RTS
'
 IMODER LINK   A5,#0
'TRAP    #6          ; Div by zero
'DC.W    -5-$4000
'CLR.L   (A3)+
'MOVE.L (A7)+,D5
'UNLK   A5
#END
 END @IMOD;
 
 PROCEDURE @CMOD (a,b:LONGCARD):LONGCARD;
 BEGIN
 ASSEMBLER
'MOVE.L D3,-(A7)
'MOVE.L -(A3),D0
'BEQ    CMERR
'MOVE.L -(A3),D1
'CLR.L  D2
'MOVE.L D0,D3
'BMI    CMOD2
 !CMOD1 CMP.L  D0,D1
'BLS    CMOD2
'ADDQ   #1,D2
'ASL.L  #1,D0
'BPL    CMOD1
 !CMOD2 CMP.L  D0,D1
'BCS    CMOD3
'SUB.L  D0,D1
 !CMOD3 LSR.L  #1,D0
'CMP.L  D1,D3
'DBHI   D2,CMOD2
'
'MOVE.L D1,(A3)+
'MOVE.L (A7)+,D3
'RTS
'
 !CMERR LINK   A5,#0
'TRAP    #6          ; Div by zero
'DC.W    -5-$4000
'CLR.L   (A3)+
'MOVE.L (A7)+,D3
'UNLK   A5
#END
 END @CMOD;
 
 PROCEDURE @ASGN;
 BEGIN
#ASSEMBLER
'MOVE.L   -(A3),A0
$!X MOVE.W   (A0)+,(A4)+
'DBF      D0,X
#END
 END @ASGN;
 
 PROCEDURE @STAS;
 (* D0: LAENGE DES SOURCESTRING/BYTE; D1: LAENGE DEST.STRING/BYTE *)
 BEGIN
#ASSEMBLER
'MOVE.L  A3,A0
'MOVE.L  D0,D2
'ADDQ.L  #1,D0     ; D0 als StackOffset: muss synch. werden!
'ANDI.W  #$FFFE,D0 ; nicht BCLR verwenden, sonst Fehler bei DBEQ (unten)
'SUBA.L  D0,A0     ; A0 zeigt auf Sourcestring
'BRA     y
$
$z  SWAP    D1        ;*** Kopierschleife
$x  SUBQ.L  #1,D2
'BCS     ok2       ; Source-Ende, Dest. muss Endmarke bekommen
'MOVE.B  (A0)+,(A4)+
$y  DBEQ    D1,x
'BEQ     ok        ; Endmarke der Source wurde eben kopiert
'SWAP    D1
'DBF     D1,z
'
'TST.L   D2        ;*** Ende der Schleife, weil Dest voll
'BEQ     ok        ; Source komplett kopiert (hatte keine Endmarke)
'TST.B   (A0)
'BEQ     ok        ; sonst muss die Endmarke das naechste Zeichen sein
'SUBA.L  D0,A3     ; leider nein: String Overflow
'TRAP    #6
'DC.W    -8-$4000
#ok2 CLR.B   (A4)+
#ok  SUBA.L  D0,A3
#END
 END @STAS;
 
 
 PROCEDURE @COPY;
"BEGIN
$ASSEMBLER
&move.l  (a7)+,A1          ;Ruecksprung-Adr
&
&; Platzbedarf ausrechnen
&
&move.w  -2(a3),d1         ;High-Wert
&addq.w  #1,d1             ;Anzahl Elemente
&mulu    d0,d1             ; * Elementlaenge = Anzahl Bytes
&addq.l  #1,d1             ;synchronisieren
&bclr    #0,d1
&
&; Platz reservieren, Pointer bereitstellen
&
&suba.l  d1,a7
&movea.l -6(a3),A2         ;^ Source-Daten
&move.l  a7,-6(a3)         ;neuer ^ Kopie
&movea.l a7,a0             ;^ fuer Kopierschleife
&move.l  d1,-(a7)          ;fuer Release
&
&; Kopierschleife
&
&bra     lp2
!lp1  swap    d1
!lp   move.b  (A2)+,(a0)+       ;schoen langsam umkopieren...
!lp2  dbf     d1,lp
&swap    d1
&dbf     d1,lp1
&
&jmp     (A1)              ;zurueck zum Aufrufer
$END
"END @COPY;
 
 
 PROCEDURE @COPS;
"BEGIN
$ASSEMBLER
&move.l  (a7)+,A1          ;Ruecksprung-Adr
&move.l  (a7)+,d2          ;Adresse der zu rufenden Prozedur retten
&
&; Platzbedarf ausrechnen
&
&move.w  -2(a3),d1         ;High-Wert
&addq.w  #1,d1             ;Anzahl Elemente
&mulu    d0,d1             ; * Elementlaenge = Anzahl Bytes
&addq.l  #1,d1             ;synchronisieren
&bclr    #0,d1
&
&; Platz reservieren, Pointer bereitstellen
&
&suba.l  d1,a7
&movea.l -6(a3),A2         ;^ Source-Daten
&move.l  a7,-6(a3)         ;neuer ^ Kopie
&movea.l a7,a0             ;^ fuer Kopierschleife
&move.l  d1,-(a7)          ;fuer Release
&
&; Kopierschleife
&
&bra     lp2
!lp1  swap    d1
!lp   move.b  (A2)+,(a0)+       ;schoen langsam umkopieren...
!lp2  dbf     d1,lp
&swap    d1
&dbf     d1,lp1
&
&move.l  d2,-(a7)
&jmp     (A1)              ;zurueck zum Aufrufer
$END
"END @COPS;
 
 PROCEDURE @SCAS; END @SCAS;
 
 PROCEDURE @RES1;  (* Procedure Entry ohne Priority *)
"BEGIN
$ASSEMBLER
(; Null-Link (keine Parameter, keine lok. Vars), norm. $200 Stack-Check
(LEA     $200(A3),A0
(CMPA.L  A7,A0
(BCC     stackerror
&cont
(MOVE.L  (A7)+,A0
(LINK    A5,#$0000
(MOVE.L  A7,A2
(MOVEM.L A4/A6,-(A7)
(MOVE.L  A2,A6
(JMP     (A0)
&stackerror
(TRAP    #6
(DC.W    $BFF6    ; Stack overflow, caller caused
(BRA     cont
$END
"END @RES1;
 
 PROCEDURE @RES2;  (* Procedure Entry ohne Priority *)
"BEGIN
$ASSEMBLER
(; D0.W: Link-Wert
(; als Stacksicherheitswert wird $200 angenommen
(LEA     $200(A3),A0
(ADDA.W  D0,A0
(CMPA.L  A7,A0
(BCC     stackerror
&cont
(MOVE.L  (A7)+,A0
(; LINK #<D0>,A5:
(MOVE.L  A5,-(A7)
(MOVE.L  A7,A5
(SUBA.W  D0,A7
(
(MOVE.L  A7,A2
(MOVEM.L A4/A6,-(A7)
(MOVE.L  A2,A6
(JMP     (A0)
&stackerror
(TRAP    #6
(DC.W    $BFF6    ; Stack overflow, caller caused
(BRA     cont
$END
"END @RES2;
 
 PROCEDURE @RES3; END @RES3;
 PROCEDURE @RES4; END @RES4;
 PROCEDURE @RES5; END @RES5;
 PROCEDURE @RES6; END @RES6;
 PROCEDURE @RES7; END @RES7;
 PROCEDURE @RES8; END @RES8;
 PROCEDURE @RES9; END @RES9;
 
 
 PROCEDURE CAP (ch: CHAR): CHAR;
 BEGIN
"ASSEMBLER
(CLR     D0
(MOVE.B  -2(A3),D0
(LEA     tab(PC),A0
(MOVE.B  0(A0,D0.W),-2(A3)
(RTS
"
"tab:  DC.B $00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F
(DC.B $10,$11,$12,$13,$14,$15,$16,$17,$18,$19,$1A,$1B,$1C,$1D,$1E,$1F
(DC.B ' ','!','"','#','$','%','&',$27,'(',')','*','+',',','-','.','/'
(DC.B '0','1','2','3','4','5','6','7','8','9',':',';','<','=','>','?'
(DC.B '@','A','B','C','D','E','F','G','H','I','J','K','L','M','N','O'
(DC.B 'P','Q','R','S','T','U','V','W','X','Y','Z','[','\',']','^','_'
(DC.B '`','A','B','C','D','E','F','G','H','I','J','K','L','M','N','O'
(DC.B 'P','Q','R','S','T','U','V','W','X','Y','Z','{','|','}','~',''
(DC.B '','','','A','','','','','E','E','E','I','I','I','',''
(DC.B '','','','O','','O','U','U','','','','','','','',''
(DC.B 'A','I','O','U','','','','','','','','','','','',''
(DC.B '','','','','','','','','','','','','','','',''
(DC.B '','','','','','','','','','','','','','','',''
(DC.B '','','','','','','','','','','','','','','',''
(DC.B '','','','','','','','','','','','','','','',''
(DC.B '','','','','','','','','','','','','','','',''
"END
 END CAP;
 
 
 PROCEDURE CHR (c: WORD): CHAR;
 BEGIN ASSEMBLER
(MOVE.B  -(A3),D0        ;Low-Byte wird Char
(TST.B   -(A3)
(BEQ     ok              ;High-Byte muss 0 sein
(LINK    A5,#0
(TRAP    #6
(DC.W    -7-$4000 ;Overflow
(UNLK    A5
#ok   MOVE.B  D0,(A3)+
(CLR.B   (A3)+
'END
 END CHR;
 
 PROCEDURE HALT;
 BEGIN
"ASSEMBLER
(LINK    A5,#0
(TRAP    #6
(DC.W    -11-$4000       ; HALT
(UNLK    A5
"END
 END HALT;
 
 PROCEDURE FLOAT(i: LONGCARD): LONGREAL;
 BEGIN
"ASSEMBLER
 (*$? ~A68881 & ~M68881:
&MOVE.W #$0102,D0  ;Exponent 32
&MOVE.L -(A3),D1
&BEQ    ZERO
&BMI    Large      ;ist linksbndig
 POS   SUBQ.W #8,D0      ;linksbndig machen
&LSL.L  #1,D1
&BPL    POS
 Large SWAP   D0
&SWAP   D1
&MOVE.W D1,D0
&CLR.W  D1
&MOVE.L D0,(A3)+
&MOVE.L D1,(A3)+
&RTS
 !ZERO CLR.L (A3)+
&CLR.L (A3)+
 *)
 (*$? M68881:
(FMOVE.L -(A3),FP0    ; kein Runtime-Fehler mglich
(FMOVE.D FP0,(A3)+
 *)
 (*$? A68881:
(; FMOVE.L -(A3),FP0    ; kein Runtime-Fehler mglich
(MOVE.W  #$4000,fpcmd
 DoDl1   TST.B   fpstatlo
(BEQ     DoDl1
(MOVE.L  -(A3),fpop
(; FMOVE.D FP0,(A3)+
(MOVE.W  #$7400,fpcmd
 DoDl3   MOVE.B  fpstatlo,D0
(BEQ     DoDl3
(MOVE.L  fpop,(A3)+
(MOVE.L  fpop,(A3)+
(TST.B   fpstatlo
 *)
"END
 END FLOAT;
 
 PROCEDURE TRUNC(r: LONGREAL): LONGCARD;
 BEGIN
"ASSEMBLER
 (*$? ~A68881 & ~M68881:
'LINK   A5,#0
'MOVEM.L D3-D4,-(A7)
 
'MOVE.L -(A3),D0
'MOVE.L -(A3),D1
'SWAP   D1
'BTST   #0,D1
'BNE    nega      ;Zahl ist negativ -> Fehler
'ASR.W  #3,D1
'MOVE.W #32,D4
'SUB.W  D1,D4
'BLT    Err       ;Exponent war > 32: 0.FFF.. * 2^32 ist MaxLCard
'CMP.W  #32,D4
'BCC    ZERO      ;Exponent war <= 0
'MOVE.L D1,D2
'SWAP   D0
'MOVE.W D0,D2
'LSR.L  D4,D2
'BRA    X
!!ZERO CLR.L  D2
!!X    MOVE.L D2,(A3)+
'MOVEM.L (A7)+,D3-D4
'UNLK   A5
'RTS
 
!!NEGA TRAP    #6
'DC.W    -6-$4000          ; Out of range: Arg. ist negativ
'BRA     cont
!!ERR  TRAP    #6
'DC.W    -7-$4000          ; Overflow: Arg. ist > MaxLCard
!!CONT CLR.L   (A3)+
'MOVEM.L (A7)+,D3-D4
'UNLK   A5
 *)
 (*$? M68881:
(; !!! Abfrage auf neg. Ergebnis und berlauf fehlt noch!
(FINTRZ.D -(A3),FP0
(FMOVE.L  FP0,(A3)+
 *)
 (*$? A68881:
(; !!! Abfrage auf neg. Ergebnis fehlt noch!
(; FINTRZ.D -(A3),FP0
(MOVE.W  #$5403,fpcmd
 DoDl1   MOVE.B  fpstatlo,D0
(BEQ     DoDl1
(CMPI.B  #8,D0
(BNE     error2
(MOVE.L  -8(A3),fpop
(MOVE.L  -(A3),fpop
(SUBQ.L  #4,A3
(; FMOVE.L  FP0,(A3)+
(MOVE.W  #$6000,fpcmd
 DoDl3   MOVE.B  fpstatlo,D0
(BEQ     DoDl3
(CMPI.B  #2,D0
(BNE     error
(MOVE.L  fpop,(A3)+
(TST.B   fpstatlo
(RTS
 error2  SUBQ.L  #8,A3
 error   LINK    A5,#0
(JSR     FPUError
(UNLK    A5
(CLR.L   (A3)+
 *)
"END
 END TRUNC;
 
 
 (*$? A68881:
 PROCEDURE DoComp;
 BEGIN
"ASSEMBLER
+LEA     -16(A3),A3
+MOVE.L  A3,A0
+MOVE.W  #$5400,fpcmd
"!DoCl1   TST.B   fpstatlo
+BEQ     DoCl1
+MOVE.L  (A0)+,fpop
+MOVE.L  (A0)+,fpop
+MOVE.W  #$5438,fpcmd        ;FCMP  ?,FP0
"!DoCl2   MOVE.B  fpstatlo,D0
+BEQ     DoCl2
+CMPI.B  #8,D0
+BNE     DoCError
+MOVE.L  (A0)+,fpop
+MOVE.L  (A0)+,fpop
+MOVE.W  D1,fpcond
+CLR.W   D0
+MOVE.B  fpstatlo,D0
+MOVE.W  D0,(A3)+
+RTS
"!DoCError
+LINK    A5,#0
+JSR     FPUError
+UNLK    A5
+CLR     (A3)+
"END;
 END DoComp;
 *)
 
 
 PROCEDURE @RELE (a,b:LONGREAL):BOOLEAN;        (* Op1 <= Op2, neu *)
 BEGIN ASSEMBLER
&(*$? ~A68881:
(MOVEM.L D3/D4,-(A7)
(MOVEQ  #16,D4
(MOVE.L -(A3),D0    ;zweiter Operand
(MOVE.L -(A3),D1
(BEQ    zer2
(MOVE.L -(A3),D2    ;erster Operand
(MOVE.L -(A3),D3
(BEQ    zer1
(BTST   D4,D3
(BNE    neg1        ;Op1 negativ
(BTST   D4,D1
(BNE    neg2        ;Op2 negativ
(CMP.L  D1,D3       ;beide Operanden positiv
(BLT    neg3
(BGT    neg2
(CMP.L  D0,D2
(BLS    neg3
(BRA    neg2
!neg1   BTST   D4,D1
(BEQ    neg3        ;Op1 negativ, Op2 positiv
(CMP.L  D3,D1
(BLT    neg3
(BGT    neg2
(CMP.L  D2,D0
(BLS    neg3
!neg2   CLR.W  (A3)+       ;Op1 positiv, Op2 negativ
(MOVEM.L (A7)+,D3/D4
(RTS
!zer2   SUBQ.L #4,A3       ;Op2 Null, Op1 <= 0 ?
(MOVE.L -(A3),D3
(BEQ    neg3        ;Op1 = Op2 = 0
(BTST   D4,D3
(BNE    neg3        ;Op2 = 0; Op1 < 0
(BRA    neg2
!zer1   BTST   D4,D1       ;Op1 Null, Op2 # 0: ist Op2 < 0?
(BNE    neg2        ; ja
!neg3   MOVEM.L (A7)+,D3/D4
(MOVE.W #TRUE,(A3)+
&*)
&(*$? A68881:
(MOVE.W #$15,D1     ;Conditional LE
(JMP    DoComp
&*)
'END
 END @RELE;
 
 PROCEDURE @REGE (a,b:LONGREAL):BOOLEAN;
 BEGIN ASSEMBLER
&(*$? ~A68881:
(MOVEM.L D3/D4,-(A7)
(MOVEQ  #16,D4
(MOVE.L -(A3),D0    ;zweiter Operand
(MOVE.L -(A3),D1
(BEQ    zer2
(MOVE.L -(A3),D2    ;erster Operand
(MOVE.L -(A3),D3
(BEQ    zer1
(BTST   D4,D3
(BNE    neg1        ;Op1 negativ
(BTST   D4,D1
(BNE    neg2        ;Op2 negativ
(CMP.L  D1,D3       ;beide Operanden positiv
(BLT    neg3
(BGT    neg2
(CMP.L  D0,D2
(BCS    neg3
(BRA    neg2
!neg1   BTST   D4,D1
(BEQ    neg3        ;Op1 negativ, Op2 positiv
(CMP.L  D3,D1
(BLT    neg3
(BGT    neg2
(CMP.L  D2,D0
(BCS    neg3
!neg2   MOVE.W #true,(A3)+ ;Op1 positiv, Op2 negativ
(MOVEM.L (A7)+,D3/D4
(RTS
!zer2   SUBQ.L #4,A3       ;Op2 Null, Op1 <= 0 ?
(MOVE.L -(A3),D3
(BEQ    neg2        ;beide Null
(BTST   D4,D3
(BNE    neg3        ;Op2 = 0, Op1 < 0
(BRA    neg2        ;Op2 = 0, Op1 > 0
!zer1   BTST   D4,D1       ;Op1 = 0, Op2 # 0: ist Op2 > 0?
(BNE    neg2        ; nein
!neg3   CLR.W  (A3)+       ;Op1 negativ, Op2 positiv
(MOVEM.L (A7)+,D3/D4
&*)
&(*$? A68881:
(MOVE.W #$13,D1     ;Conditional GE
(JMP    DoComp
&*)
#END
 END @REGE;
 
 PROCEDURE @RELT (a,b:LONGREAL):BOOLEAN;
 BEGIN ASSEMBLER
&(*$? ~A68881:
(MOVEM.L D3/D4,-(A7)
(MOVEQ  #16,D4
(MOVE.L -(A3),D0    ;zweiter Operand
(MOVE.L -(A3),D1
(BEQ    zer2
(MOVE.L -(A3),D2    ;erster Operand
(MOVE.L -(A3),D3
(BEQ    zer1
(BTST   D4,D3
(BNE    neg1        ;Op1 negativ
(BTST   D4,D1
(BNE    neg2        ;Op2 negativ
(CMP.L  D1,D3       ;beide Operanden positiv
(BLT    neg3
(BGT    neg2
(CMP.L  D0,D2
(BCS    neg3
(BRA    neg2
!neg1   BTST   D4,D1
(BEQ    neg3        ;Op1 negativ, Op2 positiv
(CMP.L  D3,D1
(BLT    neg3
(BGT    neg2
(CMP.L  D2,D0
(BCS    neg3
!neg2   CLR.W  (A3)+       ;Op1 positiv, Op2 negativ
(MOVEM.L (A7)+,D3/D4
(RTS
!zer2   SUBQ.L #4,A3       ;Op2 Null, Op1 <= 0 ?
(MOVE.L -(A3),D3
(BEQ    neg2        ;beide Null
(BTST   D4,D3
(BNE    neg3        ;Op2 = 0, Op1 < 0
(BRA    neg2        ;Op2 = 0, Op1 > 0
!zer1   BTST   D4,D1       ;Op1 = 0, Op2 # 0: ist Op2 > 0?
(BNE    neg2        ; nein
!neg3   MOVE.W #TRUE,(A3)+ ;Op1 negativ, Op2 positiv
(MOVEM.L (A7)+,D3/D4
&*)
&(*$? A68881:
(MOVE.W #$14,D1     ;Conditional LT
(JMP    DoComp
&*)
&END
 END @RELT;
 
 PROCEDURE @REGT (a,b:LONGREAL):BOOLEAN;
 BEGIN
"ASSEMBLER
"(*$? ~A68881:
(MOVEM.L D3/D4,-(A7)
(MOVEQ  #16,D4
(MOVE.L -(A3),D0    ;zweiter Operand
(MOVE.L -(A3),D1
(BEQ    zer2
(MOVE.L -(A3),D2    ;erster Operand
(MOVE.L -(A3),D3
(BEQ    zer1
(BTST   D4,D3
(BNE    neg1        ;Op1 negativ
(BTST   D4,D1
(BNE    neg2        ;Op2 negativ
(CMP.L  D1,D3       ;beide Operanden positiv
(BLT    neg3
(BGT    neg2
(CMP.L  D0,D2
(BLS    neg3
(BRA    neg2
!neg1   BTST   D4,D1
(BEQ    neg3        ;Op1 negativ, Op2 positiv
(CMP.L  D3,D1
(BLT    neg3
(BGT    neg2
(CMP.L  D2,D0
(BLS    neg3
!neg2   MOVE.W #true,(A3)+ ;Op1 positiv, Op2 negativ
(MOVEM.L (A7)+,D3/D4
(RTS
!zer2   SUBQ.L #4,A3       ;Op2 Null, Op1 <= 0 ?
(MOVE.L -(A3),D3
(BEQ    neg3        ;beide Null
(BTST   D4,D3
(BNE    neg3        ;Op2 = 0, Op1 < 0
(BRA    neg2        ;Op2 = 0, Op1 > 0
!zer1   BTST   D4,D1       ;Op1 = 0, Op2 # 0: ist Op2 > 0?
(BNE    neg2        ; nein
!neg3   CLR.W  (A3)+       ;Op1 negativ, Op2 positiv
(MOVEM.L (A7)+,D3/D4
!*)
!(*$? A68881:
(MOVE.W #$12,D1     ;Conditional GT
(JMP    DoComp
!*)
&END
 END @REGT;
 
 
 (********* Real-Arithmetik *********)
 PROCEDURE @RNEG (a:LONGREAL):LONGREAL;
 BEGIN
"ASSEMBLER
"(*$? ~A68881:
(TST.W  -8(A3)
(BEQ    ZERO
(BCHG   #0,-7(A3)
"!ZERO
"*)
"(*$? A68881:
(TST     -8(A3)
(BEQ     zero
(BCHG    #7,-8(A3)
"!zero RTS
"*)
$RTS
"END
 END @RNEG;
 
 (*$? A68881:
 PROCEDURE DoDouble;
 (* Erwartet in Register D1 eine Co-Instruction *)
 BEGIN
"ASSEMBLER
+LEA     -16(A3),A3
+MOVE.L  A3,A0
+MOVE.W  #$5400,fpcmd
"!DoDl1   TST.B   fpstatlo
+BEQ     DoDl1
+MOVE.L  (A0)+,fpop
+MOVE.L  (A0)+,fpop
+MOVE.W  D1,fpcmd
"!DoDl2   TST.B   fpstatlo
+BEQ     DoDl2
+MOVE.L  (A0)+,fpop
+MOVE.L  (A0)+,fpop
+MOVE.W  #$7400,fpcmd
"!DoDl3   MOVE.B  fpstatlo,D0
+BEQ     DoDl3
+CMPI.B  #8,D0
+BNE     DoDErr
"!GoBack  MOVE.L  fpop,(A3)+
+MOVE.L  fpop,(A3)+
+MOVE.W  fpstat,D0
+CMPI.B  #2,D0
+BNE     DoDErr2
+RTS
"!DoDErr2 SUBQ.L  #8,A3
"!DoDErr  LINK    A5,#0
+JSR     FPUError
+UNLK    A5
+CLR.L   (A3)+        ; RETURN 0.0
+CLR.L   (A3)+
"END;
 END DoDouble;
 *)
 
 PROCEDURE @RMUL (a,b:LONGREAL):LONGREAL;
 BEGIN
"ASSEMBLER
"(*$? ~A68881:
+LINK    A5,#0
+MOVEM.L D3-D7,-(A7)
+MOVEM.W -16(A3),D0-D7
+TST.W   D0           ;Op1 = 0 ?
+BEQ.L   ZERO
+TST.W   D4           ;Op2 = 0 ?
+BEQ.L   ZERO
+ADD.W   D0,D4        ;vorl. Exponent; neues Sign in bit0
+BVS.L   range        ;Ueber/Unterlauf
+MOVE.W  D4,-(A7)
+MOVE.W  D3,D4
+MULU    D7,D4
+CLR.W   D4
+SWAP    D4
+CLR.W   D5
+MOVE.W  D3,D0
+MULU    D6,D0
+ADD.L   D0,D4
+BCC     L0
+ADDQ.W  #1,D5
"!L0      MOVE.W  D2,D0
+MULU    D7,D0
+ADD.L   D0,D4
+BCC     L1
+ADDQ.W  #1,D5
"!L1      MOVE.W  D5,D4
+SWAP    D4
+CLR.W   D5
+MULU    D1,D7
+ADD.L   D7,D4
+BCC     L2
+ADDQ.W  #1,D5
"!L2      MOVE.W  -6(A3),D7
+MOVE.W  D2,D0
+MULU    D6,D0
+ADD.L   D0,D4
+BCC     L3
+ADDQ.W  #1,D5
"!L3      MULU    D7,D3
+ADD.L   D3,D4
+BCC     L4
+ADDQ.W  #1,D5
"!L4      MOVE.W  D4,D3
+MOVE.W  D5,D4
+SWAP    D4
+CLR.W   D5
+MULU    D7,D2
+ADD.L   D2,D4
+BCC     L5
+ADDQ.W  #1,D5
"!L5      MULU    D1,D6
+ADD.L   D6,D4
+BCC     L6
+ADDQ.W  #1,D5
"!L6      MOVE.W  D4,D6
+MOVE.W  D5,D4
+SWAP    D4
+MULU    D7,D1
+
+MOVE.W  (A7)+,D7
+ADD.L   D1,D4
+BMI     ISADJ
+ADD.W   D3,D3
+ADDX.W  D6,D6
+ADDX.L  D4,D4
+SUBQ.W  #8,D7
+BVS     ZERO
"!ISADJ   TST.W   D3
+BPL     NORND
+ADDQ.W  #1,D6
+BCC     NORND
+ADDQ.L  #1,D4
+BCC     NORND
+ADDQ.W  #8,D7
+BSET    #31,D4
"!NORND   BSET    #1,D7        ;markiere als # 0
+BCLR    #2,D7        ;loesche Schutzbit
+SUBA.W  #16,A3
+MOVE.W  D7,(A3)+
+MOVE.L  D4,(A3)+
+MOVE.W  D6,(A3)+
+MOVEM.L (A7)+,D3-D7
+UNLK    A5
+RTS
+
"range    BMI     ovfl         ;Summe der Exponenten war so gross,
@;dass sie ins negative ueberlief
"zero     SUBA.W  #16,A3
+CLR.L   (A3)+
+CLR.L   (A3)+
+MOVEM.L (A7)+,D3-D7
+UNLK    A5
+RTS
+
"ovfl     SUBA.W  #16,A3
+TRAP    #6
+DC.W    -7-$4000     ;overflow
+CLR.L   (A3)+
+CLR.L   (A3)+
+MOVEM.L (A7)+,D3-D7
+UNLK    A5
"*)
"(*$? A68881:
+MOVE.W  #$5423,D1
+JMP     DoDouble
"*)
"END
 END @RMUL;
 
 
 PROCEDURE @RDIV (a,b:LONGREAL):LONGREAL;
 BEGIN
"ASSEMBLER
"(*$? ~A68881:
(LINK    A5,#0
(MOVEM.L D3-D7,-(A7)
(MOVE.W  -(A3),D5
(MOVE.L  -(A3),D4
(MOVE.W  -(A3),D1
(MOVE.W  -(A3),D3
(MOVE.L  -(A3),D2
(MOVE.W  -(A3),D0
(JSR     @FPDIV
(MOVEM.L (A7)+,D3-D7
(UNLK    A5
"*)
"(*$? A68881:
'MOVE.W   #$5420,D1
'JMP      DoDouble
"*)
"END
 END @RDIV;
 
 PROCEDURE @FPDIV;
 BEGIN
"ASSEMBLER
"(*$? ~A68881:
+TST.W   D0
+BEQ.L   ZERO1
+TST.W   D1
+BEQ.L   DIVBY0
+BCLR    #1,D1        ; !TT 01.04.88
+SUB.W   D1,D0        ;vorl. Exponent und Sign in D0
+BVS.L   range        ;Ueber/Unterlauf
+CLR.L   D7
+MOVEQ   #49,D1
+BRA     L1
"!L0      ADD.L   D7,D7
+ADDX.L  D6,D6
+ADD.W   D3,D3
+ADDX.L  D2,D2
+BCS     ONEBIT
"!L1      CMP.L   D2,D4
+BHI     ZERBIT
+BNE     ONEBIT
+CMP.W   D3,D5
+BHI     ZERBIT
"!ONEBIT  SUB.W   D5,D3
+SUBX.L  D4,D2
+ADDQ.B  #1,D7
"!ZERBIT  DBF     D1,L0
+BTST    #17,D6
+BEQ     LESS05
+LSR.L   #1,D6
+ROXR.L  #1,D7
+ADDQ.W  #8,D0
+BVS     ovfl
"!LESS05  LSR.L   #1,D6
+ROXR.L  #1,D7
+BCC     NORND
+ADDQ.L  #1,D7
+BCC     NORND
+ADDQ.W  #1,D6
+BCC     NORND
+ROXR.W  #1,D6
+ADDQ.W  #8,D0
+BVS     ovfl
"noRnd    BSET    #1,D0
+BCLR    #2,D0
+MOVE.W  D0,(A3)+
+MOVE.W  D6,(A3)+
+MOVE.L  D7,(A3)+
+RTS
+
"range    BMI     ovfl         ;Differenz der Exponenten war so gross,
@;dass sie ins negative ueberlief
"zero1    CLR.L   (A3)+
+CLR.L   (A3)+
+RTS
+
"ovfl     TRAP    #6
+DC.W    -7-$4000     ;overflow
+BRA     errend
+
"DivBy0   TRAP    #6
+DC.W    -5-$4000
"errend:  CLR.L   (A3)+
+CLR.L   (A3)+
"*)
"(*$? A68881:
+MOVE.W  D0,(A3)+
+MOVE.L  D2,(A3)+
+MOVE.W  D3,(A3)+
+MOVE.W  D1,(A3)+
+MOVE.L  D4,(A3)+
+MOVE.W  D5,(A3)+
+MOVE.W  #$5420,D1
+JMP     DoDouble
"*)
"END
 END @FPDIV;
 
 
 PROCEDURE @RADD (a,b:LONGREAL):LONGREAL;
 BEGIN
%ASSEMBLER
%(*$? ~A68881:
+LINK    A5,#0
+MOVEM.L D3-D7,-(A7)
+MOVEM.W -16(A3),D0-D7
+SWAP    D1
+MOVE.W  D2,D1        ;hchste 32 Mant.-Stellen (a) in D1
+SWAP    D5
+MOVE.W  D6,D5        ;hchste 32 Mant.-Stellen (b) in D5
+
+ANDI.W  #$FFFE,D0
+BEQ.L   RETN2        ;ein Argument ist 0
+ANDI.W  #$FFFE,D4
+BEQ.L   RETN1        ;ein Argument ist 0
+CLR.W   D6
+CMP.W   D0,D4
+BLT     PASST
+BNE     TAUSCH
+CMP.L   D1,D5
+BCS.L   PASST1
+BNE     TAUSCH
+CMP.W   D3,D7
+BLS.L   PASST1
"!TAUSCH  EXG     D0,D4
+EXG     D1,D5
+EXG     D3,D7
+MOVE.W  -16(A3),D2
+MOVE.W  -8(A3),-16(A3)
+MOVE.W  D2,-8(A3)
"
"!PASST   SUB.W   D4,D0        ;Exp.differenz immer positiv!
+LSR     #3,D0
+BEQ.L   PASST1
+CMP.W   #16,D0
+BEQ     S16
+BHI     SGT16
+SWAP    D7
+MOVE.W  D5,D7
+SWAP    D7
+LSR.L   D0,D5
+LSR.L   D0,D7
+BRA.L   DONE
"!S16     ADD.W   D7,D7
+MOVE.W  D5,D7
+CLR.W   D5
+SWAP    D5
+BRA     DONE
"!SGT16   CMP.W   #32,D0
+BEQ     S32
+BHI     SGT32
+SUB.W   #16,D0
+LSR.L   D0,D5
+MOVE.W  D5,D7
+CLR.W   D5
+SWAP    D5
+BRA     DONE
"!S32     ADD.W   D5,D5
+SWAP    D5
+MOVE.W  D5,D7
+CLR.L   D5
+BRA     DONE
"!S48     CLR.L   D5
+CLR.W   D7
+MOVEQ   #$FF,D6
+BRA     PASST1
"!SGT32   CMP.W   #48,D0
+BEQ     S48
+BHI.L   RETN1
+SUB.W   #32,D0
+SWAP    D5
+MOVE.W  D5,D7
+CLR.L   D5
+LSR.W   D0,D7
"!DONE    ROXR.W  #1,D6
"!PASST1  MOVE.W  -16(A3),D2   ;Vorzeichen beider Operanden gleich?
+MOVE.W  -8(A3),D0
+ADD.W   D2,D0
+BTST    #0,D0
+BNE     SUBTR
+ADD.W   D7,D3
+ADDX.L  D5,D1
+BCC     NOFL
+ROXR.L  #1,D1
+ROXR.W  #1,D3
+BCC     INCEX
+ADDQ.W  #1,D3
+BCC     INCEX
+ADDQ.L  #1,D1
"!INCEX   ADDQ.W  #8,D2        ;D2 ist Exp. der betr.mig greren Zahl
+BVS.L   OVFL
"!FERTIG  SUBA.W  #16,A3
+MOVE.W  D2,(A3)+
+MOVE.L  D1,(A3)+
+MOVE.W  D3,(A3)+
+MOVEM.L (A7)+,D3-D7
+UNLK    A5
+RTS
+
"!NOFL    TST.W   D6
+BPL     FERTIG
+ADDQ.W  #1,D3
+BCC     FERTIG
+ADDQ.L  #1,D1
+BCC     FERTIG
+ROXR.L  #1,D1
+BRA     INCEX
"
"!SUBTR   ADD.W   D6,D6
+SCS     D6
+SUBX.W  D7,D3
+SUBX.L  D5,D1
+TST.L   D1
+BMI     FERTIG
+SUBQ.W  #8,D2
+ADD.W   D6,D6
+ADDX.W  D3,D3
+ADDX.L  D1,D1
+BMI.L   fertig
+BEQ     LGT32        ;Ausloeschung in der Mantisse.. normalisieren
+SWAP    D1
+TST.W   D1
+BNE     LLT16
+MOVE.W  D3,D1
+CLR.W   D3
+SUB.W   #128,D2      ;8 * (16 bit Shift)
+BVS     zero
+TST.L   D1
+BMI     fertig
"!L0      SUBQ.W  #8,D2
+BVS     zero
+ADD.L   D1,D1
+BPL     L0
+BRA     fertig
"!LLT16   SWAP    D1
"!L1      SUBQ.W  #8,D2
+BVS     zero
+ADD.W   D3,D3
+ADDX.L  D1,D1
+BPL     L1
+BRA     fertig
"!LGT32   SUB.W   #256,D2      ;8 * (32 bit Shift)
+BVS     zero
+MOVE.W  D3,D1
+BEQ.L   ZERO
+BMI     L3
"!L2      SUBQ.W  #8,D2
+BVS     zero
+ADD.W   D1,D1
+BPL     L2
"!L3      SWAP    D1
+CLR.W   D3
+BRA     fertig
"!ZERO    SUBA.W  #16,A3
+CLR.L   (A3)+
+CLR.L   (A3)+
+MOVEM.L (A7)+,D3-D7
+UNLK    A5
+RTS
+
"!RETN1   SUBA.W  #14,A3       ;Exponent stimmt schon
+MOVE.L  D1,(A3)+     ;Mantisse mu (bei Ausgang 2 hierher)
+MOVE.W  D3,(A3)+     ; noch getauscht werden!
+MOVEM.L (A7)+,D3-D7
+UNLK    A5
+RTS
+
"!RETN2   MOVE.L  -(A3),-8(A3)
+MOVE.L  -(A3),-8(A3)
+MOVEM.L (A7)+,D3-D7
+UNLK    A5
+RTS
+
"!OVFL    TRAP    #6
+DC.W    -7-$4000      ;overflow
+BRA     ZERO
"*)
"(*$? A68881:
+MOVE.W  #$5422,D1
+JMP     DoDouble
"*)
"END
 END @RADD;
 
 PROCEDURE @RSUB (a,b:LONGREAL):LONGREAL;
 BEGIN
"ASSEMBLER
"(*$? ~A68881:
$TST.W  -8(A3)
$BEQ    N
$BCHG   #0,-7(A3)
"N JMP    @RADD
"*)
"(*$? A68881:
$MOVE.W #$5428,D1
$JMP    DoDouble
"*)
"END
 END @RSUB;
 
 
 BEGIN
"has020:= SysInfo.Has020 ();
 (*$? A68881:
"FPUInit
 *)
 END Runtime.
 
(* $00000A8D$FFFB3F34$FFFB3F34$FFFB3F34$FFFB3F34$FFFB3F34$FFFB3F34$FFFB3F34$FFFB3F34$FFFB3F34$FFFB3F34$FFFB3F34$FFFB3F34$FFFB3F34$FFFB3F34$FFEE685A$FFFB3F34$FFFB3F34$FFFB3F34$FFFB3F34$FFFB3F34$FFFB3F34$FFFB3F34$FFFB3F34$FFFB3F34$FFFB3F34$FFFB3F34$FFFB3F34$FFFB3F34$FFFB3F34$FFFB3F34$FFFB3F34$FFFB3F34$FFFB3F34$FFFB3F34$FFFB3F34$FFFB3F34$FFFB3F34$FFFB3F34$FFFB3F34$FFFB3F34$FFFB3F34$00000A3FT.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$00000028$FFEE685A$000014A5$00001A0C$00002342$00002CC0$00003461$0000352F$0000372B$00003739$00000A3F$000097A0$00009EAD$00009EB7$0000AC5E$0000AC68*)
