 IMPLEMENTATION MODULE StringEditor;
 
 (*$Y+,H+,R-*)
 
 FROM SYSTEM IMPORT ASSEMBLER;
 
 IMPORT Strings;
 
 FROM MOSGlobals IMPORT Key;
 
 
 PROCEDURE StdKeyCmd (k: Key): Commands;
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE.W  -(A3),D0        ; scan
(SWAP    D0
(CLR     D0
(SUBQ.L  #1,A3           ; ctrl
(MOVE.B  -(A3),D0        ; ch
(LEA     tab(PC),A0
&lup:
(MOVE.L  (A0)+,D1
(MOVE.W  (A0)+,D2
(BEQ     ende
(CMP.L   D1,D0
(BNE     lup
&ende:
(MOVE    D2,(A3)+
(RTS
 
&tab:
(DC.L    $72000D      DC.W    enter
(DC.L    $1C000D      DC.W    enter
(DC.L    $01001B      DC.W    clrln
(DC.L    $610000      DC.W    abort
(DC.L    $520000      DC.W    insert
(DC.L    $4B0000      DC.W    left
(DC.L    $4D0000      DC.W    right
(DC.L    $730000      DC.W    wdleft  (* Ctrl-left  *)
(DC.L    $740000      DC.W    wdright (* Ctrl-right *)
(DC.L    $53007F      DC.W    delete
(DC.L    $0E0008      DC.W    backspace
(DC.L    $470000      DC.W    clreol (* Home *)
(DC.L    $470037      DC.W    clrln  (* Shift-Home *)
(DC.L    $4B0034      DC.W    sol    (* Shift-left  *)
(DC.L    $4D0036      DC.W    eol    (* Shift-right *)
(DC.L    $53001F      DC.W    delwdright (* Ctrl-Delete *)
(DC.L    0            DC.W    none
$END
"END StdKeyCmd;
"(*$L=*)
 
 PROCEDURE StdAscCmd (k: Key): Commands;
"(*$L-*)
"BEGIN
$ASSEMBLER
(SUBQ.L  #3,A3           ; scan, ctrl
(MOVE.B  -(A3),D0        ; ch
(CLR     D2
(LEA     tab(PC),A0
&lup:
(MOVE.B  (A0)+,D1
(MOVE.B  (A0)+,D2
(BEQ     ende
(CMP.B   D1,D0
(BNE     lup
&ende:
(MOVE    D2,(A3)+
(RTS
 
&tab:
(DC.B    13      DC.B    enter
(DC.B    3       DC.B    abort
(DC.B    8       DC.B    backspace
(DC.B    21      DC.B    right
(DC.B    127     DC.B    delete
(DC.B    9       DC.B    eol
(DC.B    27      DC.B    clrln
(DC.B    24      DC.B    clrln
(DC.B    0       DC.B    none
$END
"END StdAscCmd;
"(*$L=*)
 
 PROCEDURE StdWSCmd (k: Key): Commands;
"(*$L-*)
"BEGIN
$ASSEMBLER
(SUBQ.L  #3,A3           ; scan, ctrl
(MOVE.B  -(A3),D0        ; ch
(CLR     D2
(LEA     tab(PC),A0
&lup:
(MOVE.B  (A0)+,D1
(MOVE.B  (A0)+,D2
(BEQ     ende
(CMP.B   D1,D0
(BNE     lup
&ende:
(MOVE    D2,(A3)+
(RTS
 
&tab:
(DC.B    13      DC.B    enter
(DC.B    3       DC.B    abort
(DC.B    8       DC.B    backspace
(DC.B    27      DC.B    clrln
(DC.B    127     DC.B    delete
(DC.B    19      DC.B    left
(DC.B    20      DC.B    delwdright
(DC.B    22      DC.B    insert
(DC.B    1       DC.B    eol
(DC.B    4       DC.B    right
(DC.B    6       DC.B    eol
(DC.B    0       DC.B    none
$END
"END StdWSCmd;
"(*$L=*)
 
 VAR ok: BOOLEAN;
 
 PROCEDURE Edit( VAR dStr: ARRAY OF CHAR; mayCtrl: BOOLEAN;
0hdl_write: WrChProc; hdl_writeString: WrStrProc;
0hdl_moveCursor: CrsrProc; hdl_readCmd: RdProc );
 
"VAR limit, sLen, index: INTEGER;
&finish: BOOLEAN;
 
"PROCEDURE ConsOutRpt( c : CHAR; no : INTEGER );
$VAR i: INTEGER;
$BEGIN
&FOR i:= 1 TO no DO hdl_write(c) END
$END ConsOutRpt;
 
"PROCEDURE DelR;
$BEGIN
&IF index < sLen THEN
(Strings.Delete (dStr,index,1,ok);
(hdl_moveCursor(-index);
(hdl_writeString (dStr);
(hdl_write(' ');
(hdl_moveCursor(-(sLen-index));
(DEC (sLen)
&END
$END DelR;
 
"PROCEDURE ClrEoln;
$BEGIN
&ConsOutRpt(' ',sLen + index);
&hdl_moveCursor(-(sLen-index));
&sLen:= index;
&dStr[sLen]:=0C;
$END ClrEoln;
 
"PROCEDURE pos1;
$BEGIN
&hdl_moveCursor(-index);
&index:= 0;
$END pos1;
 
"VAR i: CARDINAL;
&keycode: Commands;
&ch: CHAR;
 
"BEGIN (* EditString *)
$limit:= HIGH (dStr)+1;
$finish:= FALSE;
$index:= 0;
$sLen:= Strings.Length (dStr);
$hdl_writeString (dStr);
$hdl_moveCursor( -sLen );
$REPEAT
&hdl_readCmd (keycode,ch);
&CASE keycode OF
&|left:
(IF index > 0 THEN
*DEC( index);
*hdl_moveCursor(-1)
(END
&|right:
(IF ( index < sLen) & ( index < limit) THEN
*INC( index);
*hdl_moveCursor(1)
(END
&|backspace:
(IF index > 0 THEN
*DEC( index);
*hdl_moveCursor(-1);
*DelR
(END
&|delete:
(DelR
&|clrln:
(pos1;
(ClrEoln
&|clreol:
(ClrEoln
&|sol:
(pos1;
&|eol:
(hdl_moveCursor (sLen-index);
(index:= sLen
&|enter:
(finish:= TRUE
&|abort:
(pos1;
(ClrEoln;
(finish:= TRUE
&|insert:
(IF (index < sLen) & (sLen < limit) THEN
*Strings.Insert (' ',index,dStr,ok);
*INC (sLen);
*hdl_moveCursor(-index);
*hdl_writeString (dStr);
*hdl_moveCursor (-(sLen-index))
(END;
&|none:
(IF (index<limit) AND (ch#0C) AND (mayCtrl OR (ch>=' ')) THEN
*hdl_write (ch);
*dStr [index]:= ch;
*IF index >= sLen THEN
,INC (sLen);
,IF sLen < limit THEN
.dStr [sLen]:= 0C;
,END
*END;
*INC(index);
(END
&ELSE
((* nix *)
&END;
$UNTIL finish;
$hdl_moveCursor (sLen - index)
"END Edit;
 
 BEGIN
"StdCmd:= StdKeyCmd;
 END StringEditor.
  
(* $00000A7F$FFEE9FCA$FFEE9FCA$FFEE9FCA$FFEE9FCA$FFEE9FCA$FFEE9FCA$FFEE9FCA$FFEE9FCA$FFEE9FCA$FFEE9FCA$FFEE9FCA$FFEE9FCA$FFEE9FCA$FFEE9FCA$00000C53$FFEE9FCA$FFEE9FCA$FFEE9FCA$FFEE9FCA$FFEE9FCA$FFEE9FCA$FFEE9FCA$FFEE9FCA$FFEE9FCA$FFEE9FCA$FFEE9FCA$FFEE9FCA$FFEE9FCA$FFEE9FCA$FFEE9FCA$FFEE9FCA$FFEE9FCA$FFEE9FCA$FFEE9FCA$FFEE9FCA$FFEE9FCA$FFEE9FCA$FFEE9FCA$FFEE9FCA$FFEE9FCA$FFEE9FCA$00000036T.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$000010F4$0000110E$00001128$00001198$0000125B$00000028$00000036$00000D07$00000D76$00000E54$00000E6E$00000E92$00000EEC$00000F4D$00000F98$00001016*)
