 MODULE FAT;
 (*$A+*)
 
 (*
!* Zeigt FAT an, korrigiert ggf.
!*)
 
 FROM InOut IMPORT WriteCard, WriteLn, ReadCard, WriteString;
 IMPORT InOut;
 
 FROM SYSTEM IMPORT ADDRESS, ADR, BYTE, ASSEMBLER;
 
 FROM BIOS IMPORT GetBPB, RWAbs, Read, Write, BPBPtr, ControlKey, GetKBShift;
 
 FROM Block IMPORT Copy;
 
 FROM Storage IMPORT ALLOCATE, DEALLOCATE;
 
 FROM Strings IMPORT String, Relation,
4Empty, Append, Assign, Concat, Length, PosLen, Delete,
4Compare;
 
 IMPORT FastStrings;
 
 FROM Lists IMPORT List,
2ResetList, PrevEntry, DeleteList, CreateList, AppendEntry,
2NoOfEntries, RemoveEntry, CurrentEntry, InsertEntry,
2NextEntry;
 
 FROM Directory IMPORT PathExists, DirEntry, FileAttr, FileAttrSet, DirQuery;
 
 FROM FileNames IMPORT SplitPath, ConcatPath;
 
 FROM StrConv IMPORT CardToStr;
 
 FROM GrafBase IMPORT Point, Rectangle,
5Rect;
 
 FROM GEMGlobals IMPORT GemChar, MouseButton, MButtonSet, SpecialKeySet, MaxStr;
 
 FROM AESEvents IMPORT RectEnterMode, Event;
 
 FROM EventHandler IMPORT EventProc,
9HandleEvents;
 
 FROM WindowLists IMPORT WindowList, NoWindowList, DetectModeWL, AttributesWL,
8AttributeWL, MaxWindowWL, CenterWindowWL, ErrorStateWL,
8ReplaceEntryWL, CreateWL, DeleteWL, SetListWL,
8GetListWL,
8ViewLineWL, ShowWindowWL, HideWindowWL, DetectWindowWL,
8SetEntryAttributesWL, EntryAttributesWL, StateWL;
 
 
 TYPE PtrFAT = ADDRESS;
 
 
 TYPE    PtrWEnv = POINTER TO RECORD
4opened: BOOLEAN;
4drive: CARDINAL;
4oldFat, fat: PtrFAT;
4bpb: BPBPtr;
4fat12Bit: BOOLEAN;
4wl: WindowList;
2END;
(
(Entry   = POINTER TO DirEntry;
 
 
 VAR     Success,
(Quit,
(VoidO   : BOOLEAN;
(PrevCluster: CARDINAL;
 
 
 FORWARD EntryToStr (entry, env: ADDRESS; VAR str: MaxStr);
 
 FORWARD CloseWList (wl: WindowList; env: ADDRESS);
 
 FORWARD OpenFolder (wl: WindowList; env, entry: ADDRESS; selMode: LONGCARD);
 
 
 VAR     CurrList        : List;
 
 TYPE FATProc = PROCEDURE (CARDINAL);
"
 PROCEDURE FATEntry (fat: PtrFAT; fat12Bit: BOOLEAN; cluster: CARDINAL): CARDINAL;
"
"TYPE PtrByte = POINTER TO BYTE;
 
"VAR pb: ADDRESS;
"
"BEGIN
$IF fat12Bit THEN
&pb:= ADDRESS(fat) + LONG (cluster) DIV 2 * 3;
&IF ODD (cluster) THEN
(RETURN (ORD(PtrByte(pb+1)^) DIV 16) + ORD(PtrByte(pb+2)^) * 16
&ELSE
(RETURN ORD(PtrByte(pb)^) + (ORD(PtrByte(pb+1)^) MOD 16) * 256
&END
$ELSE
&pb:= ADDRESS(fat) + LONG (cluster) * 2;
&RETURN ORD(PtrByte(pb)^) + ORD(PtrByte(ADDRESS(pb)+1)^) * 256;
$END;
"END FATEntry;
"
 PROCEDURE SetFATEntry (fat: PtrFAT; fat12Bit: BOOLEAN; cluster, next: CARDINAL);
"
"TYPE PtrByte = POINTER TO BYTE;
 
"VAR pb: ADDRESS;
"
"BEGIN
$IF fat12Bit THEN
&IF next > 4095 THEN
(HALT
&ELSE
(pb:= ADDRESS(fat) + LONG (cluster) DIV 2 * 3;
(ASSEMBLER
*MOVE.L  pb(A6),A0
*MOVE    next(A6),D0
*MOVE    cluster(A6),D1
*BTST    #0,D1
*BNE     isodd
*MOVE.B  D0,(A0)
*LSR.W   #8,D0
*MOVE.B  1(A0),D1
*ANDI.B  #$F0,D1
*OR.B    D0,D1
*MOVE.B  D1,1(A0)
*BRA     ende
(isodd
*MOVE.B  D0,D1
*LSL.W   #4,D1
*MOVE.B  1(A0),D2
*ANDI.B  #$0F,D2
*OR.B    D2,D1
*MOVE.B  D1,1(A0)
*LSR.W   #4,D0
*MOVE.B  D0,2(A0)
(ende
(END
&END
$ELSE
&pb:= ADDRESS(fat) + LONG (cluster) * 2;
&ASSEMBLER
(MOVE    next(A6),D0
(MOVE.L  pb(A6),A0
(ROR.W   #8,D0
(MOVE.W  D0,(A0)
&END
$END;
"END SetFATEntry;
 
 PROCEDURE ReadFAT (wEnvPtr: PtrWEnv): BOOLEAN;
"VAR i: CARDINAL; l: LONGINT; b: BOOLEAN;
"BEGIN
$WITH wEnvPtr^ DO
&b:= PathExists (CHR(drive+ORD("A")));
&bpb:= GetBPB (drive);
&WITH bpb^ DO
(fat12Bit:= bflags = 0;
(IF fat12Bit THEN
*WriteString ('12 Bit FAT');
(ELSE
*WriteString ('16 Bit FAT')
(END;
(WriteLn;
 
(ALLOCATE (fat, fsiz * recsiz);
(ALLOCATE (oldFat, fsiz * recsiz);
(IF (fat = NIL) OR (oldFat = NIL) THEN
*WriteLn; WriteString ('Out of memory!'); WriteLn;
*RETURN FALSE
(END;
 
(l:= RWAbs (Read, fat, fsiz, fatrec, drive);
(IF l # 0L THEN
*WriteLn; WriteString ('Read error!'); WriteLn;
*RETURN FALSE
(END;
(Copy (fat, fsiz*recsiz, oldFat)
&END;
$END;
$RETURN TRUE
"END ReadFAT;
 
 PROCEDURE WriteFAT (wEnvPtr: PtrWEnv): BOOLEAN;
"VAR i: CARDINAL; l: LONGINT; b: BOOLEAN;
"BEGIN
$WITH wEnvPtr^ DO
&WITH bpb^ DO
(l:= RWAbs (Write, fat, fsiz, fatrec, drive);
(IF l # 0L THEN
*WriteLn; WriteString ('Write error!'); WriteLn;
*RETURN FALSE
(END;
(Copy (fat, fsiz*recsiz, oldFat)
&END;
$END;
$RETURN TRUE
"END WriteFAT;
 
 PROCEDURE InsertEntryInCurr (n: CARDINAL);
"VAR error: BOOLEAN;
"BEGIN
$(*
$WriteCard (cluster, 5);
$WriteString (': ');
$WriteCard (next, 5);
$WriteLn;
$*)
$AppendEntry (CurrList, LONG(n)+65536 (* vermeidet den Wert 0 *), error);
$IF error THEN HALT END;
"END InsertEntryInCurr;
"
 PROCEDURE QueryFAT (wEnvPtr: PtrWEnv; out: FATProc);
"VAR i: CARDINAL;
"BEGIN
$WITH wEnvPtr^ DO
&FOR i:= 0 TO bpb^.numcl DO
(out (i)
&END
$END;
"END QueryFAT;
 
 PROCEDURE newList (wEnvPtr: PtrWEnv);
 
"VAR   res     : INTEGER;
(wildName: String;
(error: BOOLEAN;
 
"BEGIN
$CreateList (CurrList, error);
$IF error THEN HALT END;
$IF ReadFAT (wEnvPtr) THEN
&QueryFAT (wEnvPtr, InsertEntryInCurr);
&SetListWL (wEnvPtr^.wl, CurrList, EntryToStr, CloseWList, OpenFolder,
1wEnvPtr, 30, CHR(wEnvPtr^.drive+ORD("A")));
&IF StateWL (wEnvPtr^.wl) # okWL THEN
(WriteString ('Error setting list!'); WriteLn
&END
$END
"END newList;
 
 PROCEDURE killList (wEnvPtr: PtrWEnv);
 
"VAR   l       : List;
(entry   : Entry;
 
"BEGIN
$GetListWL (wEnvPtr^.wl, l);
$
$ResetList (l);
$entry := PrevEntry (l);
$WHILE entry # NIL DO
&RemoveEntry (l, VoidO);
&(*
&DISPOSE (entry);
&*)
&entry := CurrentEntry (l);
$END;
$DeleteList (l, VoidO);
$DEALLOCATE (wEnvPtr^.fat, 0);
$IF VoidO THEN HALT END;
"END killList;
"
 
 PROCEDURE CloseWList (wl: WindowList; env: ADDRESS);
 
"VAR   wEnv: PtrWEnv;
(i, j,
(len : INTEGER;
(folderName: String;
 
"BEGIN
$wEnv := PtrWEnv (env);
$WITH wEnv^ DO
&killList (wEnv);
&HideWindowWL (wl);
&opened:= FALSE
$END;
"END CloseWList;
 
 
 PROCEDURE EntryToStr (entry, env: ADDRESS; VAR str: MaxStr);
"
"VAR next, next2, cluster: CARDINAL;
"
"PROCEDURE apnd (n: CARDINAL);
$BEGIN
&IF n = $FFF THEN
(Append ("<EOF>", str, VoidO)
&ELSIF n = $FF9 THEN
(Append ("<DIR>", str, VoidO)
&ELSE
(Append (CardToStr (n,5), str, VoidO);
&END;
$END apnd;
"
"PROCEDURE apnd2 (n: CARDINAL);
$BEGIN
&IF n > $FF7 THEN
(Append ("   ", str, VoidO)
&ELSE
(IF n <= cluster THEN
*Append (' < ', str, VoidO);
(ELSIF n # cluster + 1 THEN
*Append (' ~ ', str, VoidO);
(ELSE
*Append ('   ', str, VoidO);
(END
&END;
$END apnd2;
"
"VAR fatDesc: PtrWEnv;
"
"BEGIN
$cluster:= SHORT (LONGCARD(entry) MOD 65536);
$fatDesc:= env;
$WITH fatDesc^ DO
&next:= FATEntry (fat, fat12Bit, cluster);
&next2:= FATEntry (oldFat, fat12Bit, cluster);
&Concat (CardToStr (cluster,6), ': ', str, VoidO);
&apnd (next);
&apnd2 (next);
&IF next2 # next THEN
(Append ('(', str, VoidO);
(apnd (next2);
(Append (')', str, VoidO);
&END;
&Append (' ', str, VoidO);
$END
"END EntryToStr;
 
 PROCEDURE OpenFolder (wl: WindowList; entry, env: ADDRESS; clicks: LONGCARD);
 
"VAR   attrs   : AttributesWL;
(cluster, next: CARDINAL;
(fatDesc: PtrWEnv;
 
"BEGIN
$fatDesc:= env;
$cluster:= SHORT (LONGCARD(entry) MOD 65536);
$next:= FATEntry (fatDesc^.fat, fatDesc^.fat12Bit, cluster);
$IF clicks = 2 THEN
&PrevCluster:= cluster;
&WriteString ('View cluster '); WriteCard (next, 0); WriteLn;
&ViewLineWL (wl, next+1);
$ELSIF clicks = 1 THEN
&(*
(attrs:= EntryAttributesWL (wl, entry);
(IF selectedWL IN attrs THEN
*EXCL (attrs, selectedWL)
(ELSE
*INCL (attrs, selectedWL)
(END;
(SetEntryAttributesWL (wl, entry, attrs);
&*)
&WriteString ('Cluster '); WriteCard (cluster, 0);
&IF ControlKey IN GetKBShift() THEN
((* Folgecluster einsetzen *)
(next:= cluster + 1;
(WriteString (': '); WriteCard (next, 0); WriteLn;
&ELSE
((* Cluster manuell bestimmen *)
(WriteString ('? '); ReadCard (next);
&END;
&SetFATEntry (fatDesc^.fat, fatDesc^.fat12Bit, cluster, next);
&ReplaceEntryWL (wl, entry, entry, TRUE)
$END
"END OpenFolder;
 
 
 VAR FAT    : PtrWEnv;
 
 
 PROCEDURE KeyHdler (VAR ch: GemChar; VAR k: SpecialKeySet): BOOLEAN;
"VAR c: CHAR; i: CARDINAL;
"BEGIN
$IF CAP (ch.ascii) = 'Q' THEN
&Quit := TRUE
$ELSE
&WITH FAT^ DO
(IF ~opened THEN
*IF (CAP (ch.ascii) >= 'A') AND (CAP (ch.ascii) <= 'P') THEN
,opened:= TRUE;
,drive:= ORD (CAP(ch.ascii)) - ORD ("A");
,newList (FAT);
,ShowWindowWL (wl);
*END;
(ELSE
*IF ch.ascii = CHR(13) THEN (* Return *)
,WriteString ('View cluster '); WriteCard (PrevCluster, 0); WriteLn;
,ViewLineWL (FAT^.wl, PrevCluster+1);
*ELSIF CAP(ch.ascii) = 'O' THEN
,ShowWindowWL (wl);
*ELSIF CAP(ch.ascii) = 'C' THEN
,HideWindowWL (wl);
*ELSIF CAP(ch.ascii) = 'W' THEN
,WriteString ('Write FAT? (Y/N) ');
,REPEAT
.InOut.Read (c)
,UNTIL (CAP(c)='Y') OR (CAP(c)='J') OR (CAP(c)='N');
,IF (CAP(c) # 'N') & WriteFAT (FAT) THEN
.WriteString ('FAT Written'); WriteLn
,END;
,HideWindowWL (wl);
*ELSIF CAP(ch.ascii) = '@' THEN
,(* ganze FAT mit einem File belegen *)
,FOR i:= 2 TO FAT^.bpb^.numcl-1 DO
.SetFATEntry (FAT^.fat, FAT^.fat12Bit, i, i+1);
,END;
,SetFATEntry (FAT^.fat, FAT^.fat12Bit, FAT^.bpb^.numcl, $FFF);
,HideWindowWL (wl);
*END
(END
&END
$END;
$RETURN FALSE
"END KeyHdler;
 
 PROCEDURE ButHdler (clicks: CARDINAL; loc: Point; buts: MButtonSet;
4keys: SpecialKeySet): BOOLEAN;
 
"VAR   wl   : WindowList;
(entry,
(env  : ADDRESS;
 
"BEGIN
$DetectWindowWL (FAT^.wl, 0, loc, selectWL, clicks, wl, entry, env, VoidO);
$RETURN FALSE
"END ButHdler;
 
 VAR Worker: ARRAY [0..1] OF EventProc;
 
 BEGIN
"NEW (FAT);
"FAT^.opened:= FALSE;
"CreateWL (FAT^.wl, TRUE,  Rect (CenterWindowWL, CenterWindowWL,
CMaxWindowWL, MaxWindowWL));
"IF StateWL (FAT^.wl) = okWL THEN
$
$WriteString ('Q: Quit');
$WriteLn;
$
$Worker[0].event := keyboard;
$Worker[0].keyHdler := KeyHdler;
$Worker[1].event := mouseButton;
$Worker[1].butHdler := ButHdler;
$Quit:= FALSE;
$REPEAT
&HandleEvents (2, MButtonSet{msBut1}, MButtonSet{msBut1},
4lookForEntry, Rect (0,0,0,0),
4lookForEntry, Rect (0,0,0,0),
40L,
4Worker, 0);
$UNTIL Quit;
$
"END;
 END FAT.
  
(* $FFEDB23C$FFEDB23C$FFEDB23C$FFEDB23C$FFEDB23C$FFEDB23C$FFEDB23C$FFEDB23C$FFEDB23C$FFEDB23C$FFEDB23C$FFEDB23C$FFEDB23C$FFEDB23C$FFEDB23C$000023DC$FFEDB23C$FFEDB23C$FFEDB23C$FFEDB23C$FFEDB23C$FFEDB23C$FFEDB23C$FFEDB23C$FFEDB23C$FFEDB23C$FFEDB23C$FFEDB23C$FFEDB23C$FFEDB23C$FFEDB23C$FFEDB23C$FFEDB23C$FFEDB23C$FFEDB23C$FFEDB23C$FFEDB23C$FFEDB23C$FFEDB23C$FFEDB23C$FFEDB23C$FFEDB23C$000023E9T.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$00002444$00002407$0000204C$00002417$FFED4E26$00002421$FFED4E26$000023DF$FFED4E26$000023E9$000023B8$0000243C$000023AB$00002398$0000234C$0000245C*)
