#ifdef __PUREC__
   #include <tos.h>
#else
   #include <osbind.h>
#endif

#define MAX(x,y)  ((x) > (y) ? (x) : (y))
#define COPIES    5
#define MAX_REGS  4
#define MAGIC     "InitMagic"

/*
 * Structure definitions
 */
typedef struct _Prgheader {
   short magic;
   long  tsize;
   long  dsize;
   long  bsize;
   long  ssize;
   long  reserved;
   long  flags;
   short relocflag;
} Prgheader;

typedef struct _Funcs {
	int  (*apply)(int (*)(int));
	char *(*malloc)(long);
	void (*free)(char *);
	void (*puts)(char *);
	int  (*strlen)(char *);
	void (*strcpy)(char *, char *);
	void (*strcat)(char *, char *);
	void (*ltoa)(char *, long);
} Funcs;

typedef struct _Vars {
	short	count;
} Vars;

typedef struct _Access {
	Funcs	funcs;
	Vars  vars;	
} Access;

typedef struct _Locator {
	char 	magic[10];
	short version;
	int 	(*init)(int (*)(void), Access *);
} Locator;

typedef struct _Registered {
	int (*func)(int);
} Registered;


/*
 * Global variables
 */
int  g_apply(int (*)(int));
char *g_malloc(long);
void g_free(char *);
void g_puts(char *);
int  g_strlen(char *);
void g_strcpy(char *, char *);
void g_strcat(char *, char *);
void g_ltoa(char *, long);

Access real_access = {{g_apply, g_malloc, g_free, g_puts,
                       g_strlen, g_strcpy, g_strcat, g_ltoa},
                       0};
int no_registered = 0;
Registered registered[MAX_REGS];


/*
 * Local variables
 */
int init(int (*callback)(void), Access *_access);
int do_work(int n);

Locator locator = {MAGIC, 0x0010, init};
Access *access;
int my_num;

/*
 * Local functions
 */
int init(int (*callback)(void), Access *_access)
{
	access = _access;
	my_num = access->vars.count;
	if (callback())
		access->funcs.puts("Callback successful!");
	if (!access->funcs.apply(do_work)) {
		access->funcs.puts("Could not register!");
		return 0;
	}
	
	return 1;
}

int do_work(int n)
{
	char text[20], num[10];
	
	access->funcs.strcpy(text, "I am ");
	access->funcs.ltoa(num, my_num);
	access->funcs.strcat(text, num);
	access->funcs.strcat(text, "/");
	access->funcs.ltoa(num, n);
	access->funcs.strcat(text, num);
	if (n % access->vars.count == my_num)
		access->funcs.puts(text);

	return 1;
}

/*
 * Global functions
 */
char *g_malloc(long n)
{
	return Malloc(n);
}

void g_free(char *addr)
{
	Mfree(addr);
}

int g_apply(int (*func)(int))
{
	int res;
	
	res = 0;
	if (no_registered < MAX_REGS) {
		registered[no_registered++].func = func;
		res = 1;
	}
	
	return res;
}

int g_strlen(char *text)
{
	int n;

	n = 0;	
	while(*text++)
		n++;
	
	return n;
}

void g_strcpy(char *dest, char *src)
{
	while(*dest++ = *src++)
		;
}

void g_strcat(char *dest, char *src)
{
	dest += g_strlen(dest);
	g_strcpy(dest, src);
}

void g_puts(char *text)
{
	Cconws(text);
	Cconws("\x0d\x0a");
}

void reverse(char *buf)
{
	int i, n;
	char tmp;
	
	n = g_strlen(buf);
	for(i = 0; i < n / 2; i++) {
		tmp = buf[i];
		buf[i] = buf[n - 1 - i];
		buf[n - 1 - i] = tmp;
	}
}

void g_ltoa(char *buf, long n)
{
	long result, rest;
	char *tmp;
	
	tmp = buf;
	do {
		result = n / 10;
		rest = n - result * 10;
		*tmp++ = rest + '0';
		n = result;
	} while (n);
	*tmp = '\0';
	reverse(buf);
}

int g_callback(void)
{
	return 1;
}


/*
 * Loader/relocator/scheduler
 */

int initialize(unsigned char *addr, long size)
{
	int i, j;
	
	for(i = 0; i < size - sizeof(MAGIC); i++) {
		for(j = 0; j < sizeof(MAGIC); j++) {
			if (addr[j] != MAGIC[j])
				break;
		}
		if (j == sizeof(MAGIC)) {
			if (((Locator *)addr)->init(g_callback, &real_access))
				real_access.vars.count++;
			return 1;
		}
		addr++;
	}

	return 0;
}

void execute(void)
{
	int i, j;
	
	for(i = 0; i < 20; i++) {
		for(j = 0; j < no_registered; j++) {
			registered[j].func(i);
		}
	}
}

void relocate(unsigned char *prog_addr, Prgheader *header)
{
   unsigned char *code, *rtab, rval;

   rtab = prog_addr + header->tsize + header->dsize + header->ssize;
   code = prog_addr + *(long *)rtab;
   rtab += 4;

   *(long *)code += (long)prog_addr;
   while (rval = *rtab++) {
      if (rval == 1)
         code += 254;
      else {
         code += rval;
         *(long *)code += (long)prog_addr;
      }
   }
}      

int main(int argc, char **argv)
{
#ifdef __TURBOC__
   DTA info;
#else
 #ifdef __GNUC__
   _DTA info;
 #else
   struct FILEINFO info;
 #endif
#endif
   long file_size, program_size;
   int file;
   unsigned char *addr;
   Prgheader header;
#if 0
   void (*program)(void);
#endif
   int i;

for(i = 0; i < COPIES; i++) {
   if (argc != 2)
      return -1;

   Fsetdta(&info);
	Fsfirst(argv[1], 0);
#ifdef __TURBOC__
   file_size = info.d_length;
#else
 #ifdef __GNUC__
   file_size = info.dta_size;
 #else
   file_size = info.size;
 #endif
#endif
   file_size -= sizeof(header);

   if ((file = Fopen(argv[1],0)) < 0)
      return -1;

   Fread(file, sizeof(header), &header);
   program_size = header.tsize + header.dsize + header.bsize;

   addr = Malloc(MAX(file_size, program_size));

   Fread(file, file_size, addr);
   Fclose(file);

   relocate(addr, &header);
#if 0
   program = (void (*))addr;
   program();
#endif
	if (!initialize(addr, header.tsize + header.dsize))
		g_puts("Initialization failed!");
}
	execute();

   return 1;
}
