/*******************************************************************
 * Modul	   : DATELIB.H
 * Projekt	: DATUM
 * Aufgabe	: Eine kleine Datumslibary, die einen 
 *            Dauerkalender beinhaltet.
 *------------------------------------------------------------------
 * Autor	: Ralph Lanfermann
 * Datum	: 27.10.1992
 *------------------------------------------------------------------
 * Computer : Atari ST
 * Compiler	: Pure C Version Aug 29 1991
 * Optionen	: -----
 * Version	: 1.00
 *******************************************************************/

/*
	Es folgen die Strings mit den Bezeichnungen fr die
	Monate und Tage.
	
	Soll die Libary in englich, franzsich, spanisch oder
	timbuktunesisch verwendet werden, so mssen Sie nur
	darauf achten, das die Positionen beibehalten werden, da 
	es sonst zu herben Kuddelmuddel kommen kann.

	Also :  Frzblkm (= Oktober in mittelhochsubcutaneisch )
	        kommt da hin, wo auch Oktober stand.

*/

/* Lange und kurze Strings fr Monatsnamen */
BYTE *_mmon1[] = { "Januar","Februar","Mrz","April","Mai","Juni",
                  "Juli","August","September","Oktober","November",
                  "Dezember" };

BYTE *_mmon2[] = { "Jan","Feb","Mrz","Apr","Mai","Jun","Jul",
						 "Aug","Sep","Okt","Nov","Dez" };                  

/* Lange und kurze Strings fr Wochentage */

BYTE *_mtag1[] = { "Montag", "Dienstag", "Mittwoch","Donnerstag","Freitag",
                 "Samstag","Sonntag","Sonntag" };                  

BYTE *_mtag2[] = { "Mo" , "Di", "Mi", "Do", "Fr", "Sa", "So", "So" };



/*
	Definitionen der Berechnungsmodi
*/

#define M_NEUDATE 0x1  /* Systemdatum erfragen */
#define M_ZIFFERN 0x2  /* Nur in Ziffern       */
#define M_ENGLISH 0x4  /* Engl Format MMTTJJ   */
#define M_TAGE    0x8  /* Tage anzeigen        */
#define M_MONATE  0x10 /* Monate als Text      */
#define M_KURZTAG 0x20 /* Tage in Kurzform     */
#define M_KURZMON 0x40 /* Kurze Monatsangabe   */
#define M_EDIT1   0x80  /* Editfeld Lang */
#define M_EDIT2   0x100	/* Editfeld kurz */
#define M_KURZJ	0x200	/* Jahr kurz */
#define M_2FORM	0x400 /* Formatieren */

/* Datumsstruktur 
	Sie hat die Lnge von 4 Bytes.
	
	Die Struktur ist im wesentlichen mit der des GEMDOS
	identisch. Bit 0-4 Tag Bit 5-8 Monat und Bit 9-20 Jahr.
	Bit 21-24 Index.
	
	Das Jahr wird, im Gegensatz zum GEMDOS, komplett gepackt.
*/	 

typedef struct
	{
	unsigned text : 4;  /* index im Wochentagarray */
	unsigned tag  : 5;  /* Tage                    */
	unsigned monat: 4;  /* Monat                   */
	unsigned jahr :12;  /* Jahr                    */
	}_MLDATE;



/* Prototypendeklaration */

/* 
	_get_date 
	Die Funktion erfragt das Systemdatum (Bei Mode M_NEUDATE)
	und fllt die Struktur m mit den korrekten Werten. Je nach
	den weiteren gesetzten Bits in der Variable modi erhlt man
	im String erg das Datum in der gewnschten Form.
	Ruft die Funktion berechne_text auf.
*/	
BOOLEAN _get_date( _MLDATE *m, WORD mode , BYTE *erg );


/*
	berechne_text( _MLDATE *m )
	Die Funktion berechnet zu dem Datum den passenden
	Wochentag. Der index des Tages, bzw die Nummer des Tages
	wird in das Feld .text der _MLDATE-struktur eingetragen.
	Die Bedeutungen sind : 
	0 = Montag
	1 = Dienstag... 
	6 = Sonntag und zustzlich wegen des 
	Dauerkalenders auch 7 = Sonntag.
*/
	
VOID berechne_text( _MLDATE *m );


/*
	_gd2my
	Diese Funktion konvertiert das GEMDOS-Datum in das Format
	von _MLDATE.
	Wird im Parameter 'date' eine 0 bergeben, so wird das
	aktuelle Datum mit der Systemfunktion Tgetdate ermittelt.
	Bem. : Der Wochentag wird nicht berechnet.
*/
	
VOID _gd2my( _MLDATE *_m , UWORD date );

/*
	_my2gd
	Diese Funktion convertiert wieder das Datum vom _MLDATE-Format
	ins GEMDOS Format um, falls mglich.
	
	Wie, falls mglich ???!?!?
	
	Nun, GEMDOS packt das Jahr als 'Jahre seit 1980' . 
	dagegen ist in _MLDATE auch ein Jahr von 1955 oder 1912
	zu packen. Das klappt in GEMDOS nicht. 
	In einem solchen Fall gibt die Funktion in date ein
	lapidare 0 zurck.
	Bem.: Der Inhalt von _MLDATE wird nicht verndert.
*/
	
UWORD _my2gd( _MLDATE *_m );


/*
	_ex2dstr
	Diese Funktion konvertiert ein Datum im String-Format in
	das _MLDATE-Format.
	Wird der Funktion anstelle eines String eine Null-addresse
	( = (void*)0L ) bergeben, so wird das Systemdatum ermittelt.
	
	Die Funktion verarbeitet Strings in folgenden Formaten
		: TTMMJJJJ
		  TTMMJJ
		  TT.MM.JJ
		  TT.MM.JJJJ
	Wobei die Trennzeichen beliebig sind. Wichtig ist dabei nur,
	da Tag und Monat zweistellig angegeben werden. 
	(z.B. 02 statt 2)
	Auch hier wird kein Wochentag berechnet.
*/	  
	
VOID _ex2dstr( _MLDATE *_m , CONST BYTE *datum );

/* 
	_set_date
	Diese Funktion setzt die Uhrzeit neu.
	Je nach Mode wird das fr die GEMDOS und/oder die
	Bios Uhr versucht.
	
	Mode 1 : nur GEMDOS stellen (mit Tsetdate)
	Mode 2 : nur BIOS   stellen (mit Settime )
	Mode 3 : GEMDOS und BIOS stellen
	
	FALSE deutet auf einen Fehler hin.
*/
	
BOOLEAN set_date( _MLDATE *m , WORD mode );


BOOLEAN _is_ok( _MLDATE *m );

BOOLEAN generate_cal( WORD monat , WORD jahr, BYTE *erg[] );