/*******************************************************************
 * Modul	   : RPMT_DEM.C
 * Projekt	: RPMT
 * Aufgabe	: Kleine Demo-Routinen zu RPMT
 *            
 *------------------------------------------------------------------
 * Autor	: Ralph Lanfermann
 * Datum	: 28. 4. 1993
 *------------------------------------------------------------------
 * Computer : Atari ST
 * Compiler	: Pure C Version Aug 29 1991
 * Optionen	: -----
 * Version	: 1.00
 *******************************************************************/


#include "rpmt_inc.h"

#define GOTO_POS      "\33Y"
#define Goto_pos(x,y) (Cconws(GOTO_POS),  Cconout(' ' + x), Cconout(' ' + y))


static void formatter( int in );
static void joblist( int in );
static void copierer( int in );
static void infostring( int in );
void ausgeben( int bis );

/* Hilfvariablen zur DEMO */
static int disknr;
static char zeile[500];

extern int taskstop;

int do_work( void )
	{
	/* Dieser Job Kopiert von A nach B */
	int j,ret;
	
	/* freie Task suchen */ 
	j = task_free();
	
	/* Gefunden */
	if ( j >= 0 )
		{
		task[j].t_id     = disknr;
		task[j].t_min1   = 0;
		task[j].t_max1   = 100;  /* Damit man was erkennt */
		task[j].t_akt1   = 0;
		task[j].t_min2   = 0;
		task[j].t_max2   = 0;
		task[j].t_akt2   = 0;
		
		/* Ein wenig Zufall */
		ret = random( 17 );
		
		/* und ein Paar Quelldrives */
		switch( ret )
			{			
			case 2  : task[j].t_drive = T_DC; break;
			case 3  : task[j].t_drive = T_DD; break;
			case 4  : task[j].t_drive = T_DE; break;
			case 5  : task[j].t_drive = T_DF; break;
			case 6  : task[j].t_drive = T_DG; break;
			case 7  : task[j].t_drive = T_DH; break;
			case 8  : task[j].t_drive = T_DI; break;
			case 9  : task[j].t_drive = T_DJ; break;
			case 10 : task[j].t_drive = T_DK; break;
			case 11 : task[j].t_drive = T_DL; break;
			case 12 : task[j].t_drive = T_DM; break;
			case 13 : task[j].t_drive = T_DN; break;
			case 14 : task[j].t_drive = T_DO; break;
			case 15 : task[j].t_drive = T_DP; break;
			default : task[j].t_drive = T_DC; break;
			}

		ret = random( 17 );

		/* und ein Paar Ziellaufwerke */
		switch( ret )
			{
			case 2  : task[j].t_drive |= T_DC; break;
			case 3  : task[j].t_drive |= T_DD; break;
			case 4  : task[j].t_drive |= T_DE; break;
			case 5  : task[j].t_drive |= T_DF; break;
			case 6  : task[j].t_drive |= T_DG; break;
			case 7  : task[j].t_drive |= T_DH; break;
			case 8  : task[j].t_drive |= T_DI; break;
			case 9  : task[j].t_drive |= T_DJ; break;
			case 10 : task[j].t_drive |= T_DK; break;
			case 11 : task[j].t_drive |= T_DL; break;
			case 12 : task[j].t_drive |= T_DM; break;
			case 13 : task[j].t_drive |= T_DN; break;
			case 14 : task[j].t_drive |= T_DO; break;
			case 15 : task[j].t_drive |= T_DP; break;
			default : task[j].t_drive |= T_DE; break;
			}

		task[j].t_device = 0;
		
		/* Immer erst ins Hold */
		task[j].t_status   = T_HOLD;
		task[j].t_funktion = copierer;
		
		/* Das Kind braucht einen Namen */
		sprintf( task[j].t_name , "COPY   DISK   ");
		
		/* Disknummer eins erhhen */
		disknr++;
		}
		if ( disknr == 22 )
			disknr = 1;
		
	return TRUE;
	}
	
int do_format( void )
	{
	int j,ret;
	
	/* freie Task suchen */ 
	j = task_free();
	
	/* Gefunden */
	if ( j >= 0 )
		{
		
		ret = form_alert(1,"[2][Disk A oder B|formatieren ?][ A | B ]");
		
		task[j].t_id     = disknr;
		task[j].t_min1   = 0;
		task[j].t_max1   = 100;  /* Damit man was erkennt */
		task[j].t_akt1   = 0;
		task[j].t_min2   = 0;
		task[j].t_max2   = 0;
		task[j].t_akt2   = 0;
		/* Laufwerk A oder B */
		if ( ret == 1 )
			task[j].t_drive = T_DA;
		else
			task[j].t_drive = T_DB;	
		task[j].t_device   = 0;
		
		/* Immer erst ins Hold */
		task[j].t_status   = T_HOLD;
		task[j].t_funktion = formatter;
		
		/* Das Kind braucht einen Namen */
		sprintf( task[j].t_name , "FORMAT VON DISK #%d",disknr);
		
		/* Disknummer eins erhhen */
		disknr++;
		}
				
		if ( disknr == 22 )
			disknr = 1;
		
	return TRUE;
	}


void formatter( int in )
	{
	int is_error = TRUE;
	
	/* Mu noch etwas geschehen ? */
	if ( task[in].t_akt1 < task[in].t_max1 )
		{
		/* 
		Ja, dann formatieren 
		Falls ein Fehler auftritt,
		wird is_error auf FALSE gesetzt, damit die 
		Task beendet werden kann.
		Im Demo bleibt  is_error immer TRUE.
		Nach der Aktion wird t_akt1 um eins erhht.
		
		Hier ist auch die Stelle, an der ein Redraw
		fr das Fortschrittsfenster erfolgen kann.
		Dazu wird die Funktion updaten aufgerufen,
		die ber die Funktion appl_write eine 
		Redraw-Message an das Betreffende Fenster
		versendet.
		
		Dies darf natrlich nur geschehen, wenn
		berhaupt ein Fenster vorhanden ist.
		
		void updaten( int in )
			{
			if ( task[in].t_fens != NULL )
				{
				WM_REDRAW versenden
				}
			}		
		
		Im Demo wird an der Stelle X=1,Y=n ein
		Hinweistext ausgegeben.
		*/

		Goto_pos( (task[in].t_id)+1 , 1 );
		printf("*** Task : %-20s -> %5d\r",
		task[in].t_name,task[in].t_akt1);
				
		task[in].t_akt1 += 1;

		}
	else
	   /* Nein, dann Task entfernen */
		task_delete( in );
	
	
	/* Es trat ein Fehler auf */	
	if ( is_error == FALSE )
		task_delete( in );	
	}		
	
void copierer( int in )
	{
	int is_error = TRUE;
	
	/* Mu noch etwas geschehen ? */
	if ( task[in].t_akt1 < task[in].t_max1 )
		{
		Goto_pos( task[in].t_id+1 , 1 );
		printf("*** Task : %-20s -> %5d\r",
		task[in].t_name,task[in].t_akt1);
				
		task[in].t_akt1 += 1;
		}
	else
	   /* Nein, dann Task entfernen */
		task_delete( in );
	
	
	/* Es trat ein Fehler auf */	
	if ( is_error == FALSE )
		task_delete( in );	
	}		
		
int do_tasker( void )
	{
	if ( taskstop == TRUE )
		taskstop = FALSE;
	else
		taskstop = TRUE;
			
	return TRUE;
	}
	
int do_info( void )
	{
	int j;
	
	/* 
	gibt einen Infostring aus
	*/
	
	/* freie Task suchen */ 
	j = task_free();
	
	/* Gefunden */
	if ( j >= 0 )
		{
		task[j].t_id     = 101; 
		task[j].t_min1   = 0;
		task[j].t_max1   = 250;  
		task[j].t_akt1   = 0;
		task[j].t_min2   = 0;
		task[j].t_max2   = 0;
		task[j].t_akt2   = 0;
		task[j].t_drive  = 0;
		task[j].t_device = T_PRINT;
		/* Immer erst ins Hold */
		task[j].t_status   = T_HOLD;
		task[j].t_funktion = infostring;
		/* Das Kind braucht einen Namen */
		sprintf( task[j].t_name , "INFOANZEIGE");
		}
	
	return TRUE;
	}	
	
int do_system( void )
	{
	int j;
	
	/* 
	Diese Routine listet stndig alle Tasks
	auf, die dezeit laufen.
	*/
	
	/* freie Task suchen */ 
	j = task_free();
	
	/* Gefunden */
	if ( j >= 0 )
		{
		task[j].t_id     = 99; /* Ein Systemjob */
		task[j].t_min1   = 0;
		task[j].t_max1   = 0;  
		task[j].t_akt1   = 0;
		task[j].t_min2   = 0;
		task[j].t_max2   = 0;
		task[j].t_akt2   = 0;
		task[j].t_drive  = 0;
		task[j].t_device = T_SCREEN;
		/* Immer erst ins Hold */
		task[j].t_status   = T_HOLD;
		task[j].t_funktion = joblist;
		/* Das Kind braucht einen Namen */
		sprintf( task[j].t_name , "JOBLIST");
		}
	
	return TRUE;
	}
	
	
void joblist( int ii )
	{
	int x,y,i;
	char text[38];
	char status[6];

	x = 42;
	
	y = 0;
	for( i=0; i<10; i++ )
		if ( task[i].t_id != 0 )
			y++;
	
	Goto_pos( 2 , x );
	printf("*** JLIST * : %4d Jobs running\r",y);
	Goto_pos( 4 , x );
	printf("               Laufwerke       ");
	
	/* Alle Tasks durchsuchen */
	for( i = 0	; i < 10 ; i++ )
		{
		get_drive( task[i].t_drive , text );
		switch( task[i].t_status )
			{
			case T_RUN : strcpy( status , "RUN ");
			break;
			case T_HOLD: strcpy( status , "HOLD");
			break;
			case T_WAIT: strcpy( status , "WAIT");
			break;
			default    : strcpy( status , "    ");
			}
		Goto_pos( 5+i , x );
		if ( task[i].t_id != 0 )
			printf("ID : %4d %s %s\r",task[i].t_id,status,text);  
		else
			printf("                               ");	
		}

	}	
	

void infostring( int in )
	{
	
	/* Erster Aufruf ? */
	if ( task[in].t_akt1 == 0 )
		{
		/* Infostring generieren */
		sprintf( zeile , "%s%s%s%s %c %s%s%s%s%s%s",
		"              ",
		"**** RPMT ****",
		" (R)alphs (P)seudo (M)ulti(T)asking ",
		"*****",
		0xbd,
		"1992 by LANTEC ComPro Alsdorf ",
		"*****",
		" Das ist ein Demo-Programm zu RPMT. ",
		"*****",
		" viel Spa beim Testen..... ",
		"              ");
		
		task[in].t_max1 = (int)strlen( zeile );
		}
	
	if ( task[in].t_akt1 < task[in].t_max1 )
		{
		ausgeben( task[in].t_akt1 );
		task[in].t_akt1 += 1;
		}
	else
		task_delete( in );
	}	
	
	
void ausgeben( int bis )
	{
	/* Diese Funktion gibt nur einen
	   kleinen Infotext aus. */
	char zwi[500];
	strncpy( zwi, &zeile[bis] , 20 );
	Goto_pos( 22 , 1 );
	printf(">>> %s <<<\r",zwi);
	}		