/*******************************************************************
 * Modul	   : RPMT_EVN.C
 * Projekt	: RPMT
 * Aufgabe	: Event-Modul.
 *            Zur einfacheren Handhabe
 *------------------------------------------------------------------
 * Autor	: Ralph Lanfermann
 * Datum	: 28. 4. 1993
 *------------------------------------------------------------------
 * Computer : Atari ST
 * Compiler	: Pure C Version Aug 29 1991
 * Optionen	: -----
 * Version	: 1.00
 *******************************************************************/

#include <aes.h>

typedef struct
{
  int    mox;                            /* Maus-X-Position */
  int    moy;                            /* Maus-Y-Position */
  int    mobutton;                       /* Mausknopf */
  int    kstate;                         /* Shift-Tastatur-Status */
  int    kreturn;                        /* Keycode von Event-Keyboard */
  int    breturn;                        /* Anzahl der Klicks */
  int    ascii_code;                     /* ASCII-Code der Taste */
  int    scan_code;                      /* Scan-Code der Taste */
  int    shift;                          /* Shift-Taste bettigt ? */
  int    ctrl;                           /* Control-Taste bettigt ? */
  int    alt;                            /* Alternate-Taste bettigt ? */
} RLKINFO;      

int multievent( int *msg , RLKINFO *mk , long time )
	{
	int event;

	if ( time == 0L )
		time = 100L;


	event = evnt_multi( (MU_BUTTON|MU_KEYBD|MU_MESAG|MU_TIMER), 
						0x02,           /* Zeitrahmen der Events   */
						0x01,           /* Maske der Events        */
						0x01,           /* gewnscht. Mauszustand  */
						0, 0, 0, 0, 0,
						0, 0, 0, 0, 0,
						msg,            /* Nachrichtenpuffer       */
						(int)(time&0xFFF), (int)(time>>16),          /* Timerereignisse         */
						&(mk->mox), &(mk->moy),
   			            &(mk->mobutton), &(mk->kstate),
               			&(mk->kreturn), &(mk->breturn));

    graf_mkstate (&(mk->mox), &(mk->moy),
                 (&mk->mobutton), &(mk->kstate)); /* Werte nach Ereignis */

    mk->shift  = (mk->kstate & (K_RSHIFT | K_LSHIFT)) != 0;
    mk->ctrl   = (mk->kstate & K_CTRL) != 0;
    mk->alt    = (mk->kstate & K_ALT) != 0;
    
    return event;
	}
