/*******************************************************************
 * Modul	   : RPMT_KER.C
 * Projekt	: RPMT
 * Aufgabe	: Multitasking-Routinen
 *            
 *------------------------------------------------------------------
 * Autor	: Ralph Lanfermann
 * Datum	: 28. 4. 1993
 *------------------------------------------------------------------
 * Computer : Atari ST
 * Compiler	: Pure C Version Aug 29 1991
 * Optionen	: -----
 * Version	: 1.00
 *******************************************************************/

#include "rpmt_inc.h"

#define T_ANZ 10

int taskstop;


/***************************
 *	task_manager
 *	Verwaltung der Tasks
 *	in  -> : 
 *	out -> :
 ***************************/
		
void task_manager( void )
	{
	int i;
	
	/* Genereller Aufgabenstopp ? */
	if ( taskstop == FALSE )
		{
		/* Alle Tasks behandeln */
		for( i = 0 ; i < T_ANZ ; i++ )
			{
			/* Ist die Task belegt ? */
			if ( task[i].t_id != 0 )
				{
				/* Gibt es eine Funktion ? */
				if ( task[i].t_funktion != NULL )
					{
					/* Darf die Task laufen ? */
					if ( task[i].t_status == T_RUN )
						/* Ausfhren ! */
						(*task[i].t_funktion)(i);
					else	
						{
						/* vom User gewollte Pause ? */
						if ( task[i].t_status != T_WAIT )
							{
							/* Nein, Peripherie frei ? */
							if ( used_device ( i )== TRUE )
								{
								/* Soll gestartet werden ? */
								if( task_start( i ) == TRUE )
									{
									/* Status auf T_RUN setzten */
									task[i].t_status = T_RUN;
									/* FUnktion ausfhren */
									(*task[i].t_funktion)(i);
									}
								else
							 		/* 
								 	Soll nicht gestartet werden,
								 	Task lschen.
									*/
									task_delete( i );	
								} /* Device frei */
							} /* != T_WAIT */	
						} /* else T_RUN */
					} /* Funktion != NULL */
				} /* task id != 0 */
			} /* for */	
		} /* Taskstop ? */	
	}	


/*******************************
 *	task_exist
 *	Test, ob Task existiert
 *	in  -> : Task-ID
 *	out -> : Index Task-Array/ -1
 *******************************/
 
int task_exist( int id )
	{
	int i;

	/* Alle durchsuchen */
	for( i = 0 ; i < T_ANZ ; i++ )
		
		/* Gibt es die gewnschte ID */
		if ( task[i].t_id == id )
			
			/* Ja, Index zurck */ 
			return i;

	/* Nein, Fehler */
	return (-1);
	}	
		


/*******************************
 *	used_device
 *	Test, ob Peripherie frei
 *	in  -> : Index Task-Array
 *	out -> : TRUE / FALSE
 *******************************/
	
int used_device( int tas )
	{
	int device,drive;
	int i;
	
	device = task[tas].t_device;
	drive  = task[tas].t_drive;
	
	/* Bildschirm ist immer Frei */
	if ( device & T_SCREEN )
		return TRUE;
	
	/* Wieder alle Tasks untersuchen */
	for( i = 0 ; i < T_ANZ ; i++ )
		{
		/* Luft die Task ? */
		if ( task[i].t_status == T_RUN )
			/* Verwendet Sie gesuchte Peripherie */
			if( (task[i].t_drive  & drive  )||
			    (task[i].t_device & device ) )
				return FALSE;  /* ist belegt */
		}
	return TRUE; /* ist frei */
	}	
	

/*******************************
 *	task_delete
 *	eine Task entfernen
 *	in  -> : Index Task-Array
 *	out -> : 
 *******************************/
	
void task_delete( int i )
	{
	/*

	Hier wrde bei allen Tasks, die
	die ID kleiner als 99 haben das
	dazugehrige Fenster geschlossen
	
	if ( task[i].t_id < 99 )
		if ( task[i].t_fen != NULL )
			delete_fenster( task[i].t_fen ); 
	*/
	

	/* Urzustand herstellen */
	task[i].t_id	    = 0;
	task[i].t_min1     = 0;
	task[i].t_max1	    = 0;
	task[i].t_akt1	    = 0;
	task[i].t_min2	    = 0;
	task[i].t_max2	    = 0;
	task[i].t_akt2	    = 0;
	task[i].t_drive    = 0;
	task[i].t_device   = 0;
	task[i].t_status   = 0;
		
	/* 
	Kommentiert, da keine
	Window-libary installiert
	ist.

	task[i].t_fen   = NULL; 
	*/

	task[i].t_funktion = NULL;
	strcpy( task[i].t_name, "LEER" );
	
	}
	

/*******************************
 *	task_init
 *	Task-Manager initialisieren
 *	in  -> : 
 *	out -> : 
 *******************************/

void task_init( void )
	{
	int i;
	

	/* Genereller Stop */
	taskstop = FALSE;
	
	/* Alle Tasks bearbeiten */
	for( i=0 ; i < T_ANZ ; i++ )
		{
		task[i].t_id	   = 0;
		task[i].t_min1    = 0;
		task[i].t_max1	   = 0;
		task[i].t_akt1	   = 0;
		task[i].t_min2	   = 0;
		task[i].t_max2	   = 0;
		task[i].t_akt2	   = 0;
		task[i].t_drive   = 0;
		task[i].t_device  = 0;
		task[i].t_status  = 0;
		
		/* 
		Kommentiert, da keine
		Window-libary installiert
		ist.

		task[i].t_fen   = NULL; 
		*/

		task[i].t_funktion = NULL;
		strcpy( task[i].t_name, "LEER" );
		} /* for */
		
	}/* task_init */		
	

/*******************************
 *	task_free
 *	freie Task suchen
 *	in  -> : 
 *	out -> : Task-Index / -1
 *******************************/
	
int task_free( void )
	{
	int i;

	/* Alle Tasks durchsuchen */
	for( i = 0; i < T_ANZ ; i++ )
		
		/* ID unbenutzt ? */
		if ( task[i].t_id == 0 )	
		
			/* Index zurckgeben */
			return i;

	/* Fehler, keine Task frei */
	return (-1);				
	}	
	


/*******************************
 *	task_start
 *	eine Task starten
 *	in  -> : Task-Index
 *	out -> : TRUE / FALSE
 *******************************/

int task_start( int i )
	{
	char tex[100];	/* Text fr Form_alert */
	int ret;

	/* 
	Da Ohne Windows, kommentiert
	
	OBJECT *addi;	Dialogbox im Fenster
	FENSTER *a;		Zeiger auf Fenster   
	*/

	/* 
	Systemtask mit ID 99
	wird sofort gestartet.
	*/
	
	if ( task[i].t_id == 99 )
		return TRUE;
		
	
	/* 
	Einen Text zusammen-
	schustern.
	*/
	sprintf(tex,
	"[2][FRAGE:|Task: %s|ID : %d starten ?][ JA | Nein ]",
	task[i].t_name,task[i].t_id);
	
	
	/* Noch nicht gestartet */
	if ( (task[i].t_akt1 == 0) &&
		 (task[i].t_akt2 == 0) )
		ret = form_alert(1,tex);	
	else
		ret = 1;	
	
	/* Es wurde 'OK' gewhlt. */
	if ( ret == 1 )
		{
		if ( task[i].t_id < 99 )
			{
			
			/* 
			Falls die ID zwischen
			1 und 98 liegt, soll ein
			Fenster geffnet werden.
			Aber nur, wenn noch kein
			Fenster fr diese Task 
			geffnet wurde. Der Zeiger
			auf das Fenster ist also noch
			NULL
			
			Auch hier nur der die
			kommentierte Fassung.
			
			Noch kein Fenster vorhanden ?
			if ( task[i].t_fen == NULL )
				{
				
				Adresse der Dialogbox besorgen
				rsrc_gaddr(R_TREE,NEUWORK,&addi);
				
				Fenster reservieren
				a = ropen_w( (NAME|MOVER),4,
					task[i].t_name, 
					0L ,
					0L, 
					0L, 
					NULL, 
					addi ,
					nwork , 
					0L );

				konnte Fenster reserviert
				werden   ?
				
				if ( a != NULL )
					{
					Ja, Tasknummer
					in Fensterstruktur
					eintragen.
					a->besonders = (long)i;
					
					fenster ffnen
					fenster_auf(a);
					
					fensterzeiger merken
					task[i].t_fen = a;
					}
				else
					task[i].t_fen = NULL;
					
					
				}	*/
			}
		
		/* Task Starten */	
		return TRUE;  
		}
	else
		/* Task nicht starten */
		return FALSE;
	}	
	
	
	

/*******************************
 *	get_device
 *	verwendete Devices anzeigen
 *	in  -> : Task-Index / String
 *	out -> : 
 *******************************/
	
void get_device( int i , char *s )
	{
	char z[16];
	int tst,t = task[i].t_device;
	tst = 0x1;
	strcpy( z, "SPMDZIIIIIIIIIII" );
	strcpy( s, "                " );
	for( i=0; i<=15 ; i++ )
		{
		if ( tst & t )
			s[i] = z[i];
		tst<<=1;
		}
	}


/*******************************
 *	get_drive
 *	verwendete Drives anzeigen
 *	in  -> : Task-Index / String
 *	out -> : 
 *******************************/
 
void get_drive( int map , char *str)
	{
	int i,tst;
	char zw[18];
	tst = 0x1;
	strcpy( str, "                " );
	strcpy( zw , "ABCDEFGHIJKLMNOP");
	for( i=0; i<=15 ; i++ )
		{
		if ( tst & map )
			str[i] = zw[i];
		tst<<=1;
		}
	}
	

