/*******************************************************************
 * Modul	   : RPMT_MAI.C
 * Projekt	: RPMT
 * Aufgabe	: Demo des (R)alph's (P)seudo (M)ulti(T)asking
 *            RPMT
 *------------------------------------------------------------------
 * Autor	: Ralph Lanfermann
 * Datum	: 28. 4. 1993
 *------------------------------------------------------------------
 * Computer : Atari ST
 * Compiler	: Pure C Version Aug 29 1991
 * Optionen	: -----
 * Version	: 1.00
 *******************************************************************/

#include "rpmt_gem.h"
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <tos.h>
#include <string.h>
#include <stddef.h>
#include <ext.h>
#include "rpmt_rsc.h"
#include "rpmt_def.h"
#include "rpmt_pro.h"


/* Menleiste */
OBJECT *my_addr;

/* Message-Buffer */
int msg[16];

/* Struktur fr 11 Task definieren */
TASK task[12];
    

int main( void )
	{

	/* Applikation anmelden */
	init_gem(FALSE);
	
	/* RSC-Datei laden */
	rsrc_load("RPMT_RSC.RSC");

	/* Adresse Menleiste besorgen */
	rsrc_gaddr(R_TREE,MLEISTE,&my_addr);
	
	/* Menleiste darstellen */
	menu_bar(my_addr,1);
	
	/* Programm initialisieren */
	inits();
	
	/* Hauptschleife anspringen */
	haupt();
	
	/* Programm beenden, Menleiste entfernen */
	menu_bar(my_addr,0);	
	
	/* RSC- Freigeben */
	rsrc_free();
	
	/* Applikation abmelden */
	exit_gem();	
	
	/* Alles OK */
	return 0;	
	
	} /* Main Ende */


/* Hauptschleife des Programms */
void haupt(void)
	{
	int event;
	
	RLKINFO mk;
	 
	int verlassen = FALSE;
   
	do
		{
		event = multievent( msg , &mk , 100L );

      wind_update(BEG_UPDATE); /* friere Bildschirm ein.      */   
	
		if ( (event&MU_MESAG)&&(msg[0]==MN_SELECTED))
         verlassen = hdl_menu( msg[3],msg[4] );
         
		if (event & MU_TIMER )
			task_manager();

	   wind_update(END_UPDATE);
	   
      }while( verlassen == FALSE);
   
	}


/* erforderliche Initialisierungen vornehmen */
void inits( void )
	{
	/* 
	Speicher reservieren,
	Windowlibary anmelden u.s.w.
	*/
	
	/* Taskmanager anmelden */
	task_init();

	/* Einen Systemjob starten*/
	do_system();
	
	}/* inits */


/* Auf Menauswahl reagieren */
int hdl_menu( int titel, int item )
	{
	
	int flag=FALSE;
	
	/* 
		welcher Eintrag wurde
		auserkoren ?
	*/	
	switch ( item ) 
		{
		case ML_INFO :		do_info();
		break;
		case ML_FORMAT:	do_format();
		break;
		case ML_WORK:		do_work();
		break;
		case ML_TASKER:	do_tasker();
		break;
		case ML_ENDE: flag = TRUE;
		break;
		}/* switch */
		
	/* Menu normal darstellen */	
	menu_tnormal ( my_addr, titel, 1 );
	
	/* Abbruchflag zurckgeben */
	return (flag);
	
	}/* hdl_menu */		
	
	
/* Infobox anzeigen */	
void hdl_info( void )
	{
	}/* hdl_info */
	
